/// <reference path="./internals/internal_*.d.ts" />
declare class BlockPos extends Vec3i {
    constructor(arg0: Vec3i_)
    constructor(arg0: number, arg1: number, arg2: number)
    south(): this;
    mutable(): Internal.BlockPos$MutableBlockPos;
    getY(): number;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    static betweenClosed(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Iterable<BlockPos>;
    static getY(arg0: number): number;
    toShortString(): string;
    static betweenClosedStream(arg0: BlockPos_, arg1: BlockPos_): Internal.Stream<BlockPos>;
    notify(): void;
    static "betweenClosedStream(net.minecraft.world.level.levelgen.structure.BoundingBox)"(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    compareTo(arg0: any): number;
    multiply(arg0: number): this;
    relative(arg0: Internal.Direction_): Vec3i;
    static offset(arg0: number, arg1: number, arg2: number, arg3: number): number;
    asLong(): number;
    west(): this;
    static spiralAround(arg0: BlockPos_, arg1: number, arg2: Internal.Direction_, arg3: Internal.Direction_): Internal.Iterable<Internal.BlockPos$MutableBlockPos>;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    above(): Vec3i;
    below(arg0: number): this;
    "compareTo(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
    east(): Vec3i;
    static betweenClosedStream(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    static randomInCube(arg0: Internal.RandomSource_, arg1: number, arg2: BlockPos_, arg3: number): Internal.Iterable<BlockPos>;
    static breadthFirstTraversal(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.BiConsumer_<BlockPos, Internal.Consumer<BlockPos>>, arg4: Internal.Predicate_<BlockPos>): number;
    "relative(net.minecraft.core.Direction$Axis,int)"(arg0: Internal.Direction$Axis_, arg1: number): this;
    static betweenClosed(arg0: BlockPos_, arg1: BlockPos_): Internal.Iterable<BlockPos>;
    distSqr(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): Vec3i;
    static offset(arg0: number, arg1: Internal.Direction_): number;
    getCenter(): Vec3d;
    wait(): void;
    static containing(arg0: Internal.Position_): BlockPos;
    east(arg0: number): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    above(arg0: number): this;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    north(): Vec3i;
    getClass(): typeof any;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    south(arg0: number): Vec3i;
    static getX(arg0: number): number;
    static getZ(arg0: number): number;
    static findClosestMatch(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.Predicate_<BlockPos>): Optional<BlockPos>;
    atY(arg0: number): this;
    west(arg0: number): Vec3i;
    wait(arg0: number, arg1: number): void;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    rotate(arg0: Internal.Rotation_): this;
    static "betweenClosedStream(net.minecraft.world.phys.AABB)"(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    static betweenClosedStream(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Stream<BlockPos>;
    getZ(): number;
    static randomBetweenClosed(arg0: Internal.RandomSource_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): Internal.Iterable<BlockPos>;
    offset(arg0: number, arg1: number, arg2: number): Vec3i;
    static withinManhattanStream(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Stream<BlockPos>;
    immutable(): this;
    toString(): string;
    north(arg0: number): Vec3i;
    static asLong(arg0: number, arg1: number, arg2: number): number;
    below(): Vec3i;
    notifyAll(): void;
    distManhattan(arg0: Vec3i_): number;
    static getFlatIndex(arg0: number): number;
    static of(arg0: number): BlockPos;
    get(arg0: Internal.Direction$Axis_): number;
    offset(arg0: Vec3i_): Vec3i;
    cross(arg0: Vec3i_): Vec3i;
    /**
     * @deprecated
    */
    static squareOutSouthEast(arg0: BlockPos_): Internal.Stream<BlockPos>;
    static withinManhattan(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Iterable<BlockPos>;
    static containing(arg0: number, arg1: number, arg2: number): BlockPos;
    static betweenClosedStream(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    hashCode(): number;
    relative(arg0: Internal.Direction_, arg1: number): Vec3i;
    wait(arg0: number): void;
    relative(arg0: Internal.Direction$Axis_, arg1: number): this;
    compareTo(arg0: Vec3i_): number;
    equals(arg0: any): boolean;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    "relative(net.minecraft.core.Direction,int)"(arg0: Internal.Direction_, arg1: number): Vec3i;
    get y(): number
    get center(): Vec3d
    get class(): typeof any
    get x(): number
    get z(): number
    static readonly PACKED_Y_LENGTH: (12) & (number);
    static readonly CODEC: Internal.Codec<BlockPos>;
    static readonly ZERO: (BlockPos) & (BlockPos);
}
type BlockPos_ = Vec3d_ | [number, number, number] | BlockPos;
/**
 * Various block related helper functions
*/
declare class Block {
    constructor()
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static id(id: ResourceLocation_): Internal.BlockIDPredicate;
    static entity(id: ResourceLocation_): Internal.BlockEntityPredicate;
    /**
     * Gets a blocks id from the Block
    */
    static getId(block: Internal.Block_): ResourceLocation;
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    static getFacing(): Internal.Map<string, Internal.Direction>;
    notify(): void;
    static id(id: ResourceLocation_, properties: Internal.Map_<string, any>): Internal.BlockIDPredicate;
    wait(arg0: number, arg1: number): void;
    /**
     * Gets a list of all blocks with tags
    */
    static getTaggedIds(tag: ResourceLocation_): Internal.List<ResourceLocation>;
    hashCode(): number;
    /**
     * Gets a Block from a block id
    */
    static getBlock(id: ResourceLocation_): Internal.Block;
    wait(): void;
    wait(arg0: number): void;
    static custom(predicate: Internal.BlockPredicate_): Internal.BlockPredicate;
    /**
     * Gets a list of the classname of all registered blocks
    */
    static getTypeList(): Internal.List<string>;
    equals(arg0: any): boolean;
    get class(): typeof any
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    get facing(): Internal.Map<string, Internal.Direction>
    /**
     * Gets a list of the classname of all registered blocks
    */
    get typeList(): Internal.List<string>
}
type Block_ = Block;
declare class Vec3d implements Internal.Position {
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Vec3f_)
    lengthSqr(): number;
    distanceToSqr(arg0: Vec3d_): number;
    notify(): void;
    yRot(arg0: number): this;
    z(): number;
    xRot(arg0: number): this;
    x(): number;
    align(arg0: Internal.EnumSet_<Internal.Direction$Axis>): this;
    closerThan(arg0: Internal.Position_, arg1: number): boolean;
    static atLowerCornerWithOffset(arg0: Vec3i_, arg1: number, arg2: number, arg3: number): Vec3d;
    subtract(arg0: Vec3d_): this;
    static upFromBottomCenterOf(arg0: Vec3i_, arg1: number): Vec3d;
    reverse(): this;
    scale(arg0: number): this;
    wait(): void;
    length(): number;
    distanceToSqr(arg0: number, arg1: number, arg2: number): number;
    zRot(arg0: number): this;
    subtract(arg0: number, arg1: number, arg2: number): this;
    get(arg0: Internal.Direction$Axis_): number;
    lerp(arg0: Vec3d_, arg1: number): this;
    normalize(): this;
    horizontalDistance(): number;
    getClass(): typeof any;
    relative(arg0: Internal.Direction_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number): this;
    static directionFromRotation(arg0: Internal.Vec2_): Vec3d;
    cross(arg0: Vec3d_): this;
    static atCenterOf(arg0: Vec3i_): Vec3d;
    add(arg0: Vec3d_): this;
    wait(arg0: number, arg1: number): void;
    "with"(arg0: Internal.Direction$Axis_, arg1: number): this;
    static atBottomCenterOf(arg0: Vec3i_): Vec3d;
    horizontalDistanceSqr(): number;
    dot(arg0: Vec3d_): number;
    multiply(arg0: number, arg1: number, arg2: number): this;
    y(): number;
    vectorTo(arg0: Vec3d_): this;
    offsetRandom(arg0: Internal.RandomSource_, arg1: number): this;
    toString(): string;
    static atLowerCornerOf(arg0: Vec3i_): Vec3d;
    notifyAll(): void;
    static fromRGB24(arg0: number): Vec3d;
    distanceTo(arg0: Vec3d_): number;
    multiply(arg0: Vec3d_): this;
    hashCode(): number;
    toVector3f(): Vec3f;
    wait(arg0: number): void;
    static directionFromRotation(arg0: number, arg1: number): Vec3d;
    equals(arg0: any): boolean;
    get class(): typeof any
    readonly z: number;
    static readonly ZERO: (Vec3d) & (Vec3d);
    static readonly CODEC: Internal.Codec<Vec3d>;
    readonly x: number;
    readonly y: number;
}
type Vec3d_ = [number, number, number] | Vec3d;
declare class RotationAxis extends Internal.Enum<RotationAxis> {
    deg(f: number): Quaternionf;
    static valueOf<T extends Internal.Enum<T>>(arg0: T, arg1: string): T;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static valueOf(name: string): RotationAxis;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    name(): string;
    static values(): RotationAxis[];
    hashCode(): number;
    rad(f: number): Quaternionf;
    getDeclaringClass(): typeof RotationAxis;
    ordinal(): number;
    wait(): void;
    "compareTo(dev.latvian.mods.kubejs.util.RotationAxis)"(arg0: RotationAxis_): number;
    wait(arg0: number): void;
    compareTo(arg0: RotationAxis_): number;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    describeConstable(): Optional<Internal.Enum$EnumDesc<RotationAxis>>;
    get class(): typeof any
    get declaringClass(): typeof RotationAxis
    static readonly XN: (RotationAxis) & (RotationAxis);
    static readonly ZP: (RotationAxis) & (RotationAxis);
    static readonly YN: (RotationAxis) & (RotationAxis);
    static readonly XP: (RotationAxis) & (RotationAxis);
    static readonly YP: (RotationAxis) & (RotationAxis);
    static readonly ZN: (RotationAxis) & (RotationAxis);
    readonly vec: Vec3f;
}
type RotationAxis_ = "yp" | "xp" | "yn" | "xn" | "zp" | RotationAxis | "zn";
declare class ResourceLocation implements Internal.ResourceLocationAccess, Internal.SpecialEquality, Internal.Comparable<ResourceLocation> {
    constructor(arg0: string, arg1: string)
    constructor(arg0: string)
    static isValidNamespace(arg0: string): boolean;
    getClass(): typeof any;
    compareTo(arg0: ResourceLocation_): number;
    toLanguageKey(arg0: string): string;
    static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
    static validNamespaceChar(arg0: string): boolean;
    static read(arg0: string): Internal.DataResult<ResourceLocation>;
    toShortLanguageKey(): string;
    static isValidPath(arg0: string): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    setPath(arg0: string): void;
    static tryBuild(arg0: string, arg1: string): ResourceLocation;
    "withPath(java.lang.String)"(arg0: string): this;
    static isAllowedInResourceLocation(arg0: string): boolean;
    static tryParse(arg0: string): ResourceLocation;
    withPath(arg0: string): this;
    static validPathChar(arg0: string): boolean;
    toLanguageKey(arg0: string, arg1: string): string;
    toDebugFileName(): string;
    getPath(): string;
    getNamespace(): string;
    static of(arg0: string, arg1: string): ResourceLocation;
    compareNamespaced(arg0: ResourceLocation_): number;
    "compareTo(net.minecraft.resources.ResourceLocation)"(arg0: ResourceLocation_): number;
    toString(): string;
    withSuffix(arg0: string): this;
    notifyAll(): void;
    specialEquals(o: any, shallow: boolean): boolean;
    static read(arg0: Internal.StringReader_): ResourceLocation;
    toLanguageKey(): string;
    static isValidResourceLocation(arg0: string): boolean;
    "withPath(java.util.function.UnaryOperator)"(arg0: Internal.UnaryOperator_<string>): this;
    static "read(com.mojang.brigadier.StringReader)"(arg0: Internal.StringReader_): ResourceLocation;
    hashCode(): number;
    static "read(java.lang.String)"(arg0: string): Internal.DataResult<ResourceLocation>;
    setNamespace(arg0: string): void;
    wait(): void;
    withPath(arg0: Internal.UnaryOperator_<string>): this;
    wait(arg0: number): void;
    withPrefix(arg0: string): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    get class(): typeof any
    set path(arg0: string)
    get path(): string
    get namespace(): string
    set namespace(arg0: string)
    static readonly REALMS_NAMESPACE: ("realms") & (string);
    static readonly CODEC: Internal.Codec<ResourceLocation>;
    static readonly NAMESPACE_SEPARATOR: (":") & (string);
    static readonly DEFAULT_NAMESPACE: ("minecraft") & (string);
}
type ResourceLocation_ = string | ResourceLocation | Special.CustomStat;
declare class any {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
}
type any_ = any;
declare class MoreJS {
    constructor()
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    static weightedList(): Internal.WeightedList$Builder<any>;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static ofTradeFilter(arg0: any): Internal.TradeFilter;
    static ofWeightedList(arg0: any): com.almostreliable.morejs.util.WeightedList<any>;
    static range(arg0: any): Internal.IntRange;
    static findStructure(arg0: BlockPos_, arg1: Internal.ServerLevel_, arg2: string, arg3: number): BlockPos;
    hashCode(): number;
    static findBiome(arg0: BlockPos_, arg1: Internal.ServerLevel_, arg2: string, arg3: number): BlockPos;
    wait(): void;
    static ofTradeItem(arg0: any): TradeItem;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
}
type MoreJS_ = MoreJS;
declare class Optional <T> {
    getClass(): typeof any;
    ifPresent(arg0: Internal.Consumer_<T>): void;
    isEmpty(): boolean;
    flatMap<U>(arg0: Internal.Function_<T, Optional<U>>): Optional<U>;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    isPresent(): boolean;
    map<U>(arg0: Internal.Function_<T, U>): Optional<U>;
    orElseThrow<X extends Internal.Throwable>(arg0: Internal.Supplier_<X>): T;
    get(): T;
    static of<T>(arg0: T): Optional<T>;
    toString(): string;
    orElseThrow(): T;
    stream(): Internal.Stream<T>;
    notifyAll(): void;
    static empty<T>(): Optional<T>;
    orElseGet(arg0: Internal.Supplier_<T>): T;
    ifPresentOrElse(arg0: Internal.Consumer_<T>, arg1: Internal.Runnable_): void;
    filter(arg0: Internal.Predicate_<T>): this;
    static ofNullable<T>(arg0: T): Optional<T>;
    or(arg0: Internal.Supplier_<Optional<T>>): this;
    hashCode(): number;
    orElse(arg0: T): T;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get empty(): boolean
    get present(): boolean
}
type Optional_<T> = Optional<T>;
declare class VillagerUtils {
    constructor()
    static getVillagerTrades(arg0: Internal.VillagerProfession_, arg1: number): Internal.List<Internal.VillagerTrades$ItemListing>;
    getClass(): typeof any;
    static getWandererTrades(arg0: number): Internal.List<Internal.VillagerTrades$ItemListing>;
    static createStructureMapTrade(arg0: TradeItem_[], arg1: com.almostreliable.morejs.util.WeightedList_<any>): Internal.TreasureMapTrade;
    static createStewTrade(arg0: TradeItem_[], arg1: Internal.MobEffect_[], arg2: number): Internal.StewTrade;
    static getProfessions(): Internal.Collection<Internal.VillagerProfession>;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static createCustomTrade(arg0: Internal.TransformableTrade$Transformer_): Internal.CustomTrade;
    static isModdedTrade(arg0: Internal.VillagerTrades$ItemListing_): boolean;
    static createBiomeMapTrade(arg0: TradeItem_[], arg1: com.almostreliable.morejs.util.WeightedList_<any>): Internal.TreasureMapTrade;
    static setAbstractTrades(arg0: Internal.Map_<number, Internal.VillagerTrades$ItemListing[]>, arg1: number, arg2: Internal.List_<Internal.VillagerTrades$ItemListing>): void;
    static getRandomVillagerTrade(arg0: Internal.VillagerProfession_, arg1: number): Internal.VillagerTrades$ItemListing;
    static getRandomWandererTrade(arg0: number): Internal.VillagerTrades$ItemListing;
    static isVanillaTrade(arg0: Internal.VillagerTrades$ItemListing_): boolean;
    static getVillagerTrades(arg0: Internal.VillagerProfession_): Internal.List<Internal.VillagerTrades$ItemListing>;
    static createEnchantedItemTrade(arg0: TradeItem_[], arg1: Internal.Item_): Internal.EnchantedItemTrade;
    toString(): string;
    notifyAll(): void;
    static createCustomMapTrade(arg0: TradeItem_[], arg1: Internal.MapPosInfo$Provider_): Internal.TreasureMapTrade;
    static createSimpleTrade(arg0: TradeItem_[], arg1: TradeItem_): Internal.SimpleTrade;
    hashCode(): number;
    static getProfession(arg0: ResourceLocation_): Internal.VillagerProfession;
    wait(): void;
    static getRandomVillagerTrade(arg0: Internal.VillagerProfession_): Internal.VillagerTrades$ItemListing;
    wait(arg0: number): void;
    static isMoreJSTrade(arg0: Internal.VillagerTrades$ItemListing_): boolean;
    static getAbstractTrades(arg0: Internal.Map_<number, Internal.VillagerTrades$ItemListing[]>, arg1: number): Internal.List<Internal.VillagerTrades$ItemListing>;
    equals(arg0: any): boolean;
    static createPotionTrade(arg0: TradeItem_[]): Internal.PotionTrade;
    get class(): typeof any
    get professions(): Internal.Collection<Internal.VillagerProfession>
    static readonly VANILLA_TRADE_TYPES: Internal.Set<typeof Internal.VillagerTrades$ItemListing>;
    static readonly CACHED_PROFESSION_TRADES: ({}) & (Internal.Map<Internal.VillagerProfession, Internal.List<Internal.VillagerTrades$ItemListing>>);
}
type VillagerUtils_ = VillagerUtils;
declare class Stats {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly SWIM_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly FLY_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_SHULKER_BOX: (ResourceLocation) & (ResourceLocation);
    static readonly TOTAL_WORLD_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly TUNE_NOTEBLOCK: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_RESISTED: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_DROPPED: Internal.StatType<Internal.Item>;
    static readonly PLAYER_KILLS: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BREWINGSTAND: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_CAMPFIRE: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_DISPENSER: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_FURNACE: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_ENDERCHEST: (ResourceLocation) & (ResourceLocation);
    static readonly ANIMALS_BRED: (ResourceLocation) & (ResourceLocation);
    static readonly POT_FLOWER: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_STONECUTTER: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_PICKED_UP: Internal.StatType<Internal.Item>;
    static readonly FALL_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_ABSORBED: (ResourceLocation) & (ResourceLocation);
    static readonly FISH_CAUGHT: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_ANVIL: (ResourceLocation) & (ResourceLocation);
    static readonly BOAT_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_RECORD: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT_RESISTED: (ResourceLocation) & (ResourceLocation);
    static readonly RAID_WIN: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT: (ResourceLocation) & (ResourceLocation);
    static readonly DEATHS: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_SMOKER: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_USED: Internal.StatType<Internal.Item>;
    static readonly BELL_RING: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_SMITHING_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_DROPPER: (ResourceLocation) & (ResourceLocation);
    static readonly DROP: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_LECTERN: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly WALK_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly CLIMB_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly TRADED_WITH_VILLAGER: (ResourceLocation) & (ResourceLocation);
    static readonly RAID_TRIGGER: (ResourceLocation) & (ResourceLocation);
    static readonly STRIDER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_BROKEN: Internal.StatType<Internal.Item>;
    static readonly BLOCK_MINED: Internal.StatType<Internal.Block>;
    static readonly TIME_SINCE_REST: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BEACON: (ResourceLocation) & (ResourceLocation);
    static readonly INSPECT_HOPPER: (ResourceLocation) & (ResourceLocation);
    static readonly PLAY_NOTEBLOCK: (ResourceLocation) & (ResourceLocation);
    static readonly CUSTOM: Internal.StatType<ResourceLocation>;
    static readonly CROUCH_TIME: (ResourceLocation) & (ResourceLocation);
    static readonly JUMP: (ResourceLocation) & (ResourceLocation);
    static readonly ENTITY_KILLED: Internal.StatType<Internal.EntityType<any>>;
    static readonly ENTITY_KILLED_BY: Internal.StatType<Internal.EntityType<any>>;
    static readonly INTERACT_WITH_CARTOGRAPHY_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly MOB_KILLS: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_CHEST: (ResourceLocation) & (ResourceLocation);
    static readonly SLEEP_IN_BED: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_ARMOR: (ResourceLocation) & (ResourceLocation);
    static readonly CROUCH_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly TALKED_TO_VILLAGER: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_DEALT_ABSORBED: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_LOOM: (ResourceLocation) & (ResourceLocation);
    static readonly LEAVE_GAME: (ResourceLocation) & (ResourceLocation);
    static readonly HORSE_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly WALK_ON_WATER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly MINECART_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly ENCHANT_ITEM: (ResourceLocation) & (ResourceLocation);
    static readonly TIME_SINCE_DEATH: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_TAKEN: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_BLAST_FURNACE: (ResourceLocation) & (ResourceLocation);
    static readonly TRIGGER_TRAPPED_CHEST: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_GRINDSTONE: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_BARREL: (ResourceLocation) & (ResourceLocation);
    static readonly SPRINT_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly DAMAGE_BLOCKED_BY_SHIELD: (ResourceLocation) & (ResourceLocation);
    static readonly EAT_CAKE_SLICE: (ResourceLocation) & (ResourceLocation);
    static readonly INTERACT_WITH_CRAFTING_TABLE: (ResourceLocation) & (ResourceLocation);
    static readonly CLEAN_BANNER: (ResourceLocation) & (ResourceLocation);
    static readonly TARGET_HIT: (ResourceLocation) & (ResourceLocation);
    static readonly ITEM_CRAFTED: Internal.StatType<Internal.Item>;
    static readonly WALK_UNDER_WATER_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly PIG_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly OPEN_SHULKER_BOX: (ResourceLocation) & (ResourceLocation);
    static readonly USE_CAULDRON: (ResourceLocation) & (ResourceLocation);
    static readonly AVIATE_ONE_CM: (ResourceLocation) & (ResourceLocation);
    static readonly FILL_CAULDRON: (ResourceLocation) & (ResourceLocation);
}
type Stats_ = Stats;
declare class TradeItem {
    constructor(arg0: Internal.ItemStack_, arg1: Internal.IntRange_)
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    createItemStack(arg0: Internal.RandomSource_): Internal.ItemStack;
    static of(arg0: Internal.ItemStack_, arg1: number, arg2: number, arg3: Internal.CompoundTag_): TradeItem;
    isEmpty(): boolean;
    static of(arg0: Internal.ItemStack_, arg1: number, arg2: number): TradeItem;
    static "of(net.minecraft.world.item.ItemStack,int,net.minecraft.nbt.CompoundTag)"(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.CompoundTag_): TradeItem;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static of(arg0: Internal.ItemStack_, arg1: number): TradeItem;
    hashCode(): number;
    static of(arg0: Internal.ItemStack_): TradeItem;
    static of(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.CompoundTag_): TradeItem;
    wait(): void;
    static "of(net.minecraft.world.item.ItemStack,int,int)"(arg0: Internal.ItemStack_, arg1: number, arg2: number): TradeItem;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get empty(): boolean
    static readonly EMPTY: (TradeItem) & (TradeItem);
}
type TradeItem_ = TradeItem;
declare class Fluid {
    constructor()
    static of(o: Internal.FluidStackJS_): Internal.FluidStackJS;
    getClass(): typeof any;
    static getEmpty(): Internal.FluidStackJS;
    static getType(id: ResourceLocation_): Internal.Fluid;
    static of(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    toString(): string;
    static of(o: Internal.FluidStackJS_, amount: number, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static "of(dev.latvian.mods.kubejs.fluid.FluidStackJS,net.minecraft.nbt.CompoundTag)"(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    notifyAll(): void;
    static of(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    static lava(amount: number): Internal.FluidStackJS;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static lava(): Internal.FluidStackJS;
    static getTypes(): Internal.List<string>;
    static "of(dev.latvian.mods.kubejs.fluid.FluidStackJS,int)"(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    wait(): void;
    static getId(fluid: Internal.Fluid_): ResourceLocation;
    wait(arg0: number): void;
    static water(amount: number): Internal.FluidStackJS;
    static exists(id: ResourceLocation_): boolean;
    equals(arg0: any): boolean;
    static water(): Internal.FluidStackJS;
    get class(): typeof any
    get empty(): Internal.FluidStackJS
    get types(): Internal.List<string>
    static readonly LAVA_ID: (ResourceLocation) & (ResourceLocation);
    static readonly WATER_ID: (ResourceLocation) & (ResourceLocation);
}
type Fluid_ = Fluid;
declare class InputItem implements Internal.InputReplacement, Internal.IngredientSupplierKJS, Internal.JsonSerializable {
    replaceInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.InputReplacement_): any;
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    isEmpty(): boolean;
    notify(): void;
    toJson(): Internal.JsonElement;
    withCount(count: number): this;
    wait(arg0: number, arg1: number): void;
    static of(o: InputItem_): InputItem;
    static of(ingredient: Internal.Ingredient_, count: number): InputItem;
    toJson(alwaysNest: boolean): Internal.JsonElement;
    validForMatching(): boolean;
    hashCode(): number;
    unwrap(): Internal.List<InputItem>;
    wait(): void;
    wait(arg0: number): void;
    transform(transformer: Internal.InputReplacementTransformer_): Internal.InputReplacementTransformer$Replacement;
    equals(arg0: any): boolean;
    kjs$asIngredient(): Internal.Ingredient;
    get class(): typeof any
    get empty(): boolean
    readonly ingredient: Internal.Ingredient;
    readonly count: number;
    static readonly EMPTY: (InputItem) & (InputItem);
    static readonly PARSE_CACHE: ({}) & (Internal.Map<string, InputItem>);
}
type InputItem_ = Internal.Ingredient_ | InputItem;
declare interface Color {
    of(o: any): Internal.Color;
    rgba(r: number, g: number, b: number, a: number): Internal.Color;
    createMapped(o: any, ...names: string[]): Internal.Color;
    readonly DARK_PURPLE: (Internal.ChatFormatting) & (Internal.Color);
    readonly YELLOW: (Internal.ChatFormatting) & (Internal.Color);
    readonly CYAN_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly GRAY: (Internal.ChatFormatting) & (Internal.Color);
    readonly BROWN_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly LIGHT_PURPLE: (Internal.ChatFormatting) & (Internal.Color);
    readonly PURPLE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly DARK_AQUA: (Internal.ChatFormatting) & (Internal.Color);
    readonly GREEN: (Internal.ChatFormatting) & (Internal.Color);
    readonly LIGHT_GRAY_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly WHITE: (Internal.ChatFormatting) & (Internal.Color);
    readonly MAGENTA_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly RED: (Internal.ChatFormatting) & (Internal.Color);
    readonly BLACK_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly TEXT: ({"dark_red": Internal.ChatFormatting, "green": Internal.ChatFormatting, "underline": Internal.ChatFormatting, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "bold": Internal.ChatFormatting, "italic": Internal.ChatFormatting, "dark_blue": Internal.ChatFormatting, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "red": Internal.ChatFormatting, "aqua": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "blue": Internal.ChatFormatting, "white": Internal.ChatFormatting, "dark_aqua": Internal.ChatFormatting, "dark_gray": Internal.ChatFormatting, "reset": Internal.ChatFormatting, "strikethrough": Internal.ChatFormatting, "obfuscated": Internal.ChatFormatting}) & (Internal.Map<string, Internal.ChatFormatting>);
    readonly RED_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly GRAY_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly DARK_GRAY: (Internal.ChatFormatting) & (Internal.Color);
    readonly NONE: (Internal.NoColor) & (Internal.Color);
    readonly ORANGE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly WHITE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly DYE: ({"magenta": Internal.DyeColor, "pink": Internal.DyeColor, "green": Internal.DyeColor, "lime": Internal.DyeColor, "light_gray": Internal.DyeColor, "yellow": Internal.DyeColor, "black": Internal.DyeColor, "light_blue": Internal.DyeColor, "brown": Internal.DyeColor, "cyan": Internal.DyeColor, "orange": Internal.DyeColor, "red": Internal.DyeColor, "gray": Internal.DyeColor, "white": Internal.DyeColor, "blue": Internal.DyeColor, "purple": Internal.DyeColor}) & (Internal.Map<string, Internal.DyeColor>);
    readonly BLACK: (Internal.ChatFormatting) & (Internal.Color);
    readonly BLUE: (Internal.ChatFormatting) & (Internal.Color);
    readonly DARK_GREEN: (Internal.ChatFormatting) & (Internal.Color);
    readonly DARK_RED: (Internal.ChatFormatting) & (Internal.Color);
    readonly GOLD: (Internal.ChatFormatting) & (Internal.Color);
    readonly MAP: ({"": Internal.NoColor, "light_blue_dye": Internal.DyeColor, "BLUE_DYE": Internal.DyeColor, "purple_dye": Internal.DyeColor, "dark_red": Internal.ChatFormatting, "lightGrayDye": Internal.DyeColor, "DARK_AQUA": Internal.ChatFormatting, "none": Internal.NoColor, "green_dye": Internal.DyeColor, "blackDye": Internal.DyeColor, "dark_blue": Internal.ChatFormatting, "red": Internal.ChatFormatting, "pink_dye": Internal.DyeColor, "aqua": Internal.ChatFormatting, "white": Internal.ChatFormatting, "WHITE_DYE": Internal.DyeColor, "dark_gray": Internal.ChatFormatting, "LIGHT_PURPLE": Internal.ChatFormatting, "BROWN_DYE": Internal.DyeColor, "BLACK": Internal.ChatFormatting, "darkPurple": Internal.ChatFormatting, "NONE": Internal.NoColor, "LIGHT_BLUE_DYE": Internal.DyeColor, "AQUA": Internal.ChatFormatting, "lightBlueDye": Internal.DyeColor, "limeDye": Internal.DyeColor, "PURPLE_DYE": Internal.DyeColor, "GREEN_DYE": Internal.DyeColor, "magenta_dye": Internal.DyeColor, "-": Internal.NoColor, "lime_dye": Internal.DyeColor, "yellowDye": Internal.DyeColor, "grayDye": Internal.DyeColor, "purpleDye": Internal.DyeColor, "DARK_PURPLE": Internal.ChatFormatting, "ORANGE_DYE": Internal.DyeColor, "darkGray": Internal.ChatFormatting, "brownDye": Internal.DyeColor, "YELLOW": Internal.ChatFormatting, "LIME_DYE": Internal.DyeColor, "blueDye": Internal.DyeColor, "white_dye": Internal.DyeColor, "pinkDye": Internal.DyeColor, "blue_dye": Internal.DyeColor, "cyanDye": Internal.DyeColor, "GOLD": Internal.ChatFormatting, "GRAY": Internal.ChatFormatting, "MAGENTA_DYE": Internal.DyeColor, "BLUE": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "darkBlue": Internal.ChatFormatting, "transparent": Internal.NoColor, "orange_dye": Internal.DyeColor, "red_dye": Internal.DyeColor, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "darkRed": Internal.ChatFormatting, "greenDye": Internal.DyeColor, "DARK_RED": Internal.ChatFormatting, "redDye": Internal.DyeColor, "GRAY_DYE": Internal.DyeColor, "orangeDye": Internal.DyeColor, "yellow_dye": Internal.DyeColor, "black_dye": Internal.DyeColor, "magentaDye": Internal.DyeColor, "WHITE": Internal.ChatFormatting, "green": Internal.ChatFormatting, "LIGHT_GRAY_DYE": Internal.DyeColor, "BLACK_DYE": Internal.DyeColor, "darkGreen": Internal.ChatFormatting, "RED_DYE": Internal.DyeColor, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "lightPurple": Internal.ChatFormatting, "PINK_DYE": Internal.DyeColor, "DARK_BLUE": Internal.ChatFormatting, "GREEN": Internal.ChatFormatting, "darkAqua": Internal.ChatFormatting, "gray_dye": Internal.DyeColor, "CYAN_DYE": Internal.DyeColor, "RED": Internal.ChatFormatting, "brown_dye": Internal.DyeColor, "cyan_dye": Internal.DyeColor, "blue": Internal.ChatFormatting, "whiteDye": Internal.DyeColor, "dark_aqua": Internal.ChatFormatting, "YELLOW_DYE": Internal.DyeColor, "DARK_GREEN": Internal.ChatFormatting, "DARK_GRAY": Internal.ChatFormatting}) & (Internal.Map<string, Internal.Color>);
    readonly GREEN_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly LIGHT_BLUE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly AQUA: (Internal.ChatFormatting) & (Internal.Color);
    readonly DARK_BLUE: (Internal.ChatFormatting) & (Internal.Color);
    readonly PINK_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly BLUE_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly YELLOW_DYE: (Internal.DyeColor) & (Internal.Color);
    readonly LIME_DYE: (Internal.DyeColor) & (Internal.Color);
}
type Color_ = Color;
declare const Color: Color;
declare class JsonIO {
    constructor()
    getClass(): typeof any;
    static readJson(path: Internal.Path_): Internal.JsonElement;
    static toPrettyString(json: Internal.JsonElement_): string;
    static getJsonHashString(json: Internal.JsonElement_): string;
    notify(): void;
    static toObject(json: Internal.JsonElement_): any;
    wait(arg0: number, arg1: number): void;
    static primitiveOf(o: any): Internal.JsonPrimitive;
    static readString(path: Internal.Path_): string;
    static writeJsonHash(stream: Internal.DataOutputStream_, element: Internal.JsonElement_): void;
    static parseRaw(string: string): Internal.JsonElement;
    static write(path: Internal.Path_, json: Internal.JsonObject_): void;
    static read(path: Internal.Path_): Internal.Map<any, any>;
    toString(): string;
    notifyAll(): void;
    static toArray(element: Internal.JsonElement_): Internal.JsonArray;
    static parse(string: string): any;
    static toPrimitive(element: Internal.JsonElement_): any;
    hashCode(): number;
    static copy(element: Internal.JsonElement_): Internal.JsonElement;
    wait(): void;
    wait(arg0: number): void;
    static toString(json: Internal.JsonElement_): string;
    static getJsonHashBytes(json: Internal.JsonElement_): number[];
    equals(arg0: any): boolean;
    static of(o: any): Internal.JsonElement;
    get class(): typeof any
}
type JsonIO_ = JsonIO;
/**
 * Various item related helper methods
*/
declare interface Item {
    /**
     * Returns an ItemStack of the input
    */
    of(in_: Internal.ItemStack_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count and NBT data
    */
    of(in_: Internal.ItemStack_, count: number, nbt: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    of(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    withNBT(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.ItemStack;
    getTypeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>;
    playerHeadFromSkinHash(hash: string): Internal.ItemStack;
    /**
     * Get the item that represents air/an empty slot
    */
    getEmpty(): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    "of(net.minecraft.world.item.ItemStack,int)"(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Gets an Item from an item id
    */
    getItem(id: ResourceLocation_): Internal.Item;
    getVariants(item: Internal.ItemStack_): Internal.Collection<Internal.ItemStack>;
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    getList(): Internal.List<Internal.ItemStack>;
    /**
     * Returns a Firework with the input properties
    */
    fireworks(properties: Internal.Map_<string, any>): Internal.FireworksJS;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    "of(net.minecraft.world.item.ItemStack,net.minecraft.nbt.CompoundTag)"(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    playerHead(name: string): Internal.ItemStack;
    playerHeadFromUrl(url: string): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    of(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Get a list of all the item ids in the game
    */
    getTypeList(): Internal.List<string>;
    /**
     * Checks if the provided item id exists in the registry
    */
    exists(id: ResourceLocation_): boolean;
    playerHead(uuid: Internal.UUID_, textureBase64: string): Internal.ItemStack;
    /**
     * Checks if the passed in object is an ItemStack.
     * Note that this does not mean it will not function as an ItemStack if passed to something that requests one.
    */
    isItem(o: any): boolean;
    /**
     * Gets an items id from the Item
    */
    getId(item: Internal.Item_): ResourceLocation;
    get typeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>
    /**
     * Get the item that represents air/an empty slot
    */
    get empty(): Internal.ItemStack
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    get list(): Internal.List<Internal.ItemStack>
    /**
     * Get a list of all the item ids in the game
    */
    get typeList(): Internal.List<string>
    readonly KJS_ARMOR_MODIFIER_UUID_PER_SLOT: Internal.UUID[];
    readonly KJS_BASE_ATTACK_SPEED_UUID: (Internal.UUID) & (Internal.UUID);
    readonly KJS_BASE_ATTACK_DAMAGE_UUID: (Internal.UUID) & (Internal.UUID);
}
type Item_ = Item;
declare const Item: Item;
declare abstract class number implements Internal.Serializable {
    constructor()
    abstract longValue(): number;
    getClass(): typeof any;
    abstract doubleValue(): number;
    toString(): string;
    abstract floatValue(): number;
    notifyAll(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    shortValue(): number;
    hashCode(): number;
    abstract intValue(): number;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    byteValue(): number;
    get class(): typeof any
}
type number_ = number;
declare class Collectors {
    static mapping<T, U, A, R>(arg0: Internal.Function_<T, U>, arg1: Internal.Collector_<U, A, R>): Internal.Collector<T, any, R>;
    static toUnmodifiableSet<T>(): Internal.Collector<T, any, Internal.Set<T>>;
    static toConcurrentMap<T, K, U>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>): Internal.Collector<T, any, Internal.ConcurrentMap<K, U>>;
    static toCollection<T, C extends Internal.Collection<T>>(arg0: Internal.Supplier_<C>): Internal.Collector<T, any, C>;
    static filtering<T, A, R>(arg0: Internal.Predicate_<T>, arg1: Internal.Collector_<T, A, R>): Internal.Collector<T, any, R>;
    notify(): void;
    static toList<T>(): Internal.Collector<T, any, Internal.List<T>>;
    static groupingBy<T, K>(arg0: Internal.Function_<T, K>): Internal.Collector<T, any, Internal.Map<K, Internal.List<T>>>;
    static summarizingDouble<T>(arg0: Internal.ToDoubleFunction_<T>): Internal.Collector<T, any, Internal.DoubleSummaryStatistics>;
    static summingDouble<T>(arg0: Internal.ToDoubleFunction_<T>): Internal.Collector<T, any, number>;
    static reducing<T, U>(arg0: U, arg1: Internal.Function_<T, U>, arg2: Internal.BinaryOperator_<U>): Internal.Collector<T, any, U>;
    static partitioningBy<T>(arg0: Internal.Predicate_<T>): Internal.Collector<T, any, Internal.Map<boolean, Internal.List<T>>>;
    static teeing<T, R1, R2, R>(arg0: Internal.Collector_<T, any, R1>, arg1: Internal.Collector_<T, any, R2>, arg2: Internal.BiFunction_<R1, R2, R>): Internal.Collector<T, any, R>;
    static partitioningBy<T, D, A>(arg0: Internal.Predicate_<T>, arg1: Internal.Collector_<T, A, D>): Internal.Collector<T, any, Internal.Map<boolean, D>>;
    static toUnmodifiableList<T>(): Internal.Collector<T, any, Internal.List<T>>;
    static reducing<T>(arg0: T, arg1: Internal.BinaryOperator_<T>): Internal.Collector<T, any, T>;
    static flatMapping<T, U, A, R>(arg0: Internal.Function_<T, Internal.Stream<U>>, arg1: Internal.Collector_<U, A, R>): Internal.Collector<T, any, R>;
    static minBy<T>(arg0: Comparator_<T>): Internal.Collector<T, any, Optional<T>>;
    static toUnmodifiableMap<T, K, U>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>, arg2: Internal.BinaryOperator_<U>): Internal.Collector<T, any, Internal.Map<K, U>>;
    static joining(): Internal.Collector<Internal.CharSequence, any, string>;
    static groupingByConcurrent<T, K>(arg0: Internal.Function_<T, K>): Internal.Collector<T, any, Internal.ConcurrentMap<K, Internal.List<T>>>;
    static reducing<T>(arg0: Internal.BinaryOperator_<T>): Internal.Collector<T, any, Optional<T>>;
    static toMap<T, K, U, M extends Internal.Map<K, U>>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>, arg2: Internal.BinaryOperator_<U>, arg3: Internal.Supplier_<M>): Internal.Collector<T, any, M>;
    static maxBy<T>(arg0: Comparator_<T>): Internal.Collector<T, any, Optional<T>>;
    wait(): void;
    static averagingInt<T>(arg0: Internal.ToIntFunction_<T>): Internal.Collector<T, any, number>;
    static summingInt<T>(arg0: Internal.ToIntFunction_<T>): Internal.Collector<T, any, number>;
    static averagingDouble<T>(arg0: Internal.ToDoubleFunction_<T>): Internal.Collector<T, any, number>;
    static joining(arg0: Internal.CharSequence_, arg1: Internal.CharSequence_, arg2: Internal.CharSequence_): Internal.Collector<Internal.CharSequence, any, string>;
    static summarizingLong<T>(arg0: Internal.ToLongFunction_<T>): Internal.Collector<T, any, Internal.LongSummaryStatistics>;
    getClass(): typeof any;
    static groupingByConcurrent<T, K, A, D, M extends Internal.ConcurrentMap<K, D>>(arg0: Internal.Function_<T, K>, arg1: Internal.Supplier_<M>, arg2: Internal.Collector_<T, A, D>): Internal.Collector<T, any, M>;
    static toMap<T, K, U>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>, arg2: Internal.BinaryOperator_<U>): Internal.Collector<T, any, Internal.Map<K, U>>;
    wait(arg0: number, arg1: number): void;
    static groupingBy<T, K, D, A, M extends Internal.Map<K, D>>(arg0: Internal.Function_<T, K>, arg1: Internal.Supplier_<M>, arg2: Internal.Collector_<T, A, D>): Internal.Collector<T, any, M>;
    static summingLong<T>(arg0: Internal.ToLongFunction_<T>): Internal.Collector<T, any, number>;
    static groupingByConcurrent<T, K, A, D>(arg0: Internal.Function_<T, K>, arg1: Internal.Collector_<T, A, D>): Internal.Collector<T, any, Internal.ConcurrentMap<K, D>>;
    static joining(arg0: Internal.CharSequence_): Internal.Collector<Internal.CharSequence, any, string>;
    static toMap<T, K, U>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>): Internal.Collector<T, any, Internal.Map<K, U>>;
    toString(): string;
    static averagingLong<T>(arg0: Internal.ToLongFunction_<T>): Internal.Collector<T, any, number>;
    notifyAll(): void;
    static toConcurrentMap<T, K, U, M extends Internal.ConcurrentMap<K, U>>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>, arg2: Internal.BinaryOperator_<U>, arg3: Internal.Supplier_<M>): Internal.Collector<T, any, M>;
    static counting<T>(): Internal.Collector<T, any, number>;
    static collectingAndThen<T, A, R, RR>(arg0: Internal.Collector_<T, A, R>, arg1: Internal.Function_<R, RR>): Internal.Collector<T, A, RR>;
    hashCode(): number;
    static summarizingInt<T>(arg0: Internal.ToIntFunction_<T>): Internal.Collector<T, any, Internal.IntSummaryStatistics>;
    wait(arg0: number): void;
    static toUnmodifiableMap<T, K, U>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>): Internal.Collector<T, any, Internal.Map<K, U>>;
    static toConcurrentMap<T, K, U>(arg0: Internal.Function_<T, K>, arg1: Internal.Function_<T, U>, arg2: Internal.BinaryOperator_<U>): Internal.Collector<T, any, Internal.ConcurrentMap<K, U>>;
    equals(arg0: any): boolean;
    static toSet<T>(): Internal.Collector<T, any, Internal.Set<T>>;
    static groupingBy<T, K, A, D>(arg0: Internal.Function_<T, K>, arg1: Internal.Collector_<T, A, D>): Internal.Collector<T, any, Internal.Map<K, D>>;
    get class(): typeof any
}
type Collectors_ = Collectors;
declare class Notification {
    constructor()
    constructor(buf: Internal.FriendlyByteBuf_)
    getClass(): typeof any;
    write(buf: Internal.FriendlyByteBuf_): void;
    toString(): string;
    static make(consumer: Internal.Consumer_<Notification>): Notification;
    notifyAll(): void;
    static of(cx: Internal.Context_, object: any): Notification;
    setIcon(icon: string): void;
    show(): void;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    setAtlasIcon(icon: string): void;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    setItemIcon(stack: Internal.ItemStack_): void;
    get class(): typeof any
    set icon(icon: string)
    set atlasIcon(icon: string)
    set itemIcon(stack: Internal.ItemStack_)
    duration: Duration;
    static readonly DEFAULT_DURATION: (Duration) & (Duration);
    backgroundColor: Internal.Color;
    iconSize: number;
    static readonly DEFAULT_BACKGROUND_COLOR: (Internal.SimpleColor) & (Internal.Color);
    static readonly DEFAULT_BORDER_COLOR: (Internal.SimpleColor) & (Internal.Color);
    borderColor: Internal.Color;
    text: Internal.Component;
    outlineColor: Internal.Color;
    textShadow: boolean;
    static readonly NO_TEXT: Internal.Component[];
}
type Notification_ = Notification;
declare interface Facing {
    readonly south: (Internal.Direction) & (Internal.Direction);
    readonly up: (Internal.Direction) & (Internal.Direction);
    readonly UP: (Internal.Direction) & (Internal.Direction);
    readonly NORTH: (Internal.Direction) & (Internal.Direction);
    readonly east: (Internal.Direction) & (Internal.Direction);
    readonly DOWN: (Internal.Direction) & (Internal.Direction);
    readonly EAST: (Internal.Direction) & (Internal.Direction);
    readonly west: (Internal.Direction) & (Internal.Direction);
    readonly north: (Internal.Direction) & (Internal.Direction);
    readonly down: (Internal.Direction) & (Internal.Direction);
    readonly ALL: ({"east": Internal.Direction, "south": Internal.Direction, "north": Internal.Direction, "west": Internal.Direction, "up": Internal.Direction, "down": Internal.Direction}) & (Internal.Map<string, Internal.Direction>);
    readonly WEST: (Internal.Direction) & (Internal.Direction);
    readonly SOUTH: (Internal.Direction) & (Internal.Direction);
}
type Facing_ = Facing;
declare const Facing: Facing;
declare class Quaternionf implements Internal.Cloneable, Internal.Externalizable, Internal.Quaternionfc {
    constructor()
    constructor(arg0: Internal.AxisAngle4d_)
    constructor(arg0: Internal.Quaternionfc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.AxisAngle4f_)
    constructor(arg0: Internal.Quaterniondc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    "transform(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    slerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transformInverse(arg0: Internal.Vector4d_): Internal.Vector4d;
    invert(): this;
    transformPositiveY(arg0: Vec3f_): Vec3f;
    transformPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    mul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    "getAsMatrix3f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformInverse(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    setFromUnnormalized(arg0: Internal.Matrix3fc_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    conjugate(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    fromAxisAngleDeg(arg0: Internal.Vector3fc_, arg1: number): this;
    "transformUnitPositiveZ(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    premul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotationZ(arg0: number): this;
    transformInverse(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveY(arg0: Vec4f_): Vec4f;
    transformPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    transformUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    premul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    "transformUnitPositiveY(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    invert(arg0: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "get(org.joml.Quaternionf)"(arg0: Quaternionf_): this;
    transform(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverse(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transform(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    positiveZ(arg0: Vec3f_): Vec3f;
    difference(arg0: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    setFromNormalized(arg0: Internal.Matrix3dc_): this;
    normalize(): this;
    getClass(): typeof any;
    transformPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZ(arg0: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformUnit(arg0: Vec4f_): Vec4f;
    transformPositiveZ(arg0: Vec3f_): Vec3f;
    "setAngleAxis(double,double,double,double)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    scale(arg0: number, arg1: Quaternionf_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    "transformInverse(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    mul(arg0: number): this;
    "transformUnitPositiveX(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    static slerp(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    "transformPositiveY(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    get(arg0: Matrix4f_): Matrix4f;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transform(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4fc_): this;
    "setFromNormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    getAsMatrix3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(org.joml.Matrix4x3f)"(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    "transformInverseUnit(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    normalize(arg0: Quaternionf_): this;
    rotationAxis(arg0: Internal.AxisAngle4f_): this;
    transformInverseUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mul(arg0: number, arg1: Quaternionf_): this;
    "transformPositiveZ(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformUnit(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    w(): number;
    transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    transformPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformInverse(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    transformPositiveZ(arg0: Vec4f_): Vec4f;
    conjugateBy(arg0: Internal.Quaternionfc_): this;
    "transformInverse(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverse(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    get(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    transform(arg0: Vec3f_): Vec3f;
    "get(org.joml.Matrix3d)"(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    wait(arg0: number): void;
    "nlerp(org.joml.Quaternionfc,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    slerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    fromAxisAngleRad(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    "get(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "transformUnit(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocalY(arg0: number, arg1: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveY(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    isFinite(): boolean;
    setFromUnnormalized(arg0: Internal.Matrix3dc_): this;
    "nlerpIterative(org.joml.Quaternionfc,float,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformUnitPositiveX(arg0: Vec3f_): Vec3f;
    rotateLocalX(arg0: number): this;
    get(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    x(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transform(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: Vec3f_): Vec3f;
    transformPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveX(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "transform(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transform(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "setFromUnnormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    transformInverseUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "mul(float,org.joml.Quaternionf)"(arg0: number, arg1: Quaternionf_): this;
    "transformUnitPositiveZ(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformInverseUnit(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    fromAxisAngleRad(arg0: Internal.Vector3fc_, arg1: number): this;
    setFromUnnormalized(arg0: Internal.Matrix4fc_): this;
    wait(): void;
    setFromNormalized(arg0: Internal.Matrix3fc_): this;
    premul(arg0: Internal.Quaternionfc_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    "transformPositiveX(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    get(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    "getAsMatrix4f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformUnit(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformInverse(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    static "nlerpIterative(org.joml.Quaternionf[],float[],float,org.joml.Quaternionf)"(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    transformInverse(arg0: Vec4f_): Vec4f;
    getEulerAnglesZXY(arg0: Vec3f_): Vec3f;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "get(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    add(arg0: Internal.Quaternionfc_): this;
    rotateLocalZ(arg0: number, arg1: Quaternionf_): this;
    getAsMatrix4f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "transformUnit(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    add(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    dot(arg0: Quaternionf_): number;
    "getAsMatrix4f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "transformUnitPositiveY(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    static "nlerp(org.joml.Quaternionfc[],float[],org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    rotateLocalY(arg0: number): this;
    "transformInverse(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    y(): number;
    transformInverse(arg0: Vec3f_): Vec3f;
    "setFromNormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_): this;
    "transformUnitPositiveX(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setFromNormalized(arg0: Internal.Matrix4x3fc_): this;
    "get(org.joml.Matrix4d)"(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    static nlerp(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    getAsMatrix4x3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3dc_): this;
    "transformInverse(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveZ(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "mul(float)"(arg0: number): this;
    conjugate(): this;
    transformInverse(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    equals(arg0: any): boolean;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    "transformInverseUnit(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transformInverseUnit(float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "setFromNormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    "transformInverse(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    "transform(org.joml.Vector4dc,org.joml.Vector4d)"(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    fromAxisAngleDeg(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "setFromUnnormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "getAsMatrix4x3f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformUnitPositiveZ(arg0: Vec3f_): Vec3f;
    "setFromNormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    transformUnitPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transform(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformUnitPositiveZ(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    z(): number;
    "transformUnitPositiveY(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotationAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    "setAngleAxis(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    "get(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    getAsMatrix3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    toString(arg0: Internal.NumberFormat_): string;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformInverseUnit(arg0: Vec3f_): Vec3f;
    lengthSquared(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    getEulerAnglesYXZ(arg0: Vec3f_): Vec3f;
    setFromUnnormalized(arg0: Internal.Matrix4dc_): this;
    get(arg0: Quaternionf_): this;
    rotateX(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveY(arg0: Vec4f_): Vec4f;
    identity(): this;
    "transformInverseUnit(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    clone(): any;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    "mul(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "setFromUnnormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "transformUnitPositiveX(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateLocalX(arg0: number, arg1: Quaternionf_): this;
    "transformPositiveY(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    static "slerp(org.joml.Quaternionf[],float[],org.joml.Quaternionf)"(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Vec4f_): Vec4f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    setFromNormalized(arg0: Internal.Matrix4x3dc_): this;
    "get(org.joml.Matrix4x3d)"(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    transformInverseUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverseUnit(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveY(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformUnit(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "transformInverseUnit(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformUnit(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    get(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    toString(): string;
    "transformPositiveZ(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    notifyAll(): void;
    "setFromNormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    "transformInverse(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    equals(arg0: Internal.Quaternionfc_, arg1: number): boolean;
    scaling(arg0: number): this;
    transformInverse(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "slerp(org.joml.Quaternionfc,float,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3fc_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "transform(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Vec4f_): Vec4f;
    premul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    getAsMatrix4x3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: Internal.Quaternionfc_): this;
    rotateY(arg0: number): this;
    "transformInverse(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    notify(): void;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotationX(arg0: number): this;
    "transformPositiveY(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformInverseUnit(double,double,double,org.joml.Vector4d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    "getAsMatrix4x3f(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.AxisAngle4f_): this;
    "getAsMatrix3f(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    conjugateBy(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    "transform(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    angle(): number;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    "transformPositiveX(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformInverseUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    "transform(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    "transformInverseUnit(float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): Matrix3f;
    "setFromNormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    "transformUnitPositiveZ(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateZ(arg0: number, arg1: Quaternionf_): this;
    "transformInverseUnit(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    positiveX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    transformUnitPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformPositiveX(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    getAsMatrix4f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotateX(arg0: number): this;
    "transformInverseUnit(double,double,double,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    difference(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformPositiveX(arg0: Vec3f_): Vec3f;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "transformInverse(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    "get(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    wait(arg0: number, arg1: number): void;
    "setFromUnnormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    set(arg0: Internal.Quaterniondc_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    "transformUnit(float,float,float,org.joml.Vector3d)"(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    "mul(org.joml.Quaternionfc,org.joml.Quaternionf)"(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transform(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number): this;
    "transformUnitPositiveY(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    transformUnitPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    "transformUnit(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transform(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    "transformUnit(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4dc_): this;
    static nlerpIterative(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    rotationY(arg0: number): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    transformInverse(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    "transformInverseUnit(org.joml.Vector3dc,org.joml.Vector3d)"(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveX(arg0: Vec4f_): Vec4f;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): Matrix4f;
    set(arg0: Internal.AxisAngle4d_): this;
    hashCode(): number;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    "transformInverse(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "setFromUnnormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_): this;
    transformUnitPositiveZ(arg0: Vec4f_): Vec4f;
    get(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "transform(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "transformPositiveZ(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    "transformUnitPositiveX(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    rotateY(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    "transformUnit(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    "setFromUnnormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set fromUnnormalized(arg0: Internal.Matrix3fc_)
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    set fromNormalized(arg0: Internal.Matrix3dc_)
    get class(): typeof any
    set fromNormalized(arg0: Internal.Matrix4fc_)
    set "fromNormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set fromUnnormalized(arg0: Internal.Matrix3dc_)
    set "fromUnnormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set fromUnnormalized(arg0: Internal.Matrix4fc_)
    set fromNormalized(arg0: Internal.Matrix3fc_)
    set "fromNormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_)
    set fromNormalized(arg0: Internal.Matrix4x3fc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3dc_)
    set "fromNormalized(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "fromUnnormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_)
    set "fromNormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set fromUnnormalized(arg0: Internal.Matrix4dc_)
    set "fromUnnormalized(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    set fromNormalized(arg0: Internal.Matrix4x3dc_)
    set "fromNormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3fc_)
    set "fromNormalized(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "fromUnnormalized(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set fromNormalized(arg0: Internal.Matrix4dc_)
    set "fromUnnormalized(org.joml.Matrix4x3dc)"(arg0: Internal.Matrix4x3dc_)
    set "fromUnnormalized(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    z: number;
    y: number;
    x: number;
    w: number;
}
type Quaternionf_ = Quaternionf;
declare class BlockProperties {
    constructor()
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static readonly LEVEL_FLOWING: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly PERSISTENT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HORIZONTAL_FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly WEST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CHISELED_BOOKSHELF_SLOT_5_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly NOTE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly AGE_5: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EGGS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NORTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_RECORD: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SCULK_SENSOR_PHASE: Internal.EnumProperty<Internal.SculkSensorPhase>;
    static readonly EAST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly HALF: Internal.EnumProperty<Internal.Half>;
    static readonly RESPAWN_ANCHOR_CHARGES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly HANGING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly TILT: Internal.EnumProperty<Internal.Tilt>;
    static readonly STABILITY_DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_4_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_BOTTLE_2: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LAYERS: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly SOUTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CRACKED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CONDITIONAL: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LOCKED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly POWER: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EYE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SOUTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly MAX_AGE_1: (1) & (number);
    static readonly ATTACHED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_LEVEL_15: (15) & (number);
    static readonly BELL_ATTACHMENT: Internal.EnumProperty<Internal.BellAttachType>;
    static readonly MAX_DISTANCE: (7) & (number);
    static readonly FLOWER_AMOUNT: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EXTENDED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly INVERTED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MODE_COMPARATOR: Internal.EnumProperty<Internal.ComparatorMode>;
    static readonly MOISTURE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly LIT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly DISTANCE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NORTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly AGE_3: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STAIRS_SHAPE: Internal.EnumProperty<Internal.StairsShape>;
    static readonly MAX_LEVEL_8: (8) & (number);
    static readonly MIN_RESPAWN_ANCHOR_CHARGES: (0) & (number);
    static readonly BAMBOO_LEAVES: Internal.EnumProperty<Internal.BambooLeaves>;
    static readonly HORIZONTAL_AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly FALLING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ENABLED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ATTACH_FACE: Internal.EnumProperty<Internal.AttachFace>;
    static readonly OPEN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly UNSTABLE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_4: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly EAST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly ORIENTATION: Internal.EnumProperty<Internal.FrontAndTop>;
    static readonly DOUBLE_BLOCK_HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    static readonly MAX_RESPAWN_ANCHOR_CHARGES: (4) & (number);
    static readonly CHEST_TYPE: Internal.EnumProperty<Internal.ChestType>;
    static readonly MAX_AGE_7: (7) & (number);
    static readonly DOWN: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_2_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_15: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STRUCTUREBLOCK_MODE: Internal.EnumProperty<Internal.StructureMode>;
    static readonly SLAB_TYPE: Internal.EnumProperty<Internal.SlabType>;
    static readonly EAST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly WATERLOGGED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BLOOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SHRIEKING: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_1: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly FACING_HOPPER: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly VERTICAL_DIRECTION: (Internal.DirectionProperty) & (Internal.DirectionProperty);
    static readonly PICKLES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_25: (25) & (number);
    static readonly LEVEL_HONEY: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DUSTED: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_4: (4) & (number);
    static readonly PISTON_TYPE: Internal.EnumProperty<Internal.PistonType>;
    static readonly HATCH: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly SNOWY: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly TRIGGERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_1_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SIGNAL_FIRE: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LEVEL_CAULDRON: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly AGE_2: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DRAG: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CAN_SUMMON: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly LEVEL: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STAGE: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_AGE_5: (5) & (number);
    static readonly NORTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly UP: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_0_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BITES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly IN_WALL: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_25: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly STABILITY_MAX_DISTANCE: (7) & (number);
    static readonly HAS_BOTTLE_1: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly AGE_7: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly CHISELED_BOOKSHELF_SLOT_3_OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SOUTH: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_15: (15) & (number);
    static readonly DISARMED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly RAIL_SHAPE: Internal.EnumProperty<Internal.RailShape>;
    static readonly DOOR_HINGE: Internal.EnumProperty<Internal.DoorHingeSide>;
    static readonly LEVEL_COMPOSTER: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly DELAY: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MIN_LEVEL: (0) & (number);
    static readonly RAIL_SHAPE_STRAIGHT: Internal.EnumProperty<Internal.RailShape>;
    static readonly MIN_LEVEL_CAULDRON: (1) & (number);
    static readonly BOTTOM: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly HAS_BOOK: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly CANDLES: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly NOTEBLOCK_INSTRUMENT: Internal.EnumProperty<Internal.NoteBlockInstrument>;
    static readonly WEST: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly SHORT: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly BERRIES: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_2: (2) & (number);
    static readonly HAS_BOTTLE_0: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly WEST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly ROTATION_16: (Internal.IntegerProperty) & (Internal.IntegerProperty);
    static readonly MAX_LEVEL_3: (3) & (number);
    static readonly BED_PART: Internal.EnumProperty<Internal.BedPart>;
    static readonly POWERED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly MAX_AGE_3: (3) & (number);
    static readonly OCCUPIED: (Internal.BooleanProperty) & (Internal.BooleanProperty);
    static readonly DRIPSTONE_THICKNESS: Internal.EnumProperty<Internal.DripstoneThickness>;
    static readonly FACING: (Internal.DirectionProperty) & (Internal.DirectionProperty);
}
type BlockProperties_ = BlockProperties;
declare class Vec3i implements Internal.Comparable<Vec3i> {
    constructor(arg0: number, arg1: number, arg2: number)
    north(): this;
    getClass(): typeof any;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    getY(): number;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    south(arg0: number): this;
    toShortString(): string;
    above(arg0: number): this;
    notify(): void;
    west(arg0: number): this;
    wait(arg0: number, arg1: number): void;
    compareTo(arg0: any): number;
    east(arg0: number): this;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    "relative(net.minecraft.core.Direction$Axis,int)"(arg0: Internal.Direction$Axis_, arg1: number): this;
    relative(arg0: Internal.Direction_): this;
    multiply(arg0: number): this;
    getZ(): number;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(arg0: number): this;
    offset(arg0: number, arg1: number, arg2: number): this;
    above(): this;
    toString(): string;
    "compareTo(net.minecraft.core.Vec3i)"(arg0: Vec3i_): number;
    north(arg0: number): this;
    east(): this;
    below(): this;
    notifyAll(): void;
    distManhattan(arg0: Vec3i_): number;
    west(): this;
    relative(arg0: Internal.Direction$Axis_, arg1: number): this;
    get(arg0: Internal.Direction$Axis_): number;
    offset(arg0: Vec3i_): this;
    cross(arg0: Vec3i_): this;
    south(): this;
    hashCode(): number;
    distSqr(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): this;
    relative(arg0: Internal.Direction_, arg1: number): this;
    wait(): void;
    wait(arg0: number): void;
    compareTo(arg0: Vec3i_): number;
    "compareTo(java.lang.Object)"(arg0: any): number;
    equals(arg0: any): boolean;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    "relative(net.minecraft.core.Direction,int)"(arg0: Internal.Direction_, arg1: number): this;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    get class(): typeof any
    get x(): number
    get y(): number
    get z(): number
    static readonly ZERO: (Vec3i) & (Vec3i);
    static readonly CODEC: Internal.Codec<Vec3i>;
}
type Vec3i_ = Vec3i;
declare class Blocks {
    constructor()
    getClass(): typeof any;
    static register(arg0: string, arg1: Internal.Block_): Internal.Block;
    hashCode(): number;
    static never(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    toString(): string;
    wait(): void;
    notifyAll(): void;
    wait(arg0: number): void;
    static rebuildCache(): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    static MANGROVE_PROPAGULE: (Internal.MangrovePropaguleBlock) & (Internal.Block);
    static STONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POTTED_CRIMSON_FUNGUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CHERRY_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static POLISHED_ANDESITE: (Internal.Block) & (Internal.Block);
    static RED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static TORCH: (Internal.TorchBlock) & (Internal.Block);
    static COAL_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_CRIMSON_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static FIRE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static WEEPING_VINES_PLANT: (Internal.WeepingVinesPlantBlock) & (Internal.Block);
    static PEONY: (Internal.TallFlowerBlock) & (Internal.Block);
    static CARROTS: (Internal.CarrotBlock) & (Internal.Block);
    static YELLOW_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CYAN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BLUE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static TUBE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static SMITHING_TABLE: (Internal.SmithingTableBlock) & (Internal.Block);
    static ACACIA_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static MAGENTA_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static POTTED_CHERRY_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static PLAYER_WALL_HEAD: (Internal.PlayerWallHeadBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static MANGROVE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SPRUCE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static IRON_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static TRIPWIRE: (Internal.TripWireBlock) & (Internal.Block);
    static BLACK_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static LIGHT_BLUE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static ACACIA_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CRIMSON_FUNGUS: (Internal.FungusBlock) & (Internal.Block);
    static BUBBLE_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static LIGHT_BLUE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static PRISMARINE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static PURPLE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static RED_NETHER_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static SCULK_SENSOR: (Internal.SculkSensorBlock) & (Internal.Block);
    static YELLOW_WOOL: (Internal.Block) & (Internal.Block);
    static MAGENTA_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static SAND: (Internal.SandBlock) & (Internal.Block);
    static MYCELIUM: (Internal.MyceliumBlock) & (Internal.Block);
    static LIGHT_GRAY_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static ORANGE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CORNFLOWER: (Internal.FlowerBlock) & (Internal.Block);
    static DARK_OAK_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static GRANITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static REDSTONE_LAMP: (Internal.RedstoneLampBlock) & (Internal.Block);
    static LIGHT: (Internal.LightBlock) & (Internal.Block);
    static TUBE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static WARPED_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static DANDELION: (Internal.FlowerBlock) & (Internal.Block);
    static PINK_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WARPED_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static RED_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SOUL_SOIL: (Internal.Block) & (Internal.Block);
    static ACACIA_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static CRIMSON_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static HEAVY_WEIGHTED_PRESSURE_PLATE: (Internal.WeightedPressurePlateBlock) & (Internal.Block);
    static PRISMARINE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static TWISTING_VINES_PLANT: (Internal.TwistingVinesPlantBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WARPED_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static RED_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WARPED_WART_BLOCK: (Internal.Block) & (Internal.Block);
    static EXPOSED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static COARSE_DIRT: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_REDSTONE_ORE: (Internal.RedStoneOreBlock) & (Internal.Block);
    static TUFF: (Internal.Block) & (Internal.Block);
    static CHISELED_BOOKSHELF: (Internal.ChiseledBookShelfBlock) & (Internal.Block);
    static ACACIA_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEEPSLATE_IRON_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPLE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static LIGHTNING_ROD: (Internal.LightningRodBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static CHERRY_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LILY_PAD: (Internal.WaterlilyBlock) & (Internal.Block);
    static GREEN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static BARRIER: (Internal.BarrierBlock) & (Internal.Block);
    static PINK_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static DRAGON_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static YELLOW_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static STRIPPED_BIRCH_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SEAGRASS: (Internal.SeagrassBlock) & (Internal.Block);
    static CHERRY_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static HORN_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static MOSSY_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static SPRUCE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static WAXED_COPPER_BLOCK: (Internal.Block) & (Internal.Block);
    static STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GRANITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static NETHER_BRICK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static MOSS_CARPET: (Internal.CarpetBlock) & (Internal.Block);
    static DARK_OAK_PLANKS: (Internal.Block) & (Internal.Block);
    static MAGENTA_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static ANDESITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_NETHER_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BIRCH_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BAMBOO_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BROWN_CONCRETE: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_DIAMOND_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static BEETROOTS: (Internal.BeetrootBlock) & (Internal.Block);
    static POTTED_BAMBOO: (Internal.FlowerPotBlock) & (Internal.Block);
    static FERN: (Internal.TallGrassBlock) & (Internal.Block);
    static CRIMSON_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WAXED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static ACACIA_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static BLACK_WOOL: (Internal.Block) & (Internal.Block);
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static BRAIN_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static VINE: (Internal.VineBlock) & (Internal.Block);
    static CHERRY_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static ANDESITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static INFESTED_DEEPSLATE: (Internal.InfestedRotatedPillarBlock) & (Internal.Block);
    static ACACIA_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SPONGE: (Internal.SpongeBlock) & (Internal.Block);
    static REDSTONE_ORE: (Internal.RedStoneOreBlock) & (Internal.Block);
    static STRIPPED_ACACIA_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static REDSTONE_WALL_TORCH: (Internal.RedstoneWallTorchBlock) & (Internal.Block);
    static CYAN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BLACK_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static CAMPFIRE: (Internal.CampfireBlock) & (Internal.Block);
    static OCHRE_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static COBBLESTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DRAGON_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static POTTED_WITHER_ROSE: (Internal.FlowerPotBlock) & (Internal.Block);
    static BLACKSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GRAY_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static CYAN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static BAMBOO_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static BIRCH_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static POTTED_CORNFLOWER: (Internal.FlowerPotBlock) & (Internal.Block);
    static STICKY_PISTON: (Internal.PistonBaseBlock) & (Internal.Block);
    static LIGHT_BLUE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WEATHERED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static CYAN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static RAW_GOLD_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_BIRCH_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LARGE_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static POLISHED_ANDESITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_PORTAL: (Internal.NetherPortalBlock) & (Internal.Block);
    static JUNGLE_PLANKS: (Internal.Block) & (Internal.Block);
    static PINK_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STRIPPED_WARPED_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static POTTED_OAK_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static MANGROVE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static DARK_OAK_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static ORANGE_CONCRETE: (Internal.Block) & (Internal.Block);
    static BLUE_ORCHID: (Internal.FlowerBlock) & (Internal.Block);
    static STRIPPED_BAMBOO_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BIRCH_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GRAY_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static DEEPSLATE_TILES: (Internal.Block) & (Internal.Block);
    static CRIMSON_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static WHITE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static KELP: (Internal.KelpBlock) & (Internal.Block);
    static BROWN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static INFESTED_CRACKED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static JUNGLE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static LIGHT_GRAY_CONCRETE: (Internal.Block) & (Internal.Block);
    static RED_MUSHROOM_BLOCK: (Internal.HugeMushroomBlock) & (Internal.Block);
    static GRAY_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static MOSS_BLOCK: (Internal.MossBlock) & (Internal.Block);
    static LIME_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static CRIMSON_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CARVED_PUMPKIN: (Internal.EquipableCarvedPumpkinBlock) & (Internal.Block);
    static POTATOES: (Internal.PotatoBlock) & (Internal.Block);
    static PURPUR_PILLAR: (Internal.RotatedPillarBlock) & (Internal.Block);
    static MUD_BRICKS: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static MANGROVE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHERRY_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static NOTE_BLOCK: (Internal.NoteBlock) & (Internal.Block);
    static ENDER_CHEST: (Internal.EnderChestBlock) & (Internal.Block);
    static CYAN_BED: (Internal.BedBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static BIRCH_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static YELLOW_CONCRETE: (Internal.Block) & (Internal.Block);
    static DEAD_TUBE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static STRIPPED_WARPED_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LEVER: (Internal.LeverBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static LIGHT_BLUE_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_MANGROVE_PROPAGULE: (Internal.FlowerPotBlock) & (Internal.Block);
    static DROPPER: (Internal.DropperBlock) & (Internal.Block);
    static SPRUCE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static RED_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CRAFTING_TABLE: (Internal.CraftingTableBlock) & (Internal.Block);
    static SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GRASS: (Internal.TallGrassBlock) & (Internal.Block);
    static CHERRY_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MEDIUM_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static CRIMSON_ROOTS: (Internal.RootsBlock) & (Internal.Block);
    static WITHER_ROSE: (Internal.WitherRoseBlock) & (Internal.Block);
    static OXEYE_DAISY: (Internal.FlowerBlock) & (Internal.Block);
    static OAK_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static EMERALD_BLOCK: (Internal.Block) & (Internal.Block);
    static BUDDING_AMETHYST: (Internal.BuddingAmethystBlock) & (Internal.Block);
    static RAIL: (Internal.RailBlock) & (Internal.Block);
    static JUNGLE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BROWN_MUSHROOM_BLOCK: (Internal.HugeMushroomBlock) & (Internal.Block);
    static DARK_OAK_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static DIAMOND_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LADDER: (Internal.LadderBlock) & (Internal.Block);
    static OAK_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static MELON: (Internal.MelonBlock) & (Internal.Block);
    static CRIMSON_PLANKS: (Internal.Block) & (Internal.Block);
    static GLOW_LICHEN: (Internal.GlowLichenBlock) & (Internal.Block);
    static REDSTONE_WIRE: (Internal.RedStoneWireBlock) & (Internal.Block);
    static HORN_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static DARK_PRISMARINE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CAVE_VINES_PLANT: (Internal.CaveVinesPlantBlock) & (Internal.Block);
    static ACACIA_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static YELLOW_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_WALL: (Internal.WallBlock) & (Internal.Block);
    static CRIMSON_NYLIUM: (Internal.NyliumBlock) & (Internal.Block);
    static POTTED_BLUE_ORCHID: (Internal.FlowerPotBlock) & (Internal.Block);
    static CYAN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static SCULK_CATALYST: (Internal.SculkCatalystBlock) & (Internal.Block);
    static STRIPPED_MANGROVE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DISPENSER: (Internal.DispenserBlock) & (Internal.Block);
    static PRISMARINE_WALL: (Internal.WallBlock) & (Internal.Block);
    static ORANGE_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static BLACK_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static SPORE_BLOSSOM: (Internal.SporeBlossomBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static DEEPSLATE_TILE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static JUNGLE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DIRT_PATH: (Internal.DirtPathBlock) & (Internal.Block);
    static BLUE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GREEN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static HONEYCOMB_BLOCK: (Internal.Block) & (Internal.Block);
    static ICE: (Internal.IceBlock) & (Internal.Block);
    static BAMBOO_MOSAIC_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POTTED_BIRCH_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static WHITE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WATER: (Internal.LiquidBlock) & (Internal.Block);
    static CRACKED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static WATER_CAULDRON: (Internal.LayeredCauldronBlock) & (Internal.Block);
    static MUD_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WAXED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_WALL: (Internal.WallBlock) & (Internal.Block);
    static OAK_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static OAK_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static POTTED_BROWN_MUSHROOM: (Internal.FlowerPotBlock) & (Internal.Block);
    static WARPED_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static JUKEBOX: (Internal.JukeboxBlock) & (Internal.Block);
    static MANGROVE_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static PLAYER_HEAD: (Internal.PlayerHeadBlock) & (Internal.Block);
    static PURPLE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_TUBE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BIRCH_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POWDER_SNOW_CAULDRON: (Internal.PowderSnowCauldronBlock) & (Internal.Block);
    static BROWN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static BREWING_STAND: (Internal.BrewingStandBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static REDSTONE_TORCH: (Internal.RedstoneTorchBlock) & (Internal.Block);
    static BAMBOO_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static BLACK_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static POLISHED_GRANITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MAGENTA_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BLACK_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static NETHER_SPROUTS: (Internal.NetherSproutsBlock) & (Internal.Block);
    static GREEN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static SPRUCE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PURPLE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static CONDUIT: (Internal.ConduitBlock) & (Internal.Block);
    static ORANGE_WOOL: (Internal.Block) & (Internal.Block);
    static POTTED_WHITE_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static PRISMARINE_BRICKS: (Internal.Block) & (Internal.Block);
    static POLISHED_BLACKSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static SEA_LANTERN: (Internal.Block) & (Internal.Block);
    static MAGENTA_BED: (Internal.BedBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STONE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static SCAFFOLDING: (Internal.ScaffoldingBlock) & (Internal.Block);
    static NETHER_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DIORITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static PISTON_HEAD: (Internal.PistonHeadBlock) & (Internal.Block);
    static BLACK_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PURPLE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static LIME_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static OAK_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static CUT_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static LIME_BED: (Internal.BedBlock) & (Internal.Block);
    static SPAWNER: (Internal.SpawnerBlock) & (Internal.Block);
    static FROSTED_ICE: (Internal.FrostedIceBlock) & (Internal.Block);
    static IRON_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static WARPED_ROOTS: (Internal.RootsBlock) & (Internal.Block);
    static STONE: (Internal.Block) & (Internal.Block);
    static MUD_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SOUL_LANTERN: (Internal.LanternBlock) & (Internal.Block);
    static COPPER_BLOCK: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static WAXED_OXIDIZED_COPPER: (Internal.Block) & (Internal.Block);
    static WARPED_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POLISHED_BASALT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DAYLIGHT_DETECTOR: (Internal.DaylightDetectorBlock) & (Internal.Block);
    static CRIMSON_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CHERRY_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GOLD_BLOCK: (Internal.Block) & (Internal.Block);
    static POTTED_LILY_OF_THE_VALLEY: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIGHT_BLUE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static LIGHT_GRAY_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static DRIPSTONE_BLOCK: (Internal.Block) & (Internal.Block);
    static COBBLED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static BIG_DRIPLEAF: (Internal.BigDripleafBlock) & (Internal.Block);
    static MANGROVE_LEAVES: (Internal.MangroveLeavesBlock) & (Internal.Block);
    static GRAY_WOOL: (Internal.Block) & (Internal.Block);
    static INFESTED_CHISELED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static GRAY_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static CHERRY_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static REPEATING_COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static WARPED_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static RED_BED: (Internal.BedBlock) & (Internal.Block);
    static CHERRY_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static POTTED_DANDELION: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_CACTUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static DIORITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static HOPPER: (Internal.HopperBlock) & (Internal.Block);
    static SPRUCE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static BARREL: (Internal.BarrelBlock) & (Internal.Block);
    static MELON_STEM: (Internal.StemBlock) & (Internal.Block);
    static ROOTED_DIRT: (Internal.RootedDirtBlock) & (Internal.Block);
    static LIGHT_BLUE_WOOL: (Internal.Block) & (Internal.Block);
    static SOUL_WALL_TORCH: (Internal.WallTorchBlock) & (Internal.Block);
    static LAPIS_BLOCK: (Internal.Block) & (Internal.Block);
    static ANDESITE: (Internal.Block) & (Internal.Block);
    static YELLOW_BED: (Internal.BedBlock) & (Internal.Block);
    static END_STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BLAST_FURNACE: (Internal.BlastFurnaceBlock) & (Internal.Block);
    static SMALL_DRIPLEAF: (Internal.SmallDripleafBlock) & (Internal.Block);
    static KELP_PLANT: (Internal.KelpPlantBlock) & (Internal.Block);
    static RED_SAND: (Internal.SandBlock) & (Internal.Block);
    static JUNGLE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static QUARTZ_BRICKS: (Internal.Block) & (Internal.Block);
    static CRIMSON_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static ZOMBIE_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static LIME_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static RAW_COPPER_BLOCK: (Internal.Block) & (Internal.Block);
    static CHERRY_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static ORANGE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static LOOM: (Internal.LoomBlock) & (Internal.Block);
    static GREEN_WOOL: (Internal.Block) & (Internal.Block);
    static BROWN_WOOL: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static PIGLIN_WALL_HEAD: (Internal.PiglinWallSkullBlock) & (Internal.Block);
    static BLUE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static PINK_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static SMOKER: (Internal.SmokerBlock) & (Internal.Block);
    static ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static BROWN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static FLOWER_POT: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIGHT_BLUE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STONECUTTER: (Internal.StonecutterBlock) & (Internal.Block);
    static CUT_RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_CONCRETE: (Internal.Block) & (Internal.Block);
    static DARK_OAK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static GREEN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BAMBOO: (Internal.BambooStalkBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static DARK_OAK_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static MAGENTA_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static DARK_OAK_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static CHISELED_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static CRIMSON_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static PITCHER_CROP: (Internal.PitcherCropBlock) & (Internal.Block);
    static CHERRY_LEAVES: (Internal.CherryLeavesBlock) & (Internal.Block);
    static RED_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static QUARTZ_PILLAR: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHISELED_POLISHED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static DEAD_FIRE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static PURPLE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static RED_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static AMETHYST_CLUSTER: (Internal.AmethystClusterBlock) & (Internal.Block);
    static DARK_PRISMARINE: (Internal.Block) & (Internal.Block);
    static MANGROVE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SCULK_VEIN: (Internal.SculkVeinBlock) & (Internal.Block);
    static JUNGLE_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static YELLOW_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static OBSERVER: (Internal.ObserverBlock) & (Internal.Block);
    static END_STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SPRUCE_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static MANGROVE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BAMBOO_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static SPRUCE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static NETHER_WART: (Internal.NetherWartBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static OBSIDIAN: (Internal.Block) & (Internal.Block);
    static PURPLE_CONCRETE: (Internal.Block) & (Internal.Block);
    static BLACK_CONCRETE: (Internal.Block) & (Internal.Block);
    static WARPED_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static REINFORCED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static DRAGON_EGG: (Internal.DragonEggBlock) & (Internal.Block);
    static PACKED_MUD: (Internal.Block) & (Internal.Block);
    static ACACIA_PLANKS: (Internal.Block) & (Internal.Block);
    static RED_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static DARK_OAK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_WEIGHTED_PRESSURE_PLATE: (Internal.WeightedPressurePlateBlock) & (Internal.Block);
    static FIRE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static QUARTZ_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static PURPUR_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static STRIPPED_JUNGLE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static RED_WOOL: (Internal.Block) & (Internal.Block);
    static FARMLAND: (Internal.FarmBlock) & (Internal.Block);
    static DARK_OAK_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static ORANGE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static DEEPSLATE_GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LIGHT_BLUE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BRICKS: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CAKE: (Internal.CakeBlock) & (Internal.Block);
    static GREEN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static JUNGLE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static BLUE_BED: (Internal.BedBlock) & (Internal.Block);
    static OAK_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static MANGROVE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static DEEPSLATE_BRICKS: (Internal.Block) & (Internal.Block);
    static BASALT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static REPEATER: (Internal.RepeaterBlock) & (Internal.Block);
    static PURPLE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static AZURE_BLUET: (Internal.FlowerBlock) & (Internal.Block);
    static LILY_OF_THE_VALLEY: (Internal.FlowerBlock) & (Internal.Block);
    static STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static BIRCH_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static BIRCH_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_BLUE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BROWN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static FIRE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static SANDSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static RESPAWN_ANCHOR: (Internal.RespawnAnchorBlock) & (Internal.Block);
    static PRISMARINE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHERRACK: (Internal.NetherrackBlock) & (Internal.Block);
    static CAVE_VINES: (Internal.CaveVinesBlock) & (Internal.Block);
    static WARPED_NYLIUM: (Internal.NyliumBlock) & (Internal.Block);
    static POTTED_POPPY: (Internal.FlowerPotBlock) & (Internal.Block);
    static POINTED_DRIPSTONE: (Internal.PointedDripstoneBlock) & (Internal.Block);
    static ORANGE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static LIGHT_GRAY_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICKS: (Internal.Block) & (Internal.Block);
    static GLASS: (Internal.GlassBlock) & (Internal.Block);
    static WARPED_PLANKS: (Internal.Block) & (Internal.Block);
    static WET_SPONGE: (Internal.WetSpongeBlock) & (Internal.Block);
    static GRASS_BLOCK: (Internal.GrassBlock) & (Internal.Block);
    static COAL_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPUR_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static WARPED_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEEPSLATE_COPPER_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static POLISHED_DIORITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static ANCIENT_DEBRIS: (Internal.Block) & (Internal.Block);
    static GRAY_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static WHITE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static END_STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static PODZOL: (Internal.SnowyDirtBlock) & (Internal.Block);
    static CHERRY_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static COMPARATOR: (Internal.ComparatorBlock) & (Internal.Block);
    static ACACIA_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static CHISELED_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static WAXED_WEATHERED_COPPER: (Internal.Block) & (Internal.Block);
    static SUGAR_CANE: (Internal.SugarCaneBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static NETHERITE_BLOCK: (Internal.Block) & (Internal.Block);
    static OAK_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static WHITE_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_AZURE_BLUET: (Internal.FlowerPotBlock) & (Internal.Block);
    static SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static ORANGE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static ORANGE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BRAIN_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static PINK_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static GRAY_BED: (Internal.BedBlock) & (Internal.Block);
    static GLASS_PANE: (Internal.IronBarsBlock) & (Internal.Block);
    static GRAVEL: (Internal.GravelBlock) & (Internal.Block);
    static BAMBOO_MOSAIC: (Internal.Block) & (Internal.Block);
    static SUSPICIOUS_GRAVEL: (Internal.BrushableBlock) & (Internal.Block);
    static ENCHANTING_TABLE: (Internal.EnchantmentTableBlock) & (Internal.Block);
    static LILAC: (Internal.TallFlowerBlock) & (Internal.Block);
    static STRIPPED_SPRUCE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static MANGROVE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static RED_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static STRIPPED_JUNGLE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static ALLIUM: (Internal.FlowerBlock) & (Internal.Block);
    static MUD_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DEAD_BRAIN_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static LIGHT_GRAY_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static ZOMBIE_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static WHITE_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static PINK_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static CRACKED_DEEPSLATE_BRICKS: (Internal.Block) & (Internal.Block);
    static WHITE_WOOL: (Internal.Block) & (Internal.Block);
    static GREEN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static GRAY_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BLACK_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static TUBE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static JUNGLE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static CUT_SANDSTONE: (Internal.Block) & (Internal.Block);
    static POLISHED_GRANITE: (Internal.Block) & (Internal.Block);
    static DARK_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SKELETON_WALL_SKULL: (Internal.WallSkullBlock) & (Internal.Block);
    static TALL_GRASS: (Internal.DoublePlantBlock) & (Internal.Block);
    static POTTED_JUNGLE_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static YELLOW_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static PEARLESCENT_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DARK_OAK_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static MAGENTA_WOOL: (Internal.Block) & (Internal.Block);
    static PUMPKIN_STEM: (Internal.StemBlock) & (Internal.Block);
    static MUD: (Internal.MudBlock) & (Internal.Block);
    static GRINDSTONE: (Internal.GrindstoneBlock) & (Internal.Block);
    static LIGHT_BLUE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BAMBOO_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static BLUE_ICE: (Internal.HalfTransparentBlock) & (Internal.Block);
    static BROWN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static FLOWERING_AZALEA: (Internal.AzaleaBlock) & (Internal.Block);
    static CHERRY_PLANKS: (Internal.Block) & (Internal.Block);
    static PACKED_ICE: (Internal.Block) & (Internal.Block);
    static ACACIA_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static GRAY_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static DARK_OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLUE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static ORANGE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BEEHIVE: (Internal.BeehiveBlock) & (Internal.Block);
    static PURPLE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static BLUE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static BLACK_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WHITE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static NETHER_GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static LODESTONE: (Internal.Block) & (Internal.Block);
    static WEEPING_VINES: (Internal.WeepingVinesBlock) & (Internal.Block);
    static MAGENTA_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static OAK_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static END_PORTAL: (Internal.EndPortalBlock) & (Internal.Block);
    static TINTED_GLASS: (Internal.TintedGlassBlock) & (Internal.Block);
    static LIME_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static SKELETON_SKULL: (Internal.SkullBlock) & (Internal.Block);
    static LIME_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static END_STONE: (Internal.Block) & (Internal.Block);
    static JUNGLE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static TWISTING_VINES: (Internal.TwistingVinesBlock) & (Internal.Block);
    static END_PORTAL_FRAME: (Internal.EndPortalFrameBlock) & (Internal.Block);
    static CRIMSON_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static SPRUCE_PLANKS: (Internal.Block) & (Internal.Block);
    static POLISHED_GRANITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static YELLOW_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SNIFFER_EGG: (Internal.SnifferEggBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CHERRY_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static ORANGE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static LIGHT_BLUE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static ACACIA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static GRAY_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static GRAY_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BIRCH_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CRACKED_DEEPSLATE_TILES: (Internal.Block) & (Internal.Block);
    static HANGING_ROOTS: (Internal.HangingRootsBlock) & (Internal.Block);
    static TURTLE_EGG: (Internal.TurtleEggBlock) & (Internal.Block);
    static BLACKSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static BAMBOO_SAPLING: (Internal.BambooSaplingBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WHITE_BED: (Internal.BedBlock) & (Internal.Block);
    static CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static DETECTOR_RAIL: (Internal.DetectorRailBlock) & (Internal.Block);
    static COPPER_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static CAULDRON: (Internal.CauldronBlock) & (Internal.Block);
    static LANTERN: (Internal.LanternBlock) & (Internal.Block);
    static GLOWSTONE: (Internal.Block) & (Internal.Block);
    static YELLOW_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static VOID_AIR: (Internal.AirBlock) & (Internal.Block);
    static PURPUR_BLOCK: (Internal.Block) & (Internal.Block);
    static INFESTED_STONE: (Internal.InfestedBlock) & (Internal.Block);
    static CHAIN: (Internal.ChainBlock) & (Internal.Block);
    static STRIPPED_SPRUCE_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static OAK_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static OAK_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static MAGMA_BLOCK: (Internal.MagmaBlock) & (Internal.Block);
    static DIORITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static RED_SANDSTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static LAPIS_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static SPRUCE_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static SMOOTH_STONE: (Internal.Block) & (Internal.Block);
    static BUBBLE_COLUMN: (Internal.BubbleColumnBlock) & (Internal.Block);
    static CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static POLISHED_DIORITE: (Internal.Block) & (Internal.Block);
    static BIRCH_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static AIR: (Internal.AirBlock) & (Internal.Block);
    static AZALEA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static WHITE_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static CAVE_AIR: (Internal.AirBlock) & (Internal.Block);
    static MOSSY_COBBLESTONE: (Internal.Block) & (Internal.Block);
    static OAK_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static BAMBOO_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static EMERALD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static CYAN_WOOL: (Internal.Block) & (Internal.Block);
    static BIRCH_PLANKS: (Internal.Block) & (Internal.Block);
    static POTTED_ORANGE_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_WARPED_ROOTS: (Internal.FlowerPotBlock) & (Internal.Block);
    static SPRUCE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static DARK_PRISMARINE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static SMALL_AMETHYST_BUD: (Internal.AmethystClusterBlock) & (Internal.Block);
    static SPRUCE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WITHER_SKELETON_SKULL: (Internal.WitherSkullBlock) & (Internal.Block);
    static BUBBLE_CORAL_FAN: (Internal.CoralFanBlock) & (Internal.Block);
    static CREEPER_WALL_HEAD: (Internal.WallSkullBlock) & (Internal.Block);
    static STRIPPED_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static ACACIA_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHAIN_COMMAND_BLOCK: (Internal.CommandBlock) & (Internal.Block);
    static PIGLIN_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static MANGROVE_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static INFESTED_MOSSY_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static BROWN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BLUE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static ACACIA_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static CYAN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static FLETCHING_TABLE: (Internal.FletchingTableBlock) & (Internal.Block);
    static TORCHFLOWER_CROP: (Internal.TorchflowerCropBlock) & (Internal.Block);
    static GRAY_CONCRETE: (Internal.Block) & (Internal.Block);
    static WARPED_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static HORN_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static BROWN_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static END_GATEWAY: (Internal.EndGatewayBlock) & (Internal.Block);
    static DEEPSLATE_TILE_WALL: (Internal.WallBlock) & (Internal.Block);
    static POTTED_ALLIUM: (Internal.FlowerPotBlock) & (Internal.Block);
    static COBBLESTONE: (Internal.Block) & (Internal.Block);
    static OAK_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CALCITE: (Internal.Block) & (Internal.Block);
    static MANGROVE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static POTTED_OXEYE_DAISY: (Internal.FlowerPotBlock) & (Internal.Block);
    static FIRE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static STRIPPED_CRIMSON_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BIRCH_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static TERRACOTTA: (Internal.Block) & (Internal.Block);
    static JUNGLE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static NETHER_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static CYAN_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BAMBOO_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static END_ROD: (Internal.EndRodBlock) & (Internal.Block);
    static LIGHT_BLUE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SMOOTH_QUARTZ: (Internal.Block) & (Internal.Block);
    static PRISMARINE: (Internal.Block) & (Internal.Block);
    static SMOOTH_QUARTZ_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static NETHER_QUARTZ_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static MUDDY_MANGROVE_ROOTS: (Internal.RotatedPillarBlock) & (Internal.Block);
    static LIGHT_GRAY_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static MANGROVE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static DEEPSLATE_TILE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static ATTACHED_PUMPKIN_STEM: (Internal.AttachedStemBlock) & (Internal.Block);
    static CYAN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static OXIDIZED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static POLISHED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static COCOA: (Internal.CocoaBlock) & (Internal.Block);
    static JUNGLE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static BIRCH_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static SPRUCE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POTTED_RED_MUSHROOM: (Internal.FlowerPotBlock) & (Internal.Block);
    static MAGENTA_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static JUNGLE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WARPED_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CRIMSON_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static CHEST: (Internal.ChestBlock) & (Internal.Block);
    static SPRUCE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static BLACKSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIME_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static GILDED_BLACKSTONE: (Internal.Block) & (Internal.Block);
    static SUNFLOWER: (Internal.TallFlowerBlock) & (Internal.Block);
    static ORANGE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static VERDANT_FROGLIGHT: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PETRIFIED_OAK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static RED_NETHER_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DRIED_KELP_BLOCK: (Internal.Block) & (Internal.Block);
    static BONE_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static WHITE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static POTTED_SPRUCE_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static DEAD_HORN_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BUBBLE_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static GREEN_CONCRETE: (Internal.Block) & (Internal.Block);
    static CHORUS_FLOWER: (Internal.ChorusFlowerBlock) & (Internal.Block);
    static GRAY_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static YELLOW_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static LIGHT_GRAY_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PINK_WOOL: (Internal.Block) & (Internal.Block);
    static PINK_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static CYAN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static DARK_OAK_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static POWERED_RAIL: (Internal.PoweredRailBlock) & (Internal.Block);
    static LIGHT_BLUE_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static POWDER_SNOW: (Internal.PowderSnowBlock) & (Internal.Block);
    static ORANGE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static PINK_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BLACK_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SPRUCE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static GRAY_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static WARPED_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static JIGSAW: (Internal.JigsawBlock) & (Internal.Block);
    static WHITE_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static SPRUCE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIGHT_GRAY_WOOL: (Internal.Block) & (Internal.Block);
    static PISTON: (Internal.PistonBaseBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static DIRT: (Internal.Block) & (Internal.Block);
    static BLUE_CONCRETE: (Internal.Block) & (Internal.Block);
    static RED_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static OXIDIZED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static TALL_SEAGRASS: (Internal.TallSeagrassBlock) & (Internal.Block);
    static CHORUS_PLANT: (Internal.ChorusPlantBlock) & (Internal.Block);
    static PINK_CONCRETE: (Internal.Block) & (Internal.Block);
    static WHITE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static MOVING_PISTON: (Internal.MovingPistonBlock) & (Internal.Block);
    static CHERRY_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static MANGROVE_ROOTS: (Internal.MangroveRootsBlock) & (Internal.Block);
    static POTTED_ACACIA_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static MANGROVE_PLANKS: (Internal.Block) & (Internal.Block);
    static ACACIA_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WAXED_OXIDIZED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static BAMBOO_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static RED_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static BLUE_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static BELL: (Internal.BellBlock) & (Internal.Block);
    static MUSHROOM_STEM: (Internal.HugeMushroomBlock) & (Internal.Block);
    static EXPOSED_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static CYAN_CONCRETE: (Internal.Block) & (Internal.Block);
    static POTTED_CRIMSON_ROOTS: (Internal.FlowerPotBlock) & (Internal.Block);
    static GREEN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static CHISELED_QUARTZ_BLOCK: (Internal.Block) & (Internal.Block);
    static JUNGLE_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static FROGSPAWN: (Internal.FrogspawnBlock) & (Internal.Block);
    static SOUL_TORCH: (Internal.TorchBlock) & (Internal.Block);
    static BOOKSHELF: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_COPPER: (Internal.Block) & (Internal.Block);
    static CRIMSON_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static DIAMOND_BLOCK: (Internal.Block) & (Internal.Block);
    static RED_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static CRIMSON_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static SANDSTONE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static MAGENTA_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static STRIPPED_DARK_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL_BLOCK: (Internal.Block) & (Internal.Block);
    static SPRUCE_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BLUE_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static STRIPPED_CHERRY_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static CALIBRATED_SCULK_SENSOR: (Internal.CalibratedSculkSensorBlock) & (Internal.Block);
    static AMETHYST_BLOCK: (Internal.AmethystBlock) & (Internal.Block);
    static STRUCTURE_BLOCK: (Internal.StructureBlock) & (Internal.Block);
    static BAMBOO_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static BRAIN_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static BAMBOO_MOSAIC_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static STRIPPED_DARK_OAK_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static SMOOTH_SANDSTONE: (Internal.Block) & (Internal.Block);
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BLUE_WOOL: (Internal.Block) & (Internal.Block);
    static IRON_BARS: (Internal.IronBarsBlock) & (Internal.Block);
    static IRON_BLOCK: (Internal.Block) & (Internal.Block);
    static SUSPICIOUS_SAND: (Internal.BrushableBlock) & (Internal.Block);
    static HORN_CORAL_BLOCK: (Internal.CoralBlock) & (Internal.Block);
    static MAGENTA_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static HONEY_BLOCK: (Internal.HoneyBlock) & (Internal.Block);
    static END_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static JACK_O_LANTERN: (Internal.CarvedPumpkinBlock) & (Internal.Block);
    static TARGET: (Internal.TargetBlock) & (Internal.Block);
    static BRAIN_CORAL: (Internal.CoralPlantBlock) & (Internal.Block);
    static DEAD_FIRE_CORAL_FAN: (Internal.BaseCoralFanBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLUE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static WITHER_SKELETON_WALL_SKULL: (Internal.WitherWallSkullBlock) & (Internal.Block);
    static CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static BIRCH_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static ROSE_BUSH: (Internal.TallFlowerBlock) & (Internal.Block);
    static YELLOW_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static LECTERN: (Internal.LecternBlock) & (Internal.Block);
    static CRIMSON_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static DAMAGED_ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static POLISHED_BLACKSTONE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static POLISHED_DIORITE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static HAY_BLOCK: (Internal.HayBlock) & (Internal.Block);
    static WARPED_HYPHAE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CHERRY_WALL_HANGING_SIGN: (Internal.WallHangingSignBlock) & (Internal.Block);
    static MANGROVE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WEATHERED_CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static LIME_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static TRIPWIRE_HOOK: (Internal.TripWireHookBlock) & (Internal.Block);
    static CLAY: (Internal.Block) & (Internal.Block);
    static SNOW: (Internal.SnowLayerBlock) & (Internal.Block);
    static WHEAT: (Internal.CropBlock) & (Internal.Block);
    static CYAN_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static WEATHERED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static BROWN_MUSHROOM: (Internal.MushroomBlock) & (Internal.Block);
    static SHROOMLIGHT: (Internal.Block) & (Internal.Block);
    static CRIMSON_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static PRISMARINE_BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static POPPY: (Internal.FlowerBlock) & (Internal.Block);
    static STRUCTURE_VOID: (Internal.StructureVoidBlock) & (Internal.Block);
    static ORANGE_BED: (Internal.BedBlock) & (Internal.Block);
    static DEEPSLATE_COAL_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static PURPLE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static CUT_COPPER_SLAB: (Internal.WeatheringCopperSlabBlock) & (Internal.Block);
    static REDSTONE_BLOCK: (Internal.PoweredBlock) & (Internal.Block);
    static BLACK_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static WAXED_CUT_COPPER_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static GREEN_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static POTTED_AZALEA: (Internal.FlowerPotBlock) & (Internal.Block);
    static LIME_CONCRETE: (Internal.Block) & (Internal.Block);
    static BAMBOO_BLOCK: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PURPLE_WOOL: (Internal.Block) & (Internal.Block);
    static SOUL_FIRE: (Internal.SoulFireBlock) & (Internal.Block);
    static CHISELED_NETHER_BRICKS: (Internal.Block) & (Internal.Block);
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: (Internal.Block) & (Internal.Block);
    static PINK_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static CARTOGRAPHY_TABLE: (Internal.CartographyTableBlock) & (Internal.Block);
    static BLACK_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static GREEN_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static CYAN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static QUARTZ_BLOCK: (Internal.Block) & (Internal.Block);
    static BAMBOO_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static WHITE_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER: (Internal.Block) & (Internal.Block);
    static WARPED_WALL_SIGN: (Internal.WallSignBlock) & (Internal.Block);
    static COMPOSTER: (Internal.ComposterBlock) & (Internal.Block);
    static DARK_OAK_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static ACACIA_SAPLING: (Internal.SaplingBlock) & (Internal.Block);
    static PITCHER_PLANT: (Internal.DoublePlantBlock) & (Internal.Block);
    static CHISELED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static POTTED_PINK_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static LARGE_FERN: (Internal.DoublePlantBlock) & (Internal.Block);
    static TNT: (Internal.TntBlock) & (Internal.Block);
    static COBBLED_DEEPSLATE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BRICK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static WARPED_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static SMOOTH_QUARTZ_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LAVA_CAULDRON: (Internal.LavaCauldronBlock) & (Internal.Block);
    static SCULK_SHRIEKER: (Internal.SculkShriekerBlock) & (Internal.Block);
    static BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static CHISELED_DEEPSLATE: (Internal.Block) & (Internal.Block);
    static AZALEA: (Internal.AzaleaBlock) & (Internal.Block);
    static SMOOTH_STONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static JUNGLE_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static LIME_WOOL: (Internal.Block) & (Internal.Block);
    static LIME_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static GREEN_BED: (Internal.BedBlock) & (Internal.Block);
    static ACTIVATOR_RAIL: (Internal.PoweredRailBlock) & (Internal.Block);
    static SEA_PICKLE: (Internal.SeaPickleBlock) & (Internal.Block);
    static PINK_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static BLUE_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static WEATHERED_CUT_COPPER_STAIRS: (Internal.WeatheringCopperStairBlock) & (Internal.Block);
    static CRACKED_STONE_BRICKS: (Internal.Block) & (Internal.Block);
    static FURNACE: (Internal.FurnaceBlock) & (Internal.Block);
    static COBBLESTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MANGROVE_FENCE_GATE: (Internal.FenceGateBlock) & (Internal.Block);
    static CHERRY_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BAMBOO_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static LIGHT_GRAY_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static MANGROVE_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static COBBLESTONE_WALL: (Internal.WallBlock) & (Internal.Block);
    static BEDROCK: (Internal.Block) & (Internal.Block);
    static BIRCH_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static PURPLE_BED: (Internal.BedBlock) & (Internal.Block);
    static LIME_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static RED_SANDSTONE: (Internal.Block) & (Internal.Block);
    static GOLD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static SCULK: (Internal.SculkBlock) & (Internal.Block);
    static ACACIA_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static COBWEB: (Internal.WebBlock) & (Internal.Block);
    static CRIMSON_STEM: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_BED: (Internal.BedBlock) & (Internal.Block);
    static STRIPPED_ACACIA_LOG: (Internal.RotatedPillarBlock) & (Internal.Block);
    static BEE_NEST: (Internal.BeehiveBlock) & (Internal.Block);
    static LAVA: (Internal.LiquidBlock) & (Internal.Block);
    static POTTED_WARPED_FUNGUS: (Internal.FlowerPotBlock) & (Internal.Block);
    static NETHER_WART_BLOCK: (Internal.Block) & (Internal.Block);
    static TORCHFLOWER: (Internal.FlowerBlock) & (Internal.Block);
    static ATTACHED_MELON_STEM: (Internal.AttachedStemBlock) & (Internal.Block);
    static DEEPSLATE_EMERALD_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static BROWN_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static POTTED_DARK_OAK_SAPLING: (Internal.FlowerPotBlock) & (Internal.Block);
    static POTTED_FERN: (Internal.FlowerPotBlock) & (Internal.Block);
    static PUMPKIN: (Internal.PumpkinBlock) & (Internal.Block);
    static EXPOSED_CUT_COPPER: (Internal.WeatheringCopperFullBlock) & (Internal.Block);
    static RED_MUSHROOM: (Internal.MushroomBlock) & (Internal.Block);
    static BROWN_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static PURPLE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static ORANGE_SHULKER_BOX: (Internal.ShulkerBoxBlock) & (Internal.Block);
    static RAW_IRON_BLOCK: (Internal.Block) & (Internal.Block);
    static WALL_TORCH: (Internal.WallTorchBlock) & (Internal.Block);
    static CACTUS: (Internal.CactusBlock) & (Internal.Block);
    static FIRE: (Internal.FireBlock) & (Internal.Block);
    static SLIME_BLOCK: (Internal.SlimeBlock) & (Internal.Block);
    static CHIPPED_ANVIL: (Internal.AnvilBlock) & (Internal.Block);
    static QUARTZ_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static LIGHT_BLUE_BED: (Internal.BedBlock) & (Internal.Block);
    static GREEN_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static JUNGLE_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static SOUL_SAND: (Internal.SoulSandBlock) & (Internal.Block);
    static CUT_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MAGENTA_CONCRETE: (Internal.Block) & (Internal.Block);
    static GRANITE: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_STAINED_GLASS_PANE: (Internal.StainedGlassPaneBlock) & (Internal.Block);
    static SMOOTH_BASALT: (Internal.Block) & (Internal.Block);
    static DEAD_BUSH: (Internal.DeadBushBlock) & (Internal.Block);
    static DARK_OAK_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static SOUL_CAMPFIRE: (Internal.CampfireBlock) & (Internal.Block);
    static MAGENTA_BANNER: (Internal.BannerBlock) & (Internal.Block);
    static SPRUCE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static CREEPER_HEAD: (Internal.SkullBlock) & (Internal.Block);
    static BROWN_CANDLE: (Internal.CandleBlock) & (Internal.Block);
    static YELLOW_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static DEAD_BUBBLE_CORAL: (Internal.BaseCoralPlantBlock) & (Internal.Block);
    static BLUE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static BRICK_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static JUNGLE_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static LIME_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static ACACIA_HANGING_SIGN: (Internal.CeilingHangingSignBlock) & (Internal.Block);
    static MOSSY_STONE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static TUBE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static BROWN_BED: (Internal.BedBlock) & (Internal.Block);
    static PURPLE_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static LIGHT_GRAY_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static BIG_DRIPLEAF_STEM: (Internal.BigDripleafStemBlock) & (Internal.Block);
    static LIME_CARPET: (Internal.WoolCarpetBlock) & (Internal.Block);
    static WARPED_FUNGUS: (Internal.FungusBlock) & (Internal.Block);
    static WHITE_WALL_BANNER: (Internal.WallBannerBlock) & (Internal.Block);
    static DARK_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static STRIPPED_MANGROVE_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static CRYING_OBSIDIAN: (Internal.CryingObsidianBlock) & (Internal.Block);
    static WAXED_WEATHERED_CUT_COPPER_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static MAGENTA_TERRACOTTA: (Internal.Block) & (Internal.Block);
    static POTTED_TORCHFLOWER: (Internal.FlowerPotBlock) & (Internal.Block);
    static STONE_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static IRON_DOOR: (Internal.DoorBlock) & (Internal.Block);
    static TRAPPED_CHEST: (Internal.TrappedChestBlock) & (Internal.Block);
    static LIGHT_GRAY_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static OAK_PLANKS: (Internal.Block) & (Internal.Block);
    static FLOWERING_AZALEA_LEAVES: (Internal.LeavesBlock) & (Internal.Block);
    static POTTED_FLOWERING_AZALEA: (Internal.FlowerPotBlock) & (Internal.Block);
    static POLISHED_ANDESITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BUBBLE_CORAL_WALL_FAN: (Internal.CoralWallFanBlock) & (Internal.Block);
    static ANDESITE_WALL: (Internal.WallBlock) & (Internal.Block);
    static YELLOW_CANDLE_CAKE: (Internal.CandleCakeBlock) & (Internal.Block);
    static BIRCH_SIGN: (Internal.StandingSignBlock) & (Internal.Block);
    static DEEPSLATE_BRICK_WALL: (Internal.WallBlock) & (Internal.Block);
    static SMOOTH_RED_SANDSTONE_SLAB: (Internal.SlabBlock) & (Internal.Block);
    static BLACKSTONE: (Internal.Block) & (Internal.Block);
    static LIGHT_GRAY_BED: (Internal.BedBlock) & (Internal.Block);
    static STRIPPED_OAK_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static PINK_PETALS: (Internal.PinkPetalsBlock) & (Internal.Block);
    static DIORITE: (Internal.Block) & (Internal.Block);
    static SWEET_BERRY_BUSH: (Internal.SweetBerryBushBlock) & (Internal.Block);
    static DECORATED_POT: (Internal.DecoratedPotBlock) & (Internal.Block);
    static INFESTED_STONE_BRICKS: (Internal.InfestedBlock) & (Internal.Block);
    static POTTED_RED_TULIP: (Internal.FlowerPotBlock) & (Internal.Block);
    static RED_TULIP: (Internal.FlowerBlock) & (Internal.Block);
    static BAMBOO_PLANKS: (Internal.Block) & (Internal.Block);
    static BIRCH_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static JUNGLE_TRAPDOOR: (Internal.TrapDoorBlock) & (Internal.Block);
    static GREEN_GLAZED_TERRACOTTA: (Internal.GlazedTerracottaBlock) & (Internal.Block);
    static BEACON: (Internal.BeaconBlock) & (Internal.Block);
    static DEEPSLATE_LAPIS_ORE: (Internal.DropExperienceBlock) & (Internal.Block);
    static OAK_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static BIRCH_FENCE: (Internal.FenceBlock) & (Internal.Block);
    static SANDSTONE: (Internal.Block) & (Internal.Block);
    static SNOW_BLOCK: (Internal.Block) & (Internal.Block);
    static BLACK_BED: (Internal.BedBlock) & (Internal.Block);
    static BROWN_STAINED_GLASS: (Internal.StainedGlassBlock) & (Internal.Block);
    static POTTED_DEAD_BUSH: (Internal.FlowerPotBlock) & (Internal.Block);
    static STRIPPED_CHERRY_WOOD: (Internal.RotatedPillarBlock) & (Internal.Block);
    static GRANITE_STAIRS: (Internal.StairBlock) & (Internal.Block);
    static DEEPSLATE: (Internal.RotatedPillarBlock) & (Internal.Block);
    static DARK_OAK_BUTTON: (Internal.ButtonBlock) & (Internal.Block);
    static WHITE_CONCRETE_POWDER: (Internal.ConcretePowderBlock) & (Internal.Block);
    static DEAD_HORN_CORAL_WALL_FAN: (Internal.BaseCoralWallFanBlock) & (Internal.Block);
    static BAMBOO_PRESSURE_PLATE: (Internal.PressurePlateBlock) & (Internal.Block);
    static INFESTED_COBBLESTONE: (Internal.InfestedBlock) & (Internal.Block);
}
type Blocks_ = Blocks;
declare interface BlockStatePredicate extends Internal.ReplacementMatch, Internal.Predicate<Internal.BlockState> {
    fromString(s: string): this;
    ruleTestOf(o: any): Internal.RuleTest;
    asRuleTest(): Internal.RuleTest;
    getBlockIds(): Internal.Set<ResourceLocation>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    check(targetStates: Internal.List_<Internal.OreConfiguration$TargetBlockState>): boolean;
    abstract test(arg0: Internal.BlockState_): boolean;
    getBlockStates(): Internal.Collection<Internal.BlockState>;
    getBlocks(): Internal.Collection<Internal.Block>;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    testBlock(block: Internal.Block_): boolean;
    of(o: BlockStatePredicate_): this;
    test(arg0: any): boolean;
    and(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    abstract "test(net.minecraft.world.level.block.state.BlockState)"(arg0: Internal.BlockState_): boolean;
    negate(): Internal.Predicate<Internal.BlockState>;
    or(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    "test(java.lang.Object)"(arg0: any): boolean;
    get blockIds(): Internal.Set<ResourceLocation>
    get blockStates(): Internal.Collection<Internal.BlockState>
    get blocks(): Internal.Collection<Internal.Block>
    readonly AIR_ID: (ResourceLocation) & (ResourceLocation);
}
type BlockStatePredicate_ = RegExp | "-" | `#${Special.BlockTag}` | BlockStatePredicate_[] | Internal.Block_ | Internal.BlockState_ | "*" | BlockStatePredicate | {not?: BlockStatePredicate_, or?: BlockStatePredicate_};
declare const BlockStatePredicate: BlockStatePredicate;
declare class KMath {
    constructor()
    getClass(): typeof any;
    static block(x: number, y: number, z: number): BlockPos;
    static deg(value: number): number;
    static v3d(x: number, y: number, z: number): Internal.Vector3d;
    static ceil(value: number): number;
    static map(value: number, min0: number, max0: number, min1: number, max1: number): number;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static clamp(value: number, min: number, max: number): number;
    static v4f(x: number, y: number, z: number, w: number): Vec4f;
    static rad(value: number): number;
    static degreesDifference(current: number, target: number): number;
    static floor(value: number): number;
    static lerp(value: number, min: number, max: number): number;
    static v3f(x: number, y: number, z: number): Vec3f;
    toString(): string;
    notifyAll(): void;
    static rotateIfNecessary(current: number, target: number, max: number): number;
    static m4f(): Matrix4f;
    static v3(x: number, y: number, z: number): Vec3d;
    static quaternion(x: number, y: number, z: number, w: number): Quaternionf;
    hashCode(): number;
    static wrapDegrees(d: number): number;
    static m3f(): Matrix3f;
    wait(): void;
    static approachDegrees(current: number, target: number, speed: number): number;
    static clampedLerp(value: number, min: number, max: number): number;
    wait(arg0: number): void;
    static approach(current: number, target: number, speed: number): number;
    equals(arg0: any): boolean;
    static isPowerOfTwo(value: number): boolean;
    get class(): typeof any
    static readonly PI: (3.141592653589793) & (number);
    static readonly RADIANS_TO_DEGREES: (57.29577951308232) & (number);
    static readonly DEGREES_TO_RADIANS: (0.017453292519943295) & (number);
    static readonly E: (2.718281828459045) & (number);
}
type KMath_ = KMath;
declare class Items {
    constructor()
    getClass(): typeof any;
    toString(): string;
    static registerBlock(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    notifyAll(): void;
    static "registerItem(net.minecraft.resources.ResourceKey,net.minecraft.world.item.Item)"(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    static "registerItem(net.minecraft.resources.ResourceLocation,net.minecraft.world.item.Item)"(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static registerBlock(arg0: Internal.Block_): Internal.Item;
    static "registerBlock(net.minecraft.world.level.block.Block,net.minecraft.world.item.Item)"(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    static "registerBlock(net.minecraft.world.item.BlockItem)"(arg0: Internal.BlockItem_): Internal.Item;
    static registerItem(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    static "registerBlock(net.minecraft.world.level.block.Block)"(arg0: Internal.Block_): Internal.Item;
    static registerItem(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static "registerItem(java.lang.String,net.minecraft.world.item.Item)"(arg0: string, arg1: Internal.Item_): Internal.Item;
    wait(): void;
    static registerBlock(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    wait(arg0: number): void;
    static registerItem(arg0: string, arg1: Internal.Item_): Internal.Item;
    equals(arg0: any): boolean;
    static registerBlock(arg0: Internal.BlockItem_): Internal.Item;
    static "registerBlock(net.minecraft.world.level.block.Block,net.minecraft.world.level.block.Block[])"(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    get class(): typeof any
    static POWERED_RAIL: (Internal.BlockItem) & (Internal.Item);
    static GUARDIAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ: (Internal.Item) & (Internal.Item);
    static TUBE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static TURTLE_EGG: (Internal.BlockItem) & (Internal.Item);
    static HANGING_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static CYAN_DYE: (Internal.DyeItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_DEEPSLATE_TILES: (Internal.BlockItem) & (Internal.Item);
    static OAK_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_ROD: (Internal.Item) & (Internal.Item);
    static GRASS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DRIED_KELP: (Internal.Item) & (Internal.Item);
    static TURTLE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GRAY_BANNER: (Internal.BannerItem) & (Internal.Item);
    static MAGENTA_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FUNGUS: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BEETROOT: (Internal.Item) & (Internal.Item);
    static LIGHT_GRAY_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GRAY_BED: (Internal.BedItem) & (Internal.Item);
    static MUDDY_MANGROVE_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static OAK_SIGN: (Internal.SignItem) & (Internal.Item);
    static ACACIA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHAIN: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_DYE: (Internal.DyeItem) & (Internal.Item);
    static STRIPPED_SPRUCE_LOG: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static DEBUG_STICK: (Internal.DebugStickItem) & (Internal.Item);
    static DUNE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static MUSIC_DISC_CAT: (Internal.RecordItem) & (Internal.Item);
    static GOLDEN_SWORD: (Internal.SwordItem) & (Internal.Item);
    static VERDANT_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static WARPED_NYLIUM: (Internal.BlockItem) & (Internal.Item);
    static TIPPED_ARROW: (Internal.TippedArrowItem) & (Internal.Item);
    static MILK_BUCKET: (Internal.MilkBucketItem) & (Internal.Item);
    static LAPIS_ORE: (Internal.BlockItem) & (Internal.Item);
    static WEEPING_VINES: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TORCHFLOWER: (Internal.BlockItem) & (Internal.Item);
    static LODESTONE: (Internal.BlockItem) & (Internal.Item);
    static IRON_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static MANGROVE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static INFESTED_STONE: (Internal.BlockItem) & (Internal.Item);
    static OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_QUARTZ: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BRUSH: (Internal.BrushItem) & (Internal.Item);
    static END_PORTAL_FRAME: (Internal.BlockItem) & (Internal.Item);
    static AZURE_BLUET: (Internal.BlockItem) & (Internal.Item);
    static NETHER_QUARTZ_ORE: (Internal.BlockItem) & (Internal.Item);
    static COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static SPRUCE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static PUMPKIN: (Internal.BlockItem) & (Internal.Item);
    static COBWEB: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CARROT: (Internal.ItemNameBlockItem) & (Internal.Item);
    static GOLDEN_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static BLACKSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static SUNFLOWER: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static COPPER_ORE: (Internal.BlockItem) & (Internal.Item);
    static CHEST: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_GRANITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static SKELETON_SKULL: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static RESPAWN_ANCHOR: (Internal.BlockItem) & (Internal.Item);
    static BUCKET: (Internal.BucketItem) & (Internal.Item);
    static ZOMBIFIED_PIGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GLASS: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static FIRE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static LAVA_BUCKET: (Internal.BucketItem) & (Internal.Item);
    static ENDER_PEARL: (Internal.EnderpearlItem) & (Internal.Item);
    static DRIED_KELP_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WILD_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static JUNGLE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BOOKSHELF: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static COBBLESTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static TWISTING_VINES: (Internal.BlockItem) & (Internal.Item);
    static GRINDSTONE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static PHANTOM_MEMBRANE: (Internal.Item) & (Internal.Item);
    static BRICK: (Internal.Item) & (Internal.Item);
    static ARCHER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static JUNGLE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static TINTED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static OAK_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static FLOWERING_AZALEA: (Internal.BlockItem) & (Internal.Item);
    static POPPED_CHORUS_FRUIT: (Internal.Item) & (Internal.Item);
    static PRISMARINE_CRYSTALS: (Internal.Item) & (Internal.Item);
    static LAPIS_LAZULI: (Internal.Item) & (Internal.Item);
    static SQUID_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_INGOT: (Internal.Item) & (Internal.Item);
    static DEEPSLATE_EMERALD_ORE: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static NETHERITE_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static CHICKEN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BEEHIVE: (Internal.BlockItem) & (Internal.Item);
    static SPYGLASS: (Internal.SpyglassItem) & (Internal.Item);
    static NETHERITE_AXE: (Internal.AxeItem) & (Internal.Item);
    static ELDER_GUARDIAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BLUE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static MULE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ORANGE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static FIREWORK_STAR: (Internal.FireworkStarItem) & (Internal.Item);
    static SPIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static SKULL_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static FROG_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DIRT: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static WOODEN_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static GLOWSTONE_DUST: (Internal.Item) & (Internal.Item);
    static ITEM_FRAME: (Internal.ItemFrameItem) & (Internal.Item);
    static MUSIC_DISC_RELIC: (Internal.RecordItem) & (Internal.Item);
    static SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_FENCE: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE: (Internal.ItemNameBlockItem) & (Internal.Item);
    static CARROT_ON_A_STICK: Internal.Item;
    static SOUL_TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static LIME_CARPET: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static SUGAR_CANE: (Internal.BlockItem) & (Internal.Item);
    static COMMAND_BLOCK_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static SMOOTH_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHEST_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static SCUTE: (Internal.Item) & (Internal.Item);
    static FEATHER: (Internal.Item) & (Internal.Item);
    static JUNGLE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CUT_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_QUARTZ_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WHITE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static COPPER_INGOT: (Internal.Item) & (Internal.Item);
    static SWEET_BERRIES: (Internal.ItemNameBlockItem) & (Internal.Item);
    static GREEN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BUBBLE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BELL: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PITCHER_POD: (Internal.ItemNameBlockItem) & (Internal.Item);
    static BLACK_DYE: (Internal.DyeItem) & (Internal.Item);
    static WHITE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static DETECTOR_RAIL: (Internal.BlockItem) & (Internal.Item);
    static TIDE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static LIME_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static PIGLIN_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static CHORUS_FLOWER: (Internal.BlockItem) & (Internal.Item);
    static WARPED_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static WARDEN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHISELED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SNOWBALL: (Internal.SnowballItem) & (Internal.Item);
    static LANTERN: (Internal.BlockItem) & (Internal.Item);
    static CYAN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static MAP: (Internal.EmptyMapItem) & (Internal.Item);
    static WHITE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_COPPER_ORE: (Internal.BlockItem) & (Internal.Item);
    static CUT_STANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BLAST_FURNACE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static CYAN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static IRON_INGOT: (Internal.Item) & (Internal.Item);
    static PINK_BANNER: (Internal.BannerItem) & (Internal.Item);
    static MAGMA_CUBE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WHITE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static TRADER_LLAMA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static TNT: (Internal.BlockItem) & (Internal.Item);
    static OAK_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static CHERRY_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_FENCE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_BANNER: (Internal.BannerItem) & (Internal.Item);
    static ROTTEN_FLESH: (Internal.Item) & (Internal.Item);
    static RIB_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WRITTEN_BOOK: (Internal.WrittenBookItem) & (Internal.Item);
    static DISC_FRAGMENT_5: (Internal.DiscFragmentItem) & (Internal.Item);
    static SNIFFER_EGG: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_DYE: (Internal.DyeItem) & (Internal.Item);
    static CLAY: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static BRAIN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static SPAWNER: (Internal.BlockItem) & (Internal.Item);
    static LIME_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SCRAP: (Internal.Item) & (Internal.Item);
    static NETHER_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static STONE: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SKELETON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static AMETHYST_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static HOGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ZOGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIME_DYE: (Internal.DyeItem) & (Internal.Item);
    static IRON_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MAGENTA_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PETRIFIED_OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_SHARD: (Internal.Item) & (Internal.Item);
    static NETHER_GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BASALT: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CHERRY_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static SANDSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static ENDER_DRAGON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STRIPPED_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_GRANITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_GOLD_ORE: (Internal.BlockItem) & (Internal.Item);
    static OBSERVER: (Internal.BlockItem) & (Internal.Item);
    static GRAY_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_SWORD: (Internal.SwordItem) & (Internal.Item);
    static FOX_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHERRY_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_WOOL: (Internal.BlockItem) & (Internal.Item);
    static CALCITE: (Internal.BlockItem) & (Internal.Item);
    static PUMPKIN_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static FERMENTED_SPIDER_EYE: (Internal.Item) & (Internal.Item);
    static HEART_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static PURPLE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static MUTTON: (Internal.Item) & (Internal.Item);
    static PURPLE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static ZOMBIE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSIC_DISC_PIGSTEP: (Internal.RecordItem) & (Internal.Item);
    static REDSTONE_TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static LEATHER_LEGGINGS: (Internal.DyeableArmorItem) & (Internal.Item);
    static PIGLIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static RED_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static COD: (Internal.Item) & (Internal.Item);
    static MUSIC_DISC_11: (Internal.RecordItem) & (Internal.Item);
    static AZALEA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static NETHER_WART: (Internal.ItemNameBlockItem) & (Internal.Item);
    static NAME_TAG: (Internal.NameTagItem) & (Internal.Item);
    static CYAN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static JACK_O_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static WARPED_SLAB: (Internal.BlockItem) & (Internal.Item);
    static FURNACE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CARPET: (Internal.BlockItem) & (Internal.Item);
    static POWDER_SNOW_BUCKET: (Internal.SolidBucketItem) & (Internal.Item);
    static BUBBLE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static WHITE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static BOOK: (Internal.BookItem) & (Internal.Item);
    static RED_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static DARK_PRISMARINE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CRIMSON_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_BED: (Internal.BedItem) & (Internal.Item);
    static EMERALD_ORE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static COD_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DIAMOND: (Internal.Item) & (Internal.Item);
    static AZALEA: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static SPRUCE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MELON_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static WEATHERED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CANDLE: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSIC_DISC_13: (Internal.RecordItem) & (Internal.Item);
    static LIGHT_GRAY_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_WOOD: (Internal.BlockItem) & (Internal.Item);
    static FLOWER_POT: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_WOOD: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FENCE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_POLISHED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static SEA_PICKLE: (Internal.BlockItem) & (Internal.Item);
    static LARGE_FERN: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static AMETHYST_SHARD: (Internal.Item) & (Internal.Item);
    static CHICKEN: (Internal.Item) & (Internal.Item);
    static GRAY_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static TOTEM_OF_UNDYING: (Internal.Item) & (Internal.Item);
    static STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static GREEN_BED: (Internal.BedItem) & (Internal.Item);
    static DROPPER: (Internal.BlockItem) & (Internal.Item);
    static LIME_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static KNOWLEDGE_BOOK: (Internal.KnowledgeBookItem) & (Internal.Item);
    static LOOM: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static FISHING_ROD: (Internal.FishingRodItem) & (Internal.Item);
    static BROWN_DYE: (Internal.DyeItem) & (Internal.Item);
    static MEDIUM_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static ROOTED_DIRT: (Internal.BlockItem) & (Internal.Item);
    static SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static WARPED_STEM: (Internal.BlockItem) & (Internal.Item);
    static SHEAF_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RED_SAND: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SHEARS: (Internal.ShearsItem) & (Internal.Item);
    static PANDA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static POTATO: (Internal.ItemNameBlockItem) & (Internal.Item);
    static LAPIS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static COMPOSTER: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static TROPICAL_FISH: (Internal.Item) & (Internal.Item);
    static POTION: (Internal.PotionItem) & (Internal.Item);
    static MANGROVE_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static JIGSAW: (Internal.GameMasterBlockItem) & (Internal.Item);
    static PRISMARINE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static TROPICAL_FISH_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static WARPED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static LIGHT_BLUE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_CHESTPLATE: (Internal.DyeableArmorItem) & (Internal.Item);
    static RED_BED: (Internal.BedItem) & (Internal.Item);
    static STONE_HOE: (Internal.HoeItem) & (Internal.Item);
    static JUNGLE_LOG: (Internal.BlockItem) & (Internal.Item);
    static GLOW_SQUID_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static EYE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static BROWN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PUFFERFISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static GREEN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static BREAD: (Internal.Item) & (Internal.Item);
    static COOKED_CHICKEN: (Internal.Item) & (Internal.Item);
    static BIRCH_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_SLAB: (Internal.BlockItem) & (Internal.Item);
    static GOLD_NUGGET: (Internal.Item) & (Internal.Item);
    static PHANTOM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WAXED_WEATHERED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static WHEAT_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static DEEPSLATE_TILES: (Internal.BlockItem) & (Internal.Item);
    static PORKCHOP: (Internal.Item) & (Internal.Item);
    static SCAFFOLDING: (Internal.ScaffoldingBlockItem) & (Internal.Item);
    static END_ROD: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE: (Internal.BlockItem) & (Internal.Item);
    static PACKED_MUD: (Internal.BlockItem) & (Internal.Item);
    static STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static REINFORCED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static LILY_OF_THE_VALLEY: (Internal.BlockItem) & (Internal.Item);
    static VILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STONE_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static PARROT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WHEAT: (Internal.Item) & (Internal.Item);
    static JUNGLE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_AXE: (Internal.AxeItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static NETHERRACK: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static GRAY_WOOL: (Internal.BlockItem) & (Internal.Item);
    static COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WEATHERED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_PILLAR: (Internal.BlockItem) & (Internal.Item);
    static STONE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_NETHER_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CAKE: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static FARMLAND: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static PUMPKIN_PIE: (Internal.Item) & (Internal.Item);
    static SHULKER_SHELL: (Internal.Item) & (Internal.Item);
    static OAK_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static RABBIT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIGHT_WEIGHTED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static APPLE: (Internal.Item) & (Internal.Item);
    static DIAMOND_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WARPED_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_LOG: (Internal.BlockItem) & (Internal.Item);
    static ELYTRA: (Internal.ElytraItem) & (Internal.Item);
    static WARPED_SIGN: (Internal.SignItem) & (Internal.Item);
    static GREEN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static BEE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PINK_DYE: (Internal.DyeItem) & (Internal.Item);
    static PLAYER_HEAD: (Internal.PlayerHeadItem) & (Internal.Item);
    static GLOW_LICHEN: (Internal.BlockItem) & (Internal.Item);
    static STONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static ROSE_BUSH: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static GLOW_ITEM_FRAME: (Internal.ItemFrameItem) & (Internal.Item);
    static WHITE_TULIP: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static OBSIDIAN: (Internal.BlockItem) & (Internal.Item);
    static BLADE_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static EGG: (Internal.EggItem) & (Internal.Item);
    static WITCH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static OCELOT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static HORN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHER_SPROUTS: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static TALL_GRASS: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BLACK_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SPIDER_EYE: (Internal.Item) & (Internal.Item);
    static FILLED_MAP: (Internal.MapItem) & (Internal.Item);
    static MUD_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static AXOLOTL_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static ZOMBIE_HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DARK_PRISMARINE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_SIGN: (Internal.SignItem) & (Internal.Item);
    static STRIPPED_JUNGLE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static MUSHROOM_STEM: (Internal.BlockItem) & (Internal.Item);
    static LILAC: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BAMBOO_RAFT: (Internal.BoatItem) & (Internal.Item);
    static SUSPICIOUS_STEW: (Internal.SuspiciousStewItem) & (Internal.Item);
    static SUSPICIOUS_GRAVEL: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static IRON_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_DEEPSLATE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SHULKER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static LIGHT_GRAY_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MELON_SLICE: (Internal.Item) & (Internal.Item);
    static HONEYCOMB_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static PEARLESCENT_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static ANCIENT_DEBRIS: (Internal.BlockItem) & (Internal.Item);
    static HOPPER_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static MAGMA_CREAM: (Internal.Item) & (Internal.Item);
    static ZOMBIE_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static POLISHED_GRANITE: (Internal.BlockItem) & (Internal.Item);
    static PINK_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static HONEYCOMB: (Internal.HoneycombItem) & (Internal.Item);
    static NOTE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static RED_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static FURNACE_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static DRAGON_BREATH: (Internal.Item) & (Internal.Item);
    static CYAN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static CHORUS_PLANT: (Internal.BlockItem) & (Internal.Item);
    static WAXED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static TURTLE_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static DARK_OAK_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static COAL_ORE: (Internal.BlockItem) & (Internal.Item);
    static COAL: (Internal.Item) & (Internal.Item);
    static COAST_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static GRAY_CARPET: (Internal.BlockItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DANGER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static GREEN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static BARREL: (Internal.BlockItem) & (Internal.Item);
    static RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WHITE_DYE: (Internal.DyeItem) & (Internal.Item);
    static ORANGE_DYE: (Internal.DyeItem) & (Internal.Item);
    static ENCHANTED_BOOK: (Internal.EnchantedBookItem) & (Internal.Item);
    static SOUL_SOIL: (Internal.BlockItem) & (Internal.Item);
    static IRON_NUGGET: (Internal.Item) & (Internal.Item);
    static ENDERMITE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHERITE_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static LEVER: (Internal.BlockItem) & (Internal.Item);
    static COOKED_SALMON: (Internal.Item) & (Internal.Item);
    static CAULDRON: (Internal.Items$1) & (Internal.Item);
    static ALLIUM: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static EXPLORER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static POISONOUS_POTATO: (Internal.Item) & (Internal.Item);
    static FLOWER_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static SMOOTH_STONE: (Internal.BlockItem) & (Internal.Item);
    static WHITE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static SNORT_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_MUSHROOM_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GHAST_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHER_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static IRON_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static AXOLOTL_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ORANGE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SEA_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static STONE_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static LIME_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SHIELD: (Internal.ShieldItem) & (Internal.Item);
    static DIORITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static STONE_SWORD: (Internal.SwordItem) & (Internal.Item);
    static GOLDEN_HOE: (Internal.HoeItem) & (Internal.Item);
    static BLACK_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_ORE: (Internal.BlockItem) & (Internal.Item);
    static BLACK_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_DYE: (Internal.DyeItem) & (Internal.Item);
    static REPEATER: (Internal.BlockItem) & (Internal.Item);
    static SPECTRAL_ARROW: (Internal.SpectralArrowItem) & (Internal.Item);
    static CHERRY_SLAB: (Internal.BlockItem) & (Internal.Item);
    static LEAD: (Internal.LeadItem) & (Internal.Item);
    static WHITE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DEAD_TUBE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BROWN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static WAXED_OXIDIZED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static PINK_WOOL: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_BOAT: (Internal.BoatItem) & (Internal.Item);
    static BLACK_CARPET: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static BREWING_STAND: (Internal.BlockItem) & (Internal.Item);
    static BIG_DRIPLEAF: (Internal.Items$1) & (Internal.Item);
    static CARVED_PUMPKIN: (Internal.BlockItem) & (Internal.Item);
    static OAK_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static PINK_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DIORITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_BOAT: (Internal.BoatItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_WOOD: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_QUARTZ_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static END_STONE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_BED: (Internal.BedItem) & (Internal.Item);
    static LIGHT: (Internal.BlockItem) & (Internal.Item);
    static BONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DRIPSTONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WET_SPONGE: (Internal.BlockItem) & (Internal.Item);
    static FLINT: (Internal.Item) & (Internal.Item);
    static INFESTED_CHISELED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static GRAY_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static HUSK_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PINK_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_ICE: (Internal.BlockItem) & (Internal.Item);
    static JUKEBOX: (Internal.BlockItem) & (Internal.Item);
    static FIRE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static FIRE_CHARGE: (Internal.FireChargeItem) & (Internal.Item);
    static COOKED_MUTTON: (Internal.Item) & (Internal.Item);
    static BASALT: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static PIG_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MUSHROOM_STEW: (Internal.BowlFoodItem) & (Internal.Item);
    static PURPLE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static HOWL_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static SMALL_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static WEATHERED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static RED_WOOL: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_PROPAGULE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static PAPER: (Internal.Item) & (Internal.Item);
    static IRON_HOE: (Internal.HoeItem) & (Internal.Item);
    static MAGENTA_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static STICKY_PISTON: (Internal.BlockItem) & (Internal.Item);
    static COMPASS: (Internal.CompassItem) & (Internal.Item);
    static RED_SANDSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static DARK_PRISMARINE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static CLAY_BALL: (Internal.Item) & (Internal.Item);
    static CYAN_WOOL: (Internal.BlockItem) & (Internal.Item);
    static STONECUTTER: (Internal.BlockItem) & (Internal.Item);
    static MINECART: (Internal.MinecartItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RED_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static SHELTER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static AIR: (Internal.AirItem) & (Internal.Item);
    static SEAGRASS: (Internal.BlockItem) & (Internal.Item);
    static GLOWSTONE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_BED: (Internal.BedItem) & (Internal.Item);
    static ANVIL: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static RAW_COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_SIGN: (Internal.SignItem) & (Internal.Item);
    static MAGENTA_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SKELETON_SKULL: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DONKEY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static WAXED_COPPER_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ENCHANTED_GOLDEN_APPLE: (Internal.EnchantedGoldenAppleItem) & (Internal.Item);
    static MANGROVE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MUD: (Internal.BlockItem) & (Internal.Item);
    static OAK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static GOAT_HORN: (Internal.InstrumentItem) & (Internal.Item);
    static HOST_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CAVE_SPIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static QUARTZ_PILLAR: (Internal.BlockItem) & (Internal.Item);
    static DEAD_FIRE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static SUGAR: (Internal.Item) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BROWN_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static SCULK_VEIN: (Internal.BlockItem) & (Internal.Item);
    static FLETCHING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_MOSSY_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static BROWN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PINK_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PLENTY_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RED_CARPET: (Internal.BlockItem) & (Internal.Item);
    static CLOCK: (Internal.Item) & (Internal.Item);
    static GRAY_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static EMERALD: (Internal.Item) & (Internal.Item);
    static DEEPSLATE_DIAMOND_ORE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BROWN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static KELP: (Internal.BlockItem) & (Internal.Item);
    static WITHER_ROSE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static TADPOLE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OAK_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static SPRUCE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static CRAFTING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static BAKED_POTATO: (Internal.Item) & (Internal.Item);
    static MANGROVE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CYAN_BED: (Internal.BedItem) & (Internal.Item);
    static CHISELED_BOOKSHELF: (Internal.BlockItem) & (Internal.Item);
    static NAUTILUS_SHELL: (Internal.Item) & (Internal.Item);
    static SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STICK: (Internal.Item) & (Internal.Item);
    static HEAVY_WEIGHTED_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static COARSE_DIRT: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_SLAB: (Internal.BlockItem) & (Internal.Item);
    static SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static LIGHTNING_ROD: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_FENCE: (Internal.BlockItem) & (Internal.Item);
    static POLAR_BEAR_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ACACIA_LOG: (Internal.BlockItem) & (Internal.Item);
    static MOJANG_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static DEEPSLATE_REDSTONE_ORE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static ENCHANTING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_ANDESITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PINK_CARPET: (Internal.BlockItem) & (Internal.Item);
    static BREWER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static DIORITE: (Internal.BlockItem) & (Internal.Item);
    static RED_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static GRAY_DYE: (Internal.DyeItem) & (Internal.Item);
    static LIGHT_GRAY_BED: (Internal.BedItem) & (Internal.Item);
    static BAMBOO_SIGN: (Internal.SignItem) & (Internal.Item);
    static IRON_ORE: (Internal.BlockItem) & (Internal.Item);
    static SCULK_SENSOR: (Internal.BlockItem) & (Internal.Item);
    static BUNDLE: (Internal.BundleItem) & (Internal.Item);
    static STRING: (Internal.ItemNameBlockItem) & (Internal.Item);
    static STRIPPED_JUNGLE_LOG: (Internal.BlockItem) & (Internal.Item);
    static END_CRYSTAL: (Internal.EndCrystalItem) & (Internal.Item);
    static LEATHER_BOOTS: (Internal.DyeableArmorItem) & (Internal.Item);
    static SLIME_BALL: (Internal.Item) & (Internal.Item);
    static ORANGE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_IRON_ORE: (Internal.BlockItem) & (Internal.Item);
    static BOW: (Internal.BowItem) & (Internal.Item);
    static ORANGE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_ORCHID: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static LLAMA_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CAMPFIRE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BUBBLE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static RED_MUSHROOM: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static SAND: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_HOE: (Internal.HoeItem) & (Internal.Item);
    static RED_MUSHROOM_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static MYCELIUM: (Internal.BlockItem) & (Internal.Item);
    static PINK_TULIP: (Internal.BlockItem) & (Internal.Item);
    static PINK_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GOAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static INFESTED_CRACKED_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static RABBIT: (Internal.Item) & (Internal.Item);
    static PRISMARINE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE_LAMP: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static TUBE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static MANGROVE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static LIME_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static STRIPPED_ACACIA_WOOD: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static ARMOR_STAND: (Internal.ArmorStandItem) & (Internal.Item);
    static CHERRY_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static BROWN_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static STONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static MANGROVE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static PRISMARINE_WALL: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_BANNER: (Internal.BannerItem) & (Internal.Item);
    static RED_NETHER_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static IRON_GOLEM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CRIMSON_NYLIUM: (Internal.BlockItem) & (Internal.Item);
    static FIRE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static EXPERIENCE_BOTTLE: (Internal.ExperienceBottleItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static RED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static SMITHING_TABLE: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_SIGN: (Internal.SignItem) & (Internal.Item);
    static YELLOW_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static VEX_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static PIGLIN_BRUTE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GRAY_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static COBBLESTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLAZE_POWDER: (Internal.Item) & (Internal.Item);
    static MUSIC_DISC_MALL: (Internal.RecordItem) & (Internal.Item);
    static LARGE_AMETHYST_BUD: (Internal.BlockItem) & (Internal.Item);
    static BRICKS: (Internal.BlockItem) & (Internal.Item);
    static BUDDING_AMETHYST: (Internal.BlockItem) & (Internal.Item);
    static RABBIT_FOOT: (Internal.Item) & (Internal.Item);
    static BAMBOO_MOSAIC: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_COBBLESTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SKULL_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static ACACIA_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static BURN_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static BEACON: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_SPRUCE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static OAK_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CRIMSON_STEM: (Internal.BlockItem) & (Internal.Item);
    static GLOW_INK_SAC: (Internal.GlowInkSacItem) & (Internal.Item);
    static CYAN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CAMEL_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static POLISHED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static GRASS: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BROWN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_CHIRP: (Internal.RecordItem) & (Internal.Item);
    static MUSIC_DISC_FAR: (Internal.RecordItem) & (Internal.Item);
    static RED_SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_WALL: (Internal.BlockItem) & (Internal.Item);
    static BLUE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static WOODEN_AXE: (Internal.AxeItem) & (Internal.Item);
    static SPORE_BLOSSOM: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BRAIN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CROSSBOW: (Internal.CrossbowItem) & (Internal.Item);
    static BAMBOO_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static HORN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static ORANGE_TULIP: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static GREEN_CARPET: (Internal.BlockItem) & (Internal.Item);
    static SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static OXIDIZED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RABBIT_HIDE: (Internal.Item) & (Internal.Item);
    static COOKED_COD: (Internal.Item) & (Internal.Item);
    static BLACK_BED: (Internal.BedItem) & (Internal.Item);
    static PUFFERFISH: (Internal.Item) & (Internal.Item);
    static ENDER_EYE: (Internal.EnderEyeItem) & (Internal.Item);
    static INFESTED_COBBLESTONE: (Internal.BlockItem) & (Internal.Item);
    static GOLD_INGOT: (Internal.Item) & (Internal.Item);
    static VEX_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static STRIPPED_MANGROVE_LOG: (Internal.BlockItem) & (Internal.Item);
    static ICE: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_MOSAIC_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BLACK_BANNER: (Internal.BannerItem) & (Internal.Item);
    static OAK_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static LIME_BANNER: (Internal.BannerItem) & (Internal.Item);
    static PINK_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static SMALL_DRIPLEAF: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static LILY_PAD: (Internal.PlaceOnWaterBlockItem) & (Internal.Item);
    static CREEPER_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static GLOW_BERRIES: (Internal.ItemNameBlockItem) & (Internal.Item);
    static HOPPER: (Internal.BlockItem) & (Internal.Item);
    static PUFFERFISH_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static PURPLE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static HAY_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static HEART_OF_THE_SEA: (Internal.Item) & (Internal.Item);
    static WARD_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WARPED_WART_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_SWORD: (Internal.SwordItem) & (Internal.Item);
    static SHEEP_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ANGLER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static PODZOL: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_HOE: (Internal.HoeItem) & (Internal.Item);
    static GRAY_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_WARPED_STEM: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SIGN: (Internal.SignItem) & (Internal.Item);
    static RABBIT_STEW: (Internal.BowlFoodItem) & (Internal.Item);
    static DEAD_TUBE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DECORATED_POT: (Internal.BlockItem) & (Internal.Item);
    static OAK_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static LIME_BED: (Internal.BedItem) & (Internal.Item);
    static TUFF: (Internal.BlockItem) & (Internal.Item);
    static GRAVEL: (Internal.BlockItem) & (Internal.Item);
    static BARRIER: (Internal.BlockItem) & (Internal.Item);
    static DRAGON_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static MUSIC_DISC_MELLOHI: (Internal.RecordItem) & (Internal.Item);
    static IRON_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static VINDICATOR_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SMOOTH_BASALT: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static DEAD_HORN_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static DROWNED_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHER_STAR: (Internal.SimpleFoiledItem) & (Internal.Item);
    static CRIMSON_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static FLINT_AND_STEEL: (Internal.FlintAndSteelItem) & (Internal.Item);
    static MAGENTA_BED: (Internal.BedItem) & (Internal.Item);
    static BONE: (Internal.Item) & (Internal.Item);
    static BROWN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CALIBRATED_SCULK_SENSOR: (Internal.BlockItem) & (Internal.Item);
    static COMPARATOR: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_HORSE_ARMOR: (Internal.DyeableHorseArmorItem) & (Internal.Item);
    static STRIPPED_BAMBOO_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DIORITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static MOSS_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CREEPER_HEAD: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static JUNGLE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static BLACK_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static COOKIE: (Internal.Item) & (Internal.Item);
    static GRANITE: (Internal.BlockItem) & (Internal.Item);
    static LEATHER: (Internal.Item) & (Internal.Item);
    static SALMON_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static DANDELION: (Internal.BlockItem) & (Internal.Item);
    static WARPED_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static PRISMARINE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static IRON_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static IRON_SWORD: (Internal.SwordItem) & (Internal.Item);
    static BONE_MEAL: (Internal.BoneMealItem) & (Internal.Item);
    static GRAY_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static DEAD_FIRE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POINTED_DRIPSTONE: (Internal.BlockItem) & (Internal.Item);
    static PURPUR_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BIRCH_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static ALLAY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static COW_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ARMS_UP_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BLUE_WOOL: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_BLUE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_WARD: (Internal.RecordItem) & (Internal.Item);
    static PINK_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static BLUE_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHORUS_FRUIT: (Internal.ChorusFruitItem) & (Internal.Item);
    static VINE: (Internal.BlockItem) & (Internal.Item);
    static COAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_WALL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_OTHERSIDE: (Internal.RecordItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SNOW_GOLEM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SCULK: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_ANDESITE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_SIGN: (Internal.SignItem) & (Internal.Item);
    static COCOA_BEANS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static CYAN_STAINED_GLASS: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static PURPLE_DYE: (Internal.DyeItem) & (Internal.Item);
    static CYAN_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static GLOBE_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static SPRUCE_LOG: (Internal.BlockItem) & (Internal.Item);
    static TUBE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static EXPOSED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static GREEN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CONDUIT: (Internal.BlockItem) & (Internal.Item);
    static GLISTERING_MELON_SLICE: (Internal.Item) & (Internal.Item);
    static RAVAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SKELETON_HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BRAIN_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO: (Internal.BlockItem) & (Internal.Item);
    static COOKED_PORKCHOP: (Internal.Item) & (Internal.Item);
    static GOLDEN_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static CUT_RED_SANDSTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static BAMBOO_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SMOOTH_STONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static IRON_LEGGINGS: (Internal.ArmorItem) & (Internal.Item);
    static SMOKER: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_BIRCH_WOOD: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_BOAT: (Internal.BoatItem) & (Internal.Item);
    static MOSS_CARPET: (Internal.BlockItem) & (Internal.Item);
    static FIREWORK_ROCKET: (Internal.FireworkRocketItem) & (Internal.Item);
    static OCHRE_FROGLIGHT: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static NETHER_BRICK_FENCE: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static TADPOLE_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static DRAGON_EGG: (Internal.BlockItem) & (Internal.Item);
    static PRIZE_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static DARK_OAK_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static COOKED_RABBIT: (Internal.Item) & (Internal.Item);
    static CHERRY_BOAT: (Internal.BoatItem) & (Internal.Item);
    static END_STONE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static GREEN_DYE: (Internal.DyeItem) & (Internal.Item);
    static MUSIC_DISC_WAIT: (Internal.RecordItem) & (Internal.Item);
    static RED_NETHER_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static PITCHER_PLANT: (Internal.BlockItem) & (Internal.Item);
    static LIME_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static AMETHYST_CLUSTER: (Internal.BlockItem) & (Internal.Item);
    static CHISELED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_COAL_ORE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_MANGROVE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static STONE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static RED_DYE: (Internal.DyeItem) & (Internal.Item);
    static SPLASH_POTION: (Internal.SplashPotionItem) & (Internal.Item);
    static PURPLE_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static STRIDER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OXEYE_DAISY: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static PINK_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CHERRY_WOOD: (Internal.BlockItem) & (Internal.Item);
    static REPEATING_COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static CHERRY_SIGN: (Internal.SignItem) & (Internal.Item);
    static CRYING_OBSIDIAN: (Internal.BlockItem) & (Internal.Item);
    static RAISER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static CREEPER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BAMBOO_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static SCULK_SHRIEKER: (Internal.BlockItem) & (Internal.Item);
    static GOLDEN_HORSE_ARMOR: (Internal.HorseArmorItem) & (Internal.Item);
    static POLISHED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static LIGHT_GRAY_WOOL: (Internal.BlockItem) & (Internal.Item);
    static PINK_PETALS: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_DYE: (Internal.DyeItem) & (Internal.Item);
    static CRIMSON_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static PURPLE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static WITHER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BEETROOT_SOUP: (Internal.BowlFoodItem) & (Internal.Item);
    static CRIMSON_ROOTS: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static FLOWERING_AZALEA_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static OAK_BOAT: (Internal.BoatItem) & (Internal.Item);
    static POLISHED_ANDESITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BROWN_BED: (Internal.BedItem) & (Internal.Item);
    static BLUE_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_CRIMSON_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_DEEPSLATE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static TARGET: (Internal.BlockItem) & (Internal.Item);
    static SOUL_SAND: (Internal.BlockItem) & (Internal.Item);
    static DAYLIGHT_DETECTOR: (Internal.BlockItem) & (Internal.Item);
    static MOOSHROOM_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIGHT_BLUE_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static DAMAGED_ANVIL: (Internal.BlockItem) & (Internal.Item);
    static YELLOW_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static RAW_IRON_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static TROPICAL_FISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static BAMBOO_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static INK_SAC: (Internal.InkSacItem) & (Internal.Item);
    static LINGERING_POTION: (Internal.LingeringPotionItem) & (Internal.Item);
    static BRAIN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static GILDED_BLACKSTONE: (Internal.BlockItem) & (Internal.Item);
    static PRISMARINE: (Internal.BlockItem) & (Internal.Item);
    static SOUL_CAMPFIRE: (Internal.BlockItem) & (Internal.Item);
    static LECTERN: (Internal.BlockItem) & (Internal.Item);
    static SHROOMLIGHT: (Internal.BlockItem) & (Internal.Item);
    static GOLD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MUD_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_FENCE: (Internal.BlockItem) & (Internal.Item);
    static SNIFFER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CHERRY_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_LEAVES: (Internal.BlockItem) & (Internal.Item);
    static PAINTING: (Internal.HangingEntityItem) & (Internal.Item);
    static MANGROVE_HANGING_SIGN: (Internal.HangingSignItem) & (Internal.Item);
    static IRON_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ARROW: (Internal.ArrowItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_DARK_OAK_LOG: (Internal.BlockItem) & (Internal.Item);
    static WHITE_CARPET: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_STEM: (Internal.BlockItem) & (Internal.Item);
    static SOUL_LANTERN: (Internal.BlockItem) & (Internal.Item);
    static BLUE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static WRITABLE_BOOK: (Internal.WritableBookItem) & (Internal.Item);
    static PURPLE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static CUT_RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static LIME_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static STRAY_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static STRIPPED_BIRCH_LOG: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_WALL: (Internal.BlockItem) & (Internal.Item);
    static SLIME_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static NETHER_WART_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE_TILE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_MOSAIC_SLAB: (Internal.BlockItem) & (Internal.Item);
    static END_STONE_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static SKELETON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static CRIMSON_FENCE: (Internal.BlockItem) & (Internal.Item);
    static SUSPICIOUS_SAND: (Internal.BlockItem) & (Internal.Item);
    static CRACKED_NETHER_BRICKS: (Internal.BlockItem) & (Internal.Item);
    static STRUCTURE_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static CAT_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static IRON_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static STRIPPED_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static PISTON: (Internal.BlockItem) & (Internal.Item);
    static NETHERITE_UPGRADE_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static DEEPSLATE_BRICK_WALL: (Internal.BlockItem) & (Internal.Item);
    static COD_BUCKET: (Internal.MobBucketItem) & (Internal.Item);
    static HONEY_BOTTLE: (Internal.HoneyBottleItem) & (Internal.Item);
    static EXPOSED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_STRAD: (Internal.RecordItem) & (Internal.Item);
    static GREEN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static PINK_BED: (Internal.BedItem) & (Internal.Item);
    static LADDER: (Internal.BlockItem) & (Internal.Item);
    static SCULK_CATALYST: (Internal.BlockItem) & (Internal.Item);
    static BLUE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static BLUE_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static SNOW_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_CHEST_RAFT: (Internal.BoatItem) & (Internal.Item);
    static SALMON: (Internal.Item) & (Internal.Item);
    static DISPENSER: (Internal.BlockItem) & (Internal.Item);
    static DIAMOND_BOOTS: (Internal.ArmorItem) & (Internal.Item);
    static OAK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RED_BANNER: (Internal.BannerItem) & (Internal.Item);
    static IRON_AXE: (Internal.AxeItem) & (Internal.Item);
    static DEEPSLATE_LAPIS_ORE: (Internal.BlockItem) & (Internal.Item);
    static SILVERFISH_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static ENDERMAN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static GOLDEN_AXE: (Internal.AxeItem) & (Internal.Item);
    static OAK_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static GRANITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CHARCOAL: (Internal.Item) & (Internal.Item);
    static WOODEN_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static MELON: (Internal.BlockItem) & (Internal.Item);
    static ECHO_SHARD: (Internal.Item) & (Internal.Item);
    static BAMBOO_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static DIRT_PATH: (Internal.BlockItem) & (Internal.Item);
    static DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE: (Internal.SmithingTemplateItem) & (Internal.Item);
    static WHITE_BED: (Internal.BedItem) & (Internal.Item);
    static DIORITE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static RECOVERY_COMPASS: (Internal.Item) & (Internal.Item);
    static SNOW: (Internal.BlockItem) & (Internal.Item);
    static GRAY_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static GHAST_TEAR: (Internal.Item) & (Internal.Item);
    static GOLDEN_CARROT: (Internal.Item) & (Internal.Item);
    static FERN: (Internal.BlockItem) & (Internal.Item);
    static CORNFLOWER: (Internal.BlockItem) & (Internal.Item);
    static CHAIN_COMMAND_BLOCK: (Internal.GameMasterBlockItem) & (Internal.Item);
    static ZOMBIE_VILLAGER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static LIME_STAINED_GLASS_PANE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static GREEN_BANNER: (Internal.BannerItem) & (Internal.Item);
    static TRIPWIRE_HOOK: (Internal.BlockItem) & (Internal.Item);
    static EVOKER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static SALMON_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static DEEPSLATE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RAW_GOLD: (Internal.Item) & (Internal.Item);
    static BIRCH_SIGN: (Internal.SignItem) & (Internal.Item);
    static FROGSPAWN: (Internal.PlaceOnWaterBlockItem) & (Internal.Item);
    static SADDLE: (Internal.SaddleItem) & (Internal.Item);
    static YELLOW_WOOL: (Internal.BlockItem) & (Internal.Item);
    static TRIDENT: (Internal.TridentItem) & (Internal.Item);
    static LIGHT_BLUE_CONCRETE: (Internal.BlockItem) & (Internal.Item);
    static WARPED_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static POLISHED_BLACKSTONE_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static SLIME_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static ENDER_CHEST: (Internal.BlockItem) & (Internal.Item);
    static REDSTONE_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_BED: (Internal.BedItem) & (Internal.Item);
    static CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WANDERING_TRADER_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WAXED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static CRIMSON_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static WAXED_WEATHERED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static QUARTZ_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RAIL: (Internal.BlockItem) & (Internal.Item);
    static EMERALD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static POPPY: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_BUTTON: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static LEATHER_HELMET: (Internal.DyeableArmorItem) & (Internal.Item);
    static ACACIA_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static CARTOGRAPHY_TABLE: (Internal.BlockItem) & (Internal.Item);
    static RED_TULIP: (Internal.BlockItem) & (Internal.Item);
    static TRAPPED_CHEST: (Internal.BlockItem) & (Internal.Item);
    static MANGROVE_LOG: (Internal.BlockItem) & (Internal.Item);
    static DARK_OAK_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static CHERRY_LOG: (Internal.BlockItem) & (Internal.Item);
    static CHIPPED_ANVIL: (Internal.BlockItem) & (Internal.Item);
    static MAGMA_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GUNPOWDER: (Internal.Item) & (Internal.Item);
    static OXIDIZED_COPPER: (Internal.BlockItem) & (Internal.Item);
    static BLACK_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static BLUE_DYE: (Internal.DyeItem) & (Internal.Item);
    static PACKED_ICE: (Internal.BlockItem) & (Internal.Item);
    static PEONY: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static CRIMSON_FUNGUS: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_PRESSURE_PLATE: (Internal.BlockItem) & (Internal.Item);
    static JUNGLE_WOOD: (Internal.BlockItem) & (Internal.Item);
    static ORANGE_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static BEETROOT_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static IRON_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static GOLDEN_APPLE: (Internal.Item) & (Internal.Item);
    static LIGHT_BLUE_BED: (Internal.BedItem) & (Internal.Item);
    static WARPED_TRAPDOOR: (Internal.BlockItem) & (Internal.Item);
    static CACTUS: (Internal.BlockItem) & (Internal.Item);
    static TORCH: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static GLASS_BOTTLE: (Internal.BottleItem) & (Internal.Item);
    static MAGENTA_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static STRUCTURE_VOID: (Internal.BlockItem) & (Internal.Item);
    static DEAD_TUBE_CORAL_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static GREEN_CONCRETE_POWDER: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_BLOCKS: (Internal.RecordItem) & (Internal.Item);
    static COOKED_BEEF: (Internal.Item) & (Internal.Item);
    static DIAMOND_SHOVEL: (Internal.ShovelItem) & (Internal.Item);
    static WOODEN_SWORD: (Internal.SwordItem) & (Internal.Item);
    static CRIMSON_SIGN: (Internal.SignItem) & (Internal.Item);
    static NETHER_BRICK: (Internal.Item) & (Internal.Item);
    static STONE_AXE: (Internal.AxeItem) & (Internal.Item);
    static DEAD_BUSH: (Internal.BlockItem) & (Internal.Item);
    static CYAN_GLAZED_TERRACOTTA: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_CHEST_BOAT: (Internal.BoatItem) & (Internal.Item);
    static DEEPSLATE_BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static WHITE_BANNER: (Internal.BannerItem) & (Internal.Item);
    static GRANITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static MOSSY_STONE_BRICK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static OAK_SLAB: (Internal.BlockItem) & (Internal.Item);
    static DEAD_BUBBLE_CORAL: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FENCE_GATE: (Internal.BlockItem) & (Internal.Item);
    static MINER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static BROWN_MUSHROOM: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_PLANKS: (Internal.BlockItem) & (Internal.Item);
    static WOLF_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static MAGENTA_BANNER: (Internal.BannerItem) & (Internal.Item);
    static CYAN_SHULKER_BOX: (Internal.BlockItem) & (Internal.Item);
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static RAW_IRON: (Internal.Item) & (Internal.Item);
    static WEATHERED_CUT_COPPER_SLAB: (Internal.BlockItem) & (Internal.Item);
    static RED_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_DARK_OAK_WOOD: (Internal.BlockItem) & (Internal.Item);
    static BAMBOO_FENCE: (Internal.BlockItem) & (Internal.Item);
    static INFESTED_DEEPSLATE: (Internal.BlockItem) & (Internal.Item);
    static IRON_BARS: (Internal.BlockItem) & (Internal.Item);
    static SANDSTONE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BEDROCK: (Internal.BlockItem) & (Internal.Item);
    static MOURNER_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static STRIPPED_CHERRY_LOG: (Internal.BlockItem) & (Internal.Item);
    static TNT_MINECART: (Internal.MinecartItem) & (Internal.Item);
    static BEE_NEST: (Internal.BlockItem) & (Internal.Item);
    static ACTIVATOR_RAIL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_5: (Internal.RecordItem) & (Internal.Item);
    static DEAD_FIRE_CORAL_FAN: (Internal.StandingAndWallBlockItem) & (Internal.Item);
    static GOLDEN_HELMET: (Internal.ArmorItem) & (Internal.Item);
    static STRIPPED_WARPED_HYPHAE: (Internal.BlockItem) & (Internal.Item);
    static MAGENTA_CARPET: (Internal.BlockItem) & (Internal.Item);
    static TORCHFLOWER_SEEDS: (Internal.ItemNameBlockItem) & (Internal.Item);
    static HONEY_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static STRIPPED_ACACIA_LOG: (Internal.BlockItem) & (Internal.Item);
    static FRIEND_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static RAW_GOLD_BLOCK: (Internal.BlockItem) & (Internal.Item);
    static WARPED_FUNGUS_ON_A_STICK: Internal.Item;
    static SMOOTH_SANDSTONE: (Internal.BlockItem) & (Internal.Item);
    static SPRUCE_SAPLING: (Internal.BlockItem) & (Internal.Item);
    static DOLPHIN_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static NETHERITE_PICKAXE: (Internal.PickaxeItem) & (Internal.Item);
    static GRANITE_WALL: (Internal.BlockItem) & (Internal.Item);
    static BRICK_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static LIME_WOOL: (Internal.BlockItem) & (Internal.Item);
    static CHAINMAIL_CHESTPLATE: (Internal.ArmorItem) & (Internal.Item);
    static WOODEN_HOE: (Internal.HoeItem) & (Internal.Item);
    static HORSE_SPAWN_EGG: (Internal.SpawnEggItem) & (Internal.Item);
    static WATER_BUCKET: (Internal.BucketItem) & (Internal.Item);
    static SMOOTH_QUARTZ_SLAB: (Internal.BlockItem) & (Internal.Item);
    static WAXED_CUT_COPPER: (Internal.BlockItem) & (Internal.Item);
    static HORN_CORAL: (Internal.BlockItem) & (Internal.Item);
    static BLACKSTONE_WALL: (Internal.BlockItem) & (Internal.Item);
    static MUSIC_DISC_STAL: (Internal.RecordItem) & (Internal.Item);
    static SPONGE: (Internal.BlockItem) & (Internal.Item);
    static PIGLIN_BANNER_PATTERN: (Internal.BannerPatternItem) & (Internal.Item);
    static RAW_COPPER: (Internal.Item) & (Internal.Item);
    static DARK_OAK_BOAT: (Internal.BoatItem) & (Internal.Item);
    static REDSTONE_ORE: (Internal.BlockItem) & (Internal.Item);
    static ANDESITE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static BOWL: (Internal.Item) & (Internal.Item);
    static BLACK_WOOL: (Internal.BlockItem) & (Internal.Item);
    static COBBLED_DEEPSLATE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static BEEF: (Internal.Item) & (Internal.Item);
    static COBBLESTONE_SLAB: (Internal.BlockItem) & (Internal.Item);
    static CYAN_CANDLE: (Internal.BlockItem) & (Internal.Item);
    static ACACIA_DOOR: (Internal.DoubleHighBlockItem) & (Internal.Item);
    static SPRUCE_STAIRS: (Internal.BlockItem) & (Internal.Item);
    static HEARTBREAK_POTTERY_SHERD: (Internal.Item) & (Internal.Item);
    static CRIMSON_HYPHAE: (Internal.BlockItem) & (Internal.Item);
}
type Items_ = Items;
declare interface NBTIO {
    write(path: Internal.Path_, nbt: Internal.CompoundTag_): void;
    read(path: Internal.Path_): Internal.CompoundTag;
}
type NBTIO_ = NBTIO;
declare const NBTIO: NBTIO;
declare class SoundType {
    constructor(arg0: number, arg1: number, arg2: Internal.SoundEvent_, arg3: Internal.SoundEvent_, arg4: Internal.SoundEvent_, arg5: Internal.SoundEvent_, arg6: Internal.SoundEvent_)
    getClass(): typeof any;
    toString(): string;
    notifyAll(): void;
    getHitSound(): Internal.SoundEvent;
    getStepSound(): Internal.SoundEvent;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    getFallSound(): Internal.SoundEvent;
    getPlaceSound(): Internal.SoundEvent;
    getVolume(): number;
    hashCode(): number;
    getPitch(): number;
    wait(): void;
    wait(arg0: number): void;
    getBreakSound(): Internal.SoundEvent;
    equals(arg0: any): boolean;
    get class(): typeof any
    get hitSound(): Internal.SoundEvent
    get stepSound(): Internal.SoundEvent
    get fallSound(): Internal.SoundEvent
    get placeSound(): Internal.SoundEvent
    get volume(): number
    get pitch(): number
    get breakSound(): Internal.SoundEvent
    static readonly EMPTY: (SoundType) & (SoundType);
    static readonly SAND: (SoundType) & (SoundType);
    static readonly DECORATED_POT: (SoundType) & (SoundType);
    static readonly TUFF: (SoundType) & (SoundType);
    static readonly GRAVEL: (SoundType) & (SoundType);
    static readonly SHROOMLIGHT: (SoundType) & (SoundType);
    static readonly MOSS: (SoundType) & (SoundType);
    readonly pitch: number;
    static readonly GRASS: (SoundType) & (SoundType);
    static readonly SOUL_SOIL: (SoundType) & (SoundType);
    static readonly WEEPING_VINES: (SoundType) & (SoundType);
    static readonly ANCIENT_DEBRIS: (SoundType) & (SoundType);
    static readonly SCULK_SENSOR: (SoundType) & (SoundType);
    static readonly POINTED_DRIPSTONE: (SoundType) & (SoundType);
    static readonly ROOTED_DIRT: (SoundType) & (SoundType);
    static readonly FROGSPAWN: (SoundType) & (SoundType);
    static readonly NETHER_ORE: (SoundType) & (SoundType);
    static readonly COPPER: (SoundType) & (SoundType);
    static readonly LANTERN: (SoundType) & (SoundType);
    static readonly BONE_BLOCK: (SoundType) & (SoundType);
    static readonly FROGLIGHT: (SoundType) & (SoundType);
    static readonly SNOW: (SoundType) & (SoundType);
    static readonly SCULK_VEIN: (SoundType) & (SoundType);
    static readonly CHERRY_WOOD: (SoundType) & (SoundType);
    static readonly POLISHED_DEEPSLATE: (SoundType) & (SoundType);
    static readonly NYLIUM: (SoundType) & (SoundType);
    static readonly DEEPSLATE: (SoundType) & (SoundType);
    static readonly SPORE_BLOSSOM: (SoundType) & (SoundType);
    static readonly BASALT: (SoundType) & (SoundType);
    static readonly CHERRY_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly SMALL_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly CANDLE: (SoundType) & (SoundType);
    static readonly FLOWERING_AZALEA: (SoundType) & (SoundType);
    static readonly ANVIL: (SoundType) & (SoundType);
    static readonly SCAFFOLDING: (SoundType) & (SoundType);
    static readonly DEEPSLATE_BRICKS: (SoundType) & (SoundType);
    static readonly CORAL_BLOCK: (SoundType) & (SoundType);
    static readonly BAMBOO_SAPLING: (SoundType) & (SoundType);
    static readonly LILY_PAD: (SoundType) & (SoundType);
    static readonly MOSS_CARPET: (SoundType) & (SoundType);
    static readonly LADDER: (SoundType) & (SoundType);
    static readonly LARGE_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly GLOW_LICHEN: (SoundType) & (SoundType);
    static readonly CROP: (SoundType) & (SoundType);
    static readonly PINK_PETALS: (SoundType) & (SoundType);
    static readonly AZALEA_LEAVES: (SoundType) & (SoundType);
    static readonly POWDER_SNOW: (SoundType) & (SoundType);
    static readonly METAL: (SoundType) & (SoundType);
    static readonly HONEY_BLOCK: (SoundType) & (SoundType);
    static readonly NETHER_BRICKS: (SoundType) & (SoundType);
    static readonly SUSPICIOUS_SAND: (SoundType) & (SoundType);
    static readonly GILDED_BLACKSTONE: (SoundType) & (SoundType);
    static readonly HARD_CROP: (SoundType) & (SoundType);
    static readonly SCULK_CATALYST: (SoundType) & (SoundType);
    static readonly DEEPSLATE_TILES: (SoundType) & (SoundType);
    static readonly PACKED_MUD: (SoundType) & (SoundType);
    static readonly SCULK: (SoundType) & (SoundType);
    static readonly VINE: (SoundType) & (SoundType);
    static readonly BAMBOO: (SoundType) & (SoundType);
    static readonly GLASS: (SoundType) & (SoundType);
    static readonly DRIPSTONE_BLOCK: (SoundType) & (SoundType);
    static readonly CHERRY_SAPLING: (SoundType) & (SoundType);
    static readonly CALCITE: (SoundType) & (SoundType);
    static readonly MUD_BRICKS: (SoundType) & (SoundType);
    static readonly STEM: (SoundType) & (SoundType);
    static readonly BAMBOO_WOOD: (SoundType) & (SoundType);
    static readonly SOUL_SAND: (SoundType) & (SoundType);
    static readonly MUD: (SoundType) & (SoundType);
    static readonly BIG_DRIPLEAF: (SoundType) & (SoundType);
    static readonly BAMBOO_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly TWISTING_VINES: (SoundType) & (SoundType);
    static readonly NETHERRACK: (SoundType) & (SoundType);
    static readonly AMETHYST_CLUSTER: (SoundType) & (SoundType);
    static readonly SLIME_BLOCK: (SoundType) & (SoundType);
    static readonly SCULK_SHRIEKER: (SoundType) & (SoundType);
    static readonly CHAIN: (SoundType) & (SoundType);
    static readonly WOOD: (SoundType) & (SoundType);
    static readonly AZALEA: (SoundType) & (SoundType);
    static readonly MANGROVE_ROOTS: (SoundType) & (SoundType);
    static readonly CHISELED_BOOKSHELF: (SoundType) & (SoundType);
    static readonly NETHER_GOLD_ORE: (SoundType) & (SoundType);
    static readonly CHERRY_LEAVES: (SoundType) & (SoundType);
    static readonly AMETHYST: (SoundType) & (SoundType);
    static readonly DECORATED_POT_CRACKED: (SoundType) & (SoundType);
    static readonly CAVE_VINES: (SoundType) & (SoundType);
    static readonly SUSPICIOUS_GRAVEL: (SoundType) & (SoundType);
    static readonly LODESTONE: (SoundType) & (SoundType);
    readonly volume: number;
    static readonly FUNGUS: (SoundType) & (SoundType);
    static readonly SMALL_DRIPLEAF: (SoundType) & (SoundType);
    static readonly HANGING_ROOTS: (SoundType) & (SoundType);
    static readonly SWEET_BERRY_BUSH: (SoundType) & (SoundType);
    static readonly NETHER_WOOD: (SoundType) & (SoundType);
    static readonly NETHER_WART: (SoundType) & (SoundType);
    static readonly STONE: (SoundType) & (SoundType);
    static readonly NETHER_WOOD_HANGING_SIGN: (SoundType) & (SoundType);
    static readonly HANGING_SIGN: (SoundType) & (SoundType);
    static readonly WET_GRASS: (SoundType) & (SoundType);
    static readonly NETHERITE_BLOCK: (SoundType) & (SoundType);
    static readonly MEDIUM_AMETHYST_BUD: (SoundType) & (SoundType);
    static readonly MUDDY_MANGROVE_ROOTS: (SoundType) & (SoundType);
    static readonly WOOL: (SoundType) & (SoundType);
    static readonly ROOTS: (SoundType) & (SoundType);
    static readonly WART_BLOCK: (SoundType) & (SoundType);
    static readonly NETHER_SPROUTS: (SoundType) & (SoundType);
}
type SoundType_ = SoundType;
declare class AlmostUnified {
    static getPreferredItemForTag(tag: ResourceLocation_): Internal.ItemStack;
    getClass(): typeof any;
    toString(): string;
    static getReplacementForItem(stack: Internal.ItemStack_): Internal.ItemStack;
    notifyAll(): void;
    static getUnifyConfig(): Internal.UnifyConfig;
    static getTags(): Internal.Set<string>;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    hashCode(): number;
    wait(): void;
    wait(arg0: number): void;
    static getItemIds(tag: ResourceLocation_): Internal.Set<string>;
    static getPreferredTagForItem(stack: Internal.ItemStack_): string;
    equals(arg0: any): boolean;
    get class(): typeof any
    get unifyConfig(): Internal.UnifyConfig
    get tags(): Internal.Set<string>
}
type AlmostUnified_ = AlmostUnified;
declare class EnchantmentInstance extends Internal.WeightedEntry$IntrusiveBase {
    constructor(arg0: Internal.Enchantment_, arg1: number)
    getClass(): typeof any;
    hashCode(): number;
    toString(): string;
    wait(): void;
    getWeight(): Internal.Weight;
    notifyAll(): void;
    static wrap<T>(arg0: T, arg1: number): Internal.WeightedEntry$Wrapper<T>;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    get class(): typeof any
    get weight(): Internal.Weight
    readonly level: number;
    readonly enchantment: Internal.Enchantment;
}
type EnchantmentInstance_ = EnchantmentInstance;
declare class Duration implements Internal.TemporalAmount, Internal.Comparable<Duration>, Internal.Serializable {
    "dividedBy(java.time.Duration)"(arg0: Duration_): number;
    static parse(arg0: Internal.CharSequence_): Duration;
    notify(): void;
    compareTo(arg0: any): number;
    minusHours(arg0: number): this;
    plusMillis(arg0: number): this;
    toNanosPart(): number;
    getUnits(): Internal.List<Internal.TemporalUnit>;
    multipliedBy(arg0: number): this;
    dividedBy(arg0: number): this;
    get(arg0: Internal.TemporalUnit_): number;
    minusNanos(arg0: number): this;
    static ofSeconds(arg0: number): Duration;
    minus(arg0: Duration_): this;
    isNegative(): boolean;
    static ofMinutes(arg0: number): Duration;
    static ofNanos(arg0: number): Duration;
    toDays(): number;
    toHoursPart(): number;
    minusDays(arg0: number): this;
    toSecondsPart(): number;
    static ofMillis(arg0: number): Duration;
    wait(): void;
    plusNanos(arg0: number): this;
    "compareTo(java.lang.Object)"(arg0: any): number;
    minusSeconds(arg0: number): this;
    toMinutes(): number;
    plus(arg0: number, arg1: Internal.TemporalUnit_): this;
    getClass(): typeof any;
    toMillis(): number;
    toHours(): number;
    getSeconds(): number;
    static ofSeconds(arg0: number, arg1: number): Duration;
    toMinutesPart(): number;
    isZero(): boolean;
    wait(arg0: number, arg1: number): void;
    static of(arg0: number, arg1: Internal.TemporalUnit_): Duration;
    withSeconds(arg0: number): this;
    static between(arg0: Internal.Temporal_, arg1: Internal.Temporal_): Duration;
    plusSeconds(arg0: number): this;
    plusMinutes(arg0: number): this;
    toNanos(): number;
    negated(): this;
    static ofDays(arg0: number): Duration;
    addTo(arg0: Internal.Temporal_): Internal.Temporal;
    compareTo(arg0: Duration_): number;
    toString(): string;
    minus(arg0: number, arg1: Internal.TemporalUnit_): this;
    plus(arg0: Duration_): this;
    notifyAll(): void;
    toDaysPart(): number;
    "compareTo(java.time.Duration)"(arg0: Duration_): number;
    plusDays(arg0: number): this;
    static from(arg0: Internal.TemporalAmount_): Duration;
    getNano(): number;
    truncatedTo(arg0: Internal.TemporalUnit_): this;
    plusHours(arg0: number): this;
    subtractFrom(arg0: Internal.Temporal_): Internal.Temporal;
    hashCode(): number;
    minusMillis(arg0: number): this;
    wait(arg0: number): void;
    dividedBy(arg0: Duration_): number;
    equals(arg0: any): boolean;
    abs(): this;
    minusMinutes(arg0: number): this;
    static ofHours(arg0: number): Duration;
    withNanos(arg0: number): this;
    "dividedBy(long)"(arg0: number): this;
    toSeconds(): number;
    toMillisPart(): number;
    get units(): Internal.List<Internal.TemporalUnit>
    get negative(): boolean
    get class(): typeof any
    get seconds(): number
    get zero(): boolean
    get nano(): number
    static readonly ZERO: (Duration) & (Duration);
}
type Duration_ = Duration;
declare class OutputItem implements Internal.OutputReplacement {
    getClass(): typeof any;
    getCount(): number;
    withRolls(rolls: Internal.IntProvider_): this;
    static of(from: any): OutputItem;
    isEmpty(): boolean;
    notify(): void;
    withCount(count: number): this;
    wait(arg0: number, arg1: number): void;
    weakNBT(): InputItem;
    strongNBT(): InputItem;
    replaceOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.OutputReplacement_): any;
    withChance(chance: number): this;
    withRolls(min: number, max: number): this;
    getNbt(): Internal.CompoundTag;
    toString(): string;
    transform(transformer: Internal.OutputReplacementTransformer_): Internal.OutputReplacementTransformer$Replacement;
    notifyAll(): void;
    getChance(): number;
    static of(item: Internal.ItemStack_, chance: number): OutputItem;
    hashCode(): number;
    wait(): void;
    wait(arg0: number): void;
    hasChance(): boolean;
    equals(arg0: any): boolean;
    /**
     * @deprecated
    */
    ignoreNBT(): InputItem;
    get class(): typeof any
    get count(): number
    get empty(): boolean
    get nbt(): Internal.CompoundTag
    get chance(): number
    static readonly EMPTY: (OutputItem) & (OutputItem);
    readonly item: Internal.ItemStack;
    readonly rolls: Internal.IntProvider;
    readonly chance: number;
}
type OutputItem_ = Internal.ItemStack_ | OutputItem;
declare interface Comparator <T> {
    abstract compare(arg0: T, arg1: T): number;
    comparing<T, U extends Internal.Comparable<any>>(arg0: Internal.Function_<T, U>): this;
    reverseOrder<T extends Internal.Comparable<any>>(): this;
    thenComparing<U extends Internal.Comparable<any>>(arg0: Internal.Function_<T, U>): this;
    "thenComparing(java.util.function.Function)"<U extends Internal.Comparable<any>>(arg0: Internal.Function_<T, U>): this;
    reversed(): this;
    naturalOrder<T extends Internal.Comparable<any>>(): this;
    "thenComparing(java.util.Comparator)"(arg0: Comparator_<T>): this;
    thenComparingLong(arg0: Internal.ToLongFunction_<T>): this;
    comparingInt<T>(arg0: Internal.ToIntFunction_<T>): this;
    thenComparingDouble(arg0: Internal.ToDoubleFunction_<T>): this;
    nullsFirst<T>(arg0: Comparator_<T>): this;
    comparingLong<T>(arg0: Internal.ToLongFunction_<T>): this;
    comparingDouble<T>(arg0: Internal.ToDoubleFunction_<T>): this;
    nullsLast<T>(arg0: Comparator_<T>): this;
    thenComparing<U>(arg0: Internal.Function_<T, U>, arg1: Comparator_<U>): this;
    thenComparing(arg0: Comparator_<T>): this;
    abstract equals(arg0: any): boolean;
    comparing<T, U>(arg0: Internal.Function_<T, U>, arg1: Comparator_<U>): this;
    thenComparingInt(arg0: Internal.ToIntFunction_<T>): this;
}
type Comparator_<T> = Comparator<T>;
declare const Comparator: Comparator;
declare class DamageSource {
    constructor(arg0: Internal.Holder_<Internal.DamageType>)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Vec3d_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_, arg3: Vec3d_)
    getClass(): typeof any;
    getSourcePosition(): Vec3d;
    /**
     * @deprecated
    */
    scalesWithDifficulty(): boolean;
    typeHolder(): Internal.Holder<Internal.DamageType>;
    "is(net.minecraft.tags.TagKey)"(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    notify(): void;
    getLocalizedDeathMessage(arg0: Internal.LivingEntity_): Internal.Component;
    wait(arg0: number, arg1: number): void;
    is(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    type(): Internal.DamageType;
    "is(net.minecraft.resources.ResourceKey)"(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    getType(): string;
    getActual(): Internal.Entity;
    getPlayer(): Internal.Player;
    toString(): string;
    isIndirect(): boolean;
    getImmediate(): Internal.Entity;
    notifyAll(): void;
    getFoodExhaustion(): number;
    sourcePositionRaw(): Vec3d;
    is(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    hashCode(): number;
    isCreativePlayer(): boolean;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get sourcePosition(): Vec3d
    get type(): string
    get actual(): Internal.Entity
    get player(): Internal.Player
    get indirect(): boolean
    get immediate(): Internal.Entity
    get foodExhaustion(): number
    get creativePlayer(): boolean
}
type DamageSource_ = DamageSource;
declare class Platform {
    constructor()
    getClass(): typeof any;
    static getMcVersion(): string;
    static isForge(): boolean;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    static isFabric(): boolean;
    static isGeneratingData(): boolean;
    static getInfo(modID: string): Internal.PlatformWrapper$ModInfo;
    static isLoaded(modId: string): boolean;
    static getName(): string;
    static setModName(modId: string, name: string): void;
    static getMinecraftVersion(): number;
    static isDevelopmentEnvironment(): boolean;
    static getList(): Internal.Set<string>;
    toString(): string;
    notifyAll(): void;
    static isClientEnvironment(): boolean;
    static getModVersion(): string;
    static breakpoint(...args: any[]): void;
    hashCode(): number;
    static getMinecraftVersionString(): string;
    static getMods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>;
    wait(): void;
    wait(arg0: number): void;
    equals(arg0: any): boolean;
    get class(): typeof any
    get mcVersion(): string
    get forge(): boolean
    get fabric(): boolean
    get generatingData(): boolean
    get name(): string
    get minecraftVersion(): number
    get developmentEnvironment(): boolean
    get list(): Internal.Set<string>
    get clientEnvironment(): boolean
    get modVersion(): string
    get minecraftVersionString(): string
    get mods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>
}
type Platform_ = Platform;
declare class Vec3f implements Internal.Cloneable, Internal.Vector3fc, Internal.Externalizable {
    constructor(arg0: Internal.Vector3fc_)
    constructor()
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.Vector2fc_, arg1: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: Internal.Vector2ic_, arg1: number)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3ic_)
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    "get(org.joml.Vector3d)"(arg0: Internal.Vector3d_): Internal.Vector3d;
    set(arg0: number, arg1: number, arg2: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    div(arg0: number, arg1: number, arg2: number): this;
    rotateY(arg0: number): this;
    "mul(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    angleCos(arg0: Internal.Vector3fc_): number;
    "fma(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    "set(float)"(arg0: number): this;
    static length(arg0: number, arg1: number, arg2: number): number;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_): this;
    normalize(arg0: number, arg1: Vec3f_): this;
    sub(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    half(arg0: number, arg1: number, arg2: number): this;
    round(): this;
    "fma(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    "mulAdd(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "div(float)"(arg0: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    get(arg0: number): number;
    "mulAdd(float,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    mul(arg0: number, arg1: number, arg2: number): this;
    ceil(arg0: Vec3f_): this;
    negate(): this;
    getClass(): typeof any;
    "mulPosition(org.joml.Matrix4x3fc,org.joml.Vector3f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    add(arg0: Internal.Vector3fc_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number): number;
    ceil(): this;
    div(arg0: number, arg1: Vec3f_): this;
    distanceSquared(arg0: number, arg1: number, arg2: number): number;
    "div(float,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    add(arg0: number, arg1: number, arg2: number): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotateZ(arg0: number): this;
    distanceSquared(arg0: Internal.Vector3fc_): number;
    set(arg0: number[]): this;
    equals(arg0: Internal.Vector3fc_, arg1: number): boolean;
    "normalize(float)"(arg0: number): this;
    "set(double)"(arg0: number): this;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    max(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    "mulAdd(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mulPositionW(arg0: Internal.Matrix4fc_): number;
    mulPosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): Quaternionf;
    "mul(org.joml.Matrix3x2fc,org.joml.Vector3f)"(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3x2fc_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    mulDirection(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    wait(arg0: number): void;
    rotateZ(arg0: number, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_): this;
    "mulDirection(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    absolute(arg0: Vec3f_): this;
    angleSigned(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): number;
    normalize(arg0: Vec3f_): this;
    normalize(arg0: number): this;
    normalize(): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: number, arg2: Vec3f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mul(arg0: Internal.Vector3fc_): this;
    isFinite(): boolean;
    mulTransposePosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    getToAddress(arg0: number): Internal.Vector3fc;
    "mulDirection(org.joml.Matrix4dc,org.joml.Vector3f)"(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    "mul(org.joml.Matrix3dc,org.joml.Vector3f)"(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    "mulDirection(org.joml.Matrix4x3fc,org.joml.Vector3f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    x(): number;
    absolute(): this;
    mulDirection(arg0: Internal.Matrix4dc_): this;
    "set(float,float,float)"(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Vector2dc,float)"(arg0: Internal.Vector2dc_, arg1: number): this;
    mulDirection(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    "mul(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    fma(arg0: number, arg1: Internal.Vector3fc_): this;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    sub(arg0: Internal.Vector3fc_): this;
    minComponent(): number;
    set(arg0: Internal.Vector3fc_): this;
    orthogonalize(arg0: Internal.Vector3fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec3f_): this;
    "set(org.joml.Vector2ic,float)"(arg0: Internal.Vector2ic_, arg1: number): this;
    set(arg0: Internal.ByteBuffer_): this;
    "set(org.joml.Vector3dc)"(arg0: Internal.Vector3dc_): this;
    "mul(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    rotateX(arg0: number): this;
    round(arg0: Vec3f_): this;
    half(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mul(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    "normalize(org.joml.Vector3f)"(arg0: Vec3f_): this;
    "set(float[])"(arg0: number[]): this;
    y(): number;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    "get(int,org.joml.Vector3i)"(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    set(arg0: Internal.Vector2fc_, arg1: number): this;
    distance(arg0: Internal.Vector3fc_): number;
    "mul(org.joml.Matrix3fc,org.joml.Vector3f)"(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    "mulPosition(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector3fc_): this;
    equals(arg0: any): boolean;
    setFromAddress(arg0: number): this;
    "mul(float)"(arg0: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "mul(org.joml.Matrix3dc)"(arg0: Internal.Matrix3dc_): this;
    "get(org.joml.Vector3f)"(arg0: Vec3f_): this;
    equals(arg0: number, arg1: number, arg2: number): boolean;
    add(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_): this;
    set(arg0: Internal.FloatBuffer_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    z(): number;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulPositionW(arg0: Internal.Matrix4fc_, arg1: Vec3f_): number;
    mulDirection(arg0: Internal.Matrix4fc_): this;
    "fma(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    toString(arg0: Internal.NumberFormat_): string;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "div(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    lengthSquared(): number;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "set(double,double,double)"(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Vector2fc,float)"(arg0: Internal.Vector2fc_, arg1: number): this;
    mulTranspose(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): this;
    clone(): any;
    cross(arg0: Internal.Vector3fc_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector3dc_): this;
    mul(arg0: number): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    dot(arg0: number, arg1: number, arg2: number): number;
    mulTranspose(arg0: Internal.Matrix3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    floor(): this;
    zero(): this;
    reflect(arg0: number, arg1: number, arg2: number): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    sub(arg0: number, arg1: number, arg2: number): this;
    mulPosition(arg0: Internal.Matrix4x3fc_): this;
    length(): number;
    toString(): string;
    notifyAll(): void;
    "mulPosition(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "mulPosition(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    setComponent(arg0: number, arg1: number): this;
    "mul(org.joml.Matrix3x2fc)"(arg0: Internal.Matrix3x2fc_): this;
    div(arg0: number): this;
    orthogonalize(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    div(arg0: Internal.Vector3fc_): this;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    set(arg0: Internal.Vector3ic_): this;
    "mul(float,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): this;
    min(arg0: Internal.Vector3fc_): this;
    half(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    cross(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    notify(): void;
    "mulAdd(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    floor(arg0: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    half(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    smoothStep(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    set(arg0: Internal.Vector2dc_, arg1: number): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    negate(arg0: Vec3f_): this;
    mul(arg0: number, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4fc_): this;
    hermite(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: number, arg4: Vec3f_): this;
    get(arg0: Internal.Vector3d_): Internal.Vector3d;
    "set(org.joml.Vector3ic)"(arg0: Internal.Vector3ic_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateY(arg0: number, arg1: Vec3f_): this;
    "get(int)"(arg0: number): number;
    distance(arg0: number, arg1: number, arg2: number): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    dot(arg0: Internal.Vector3fc_): number;
    "set(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    div(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_): this;
    min(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    wait(arg0: number, arg1: number): void;
    "mulDirection(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    set(arg0: Internal.Vector2ic_, arg1: number): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number): this;
    "div(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Quaternionf_): Quaternionf;
    mulTransposePosition(arg0: Internal.Matrix4fc_): this;
    angle(arg0: Internal.Vector3fc_): number;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    "fma(float,org.joml.Vector3fc,org.joml.Vector3f)"(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    fma(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    angleSigned(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    mulDirection(arg0: Internal.Matrix4x3fc_): this;
    mulDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    hashCode(): number;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: Vec3f_): this;
    rotateX(arg0: number, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_): this;
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(float)"(arg0: number)
    get class(): typeof any
    set "(double)"(arg0: number)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    get finite(): boolean
    set "(org.joml.Vector3dc)"(arg0: Internal.Vector3dc_)
    set "(float[])"(arg0: number[])
    set fromAddress(arg0: number)
    set "(org.joml.Vector3ic)"(arg0: Internal.Vector3ic_)
    set "(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_)
    z: number;
    y: number;
    x: number;
}
type Vec3f_ = Vec3f;
declare class Vec4f implements Internal.Cloneable, Internal.Vector4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: Internal.Vector2fc_, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3fc_, arg1: number)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: Internal.Vector2ic_, arg1: number, arg2: number)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.Vector4fc_)
    constructor(arg0: Internal.Vector3ic_, arg1: number)
    constructor(arg0: Internal.Vector4ic_)
    min(arg0: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector4ic_): this;
    div(arg0: Internal.Vector4fc_): this;
    "fma(float,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    normalize3(arg0: Vec4f_): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateAbout(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "div(float)"(arg0: number): this;
    mul(arg0: Internal.Vector4fc_): this;
    dot(arg0: number, arg1: number, arg2: number, arg3: number): number;
    setComponent(arg0: number, arg1: number): this;
    "set(double,double,double,double)"(arg0: number, arg1: number, arg2: number, arg3: number): this;
    fma(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    rotateZ(arg0: number, arg1: Vec4f_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "mul(org.joml.Matrix4fc,org.joml.Vector4f)"(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    z(): number;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    min(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    div(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    "mul(float)"(arg0: number): this;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    dot(arg0: Internal.Vector4fc_): number;
    set(arg0: number, arg1: number, arg2: number): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "set(org.joml.Vector2fc,float,float)"(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateZ(arg0: number): this;
    "mul(float,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): this;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    fma(arg0: number, arg1: Internal.Vector4fc_): this;
    normalize3(): this;
    round(arg0: Vec4f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lengthSquared(): number;
    mul(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get(arg0: number): number;
    distanceSquared(arg0: Internal.Vector4fc_): number;
    set(arg0: number[]): this;
    sub(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector3ic_, arg1: number): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    clone(): any;
    getClass(): typeof any;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    "set(org.joml.Vector4ic)"(arg0: Internal.Vector4ic_): this;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector4fc_): this;
    "mul(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    negate(arg0: Vec4f_): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "fma(float,org.joml.Vector4fc)"(arg0: number, arg1: Internal.Vector4fc_): this;
    get(arg0: Internal.Vector4d_): Internal.Vector4d;
    getToAddress(arg0: number): Internal.Vector4fc;
    rotateY(arg0: number, arg1: Vec4f_): this;
    "get(int,org.joml.Vector4i)"(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    set(arg0: Internal.Vector3fc_, arg1: number): this;
    "mul(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    "fma(org.joml.Vector4fc,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    ceil(arg0: Vec4f_): this;
    "fma(org.joml.Vector4fc,org.joml.Vector4fc)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    "mul(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "set(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    negate(): this;
    mulAffineTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "mulAdd(float,org.joml.Vector4fc)"(arg0: number, arg1: Internal.Vector4fc_): this;
    w(): number;
    rotate(arg0: Internal.Quaternionfc_): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    length(): number;
    toString(): string;
    normalize(arg0: number): this;
    distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    mul(arg0: number): this;
    notifyAll(): void;
    ceil(): this;
    smoothStep(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number): this;
    "mul(org.joml.Matrix4x3fc,org.joml.Vector4f)"(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    floor(arg0: Vec4f_): this;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    "get(org.joml.Vector4d)"(arg0: Internal.Vector4d_): Internal.Vector4d;
    div(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    "set(org.joml.Vector3ic,float)"(arg0: Internal.Vector3ic_, arg1: number): this;
    floor(): this;
    angle(arg0: Internal.Vector4fc_): number;
    wait(arg0: number): void;
    static "lengthSquared(int,int,int,int)"(arg0: number, arg1: number, arg2: number, arg3: number): number;
    "set(org.joml.Vector3fc,float)"(arg0: Internal.Vector3fc_, arg1: number): this;
    max(arg0: Internal.Vector4fc_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number): this;
    set(arg0: Internal.FloatBuffer_): this;
    "get(org.joml.Vector4f)"(arg0: Vec4f_): this;
    angleCos(arg0: Internal.Vector4fc_): number;
    "set(float)"(arg0: number): this;
    get(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    hermite(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: number, arg4: Vec4f_): this;
    "set(float,float,float)"(arg0: number, arg1: number, arg2: number): this;
    absolute(): this;
    distance(arg0: Internal.Vector4fc_): number;
    mul(arg0: number, arg1: Vec4f_): this;
    notify(): void;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    normalize(): this;
    isFinite(): boolean;
    "normalize(org.joml.Vector4f)"(arg0: Vec4f_): this;
    get(arg0: Vec4f_): this;
    static length(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateX(arg0: number, arg1: Vec4f_): this;
    "mul(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    div(arg0: number): this;
    setFromAddress(arg0: number): this;
    "div(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_): this;
    "div(float,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): this;
    x(): number;
    absolute(arg0: Vec4f_): this;
    div(arg0: number, arg1: Vec4f_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mulTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: Internal.ByteBuffer_): this;
    "mulProject(org.joml.Matrix4fc,org.joml.Vector4f)"(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "div(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    "set(double)"(arg0: number): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    wait(): void;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    zero(): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    static "lengthSquared(float,float,float,float)"(arg0: number, arg1: number, arg2: number, arg3: number): number;
    "get(int)"(arg0: number): number;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    "normalize(float)"(arg0: number): this;
    add(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    rotateX(arg0: number): this;
    minComponent(): number;
    round(): this;
    set(arg0: Internal.Vector4dc_): this;
    "mulAdd(org.joml.Vector4fc,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    "mulProject(org.joml.Matrix4fc,org.joml.Vector3f)"(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    add(arg0: Internal.Vector4fc_): this;
    "mulAdd(org.joml.Vector4fc,org.joml.Vector4fc)"(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    equals(arg0: Internal.Vector4fc_, arg1: number): boolean;
    wait(arg0: number, arg1: number): void;
    "set(org.joml.Vector2ic,float,float)"(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    sub(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    mulTranspose(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    "mulAdd(float,org.joml.Vector4fc,org.joml.Vector4f)"(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    y(): number;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    normalize(arg0: Vec4f_): this;
    set(arg0: number): this;
    rotateY(arg0: number): this;
    hashCode(): number;
    set(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    distance(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    "set(org.joml.Vector4dc)"(arg0: Internal.Vector4dc_): this;
    set(arg0: number): this;
    equals(arg0: any): boolean;
    mul(arg0: Internal.Matrix4fc_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    "set(float[])"(arg0: number[]): this;
    normalize(arg0: number, arg1: Vec4f_): this;
    get class(): typeof any
    set "(org.joml.Vector4ic)"(arg0: Internal.Vector4ic_)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set "(org.joml.Vector4fc)"(arg0: Internal.Vector4fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(float)"(arg0: number)
    get finite(): boolean
    set fromAddress(arg0: number)
    set "(double)"(arg0: number)
    set "(org.joml.Vector4dc)"(arg0: Internal.Vector4dc_)
    set "(float[])"(arg0: number[])
    z: number;
    y: number;
    x: number;
    w: number;
}
type Vec4f_ = Vec4f;
declare interface UUID {
    toString(id: Internal.UUID_): string;
    digits(sb: Internal.StringBuilder_, val: number, digits: number): void;
    fromString(o: any): Internal.UUID;
}
type UUID_ = UUID;
declare const UUID: UUID;
/**
 * Various Ingredient related helper methods
*/
declare interface Ingredient {
    static of(ingredient: Internal.Ingredient_, count: number): Internal.Ingredient;
    /**
     * Returns an ingredient of the input
    */
    of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Returns an ingredient of the input, with the specified count
    */
    of(ingredient: Internal.Ingredient_, count: number): InputItem;
    /**
     * Make a custom ingredient where a match must match the provided predicate function
    */
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    /**
     * Register a custom ingredient action for use in recipes with Recipe#customIngredientAction
    */
    registerCustomIngredientAction(id: string, callback: Internal.CustomIngredientActionCallback_): void;
    /**
     * Make a custom ingredient where items must match both the parent ingredient and the custom predicate function
    */
    custom(parent: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    static of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Checks if the passed in object is an Ingredient.
     * Note that this does not mean it will not function as an Ingredient if passed to something that requests one.
    */
    isIngredient(o: any): boolean;
    /**
     * Make a custom ingredient where an item must match both the parent ingredient and the item's nbt must match the custom predicate function
    */
    customNBT(in_: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.CompoundTag>): Internal.Ingredient;
    /**
     * An ingredient that matches everything
    */
    readonly all: (Internal.WildcardIngredient) & (Internal.Ingredient);
    /**
     * A completely empty ingredient that will only match air
    */
    readonly none: (Internal.Ingredient) & (Internal.Ingredient);
}
type Ingredient_ = Ingredient;
declare const Ingredient: Ingredient;
declare class JavaMath {
    static "nextUp(float)"(arg0: number): number;
    static asin(arg0: number): number;
    static expm1(arg0: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static ceil(arg0: number): number;
    static exp(arg0: number): number;
    static "decrementExact(long)"(arg0: number): number;
    static "floorMod(long,int)"(arg0: number, arg1: number): number;
    static "incrementExact(int)"(arg0: number): number;
    static ulp(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static "copySign(float,float)"(arg0: number, arg1: number): number;
    static "abs(float)"(arg0: number): number;
    static "fma(double,double,double)"(arg0: number, arg1: number, arg2: number): number;
    static "negateExact(int)"(arg0: number): number;
    static "min(double,double)"(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static round(arg0: number): number;
    static hypot(arg0: number, arg1: number): number;
    static round(arg0: number): number;
    static "scalb(float,int)"(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static "subtractExact(long,long)"(arg0: number, arg1: number): number;
    static "floorDiv(long,long)"(arg0: number, arg1: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static log(arg0: number): number;
    static signum(arg0: number): number;
    static "max(float,float)"(arg0: number, arg1: number): number;
    static "nextAfter(double,double)"(arg0: number, arg1: number): number;
    static cos(arg0: number): number;
    getClass(): typeof any;
    static min(arg0: number, arg1: number): number;
    static nextUp(arg0: number): number;
    static "min(int,int)"(arg0: number, arg1: number): number;
    static "floorMod(int,int)"(arg0: number, arg1: number): number;
    static "max(long,long)"(arg0: number, arg1: number): number;
    static "fma(float,float,float)"(arg0: number, arg1: number, arg2: number): number;
    static "nextDown(double)"(arg0: number): number;
    static atan2(arg0: number, arg1: number): number;
    static cosh(arg0: number): number;
    static "round(float)"(arg0: number): number;
    static toIntExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static "floorDiv(int,int)"(arg0: number, arg1: number): number;
    static sinh(arg0: number): number;
    static toDegrees(arg0: number): number;
    static "multiplyExact(long,long)"(arg0: number, arg1: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static "scalb(double,int)"(arg0: number, arg1: number): number;
    static "decrementExact(int)"(arg0: number): number;
    static tanh(arg0: number): number;
    toString(): string;
    static "negateExact(long)"(arg0: number): number;
    static "nextUp(double)"(arg0: number): number;
    notifyAll(): void;
    static floorMod(arg0: number, arg1: number): number;
    static "min(long,long)"(arg0: number, arg1: number): number;
    static nextDown(arg0: number): number;
    static "absExact(long)"(arg0: number): number;
    static "addExact(int,int)"(arg0: number, arg1: number): number;
    static absExact(arg0: number): number;
    static pow(arg0: number, arg1: number): number;
    static scalb(arg0: number, arg1: number): number;
    wait(arg0: number): void;
    static "abs(int)"(arg0: number): number;
    static addExact(arg0: number, arg1: number): number;
    static atan(arg0: number): number;
    static "addExact(long,long)"(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    notify(): void;
    static multiplyExact(arg0: number, arg1: number): number;
    static "ulp(float)"(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static random(): number;
    static "ulp(double)"(arg0: number): number;
    static nextUp(arg0: number): number;
    static sqrt(arg0: number): number;
    static "multiplyExact(int,int)"(arg0: number, arg1: number): number;
    static "copySign(double,double)"(arg0: number, arg1: number): number;
    static "abs(double)"(arg0: number): number;
    static "subtractExact(int,int)"(arg0: number, arg1: number): number;
    static min(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static addExact(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static "floorMod(long,long)"(arg0: number, arg1: number): number;
    static floor(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static "abs(long)"(arg0: number): number;
    static rint(arg0: number): number;
    static "min(float,float)"(arg0: number, arg1: number): number;
    static "max(int,int)"(arg0: number, arg1: number): number;
    static absExact(arg0: number): number;
    static signum(arg0: number): number;
    wait(): void;
    static log10(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static tan(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static sin(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    wait(arg0: number, arg1: number): void;
    static max(arg0: number, arg1: number): number;
    static "max(double,double)"(arg0: number, arg1: number): number;
    static toRadians(arg0: number): number;
    static "multiplyExact(long,int)"(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static negateExact(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static negateExact(arg0: number): number;
    static "getExponent(float)"(arg0: number): number;
    static "incrementExact(long)"(arg0: number): number;
    static "signum(float)"(arg0: number): number;
    static nextDown(arg0: number): number;
    static "nextAfter(float,double)"(arg0: number, arg1: number): number;
    static IEEEremainder(arg0: number, arg1: number): number;
    static "round(double)"(arg0: number): number;
    static abs(arg0: number): number;
    static getExponent(arg0: number): number;
    static "getExponent(double)"(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static multiplyFull(arg0: number, arg1: number): number;
    static multiplyHigh(arg0: number, arg1: number): number;
    hashCode(): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static getExponent(arg0: number): number;
    static "floorDiv(long,int)"(arg0: number, arg1: number): number;
    static cbrt(arg0: number): number;
    static acos(arg0: number): number;
    static log1p(arg0: number): number;
    static "nextDown(float)"(arg0: number): number;
    equals(arg0: any): boolean;
    static "signum(double)"(arg0: number): number;
    static "absExact(int)"(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    get class(): typeof any
    static readonly PI: (3.141592653589793) & (number);
    static readonly E: (2.718281828459045) & (number);
}
type JavaMath_ = JavaMath;
declare interface NBT {
    accessTagMap(tag: Internal.CompoundTag_): Internal.Map<string, Internal.Tag>;
    read(buf: Internal.FriendlyByteBuf_): Internal.OrderedCompoundTag;
    toJson(t: Internal.Tag_): Internal.JsonElement;
    toTagCollection(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    l(v: number): Internal.Tag;
    quoteAndEscapeForJS(stringBuilder: Internal.StringBuilder_, string: string): void;
    b(v: number): Internal.Tag;
    byteArrayTag(v: number[]): Internal.Tag;
    listTag(): Internal.Tag;
    floatTag(v: number): Internal.Tag;
    s(v: number): Internal.Tag;
    byteTag(v: number): Internal.Tag;
    listTag(list: Internal.List_<any>): Internal.Tag;
    ia(v: number[]): Internal.Tag;
    d(v: number): Internal.Tag;
    longArrayTag(v: number[]): Internal.Tag;
    isTagCollection(o: any): boolean;
    "toTagCollection(java.util.Collection)"(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    longTag(v: number): Internal.Tag;
    compoundTag(): Internal.Tag;
    intTag(v: number): Internal.Tag;
    shortTag(v: number): Internal.Tag;
    stringTag(v: string): Internal.Tag;
    la(v: number[]): Internal.Tag;
    convertType(tagType: Internal.TagType_<any>): Internal.TagType<any>;
    toTagCollection(v: any): Internal.CollectionTag<any>;
    f(v: number): Internal.Tag;
    toTag(v: any): Internal.Tag;
    fromTag(t: Internal.Tag_): any;
    toTagList(list: any): Internal.ListTag;
    toTagCompound(v: any): Internal.CompoundTag;
    isTagCompound(o: any): boolean;
    doubleTag(v: number): Internal.Tag;
    intArrayTag(v: number[]): Internal.Tag;
    ba(v: number[]): Internal.Tag;
    compoundTag(map: Internal.Map_<any, any>): Internal.Tag;
    i(v: number): Internal.Tag;
    "toTagCollection(java.lang.Object)"(v: any): Internal.CollectionTag<any>;
    readonly VALUE_UNWRAPPER: Internal.ValueUnwrapper;
    readonly LIST_TYPE: Internal.TagType<Internal.ListTag>;
    readonly COMPOUND_TYPE: Internal.TagType<Internal.OrderedCompoundTag>;
}
type NBT_ = NBT;
declare const NBT: NBT;
declare interface FluidAmounts {
    readonly MILLIBUCKET: (1) & (number);
    readonly MB: (1) & (number);
    readonly INGOT: (90) & (number);
    readonly BOTTLE: (250) & (number);
    readonly B: (1000) & (number);
    readonly NUGGET: (10) & (number);
    readonly METAL_BLOCK: (810) & (number);
    readonly BUCKET: (1000) & (number);
}
type FluidAmounts_ = FluidAmounts;
declare const FluidAmounts: FluidAmounts;
declare class Matrix3f implements Internal.Cloneable, Internal.Matrix3fc, Internal.Externalizable {
    constructor(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_)
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix2fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number)
    rotateLocalY(arg0: number, arg1: Matrix3f_): this;
    setColumn(arg0: number, arg1: Internal.Vector3fc_): this;
    mapnZnXY(): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    mapZXnY(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYXnZ(arg0: Matrix3f_): this;
    "getUnnormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapnYnXZ(arg0: Matrix3f_): this;
    "scale(float)"(arg0: number): this;
    "getTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapYnXnZ(arg0: Matrix3f_): this;
    "getNormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    negateZ(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    "get(int,int)"(arg0: number, arg1: number): number;
    mapXnYnZ(): this;
    mapnYnZX(): this;
    m20(arg0: number): this;
    set(arg0: Internal.Matrix4fc_): this;
    rotationZ(arg0: number): this;
    mapnYnXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZYnX(): this;
    sub(arg0: Internal.Matrix3fc_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "rotate(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    setColumn(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnYnZnX(): this;
    getRowColumn(arg0: number, arg1: number): number;
    positiveZ(arg0: Vec3f_): Vec3f;
    mapnYZX(arg0: Matrix3f_): this;
    mapnXnZY(arg0: Matrix3f_): this;
    mapXZY(arg0: Matrix3f_): this;
    rotateZ(arg0: number, arg1: Matrix3f_): this;
    mapYZnX(): this;
    mapnZnYX(arg0: Matrix3f_): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotateLocalZ(arg0: number, arg1: Matrix3f_): this;
    getClass(): typeof any;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapZYX(): this;
    mapYnZnX(): this;
    mapnXnYnZ(): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix3f_): this;
    scale(arg0: number): this;
    set(arg0: Internal.Matrix3fc_): this;
    m20(): number;
    mapnXnYZ(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    "rotate(org.joml.AxisAngle4f,org.joml.Matrix3f)"(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    get(arg0: Matrix4f_): Matrix4f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    m21(arg0: number): this;
    rotationY(arg0: number): this;
    "get3x4(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXYnZ(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    mapZnYX(): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnYZnX(arg0: Matrix3f_): this;
    cofactor(arg0: Matrix3f_): this;
    set(arg0: Internal.ByteBuffer_): this;
    mapXnZY(arg0: Matrix3f_): this;
    getScale(arg0: Vec3f_): Vec3f;
    setTransposed(arg0: Internal.Matrix3fc_): this;
    transform(arg0: Vec3f_): Vec3f;
    rotateY(arg0: number, arg1: Matrix3f_): this;
    mapYnZX(): this;
    "scale(org.joml.Vector3fc,org.joml.Matrix3f)"(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    mapnXZY(arg0: Matrix3f_): this;
    "scale(float,org.joml.Matrix3f)"(arg0: number, arg1: Matrix3f_): this;
    wait(arg0: number): void;
    set(arg0: Internal.Quaterniondc_): this;
    scale(arg0: Internal.Vector3fc_): this;
    normal(arg0: Matrix3f_): this;
    mapZYnX(): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setRow(arg0: number, arg1: Internal.Vector3fc_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    set(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Quaternionfc_): this;
    rotateLocalY(arg0: number): this;
    "get(org.joml.Matrix3f)"(arg0: Matrix3f_): this;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m21(): number;
    sub(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    isFinite(): boolean;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnYZX(): this;
    mapZnYX(arg0: Matrix3f_): this;
    transpose(arg0: Matrix3f_): this;
    rotation(arg0: Internal.Quaternionfc_): this;
    mapnXnYZ(arg0: Matrix3f_): this;
    mapnXnZnY(): this;
    "set(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    m10(): number;
    mapXnZnY(): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    mapZXY(arg0: Matrix3f_): this;
    rotationX(arg0: number): this;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    mapYnXZ(): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    getToAddress(arg0: number): Internal.Matrix3fc;
    reflect(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number, arg1: number): number;
    setRow(arg0: number, arg1: number, arg2: number, arg3: number): this;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.FloatBuffer_): this;
    mapnZnXnY(arg0: Matrix3f_): this;
    mapXZnY(arg0: Matrix3f_): this;
    rotateLocalX(arg0: number, arg1: Matrix3f_): this;
    mulLocal(arg0: Internal.Matrix3fc_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapnYXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: Vec3f_): Vec3f;
    "rotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotateLocalZ(arg0: number): this;
    m22(): number;
    lerp(arg0: Internal.Matrix3fc_, arg1: number, arg2: Matrix3f_): this;
    mapYXnZ(): this;
    mapZnYnX(arg0: Matrix3f_): this;
    "rotation(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYXZ(arg0: Matrix3f_): this;
    reflection(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnZXnY(): this;
    invert(): this;
    m11(): number;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnXnY(arg0: Matrix3f_): this;
    rotateXYZ(arg0: Vec3f_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnXnZY(): this;
    negateZ(): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    mapnZnYnX(arg0: Matrix3f_): this;
    equals(arg0: any): boolean;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapXZY(): this;
    mapYnZX(arg0: Matrix3f_): this;
    m00(): number;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    "scaling(float)"(arg0: number): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnZXY(): this;
    "scaling(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    "reflect(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    identity(): this;
    scaling(arg0: Internal.Vector3fc_): this;
    mulLocal(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapXZnY(): this;
    "get3x4(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflect(arg0: Internal.Vector3fc_): this;
    "getNormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mul(arg0: Internal.Matrix3fc_): this;
    mapnZnYnX(): this;
    setFromAddress(arg0: number): this;
    m01(arg0: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    m12(): number;
    mapZnYnX(): this;
    mapnZYnX(arg0: Matrix3f_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    normal(): this;
    mapZYnX(arg0: Matrix3f_): this;
    mapnXZY(): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    "rotate(org.joml.Quaternionfc,org.joml.Matrix3f)"(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    get(arg0: number[]): number[];
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    negateY(): this;
    toString(arg0: Internal.NumberFormat_): string;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXYnZ(arg0: Matrix3f_): this;
    mapnYXnZ(): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number[], arg1: number): number[];
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnXnYnZ(arg0: Matrix3f_): this;
    mapZYX(arg0: Matrix3f_): this;
    "scale(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    m12(arg0: number): this;
    clone(): any;
    mapnYnZX(arg0: Matrix3f_): this;
    m01(): number;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    quadraticFormProduct(arg0: Internal.Vector3fc_): number;
    "set(int,int,float)"(arg0: number, arg1: number, arg2: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflection(arg0: Internal.Quaternionfc_): this;
    mapnYnZnX(arg0: Matrix3f_): this;
    transformTranspose(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapnZnXnY(): this;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    "reflection(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    m02(arg0: number): this;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXY(arg0: Matrix3f_): this;
    mapnYnXZ(): this;
    mapnXZnY(): this;
    mapYZX(): this;
    "get3x4(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnYXZ(): this;
    mulComponentWise(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapZXnY(arg0: Matrix3f_): this;
    negateX(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    toString(): string;
    mapnZYX(arg0: Matrix3f_): this;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    notifyAll(): void;
    mapYZnX(arg0: Matrix3f_): this;
    mapnZnYX(): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    mapnZXnY(arg0: Matrix3f_): this;
    mapZnXY(arg0: Matrix3f_): this;
    "reflect(org.joml.Vector3fc,org.joml.Matrix3f)"(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    reflection(arg0: Internal.Vector3fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    rotateX(arg0: number): this;
    mapnXZnY(arg0: Matrix3f_): this;
    "rotate(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mapYXZ(): this;
    setSkewSymmetric(arg0: number, arg1: number, arg2: number): this;
    "rotate(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    notify(): void;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m02(): number;
    mapZnXnY(): this;
    "set(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "set(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    negateX(arg0: Matrix3f_): this;
    mapnYZnX(): this;
    m22(arg0: number): this;
    mulComponentWise(arg0: Internal.Matrix3fc_): this;
    invert(arg0: Matrix3f_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    reflect(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    "getTransposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    readExternal(arg0: Internal.ObjectInput_): void;
    mapnZYX(): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): this;
    "get(float[],int)"(arg0: number[], arg1: number): number[];
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateX(arg0: number, arg1: Matrix3f_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    "getTransposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateYXZ(arg0: Vec3f_): this;
    determinant(): number;
    add(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    transpose(): this;
    "reflect(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "set(float[])"(arg0: number[]): this;
    m10(arg0: number): this;
    mapYnZnX(arg0: Matrix3f_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    rotateY(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    "reflect(org.joml.Quaternionfc,org.joml.Matrix3f)"(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    add(arg0: Internal.Matrix3fc_): this;
    scale(arg0: number, arg1: Matrix3f_): this;
    lerp(arg0: Internal.Matrix3fc_, arg1: number): this;
    mapYnXZ(arg0: Matrix3f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapnZXY(arg0: Matrix3f_): this;
    "get3x4(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapZnXY(): this;
    wait(arg0: number, arg1: number): void;
    cofactor(): this;
    mapnYnXnZ(): this;
    quadraticFormProduct(arg0: number, arg1: number, arg2: number): number;
    "set(org.joml.Matrix2fc)"(arg0: Internal.Matrix2fc_): this;
    "get(float[])"(arg0: number[]): number[];
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    swap(arg0: Matrix3f_): this;
    mapXnZnY(arg0: Matrix3f_): this;
    set(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "reflection(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    obliqueZ(arg0: number, arg1: number): this;
    negateY(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    m00(arg0: number): this;
    mapXnYnZ(arg0: Matrix3f_): this;
    mapXnZY(): this;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): Matrix4f;
    equals(arg0: Internal.Matrix3fc_, arg1: number): boolean;
    mapYZX(arg0: Matrix3f_): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: Internal.Matrix2fc_): this;
    mapnXnZnY(arg0: Matrix3f_): this;
    rotateZ(arg0: number): this;
    "getUnnormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    hashCode(): number;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    mapYnXnZ(): this;
    positiveY(arg0: Vec3f_): Vec3f;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    mapnYXZ(arg0: Matrix3f_): this;
    mapZXY(): this;
    scaling(arg0: number): this;
    set(arg0: number[]): this;
    zero(): this;
    set(arg0: Internal.Quaternionfc_): this;
    m11(arg0: number): this;
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    get class(): typeof any
    set transposed(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set "(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    set fromAddress(arg0: number)
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set "(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(float[])"(arg0: number[])
    set "(org.joml.Matrix2fc)"(arg0: Internal.Matrix2fc_)
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    m10: number;
    m21: number;
    m20: number;
    m01: number;
    m12: number;
    m00: number;
    m11: number;
    m22: number;
    m02: number;
}
type Matrix3f_ = Matrix3f;
declare class Matrix4f implements Internal.Cloneable, Internal.Matrix4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix4dc_)
    constructor(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: Internal.Matrix4x3fc_)
    scaleXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    testSphere(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    zero(): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    m32(arg0: number): this;
    "get4x3(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix4f_): this;
    "orthoLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapYXnZ(arg0: Matrix4f_): this;
    setTransposedFromAddress(arg0: number): this;
    "get(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "perspectiveRect(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRowColumn(arg0: number, arg1: number): number;
    "normalize3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "unprojectInv(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    "set(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "set(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    "mulPerspectiveAffine(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    "normal(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    "project(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    rotateX(arg0: number, arg1: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    m10(arg0: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapZYnX(): this;
    rotateLocalY(arg0: number, arg1: Matrix4f_): this;
    set(arg0: Internal.Matrix3fc_): this;
    invertAffine(arg0: Matrix4f_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number, arg4: Matrix4f_): this;
    m32(): number;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    "frustumLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYX(): this;
    mapYnXnZ(arg0: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    normal(arg0: Matrix3f_): Matrix3f;
    m21(arg0: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    rotationY(arg0: number): this;
    getRotation(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "unproject(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "ortho(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m21(): number;
    isFinite(): boolean;
    transformProject(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    m30(arg0: number): this;
    setRotationYXZ(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix4fc_): this;
    m10(): number;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number): this;
    set(arg0: number, arg1: number, arg2: number): this;
    mapnZnXnY(): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get3x3(org.joml.Matrix3d)"(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    mapYXZ(arg0: Matrix4f_): this;
    "get4x3Transposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotation(arg0: Internal.Quaternionfc_): this;
    rotateAffine(arg0: Internal.Quaternionfc_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    get4x3Transposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    transpose3x3(arg0: Matrix3f_): Matrix3f;
    translate(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    "transformProject(org.joml.Vector4fc,org.joml.Vector3f)"(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "set4x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    mapYZnX(): this;
    rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleLocal(arg0: number): this;
    rotateZ(arg0: number, arg1: Matrix4f_): this;
    setTransposed(arg0: Internal.FloatBuffer_): this;
    set(arg0: Internal.FloatBuffer_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    "getRow(int,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): Vec4f;
    perspectiveInvOrigin(arg0: Vec3f_): Vec3f;
    transformTranspose(arg0: Vec4f_): Vec4f;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapnYnXZ(arg0: Matrix4f_): this;
    mapZnYX(arg0: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapnZXnY(): this;
    "shadow(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getToAddress(arg0: number): Internal.Matrix4fc;
    mapnXZY(): this;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    transformProject(arg0: Vec4f_): Vec4f;
    "set(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    negateZ(): this;
    m23(): number;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    equals(arg0: Internal.Matrix4fc_, arg1: number): boolean;
    lookAtPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get4x3Transposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    m12(): number;
    mapnYnZX(arg0: Matrix4f_): this;
    "getColumn(int,org.joml.Vector4f)"(arg0: number, arg1: Vec4f_): Vec4f;
    translationRotate(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    "reflect(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "orthoSymmetricLH(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    mapXZY(): this;
    transformDirection(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "transformProject(float,float,float,float,org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    "mul(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    mapYXnZ(): this;
    m01(arg0: number): this;
    m01(): number;
    "get(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    mapYZnX(arg0: Matrix4f_): this;
    "translationRotateScaleInvert(org.joml.Vector3fc,org.joml.Quaternionfc,float)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    translate(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnZXnY(arg0: Matrix4f_): this;
    mapZnXY(arg0: Matrix4f_): this;
    transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Vec3f_, arg7: Vec3f_): this;
    invertOrtho(): this;
    "scaling(float)"(arg0: number): this;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    "get4x3Transposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateLocalY(arg0: number): this;
    billboardCylindrical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "scaling(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "ortho(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapnYXZ(): this;
    setFromIntrinsic(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    negateX(): this;
    setColumn(arg0: number, arg1: Internal.Vector4fc_): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    notify(): void;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get4x3(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    rotateYXZ(arg0: Vec3f_): this;
    mapnYXZ(arg0: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "reflection(org.joml.Vector3fc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    cofactor3x3(arg0: Matrix4f_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    "rotate(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    translationRotateScaleMulAffine(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    "orthoSymmetric(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    invertOrtho(arg0: Matrix4f_): this;
    mapYZX(arg0: Matrix4f_): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    m03(): number;
    "get(float[])"(arg0: number[]): number[];
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    translationRotateScaleMulAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: Matrix4f_): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    cofactor3x3(): this;
    scaleXY(arg0: number, arg1: number): this;
    m12(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    translateLocal(arg0: Internal.Vector3fc_): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaling(arg0: number): this;
    mapZnXY(): this;
    "setTransposed(float[])"(arg0: number[]): this;
    "unprojectInv(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "transformProject(org.joml.Vector3f)"(arg0: Vec3f_): Vec3f;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    hashCode(): number;
    positiveY(arg0: Vec3f_): Vec3f;
    negateX(arg0: Matrix4f_): this;
    setOrtho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translation(arg0: Internal.Vector3fc_): this;
    m23(arg0: number): this;
    translationRotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "set(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    "orthoSymmetric(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    setRow(arg0: number, arg1: Internal.Vector4fc_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    trapezoidCrop(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaternionfc_): this;
    transformPosition(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setOrtho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInvRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZnYnX(arg0: Matrix4f_): this;
    "getNormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "get(int,int)"(arg0: number, arg1: number): number;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    get4x3(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number, arg16: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_): this;
    "transformProject(org.joml.Vector3fc,org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapZYX(): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    get3x3(arg0: org.joml.Matrix3d_): org.joml.Matrix3d;
    mapnXnYnZ(): this;
    setTransposed(arg0: Internal.ByteBuffer_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    "frustum(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapZnYnX(arg0: Matrix4f_): this;
    positiveZ(arg0: Vec3f_): Vec3f;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    invertPerspective(): this;
    mapnYnZX(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    mapXnZY(arg0: Matrix4f_): this;
    translate(arg0: number, arg1: number, arg2: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number): this;
    "rotate(org.joml.Quaternionfc,org.joml.Matrix4f)"(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapnXYnZ(): this;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    mulLocal(arg0: Internal.Matrix4fc_): this;
    rotateXYZ(arg0: Internal.Vector3fc_): this;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    set(arg0: number[], arg1: number): this;
    get3x3(arg0: Matrix3f_): Matrix3f;
    "mulPerspectiveAffine(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "set3x3(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    mapXnYnZ(): this;
    negateZ(arg0: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "set(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    "getColumn(int,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): Vec3f;
    mul(arg0: Internal.Matrix4x3fc_): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "project(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateTowardsXY(arg0: number, arg1: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Matrix4f_): this;
    setLookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    sub(arg0: Internal.Matrix4fc_): this;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    "transformProject(float,float,float,float,org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    m03(arg0: number): this;
    get(arg0: number, arg1: number): number;
    mapnYZX(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "translationRotateScale(org.joml.Vector3fc,org.joml.Quaternionfc,float)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    invert(): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    "setTransposed(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "get4x3Transposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    perspectiveNear(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnYZX(arg0: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_): this;
    "getTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: Vec4f_, arg1: Matrix4f_): this;
    "scale(org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    perspectiveOrigin(arg0: Vec3f_): Vec3f;
    frustumAabb(arg0: Vec3f_, arg1: Vec3f_): this;
    "set(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    "rotation(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_): this;
    mulLocal(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "set(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_): this;
    "mul(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_): this;
    mapXnYnZ(arg0: Matrix4f_): this;
    setTranslation(arg0: Internal.Vector3fc_): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    isAffine(): boolean;
    "scale(float,org.joml.Matrix4f)"(arg0: number, arg1: Matrix4f_): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapYnXnZ(): this;
    "get3x4(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    set(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_): this;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_): this;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "getNormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotateX(arg0: number): this;
    invertFrustum(): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number): this;
    "set(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    mapnYnZnX(arg0: Matrix4f_): this;
    "get(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    "invertPerspectiveView(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    mapnYnXnZ(): this;
    identity(): this;
    set4x3(arg0: Internal.Matrix4x3fc_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translateLocal(arg0: number, arg1: number, arg2: number): this;
    clone(): any;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    invert(arg0: Matrix4f_): this;
    mapZnYnX(): this;
    frustumRayDir(arg0: number, arg1: number, arg2: Vec3f_): Vec3f;
    mapnZnYX(): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "mulPerspectiveAffine(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    translationRotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "mul(org.joml.Matrix3x2fc,org.joml.Matrix4f)"(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    sub4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_): this;
    properties(): number;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    "unproject(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    toString(): string;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    translationRotateInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    mapnYnXZ(): this;
    mapnZnXY(arg0: Matrix4f_): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "perspectiveOffCenterFovLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    translateLocal(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mapnZnYnX(): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): this;
    normalize3x3(arg0: Matrix3f_): Matrix3f;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    scaleLocal(arg0: number, arg1: Matrix4f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    "perspectiveOffCenter(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateZ(arg0: number): this;
    rotateLocalZ(arg0: number, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: Matrix4f_): this;
    "get3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    "invertPerspectiveView(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    "rotate(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapYnZnX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "set(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    reflection(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    testPoint(arg0: number, arg1: number, arg2: number): boolean;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveFov(): number;
    "get4x3(org.joml.Matrix4x3f)"(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    mapZYnX(arg0: Matrix4f_): this;
    mapZXY(): this;
    "get4x3(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "get4x3(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "transpose3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    mapnXYnZ(arg0: Matrix4f_): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number): this;
    withLookAtUp(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnYnZnX(): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapnXnYnZ(arg0: Matrix4f_): this;
    mapYnZnX(arg0: Matrix4f_): this;
    mapnZnYX(arg0: Matrix4f_): this;
    origin(arg0: Vec3f_): Vec3f;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    determinantAffine(): number;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    obliqueZ(arg0: number, arg1: number): this;
    "mul(org.joml.Matrix4x3fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    "perspective(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnZYnX(): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateY(arg0: number, arg1: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    "orthoLH(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    rotateAffine(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    mapXZnY(arg0: Matrix4f_): this;
    rotateLocalX(arg0: number, arg1: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZXY(arg0: Matrix4f_): this;
    mapnYXnZ(arg0: Matrix4f_): this;
    mapZXnY(): this;
    m31(): number;
    transformAffine(arg0: Vec4f_): Vec4f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    get4x3Transposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "scale(float)"(arg0: number): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m20(arg0: number): this;
    reflection(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotationZ(arg0: number): this;
    static perspectiveOffCenterViewFromRectangle(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_, arg4: number, arg5: boolean, arg6: Matrix4f_, arg7: Matrix4f_): void;
    mapZXY(arg0: Matrix4f_): this;
    cofactor3x3(arg0: Matrix3f_): Matrix3f;
    mapnYnXnZ(arg0: Matrix4f_): this;
    "getRotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    m20(): number;
    get(arg0: Matrix4f_): this;
    transform(arg0: Vec4f_): Vec4f;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    normal(arg0: Matrix4f_): this;
    m33(arg0: number): this;
    "get3x4(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    set3x3(arg0: Internal.Matrix3fc_): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    unprojectRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    "translationRotateScale(org.joml.Vector3fc,org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    normalize3x3(arg0: Matrix4f_): this;
    "shadow(org.joml.Vector4f,float,float,float,float)"(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    "frustumLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    getScale(arg0: Vec3f_): Vec3f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    setRotationXYZ(arg0: number, arg1: number, arg2: number): this;
    mapZnXnY(): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    invertFrustum(arg0: Matrix4f_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    wait(arg0: number): void;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    "transformProject(org.joml.Vector4fc,org.joml.Vector4f)"(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotationTowardsXY(arg0: number, arg1: number): this;
    "normalize3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    orthoCrop(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "shadow(org.joml.Vector4f,float,float,float,float,org.joml.Matrix4f)"(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    unprojectInvRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    transpose3x3(arg0: Matrix4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "reflect(org.joml.Quaternionfc,org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    "unprojectInv(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    m33(): number;
    transpose(arg0: Matrix4f_): this;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    set(arg0: Internal.Matrix4fc_): this;
    rotationX(arg0: number): this;
    "set(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    m22(): number;
    m31(arg0: number): this;
    mapZYX(arg0: Matrix4f_): this;
    mulAffineR(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m11(): number;
    mapYnZX(arg0: Matrix4f_): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_): this;
    mapnZnXY(): this;
    setTransposed(arg0: Internal.Matrix4fc_): this;
    setRotationZYX(arg0: number, arg1: number, arg2: number): this;
    assume(arg0: number): this;
    "unproject(float,float,float,int[],org.joml.Vector4f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    transformAab(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_, arg3: Vec3f_): this;
    rotateTowardsXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    equals(arg0: any): boolean;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "perspectiveOffCenterFov(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapnZYnX(arg0: Matrix4f_): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    m00(): number;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    "cofactor3x3(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    m13(arg0: number): this;
    invertPerspective(arg0: Matrix4f_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnZXY(): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    "normal(org.joml.Matrix3f)"(arg0: Matrix3f_): Matrix3f;
    translationRotateScaleInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    get(arg0: number[], arg1: number): number[];
    mapXZnY(): this;
    "setTransposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): this;
    set(arg0: Internal.Matrix4dc_): this;
    negateY(): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapnZYX(arg0: Matrix4f_): this;
    sub(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    "perspectiveRect(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getRow(arg0: number, arg1: Vec4f_): Vec4f;
    "getRotation(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    "perspectiveLH(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getColumn(arg0: number, arg1: Vec4f_): Vec4f;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnYXnZ(): this;
    transpose3x3(): this;
    rotateAroundAffine(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    transformProject(arg0: Vec3f_): Vec3f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    sub4x3(arg0: Matrix4f_): this;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    translationRotateInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    testAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "reflect(org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    m13(): number;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    mapYZX(): this;
    "get4x3(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    "getRow(int,org.joml.Vector3f)"(arg0: number, arg1: Vec3f_): Vec3f;
    "unprojectInv(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    setFromAddress(arg0: number): this;
    m02(arg0: number): this;
    "mulPerspectiveAffine(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    mapnYZnX(arg0: Matrix4f_): this;
    transformAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    m02(): number;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    transformTranspose(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    transpose(): this;
    "perspectiveOffCenterFov(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    "set(float[])"(arg0: number[]): this;
    set(arg0: number[]): this;
    m11(arg0: number): this;
    mulAffine(arg0: Internal.Matrix4fc_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    "project(float,float,float,int[],org.joml.Vector3f)"(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    positiveX(arg0: Vec3f_): Vec3f;
    setTranslation(arg0: number, arg1: number, arg2: number): this;
    m22(arg0: number): this;
    mapXnZY(): this;
    originAffine(arg0: Vec3f_): Vec3f;
    "set4x3(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_): this;
    mapnZYX(): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number): this;
    "get3x4(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    normal(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    setLookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    mulTranslationAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    "reflection(org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    "set(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    "unproject(org.joml.Vector3fc,int[],org.joml.Vector4f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mul(arg0: Internal.Matrix3x2fc_): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    "perspectiveOffCenterFovLH(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    scaling(arg0: Internal.Vector3fc_): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    mapnYZnX(): this;
    m00(arg0: number): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    get4x3Transposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mulComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "rotate(float,org.joml.Vector3fc)"(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.ByteBuffer_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    "getUnnormalizedRotation(org.joml.Quaterniond)"(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    set3x3(arg0: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    "getTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnXZY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaterniondc_): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnXnZY(arg0: Matrix4f_): this;
    mapXZY(arg0: Matrix4f_): this;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mulComponentWise(arg0: Internal.Matrix4fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    "perspectiveLH(float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    add(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    swap(arg0: Matrix4f_): this;
    transformDirection(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    negateY(arg0: Matrix4f_): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    getClass(): typeof any;
    "transformProject(org.joml.Vector4f)"(arg0: Vec4f_): Vec4f;
    add(arg0: Internal.Matrix4fc_): this;
    determineProperties(): this;
    mapXnZnY(): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    "set(float[],int)"(arg0: number[], arg1: number): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "shadow(float,float,float,float,org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    withLookAtUp(arg0: Internal.Vector3fc_): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapYnZX(): this;
    mapnXnYZ(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mapnXnZnY(): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    lookAtPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    mapZnXnY(arg0: Matrix4f_): this;
    setTransposed(arg0: number[], arg1: number): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    "translationRotateScaleInvert(org.joml.Vector3fc,org.joml.Quaternionfc,org.joml.Vector3fc)"(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    get4x3Transposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    get4x3(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    scale(arg0: Internal.Vector3fc_): this;
    "mul(org.joml.Matrix4fc,org.joml.Matrix4f)"(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    "cofactor3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    transformPosition(arg0: Vec3f_): Vec3f;
    "rotation(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    affineSpan(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    transformDirection(arg0: Vec3f_): Vec3f;
    perspectiveFrustumSlice(arg0: number, arg1: number, arg2: Matrix4f_): this;
    determinant3x3(): number;
    wait(): void;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "frustum(float,float,float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    projectedGridRange(arg0: Internal.Matrix4fc_, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnXnY(arg0: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    rotationAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    set4x3(arg0: Matrix4f_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    "get(org.joml.Matrix4d)"(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    "setTransposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_): this;
    get4x3(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    translateLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnXnYZ(arg0: Matrix4f_): this;
    normalize3x3(): this;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    mapnXnZY(): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    translation(arg0: number, arg1: number, arg2: number): this;
    "transpose3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    frustumPlane(arg0: number, arg1: Vec4f_): Vec4f;
    transformPosition(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    invertAffine(): this;
    frustumCorner(arg0: number, arg1: Vec3f_): Vec3f;
    "project(org.joml.Vector3fc,int[],org.joml.Vector3f)"(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    get(arg0: number[]): number[];
    shadow(arg0: Vec4f_, arg1: Internal.Matrix4fc_, arg2: Matrix4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    mapZXnY(arg0: Matrix4f_): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    get4x3(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "get3x4(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYnXZ(): this;
    setTransposed(arg0: number[]): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    "scale(org.joml.Vector3fc)"(arg0: Internal.Vector3fc_): this;
    rotateY(arg0: number): this;
    rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    invertPerspectiveView(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    notifyAll(): void;
    add4x3(arg0: Internal.Matrix4fc_): this;
    mapnXZnY(): this;
    mulAffineR(arg0: Internal.Matrix4fc_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "orthoSymmetricLH(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    transformAffine(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    perspectiveFar(): number;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapnXnZnY(arg0: Matrix4f_): this;
    set(arg0: Internal.Quaternionfc_): this;
    "rotate(org.joml.AxisAngle4f,org.joml.Matrix4f)"(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    mapYnXZ(arg0: Matrix4f_): this;
    "getTransposed(int,java.nio.FloatBuffer)"(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    "perspective(float,float,float,float,boolean)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    "get(float[],int)"(arg0: number[], arg1: number): number[];
    "getTransposed(int,java.nio.ByteBuffer)"(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapXnZnY(arg0: Matrix4f_): this;
    mapYXZ(): this;
    determinant(): number;
    "reflect(org.joml.Vector3fc,org.joml.Vector3fc,org.joml.Matrix4f)"(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    add4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    wait(arg0: number, arg1: number): void;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "perspectiveOffCenter(float,float,float,float,float,float,org.joml.Matrix4f)"(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapnXZnY(arg0: Matrix4f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    translate(arg0: Internal.Vector3fc_): this;
    "get(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    m30(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    "set3x3(org.joml.Matrix4f)"(arg0: Matrix4f_): this;
    "getUnnormalizedRotation(org.joml.Quaternionf)"(arg0: Quaternionf_): Quaternionf;
    "mul(org.joml.Matrix3x2fc)"(arg0: Internal.Matrix3x2fc_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    getTranslation(arg0: Vec3f_): Vec3f;
    invertPerspectiveView(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    set transposedFromAddress(arg0: number)
    set "(org.joml.AxisAngle4d)"(arg0: Internal.AxisAngle4d_)
    get finite(): boolean
    set transposed(arg0: Internal.FloatBuffer_)
    set "(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "transposed(float[])"(arg0: number[])
    set "(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set transposed(arg0: Internal.ByteBuffer_)
    set "(org.joml.Quaternionfc)"(arg0: Internal.Quaternionfc_)
    set "transposed(org.joml.Matrix4fc)"(arg0: Internal.Matrix4fc_)
    set "(org.joml.Matrix4dc)"(arg0: Internal.Matrix4dc_)
    set "(org.joml.Matrix3fc)"(arg0: Internal.Matrix3fc_)
    set translation(arg0: Internal.Vector3fc_)
    get affine(): boolean
    set "(org.joml.AxisAngle4f)"(arg0: Internal.AxisAngle4f_)
    set "(org.joml.Matrix4x3fc)"(arg0: Internal.Matrix4x3fc_)
    set "(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set transposed(arg0: Internal.Matrix4fc_)
    set "transposed(java.nio.FloatBuffer)"(arg0: Internal.FloatBuffer_)
    set fromAddress(arg0: number)
    set "(float[])"(arg0: number[])
    set "(org.joml.Quaterniondc)"(arg0: Internal.Quaterniondc_)
    get class(): typeof any
    set "transposed(java.nio.ByteBuffer)"(arg0: Internal.ByteBuffer_)
    set transposed(arg0: number[])
}
type Matrix4f_ = Matrix4f;
/**
 * The hub for all things text components. Format text to your hearts content!
*/
declare class Component {
    constructor()
    getClass(): typeof any;
    /**
     * Returns a component of the input, colored light purple
    */
    static lightPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored blue
    */
    static blue(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translatable(key: string): Internal.MutableComponent;
    /**
     * Returns a ClickEvent of the input
    */
    static clickEventOf(o: any): Internal.ClickEvent;
    /**
     * Returns a colorful representation of the input nbt. Useful for displaying NBT to the player
    */
    static prettyPrintNbt(tag: Internal.Tag_): Internal.Component;
    /**
     * Returns an empty component
    */
    static empty(): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translatable(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored white
    */
    static white(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translate(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a plain component of the string, or empty if it is an empty string
    */
    static ofString(s: string): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translate(key: string): Internal.MutableComponent;
    notify(): void;
    wait(arg0: number, arg1: number): void;
    /**
     * Returns a component displaying all entities matching the input selector
    */
    static selector(selector: string): Internal.MutableComponent;
    /**
     * Checks if the passed in component, and all its children are empty
    */
    static isEmpty(component: Internal.Component_): boolean;
    /**
     * Returns a component of the input, colored yellow
    */
    static yellow(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark purple
    */
    static darkPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a Component of the input
    */
    static of(o: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gray
    */
    static gray(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark blue
    */
    static darkBlue(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark red
    */
    static darkRed(text: any): Internal.MutableComponent;
    toString(): string;
    /**
     * Returns a component of the input, colored gold
    */
    static gold(text: any): Internal.MutableComponent;
    notifyAll(): void;
    /**
     * Returns a component of the input, colored red
    */
    static red(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark green
    */
    static darkGreen(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored green
    */
    static green(text: any): Internal.MutableComponent;
    /**
     * Returns a keybinding component of the input keybinding descriptor
    */
    static keybind(keybind: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark aqua
    */
    static darkAqua(text: any): Internal.MutableComponent;
    /**
     * Joins all components
    */
    static join(...texts: Internal.Component_[]): Internal.MutableComponent;
    hashCode(): number;
    /**
     * Returns a score component of the input objective, for the provided selector
    */
    static score(selector: string, objective: string): Internal.MutableComponent;
    /**
     * Returns a plain component of the passed in string, even if empty
    */
    static string(text: string): Internal.MutableComponent;
    wait(): void;
    /**
     * Joins all components in the list with the separator component
    */
    static join(separator: Internal.MutableComponent_, texts: Internal.Iterable_<Internal.Component>): Internal.MutableComponent;
    /**
     * Returns a component displaying all entities matching the input selector, with a custom separator
    */
    static selector(selector: string, separator: Internal.Component_): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored aqua
    */
    static aqua(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored black
    */
    static black(text: any): Internal.MutableComponent;
    wait(arg0: number): void;
    /**
     * Returns a component of the input, colored dark gray
    */
    static darkGray(text: any): Internal.MutableComponent;
    /**
     * Returns a plain component of the input
    */
    static literal(text: string): Internal.MutableComponent;
    equals(arg0: any): boolean;
    get class(): typeof any
}
type Component_ = Component;
/**
 * A collection of utilities
*/
declare interface Utils {
    /**
     * Capitalises the first letter of the string unless it is "a", "an", "the", "of", "on", "in", "and", "or", "but" or "for"
    */
    toTitleCase(s: string): string;
    /**
     * Returns a Stat of the passed in ResourceLocation.
     * Note that this requires the same ResourceLocation to get the same stat, so should not be used unless you want to make your own stat, and are storing an actual ResourceLocation somewhere to access it.
    */
    getStat(id: ResourceLocation_): Internal.Stat<ResourceLocation>;
    /**
     * Returns the provided snake_case_string in Title Case
    */
    snakeCaseToTitleCase(string: string): string;
    /**
     * Returns a new counting map
    */
    newCountingMap(): Internal.CountingMap;
    /**
     * Capitalises the first letter of the string. If ignoreSpecial is true, it will also capitalise articles and prepositions
    */
    toTitleCase(s: string, ignoreSpecial: boolean): string;
    /**
     * Tries to parse the first parameter as a double and returns that. The second parameter is returned if parsing fails
    */
    parseDouble(object: any, def: number): number;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    getRandom(): Internal.Random;
    /**
     * Returns a new mutable list
    */
    newList(): Internal.List<any>;
    /**
     * Returns the results of rolling the specified loot table (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_): Internal.List<Internal.ItemStack>;
    /**
     * Get a new random with the specified seed
    */
    newRandom(seed: number): Internal.Random;
    /**
     * Gets all ids from the registry with the specified id
    */
    getRegistryIds(id: ResourceLocation_): Internal.List<ResourceLocation>;
    /**
     * Get an immutable empty list
    */
    emptyList<T>(): Internal.List<T>;
    /**
     * Gets the current system time, in milliseconds
    */
    getSystemTime(): number;
    /**
     * Runs the provided supplier function in KubeJS' background thread and returns its CompletableFuture
    */
    supplyAsync(task: Internal.Supplier_<any>): Internal.CompletableFuture<any>;
    /**
     * Returns a ResourceLocation with the specified namepsace and path
    */
    id(namespace: string, path: string): ResourceLocation;
    /**
     * Returns a lazy value with the supplier function as its value factory
    */
    lazy<T>(supplier: Internal.Supplier_<T>): Internal.Lazy<T>;
    /**
     * Checks if the passed in object is an instance of WrappedJS
    */
    isWrapped(o: any): boolean;
    /**
     * Returns the provided snake_case_string in camelCase
    */
    snakeCaseToCamelCase(string: string): string;
    /**
     * Returns the creative tab associated with the id
    */
    findCreativeTab(id: ResourceLocation_): Internal.CreativeModeTab;
    /**
     * Get an immutable empty map
    */
    emptyMap<K, V>(): Internal.Map<K, V>;
    /**
     * Gets a SoundEvent from the id
    */
    getSound(id: ResourceLocation_): Internal.SoundEvent;
    /**
     * Returns a lazy value with the supplier function as its value factory, that will expire after the specified number of milliseconds
    */
    expiringLazy<T>(supplier: Internal.Supplier_<T>, time: number): Internal.Lazy<T>;
    /**
     * Gets a random object from the list using the passed in random
    */
    randomOf(random: Internal.Random_, objects: Internal.Collection_<any>): any;
    /**
     * Returns a new mutable map
    */
    newMap(): Internal.Map<any, any>;
    /**
     * Gets the specified registry
    */
    getRegistry(id: ResourceLocation_): Internal.RegistryInfo<any>;
    particleOptions(o: any): Internal.ParticleOptions;
    /**
     * Returns a copy the object if possible, or the object itself if not
    */
    copy(o: any): any;
    /**
     * Returns a regex pattern of the input with the specified flags
    */
    regex(pattern: string, flags: number): Internal.Pattern;
    /**
     * Typewraps the input string to a ResourceLocation. Format should be namespace:path
    */
    id(id: ResourceLocation_): ResourceLocation;
    /**
     * Returns a regex pattern of the input
    */
    regex(s: any): Internal.Pattern;
    /**
     * Runs the provided runnable function in KubeJS' background thread and returns its CompletableFuture
    */
    runAsync(task: Internal.Runnable_): Internal.CompletableFuture<void>;
    /**
     * Parses a block state from the input string. May throw for invalid inputs!
    */
    parseBlockState(o: any): Internal.BlockState;
    /**
     * Immediately run the passed runnable function in a try-catch block, and log the exception if it throws
    */
    queueIO(runnable: Internal.Runnable_): void;
    /**
     * Tries to parse the first parameter as an integer, and returns that. The second parameter is returned if parsing fails
    */
    parseInt(object: any, def: number): number;
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    getServer(): Internal.MinecraftServer;
    /**
     * Returns the results of rolling the specified loot table with the entity as a parameter (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_, entity: Internal.Entity_): Internal.List<Internal.ItemStack>;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    get random(): Internal.Random
    /**
     * Gets the current system time, in milliseconds
    */
    get systemTime(): number
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    get server(): Internal.MinecraftServer
    readonly ERROR_PARTICLE: (Internal.DustParticleOptions) & (Internal.DustParticleOptions);
}
type Utils_ = Utils;
declare const Utils: Utils;
declare interface AABB {
    ofSize(vec3: Vec3d_, x: number, y: number, z: number): Internal.AABB;
    ofBlock(pos: BlockPos_): Internal.AABB;
    of(x0: number, y0: number, z0: number, x1: number, y1: number, z1: number): Internal.AABB;
    ofSize(x: number, y: number, z: number): Internal.AABB;
    ofBlocks(pos1: BlockPos_, pos2: BlockPos_): Internal.AABB;
    wrap(o: any): Internal.AABB;
    readonly CUBE: (Internal.AABB) & (Internal.AABB);
    readonly EMPTY: (Internal.AABB) & (Internal.AABB);
}
type AABB_ = AABB;
declare const AABB: AABB;
declare namespace Special {
    type Mod = "rsrequestify" | "kuma_api" | "mowlib" | "exdeorum" | "supermartijn642configlib" | "geckolib" | "end_portal_easy_recipe" | "craftable_slimeball" | "morejs" | "forgepeacefulmobdrops" | "vegandelight" | "peco" | "sophisticatedcore" | "create_jetpack" | "not_interested" | "laserio" | "xaeroworldmap" | "controlling" | "placebo" | "modernfix" | "autochefsdelight" | "cabletiers" | "mixinextras" | "cobweb" | "ntgbb" | "craftable_bee_spawn_egg" | "sophisticatedbackpacks" | "railways" | "balm" | "jeresources" | "create_jetpack_curios" | "craftable_elytra_remastered" | "mob_grinding_utils" | "refinedstorage" | "athena" | "corpse" | "exmachinis" | "w2w2" | "farmersdelight" | "rebornstorage" | "chefsdelight" | "supermartijn642corelib" | "engineeredcompatibility" | "create_recipes" | "superflattrades" | "curios" | "patchouli" | "non_wandering_trader" | "nocubes_more_furnace_fuel" | "mobdropsrecipes_end" | "collective" | "searchables" | "taxhm" | "ftbultimine" | "resourcefullib" | "extrastorage" | "peacefulrecipes" | "architectury" | "mcwfurnitures" | "flib" | "monolib" | "flightlib" | "mob_catcher" | "jadeaddons" | "framework" | "probejs" | "lava_source" | "cobblefordays" | "fastleafdecay" | "yeetusexperimentus" | "enchantinginfuser" | "sliceanddice" | "mobdropsrecipes_nether" | "smartcrafter" | "betteradvancements" | "easy_mob_farm" | "fastback" | "rhino" | "watersources" | "peaceful_hunger" | "ftblibrary" | "copycats" | "lithostitched" | "create_netherless" | "mobdropsrecipes_overworld" | "bdlib" | "waystones" | "create_waystones_recipes" | "actuallyharvest" | "clumps" | "comforts" | "naturescompass" | "smarterfarmers" | "storagenetwork" | "libx" | "refstoragefluxified" | "craftable_spawner" | "farmingforblockheads" | "create_confectionery" | "pedestals" | "toastcontrol" | "extradisks" | "create_refined_recipes" | "edivadlib" | "more_immersive_wires" | "puzzlesaccessapi" | "forge" | "jeimultiblocks" | "additionalredstone" | "ironchest" | "minecraft" | "christmasmusicdiscs" | "moonlight" | "titanium" | "createsweetsandtreets" | "immersiveengineering" | "createsifter" | "nochatreports" | "jade" | "creativecore" | "spectrelib" | "createendertransmission" | "compacter" | "kotlinforforge" | "easy_villagers" | "pipez" | "flywheel" | "create" | "create_mechanical_chicken" | "xaerominimap" | "refinedstoragedelight" | "nocubes_craftable_md" | "polymorph" | "justenoughprofessions" | "almostunified" | "jei" | "kubejs" | "invtweaks" | "createcompression" | "creativecrafter" | "kubejs_create" | "portabletanks" | "appleskin" | "ferritecore" | "engineersdecor" | "puzzleslib" | "refinedstorageaddons" | "refinedpolymorph" | "craftable_spawner_p" | "createaddition"
    type Ingredient = "libx:effect" | "immersiveengineering:fluid" | "kubejs:wildcard" | "kubejs:custom" | "kubejs:custom_predicate" | "kubejs:mod" | "kubejs:regex" | "kubejs:creative_tab" | "farmersdelight:tool_action" | "forge:compound" | "forge:nbt" | "forge:partial_nbt" | "forge:difference" | "forge:intersection" | "minecraft:item" | "create:block_tag_ingredient" | "mob_grinding_utils:fluid";
    type Advancement = "minecraft:recipes/building_blocks/weathered_cut_copper_stairs_from_weathered_copper_stonecutting" | "immersiveengineering:recipes/misc/stonecutting/slab_hempcrete" | "minecraft:recipes/redstone/acacia_button" | "minecraft:recipes/decorations/brick_wall" | "minecraft:recipes/building_blocks/stone_bricks" | "minecraft:recipes/building_blocks/polished_deepslate" | "create:recipes/building_blocks/cut_scorchia_brick_slab_from_stone_types_scorchia_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_locometal_smokebox" | "minecraft:husbandry/allay_deliver_item_to_player" | "minecraft:recipes/combat/leather_helmet" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab" | "farmersdelight:recipes/cooking/mushroom_rice" | "immersiveengineering:recipes/misc/crafting/connector_mv" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_locometal_boiler" | "create:recipes/misc/crafting/kinetics/white_sailfrom_conversion" | "minecraft:recipes/decorations/blast_furnace" | "minecraft:recipes/decorations/ladder" | "minecraft:recipes/decorations/red_nether_brick_wall" | "railways:recipes/combat/dying_existing_cap_light_gray" | "minecraft:recipes/decorations/magenta_stained_glass_pane" | "create:recipes/misc/crafting/kinetics/mechanical_saw" | "minecraft:recipes/building_blocks/stripped_mangrove_wood" | "refinedstorage:recipes/misc/coloring_recipes/black_grid" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_brass_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/storage_steel_to_slab" | "create:recipes/building_blocks/cut_tuff_from_stone_types_tuff_stonecutting" | "extrastorage:recipes/misc/disk/shapeless/disk_4096k" | "create:recipes/building_blocks/small_ochrum_brick_slab_recycling" | "farmersdelight:recipes/food/egg_sandwich" | "create:recipes/misc/smelting/ingot_osmium_compat_mekanism" | "create:recipes/building_blocks/birch_window" | "immersiveengineering:main/creosote" | "create:recipes/building_blocks/cut_deepslate_brick_stairs" | "immersiveengineering:recipes/misc/smoking/clinker_brick" | "immersiveengineering:recipes/misc/crafting/connector_lv" | "refinedstorage:recipes/misc/coloring_recipes/blue_network_receiver" | "railways:recipes/misc/crafting/palettes/wrapping/orange_iron_wrapped_locometal" | "extrastorage:recipes/misc/raw_neural_processor" | "minecraft:recipes/decorations/brown_banner" | "immersiveengineering:recipes/misc/crafting/toolupgrade_powerpack_magnet" | "immersiveengineering:multiblocks/mb_improvedblastfurnace" | "create:recipes/building_blocks/cut_andesite_brick_stairs" | "exdeorum:recipes/tools/compressed_stone_hammer" | "refinedstorage:recipes/misc/coloring_recipes/brown_crafter" | "refinedstorage:recipes/misc/coloring_recipes/controller" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_flat_riveted_locometal" | "immersiveengineering:recipes/misc/crafting/turntable" | "farmersdelight:recipes/food/melon_juice" | "refinedstorage:recipes/misc/crafting_grid/white_crafting_grid" | "create:recipes/misc/crafting/kinetics/vertical_gearboxfrom_conversion" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_plated_locometal" | "create:recipes/misc/crafting/kinetics/rotation_speed_controller" | "railways:recipes/misc/crafting/palettes/wrapping/green_brass_wrapped_locometal" | "farmersdelight:recipes/food/grilled_salmon" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_locometal_boiler" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_cobbled_deepslate_stonecutting" | "farmersdelight:recipes/decorations/brown_canvas_sign" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/mangrove_planks" | "create:recipes/decorations/brass_bars_from_ingots_brass_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_iron_wrapped_locometal" | "create:recipes/building_blocks/small_veridium_brick_slab" | "exdeorum:recipes/misc/diamond_mesh_from_golden_mesh" | "refinedstorage:viewing_fluids" | "minecraft:recipes/misc/lapis_lazuli_from_smelting_deepslate_lapis_ore" | "create:recipes/building_blocks/small_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "create:recipes/misc/smelting/zinc_ingot_from_ore" | "refinedstorage:recipes/misc/coloring_recipes/lime_crafter_manager" | "refinedstorage:recipes/misc/coloring_recipes/green_fluid_grid" | "refinedstorage:recipes/misc/coloring_recipes/cyan_network_receiver" | "minecraft:recipes/misc/emerald" | "immersiveengineering:recipes/misc/crafting/treated_wood_horizontal" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/brick_stairs" | "vegandelight:tutorial/tofu_patty" | "create:recipes/building_blocks/cut_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/decorations/deepslate_brick_wall_from_deepslate_bricks_stonecutting" | "create:recipes/building_blocks/scoria_from_stone_types_scoria_stonecutting" | "farmersdelight:recipes/decorations/basket" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_brass_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_copper_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_copper_stonecutting" | "create:recipes/misc/crafting/kinetics/light_gray_valve_handle_from_other_valve_handle" | "railways:recipes/misc/crafting/copycat_headstock_link_and_pin" | "exdeorum:recipes/misc/iron_mesh" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "immersiveengineering:recipes/misc/crafting/stairs_concrete_leaded" | "create:recipes/building_blocks/crafting/kinetics/yellow_seat_from_other_seat" | "minecraft:recipes/misc/eye_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "immersiveengineering:recipes/misc/crafting/armor_faraday_chestplate" | "minecraft:recipes/decorations/lime_stained_glass_pane_from_glass_pane" | "minecraft:adventure/trim_with_all_exclusive_armor_patterns" | "minecraft:recipes/misc/copper_ingot_from_blasting_deepslate_copper_ore" | "create:recipes/misc/crafting/kinetics/chute" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_copper_wrapped_locometal" | "create:recipes/combat/crafting/appliances/netherite_diving_boots" | "railways:recipes/misc/crafting/palettes/wrapping/yellow_brass_wrapped_locometal" | "immersiveengineering:multiblocks/mb_mixer" | "create:recipes/misc/crafting/kinetics/brown_valve_handle_from_other_valve_handle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_copper_wrapped_locometal_boiler" | "farmersdelight:main/get_rich_soil" | "refinedstorage:recipes/misc/coloring_recipes/brown_network_receiver" | "refinedstorage:recipes/misc/coloring_recipes/white_controller" | "create:recipes/building_blocks/small_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "exdeorum:recipes/misc/dark_oak_sieve" | "minecraft:recipes/building_blocks/smooth_quartz_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_locometal_smokebox" | "sophisticatedbackpacks:recipes/misc/advanced_feeding_upgrade" | "exdeorum:recipes/misc/spruce_crucible" | "minecraft:recipes/building_blocks/end_stone_brick_slab" | "exdeorum:recipes/misc/cooked_silk_worm" | "copycats:recipes/misc/stonecutting/copycat_stairs" | "create:recipes/building_blocks/cut_tuff_brick_wall" | "immersiveengineering:recipes/misc/crafting/stairs_hempcrete" | "minecraft:recipes/decorations/polished_deepslate_wall" | "create:recipes/building_blocks/granite_from_stone_types_granite_stonecutting" | "laserio:recipes/card_fluid_nbtclear" | "immersiveengineering:recipes/misc/crafting/steel_post" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tiles_from_honeycomb" | "create:clockwork_bearing" | "refinedstorage:recipes/misc/coloring_recipes/purple_controller" | "railways:recipes/misc/stonecutting/palettes/cycling/locometal_smokebox" | "minecraft:recipes/decorations/orange_bed" | "railways:recipes/misc/stonecutting/palettes/cycling/slashed_locometal" | "minecraft:recipes/decorations/fletching_table" | "minecraft:recipes/food/cooked_chicken_from_campfire_cooking" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_purple_from_slab" | "minecraft:recipes/decorations/brown_bed" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_red" | "minecraft:recipes/food/cooked_mutton_from_smoking" | "minecraft:recipes/building_blocks/deepslate_bricks" | "create:recipes/building_blocks/weathered_copper_shingle_slab_from_weathered_copper_shingles_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_locometal_boiler" | "immersiveengineering:tools/skyhook_distance" | "minecraft:recipes/building_blocks/polished_diorite_stairs" | "mobdropsrecipes_overworld:recipes/misc/rotten_flesh" | "create:recipes/building_blocks/cut_diorite_brick_wall" | "mcwfurnitures:recipes/acacia" | "minecraft:recipes/building_blocks/dye_brown_bed" | "create:recipes/building_blocks/cut_ochrum_wall" | "sophisticatedbackpacks:recipes/misc/deposit_upgrade" | "minecraft:recipes/misc/gold_ingot_from_gold_block" | "minecraft:recipes/building_blocks/light_blue_stained_glass" | "create:recipes/misc/crafting/kinetics/elevator_pulley" | "exdeorum:recipes/food/end_cake" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_locometal_smokebox" | "immersiveengineering:recipes/misc/crafting/coke_to_coal_coke" | "create:recipes/misc/crafting/kinetics/portable_fluid_interface" | "immersiveengineering:recipes/misc/crafting/waterwheel_segment" | "create:recipes/misc/crafting/kinetics/wrench" | "immersiveengineering:recipes/misc/crafting/wooden_barrel" | "refinedstorage:recipes/misc/coloring_recipes/gray_controller" | "minecraft:recipes/misc/lapis_lazuli_from_blasting_lapis_ore" | "create:recipes/misc/crafting/kinetics/rose_quartz_lamp" | "create:recipes/misc/crafting/kinetics/steam_whistle" | "minecraft:recipes/decorations/purple_bed" | "exdeorum:recipes/tools/stone_hammer" | "farmersdelight:recipes/decorations/pink_hanging_canvas_sign" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_slashed_locometal" | "create:recipes/building_blocks/crafting/kinetics/pink_seat_from_other_seat" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_plated_locometal" | "cabletiers:elite_destructor" | "create:recipes/building_blocks/oxidized_copper_shingle_slab_from_oxidized_copper_shingles_stonecutting" | "exdeorum:recipes/misc/oak_crucible" | "refinedstorage:recipes/misc/coloring_recipes/gray_pattern_grid" | "minecraft:recipes/decorations/light_gray_glazed_terracotta" | "immersiveengineering:recipes/misc/stonecutting/slab_hempcrete_brick" | "minecraft:recipes/building_blocks/mossy_stone_bricks_from_vine" | "farmersdelight:recipes/cooking/rabbit_stew" | "refinedstorage:recipes/misc/coloring_recipes/blue_wireless_transmitter" | "minecraft:recipes/redstone/birch_button" | "minecraft:recipes/building_blocks/quartz_slab" | "railways:recipes/misc/crafting/semaphore" | "minecraft:recipes/building_blocks/jungle_wood" | "minecraft:recipes/combat/netherite_chestplate_smithing" | "create:recipes/building_blocks/cut_diorite_brick_stairs" | "extradisks:recipes/misc/disk/shapeless/256k_storage_disk" | "minecraft:recipes/decorations/purple_glazed_terracotta" | "minecraft:story/deflect_arrow" | "create:sturdy_sheet" | "railways:recipes/misc/crafting/palettes/wrapping/green_copper_wrapped_locometal" | "copycats:recipes/misc/stonecutting/copycat_beam" | "farmersdelight:recipes/cooking/stuffed_pumpkin_block" | "minecraft:recipes/tools/golden_axe" | "minecraft:husbandry/leash_all_frog_variants" | "immersiveengineering:recipes/misc/smelting/ingot_steel_from_dust" | "minecraft:recipes/misc/sand_from_compressed_sand" | "create:recipes/building_blocks/cut_limestone_slab_from_stone_types_limestone_stonecutting" | "create:recipes/building_blocks/cut_andesite_brick_slab" | "create:recipes/building_blocks/cut_veridium_brick_slab_from_stone_types_veridium_stonecutting" | "ironchest:recipes/decorations/chests/trapped_iron_chest" | "immersiveengineering:recipes/misc/stonecutting/concrete_chiseled" | "extrastorage:iron_crafter" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_deepslate_bricks_stonecutting" | "minecraft:recipes/decorations/orange_banner" | "refinedstorage:recipes/misc/coloring_recipes/cyan_security_manager" | "immersiveengineering:recipes/misc/crafting/conveyor_extract_covered" | "immersiveengineering:recipes/misc/crafting/stairs_hempcrete_brick" | "refinedstorage:recipes/misc/coloring_recipes/gray_security_manager" | "immersiveengineering:recipes/misc/crafting/sheetmetal_uranium" | "exdeorum:recipes/misc/granite" | "minecraft:recipes/decorations/oak_sign" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_slashed_locometal" | "refinedstorage:recipes/misc/coloring_recipes/blue_detector" | "extrastorage:recipes/misc/part/storagepart_16384k" | "comforts:rope_and_nail" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_gray_to_slab" | "minecraft:recipes/building_blocks/red_concrete_powder" | "create:recipes/misc/crafting/kinetics/gantry_shaft" | "immersiveengineering:recipes/misc/crafting/chute_aluminum" | "minecraft:recipes/tools/golden_pickaxe" | "immersiveengineering:recipes/misc/crafting/clinker_brick_to_slab" | "refinedstorage:recipes/misc/coloring_recipes/lime_grid" | "immersiveengineering:multiblocks/mb_excavator" | "immersiveengineering:recipes/misc/crafting/stairs_concrete_brick" | "create:recipes/building_blocks/polished_cut_andesite_stairs_from_stone_types_andesite_stonecutting" | "minecraft:recipes/brewing/magma_cream" | "refinedstorage:recipes/misc/coloring_recipes/pink_relay" | "create:recipes/building_blocks/cut_scoria_stairs" | "immersiveengineering:recipes/misc/crafting/blueprint_bannerpatterns" | "immersiveengineering:recipes/misc/crafting/balloon" | "exdeorum:recipes/misc/birch_sieve" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_plated_locometal" | "refinedstorage:recipes/misc/fluid_grid/pink_fluid_grid" | "copycats:recipes/misc/crafting/copycat_large_cogwheel" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_locometal_pillar" | "extrastorage:recipes/misc/storage_block/block_262144k_fluid" | "create:recipes/building_blocks/cut_granite_brick_slab_from_stone_types_granite_stonecutting" | "create:recipes/building_blocks/small_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "immersiveengineering:recipes/misc/crafting/storage_steel_to_ingot_steel" | "exdeorum:recipes/tools/netherite_watering_can" | "minecraft:nether/brew_potion" | "comforts:sleeping_bag_cyan" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_magenta" | "exdeorum:recipes/misc/iron_ore" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_plated_locometal" | "minecraft:recipes/building_blocks/polished_deepslate_slab" | "create:recipes/misc/crafting/appliances/copper_backtank" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_crafter_manager" | "create:recipes/building_blocks/dark_oak_window" | "railways:recipes/combat/dying_existing_cap_cyan" | "railways:recipes/misc/crafting/palettes/wrapping/gray_copper_wrapped_locometal" | "exmachinis:recipes/misc/diamond_upgrade" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_wooden_top_from_slab" | "minecraft:recipes/building_blocks/quartz_bricks" | "minecraft:recipes/decorations/deepslate_tile_wall_from_deepslate_tiles_stonecutting" | "minecraft:recipes/decorations/purple_stained_glass_pane_from_glass_pane" | "immersiveengineering:recipes/misc/crafting/treated_wood_horizontal_from_packaged" | "create:recipes/building_blocks/polished_cut_crimsite_wall" | "extradisks:recipes/misc/disk/shapeless/262144k_fluid_storage_disk" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_copper_wrapped_locometal" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tile_slab_from_honeycomb" | "refinedstorage:recipes/misc/coloring_recipes/orange_pattern_grid" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal" | "minecraft:end/dragon_egg" | "immersiveengineering:recipes/misc/smelting/copper_ingot_from_dust" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum2" | "minecraft:husbandry/fishy_business" | "minecraft:recipes/building_blocks/lapis_block" | "farmersdelight:recipes/food/steak_and_potatoes" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum3" | "create:recipes/building_blocks/polished_cut_calcite_slab" | "refinedstorage:recipes/misc/coloring_recipes/orange_controller" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_plated_locometal" | "minecraft:recipes/food/cooked_cod_from_smoking" | "create:recipes/misc/crafting/kinetics/mechanical_press" | "farmersdelight:main/obtain_netherite_knife" | "farmersdelight:recipes/food/cooked_cod_slice_from_smoking" | "railways:recipes/misc/stonecutting/palettes/cycling/black_plated_locometal" | "farmersdelight:recipes/decorations/orange_hanging_canvas_sign" | "minecraft:nether/explore_nether" | "immersiveengineering:recipes/misc/crafting/sheetmetal_electrum_to_slab" | "immersiveengineering:recipes/misc/crafting/minecart_woodencrate" | "create:recipes/building_blocks/cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tile_stairs_from_honeycomb" | "minecraft:recipes/building_blocks/prismarine" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_iron_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_plated_locometal" | "minecraft:recipes/building_blocks/polished_diorite" | "create:recipes/decorations/brass_ladder_from_ingots_brass_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/brown_detector" | "create:recipes/building_blocks/cut_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "extrastorage:recipes/misc/disk/shapeless/disk_1024k" | "create:recipes/misc/crafting/kinetics/rope_pulley" | "immersiveengineering:recipes/misc/crafting/concrete_leaded" | "extrastorage:recipes/misc/neural_processor" | "minecraft:recipes/misc/brown_dye" | "exdeorum:recipes/building_blocks/compressed_dust" | "minecraft:recipes/building_blocks/raw_iron_block" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingles_from_honeycomb" | "create:recipes/building_blocks/polished_cut_veridium_from_stone_types_veridium_stonecutting" | "immersiveengineering:recipes/misc/crafting/ingot_aluminum_to_nugget_aluminum" | "refinedstorage:recipes/misc/coloring_recipes/purple_crafter_manager" | "minecraft:recipes/building_blocks/mud_brick_slab_from_mud_bricks_stonecutting" | "extradisks:infinite_storage" | "create:recipes/building_blocks/cut_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "ironchest:recipes/decorations/upgrades/wood_to_iron_chest_upgrade" | "refinedstorage:recipes/misc/coloring_recipes/gray_network_transmitter" | "farmersdelight:recipes/decorations/mangrove_cabinet" | "exdeorum:recipes/tools/wooden_watering_can" | "create:recipes/building_blocks/exposed_copper_tile_slab" | "create:recipes/building_blocks/crafting/kinetics/green_seat_from_other_seat" | "refinedstorage:recipes/misc/pattern_grid/pattern_grid" | "create:recipes/building_blocks/polished_cut_tuff_from_stone_types_tuff_stonecutting" | "extrastorage:recipes/misc/disk/shaped/disk_65536k_fluid" | "immersiveengineering:recipes/misc/crafting/cokebrick_from_slab" | "create:recipes/building_blocks/cut_andesite_slab_from_stone_types_andesite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_flat_riveted_locometal" | "railways:recipes/misc/crafting/palettes/wrapping/lime_copper_wrapped_locometal" | "create:recipes/building_blocks/small_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "exdeorum:core/string_mesh" | "create:recipes/building_blocks/cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "create:extendo_grip" | "create:recipes/building_blocks/cut_scoria_brick_stairs" | "immersiveengineering:recipes/misc/stonecutting/stairs_clinker_brick" | "minecraft:recipes/building_blocks/end_stone_brick_slab_from_end_stone_stonecutting" | "farmersdelight:recipes/cooking/mushroom_stew" | "create:recipes/building_blocks/polished_cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "create:recipes/building_blocks/cut_diorite_slab_from_stone_types_diorite_stonecutting" | "minecraft:recipes/decorations/blue_stained_glass_pane_from_glass_pane" | "immersiveengineering:recipes/misc/crafting/nugget_lead_to_ingot_lead" | "minecraft:recipes/misc/netherite_scrap_from_blasting" | "create:glass_pipe" | "minecraft:recipes/combat/diamond_sword" | "minecraft:recipes/decorations/cyan_stained_glass_pane" | "create:recipes/combat/crafting/appliances/netherite_diving_helmet_from_netherite" | "minecraft:recipes/misc/white_dye" | "minecraft:recipes/building_blocks/stripped_warped_hyphae" | "mobdropsrecipes_overworld:recipes/misc/totem_of_undying" | "minecraft:recipes/decorations/jukebox" | "refinedstorage:recipes/misc/coloring_recipes/white_crafting_grid" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_flat_slashed_locometal" | "minecraft:recipes/misc/silence_armor_trim_smithing_template_smithing_trim" | "refinedstorage:recipes/misc/coloring_recipes/green_crafting_grid" | "create:recipes/building_blocks/cut_scoria_brick_wall" | "refinedstorage:upgrading" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_riveted_locometal" | "immersiveengineering:recipes/misc/crafting/axe_steel" | "immersiveengineering:recipes/misc/crafting/storage_aluminum_from_slab" | "immersiveengineering:recipes/misc/crafting/nugget_copper_to_copper_ingot" | "minecraft:recipes/misc/gold_nugget" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_plated_locometal" | "immersiveengineering:recipes/misc/smelting/ingot_lead3" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_flat_riveted_locometal" | "minecraft:recipes/building_blocks/smooth_sandstone_slab_from_smooth_sandstone_stonecutting" | "extradisks:recipes/misc/blocks/65536k_fluid_storage_block" | "immersiveengineering:recipes/misc/crafting/turret_gun" | "minecraft:nether/all_effects" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_flat_slashed_locometal" | "ironchest:recipes/decorations/chests/diamond_obsidian_chest" | "create:recipes/building_blocks/small_deepslate_brick_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_riveted_locometal" | "create:recipes/building_blocks/polished_cut_veridium_slab" | "immersiveengineering:recipes/misc/crafting/drillhead_steel" | "immersiveengineering:recipes/misc/crafting/sheetmetal_uranium_from_slab" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingle_stairs_from_honeycomb" | "immersiveengineering:recipes/misc/smelting/ingot_lead2" | "refinedstorage:recipes/misc/coloring_recipes/purple_network_receiver" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_locometal_smokebox" | "railways:recipes/misc/crafting/track_switch_brass" | "immersiveengineering:recipes/misc/crafting/sheetmetal_constantan_to_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_copper_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_locometal_pillar" | "railways:recipes/misc/stonecutting/palettes/cycling/red_slashed_locometal" | "refinedstorage:recipes/misc/coloring_recipes/crafting_monitor" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_iron_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_veridium_brick_wall" | "create:recipes/building_blocks/cut_scorchia_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/decorations/white_glazed_terracotta" | "minecraft:recipes/combat/iron_helmet" | "minecraft:recipes/tools/golden_shovel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_brass_wrapped_locometal" | "create:recipes/building_blocks/small_scoria_brick_slab" | "minecraft:recipes/building_blocks/dye_magenta_carpet" | "create:recipes/building_blocks/oxidized_copper_shingle_stairs" | "vegandelight:tutorial/smoked_tofish" | "minecraft:recipes/combat/diamond_chestplate" | "refinedstorage:recipes/misc/coloring_recipes/gray_fluid_grid" | "create:recipes/misc/crafting/kinetics/smart_chute" | "immersiveengineering:recipes/misc/crafting/railgun" | "create:recipes/building_blocks/polished_cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "immersiveengineering:recipes/misc/crafting/ingot_constantan_to_storage_constantan" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_iron_wrapped_locometal" | "minecraft:story/mine_stone" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_flat_riveted_locometal" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_waxed_oxidized_cut_copper_stonecutting" | "minecraft:recipes/decorations/furnace" | "minecraft:recipes/food/beetroot_soup" | "farmersdelight:recipes/tools/lead_from_straw" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/andesite_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_locometal_smokebox" | "create:recipes/misc/crafting/kinetics/mechanical_arm" | "immersiveengineering:recipes/misc/crafting/torch" | "minecraft:recipes/redstone/redstone_torch" | "railways:recipes/misc/crafting/palettes/wrapping/orange_brass_wrapped_locometal" | "minecraft:recipes/food/golden_apple" | "minecraft:recipes/misc/gold_ingot_from_blasting_raw_gold" | "minecraft:recipes/building_blocks/green_concrete_powder" | "create:recipes/building_blocks/cut_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "create:recipes/misc/blasting/nickel_ingot_compat_thermal" | "create:recipes/misc/blasting/copper_ingot_from_crushed" | "railways:recipes/misc/crafting/palettes/wrapping/lime_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/orange_stained_glass" | "railways:recipes/misc/crafting/palettes/wrapping/purple_brass_wrapped_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_riveted_locometal" | "immersiveengineering:recipes/misc/crafting/storage_silver_from_slab" | "farmersdelight:recipes/food/cooked_salmon_slice_from_campfire_cooking" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum" | "easy_mob_farm:recipes/mob_farm_template/tier0_mob_farm_template" | "create:recipes/misc/crafting/kinetics/super_glue" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_disk_manipulator" | "railways:recipes/misc/crafting/palettes/wrapping/lime_brass_wrapped_locometal" | "minecraft:adventure/two_birds_one_arrow" | "minecraft:recipes/decorations/end_crystal" | "refinedstorage:recipes/misc/coloring_recipes/yellow_crafting_monitor" | "create:recipes/building_blocks/cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "farmersdelight:recipes/food/melon_popsicle" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_sword_from_blasting" | "extradisks:recipes/misc/disk/shapeless/16384k_storage_disk" | "farmersdelight:recipes/food/roast_chicken_block" | "immersiveengineering:tools/upgrade_railgun" | "create:recipes/building_blocks/exposed_copper_shingle_slab" | "create:recipes/building_blocks/cut_crimsite_slab" | "immersiveengineering:recipes/misc/crafting/storage_constantan_to_slab" | "minecraft:recipes/redstone/birch_door" | "exdeorum:recipes/misc/mangrove_sieve" | "create:recipes/misc/crafting/logistics/pulse_extender" | "create:root" | "create:recipes/building_blocks/crimsite_from_stone_types_crimsite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_brass_wrapped_locometal" | "ironchest:recipes/decorations/chests/trapped_diamond_chest" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_riveted_locometal" | "create:train_crash_backwards" | "create:recipes/building_blocks/exposed_copper_tile_stairs" | "minecraft:recipes/decorations/snow" | "minecraft:recipes/decorations/soul_lantern" | "minecraft:recipes/misc/sentry_armor_trim_smithing_template" | "minecraft:recipes/building_blocks/oxidized_cut_copper_from_oxidized_copper_stonecutting" | "minecraft:recipes/decorations/cherry_fence" | "minecraft:recipes/decorations/birch_fence" | "minecraft:recipes/decorations/sandstone_wall_from_sandstone_stonecutting" | "create:recipes/misc/crafting/kinetics/andesite_door" | "immersiveengineering:recipes/misc/crafting/storage_lead_from_slab" | "create:recipes/building_blocks/cut_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "sophisticatedbackpacks:recipes/misc/advanced_refill_upgrade" | "minecraft:recipes/building_blocks/stone_brick_stairs" | "create:recipes/building_blocks/cut_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_orange_to_slab" | "minecraft:recipes/combat/golden_boots" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_locometal_boiler" | "immersiveengineering:recipes/misc/crafting/wooden_grip" | "mobdropsrecipes_overworld:recipes/misc/string" | "railways:recipes/misc/crafting/link_and_pin" | "minecraft:recipes/tools/wooden_axe" | "farmersdelight:recipes/food/beef_patty_from_campfire_cooking" | "immersiveengineering:recipes/misc/crafting/nugget_aluminum_to_ingot_aluminum" | "create:recipes/building_blocks/polished_cut_tuff_slab_from_stone_types_tuff_stonecutting" | "exdeorum:recipes/misc/jungle_crucible" | "mobdropsrecipes_overworld:recipes/misc/essence_into_prismarine_crystals" | "minecraft:recipes/misc/gold_ingot_from_smelting_gold_ore" | "minecraft:recipes/building_blocks/stone_bricks_from_stone_stonecutting" | "immersiveengineering:recipes/misc/crafting/transformer" | "laserio:recipes/misc/filter_tag_nbtclear" | "create:copper" | "minecraft:recipes/building_blocks/chiseled_sandstone" | "extradisks:recipes/misc/disk/shapeless/1024k_storage_disk" | "create:recipes/building_blocks/cut_limestone_slab" | "refinedstorage:recipes/misc/crafting_grid/cyan_crafting_grid" | "create:recipes/building_blocks/small_scoria_brick_slab_from_stone_types_scoria_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/gray_wireless_transmitter" | "immersiveengineering:recipes/misc/crafting/storage_uranium_to_ingot_uranium" | "mobdropsrecipes_overworld:recipes/misc/spider_eye" | "refinedstorage:recipes/misc/pattern_grid/blue_pattern_grid" | "create:recipes/misc/smelting/glass_from_framed_glass" | "immersiveengineering:recipes/misc/crafting/stairs_alu_scaffolding_grate_top" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_flat_riveted_locometal" | "create:potato_cannon" | "create:recipes/misc/crafting/kinetics/spout" | "minecraft:recipes/building_blocks/stone_slab" | "minecraft:recipes/decorations/black_carpet" | "immersiveengineering:recipes/misc/crafting/toolupgrade_buzzsaw_spareblades" | "refinedstorage:recipes/misc/coloring_recipes/brown_security_manager" | "minecraft:recipes/misc/gold_nugget_from_blasting" | "exdeorum:recipes/misc/oak_sieve" | "create:recipes/building_blocks/cut_deepslate_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/decorations/yellow_stained_glass_pane" | "farmersdelight:main/get_fd_seed" | "minecraft:recipes/building_blocks/blue_concrete_powder" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_honeycomb" | "minecraft:recipes/building_blocks/granite_slab_from_granite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_copper_wrapped_locometal_boiler" | "immersiveengineering:recipes/misc/crafting/coke_to_slab" | "laserio:recipes/misc/filter_mod_nbtclear" | "minecraft:recipes/building_blocks/crimson_planks" | "create:recipes/building_blocks/cut_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_riveted_locometal" | "create:chute" | "create:recipes/building_blocks/polished_cut_scoria_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/small_tuff_brick_slab_recycling" | "minecraft:recipes/building_blocks/cut_sandstone" | "minecraft:recipes/building_blocks/smooth_red_sandstone" | "minecraft:recipes/building_blocks/black_terracotta" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_pink_to_slab" | "minecraft:recipes/decorations/blackstone_wall" | "minecraft:recipes/misc/cyan_dye_from_pitcher_plant" | "cabletiers:elite_disk_manipulator" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab_from_weathered_cut_copper_stonecutting" | "immersiveengineering:main/place_dynamo" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_copper_wrapped_locometal" | "create:chained_drain" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_brass_wrapped_locometal" | "farmersdelight:recipes/cooking/chicken_soup" | "refinedstorage:recipes/misc/coloring_recipes/pink_pattern_grid" | "minecraft:recipes/decorations/purple_candle" | "create:recipes/building_blocks/crafting/kinetics/blue_seat" | "create:recipes/building_blocks/cut_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "minecraft:recipes/decorations/pink_glazed_terracotta" | "minecraft:recipes/misc/coal" | "minecraft:recipes/transportation/spruce_chest_boat" | "extradisks:recipes/misc/withering_processor" | "sophisticatedbackpacks:recipes/misc/magnet_upgrade" | "minecraft:recipes/food/cooked_rabbit" | "laserio:recipes/misc/card_energy" | "extradisks:recipes/misc/blocks/65536k_storage_block" | "minecraft:recipes/combat/leather_chestplate" | "refinedstorage:recipes/misc/coloring_recipes/yellow_security_manager" | "create:recipes/misc/crafting/appliances/crafting_blueprint" | "immersiveengineering:recipes/misc/crafting/wall_clinker_brick" | "minecraft:recipes/misc/magenta_dye_from_blue_red_pink" | "minecraft:recipes/decorations/yellow_candle" | "create:recipes/building_blocks/polished_cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_constantan_from_slab" | "minecraft:nether/obtain_blaze_rod" | "refinedstorage:recipes/misc/coloring_recipes/blue_pattern_grid" | "immersiveengineering:recipes/misc/crafting/metal_ladder_steel" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_flat_riveted_locometal" | "create:crushing_wheel" | "create:recipes/building_blocks/cut_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "create:recipes/misc/crafting/kinetics/placard" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_riveted_locometal" | "immersiveengineering:recipes/misc/smelting/ingot_nickel_from_dust_from_blasting" | "immersiveengineering:recipes/misc/crafting/fertilizer" | "create:recipes/building_blocks/cut_crimsite_brick_stairs" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_flat_slashed_locometal" | "create:recipes/building_blocks/small_tuff_brick_wall" | "immersiveengineering:recipes/misc/crafting/generator" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_iron_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_riveted_locometal" | "exdeorum:recipes/tools/iron_watering_can" | "laserio:recipes/misc/laser_connector" | "railways:recipes/misc/crafting/palettes/wrapping/light_gray_iron_wrapped_locometal" | "exdeorum:recipes/building_blocks/sponge" | "ironchest:recipes/decorations/chests/trapped_copper_chest" | "create:recipes/misc/crafting/kinetics/water_wheel" | "railways:recipes/misc/crafting/palettes/wrapping/cyan_iron_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_brown" | "immersiveengineering:recipes/misc/crafting/sheetmetal_lead_from_slab" | "create:recipes/building_blocks/cut_granite_slab_from_stone_types_granite_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/brown_network_transmitter" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_copper_wrapped_locometal_boiler" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_locometal_smokebox" | "create:recipes/misc/blasting/silver_ingot_compat_oreganized" | "minecraft:adventure/shoot_arrow" | "create:recipes/building_blocks/polished_cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "extradisks:recipes/misc/blocks/infinite_fluid_storage_block" | "refinedstorage:recipes/misc/coloring_recipes/white_disk_manipulator" | "immersiveengineering:recipes/misc/crafting/clinker_brick_from_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_slashed_locometal" | "ironchest:recipes/decorations/upgrades/gold_to_diamond_chest_upgrade" | "minecraft:recipes/building_blocks/polished_blackstone_stairs" | "create:recipes/building_blocks/cut_limestone_brick_slab_recycling" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_wooden_top_from_grate_top" | "peco:recipes/misc/disc_ring" | "laserio:recipes/misc/card_cloner" | "immersiveengineering:recipes/misc/crafting/connector_hv" | "create:recipes/misc/smelting/lead_ingot_compat_thermal" | "exdeorum:recipes/misc/cobblestone" | "farmersdelight:main/place_organic_compost" | "create:recipes/building_blocks/cut_scoria_slab_from_stone_types_scoria_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/magenta_disk_manipulator" | "create:recipes/building_blocks/oxidized_copper_shingle_slab" | "farmersdelight:main/place_campfire" | "railways:recipes/combat/dying_existing_cap_red" | "refinedstorage:recipes/misc/coloring_recipes/cyan_grid" | "create:recipes/building_blocks/polished_cut_crimsite_slab_recycling" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab" | "minecraft:recipes/building_blocks/chiseled_red_sandstone" | "create:recipes/building_blocks/crafting/kinetics/magenta_seat" | "minecraft:recipes/decorations/light_gray_stained_glass_pane_from_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_locometal_boiler" | "laserio:recipes/misc/laser_node" | "farmersdelight:recipes/food/fried_egg_from_campfire_cooking" | "immersiveengineering:recipes/misc/crafting/redstone_acid" | "extradisks:recipes/misc/disk/shapeless/4096k_storage_disk" | "minecraft:adventure/arbalistic" | "minecraft:recipes/decorations/pink_candle" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_grate_top_from_slab" | "mobdropsrecipes_overworld:recipes/misc/essence_into_string" | "minecraft:recipes/building_blocks/deepslate_brick_stairs" | "create:recipes/building_blocks/small_dripstone_brick_stairs_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/light_blue_bed" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_locometal_smokebox" | "railways:recipes/misc/crafting/palettes/wrapping/white_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_iron_wrapped_locometal" | "extrastorage:recipes/misc/storage_block/block_1048576k_fluid" | "minecraft:recipes/building_blocks/pink_stained_glass" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_grid" | "minecraft:recipes/decorations/purple_stained_glass_pane" | "create:recipes/misc/crafting/kinetics/large_cogwheel_from_little" | "minecraft:recipes/building_blocks/black_stained_glass" | "minecraft:recipes/building_blocks/brick_stairs_from_bricks_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_polished_blackstone_stonecutting" | "create:hand_crank_000" | "immersiveengineering:recipes/misc/crafting/chute_iron" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_flat_slashed_locometal" | "immersiveengineering:recipes/misc/crafting/stairs_concrete" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_brass_wrapped_locometal_boiler" | "minecraft:nether/charge_respawn_anchor" | "naturescompass:natures_compass" | "exdeorum:recipes/misc/blackstone" | "minecraft:recipes/building_blocks/bamboo_planks" | "minecraft:recipes/building_blocks/cracked_polished_blackstone_bricks" | "minecraft:recipes/building_blocks/gray_stained_glass" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_standard" | "refinedstorage:recipes/misc/coloring_recipes/blue_crafter" | "create:mechanical_mixer" | "minecraft:recipes/decorations/crafting_table" | "immersiveengineering:recipes/misc/crafting/stairs_steel_scaffolding_grate_top" | "create:recipes/misc/crafting/kinetics/portable_storage_interface" | "create:super_glue" | "ironchest:recipes/decorations/chests/copper_iron_chest" | "refinedstorage:recipes/misc/coloring_recipes/brown_crafting_grid" | "refinedstorage:recipes/misc/coloring_recipes/green_pattern_grid" | "minecraft:recipes/building_blocks/cut_copper_stairs_from_copper_block_stonecutting" | "minecraft:recipes/misc/map" | "minecraft:recipes/decorations/chest" | "minecraft:story/shiny_gear" | "refinedstorage:recipes/misc/crafting_grid/green_crafting_grid" | "minecraft:recipes/building_blocks/cobbled_deepslate_slab" | "cabletiers:ultra_importer" | "create:recipes/building_blocks/cut_scorchia_wall" | "create:recipes/misc/blasting/ingot_tin_compat_ic2" | "extradisks:recipes/misc/blocks/1048576k_fluid_storage_block" | "immersiveengineering:recipes/misc/crafting/slag_brick_from_slab" | "minecraft:recipes/tools/shears" | "minecraft:recipes/misc/stick" | "refinedstorage:recipes/misc/coloring_recipes/green_controller" | "minecraft:recipes/redstone/crimson_pressure_plate" | "farmersdelight:recipes/decorations/gray_canvas_sign" | "create:funnel" | "mobdropsrecipes_overworld:recipes/misc/essence_into_ender_pearl" | "exdeorum:recipes/tools/wooden_hammer" | "minecraft:recipes/redstone/polished_blackstone_button" | "railways:recipes/misc/stonecutting/palettes/cycling/white_plated_locometal" | "immersiveengineering:recipes/misc/crafting/gunpart_barrel" | "create:recipes/misc/crafting/materials/andesite_alloy_block" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_riveted_locometal" | "create:recipes/building_blocks/cut_andesite_slab" | "immersiveengineering:main/make_steel" | "laserio:recipes/card_item_nbtclear" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_copper_wrapped_locometal" | "minecraft:recipes/brewing/golden_carrot" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_locometal_smokebox" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_flat_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_iron_wrapped_locometal_boiler" | "refinedstorage:storing_fluids" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_plated_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_iron_wrapped_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_flat_riveted_locometal" | "create:recipes/misc/crafting/kinetics/steam_engine" | "minecraft:recipes/building_blocks/pink_terracotta" | "minecraft:recipes/building_blocks/mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting" | "minecraft:adventure/summon_iron_golem" | "minecraft:recipes/transportation/jungle_chest_boat" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/weathered_copper_shingle_stairs" | "exdeorum:recipes/misc/birch_crucible" | "exdeorum:recipes/misc/bamboo_compressed_sieve" | "create:recipes/building_blocks/cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "create:recipes/building_blocks/weathered_copper_shingle_slab" | "immersiveengineering:recipes/misc/crafting/blastbrick_from_slab" | "laserio:recipes/misc/filter_mod" | "refinedstorage:recipes/misc/coloring_recipes/pink_crafting_grid" | "immersiveengineering:recipes/misc/crafting/raw_aluminum_to_raw_block_aluminum" | "minecraft:recipes/building_blocks/dye_pink_bed" | "mcwfurnitures:recipes/birch" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingle_slab_from_honeycomb" | "create:recipes/building_blocks/cut_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "laserio:recipes/misc/filter_nbt_nbtclear" | "mobdropsrecipes_overworld:recipes/misc/slime_ball" | "immersiveengineering:tools/craft_revolver" | "extrastorage:recipes/misc/advanced_importer" | "minecraft:recipes/tools/spyglass" | "immersiveengineering:recipes/misc/crafting/workbench" | "minecraft:recipes/redstone/lectern" | "railways:recipes/misc/crafting/smokestack_woodburner" | "create:recipes/building_blocks/cut_crimsite_brick_slab_recycling" | "minecraft:recipes/building_blocks/stone_stairs_from_stone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/red_dye_from_rose_bush" | "refinedstorage:recipes/misc/coloring_recipes/cyan_pattern_grid" | "minecraft:recipes/misc/magenta_dye_from_purple_and_pink" | "easy_mob_farm:recipes/mob_farm/desert_farm" | "minecraft:recipes/decorations/mossy_stone_brick_wall" | "copycats:recipes/crafting/copycat_stairs_from_conversion" | "create:recipes/building_blocks/polished_cut_asurine_stairs_from_stone_types_asurine_stonecutting" | "sophisticatedbackpacks:recipes/misc/filter_upgrade" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_locometal_smokebox" | "copycats:recipes/misc/stonecutting/copycat_vertical_step" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_light_blue_to_slab" | "create:recipes/building_blocks/horizontal_framed_glass_from_glass_colorless_stonecutting" | "minecraft:adventure/sleep_in_bed" | "create:recipes/building_blocks/ochrum_pillar_from_stone_types_ochrum_stonecutting" | "minecraft:recipes/food/cooked_rabbit_from_campfire_cooking" | "minecraft:recipes/building_blocks/cobblestone_slab_from_cobblestone_stonecutting" | "create:recipes/building_blocks/cut_scorchia_brick_slab" | "immersiveengineering:recipes/misc/crafting/coil_hv" | "create:recipes/building_blocks/cut_scoria_bricks_from_stone_types_scoria_stonecutting" | "cabletiers:mega_requester" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_brass_wrapped_locometal" | "easy_mob_farm:recipes/mob_farm/animal_plains_farm" | "minecraft:recipes/building_blocks/prismarine_slab_from_prismarine_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_slab_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/decorations/birch_sign" | "minecraft:recipes/transportation/cherry_boat" | "copycats:recipes/crafting/copycat_step_from_conversion" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_riveted_locometal" | "farmersdelight:recipes/food/carrot_from_crate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_copper_wrapped_locometal_boiler" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_gray" | "extradisks:recipes/misc/disk/shaped/262144k_storage_disk" | "minecraft:recipes/tools/diamond_pickaxe" | "minecraft:recipes/redstone/lightning_rod" | "minecraft:adventure/kill_all_mobs" | "minecraft:recipes/decorations/brown_glazed_terracotta" | "immersiveengineering:recipes/misc/stonecutting/concrete_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_copper_wrapped_locometal" | "refinedstorage:storing_externally" | "minecraft:recipes/building_blocks/birch_wood" | "create:recipes/building_blocks/oxidized_copper_tile_slab_from_oxidized_copper_tiles_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/white_detector" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_plated_locometal" | "create:recipes/misc/blasting/ingot_silver_compat_immersiveengineering" | "minecraft:recipes/decorations/crimson_sign" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_light_gray" | "create:recipes/building_blocks/crafting/kinetics/light_blue_seat" | "minecraft:adventure/voluntary_exile" | "immersiveengineering:recipes/misc/smelting/ingot_steel_from_dust_from_blasting" | "minecraft:recipes/decorations/granite_wall_from_granite_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_blackstone_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/red_crafter" | "immersiveengineering:recipes/misc/crafting/wirecoil_steel" | "farmersdelight:recipes/food/cabbage_from_leaves" | "minecraft:recipes/building_blocks/polished_blackstone_bricks_from_blackstone_stonecutting" | "create:recipes/misc/smelting/ingot_aluminum_compat_immersiveengineering" | "create:recipes/building_blocks/polished_cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "create:recipes/building_blocks/polished_cut_diorite_wall" | "refinedstorage:recipes/misc/coloring_recipes/red_grid" | "create:recipes/misc/crafting/appliances/schedule_clear" | "create:recipes/misc/crafting/kinetics/gearbox" | "minecraft:recipes/building_blocks/cherry_planks" | "refinedstorage:recipes/misc/coloring_recipes/pink_fluid_grid" | "craftable_elytra_remastered:lets_fly" | "immersiveengineering:recipes/misc/crafting/toolupgrade_railgun_capacitors" | "exdeorum:recipes/misc/ores/magnesium_tag" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_locometal_pillar" | "immersiveengineering:recipes/misc/crafting/wire_aluminum" | "immersiveengineering:recipes/misc/smelting/ingot_nickel_from_blasting" | "create:recipes/building_blocks/polished_cut_scoria_slab" | "minecraft:recipes/building_blocks/dye_cyan_bed" | "immersiveengineering:recipes/misc/crafting/connector_mv_relay" | "vegandelight:tutorial/cooked_tofish" | "create:recipes/building_blocks/polished_cut_tuff_stairs_from_stone_types_tuff_stonecutting" | "minecraft:recipes/combat/golden_chestplate" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_locometal_boiler" | "minecraft:recipes/building_blocks/stripped_dark_oak_wood" | "sophisticatedbackpacks:recipes/misc/feeding_upgrade" | "copycats:recipes/crafting/copycat_slice_from_conversion" | "extrastorage:recipes/misc/storage_block/block_256k" | "minecraft:recipes/building_blocks/dye_yellow_wool" | "immersiveengineering:tools/craft_powerpack" | "immersiveengineering:recipes/misc/crafting/copper_ingot_to_nugget_copper" | "create:recipes/misc/crafting/logistics/brass_tunnel" | "create:recipes/misc/crafting/logistics/pulse_repeater" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_purple" | "create:extendo_grip_dual" | "railways:recipes/misc/crafting/palettes/wrapping/pink_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/iron_block" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_locometal_pillar" | "refinedstorage:recipes/misc/coloring_recipes/lime_relay" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_locometal_pillar" | "farmersdelight:recipes/food/bacon_sandwich" | "immersiveengineering:recipes/misc/crafting/storage_electrum_from_slab" | "minecraft:recipes/misc/red_dye_from_poppy" | "create:recipes/misc/smelting/bread" | "immersiveengineering:recipes/misc/crafting/sheetmetal_lead_to_slab" | "minecraft:recipes/building_blocks/smooth_red_sandstone_stairs" | "minecraft:recipes/building_blocks/clay" | "create:recipes/building_blocks/small_granite_brick_stairs" | "create:mechanical_crafter" | "create:recipes/misc/crafting/kinetics/furnace_minecart_from_contraption_cart" | "create:recipes/misc/crafting/kinetics/green_valve_handle_from_other_valve_handle" | "exmachinis:flux_sieve" | "sophisticatedbackpacks:recipes/misc/advanced_compacting_upgrade" | "create:recipes/misc/blasting/iron_ingot_from_crushed" | "refinedstorage:recipes/misc/coloring_recipes/purple_security_manager" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_orange" | "create:recipes/building_blocks/small_dripstone_brick_slab" | "refinedstorage:recipes/misc/coloring_recipes/gray_grid" | "refinedstorage:viewing_items" | "minecraft:recipes/decorations/birch_hanging_sign" | "minecraft:recipes/transportation/mangrove_chest_boat" | "minecraft:recipes/decorations/deepslate_tile_wall_from_deepslate_bricks_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/orange_crafter" | "create:recipes/building_blocks/cut_asurine_brick_slab" | "refinedstorage:recipes/misc/coloring_recipes/purple_fluid_grid" | "minecraft:recipes/decorations/gray_carpet" | "minecraft:recipes/decorations/deepslate_tile_wall" | "minecraft:recipes/redstone/tripwire_hook" | "create:recipes/misc/crafting/kinetics/wooden_bracket" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_flat_riveted_locometal" | "create:recipes/misc/crafting/kinetics/weighted_ejector" | "immersiveengineering:recipes/misc/crafting/armor_steel_helmet" | "comforts:sleeping_bag_brown" | "minecraft:recipes/redstone/birch_fence_gate" | "create:recipes/misc/smelting/zinc_ingot_from_raw_ore" | "minecraft:recipes/redstone/stone_button" | "immersiveengineering:recipes/misc/crafting/stairs_alu_scaffolding_wooden_top" | "minecraft:recipes/building_blocks/packed_mud" | "ironchest:recipes/decorations/upgrades/wood_to_copper_chest_upgrade" | "create:recipes/building_blocks/cut_dripstone_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_plated_locometal" | "farmersdelight:recipes/decorations/cooking_pot" | "copycats:recipes/misc/stonecutting/copycat_heavy_weighted_pressure_plate" | "farmersdelight:recipes/food/apple_pie_from_slices" | "create:spout" | "minecraft:recipes/building_blocks/smooth_sandstone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_iron_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/blue_terracotta" | "refinedstorage:recipes/misc/coloring_recipes/lime_crafter" | "minecraft:recipes/building_blocks/stone" | "minecraft:recipes/decorations/green_carpet" | "refinedstorage:recipes/misc/coloring_recipes/lime_controller" | "minecraft:recipes/building_blocks/light_blue_terracotta" | "immersiveengineering:recipes/misc/crafting/plate_lead_hammering" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_flat_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_slashed_locometal" | "copycats:recipes/misc/stonecutting/copycat_vertical_slope" | "railways:recipes/misc/crafting/palettes/wrapping/light_blue_iron_wrapped_locometal" | "minecraft:recipes/transportation/bamboo_raft" | "refinedstorage:recipes/misc/fluid_grid/purple_fluid_grid" | "minecraft:recipes/building_blocks/cut_red_sandstone" | "create:recipes/building_blocks/small_crimsite_brick_slab_recycling" | "railways:recipes/misc/crafting/palettes/wrapping/yellow_iron_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/battery_upgrade" | "create:recipes/building_blocks/small_rose_quartz_tiles_from_polished_rose_quartz_stonecutting" | "minecraft:recipes/building_blocks/mossy_stone_brick_slab" | "immersiveengineering:recipes/misc/stonecutting/slab_concrete_brick" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_magenta_to_slab" | "extradisks:recipes/misc/part/256k_storage_part" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_brass_wrapped_locometal_boiler" | "minecraft:recipes/decorations/purple_carpet" | "minecraft:recipes/building_blocks/cut_copper" | "immersiveengineering:recipes/misc/crafting/electric_lantern" | "minecraft:recipes/redstone/stone_pressure_plate" | "minecraft:recipes/building_blocks/polished_blackstone_slab" | "immersiveengineering:recipes/misc/stonecutting/concrete_pillar2" | "create:recipes/building_blocks/polished_cut_granite_wall" | "refinedstorage:recipes/misc/coloring_recipes/purple_detector" | "minecraft:recipes/misc/netherite_ingot" | "create:recipes/building_blocks/small_granite_brick_stairs_from_stone_types_granite_stonecutting" | "create:recipes/building_blocks/cut_ochrum_brick_slab_recycling" | "railways:recipes/misc/stonecutting/palettes/cycling/black_locometal_pillar" | "minecraft:recipes/building_blocks/dye_lime_bed" | "immersiveengineering:recipes/misc/crafting/fluid_pump" | "exdeorum:recipes/misc/ores/osmium_tag" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_axe_from_blasting" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_flat_riveted_locometal" | "minecraft:adventure/spyglass_at_dragon" | "create:recipes/building_blocks/cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/purple_iron_wrapped_locometal" | "immersiveengineering:tools/secret_ravenholm" | "additionalredstone:recipes/timer" | "refinedstorage:recipes/misc/coloring_recipes/cyan_wireless_transmitter" | "railways:recipes/misc/stonecutting/palettes/cycling/green_riveted_locometal" | "minecraft:recipes/misc/granite_from_compressed_granite" | "vegandelight:tutorial/root" | "sophisticatedbackpacks:recipes/misc/advanced_deposit_upgrade" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_pick" | "create:recipes/misc/crafting/kinetics/large_water_wheel" | "create:recipes/building_blocks/deepslate_from_stone_types_deepslate_stonecutting" | "mobdropsrecipes_overworld:recipes/misc/essence_into_gunpowder" | "minecraft:adventure/trade_at_world_height" | "create:recipes/misc/crafting/kinetics/speedometerfrom_conversion" | "copycats:recipes/crafting/copycat_slope_from_conversion" | "minecraft:recipes/decorations/red_sandstone_wall_from_red_sandstone_stonecutting" | "minecraft:recipes/food/cookie" | "comforts:hammock_brown" | "railways:recipes/misc/stonecutting/palettes/cycling/flat_riveted_locometal" | "minecraft:recipes/decorations/light_blue_stained_glass_pane_from_glass_pane" | "minecraft:recipes/building_blocks/acacia_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_locometal_pillar" | "create:recipes/building_blocks/small_asurine_brick_slab_recycling" | "create:recipes/building_blocks/small_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "ironchest:recipes/decorations/upgrades/diamond_to_obsidian_chest_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_flat_slashed_locometal" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_waxed_exposed_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_iron_wrapped_locometal" | "create:recipes/building_blocks/small_veridium_brick_stairs" | "minecraft:recipes/misc/fire_charge" | "minecraft:recipes/decorations/soul_torch" | "immersiveengineering:tools/secret_bttf" | "refinedstorage:recipes/misc/crafting_grid/red_crafting_grid" | "create:recipes/misc/crafting/materials/andesite_alloy" | "minecraft:recipes/building_blocks/yellow_terracotta" | "farmersdelight:recipes/cooking/baked_cod_stew" | "minecraft:recipes/misc/writable_book" | "farmersdelight:recipes/combat/golden_knife" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_light_gray_to_slab" | "create:recipes/building_blocks/polished_cut_granite_stairs" | "exdeorum:recipes/misc/cherry_sieve" | "immersiveengineering:recipes/misc/crafting/fiberboard" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_flat_slashed_locometal" | "minecraft:recipes/decorations/candle" | "create:recipes/combat/crafting/appliances/netherite_backtank_from_netherite" | "minecraft:recipes/food/bread" | "immersiveengineering:recipes/misc/crafting/metal_ladder_alu" | "immersiveengineering:recipes/misc/smelting/ingot_silver_from_dust" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_brass_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_plated_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_iron_wrapped_locometal" | "minecraft:nether/obtain_ancient_debris" | "cabletiers:ultra_disk_manipulator" | "minecraft:recipes/misc/bone_meal_from_bone_block" | "mobdropsrecipes_overworld:recipes/misc/ender_pearl" | "create:recipes/building_blocks/cut_tuff_stairs_from_stone_types_tuff_stonecutting" | "minecraft:recipes/decorations/magenta_candle" | "create:recipes/building_blocks/cut_veridium_wall_from_stone_types_veridium_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs_from_exposed_copper_stonecutting" | "minecraft:nether/create_full_beacon" | "create:recipes/building_blocks/tuff_from_stone_types_tuff_stonecutting" | "immersiveengineering:recipes/misc/crafting/windmill_blade" | "minecraft:recipes/building_blocks/diorite" | "refinedstorage:recipes/misc/coloring_recipes/yellow_crafting_grid" | "immersiveengineering:recipes/misc/crafting/blastbrick_reinforced" | "minecraft:recipes/building_blocks/dye_white_bed" | "create:recipes/building_blocks/small_calcite_brick_stairs_from_stone_types_calcite_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/iron_wrapped_locometal" | "minecraft:recipes/decorations/spruce_hanging_sign" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_riveted_locometal" | "farmersdelight:recipes/building_blocks/rice_bale" | "exdeorum:recipes/misc/unfired_porcelain_crucible" | "minecraft:recipes/building_blocks/polished_granite_from_granite_stonecutting" | "create:recipes/building_blocks/cut_calcite_bricks_from_stone_types_calcite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_copper_wrapped_locometal" | "create:recipes/building_blocks/cut_veridium_stairs_from_stone_types_veridium_stonecutting" | "refinedstorage:detecting" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab_from_oxidized_copper_stonecutting" | "easy_mob_farm:recipes/upgrade/enchancement/loot_enhancement" | "farmersdelight:recipes/decorations/magenta_canvas_sign" | "create:recipes/misc/crafting/logistics/brass_funnel" | "minecraft:recipes/building_blocks/birch_slab" | "minecraft:recipes/misc/raw_gold" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_flat_riveted_locometal" | "create:cart_pickup" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_locometal_pillar" | "create:potato_cannon_collide" | "exdeorum:recipes/misc/diorite" | "immersiveengineering:recipes/misc/crafting/conveyor_dropper" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_honeycomb" | "create:recipes/building_blocks/copper_tiles_from_ingots_copper_stonecutting" | "minecraft:recipes/decorations/oak_hanging_sign" | "minecraft:recipes/building_blocks/dye_lime_carpet" | "minecraft:recipes/building_blocks/polished_blackstone_stairs_from_blackstone_stonecutting" | "create:recipes/building_blocks/small_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "create:recipes/building_blocks/cut_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_slashed_locometal" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs" | "minecraft:recipes/redstone/redstone_from_smelting_redstone_ore" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_riveted_locometal" | "minecraft:recipes/building_blocks/hay_block" | "minecraft:recipes/misc/leather_horse_armor" | "immersiveengineering:recipes/misc/crafting/toolupgrade_powerpack_tesla" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingle_slab_from_honeycomb" | "create:recipes/building_blocks/weathered_copper_shingle_stairs_from_weathered_copper_shingles_stonecutting" | "minecraft:recipes/building_blocks/granite" | "immersiveengineering:tools/upgrade_powerpack" | "minecraft:recipes/building_blocks/cut_sandstone_slab_from_cut_sandstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/clinker_brick_sill" | "create:recipes/building_blocks/cut_granite_brick_slab" | "refinedstorage:recipes/misc/coloring_recipes/grid" | "create:recipes/building_blocks/polished_cut_limestone_slab_recycling" | "refinedstorage:recipes/misc/coloring_recipes/orange_wireless_transmitter" | "railways:recipes/misc/stonecutting/palettes/cycling/white_locometal_smokebox" | "minecraft:recipes/misc/emerald_from_smelting_deepslate_emerald_ore" | "immersiveengineering:recipes/misc/crafting/ingot_nickel_to_nugget_nickel" | "minecraft:recipes/transportation/oak_chest_boat" | "extrastorage:recipes/misc/part/storagepart_1024k" | "refinedstorage:better_than_a_barrel" | "minecraft:recipes/redstone/target" | "immersiveengineering:multiblocks/mb_dieselgen" | "immersiveengineering:recipes/misc/crafting/gunpart_drum" | "farmersdelight:recipes/decorations/blue_hanging_canvas_sign" | "extradisks:recipes/misc/part/1048576k_storage_part" | "immersiveengineering:recipes/misc/crafting/circuit_table" | "minecraft:recipes/redstone/crimson_door" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_flat_slashed_locometal" | "create:recipes/misc/smelting/lead_ingot_compat_oreganized" | "farmersdelight:recipes/cooking/apple_cider" | "exdeorum:recipes/misc/spruce_compressed_sieve" | "minecraft:recipes/misc/copper_ingot_from_waxed_copper_block" | "immersiveengineering:recipes/misc/smelting/slag_glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_locometal_pillar" | "minecraft:recipes/redstone/acacia_door" | "create:recipes/misc/crafting/appliances/copper_diving_helmet" | "immersiveengineering:recipes/misc/crafting/storage_constantan_from_slab" | "cabletiers:ultra_requester" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_locometal_smokebox" | "minecraft:recipes/misc/tide_armor_trim_smithing_template" | "minecraft:recipes/decorations/spruce_fence" | "minecraft:recipes/tools/diamond_hoe" | "minecraft:recipes/transportation/activator_rail" | "cabletiers:mega_disk_manipulator" | "minecraft:recipes/building_blocks/dark_oak_stairs" | "exmachinis:recipes/misc/item_buffer" | "minecraft:recipes/tools/diamond_shovel" | "minecraft:recipes/building_blocks/polished_granite_slab_from_polished_granite_stonecutting" | "farmersdelight:recipes/cooking/squid_ink_pasta" | "createsweetsandtreets:hold_the_rainbow_adv" | "refinedstorage:recipes/misc/coloring_recipes/magenta_relay" | "minecraft:husbandry/safely_harvest_honey" | "sophisticatedbackpacks:recipes/misc/netherite_backpack" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_locometal_pillar" | "create:recipes/building_blocks/polished_cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "minecraft:recipes/building_blocks/granite_slab" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_from_honeycomb" | "refinedstorage:recipes/misc/coloring_recipes/wireless_transmitter" | "immersiveengineering:recipes/misc/smelting/ingot_nickel2" | "immersiveengineering:recipes/misc/smelting/ingot_nickel3" | "minecraft:adventure/spyglass_at_ghast" | "minecraft:adventure/trim_with_any_armor_pattern" | "minecraft:nether/uneasy_alliance" | "immersiveengineering:recipes/misc/crafting/storage_nickel_to_slab" | "refinedstorage:manipulating_disks" | "farmersdelight:recipes/misc/book_from_canvas" | "copycats:recipes/crafting/copycat_slab_from_steps" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_light_blue_from_slab" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_polished_blackstone_bricks_stonecutting" | "farmersdelight:main/eat_comfort_food" | "immersiveengineering:recipes/misc/crafting/craftingtable" | "minecraft:recipes/redstone/redstone_from_blasting_redstone_ore" | "cabletiers:elite_requester" | "create:recipes/building_blocks/small_limestone_brick_slab" | "create:recipes/building_blocks/cut_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_iron_wrapped_locometal_boiler" | "refinedstorage:recipes/misc/coloring_recipes/red_fluid_grid" | "create:long_train" | "immersiveengineering:recipes/misc/crafting/treated_wood_vertical_from_horizontal" | "copycats:recipes/crafting/copycat_panel_from_conversion" | "railways:recipes/misc/crafting/palettes/wrapping/brown_brass_wrapped_locometal" | "farmersdelight:main/plant_all_crops" | "create:recipes/misc/blasting/ingot_tin_compat_mekanism" | "minecraft:recipes/misc/gravel_from_compressed_gravel" | "create:recipes/building_blocks/cut_granite_from_stone_types_granite_stonecutting" | "minecraft:recipes/building_blocks/polished_diorite_stairs_from_diorite_stonecutting" | "railways:recipes/transportation/benchcart" | "immersiveengineering:recipes/misc/crafting/wire_electrum" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_flat_slashed_locometal" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_3" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_4" | "railways:recipes/misc/crafting/palettes/wrapping/black_iron_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_1" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_2" | "vegandelight:tutorial/silken_tofu" | "create:recipes/building_blocks/cut_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "immersiveengineering:recipes/misc/smelting/ingot_electrum_from_dust_from_blasting" | "minecraft:recipes/building_blocks/dye_black_carpet" | "immersiveengineering:recipes/misc/crafting/storage_nickel_to_ingot_nickel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_iron_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/waxed_copper_block_from_honeycomb" | "minecraft:recipes/building_blocks/weathered_cut_copper" | "refinedstorage:recipes/misc/coloring_recipes/white_fluid_grid" | "create:recipes/building_blocks/cut_scorchia_slab_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/redstone/warped_trapdoor" | "exdeorum:core/silk_worm" | "create:recipes/misc/crafting/kinetics/mechanical_plough" | "create:recipes/misc/smelting/tin_ingot_compat_thermal" | "immersiveengineering:recipes/misc/crafting/raw_block_nickel_to_raw_nickel" | "immersiveengineering:recipes/misc/stonecutting/concrete_brick" | "immersiveengineering:recipes/misc/crafting/raw_block_silver_to_raw_silver" | "minecraft:recipes/building_blocks/dye_brown_wool" | "copycats:recipes/misc/stonecutting/copycat_layer" | "minecraft:recipes/redstone/light_weighted_pressure_plate" | "immersiveengineering:recipes/misc/crafting/strip_curtain" | "more_immersive_wires:recipes/rs_coil" | "minecraft:adventure/throw_trident" | "create:recipes/building_blocks/cut_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "farmersdelight:recipes/cooking/glow_berry_custard" | "immersiveengineering:recipes/misc/crafting/insulating_glass_to_slab" | "refinedstorage:recipes/misc/coloring_recipes/gray_relay" | "create:recipes/misc/crafting/kinetics/belt_connector" | "minecraft:recipes/building_blocks/mossy_cobblestone_slab" | "minecraft:recipes/misc/conduit" | "create:recipes/building_blocks/spruce_window" | "refinedstorage:recipes/misc/fluid_grid/blue_fluid_grid" | "minecraft:recipes/misc/deepslate_from_compressed_deepslate" | "create:recipes/building_blocks/cut_asurine_slab" | "easy_mob_farm:recipes/upgrade/slot/small_slot_upgrade" | "minecraft:recipes/building_blocks/prismarine_stairs_from_prismarine_stonecutting" | "minecraft:recipes/building_blocks/polished_andesite_stairs_from_polished_andesite_stonecutting" | "minecraft:recipes/decorations/green_candle" | "immersiveengineering:recipes/misc/crafting/toolupgrade_shield_flash" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_iron_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/polished_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_slashed_locometal" | "sophisticatedbackpacks:recipes/misc/blasting_upgrade_from_smelting_upgrade" | "immersiveengineering:recipes/misc/smelting/ingot_constantan_from_dust" | "copycats:recipes/misc/stonecutting/copycat_slope" | "extradisks:recipes/misc/part/16384k_fluid_storage_part" | "minecraft:recipes/decorations/bamboo_fence" | "farmersdelight:recipes/decorations/white_hanging_canvas_sign" | "create:recipes/misc/crafting/logistics/content_observer" | "minecraft:recipes/building_blocks/polished_granite_slab" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_from_waxed_weathered_copper_stonecutting" | "minecraft:recipes/redstone/repeater" | "minecraft:recipes/tools/compass" | "farmersdelight:recipes/food/kelp_roll" | "create:recipes/misc/crafting/kinetics/fluid_pipe_vertical" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_flat_riveted_locometal" | "immersiveengineering:recipes/misc/crafting/sawdust" | "minecraft:adventure/ol_betsy" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_locometal_smokebox" | "minecraft:recipes/building_blocks/quartz_block" | "minecraft:recipes/decorations/gray_candle" | "minecraft:recipes/building_blocks/mossy_cobblestone_from_vine" | "create:recipes/building_blocks/cut_crimsite_brick_slab" | "minecraft:recipes/decorations/cyan_bed" | "exdeorum:recipes/misc/ores/thorium_tag" | "create:recipes/building_blocks/polished_cut_dripstone_wall" | "minecraft:nether/netherite_armor" | "minecraft:recipes/building_blocks/birch_stairs" | "minecraft:recipes/building_blocks/jungle_stairs" | "refinedstorage:recipes/misc/coloring_recipes/pattern_grid" | "minecraft:recipes/building_blocks/purpur_pillar" | "minecraft:recipes/food/pumpkin_pie" | "exdeorum:recipes/building_blocks/compressed_crushed_end_stone" | "exdeorum:recipes/misc/iron_mesh_from_flint_mesh" | "minecraft:recipes/decorations/end_rod" | "minecraft:recipes/misc/host_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/small_veridium_brick_slab_recycling" | "exdeorum:recipes/misc/ores/nickel_tag" | "immersiveengineering:recipes/misc/smelting/ingot_nickel" | "create:recipes/building_blocks/cut_calcite_stairs" | "create:recipes/building_blocks/polished_cut_ochrum_wall" | "copycats:recipes/misc/stonecutting/copycat_slope_layer" | "minecraft:husbandry/breed_an_animal" | "exdeorum:recipes/misc/oak_barrel" | "create:recipes/building_blocks/polished_cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/combat/netherite_helmet_smithing" | "minecraft:husbandry/complete_catalogue" | "minecraft:recipes/decorations/gray_stained_glass_pane_from_glass_pane" | "refinedstorage:recipes/misc/coloring_recipes/yellow_crafter_manager" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_wooden_top_from_slab" | "minecraft:recipes/building_blocks/stripped_spruce_wood" | "create:recipes/building_blocks/small_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_boots_from_blasting" | "minecraft:recipes/decorations/brown_stained_glass_pane" | "immersiveengineering:recipes/misc/crafting/toolupgrade_drill_damage" | "create:recipes/misc/crafting/kinetics/mechanical_pump" | "farmersdelight:recipes/decorations/lime_canvas_sign" | "farmersdelight:recipes/decorations/black_hanging_canvas_sign" | "railways:recipes/misc/stonecutting/palettes/cycling/black_flat_riveted_locometal" | "create:recipes/building_blocks/deepslate_pillar_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_honeycomb" | "minecraft:recipes/building_blocks/mossy_cobblestone_stairs" | "immersiveengineering:multiblocks/mb_fermenter" | "create:recipes/misc/crafting/logistics/display_link" | "immersiveengineering:recipes/misc/crafting/slag_brick_to_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_iron_wrapped_locometal_boiler" | "comforts:sleeping_bag_light_blue" | "minecraft:recipes/building_blocks/stripped_cherry_wood" | "minecraft:recipes/decorations/gray_glazed_terracotta" | "minecraft:recipes/misc/light_blue_dye_from_blue_orchid" | "refinedstorage:recipes/misc/coloring_recipes/black_crafter_manager" | "minecraft:recipes/building_blocks/red_nether_brick_slab_from_red_nether_bricks_stonecutting" | "immersiveengineering:recipes/misc/crafting/capacitor_lv" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs" | "minecraft:recipes/building_blocks/lime_concrete_powder" | "create:recipes/building_blocks/crimson_window" | "create:recipes/building_blocks/cut_granite_brick_stairs_from_stone_types_granite_stonecutting" | "farmersdelight:recipes/food/hamburger" | "minecraft:recipes/building_blocks/copper_block" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_locometal_smokebox" | "extradisks:recipes/misc/advanced_machine_casing" | "minecraft:recipes/building_blocks/dark_prismarine_stairs_from_dark_prismarine_stonecutting" | "farmersdelight:recipes/food/rice" | "cabletiers:elite_constructor" | "create:train_portal" | "minecraft:recipes/redstone/spruce_button" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_riveted_locometal" | "sophisticatedbackpacks:recipes/misc/xp_pump_upgrade" | "refinedstorage:recipes/misc/coloring_recipes/orange_security_manager" | "extradisks:recipes/misc/disk/shapeless/262144k_storage_disk" | "minecraft:recipes/misc/popped_chorus_fruit" | "refinedstorage:recipes/misc/coloring_recipes/lime_network_transmitter" | "minecraft:nether/distract_piglin" | "minecraft:recipes/misc/flower_banner_pattern" | "immersiveengineering:tools/craft_buzzsaw" | "exdeorum:recipes/misc/ores/aluminum_tag" | "farmersdelight:recipes/food/apple_pie" | "mobdropsrecipes_overworld:recipes/misc/gunpowder" | "minecraft:recipes/building_blocks/sandstone_stairs" | "sophisticatedbackpacks:recipes/misc/void_upgrade" | "minecraft:recipes/redstone/dark_oak_door" | "comforts:hammock_purple" | "minecraft:recipes/misc/coal_from_smelting_deepslate_coal_ore" | "create:mechanical_pump_0" | "create:brass" | "create:recipes/building_blocks/polished_cut_limestone_from_stone_types_limestone_stonecutting" | "minecraft:recipes/food/dried_kelp_from_smoking" | "refinedstorage:recipes/misc/pattern_grid/magenta_pattern_grid" | "minecraft:recipes/redstone/hopper" | "create:recipes/misc/crafting/kinetics/mechanical_harvester" | "portabletanks:recipes/misc/expert_portable_tank" | "refinedstorage:recipes/misc/fluid_grid/magenta_fluid_grid" | "immersiveengineering:recipes/misc/smelting/concrete_brick_cracked" | "create:recipes/building_blocks/polished_cut_veridium_stairs_from_stone_types_veridium_stonecutting" | "exdeorum:recipes/tools/compressed_diamond_hammer" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_copper_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/shield" | "minecraft:recipes/redstone/calibrated_sculk_sensor" | "vegandelight:tutorial/cooked_tofu_slices" | "create:recipes/building_blocks/cut_dripstone_stairs_from_stone_types_dripstone_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_locometal_smokebox" | "farmersdelight:recipes/food/cooked_bacon_from_campfire_cooking" | "immersiveengineering:recipes/misc/crafting/capacitor_mv" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_from_waxed_oxidized_copper_stonecutting" | "copycats:recipes/misc/stonecutting/copycat_half_panel" | "railways:recipes/misc/stonecutting/palettes/cycling/white_locometal_pillar" | "exdeorum:recipes/misc/tuff" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs_from_oxidized_copper_stonecutting" | "minecraft:recipes/misc/lime_dye" | "immersiveengineering:recipes/misc/smelting/ingot_uranium_from_dust_from_blasting" | "create:recipes/misc/crafting/materials/zinc_ingot_from_compacting" | "minecraft:recipes/misc/gold_ingot_from_smelting_raw_gold" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_iron_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/toolupgrade_shield_magnet" | "immersiveengineering:recipes/misc/stonecutting/slab_slag_brick" | "minecraft:recipes/building_blocks/smooth_basalt" | "create:recipes/building_blocks/small_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_shovel" | "create:recipes/misc/crafting/palettes/scorchia" | "minecraft:recipes/misc/shaper_armor_trim_smithing_template" | "create:recipes/building_blocks/small_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "laserio:recipes/card_redstone_nbtclear" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_flat_riveted_locometal" | "immersiveengineering:recipes/misc/crafting/treated_wood_packaged_from_slab" | "create:recipes/misc/smoking/bread" | "minecraft:recipes/building_blocks/tinted_glass" | "ironchest:recipes/decorations/chests/vanilla_dirt_chest" | "minecraft:recipes/building_blocks/dye_blue_wool" | "sophisticatedbackpacks:recipes/misc/smelting_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_brass_wrapped_locometal_boiler" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum_from_dust_from_blasting" | "create:recipes/building_blocks/polished_cut_scoria_stairs" | "minecraft:recipes/redstone/comparator" | "minecraft:recipes/redstone/mangrove_pressure_plate" | "immersiveengineering:recipes/misc/crafting/capacitor_hv" | "immersiveengineering:recipes/misc/crafting/wall_slag_brick" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/polished_cut_granite_from_stone_types_granite_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_iron" | "farmersdelight:recipes/cooking/hot_cocoa" | "minecraft:recipes/decorations/deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "create:recipes/building_blocks/small_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "create_mechanical_chicken:recipes/misc/crafting/mechanical_chicken" | "immersiveengineering:recipes/misc/crafting/thermoelectric_generator" | "create:recipes/misc/crafting/appliances/tree_fertilizer" | "minecraft:recipes/building_blocks/red_stained_glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_locometal_pillar" | "minecraft:adventure/very_very_frightening" | "minecraft:story/lava_bucket" | "farmersdelight:recipes/food/chocolate_pie" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_plated_locometal" | "farmersdelight:recipes/food/cooked_bacon_from_smoking" | "minecraft:recipes/building_blocks/quartz_stairs" | "create:recipes/building_blocks/cut_crimsite_wall" | "create:recipes/building_blocks/polished_cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/purple_wireless_transmitter" | "refinedstorage:recipes/misc/coloring_recipes/orange_crafter_manager" | "minecraft:recipes/misc/copper_ingot_from_blasting_raw_copper" | "immersiveengineering:recipes/misc/crafting/string" | "refinedstorage:recipes/misc/coloring_recipes/magenta_crafting_monitor" | "mobdropsrecipes_overworld:recipes/misc/overworld_essence_epic" | "minecraft:recipes/decorations/black_bed" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_locometal_pillar" | "create:recipes/building_blocks/small_deepslate_brick_slab_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/layered_scoria_from_stone_types_scoria_stonecutting" | "minecraft:husbandry/ride_a_boat_with_a_goat" | "create:recipes/building_blocks/crafting/kinetics/red_seat_from_other_seat" | "copycats:recipes/misc/stonecutting/copycat_wooden_pressure_plate" | "railways:recipes/combat/dying_existing_cap_magenta" | "railways:recipes/misc/crafting/smokestack_coalburner" | "easy_mob_farm:crafting/mob_farm_template/tier0_mob_farm_template" | "farmersdelight:recipes/combat/netherite_knife_smithing" | "immersiveengineering:recipes/misc/crafting/sheetmetal_electrum_from_slab" | "minecraft:recipes/building_blocks/polished_deepslate_from_cobbled_deepslate_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_controller" | "sophisticatedbackpacks:recipes/misc/backpack" | "create:recipes/building_blocks/cut_granite_brick_slab_recycling" | "minecraft:recipes/food/cooked_beef_from_smoking" | "create:recipes/building_blocks/polished_cut_dripstone_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_slashed_locometal" | "minecraft:recipes/decorations/pink_stained_glass_pane" | "farmersdelight:recipes/decorations/spruce_cabinet" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_locometal_pillar" | "minecraft:nether/all_potions" | "minecraft:recipes/misc/emerald_from_blasting_emerald_ore" | "minecraft:recipes/misc/diamond_from_smelting_deepslate_diamond_ore" | "create:recipes/building_blocks/cut_andesite_bricks_from_stone_types_andesite_stonecutting" | "minecraft:recipes/combat/netherite_boots_smithing" | "minecraft:recipes/misc/light_blue_dye_from_blue_white_dye" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_flat_slashed_locometal" | "create:recipes/building_blocks/cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/building_blocks/orange_concrete_powder" | "minecraft:recipes/food/cooked_porkchop" | "minecraft:recipes/building_blocks/oak_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_flat_slashed_locometal" | "farmersdelight:recipes/food/cooked_chicken_cuts_from_campfire_cooking" | "minecraft:husbandry/tame_an_animal" | "create:recipes/building_blocks/crafting/kinetics/orange_seat_from_other_seat" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone" | "minecraft:recipes/building_blocks/raw_copper_block" | "farmersdelight:recipes/food/roasted_mutton_chops" | "minecraft:recipes/building_blocks/granite_stairs" | "minecraft:recipes/decorations/cyan_glazed_terracotta" | "create:recipes/building_blocks/small_andesite_bricks_from_stone_types_andesite_stonecutting" | "minecraft:recipes/building_blocks/dye_red_bed" | "refinedstorage:recipes/misc/coloring_recipes/pink_crafter_manager" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_copper_wrapped_locometal" | "minecraft:recipes/building_blocks/dye_black_bed" | "minecraft:recipes/tools/brush" | "minecraft:recipes/decorations/cyan_candle" | "minecraft:recipes/building_blocks/diorite_stairs_from_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_locometal_pillar" | "minecraft:recipes/building_blocks/stripped_acacia_wood" | "minecraft:recipes/misc/leather" | "create:recipes/building_blocks/cut_dripstone_from_stone_types_dripstone_stonecutting" | "create:recipes/misc/crafting/curiosities/minecart_coupling" | "create:recipes/building_blocks/cut_veridium_from_stone_types_veridium_stonecutting" | "farmersdelight:recipes/decorations/brown_hanging_canvas_sign" | "minecraft:recipes/decorations/light_gray_bed" | "farmersdelight:recipes/building_blocks/tomato_crate" | "create:recipes/building_blocks/acacia_window_pane" | "immersiveengineering:tools/craft_chemthrower" | "extradisks:recipes/misc/disk/shapeless/infinite_storage_disk" | "minecraft:recipes/building_blocks/blackstone_stairs" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_slashed_locometal" | "farmersdelight:recipes/misc/gold_nugget_from_smelting_knife" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_magenta_from_slab" | "create:windmill_maxed" | "create:recipes/misc/crafting/kinetics/deployer" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_flat_riveted_locometal" | "create:recipes/building_blocks/polished_cut_tuff_wall_from_stone_types_tuff_stonecutting" | "farmersdelight:recipes/food/cooked_salmon_slice" | "exdeorum:recipes/misc/mechanical_hammer" | "exdeorum:recipes/misc/acacia_barrel" | "create:recipes/misc/crafting/appliances/copper_diving_boots" | "extrastorage:advanced_exporter" | "create:recipes/building_blocks/cut_limestone_wall_from_stone_types_limestone_stonecutting" | "minecraft:recipes/transportation/bamboo_chest_raft" | "minecraft:recipes/decorations/cyan_banner" | "ironchest:recipes/decorations/chests/trapped_crystal_chest" | "immersiveengineering:recipes/misc/crafting/toolupgrade_drill_fortune" | "minecraft:recipes/decorations/red_banner" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/raw_gold_block" | "minecraft:recipes/building_blocks/dye_red_wool" | "minecraft:recipes/combat/iron_boots" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_slashed_locometal" | "immersiveengineering:recipes/misc/smelting/ingot_electrum_from_dust" | "cabletiers:elite_interface" | "minecraft:recipes/building_blocks/birch_planks" | "railways:recipes/misc/crafting/palettes/wrapping/copper_wrapped_locometal" | "extrastorage:recipes/misc/disk/shapeless/disk_16384k" | "comforts:sleeping_bag_white" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_locometal_boiler" | "easy_mob_farm:recipes/mob_farm/monster_plains_cave_farm" | "create:recipes/building_blocks/acacia_window" | "create:recipes/misc/smelting/glass_from_tiled_glass" | "create:track_0" | "minecraft:recipes/building_blocks/polished_blackstone_slab_from_blackstone_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_blasting_deepslate_gold_ore" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_flat_slashed_locometal" | "minecraft:recipes/redstone/spruce_pressure_plate" | "refinedstorage:recipes/misc/coloring_recipes/pink_controller" | "exdeorum:recipes/tools/golden_watering_can" | "copycats:recipes/misc/stonecutting/copycat_block" | "minecraft:recipes/building_blocks/granite_stairs_from_granite_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_stairs_from_prismarine_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_blasting_gold_ore" | "railways:recipes/misc/crafting/palettes/wrapping/black_copper_wrapped_locometal" | "minecraft:recipes/decorations/magenta_glazed_terracotta" | "create:recipes/misc/crafting/kinetics/clutch" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_iron_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/polished_cut_deepslate_stairs" | "minecraft:recipes/building_blocks/polished_granite_stairs_from_polished_granite_stonecutting" | "immersiveengineering:recipes/misc/smelting/iron_ingot_from_dust_from_blasting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_iron_wrapped_locometal" | "sophisticatedbackpacks:recipes/misc/refill_upgrade" | "ironchest:recipes/decorations/chests/trapped_gold_chest" | "minecraft:recipes/building_blocks/mud_brick_stairs" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_grate_top_from_standard" | "minecraft:recipes/building_blocks/dye_blue_carpet" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_riveted_locometal" | "create:recipes/building_blocks/cut_dripstone_stairs" | "create:recipes/building_blocks/copper_tile_stairs" | "minecraft:recipes/building_blocks/dye_light_gray_wool" | "create:recipes/misc/crafting/curiosities/cake" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_riveted_locometal" | "refinedstorage:recipes/misc/coloring_recipes/lime_crafting_monitor" | "minecraft:recipes/decorations/magenta_banner" | "minecraft:recipes/misc/netherrack_from_compressed_netherrack" | "minecraft:recipes/tools/stone_pickaxe" | "refinedstorage:recipes/misc/fluid_grid/gray_fluid_grid" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_copper_wrapped_locometal" | "create:recipes/building_blocks/cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/polished_cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "immersiveengineering:main/secret_luckofthedraw" | "peco:recipes/decorations/heads" | "create:recipes/misc/crafting/kinetics/depot" | "minecraft:recipes/decorations/deepslate_brick_wall" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_leggings_from_blasting" | "immersiveengineering:recipes/misc/crafting/drill" | "railways:recipes/misc/stonecutting/palettes/cycling/red_riveted_locometal" | "refinedstorage:recipes/misc/coloring_recipes/black_fluid_grid" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_brass_wrapped_locometal" | "minecraft:recipes/misc/black_dye" | "immersiveengineering:recipes/misc/crafting/light_engineering" | "minecraft:recipes/building_blocks/light_gray_stained_glass" | "minecraft:recipes/food/honey_bottle" | "immersiveengineering:recipes/misc/crafting/armor_faraday_leggings" | "railways:recipes/misc/crafting/palettes/wrapping/brown_iron_wrapped_locometal" | "create:recipes/building_blocks/layered_calcite_from_stone_types_calcite_stonecutting" | "minecraft:recipes/misc/light_gray_dye_from_gray_white_dye" | "create:recipes/building_blocks/small_crimsite_brick_wall" | "minecraft:recipes/decorations/acacia_sign" | "immersiveengineering:recipes/misc/crafting/sawblade" | "minecraft:recipes/building_blocks/brick_slab" | "create:recipes/combat/crafting/appliances/netherite_backtank" | "refinedstorage:recipes/misc/coloring_recipes/detector" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/iron_ingot_from_smelting_iron_ore" | "minecraft:recipes/decorations/lantern" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_crafting_monitor" | "minecraft:recipes/decorations/cherry_sign" | "create:recipes/building_blocks/cut_scorchia_brick_slab_recycling" | "refinedstorage:recipes/misc/coloring_recipes/lime_wireless_transmitter" | "immersiveengineering:recipes/misc/crafting/plate_aluminum_hammering" | "create:recipes/misc/crafting/kinetics/minecart_from_contraption_cart" | "farmersdelight:recipes/food/beef_patty" | "railways:recipes/misc/crafting/palettes/wrapping/white_iron_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_brass_wrapped_locometal" | "easy_mob_farm:recipes/upgrade/slot/big_slot_upgrade" | "refinedstorage:wireless" | "refinedstorage:recipes/misc/coloring_recipes/purple_network_transmitter" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_1_from_starter" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_iron_wrapped_locometal_boiler" | "refinedstorage:recipes/misc/coloring_recipes/yellow_grid" | "sophisticatedbackpacks:recipes/misc/stonecutter_upgrade" | "immersiveengineering:recipes/misc/crafting/conveyor_vertical_covered" | "immersiveengineering:tools/secret_birthdayparty" | "minecraft:recipes/building_blocks/cobbled_deepslate_slab_from_cobbled_deepslate_stonecutting" | "create:recipes/building_blocks/cut_diorite_brick_slab_recycling" | "create:recipes/building_blocks/ornate_iron_window" | "refinedstorage:recipes/misc/coloring_recipes/purple_crafting_monitor" | "create:recipes/misc/crafting/kinetics/attribute_filter" | "minecraft:recipes/misc/orange_dye_from_red_yellow" | "create:recipes/building_blocks/cut_crimsite_slab_recycling" | "immersiveengineering:recipes/misc/crafting/plate_nickel_hammering" | "railways:recipes/misc/crafting/track_switch_andesite" | "immersiveengineering:recipes/misc/crafting/blastbrick_reinforced_to_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_locometal_smokebox" | "immersiveengineering:recipes/misc/crafting/conveyor_basic_covered" | "minecraft:adventure/fall_from_world_height" | "minecraft:recipes/misc/gold_ingot_from_blasting_nether_gold_ore" | "create:fist_bump" | "minecraft:recipes/building_blocks/dye_orange_bed" | "minecraft:recipes/food/rabbit_stew_from_brown_mushroom" | "refinedstorage:recipes/misc/coloring_recipes/yellow_network_transmitter" | "immersiveengineering:recipes/misc/crafting/storage_lead_to_slab" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingle_stairs_from_honeycomb" | "minecraft:recipes/building_blocks/magenta_concrete_powder" | "minecraft:recipes/decorations/blue_bed" | "immersiveengineering:recipes/misc/crafting/raw_block_uranium_to_raw_uranium" | "extradisks:recipes/misc/disk/shapeless/16384k_fluid_storage_disk" | "minecraft:recipes/decorations/green_bed" | "create:recipes/building_blocks/cut_scorchia_brick_stairs" | "immersiveengineering:recipes/misc/crafting/ingot_steel_to_storage_steel" | "railways:recipes/misc/stonecutting/palettes/cycling/black_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_locometal_smokebox" | "refinedstorage:recipes/misc/coloring_recipes/green_grid" | "minecraft:recipes/building_blocks/cut_sandstone_from_sandstone_stonecutting" | "extrastorage:recipes/misc/diamond_crafter" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tile_slab_from_honeycomb" | "minecraft:recipes/decorations/campfire" | "railways:recipes/misc/stonecutting/palettes/cycling/red_locometal_smokebox" | "minecraft:recipes/decorations/lime_stained_glass_pane" | "minecraft:recipes/misc/snout_armor_trim_smithing_template" | "minecraft:recipes/transportation/hopper_minecart" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_plated_locometal" | "copycats:recipes/misc/stonecutting/copycat_vertical_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_plated_locometal" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_cobbled_deepslate_stonecutting" | "railways:recipes/combat/dying_existing_cap_light_blue" | "farmersdelight:recipes/cooking/dumplings" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_riveted_locometal" | "create:recipes/building_blocks/cut_ochrum_brick_wall" | "farmersdelight:recipes/food/sweet_berry_cheesecake_from_slices" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_shovel_from_blasting" | "sophisticatedbackpacks:recipes/misc/chipped/botanist_workbench_upgrade" | "minecraft:recipes/building_blocks/terracotta" | "exdeorum:recipes/misc/crimson_barrel" | "minecraft:recipes/misc/red_dye_from_beetroot" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_iron_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_green" | "copycats:recipes/misc/stonecutting/copycat_light_weighted_pressure_plate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_locometal_smokebox" | "create:display_link" | "farmersdelight:main/get_ham" | "create:recipes/building_blocks/scoria_pillar_from_stone_types_scoria_stonecutting" | "extrastorage:recipes/misc/part/storagepart_4096k" | "minecraft:recipes/redstone/jungle_trapdoor" | "minecraft:recipes/tools/wooden_hoe" | "create:recipes/building_blocks/polished_cut_scorchia_from_stone_types_scorchia_stonecutting" | "sophisticatedbackpacks:recipes/misc/pickup_upgrade" | "farmersdelight:recipes/decorations/light_blue_canvas_sign" | "immersiveengineering:recipes/misc/crafting/toolupgrade_revolver_electro" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_copper_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_brass_wrapped_locometal" | "farmersdelight:recipes/decorations/orange_canvas_sign" | "railways:recipes/misc/crafting/palettes/wrapping/black_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/chiseled_sandstone_from_sandstone_stonecutting" | "minecraft:recipes/building_blocks/polished_deepslate_slab_from_polished_deepslate_stonecutting" | "easy_mob_farm:recipes/upgrade/enchancement/experience_enhancement" | "immersiveengineering:recipes/misc/crafting/blueprint_bullets" | "minecraft:recipes/decorations/granite_wall" | "additionalredstone:recipes/oscillator" | "create:recipes/building_blocks/copper_tile_slab_from_copper_tiles_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_copper_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/armor_faraday_boots" | "minecraft:recipes/building_blocks/orange_terracotta" | "minecraft:recipes/misc/silence_armor_trim_smithing_template" | "create:recipes/misc/crafting/schematics/schematicannon" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_locometal_boiler" | "laserio:recipes/misc/overclocker_node" | "farmersdelight:recipes/food/cooked_chicken_cuts" | "minecraft:recipes/food/cooked_chicken_from_smoking" | "minecraft:recipes/redstone/oak_fence_gate" | "mobdropsrecipes_overworld:recipes/misc/essence_into_phantom_membrane" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_flat_riveted_locometal" | "create:recipes/building_blocks/cut_deepslate_brick_slab_recycling" | "create:recipes/misc/crafting/kinetics/metal_girder" | "railways:recipes/misc/stonecutting/palettes/cycling/red_locometal_pillar" | "extrastorage:recipes/misc/storage_block/block_16384k" | "minecraft:husbandry/bred_all_animals" | "immersiveengineering:recipes/misc/crafting/lead_white" | "extrastorage:recipes/misc/disk/shaped/disk_16384k" | "refinedstorage:recipes/misc/coloring_recipes/red_disk_manipulator" | "immersiveengineering:recipes/misc/crafting/rs_engineering" | "create:recipes/building_blocks/cut_asurine_brick_stairs" | "create:recipes/building_blocks/cut_diorite_stairs" | "create:recipes/building_blocks/cut_tuff_slab" | "refinedstorage:recipes/misc/coloring_recipes/green_crafter" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_brass_wrapped_locometal" | "extrastorage:recipes/misc/disk/shaped/disk_1048576k_fluid" | "railways:recipes/misc/stonecutting/palettes/cycling/green_plated_locometal" | "create:saw_processing" | "minecraft:recipes/misc/charcoal" | "minecraft:recipes/building_blocks/stone_brick_slab" | "immersiveengineering:recipes/misc/crafting/electromagnet" | "extradisks:recipes/misc/disk/shaped/infinite_fluid_storage_disk" | "minecraft:recipes/redstone/cherry_pressure_plate" | "minecraft:recipes/redstone/warped_pressure_plate" | "immersiveengineering:recipes/misc/crafting/armor_faraday_helmet" | "refinedstorage:recipes/misc/coloring_recipes/lime_detector" | "minecraft:recipes/building_blocks/polished_granite_slab_from_granite_stonecutting" | "minecraft:recipes/building_blocks/polished_andesite_from_andesite_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/magenta_crafter" | "refinedstorage:recipes/misc/coloring_recipes/red_relay" | "minecraft:recipes/tools/iron_shovel" | "laserio:recipes/misc/filter_nbt" | "refinedstorage:recipes/misc/crafting_grid/magenta_crafting_grid" | "ironchest:recipes/decorations/chests/trapped_obsidian_chest" | "create:recipes/building_blocks/cut_asurine_slab_from_stone_types_asurine_stonecutting" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_helmet_from_blasting" | "sophisticatedbackpacks:recipes/misc/jukebox_upgrade" | "create:recipes/misc/crafting/kinetics/lime_valve_handle_from_other_valve_handle" | "minecraft:recipes/food/cooked_salmon_from_campfire_cooking" | "create:recipes/misc/crafting/materials/brass_block_from_compacting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_flat_slashed_locometal" | "farmersdelight:recipes/food/cooked_mutton_chops_from_campfire_cooking" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_plated_locometal" | "minecraft:recipes/decorations/item_frame" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_brass_wrapped_locometal" | "exdeorum:recipes/building_blocks/compressed_crushed_deepslate" | "farmersdelight:recipes/decorations/gray_hanging_canvas_sign" | "minecraft:recipes/building_blocks/cut_copper_slab" | "farmersdelight:recipes/food/rice_roll_medley_block" | "immersiveengineering:tools/upgrade_drill" | "immersiveengineering:recipes/misc/crafting/hempcrete_from_slab" | "create:recipes/building_blocks/cut_andesite_brick_wall" | "farmersdelight:recipes/food/cake_from_slices" | "laserio:recipes/misc/logic_chip" | "create:recipes/building_blocks/cut_veridium_stairs" | "create:recipes/building_blocks/cut_crimsite_from_stone_types_crimsite_stonecutting" | "create:recipes/building_blocks/jungle_window_pane" | "create:recipes/building_blocks/crimson_window_pane" | "create:recipes/misc/crafting/kinetics/shaft" | "create:recipes/building_blocks/small_ochrum_brick_slab" | "minecraft:recipes/redstone/bamboo_pressure_plate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_brass_wrapped_locometal_boiler" | "mobdropsrecipes_overworld:recipes/misc/overworld_essence_uncommon" | "naturescompass:natures_compass_log" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab" | "farmersdelight:recipes/cooking/pasta_with_meatballs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_brass_wrapped_locometal" | "minecraft:recipes/misc/coast_armor_trim_smithing_template" | "minecraft:recipes/misc/ward_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/combat/diamond_helmet" | "railways:recipes/misc/stonecutting/palettes/cycling/red_plated_locometal" | "create:recipes/misc/crafting/kinetics/white_valve_handle_from_other_valve_handle" | "farmersdelight:recipes/decorations/full_tatami_mat_from_halves" | "ironchest:recipes/decorations/chests/iron_gold_chest" | "refinedstorage:recipes/misc/coloring_recipes/magenta_controller" | "sliceanddice:recipes/misc/slicer" | "immersiveengineering:recipes/misc/smelting/lead_red" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_locometal_boiler" | "exmachinis:recipes/misc/flux_hammer" | "refinedstorage:recipes/misc/coloring_recipes/white_crafter" | "minecraft:adventure/walk_on_powder_snow_with_leather_boots" | "refinedstorage:recipes/misc/coloring_recipes/black_wireless_transmitter" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_locometal_boiler" | "create:deployer" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_locometal_boiler" | "easy_mob_farm:recipes/mob_farm_template/tier3_mob_farm_template" | "minecraft:recipes/misc/raiser_armor_trim_smithing_template" | "extradisks:recipes/misc/part/262144k_fluid_storage_part" | "minecraft:recipes/building_blocks/chiseled_nether_bricks_from_nether_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_copper_wrapped_locometal_boiler" | "sophisticatedbackpacks:recipes/misc/advanced_pump_upgrade" | "immersiveengineering:recipes/misc/crafting/coil_mv" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_iron_wrapped_locometal" | "create:recipes/building_blocks/small_calcite_brick_stairs" | "create:recipes/building_blocks/polished_cut_asurine_wall" | "create:recipes/misc/crafting/kinetics/gearboxfrom_conversion" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingles_from_honeycomb" | "create:recipes/building_blocks/framed_glass_from_glass_colorless_stonecutting" | "minecraft:recipes/building_blocks/chiseled_stone_bricks_from_stone_bricks_stonecutting" | "farmersdelight:recipes/decorations/crimson_cabinet" | "create:recipes/misc/crafting/kinetics/hand_crank" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_copper_wrapped_locometal_boiler" | "minecraft:recipes/decorations/pink_bed" | "create:recipes/building_blocks/cut_asurine_wall_from_stone_types_asurine_stonecutting" | "create:recipes/building_blocks/small_calcite_brick_slab_recycling" | "minecraft:recipes/misc/coal_from_blasting_deepslate_coal_ore" | "immersiveengineering:recipes/misc/crafting/coil_lv" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_copper_wrapped_locometal_boiler" | "mcwfurnitures:recipes/spruce" | "immersiveengineering:recipes/misc/crafting/concrete_pillar" | "create:recipes/building_blocks/copper_tile_slab" | "refinedstorage:recipes/misc/coloring_recipes/pink_disk_manipulator" | "comforts:sleeping_bag_purple" | "farmersdelight:recipes/decorations/hanging_canvas_sign" | "create:recipes/building_blocks/cut_tuff_brick_stairs" | "minecraft:recipes/building_blocks/cyan_stained_glass" | "minecraft:recipes/tools/netherite_axe_smithing" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_plated_locometal" | "railways:recipes/misc/crafting/smokestack_oilburner" | "minecraft:recipes/decorations/jungle_sign" | "minecraft:recipes/building_blocks/andesite" | "minecraft:recipes/building_blocks/cut_sandstone_slab_from_sandstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/alloybrick" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/exposed_cut_copper_from_exposed_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_locometal_pillar" | "comforts:sleeping_bag_green" | "extrastorage:recipes/misc/storage_block/block_16384k_fluid" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_iron_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/storage_aluminum_to_slab" | "refinedstorage:recipes/misc/coloring_recipes/yellow_relay" | "minecraft:recipes/building_blocks/blackstone_slab" | "minecraft:husbandry/feed_snifflet" | "minecraft:recipes/building_blocks/sandstone_slab_from_sandstone_stonecutting" | "create:recipes/misc/crafting/kinetics/copper_valve_handle" | "create:recipes/building_blocks/cut_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "create:recipes/building_blocks/small_deepslate_brick_stairs" | "immersiveengineering:recipes/misc/crafting/screwdriver" | "minecraft:story/form_obsidian" | "refinedstorage:recipes/misc/fluid_grid/red_fluid_grid" | "create:recipes/building_blocks/layered_scorchia_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/misc/netherite_ingot_from_netherite_block" | "create:recipes/building_blocks/small_crimsite_brick_stairs" | "create:haunted_bell" | "create:recipes/building_blocks/cut_dripstone_brick_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_copper_wrapped_locometal" | "minecraft:end/enter_end_gateway" | "immersiveengineering:multiblocks/mb_arcfurnace" | "immersiveengineering:recipes/misc/crafting/storage_lead_to_ingot_lead" | "minecraft:recipes/building_blocks/bamboo_slab" | "create:recipes/building_blocks/cut_scoria_slab_recycling" | "railways:recipes/misc/stonecutting/palettes/cycling/green_flat_riveted_locometal" | "create:recipes/building_blocks/cut_calcite_wall_from_stone_types_calcite_stonecutting" | "laserio:recipes/misc/card_holder" | "minecraft:recipes/building_blocks/polished_blackstone_slab_from_polished_blackstone_stonecutting" | "exdeorum:recipes/misc/bamboo_sieve" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_chestplate_from_blasting" | "refinedstorage:recipes/misc/pattern_grid/orange_pattern_grid" | "copycats:recipes/crafting/copycat_layer_from_half_layers" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_flat_riveted_locometal" | "immersiveengineering:main/craft_hammer" | "minecraft:nether/loot_bastion" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_iron_wrapped_locometal_boiler" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_grate_top_to_slab" | "minecraft:recipes/redstone/oak_door" | "create:recipes/misc/campfire_cooking/bread" | "minecraft:recipes/building_blocks/dye_yellow_carpet" | "exmachinis:recipes/misc/flux_compactor" | "immersiveengineering:recipes/misc/crafting/steel_slope" | "create:recipes/building_blocks/copycat_panel_from_ingots_zinc_stonecutting" | "exdeorum:recipes/misc/diamond_mesh" | "refinedstorage:recipes/misc/coloring_recipes/black_detector" | "refinedstorage:recipes/misc/coloring_recipes/cyan_detector" | "minecraft:recipes/misc/iron_ingot_from_iron_block" | "create:recipes/building_blocks/cut_diorite_slab" | "immersiveengineering:recipes/misc/crafting/stick_aluminum" | "railways:recipes/misc/crafting/palettes/wrapping/light_blue_copper_wrapped_locometal" | "minecraft:recipes/redstone/jungle_door" | "create:recipes/building_blocks/horizontal_framed_glass_pane" | "create:recipes/building_blocks/small_deepslate_bricks_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/granite_pillar_from_stone_types_granite_stonecutting" | "immersiveengineering:recipes/misc/crafting/component_steel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_flat_riveted_locometal" | "create:recipes/building_blocks/polished_cut_crimsite_slab" | "create:recipes/misc/smelting/zinc_ingot_from_crushed" | "minecraft:recipes/decorations/end_stone_brick_wall_from_end_stone_stonecutting" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_standard_from_wooden_top" | "refinedstorage:wireless_monitoring" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_blackstone_stonecutting" | "sophisticatedbackpacks:recipes/misc/auto_blasting_upgrade" | "immersiveengineering:recipes/misc/smelting/gold_ingot_from_dust" | "create:recipes/misc/crafting/kinetics/propeller" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_locometal_boiler" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tile_stairs_from_honeycomb" | "immersiveengineering:recipes/misc/crafting/furnace_heater" | "ironchest:recipes/decorations/upgrades/copper_to_iron_chest_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_copper_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_locometal_smokebox" | "mobdropsrecipes_overworld:recipes/misc/essence_into_trident" | "copycats:recipes/crafting/copycat_vertical_stairs_from_conversion" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_iron_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_andesite_slab_recycling" | "minecraft:recipes/decorations/light_gray_candle" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_locometal_pillar" | "refinedstorage:recipes/misc/coloring_recipes/red_network_receiver" | "create:recipes/building_blocks/calcite_pillar_from_stone_types_calcite_stonecutting" | "minecraft:recipes/building_blocks/melon" | "cobblefordays:recipes/misc/tier_3" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_waxed_exposed_cut_copper_stonecutting" | "cobblefordays:recipes/misc/tier_4" | "cobblefordays:recipes/misc/tier_5" | "farmersdelight:recipes/decorations/canvas_rug" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_brass_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/raw_silver_to_raw_block_silver" | "cobblefordays:recipes/misc/tier_1" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_copper_wrapped_locometal_boiler" | "cobblefordays:recipes/misc/tier_2" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_locometal_pillar" | "minecraft:recipes/building_blocks/polished_andesite_slab" | "create:recipes/building_blocks/polished_cut_ochrum_slab_recycling" | "mobdropsrecipes_overworld:recipes/misc/bone" | "create:recipes/misc/crafting/materials/experience_nugget_from_block" | "immersiveengineering:tools/upgrade_revolver" | "create:recipes/misc/crafting/kinetics/orange_valve_handle_from_other_valve_handle" | "create:recipes/building_blocks/polished_cut_granite_wall_from_stone_types_granite_stonecutting" | "extradisks:recipes/misc/disk/shaped/65536k_storage_disk" | "create:recipes/building_blocks/cut_veridium_brick_stairs" | "create:recipes/building_blocks/diorite_from_stone_types_diorite_stonecutting" | "refinedstorage:recipes/misc/fluid_grid/orange_fluid_grid" | "exmachinis:recipes/misc/flux_sieve" | "minecraft:recipes/decorations/yellow_stained_glass_pane_from_glass_pane" | "refinedstorage:recipes/misc/coloring_recipes/network_receiver" | "farmersdelight:recipes/decorations/lime_hanging_canvas_sign" | "create:recipes/building_blocks/cut_diorite_brick_wall_from_stone_types_diorite_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_stairs" | "create:recipes/misc/crafting/kinetics/gray_valve_handle_from_other_valve_handle" | "create:mechanical_press" | "minecraft:recipes/combat/golden_sword" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_plated_locometal" | "minecraft:end/elytra" | "create:recipes/misc/crafting/kinetics/turntable" | "minecraft:recipes/decorations/mangrove_sign" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_slashed_locometal" | "exdeorum:recipes/misc/ores/boron_tag" | "minecraft:recipes/tools/wooden_shovel" | "farmersdelight:recipes/decorations/birch_cabinet" | "extradisks:recipes/misc/disk/shapeless/1048576k_fluid_storage_disk" | "minecraft:recipes/decorations/bamboo_mosaic" | "minecraft:recipes/building_blocks/purpur_stairs" | "refinedstorage:recipes/misc/coloring_recipes/lime_network_receiver" | "easy_mob_farm:recipes/mob_farm/ocean_farm" | "minecraft:recipes/redstone/redstone_lamp" | "minecraft:recipes/building_blocks/mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/orange_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_riveted_locometal" | "vegandelight:tutorial/minced_tofu" | "refinedstorage:recipes/misc/coloring_recipes/lime_disk_manipulator" | "minecraft:recipes/decorations/crimson_fence" | "minecraft:recipes/redstone/dispenser" | "create:recipes/building_blocks/polished_cut_limestone_stairs" | "create:recipes/misc/crafting/appliances/clipboard_clear" | "immersiveengineering:recipes/misc/crafting/redstone_breaker" | "refinedstorage:recipes/misc/coloring_recipes/disk_manipulator" | "create:recipes/building_blocks/polished_cut_andesite_from_stone_types_andesite_stonecutting" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/purpur_pillar_from_purpur_block_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/cyan_fluid_grid" | "create:recipes/building_blocks/polished_cut_ochrum_stairs" | "immersiveengineering:recipes/misc/smelting/ingot_lead_from_blasting2" | "minecraft:recipes/building_blocks/cobblestone_slab" | "exdeorum:recipes/misc/calcite" | "refinedstorage:recipes/misc/coloring_recipes/green_wireless_transmitter" | "copycats:recipes/misc/crafting/copycat_fluid_pipe" | "create:recipes/misc/crafting/kinetics/encased_chain_drive" | "immersiveengineering:multiblocks/craft_duroplast" | "farmersdelight:recipes/food/beetroot_from_crate" | "minecraft:recipes/building_blocks/stripped_crimson_hyphae" | "immersiveengineering:recipes/misc/stonecutting/concrete_quarter" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_leggings_from_blasting" | "create:recipes/misc/crafting/kinetics/mechanical_drill" | "extradisks:recipes/misc/part/1024k_storage_part" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_flat_riveted_locometal" | "naturescompass:natures_compass_sapling" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_grate_top_from_standard" | "minecraft:recipes/building_blocks/magenta_terracotta" | "minecraft:recipes/misc/brick" | "ironchest:recipes/decorations/chests/vanilla_iron_chest" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_locometal_boiler" | "create:recipes/building_blocks/cut_crimsite_stairs" | "extrastorage:recipes/misc/disk/shapeless/disk_1048576k_fluid" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_wooden_top_to_slab" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_black" | "refinedstorage:recipes/misc/pattern_grid/white_pattern_grid" | "create:recipes/building_blocks/polished_cut_veridium_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_iron_wrapped_locometal" | "immersiveengineering:recipes/misc/stonecutting/wall_slag_brick" | "minecraft:recipes/building_blocks/gold_block" | "railways:recipes/combat/dying_existing_cap_brown" | "create:recipes/building_blocks/cut_andesite_brick_slab_recycling" | "create:recipes/misc/smelting/ingot_uranium_compat_mekanism" | "create:recipes/building_blocks/layered_dripstone_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs_from_exposed_cut_copper_stonecutting" | "exdeorum:recipes/misc/ores/zinc_tag" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_slashed_locometal" | "minecraft:recipes/misc/yellow_dye_from_sunflower" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_locometal_pillar" | "minecraft:recipes/brewing/cauldron" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab" | "minecraft:recipes/decorations/armor_stand" | "laserio:recipes/card_energy_nbtclear" | "create:recipes/building_blocks/cut_andesite_wall_from_stone_types_andesite_stonecutting" | "create:recipes/building_blocks/polished_cut_scoria_slab_from_stone_types_scoria_stonecutting" | "create:recipes/misc/crafting/kinetics/track_observer" | "create:recipes/decorations/andesite_bars_from_andesite_alloy_stonecutting" | "comforts:sleeping_bag_orange" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_brass_wrapped_locometal_boiler" | "immersiveengineering:recipes/misc/smelting/ingot_lead_from_blasting3" | "easy_mob_farm:recipes/mob_farm/swamp_farm" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_iron_wrapped_locometal_boiler" | "create:recipes/misc/crafting/kinetics/sail_framefrom_conversion" | "create:recipes/misc/crafting/kinetics/sticker" | "exdeorum:recipes/tools/crook" | "minecraft:recipes/transportation/acacia_boat" | "minecraft:recipes/redstone/iron_trapdoor" | "immersiveengineering:recipes/misc/crafting/manual" | "railways:recipes/misc/crafting/buffer" | "minecraft:adventure/root" | "minecraft:recipes/building_blocks/end_stone_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_copper_wrapped_locometal" | "minecraft:recipes/decorations/jungle_fence" | "exdeorum:recipes/misc/mangrove_crucible" | "minecraft:recipes/misc/tide_armor_trim_smithing_template_smithing_trim" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_standard_to_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_locometal_boiler" | "createsweetsandtreets:create_bake_the_cake" | "immersiveengineering:recipes/misc/crafting/component_iron" | "immersiveengineering:recipes/misc/smelting/ingot_uranium_from_dust" | "minecraft:recipes/decorations/mud_brick_wall_from_mud_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_flat_slashed_locometal" | "minecraft:recipes/building_blocks/chiseled_quartz_block_from_quartz_block_stonecutting" | "minecraft:recipes/misc/ender_eye" | "immersiveengineering:recipes/misc/crafting/sample_drill" | "immersiveengineering:recipes/misc/crafting/electrum_mix" | "minecraft:recipes/redstone/redstone_block" | "minecraft:recipes/decorations/dark_oak_hanging_sign" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_locometal_pillar" | "immersiveengineering:recipes/misc/crafting/toolupgrade_revolver_bayonet" | "create:recipes/misc/crafting/kinetics/smart_fluid_pipe" | "create:recipes/building_blocks/polished_cut_tuff_slab_recycling" | "extrastorage:recipes/misc/disk/shapeless/disk_256k" | "refinedstorage:exporting" | "minecraft:recipes/building_blocks/cyan_terracotta" | "create:recipes/misc/crafting/materials/raw_zinc" | "minecraft:recipes/decorations/nether_brick_wall_from_nether_bricks_stonecutting" | "minecraft:recipes/decorations/red_stained_glass_pane_from_glass_pane" | "minecraft:story/follow_ender_eye" | "immersiveengineering:main/craft_batcher" | "minecraft:recipes/building_blocks/weathered_cut_copper_from_weathered_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_slashed_locometal" | "copycats:recipes/crafting/copycat_block_from_slabs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_brass_wrapped_locometal_boiler" | "create:recipes/misc/smelting/ingot_lead_compat_immersiveengineering" | "immersiveengineering:recipes/misc/crafting/raw_nickel_to_raw_block_nickel" | "create:recipes/building_blocks/cut_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/pink_network_receiver" | "immersiveengineering:recipes/misc/crafting/sheetmetal_copper_from_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_locometal_pillar" | "immersiveengineering:tools/tools_root" | "minecraft:recipes/decorations/deepslate_tile_wall_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/misc/iron_ingot_from_blasting_raw_iron" | "create:recipes/building_blocks/small_limestone_bricks_from_stone_types_limestone_stonecutting" | "create:recipes/misc/crafting/materials/brass_ingot_from_compacting" | "immersiveengineering:recipes/misc/crafting/plate_constantan_hammering" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_wooden_top_to_slab" | "create:steam_engine" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_locometal_pillar" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_blue_to_slab" | "minecraft:recipes/misc/blue_dye_from_cornflower" | "minecraft:recipes/redstone/slime_block" | "create:recipes/building_blocks/small_asurine_brick_slab" | "immersiveengineering:recipes/misc/crafting/sheetmetal_iron_to_slab" | "create:recipes/building_blocks/polished_cut_scorchia_wall" | "create:recipes/building_blocks/small_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "immersiveengineering:recipes/misc/smelting/ingot_lead" | "create:recipes/building_blocks/cut_granite_brick_stairs" | "exdeorum:recipes/misc/jungle_compressed_sieve" | "minecraft:recipes/decorations/bamboo_hanging_sign" | "create:recipes/building_blocks/small_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_flat_riveted_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_locometal_smokebox" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tiles_from_honeycomb" | "extrastorage:recipes/misc/disk/shapeless/disk_65536k_fluid" | "minecraft:recipes/building_blocks/acacia_wood" | "sophisticatedbackpacks:recipes/misc/pump_upgrade" | "create:recipes/building_blocks/ornate_iron_window_pane" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_riveted_locometal" | "minecraft:recipes/decorations/polished_blackstone_brick_wall" | "create:recipes/building_blocks/scorchia_pillar_from_stone_types_scorchia_stonecutting" | "immersiveengineering:recipes/misc/smelting/ingot_silver_from_blasting2" | "immersiveengineering:recipes/misc/smelting/ingot_silver_from_blasting3" | "create:recipes/building_blocks/small_asurine_brick_stairs" | "minecraft:recipes/combat/wooden_sword" | "minecraft:recipes/decorations/gray_banner" | "minecraft:recipes/building_blocks/oak_planks" | "minecraft:recipes/decorations/light_blue_carpet" | "mcwfurnitures:recipes/oak" | "create:recipes/building_blocks/cut_scoria_wall" | "exdeorum:recipes/misc/ores/lead_tag" | "extrastorage:recipes/misc/part/storagepart_256k" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_slashed_locometal" | "railways:recipes/misc/crafting/smokestack_long" | "minecraft:recipes/building_blocks/dye_blue_bed" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_brass_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_brass_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/quartz_slab_from_stonecutting" | "immersiveengineering:recipes/misc/crafting/hempcrete_pillar" | "minecraft:recipes/building_blocks/black_concrete_powder" | "immersiveengineering:recipes/misc/crafting/wire_steel" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_plated_locometal" | "refinedstorage:recipes/misc/fluid_grid/fluid_grid" | "farmersdelight:recipes/building_blocks/tatami_block_from_full" | "exdeorum:recipes/misc/mechanical_sieve" | "railways:recipes/misc/stonecutting/palettes/cycling/red_flat_slashed_locometal" | "create:recipes/building_blocks/cut_veridium_slab" | "immersiveengineering:recipes/misc/crafting/stairs_treated_wood_packaged" | "minecraft:recipes/combat/crossbow" | "farmersdelight:recipes/food/shepherds_pie_block" | "minecraft:recipes/building_blocks/mud_bricks" | "create:recipes/building_blocks/cut_granite_brick_wall" | "minecraft:recipes/food/cooked_porkchop_from_smoking" | "minecraft:recipes/building_blocks/cracked_deepslate_bricks" | "create:recipes/misc/crafting/kinetics/train_trapdoor" | "immersiveengineering:recipes/misc/smelting/ingot_lead_from_dust" | "minecraft:recipes/building_blocks/chiseled_nether_bricks" | "minecraft:recipes/building_blocks/warped_planks" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab" | "immersiveengineering:recipes/misc/crafting/ingot_uranium_to_storage_uranium" | "minecraft:recipes/decorations/warped_fence" | "copycats:recipes/misc/stonecutting/copycat_vertical_slice" | "minecraft:recipes/decorations/black_glazed_terracotta" | "refinedstorage:recipes/misc/crafting_grid/lime_crafting_grid" | "create:millstone" | "create:recipes/building_blocks/crafting/kinetics/green_seat" | "railways:recipes/combat/dying_existing_cap_yellow" | "create:recipes/building_blocks/cut_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "laserio:recipes/misc/card_item" | "exdeorum:recipes/misc/acacia_sieve" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs" | "farmersdelight:recipes/decorations/green_canvas_sign" | "laserio:recipes/misc/card_redstone" | "refinedstorage:security" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_plated_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_copper_wrapped_locometal_boiler" | "farmersdelight:recipes/cooking/beetroot_soup" | "minecraft:recipes/misc/gray_dye" | "create:train_whistle" | "create:recipes/building_blocks/cut_limestone_wall" | "minecraft:recipes/redstone/bamboo_button" | "create:recipes/misc/blasting/ingot_silver_compat_ic2" | "minecraft:recipes/decorations/light_gray_carpet" | "immersiveengineering:multiblocks/liquid_concrete" | "create:recipes/building_blocks/cut_diorite_slab_recycling" | "minecraft:recipes/decorations/barrel" | "immersiveengineering:recipes/misc/stonecutting/concrete_sheet" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_lime_to_slab" | "immersiveengineering:recipes/misc/crafting/conveyor_extract" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_yellow_from_slab" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_light_gray_from_slab" | "minecraft:recipes/misc/rib_armor_trim_smithing_template" | "create:recipes/building_blocks/polished_cut_diorite_stairs" | "laserio:recipes/misc/filter_count_nbtclear" | "minecraft:recipes/combat/leather_boots" | "minecraft:recipes/misc/red_dye_from_tulip" | "minecraft:husbandry/axolotl_in_a_bucket" | "minecraft:recipes/decorations/cobblestone_wall_from_cobblestone_stonecutting" | "immersiveengineering:recipes/misc/crafting/raw_lead_to_raw_block_lead" | "immersiveengineering:recipes/misc/crafting/clinker_brick_quoin" | "immersiveengineering:recipes/misc/crafting/treated_fence" | "minecraft:recipes/misc/orange_dye_from_orange_tulip" | "createsweetsandtreets:explosive_bakery" | "minecraft:recipes/decorations/grindstone" | "farmersdelight:recipes/food/sweet_berry_cookie" | "sophisticatedbackpacks:recipes/misc/anvil_upgrade" | "minecraft:recipes/building_blocks/diamond_block" | "copycats:recipes/crafting/copycat_vertical_slope_from_conversion" | "minecraft:recipes/decorations/yellow_carpet" | "minecraft:recipes/building_blocks/stripped_oak_wood" | "immersiveengineering:tools/craft_railgun" | "create:recipes/building_blocks/cut_calcite_wall" | "farmersdelight:main/craft_knife" | "minecraft:recipes/misc/andesite_from_compressed_andesite" | "refinedstorage:recipes/misc/coloring_recipes/blue_crafting_monitor" | "refinedstorage:recipes/misc/crafting_grid/orange_crafting_grid" | "minecraft:nether/ride_strider_in_overworld_lava" | "comforts:hammock_pink" | "create:recipes/building_blocks/polished_cut_andesite_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_locometal_smokebox" | "create:recipes/misc/smelting/ingot_nickel_compat_immersiveengineering" | "farmersdelight:recipes/decorations/cyan_canvas_sign" | "immersiveengineering:recipes/misc/crafting/sheetmetal_iron_from_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_slashed_locometal" | "refinedstorage:recipes/misc/coloring_recipes/brown_relay" | "refinedstorage:recipes/misc/crafting_grid/gray_crafting_grid" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_slashed_locometal" | "create:recipes/building_blocks/cut_dripstone_brick_slab_from_stone_types_dripstone_stonecutting" | "ironchest:recipes/decorations/chests/gold_diamond_chest" | "create:recipes/building_blocks/crafting/kinetics/purple_seat" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_copper_wrapped_locometal_boiler" | "minecraft:recipes/decorations/blue_banner" | "create:recipes/building_blocks/polished_cut_andesite_wall" | "portabletanks:recipes/misc/advanced_portable_tank" | "create:recipes/building_blocks/weathered_copper_tile_slab" | "ironchest:recipes/decorations/chests/diamond_crystal_chest" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_copper_wrapped_locometal" | "refinedstorage:recipes/misc/fluid_grid/green_fluid_grid" | "refinedstorage:recipes/misc/coloring_recipes/purple_disk_manipulator" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_locometal_smokebox" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_polished_deepslate_stonecutting" | "extradisks:recipes/misc/disk/shapeless/65536k_storage_disk" | "create:recipes/building_blocks/polished_cut_granite_slab" | "refinedstorage:recipes/misc/coloring_recipes/cyan_network_transmitter" | "portabletanks:recipes/misc/basic_portable_tank" | "minecraft:recipes/building_blocks/dark_prismarine_slab_from_dark_prismarine_stonecutting" | "minecraft:recipes/building_blocks/polished_andesite_stairs_from_andesite_stonecutting" | "minecraft:recipes/decorations/lime_banner" | "minecraft:recipes/decorations/white_bed" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_brass_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_iron_wrapped_locometal" | "peco:recipes/misc/slime_pulp" | "immersiveengineering:recipes/misc/crafting/toolupgrade_revolver_magazine" | "refinedstorage:recipes/misc/coloring_recipes/orange_relay" | "create:recipes/misc/crafting/kinetics/copper_valve_handle_from_others" | "minecraft:recipes/decorations/deepslate_brick_wall_from_polished_deepslate_stonecutting" | "immersiveengineering:recipes/misc/smelting/ingot_silver3" | "immersiveengineering:recipes/misc/smelting/ingot_silver2" | "minecraft:recipes/misc/lapis_lazuli_from_blasting_deepslate_lapis_ore" | "create:recipes/building_blocks/polished_cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/weathered_copper_tile_slab_from_weathered_copper_tiles_stonecutting" | "minecraft:recipes/decorations/nether_brick_wall" | "minecraft:recipes/misc/ward_armor_trim_smithing_template" | "create:recipes/misc/crafting/appliances/linked_controller" | "minecraft:recipes/misc/copper_ingot_from_smelting_deepslate_copper_ore" | "create:recipes/building_blocks/small_ochrum_brick_stairs" | "farmersdelight:recipes/food/potato_from_crate" | "immersiveengineering:recipes/misc/crafting/ingot_lead_to_nugget_lead" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_flat_slashed_locometal" | "create:recipes/building_blocks/cut_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "portabletanks:recipes/misc/ultimate_portable_tank" | "refinedstorage:recipes/misc/coloring_recipes/magenta_grid" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_slashed_locometal" | "minecraft:recipes/misc/firework_rocket_simple" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_brass_wrapped_locometal" | "minecraft:recipes/misc/gold_ingot_from_smelting_deepslate_gold_ore" | "minecraft:nether/summon_wither" | "create:recipes/building_blocks/small_scoria_brick_slab_recycling" | "create:compacting" | "extradisks:recipes/misc/disk/shaped/256k_storage_disk" | "create:recipes/building_blocks/cut_crimsite_brick_wall" | "create:recipes/misc/crafting/kinetics/nozzle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_locometal_pillar" | "minecraft:recipes/redstone/redstone_from_blasting_deepslate_redstone_ore" | "create:recipes/misc/crafting/kinetics/radial_chassis" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_riveted_locometal" | "create:recipes/building_blocks/polished_cut_ochrum_slab" | "immersiveengineering:recipes/misc/crafting/breaker_switch" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_iron_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/red_nether_brick_slab" | "minecraft:recipes/building_blocks/cobblestone_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_riveted_locometal" | "create:recipes/building_blocks/small_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "minecraft:recipes/misc/copper_ingot_from_blasting_copper_ore" | "minecraft:recipes/building_blocks/dye_green_carpet" | "minecraft:recipes/building_blocks/mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting" | "create:recipes/building_blocks/cut_ochrum_slab" | "refinedstorage:connecting" | "railways:recipes/misc/stonecutting/palettes/cycling/green_slashed_locometal" | "create:burner" | "minecraft:recipes/building_blocks/polished_diorite_slab_from_diorite_stonecutting" | "immersiveengineering:recipes/misc/crafting/connector_hv_relay" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_locometal_smokebox" | "minecraft:recipes/decorations/pink_banner" | "farmersdelight:recipes/food/pie_crust" | "farmersdelight:recipes/combat/iron_knife" | "create:recipes/misc/smelting/nickel_ingot_compat_thermal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_locometal_boiler" | "minecraft:recipes/building_blocks/prismarine_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_brass_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/waxed_exposed_copper_from_honeycomb" | "minecraft:recipes/misc/magenta_dye_from_blue_red_white_dye" | "immersiveengineering:recipes/misc/crafting/buzzsaw" | "minecraft:recipes/building_blocks/purple_concrete_powder" | "create:recipes/building_blocks/cut_granite_wall" | "minecraft:recipes/building_blocks/prismarine_slab" | "minecraft:recipes/decorations/orange_carpet" | "minecraft:recipes/misc/moss_block_from_compressed_moss_block" | "immersiveengineering:recipes/misc/crafting/hempcrete_brick_from_slab" | "minecraft:adventure/read_power_of_chiseled_bookshelf" | "exdeorum:recipes/misc/porcelain_clay_ball" | "refinedstorage:recipes/misc/crafting_grid/brown_crafting_grid" | "create:recipes/misc/crafting/kinetics/mechanical_piston" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_plated_locometal" | "minecraft:recipes/redstone/cherry_door" | "immersiveengineering:tools/upgrade_buzzsaw" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/cut_copper_stairs" | "immersiveengineering:recipes/misc/crafting/glider" | "exdeorum:recipes/misc/flint_mesh_from_string_mesh" | "minecraft:recipes/decorations/warped_hanging_sign" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_iron_wrapped_locometal_boiler" | "create:recipes/misc/crafting/kinetics/sticky_mechanical_piston" | "create:shifting_gears" | "refinedstorage:recipes/misc/coloring_recipes/crafting_grid" | "create:recipes/building_blocks/exposed_copper_shingle_slab_from_exposed_copper_shingles_stonecutting" | "create:recipes/misc/crafting/kinetics/encased_fan" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_locometal_boiler" | "create:recipes/building_blocks/cut_scoria_wall_from_stone_types_scoria_stonecutting" | "farmersdelight:recipes/decorations/rope" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_plated_locometal" | "immersiveengineering:recipes/misc/crafting/logic_unit" | "railways:recipes/misc/crafting/conductor_whistle" | "create:recipes/building_blocks/cut_dripstone_wall" | "create:recipes/misc/crafting/appliances/attribute_filter_clear" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_pink_from_slab" | "minecraft:recipes/combat/spectral_arrow" | "minecraft:recipes/decorations/white_stained_glass_pane" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_plated_locometal" | "immersiveengineering:recipes/misc/crafting/hempcrete_brick" | "immersiveengineering:recipes/misc/crafting/connector_structural" | "railways:recipes/misc/crafting/wooden_headstock_link_and_pin" | "immersiveengineering:recipes/misc/crafting/plate_gold_hammering" | "immersiveengineering:recipes/misc/crafting/fluid_placer" | "create:recipes/building_blocks/cut_diorite_from_stone_types_diorite_stonecutting" | "minecraft:recipes/decorations/ender_chest" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_iron_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/wrapping/blue_brass_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/sheetmetal_gold_to_slab" | "minecraft:recipes/decorations/dark_oak_sign" | "immersiveengineering:recipes/misc/stonecutting/slab_concrete_leaded" | "create:recipes/misc/crafting/materials/experience_block" | "exdeorum:recipes/building_blocks/compressed_crushed_netherrack" | "immersiveengineering:recipes/misc/stonecutting/stairs_concrete_brick" | "exdeorum:recipes/tools/netherite_hammer" | "create:recipes/building_blocks/veridium_pillar_from_stone_types_veridium_stonecutting" | "minecraft:story/mine_diamond" | "immersiveengineering:recipes/misc/crafting/empty_shell" | "minecraft:recipes/building_blocks/cut_copper_stairs_from_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/polished_granite_stairs_from_granite_stonecutting" | "exdeorum:core/root" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_locometal_pillar" | "create:track_crafting_factory" | "create:recipes/misc/crafting/kinetics/framed_glass_door" | "create:belt" | "create:recipes/building_blocks/polished_cut_dripstone_stairs" | "extradisks:recipes/misc/disk/shaped/1024k_storage_disk" | "minecraft:recipes/building_blocks/cyan_concrete_powder" | "mobdropsrecipes_overworld:recipes/misc/prismarine_crystals" | "copycats:recipes/misc/stonecutting/copycat_slice" | "immersiveengineering:recipes/misc/crafting/concrete_from_slab" | "create:recipes/misc/crafting/materials/electron_tube" | "exdeorum:recipes/misc/crushed_netherrack_from_compressed_crushed_netherrack" | "minecraft:recipes/misc/pink_dye_from_peony" | "extradisks:recipes/misc/part/infinite_storage_part" | "farmersdelight:recipes/food/cake_from_milk_bottle" | "create:recipes/misc/crafting/kinetics/goggles" | "sophisticatedbackpacks:recipes/misc/iron_backpack_from_copper" | "create:recipes/misc/crafting/materials/andesite_alloy_from_block" | "minecraft:recipes/misc/coal_from_smelting_coal_ore" | "create:recipes/misc/crafting/kinetics/copper_door" | "minecraft:nether/find_fortress" | "farmersdelight:recipes/building_blocks/organic_compost_from_tree_bark" | "create:recipes/building_blocks/cut_tuff_brick_slab_recycling" | "minecraft:recipes/building_blocks/polished_blackstone_bricks" | "create:recipes/building_blocks/polished_cut_dripstone_from_stone_types_dripstone_stonecutting" | "create:recipes/decorations/copper_bars_from_ingots_copper_stonecutting" | "mcwfurnitures:recipes/jungle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_slashed_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_plated_locometal" | "minecraft:recipes/decorations/red_sandstone_wall" | "immersiveengineering:recipes/misc/crafting/storage_steel_from_slab" | "farmersdelight:recipes/food/rice_from_bag" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_standard_to_slab" | "minecraft:recipes/misc/nether_brick" | "create:recipes/building_blocks/cut_scorchia_brick_wall" | "refinedstorage:monitoring" | "create:recipes/building_blocks/small_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "immersiveengineering:recipes/misc/crafting/concrete_brick_to_slab" | "create:recipes/building_blocks/cut_scorchia_stairs" | "railways:recipes/misc/crafting/handcar" | "immersiveengineering:recipes/misc/crafting/ingot_silver_to_storage_silver" | "minecraft:recipes/tools/stone_shovel" | "farmersdelight:recipes/food/onion" | "create:recipes/misc/smelting/ingot_silver_compat_immersiveengineering" | "refinedstorage:recipes/misc/fluid_grid/white_fluid_grid" | "create:lava_wheel_00000" | "create:recipes/misc/blasting/ingot_lead_compat_immersiveengineering" | "create:recipes/misc/crafting/kinetics/whisk" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_sword" | "minecraft:recipes/building_blocks/brown_terracotta" | "create:recipes/misc/crafting/kinetics/display_board" | "immersiveengineering:recipes/misc/crafting/cokebrick_to_slab" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_cyan_to_slab" | "create:recipes/building_blocks/jungle_window" | "railways:recipes/combat/dying_existing_cap_pink" | "immersiveengineering:recipes/misc/crafting/wirecoil_structure_steel" | "railways:recipes/misc/stonecutting/palettes/cycling/green_flat_slashed_locometal" | "minecraft:recipes/building_blocks/polished_deepslate_stairs" | "immersiveengineering:recipes/misc/crafting/ingot_electrum_to_storage_electrum" | "railways:recipes/misc/stonecutting/palettes/cycling/cyan_slashed_locometal" | "create:recipes/building_blocks/small_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "minecraft:recipes/decorations/shulker_box" | "minecraft:recipes/building_blocks/polished_basalt" | "minecraft:recipes/building_blocks/oak_wood" | "immersiveengineering:tools/secret_drillbreak" | "minecraft:recipes/building_blocks/smooth_quartz_stairs" | "minecraft:recipes/misc/slime_ball" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_locometal_boiler" | "refinedstorage:recipes/misc/coloring_recipes/pink_network_transmitter" | "minecraft:recipes/misc/raiser_armor_trim_smithing_template_smithing_trim" | "create:recipes/building_blocks/layered_andesite_from_stone_types_andesite_stonecutting" | "create:recipes/misc/smelting/ingot_aluminium_compat_ic2" | "copycats:recipes/misc/stonecutting/copycat_wall" | "refinedstorage:recipes/misc/coloring_recipes/black_crafting_grid" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_locometal_smokebox" | "farmersdelight:recipes/food/cooked_bacon" | "create:recipes/building_blocks/polished_cut_calcite_slab_recycling" | "minecraft:recipes/building_blocks/dye_green_wool" | "minecraft:recipes/decorations/cherry_hanging_sign" | "minecraft:recipes/building_blocks/jungle_slab" | "create:recipes/building_blocks/polished_cut_scorchia_slab_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/decorations/light_blue_candle" | "immersiveengineering:recipes/misc/crafting/conveyor_splitter_covered" | "create:recipes/misc/smelting/ingot_tin_compat_ic2" | "exdeorum:recipes/tools/compressed_netherite_hammer" | "create:recipes/building_blocks/framed_glass_pane" | "create:recipes/building_blocks/polished_cut_asurine_slab_recycling" | "create:recipes/building_blocks/polished_cut_scoria_wall" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_white" | "minecraft:recipes/building_blocks/mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/green_security_manager" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_riveted_locometal" | "minecraft:recipes/food/cooked_beef" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal_boiler" | "refinedstorage:recipes/misc/coloring_recipes/white_security_manager" | "farmersdelight:recipes/food/cooked_chicken_cuts_from_smoking" | "minecraft:recipes/transportation/powered_rail" | "extradisks:recipes/misc/blocks/1048576k_storage_block" | "minecraft:recipes/decorations/red_bed" | "minecraft:recipes/misc/iron_ingot_from_nuggets" | "refinedstorage:recipes/misc/coloring_recipes/crafter_manager" | "copycats:recipes/misc/stonecutting/copycat_stone_button" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_locometal_smokebox" | "minecraft:recipes/transportation/jungle_boat" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_iron_wrapped_locometal_boiler" | "create:recipes/misc/crafting/kinetics/piston_extension_pole" | "extrastorage:advanced_importer" | "immersiveengineering:recipes/misc/crafting/dynamo" | "extradisks:recipes/misc/disk/shaped/1048576k_storage_disk" | "minecraft:recipes/redstone/heavy_weighted_pressure_plate" | "minecraft:recipes/misc/cobblestone_from_compressed_cobblestone" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab_from_cut_red_sandstone_stonecutting" | "farmersdelight:main/harvest_ropelogged_tomato" | "refinedstorage:recipes/misc/coloring_recipes/lime_pattern_grid" | "minecraft:story/enter_the_end" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_pink" | "extrastorage:recipes/misc/disk/shapeless/disk_16384k_fluid" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_iron_wrapped_locometal" | "minecraft:recipes/transportation/warped_fungus_on_a_stick" | "comforts:hammock_orange" | "minecraft:recipes/building_blocks/stripped_jungle_wood" | "create:recipes/building_blocks/polished_cut_calcite_from_stone_types_calcite_stonecutting" | "minecraft:recipes/building_blocks/stone_stairs" | "create:recipes/building_blocks/oak_window_pane" | "create:recipes/misc/smelting/iron_ingot_from_crushed" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_slashed_locometal" | "minecraft:recipes/building_blocks/purpur_slab_from_purpur_block_stonecutting" | "create:recipes/building_blocks/spruce_window_pane" | "minecraft:recipes/transportation/rail" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_deepslate_bricks_stonecutting" | "create:recipes/building_blocks/small_diorite_brick_slab" | "immersiveengineering:recipes/misc/crafting/ingot_lead_to_storage_lead" | "extradisks:recipes/misc/part/16384k_storage_part" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_black_to_slab" | "cabletiers:mega_destructor" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_iron_wrapped_locometal_boiler" | "farmersdelight:recipes/decorations/full_tatami_mat" | "create:recipes/misc/blasting/ingot_aluminium_compat_ic2" | "farmersdelight:recipes/food/horse_feed" | "minecraft:recipes/building_blocks/bone_block" | "extradisks:recipes/misc/disk/shaped/1048576k_fluid_storage_disk" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_flat_riveted_locometal" | "sophisticatedbackpacks:recipes/misc/advanced_restock_upgrade" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_honeycomb" | "minecraft:recipes/redstone/lever" | "create:recipes/decorations/andesite_scaffolding_from_andesite_alloy_stonecutting" | "farmersdelight:recipes/cooking/dog_food" | "immersiveengineering:main/chorus_cloche" | "minecraft:nether/obtain_crying_obsidian" | "exdeorum:recipes/misc/string_mesh" | "minecraft:recipes/misc/magenta_dye_from_lilac" | "farmersdelight:recipes/food/fried_egg_from_smoking" | "create:recipes/misc/crafting/materials/zinc_ingot_from_decompacting" | "farmersdelight:recipes/food/nether_salad" | "railways:recipes/misc/crafting/palettes/wrapping/light_blue_brass_wrapped_locometal" | "immersiveengineering:recipes/misc/stonecutting/stairs_concrete" | "immersiveengineering:recipes/misc/crafting/blueprint_molds" | "create:recipes/building_blocks/polished_cut_limestone_wall_from_stone_types_limestone_stonecutting" | "minecraft:recipes/misc/pink_dye_from_pink_petals" | "farmersdelight:recipes/decorations/half_tatami_mat" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_flat_slashed_locometal" | "farmersdelight:main/place_cooking_pot" | "minecraft:husbandry/froglights" | "create:recipes/building_blocks/small_scorchia_bricks_from_stone_types_scorchia_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_locometal_pillar" | "minecraft:recipes/misc/melon_seeds" | "minecraft:recipes/building_blocks/magma_block" | "create:recipes/building_blocks/cut_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "farmersdelight:recipes/combat/diamond_knife" | "easy_mob_farm:recipes/upgrade/filter/no_flowers_filter" | "immersiveengineering:recipes/misc/stonecutting/stairs_slag_brick" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum_from_blasting2" | "sophisticatedbackpacks:recipes/misc/smoking_upgrade" | "farmersdelight:recipes/misc/iron_nugget_from_blasting_knife" | "minecraft:recipes/building_blocks/smooth_red_sandstone_stairs_from_smooth_red_sandstone_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/black_relay" | "create:recipes/building_blocks/cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_riveted_locometal" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum_from_blasting3" | "sophisticatedbackpacks:recipes/misc/advanced_void_upgrade" | "immersiveengineering:recipes/misc/stonecutting/slag_brick" | "railways:recipes/misc/crafting/portable_fuel_interface" | "immersiveengineering:recipes/misc/crafting/chute_copper" | "minecraft:recipes/building_blocks/lime_terracotta" | "create:recipes/building_blocks/small_tuff_brick_stairs_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/smooth_quartz_slab_from_smooth_quartz_stonecutting" | "create:recipes/building_blocks/cut_scoria_brick_slab_recycling" | "minecraft:recipes/food/cake" | "minecraft:recipes/combat/iron_leggings" | "minecraft:recipes/building_blocks/light_gray_terracotta" | "create:recipes/misc/crafting/kinetics/mechanical_crafter" | "create:ejector_maxed" | "create:recipes/building_blocks/cut_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "create:recipes/building_blocks/cut_limestone_bricks_from_stone_types_limestone_stonecutting" | "minecraft:recipes/decorations/gray_bed" | "refinedstorage:recipes/misc/coloring_recipes/yellow_controller" | "create:recipes/misc/crafting/materials/brass_ingot_from_decompacting" | "immersiveengineering:recipes/misc/crafting/razor_wire" | "minecraft:recipes/misc/emerald_from_smelting_emerald_ore" | "minecraft:recipes/building_blocks/coarse_dirt" | "farmersdelight:recipes/food/smoked_ham" | "comforts:sleeping_bag_pink" | "farmersdelight:recipes/food/milk_bottle" | "create:recipes/misc/crafting/kinetics/speedometer" | "farmersdelight:recipes/food/bread_from_smelting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_waxed_weathered_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/light_gray_concrete_powder" | "immersiveengineering:recipes/misc/crafting/plate_iron_hammering" | "create:recipes/building_blocks/small_diorite_brick_wall" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_flat_riveted_locometal" | "immersiveengineering:recipes/misc/crafting/ingot_aluminum_to_storage_aluminum" | "minecraft:recipes/building_blocks/end_stone_brick_stairs_from_end_stone_brick_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_flat_riveted_locometal" | "comforts:hammock_magenta" | "minecraft:recipes/combat/leather_leggings" | "copycats:recipes/crafting/copycat_vertical_step_from_conversion" | "create:recipes/building_blocks/cut_veridium_bricks_from_stone_types_veridium_stonecutting" | "minecraft:recipes/building_blocks/pink_concrete_powder" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_riveted_locometal" | "minecraft:recipes/building_blocks/sandstone_slab" | "immersiveengineering:recipes/misc/crafting/gunpowder_from_dusts" | "farmersdelight:recipes/building_blocks/straw_bale" | "immersiveengineering:recipes/misc/crafting/floodlight" | "immersiveengineering:recipes/misc/crafting/conveyor_vertical" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_copper_wrapped_locometal_boiler" | "immersiveengineering:recipes/misc/smelting/ingot_nickel_from_dust" | "minecraft:recipes/redstone/crimson_button" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_slashed_locometal" | "minecraft:story/obtain_armor" | "create:recipes/building_blocks/polished_cut_veridium_wall_from_stone_types_veridium_stonecutting" | "immersiveengineering:recipes/misc/crafting/shovel_steel" | "create:recipes/building_blocks/polished_cut_andesite_stairs" | "create:diving_suit" | "refinedstorage:recipes/misc/coloring_recipes/lime_crafting_grid" | "extradisks:recipes/misc/disk/shapeless/infinite_fluid_storage_disk" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_copper_wrapped_locometal_boiler" | "exdeorum:recipes/misc/porcelain_crucible" | "minecraft:recipes/combat/diamond_leggings" | "minecraft:recipes/decorations/gray_stained_glass_pane" | "railways:recipes/misc/stonecutting/palettes/cycling/black_slashed_locometal" | "create:recipes/building_blocks/small_diorite_bricks_from_stone_types_diorite_stonecutting" | "minecraft:recipes/food/dried_kelp_from_smelting" | "easy_mob_farm:recipes/mob_farm/nether_fortress_farm" | "create:recipes/misc/smelting/gold_ingot_from_crushed" | "create:hose_pulley_lava" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_brass_wrapped_locometal_boiler" | "farmersdelight:recipes/cooking/fish_stew" | "create:recipes/building_blocks/layered_diorite_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_locometal_pillar" | "minecraft:recipes/building_blocks/cherry_slab" | "refinedstorage:recipes/misc/coloring_recipes/brown_disk_manipulator" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_waxed_weathered_copper_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/brown_fluid_grid" | "create:recipes/building_blocks/small_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "sophisticatedbackpacks:recipes/misc/everlasting_upgrade" | "minecraft:end/kill_dragon" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_plated_locometal" | "create:recipes/building_blocks/polished_cut_deepslate_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_brass_wrapped_locometal_boiler" | "create:recipes/misc/smelting/scoria" | "railways:recipes/misc/crafting/fuel_tank" | "minecraft:recipes/decorations/orange_candle" | "create:recipes/building_blocks/asurine_pillar_from_stone_types_asurine_stonecutting" | "exdeorum:recipes/misc/bamboo_crucible" | "refinedstorage:recipes/misc/coloring_recipes/white_wireless_transmitter" | "minecraft:recipes/decorations/stone_brick_wall" | "farmersdelight:main/place_skillet" | "create:encased_fan" | "create:recipes/building_blocks/cut_diorite_wall_from_stone_types_diorite_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/green_network_transmitter" | "exdeorum:recipes/misc/ores/platinum_tag" | "minecraft:recipes/redstone/dark_oak_fence_gate" | "minecraft:recipes/building_blocks/waxed_weathered_copper_from_honeycomb" | "minecraft:recipes/misc/iron_nugget_from_smelting" | "minecraft:recipes/decorations/prismarine_wall_from_prismarine_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/red_detector" | "minecraft:recipes/building_blocks/dye_light_gray_bed" | "refinedstorage:recipes/misc/coloring_recipes/blue_disk_manipulator" | "immersiveengineering:recipes/misc/crafting/constantan_mix" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_plated_locometal" | "create:recipes/building_blocks/copper_shingle_slab" | "create:recipes/misc/crafting/kinetics/cuckoo_clock" | "immersiveengineering:recipes/misc/crafting/wire_copper" | "immersiveengineering:recipes/misc/crafting/nugget_uranium_to_ingot_uranium" | "refinedstorage:recipes/misc/coloring_recipes/cyan_disk_manipulator" | "minecraft:recipes/misc/copper_ingot_from_smelting_copper_ore" | "immersiveengineering:recipes/misc/crafting/empty_casing" | "farmersdelight:recipes/misc/milk_bucket_from_bottles" | "minecraft:recipes/misc/blue_dye" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_ochrum_wall_from_stone_types_ochrum_stonecutting" | "immersiveengineering:recipes/misc/crafting/maintenance_kit" | "minecraft:recipes/food/baked_potato_from_campfire_cooking" | "create:recipes/building_blocks/cut_deepslate_stairs" | "create:recipes/misc/crafting/kinetics/analog_lever" | "copycats:recipes/misc/stonecutting/copycat_wooden_button" | "create:recipes/building_blocks/crafting/kinetics/blue_seat_from_other_seat" | "minecraft:recipes/misc/cyan_dye" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_red_from_slab" | "immersiveengineering:recipes/misc/stonecutting/hempcrete_pillar" | "create:recipes/building_blocks/limestone_from_stone_types_limestone_stonecutting" | "minecraft:husbandry/make_a_sign_glow" | "create:andesite_alloy" | "exdeorum:recipes/misc/spruce_barrel" | "minecraft:recipes/building_blocks/dye_lime_wool" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_tiles_from_honeycomb" | "create:recipes/misc/blasting/silver_ingot_compat_thermal" | "minecraft:recipes/redstone/acacia_pressure_plate" | "create:water_wheel" | "easy_mob_farm:root" | "minecraft:nether/create_beacon" | "minecraft:recipes/building_blocks/crimson_slab" | "create:recipes/building_blocks/vertical_framed_glass_from_glass_colorless_stonecutting" | "minecraft:recipes/building_blocks/crimson_stairs" | "copycats:recipes/crafting/copycat_catwalk" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_slashed_locometal" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_network_receiver" | "minecraft:recipes/building_blocks/green_stained_glass" | "refinedstorage:recipes/misc/coloring_recipes/white_network_receiver" | "minecraft:recipes/building_blocks/bamboo_mosaic_slab" | "minecraft:recipes/decorations/yellow_glazed_terracotta" | "immersiveengineering:recipes/misc/crafting/slag_brick" | "create:recipes/building_blocks/small_granite_brick_slab_recycling" | "copycats:recipes/misc/stonecutting/copycat_door" | "railways:recipes/misc/stonecutting/palettes/cycling/white_riveted_locometal" | "create:recipes/building_blocks/small_diorite_brick_wall_from_stone_types_diorite_stonecutting" | "create:recipes/misc/crafting/logistics/redstone_link" | "minecraft:recipes/building_blocks/bookshelf" | "refinedstorage:recipes/misc/coloring_recipes/black_security_manager" | "sophisticatedbackpacks:recipes/misc/auto_smelting_upgrade" | "refinedstorage:recipes/misc/coloring_recipes/purple_crafter" | "create:recipes/misc/crafting/kinetics/cart_assembler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_locometal_pillar" | "immersiveengineering:recipes/misc/stonecutting/slab_clinker_brick" | "create:recipes/building_blocks/small_tuff_bricks_from_stone_types_tuff_stonecutting" | "minecraft:story/iron_tools" | "create:recipes/building_blocks/exposed_copper_shingle_stairs_from_exposed_copper_shingles_stonecutting" | "create:recipes/misc/smelting/glass_pane_from_vertical_framed_glass_pane" | "create:recipes/misc/crafting/kinetics/controller_rail" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_blackstone_stonecutting" | "minecraft:recipes/combat/iron_chestplate" | "create:recipes/building_blocks/small_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "minecraft:recipes/redstone/dark_oak_trapdoor" | "immersiveengineering:recipes/misc/crafting/toolupgrade_chemthrower_focus" | "minecraft:recipes/redstone/oak_trapdoor" | "create:recipes/building_blocks/tiled_glass_pane" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_helmet" | "create:recipes/building_blocks/limestone_pillar_from_stone_types_limestone_stonecutting" | "sophisticatedbackpacks:recipes/misc/chipped/mason_table_upgrade" | "create:honey_drain" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_flat_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_iron_wrapped_locometal_boiler" | "mcwfurnitures:recipes/crimson" | "immersiveengineering:recipes/misc/crafting/connector_probe" | "refinedstorage:recipes/misc/coloring_recipes/network_transmitter" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_plated_locometal" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/misc/book" | "minecraft:recipes/building_blocks/purpur_slab" | "refinedstorage:recipes/misc/coloring_recipes/pink_crafting_monitor" | "create:recipes/building_blocks/small_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/brown_seat" | "immersiveengineering:recipes/misc/crafting/storage_aluminum_to_ingot_aluminum" | "minecraft:recipes/combat/stone_sword" | "extrastorage:recipes/misc/storage_block/block_65536k_fluid" | "farmersdelight:recipes/decorations/blue_canvas_sign" | "minecraft:recipes/decorations/cobblestone_wall" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_brass_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/nugget_electrum_to_ingot_electrum" | "minecraft:recipes/misc/dune_armor_trim_smithing_template_smithing_trim" | "immersiveengineering:recipes/misc/crafting/sheetmetal_uranium_to_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_locometal_smokebox" | "create:recipes/misc/smelting/ingot_lead_compat_mekanism" | "minecraft:recipes/building_blocks/brown_stained_glass" | "copycats:recipes/misc/crafting/copycat_iron_door" | "create:recipes/building_blocks/cut_asurine_from_stone_types_asurine_stonecutting" | "minecraft:recipes/decorations/brown_carpet" | "refinedstorage:recipes/misc/coloring_recipes/cyan_controller" | "immersiveengineering:recipes/misc/crafting/wirecoil_structure_rope" | "minecraft:recipes/decorations/red_stained_glass_pane" | "minecraft:recipes/food/dried_kelp_from_campfire_cooking" | "minecraft:recipes/combat/netherite_sword_smithing" | "more_immersive_wires:recipes/rs_relay" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_copper_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/armor_steel_boots" | "create:pulley_maxed" | "vegandelight:tutorial/cooked_smoked_tofu_slices" | "railways:recipes/misc/crafting/palettes/wrapping/red_brass_wrapped_locometal" | "create:recipes/building_blocks/veridium_from_stone_types_veridium_stonecutting" | "immersiveengineering:recipes/misc/crafting/stairs_steel_scaffolding_standard" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_copper_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/pickaxe_steel" | "immersiveengineering:main/connect_wire" | "minecraft:recipes/misc/diamond" | "immersiveengineering:recipes/misc/crafting/gunpowder_barrel" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_copper_wrapped_locometal" | "minecraft:recipes/misc/gold_nugget_from_smelting" | "minecraft:recipes/food/cooked_chicken" | "create:recipes/building_blocks/small_veridium_bricks_from_stone_types_veridium_stonecutting" | "minecraft:recipes/misc/netherite_upgrade_smithing_template" | "minecraft:recipes/tools/stone_axe" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_green_from_slab" | "mobdropsrecipes_overworld:recipes/misc/essence_into_spider_eye" | "create:chocolate_bucket" | "create:recipes/building_blocks/asurine_from_stone_types_asurine_stonecutting" | "comforts:sleeping_bag_light_gray" | "create:recipes/building_blocks/cut_deepslate_wall" | "create:recipes/building_blocks/small_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "minecraft:recipes/decorations/blue_candle" | "farmersdelight:recipes/food/wheat_dough_from_eggs" | "create:recipes/misc/blasting/zinc_ingot_from_raw_ore" | "refinedstorage:recipes/misc/coloring_recipes/magenta_crafter_manager" | "create:recipes/misc/crafting/kinetics/mysterious_cuckoo_clock" | "minecraft:nether/ride_strider" | "exdeorum:recipes/misc/crushed_end_stone_from_compressed_crushed_end_stone" | "create:recipes/building_blocks/cut_granite_brick_wall_from_stone_types_granite_stonecutting" | "create:recipes/building_blocks/cut_asurine_stairs_from_stone_types_asurine_stonecutting" | "immersiveengineering:recipes/misc/crafting/storage_uranium_to_slab" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_relay" | "extradisks:recipes/misc/blocks/16384k_fluid_storage_block" | "create:recipes/building_blocks/small_andesite_brick_stairs" | "sophisticatedbackpacks:recipes/misc/chipped/carpenters_table_upgrade" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_honeycomb" | "minecraft:recipes/misc/iron_nugget" | "immersiveengineering:recipes/misc/crafting/sheetmetal_steel" | "minecraft:recipes/building_blocks/brown_concrete_powder" | "create:recipes/building_blocks/cut_calcite_slab_from_stone_types_calcite_stonecutting" | "minecraft:end/levitate" | "create:recipes/misc/blasting/tin_ingot_compat_thermal" | "immersiveengineering:recipes/misc/crafting/treated_wallmount" | "refinedstorage:recipes/misc/coloring_recipes/yellow_wireless_transmitter" | "immersiveengineering:recipes/misc/crafting/toolupgrade_railgun_scope" | "exdeorum:recipes/misc/golden_mesh_from_iron_mesh" | "exdeorum:recipes/misc/warped_barrel" | "minecraft:recipes/building_blocks/blue_stained_glass" | "create:self_deploying" | "immersiveengineering:recipes/misc/crafting/cokebrick" | "mobdropsrecipes_overworld:recipes/misc/essence_into_slime_ball" | "minecraft:recipes/building_blocks/cracked_stone_bricks" | "immersiveengineering:recipes/misc/crafting/metal_ladder_none" | "extradisks:recipes/misc/disk/shaped/262144k_fluid_storage_disk" | "exmachinis:recipes/misc/netherite_upgrade" | "farmersdelight:recipes/decorations/cyan_hanging_canvas_sign" | "exdeorum:recipes/misc/dust_from_compressed_dust" | "immersiveengineering:recipes/misc/crafting/stairs_treated_wood_horizontal" | "immersiveengineering:main/mb_cokeoven" | "farmersdelight:recipes/combat/flint_knife" | "farmersdelight:main/plant_rice" | "minecraft:recipes/building_blocks/cut_copper_slab_from_cut_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_flat_riveted_locometal" | "refinedstorage:recipes/misc/coloring_recipes/brown_pattern_grid" | "minecraft:recipes/misc/iron_ingot_from_blasting_iron_ore" | "exdeorum:recipes/misc/jungle_sieve" | "minecraft:recipes/misc/bucket" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_copper_wrapped_locometal" | "create:recipes/building_blocks/small_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "minecraft:adventure/bullseye" | "create:recipes/building_blocks/cut_dripstone_brick_wall" | "minecraft:recipes/building_blocks/diorite_slab" | "minecraft:recipes/building_blocks/stone_brick_stairs_from_stone_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_veridium_slab_from_stone_types_veridium_stonecutting" | "farmersdelight:recipes/decorations/black_canvas_sign" | "minecraft:recipes/decorations/orange_stained_glass_pane" | "refinedstorage:recipes/misc/coloring_recipes/magenta_fluid_grid" | "create:recipes/building_blocks/small_scoria_brick_stairs_from_stone_types_scoria_stonecutting" | "enchantinginfuser:recipes/decorations/advanced_enchanting_infuser" | "create:recipes/misc/crafting/kinetics/track_station" | "minecraft:recipes/building_blocks/light_blue_concrete_powder" | "create:recipes/building_blocks/cut_diorite_wall" | "extrastorage:recipes/misc/part/storagepart_1048576k_fluid" | "create:recipes/misc/crafting/kinetics/mechanical_roller" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_locometal_smokebox" | "immersiveengineering:multiblocks/mb_squeezer" | "minecraft:recipes/building_blocks/glass" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_brass_wrapped_locometal_boiler" | "minecraft:recipes/combat/bow" | "refinedstorage:recipes/misc/coloring_recipes/brown_wireless_transmitter" | "exdeorum:recipes/tools/diamond_hammer" | "immersiveengineering:main/villager" | "minecraft:recipes/building_blocks/acacia_slab" | "minecraft:recipes/building_blocks/smooth_sandstone" | "minecraft:recipes/building_blocks/oxidized_cut_copper" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_locometal_boiler" | "create:recipes/building_blocks/cut_diorite_bricks_from_stone_types_diorite_stonecutting" | "farmersdelight:recipes/building_blocks/tatami" | "immersiveengineering:recipes/misc/smelting/ingot_uranium3" | "immersiveengineering:recipes/misc/smelting/ingot_uranium2" | "immersiveengineering:recipes/misc/crafting/concrete_brick_from_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_flat_slashed_locometal" | "farmersdelight:recipes/decorations/safety_net" | "minecraft:recipes/transportation/minecart" | "minecraft:recipes/decorations/orange_glazed_terracotta" | "farmersdelight:recipes/food/cooked_salmon_slice_from_smoking" | "exdeorum:recipes/misc/ores/uranium_tag" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_plated_locometal" | "create:andesite_casing" | "create:recipes/building_blocks/crafting/kinetics/gray_seat" | "create:recipes/misc/crafting/materials/copper_nugget" | "minecraft:recipes/decorations/green_stained_glass_pane" | "minecraft:recipes/tools/iron_hoe" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_polished_deepslate_stonecutting" | "extrastorage:recipes/misc/netherite_crafter" | "immersiveengineering:recipes/misc/crafting/sheetmetal_silver" | "farmersdelight:recipes/misc/iron_nugget_from_smelting_knife" | "refinedstorage:recipes/misc/coloring_recipes/red_crafting_grid" | "refinedstorage:upgrading_your_grid" | "railways:recipes/misc/stonecutting/palettes/cycling/black_flat_slashed_locometal" | "minecraft:recipes/misc/bowl" | "create:recipes/building_blocks/polished_cut_granite_stairs_from_stone_types_granite_stonecutting" | "farmersdelight:recipes/decorations/magenta_hanging_canvas_sign" | "create:steam_engine_maxed" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_riveted_locometal" | "minecraft:recipes/building_blocks/dye_orange_carpet" | "create:recipes/building_blocks/crafting/kinetics/white_seat_from_other_seat" | "farmersdelight:recipes/food/cooked_mutton_chops" | "farmersdelight:recipes/food/honey_cookie" | "minecraft:recipes/tools/clock" | "refinedstorage:recipes/misc/coloring_recipes/blue_controller" | "minecraft:story/enter_the_nether" | "immersiveengineering:main/craft_pump" | "minecraft:recipes/decorations/red_glazed_terracotta" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_crimsite_brick_slab_from_stone_types_crimsite_stonecutting" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_standard_from_wooden_top" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_iron_wrapped_locometal" | "minecraft:adventure/whos_the_pillager_now" | "extradisks:recipes/misc/disk/shaped/16384k_fluid_storage_disk" | "create:recipes/building_blocks/small_asurine_bricks_from_stone_types_asurine_stonecutting" | "immersiveengineering:recipes/misc/crafting/conveyor_dropper_covered" | "create:recipes/building_blocks/cut_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "minecraft:recipes/food/baked_potato" | "create:recipes/misc/crafting/kinetics/filter" | "create:recipes/building_blocks/cut_andesite_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_locometal_pillar" | "refinedstorage:recipes/misc/coloring_recipes/purple_relay" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_plated_locometal" | "create:recipes/building_blocks/cut_limestone_brick_stairs" | "immersiveengineering:recipes/misc/crafting/strip_mv" | "create:recipes/misc/crafting/kinetics/white_sail" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_riveted_locometal" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingle_slab_from_honeycomb" | "create:recipes/misc/crafting/tree_fertilizer" | "minecraft:recipes/decorations/green_banner" | "create:recipes/misc/smelting/silver_ingot_compat_oreganized" | "minecraft:recipes/misc/gold_ingot_from_nuggets" | "refinedstorage:recipes/misc/coloring_recipes/gray_disk_manipulator" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_flat_slashed_locometal" | "comforts:hammock_gray" | "immersiveengineering:recipes/misc/stonecutting/hempcrete_brick" | "create:recipes/building_blocks/cut_scorchia_bricks_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/misc/pink_dye_from_pink_tulip" | "minecraft:recipes/building_blocks/mangrove_stairs" | "sophisticatedbackpacks:recipes/misc/auto_smoking_upgrade" | "immersiveengineering:recipes/misc/crafting/strip_lv" | "cabletiers:ultra_exporter" | "create:recipes/building_blocks/polished_cut_crimsite_from_stone_types_crimsite_stonecutting" | "immersiveengineering:recipes/misc/crafting/concrete_brick" | "create:recipes/building_blocks/cut_deepslate_brick_wall" | "minecraft:recipes/decorations/spruce_sign" | "minecraft:recipes/misc/wayfinder_armor_trim_smithing_template" | "create:recipes/building_blocks/layered_granite_from_stone_types_granite_stonecutting" | "sophisticatedbackpacks:recipes/misc/diamond_backpack" | "create:recipes/building_blocks/cut_calcite_brick_wall" | "extradisks:recipes/misc/blocks/256k_storage_block" | "railways:recipes/misc/crafting/track_coupler" | "refinedstorage:recipes/misc/coloring_recipes/white_crafter_manager" | "railways:recipes/misc/stonecutting/palettes/cycling/green_locometal_pillar" | "create:anvil_plough" | "minecraft:recipes/building_blocks/bricks" | "minecraft:recipes/combat/netherite_leggings_smithing" | "farmersdelight:recipes/cooking/noodle_soup" | "mcwfurnitures:recipes/dark_oak" | "minecraft:recipes/decorations/painting" | "create:stressometer" | "immersiveengineering:recipes/misc/crafting/stick_steel" | "minecraft:recipes/building_blocks/waxed_cut_copper" | "farmersdelight:main/hit_raider_with_rotten_tomato" | "minecraft:recipes/building_blocks/red_terracotta" | "exdeorum:recipes/misc/jungle_barrel" | "minecraft:recipes/combat/arrow" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_locometal_pillar" | "refinedstorage:recipes/misc/crafting_grid/yellow_crafting_grid" | "create:recipes/building_blocks/small_diorite_brick_slab_recycling" | "sophisticatedbackpacks:recipes/misc/chipped/alchemy_bench_upgrade" | "railways:recipes/misc/crafting/palettes/wrapping/cyan_brass_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/wirecoil_electrum" | "create:recipes/building_blocks/crafting/kinetics/red_seat" | "create:recipes/building_blocks/polished_cut_veridium_slab_recycling" | "farmersdelight:recipes/decorations/dark_oak_cabinet" | "minecraft:recipes/building_blocks/polished_deepslate_stairs_from_polished_deepslate_stonecutting" | "minecraft:recipes/misc/vex_armor_trim_smithing_template_smithing_trim" | "immersiveengineering:recipes/misc/crafting/concrete_tile_to_slab" | "immersiveengineering:recipes/misc/crafting/drillhead_iron" | "immersiveengineering:multiblocks/mb_refinery" | "createsweetsandtreets:taste_the_rainbow" | "minecraft:recipes/combat/golden_helmet" | "refinedstorage:recipes/misc/coloring_recipes/cyan_crafter_manager" | "immersiveengineering:recipes/misc/crafting/hempcrete_to_slab" | "minecraft:recipes/redstone/acacia_trapdoor" | "create:recipes/misc/smelting/glass_pane_from_framed_glass_pane" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_from_waxed_exposed_copper_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/light_gray_seat" | "immersiveengineering:recipes/misc/crafting/lantern" | "exdeorum:recipes/misc/crimson_crucible" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tiles_from_honeycomb" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_axe" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_locometal_pillar" | "vegandelight:tutorial/tofu_slices" | "create:recipes/building_blocks/cut_ochrum_stairs" | "minecraft:recipes/building_blocks/brick_slab_from_bricks_stonecutting" | "create:recipes/building_blocks/polished_cut_andesite_slab" | "create:train" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_flat_riveted_locometal" | "immersiveengineering:recipes/misc/crafting/sheetmetal_lead" | "laserio:recipes/misc/filter_count" | "minecraft:recipes/food/cooked_salmon" | "minecraft:recipes/building_blocks/cherry_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_riveted_locometal" | "create:recipes/building_blocks/small_andesite_brick_wall" | "create:recipes/building_blocks/small_tuff_brick_stairs" | "immersiveengineering:recipes/misc/crafting/rockcutter" | "immersiveengineering:recipes/misc/crafting/ingot_constantan_to_nugget_constantan" | "immersiveengineering:recipes/misc/crafting/concrete_leaded_from_slab" | "easy_mob_farm:recipes/mob_farm_template/tier1_mob_farm_template" | "minecraft:recipes/misc/blackstone_from_compressed_blackstone" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_red_to_slab" | "immersiveengineering:recipes/misc/crafting/sheetmetal_electrum" | "peco:recipes/decorations/cobweb" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_copper_wrapped_locometal_boiler" | "mobdropsrecipes_overworld:recipes/misc/essence_into_totem_of_undying" | "immersiveengineering:recipes/misc/crafting/stairs_concrete_tile" | "refinedstorage:managing_patterns" | "create:recipes/building_blocks/cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_slashed_locometal" | "minecraft:recipes/decorations/composter" | "create:recipes/building_blocks/cut_ochrum_brick_slab" | "minecraft:recipes/building_blocks/red_nether_brick_stairs_from_red_nether_bricks_stonecutting" | "exdeorum:recipes/misc/basalt" | "create:recipes/building_blocks/crafting/kinetics/orange_seat" | "create:recipes/building_blocks/dripstone_block_from_stone_types_dripstone_stonecutting" | "create:recipes/building_blocks/cut_scorchia_slab" | "create:recipes/building_blocks/weathered_copper_tile_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_locometal_pillar" | "create:recipes/building_blocks/cut_calcite_brick_stairs" | "immersiveengineering:recipes/misc/crafting/sheetmetal_gold_from_slab" | "minecraft:recipes/building_blocks/end_stone_bricks" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_riveted_locometal" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_starter_tier" | "immersiveengineering:recipes/misc/crafting/concrete_to_slab" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_shingles_from_honeycomb" | "minecraft:recipes/decorations/glow_item_frame" | "railways:recipes/misc/crafting/palettes/wrapping/light_gray_copper_wrapped_locometal" | "minecraft:husbandry/silk_touch_nest" | "minecraft:recipes/building_blocks/dark_prismarine_stairs" | "minecraft:recipes/building_blocks/dye_cyan_wool" | "minecraft:recipes/decorations/andesite_wall_from_andesite_stonecutting" | "exmachinis:root" | "minecraft:recipes/building_blocks/waxed_cut_copper_from_honeycomb" | "minecraft:recipes/building_blocks/nether_brick_stairs" | "create:train_roadkill" | "sophisticatedbackpacks:recipes/misc/chipped/glassblower_upgrade" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_leggings" | "exmachinis:gold_upgrade" | "create:recipes/building_blocks/cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "comforts:sleeping_bag_magenta" | "immersiveengineering:recipes/misc/stonecutting/concrete_chiseled2" | "create:recipes/misc/crafting/kinetics/black_valve_handle_from_other_valve_handle" | "farmersdelight:recipes/cooking/vegetable_noodles" | "minecraft:recipes/building_blocks/smooth_red_sandstone_slab" | "minecraft:recipes/misc/diorite_from_compressed_diorite" | "refinedstorage:recipes/misc/coloring_recipes/purple_grid" | "create:recipes/building_blocks/oxidized_copper_tile_stairs_from_oxidized_copper_tiles_stonecutting" | "minecraft:story/smelt_iron" | "create:brass_casing" | "minecraft:recipes/misc/orange_dye_from_torchflower" | "create:recipes/misc/smelting/ingot_tin_compat_mekanism" | "immersiveengineering:recipes/misc/crafting/toolupgrade_shield_shock" | "minecraft:recipes/tools/fishing_rod" | "minecraft:recipes/decorations/smoker" | "immersiveengineering:recipes/misc/crafting/transformer_hv" | "railways:recipes/misc/stonecutting/palettes/cycling/magenta_slashed_locometal" | "create:wrench_goggles" | "exdeorum:recipes/misc/cooked_silk_worm_from_campfire_cooking" | "create:recipes/building_blocks/copper_tile_stairs_from_copper_tiles_stonecutting" | "extradisks:recipes/misc/part/4096k_storage_part" | "refinedstorage:recipes/misc/fluid_grid/lime_fluid_grid" | "refinedstorage:drives" | "refinedstorage:recipes/misc/coloring_recipes/red_crafting_monitor" | "minecraft:recipes/building_blocks/chiseled_deepslate_from_cobbled_deepslate_stonecutting" | "immersiveengineering:recipes/misc/crafting/alu_slope" | "railways:recipes/misc/crafting/palettes/wrapping/gray_iron_wrapped_locometal" | "create:recipes/building_blocks/layered_tuff_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/chiseled_stone_bricks" | "minecraft:recipes/building_blocks/nether_brick_slab" | "create:recipes/building_blocks/cut_granite_slab" | "minecraft:recipes/misc/pumpkin_seeds" | "immersiveengineering:recipes/misc/crafting/sheetmetal_copper_to_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_brass_wrapped_locometal" | "refinedstorage:recipes/misc/coloring_recipes/black_controller" | "create:recipes/misc/crafting/kinetics/mechanical_bearing" | "farmersdelight:recipes/decorations/jungle_cabinet" | "immersiveengineering:recipes/misc/crafting/nugget_constantan_to_ingot_constantan" | "comforts:sleeping_bag_black" | "create:cross_streams" | "minecraft:recipes/decorations/mud_brick_wall" | "refinedstorage:recipes/misc/coloring_recipes/gray_detector" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_copper_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/red_sandstone" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_flat_riveted_locometal" | "minecraft:husbandry/tadpole_in_a_bucket" | "refinedstorage:recipes/misc/coloring_recipes/brown_controller" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_slashed_locometal" | "minecraft:recipes/redstone/dark_oak_button" | "create:recipes/misc/blasting/ingot_osmium_compat_mekanism" | "minecraft:husbandry/wax_off" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tile_stairs_from_honeycomb" | "copycats:recipes/misc/stonecutting/copycat_iron_trapdoor" | "railways:recipes/misc/stonecutting/palettes/cycling/flat_slashed_locometal" | "farmersdelight:recipes/food/rice_panicle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_riveted_locometal" | "minecraft:recipes/decorations/beehive" | "minecraft:recipes/misc/rib_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/tools/netherite_hoe_smithing" | "minecraft:recipes/decorations/lime_candle" | "minecraft:recipes/building_blocks/emerald_block" | "easy_mob_farm:recipes/upgrade/enchancement/luck_enhancement" | "minecraft:recipes/food/cooked_rabbit_from_smoking" | "immersiveengineering:recipes/misc/crafting/stick_iron" | "sophisticatedbackpacks:recipes/misc/chipped/tinkering_table_upgrade" | "create:recipes/misc/crafting/kinetics/train_door" | "farmersdelight:recipes/misc/paper_from_tree_bark" | "farmersdelight:recipes/cooking/cabbage_rolls" | "minecraft:recipes/building_blocks/nether_wart_block" | "create:recipes/building_blocks/cut_deepslate_slab_recycling" | "minecraft:recipes/redstone/trapped_chest" | "minecraft:recipes/building_blocks/dye_pink_wool" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_brass_wrapped_locometal_boiler" | "immersiveengineering:recipes/misc/crafting/sheetmetal_gold" | "immersiveengineering:recipes/misc/smelting/copper_ingot_from_dust_from_blasting" | "minecraft:recipes/decorations/cobbled_deepslate_wall_from_cobbled_deepslate_stonecutting" | "create:recipes/building_blocks/andesite_from_stone_types_andesite_stonecutting" | "immersiveengineering:recipes/misc/crafting/storage_nickel_from_slab" | "refinedstorage:recipes/misc/crafting_grid/purple_crafting_grid" | "sophisticatedbackpacks:recipes/misc/advanced_magnet_upgrade_from_basic" | "immersiveengineering:recipes/misc/crafting/sheetmetal_constantan" | "minecraft:recipes/building_blocks/stripped_birch_wood" | "create:recipes/misc/crafting/schematics/schematic_and_quill" | "create:windmill" | "create:recipes/building_blocks/cut_andesite_from_stone_types_andesite_stonecutting" | "create:rose_quartz" | "create:recipes/misc/smelting/ingot_uranium_compat_ic2" | "railways:recipes/misc/stonecutting/palettes/cycling/plated_locometal" | "minecraft:recipes/building_blocks/sponge" | "minecraft:recipes/building_blocks/smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/hoe_steel" | "create:recipes/building_blocks/cut_veridium_wall" | "minecraft:recipes/building_blocks/prismarine_brick_stairs" | "minecraft:recipes/decorations/prismarine_wall" | "refinedstorage:recipes/misc/coloring_recipes/magenta_security_manager" | "comforts:sleeping_bag_red" | "create:recipes/building_blocks/cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "create:recipes/misc/crafting/schematics/empty_schematic" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_flat_slashed_locometal" | "minecraft:recipes/redstone/warped_fence_gate" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_veridium_brick_slab_recycling" | "minecraft:recipes/transportation/acacia_chest_boat" | "copycats:recipes/misc/stonecutting/copycat_stone_pressure_plate" | "railways:recipes/misc/crafting/palettes/wrapping/cyan_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_iron_wrapped_locometal" | "easy_mob_farm:recipes/mob_catcher/enduring_capture_net" | "easy_mob_farm:recipes/mob_farm/jungle_farm" | "minecraft:recipes/decorations/white_candle" | "farmersdelight:recipes/food/salmon_roll" | "minecraft:recipes/combat/turtle_helmet" | "minecraft:recipes/building_blocks/mud_brick_stairs_from_mud_bricks_stonecutting" | "create:recipes/misc/smelting/glass_pane_from_horizontal_framed_glass_pane" | "refinedstorage:recipes/misc/coloring_recipes/yellow_pattern_grid" | "farmersdelight:main/place_feast" | "minecraft:recipes/building_blocks/oak_stairs" | "minecraft:recipes/building_blocks/polished_andesite_slab_from_andesite_stonecutting" | "create:recipes/building_blocks/copper_shingles_from_ingots_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_locometal_smokebox" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_riveted_locometal" | "immersiveengineering:recipes/misc/crafting/sorter" | "minecraft:end/dragon_breath" | "refinedstorage:recipes/misc/coloring_recipes/white_relay" | "create:recipes/misc/blasting/silver_ingot_compat_galosphere" | "create:recipes/building_blocks/crafting/kinetics/cyan_seat_from_other_seat" | "railways:recipes/combat/dying_existing_cap_purple" | "create:recipes/misc/crafting/kinetics/fluid_pipe" | "create:recipes/misc/crafting/kinetics/blue_valve_handle_from_other_valve_handle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_locometal_boiler" | "minecraft:recipes/building_blocks/white_concrete_powder" | "farmersdelight:recipes/food/wheat_dough_from_water" | "create:recipes/building_blocks/polished_cut_crimsite_stairs" | "create:recipes/building_blocks/small_crimsite_brick_wall_from_stone_types_crimsite_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/yellow_fluid_grid" | "immersiveengineering:recipes/misc/smelting/ingot_silver_from_blasting" | "minecraft:recipes/misc/music_disc_5" | "create:recipes/building_blocks/cut_dripstone_slab" | "minecraft:recipes/misc/netherite_scrap" | "minecraft:story/enchant_item" | "create:recipes/building_blocks/layered_crimsite_from_stone_types_crimsite_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_flat_slashed_locometal" | "minecraft:recipes/building_blocks/lime_stained_glass" | "create:recipes/misc/crafting/kinetics/stressometerfrom_conversion" | "create:recipes/building_blocks/polished_cut_tuff_wall" | "immersiveengineering:recipes/misc/crafting/plate_copper_hammering" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/quartz_pillar_from_quartz_block_stonecutting" | "create:recipes/building_blocks/cut_tuff_stairs" | "create:recipes/building_blocks/cut_tuff_wall" | "minecraft:recipes/redstone/cherry_trapdoor" | "create:recipes/misc/crafting/kinetics/brass_hand" | "refinedstorage:recipes/misc/fluid_grid/yellow_fluid_grid" | "minecraft:recipes/decorations/chain" | "refinedstorage:recipes/misc/coloring_recipes/magenta_pattern_grid" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_brass_wrapped_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_locometal_pillar" | "create:stressometer_maxed" | "minecraft:recipes/decorations/yellow_bed" | "exdeorum:recipes/misc/crushed_blackstone_from_compressed_crushed_blackstone" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_locometal_boiler" | "create:recipes/building_blocks/layered_ochrum_from_stone_types_ochrum_stonecutting" | "create:recipes/building_blocks/cut_scoria_from_stone_types_scoria_stonecutting" | "minecraft:recipes/decorations/oak_fence" | "refinedstorage:recipes/misc/fluid_grid/black_fluid_grid" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_locometal_smokebox" | "refinedstorage:recipes/misc/coloring_recipes/gray_crafter_manager" | "immersiveengineering:recipes/misc/crafting/heavy_engineering" | "create:recipes/building_blocks/ochrum_from_stone_types_ochrum_stonecutting" | "create:recipes/building_blocks/cut_limestone_stairs" | "ironchest:recipes/decorations/chests/vanilla_copper_chest" | "minecraft:recipes/redstone/cherry_button" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs" | "minecraft:recipes/misc/coal_from_blasting_coal_ore" | "minecraft:recipes/redstone/mangrove_door" | "create:display_board_0" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_locometal_smokebox" | "minecraft:recipes/redstone/redstone_from_smelting_deepslate_redstone_ore" | "create:steam_whistle" | "minecraft:recipes/food/cooked_porkchop_from_campfire_cooking" | "exdeorum:core/barrel" | "minecraft:recipes/building_blocks/chiseled_bookshelf" | "farmersdelight:recipes/cooking/pumpkin_soup" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_copper_wrapped_locometal_boiler" | "immersiveengineering:recipes/misc/crafting/toolupgrade_powerpack_induction" | "create:recipes/misc/crafting/appliances/clipboard" | "create:recipes/building_blocks/crafting/kinetics/black_seat_from_other_seat" | "immersiveengineering:multiblocks/craft_sheetmetal" | "extradisks:recipes/misc/disk/shaped/4096k_storage_disk" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_locometal_boiler" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_chestplate" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_slashed_locometal" | "refinedstorage:recipes/misc/coloring_recipes/magenta_network_receiver" | "minecraft:recipes/decorations/light_blue_stained_glass_pane" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_yellow" | "create:recipes/building_blocks/cut_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "create:crafter_lazy_000" | "minecraft:adventure/spyglass_at_parrot" | "minecraft:recipes/building_blocks/nether_brick_stairs_from_nether_bricks_stonecutting" | "create:recipes/building_blocks/copper_shingle_stairs" | "create:recipes/building_blocks/small_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "create:recipes/misc/crafting/kinetics/linear_chassis" | "create:recipes/building_blocks/cut_tuff_brick_stairs_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs" | "immersiveengineering:recipes/misc/crafting/cushion" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_plated_locometal" | "immersiveengineering:recipes/misc/smelting/ingot_nickel_from_blasting3" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_flat_slashed_locometal" | "immersiveengineering:recipes/misc/smelting/ingot_nickel_from_blasting2" | "minecraft:recipes/building_blocks/spruce_wood" | "create:recipes/misc/blasting/ingot_uranium_compat_immersiveengineering" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_copper_wrapped_locometal_boiler" | "create:recipes/misc/crafting/kinetics/track_signal" | "exdeorum:recipes/misc/moss_block" | "minecraft:recipes/misc/yellow_dye_from_dandelion" | "exdeorum:recipes/misc/flint_mesh" | "ironchest:recipes/decorations/chests/trapped_dirt_chest" | "minecraft:recipes/decorations/end_stone_brick_wall" | "create:recipes/misc/crafting/kinetics/gantry_carriage" | "refinedstorage:recipes/misc/coloring_recipes/orange_grid" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_iron_wrapped_locometal_boiler" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_fluid_grid" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_plated_locometal" | "immersiveengineering:recipes/misc/crafting/nugget_silver_to_ingot_silver" | "laserio:recipes/misc/card_fluid" | "immersiveengineering:recipes/misc/crafting/radiator" | "create:recipes/misc/crafting/kinetics/secondary_linear_chassisfrom_conversion" | "minecraft:recipes/decorations/mangrove_hanging_sign" | "minecraft:recipes/building_blocks/deepslate_bricks_from_polished_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_slashed_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_riveted_locometal" | "minecraft:recipes/decorations/black_banner" | "create:recipes/building_blocks/small_granite_brick_wall_from_stone_types_granite_stonecutting" | "minecraft:recipes/misc/black_dye_from_wither_rose" | "minecraft:recipes/misc/bone_meal" | "immersiveengineering:recipes/misc/smelting/hempcrete_brick_cracked" | "create:speed_controller" | "immersiveengineering:recipes/misc/crafting/conveyor_basic" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_iron_wrapped_locometal" | "create:recipes/misc/blasting/ingot_uranium_compat_ic2" | "railways:recipes/misc/crafting/palettes/wrapping/blue_copper_wrapped_locometal" | "create:recipes/building_blocks/tuff_pillar_from_stone_types_tuff_stonecutting" | "create:recipes/building_blocks/diorite_pillar_from_stone_types_diorite_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_slab_from_prismarine_stonecutting" | "minecraft:recipes/building_blocks/sandstone_stairs_from_sandstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/storage_uranium_from_slab" | "minecraft:adventure/totem_of_undying" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_slashed_locometal" | "minecraft:recipes/decorations/cobbled_deepslate_wall" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_iron_wrapped_locometal_boiler" | "refinedstorage:recipes/misc/coloring_recipes/black_network_transmitter" | "immersiveengineering:recipes/misc/crafting/blastbrick_reinforced_from_slab" | "minecraft:recipes/building_blocks/prismarine_bricks" | "immersiveengineering:recipes/misc/crafting/minecart_woodenbarrel" | "peco:recipes/tools/saddle" | "farmersdelight:recipes/food/chocolate_pie_from_slices" | "minecraft:recipes/decorations/polished_deepslate_wall_from_cobbled_deepslate_stonecutting" | "immersiveengineering:recipes/misc/crafting/minecart_metalbarrel" | "refinedstorage:recipes/misc/coloring_recipes/orange_detector" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_brass_wrapped_locometal" | "farmersdelight:recipes/decorations/green_hanging_canvas_sign" | "easy_mob_farm:recipes/upgrade/enchancement/sheep_enhancement" | "minecraft:recipes/decorations/diorite_wall" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_locometal_boiler" | "immersiveengineering:recipes/misc/crafting/concrete_leaded_to_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_iron_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_calcite_brick_slab_from_stone_types_calcite_stonecutting" | "immersiveengineering:recipes/misc/crafting/alloybrick_from_slab" | "minecraft:recipes/decorations/stonecutter" | "immersiveengineering:recipes/misc/crafting/voltmeter" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_iron_wrapped_locometal" | "farmersdelight:recipes/food/barbecue_stick" | "sophisticatedbackpacks:recipes/misc/compacting_upgrade" | "extrastorage:recipes/misc/part/storagepart_16384k_fluid" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_brass_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_brass_wrapped_locometal_boiler" | "minecraft:recipes/decorations/light_blue_banner" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_copper_wrapped_locometal" | "minecraft:recipes/decorations/smithing_table" | "immersiveengineering:recipes/misc/crafting/ingot_electrum_to_nugget_electrum" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_iron_wrapped_locometal_boiler" | "refinedstorage:autocrafting" | "minecraft:recipes/building_blocks/cut_sandstone_slab" | "minecraft:recipes/misc/cobbled_deepslate_from_compressed_cobbled_deepslate" | "exdeorum:recipes/misc/cobbled_deepslate" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_locometal_pillar" | "immersiveengineering:main/kill_illager" | "minecraft:recipes/misc/sugar_from_honey_bottle" | "minecraft:recipes/building_blocks/dye_red_carpet" | "minecraft:husbandry/allay_deliver_cake_to_note_block" | "extradisks:recipes/misc/blocks/4096k_storage_block" | "create:recipes/building_blocks/cut_limestone_brick_wall" | "creativecrafter:creative_crafter" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "create:recipes/building_blocks/oxidized_copper_tile_stairs" | "immersiveengineering:recipes/misc/crafting/plate_uranium_hammering" | "minecraft:recipes/decorations/orange_stained_glass_pane_from_glass_pane" | "immersiveengineering:recipes/misc/crafting/blueprint_components" | "minecraft:recipes/transportation/tnt_minecart" | "immersiveengineering:recipes/misc/crafting/hempcrete" | "immersiveengineering:recipes/misc/crafting/sheetmetal_copper" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_pick_from_blasting" | "create:crusher_maxed_0000" | "create:recipes/misc/smelting/copper_ingot_from_crushed" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_riveted_locometal" | "create:recipes/building_blocks/small_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "immersiveengineering:recipes/misc/crafting/steel_fence" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_locometal_smokebox" | "copycats:recipes/misc/stonecutting/copycat_ghost_block" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs_from_oxidized_cut_copper_stonecutting" | "exdeorum:recipes/misc/crushed_deepslate_from_compressed_crushed_deepslate" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_purple_to_slab" | "minecraft:recipes/building_blocks/dye_green_bed" | "create:recipes/building_blocks/polished_cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/brown_candle" | "minecraft:recipes/building_blocks/quartz_pillar" | "immersiveengineering:recipes/misc/crafting/chemthrower" | "minecraft:husbandry/wax_on" | "minecraft:recipes/building_blocks/purple_terracotta" | "immersiveengineering:recipes/misc/crafting/connector_bundled" | "create:recipes/misc/crafting/logistics/powered_latch" | "extrastorage:recipes/misc/advanced_exporter" | "minecraft:adventure/play_jukebox_in_meadows" | "immersiveengineering:recipes/misc/crafting/sheetmetal_nickel_from_slab" | "refinedstorage:recipes/misc/coloring_recipes/brown_grid" | "create:recipes/building_blocks/polished_cut_dripstone_stairs_from_stone_types_dripstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/windmill_sail" | "minecraft:recipes/misc/green_dye" | "minecraft:recipes/decorations/magenta_bed" | "create:recipes/building_blocks/polished_cut_granite_slab_recycling" | "refinedstorage:recipes/misc/coloring_recipes/yellow_detector" | "minecraft:recipes/redstone/honey_block" | "minecraft:recipes/building_blocks/dark_prismarine" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_flat_slashed_locometal" | "minecraft:adventure/hero_of_the_village" | "create:recipes/building_blocks/polished_cut_limestone_wall" | "minecraft:recipes/redstone/redstone" | "railways:recipes/misc/stonecutting/palettes/cycling/riveted_locometal" | "minecraft:recipes/building_blocks/smooth_stone" | "create:recipes/building_blocks/small_scorchia_brick_slab_recycling" | "create:recipes/misc/crafting/logistics/andesite_tunnel" | "minecraft:recipes/misc/coast_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/dye_pink_carpet" | "railways:recipes/misc/crafting/palettes/wrapping/pink_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_locometal_boiler" | "copycats:recipes/crafting/copycat_box" | "immersiveengineering:recipes/misc/crafting/concrete_tile" | "minecraft:recipes/building_blocks/packed_ice" | "minecraft:recipes/transportation/spruce_boat" | "exmachinis:recipes/misc/gold_upgrade" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_slashed_locometal" | "extrastorage:recipes/misc/storage_block/block_1024k" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_crafter" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/quartz_stairs_from_quartz_block_stonecutting" | "laserio:recipes/misc/filter_basic" | "copycats:recipes/crafting/copycat_panel_from_half_panels" | "minecraft:recipes/building_blocks/deepslate_tiles" | "create:recipes/building_blocks/crimsite_pillar_from_stone_types_crimsite_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/cyan_crafter" | "minecraft:recipes/building_blocks/warped_hyphae" | "minecraft:recipes/redstone/jungle_button" | "extrastorage:recipes/misc/disk/shaped/disk_262144k_fluid" | "railways:recipes/misc/stonecutting/palettes/cycling/black_locometal_smokebox" | "immersiveengineering:recipes/misc/crafting/revolver" | "extrastorage:recipes/misc/gold_crafter" | "farmersdelight:recipes/misc/canvas" | "immersiveengineering:recipes/misc/crafting/sheetmetal_steel_from_slab" | "copycats:recipes/misc/stonecutting/copycat_fence_gate" | "minecraft:recipes/redstone/note_block" | "railways:recipes/combat/dying_existing_cap_gray" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_copper_wrapped_locometal" | "easy_mob_farm:recipes/mob_catcher/ironbound_containment_cage" | "minecraft:recipes/decorations/green_stained_glass_pane_from_glass_pane" | "create:recipes/building_blocks/crafting/kinetics/lime_seat_from_other_seat" | "immersiveengineering:recipes/misc/stonecutting/hempcrete_chiseled" | "immersiveengineering:multiblocks/mb_silo" | "peco:recipes/misc/slime_ball" | "create:hose_pulley" | "minecraft:recipes/decorations/crimson_hanging_sign" | "refinedstorage:storing_items" | "cabletiers:mega_constructor" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_iron_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/blastbrick" | "minecraft:recipes/decorations/lime_bed" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_flat_slashed_locometal" | "railways:recipes/misc/stonecutting/palettes/cycling/orange_riveted_locometal" | "refinedstorage:recipes/misc/coloring_recipes/pink_detector" | "immersiveengineering:recipes/misc/crafting/blastfurnace_preheater" | "create:recipes/building_blocks/polished_cut_granite_slab_from_stone_types_granite_stonecutting" | "immersiveengineering:recipes/misc/crafting/fluid_pipe" | "create:recipes/misc/crafting/kinetics/empty_blaze_burner" | "immersiveengineering:recipes/misc/crafting/raw_block_lead_to_raw_lead" | "farmersdelight:recipes/decorations/light_gray_canvas_sign" | "minecraft:recipes/building_blocks/smooth_stone_slab" | "farmersdelight:recipes/food/cooked_mutton_chops_from_smoking" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_slashed_locometal" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_security_manager" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_slashed_locometal" | "immersiveengineering:recipes/misc/crafting/storage_electrum_to_slab" | "create:recipes/building_blocks/crafting/kinetics/cyan_seat" | "create:recipes/building_blocks/small_asurine_brick_wall" | "extrastorage:recipes/misc/part/storagepart_262144k_fluid" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_riveted_locometal" | "minecraft:recipes/misc/beacon" | "create:recipes/misc/crafting/kinetics/millstone" | "sophisticatedbackpacks:recipes/misc/advanced_magnet_upgrade" | "additionalredstone:recipes/circuit_maker" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_locometal_boiler" | "minecraft:recipes/building_blocks/red_nether_bricks" | "immersiveengineering:recipes/misc/crafting/toolupgrade_drill_lube" | "minecraft:recipes/decorations/cyan_carpet" | "minecraft:husbandry/root" | "refinedstorage:recipes/misc/coloring_recipes/blue_crafting_grid" | "create:recipes/building_blocks/cut_granite_bricks_from_stone_types_granite_stonecutting" | "minecraft:recipes/transportation/birch_boat" | "minecraft:recipes/building_blocks/cut_copper_from_copper_block_stonecutting" | "immersiveengineering:recipes/misc/crafting/ingot_nickel_to_storage_nickel" | "minecraft:recipes/building_blocks/cobbled_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "extrastorage:recipes/misc/storage_block/block_4096k" | "mobdropsrecipes_overworld:recipes/misc/essence_into_bone" | "laserio:recipes/misc/laser_wrench" | "create:recipes/building_blocks/crafting/kinetics/purple_seat_from_other_seat" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_chestplate_from_blasting" | "farmersdelight:recipes/food/cod_roll" | "copycats:recipes/misc/stonecutting/copycat_slab" | "railways:recipes/misc/crafting/palettes/wrapping/blue_iron_wrapped_locometal" | "minecraft:recipes/redstone/crimson_trapdoor" | "minecraft:recipes/building_blocks/cherry_wood" | "minecraft:recipes/decorations/green_glazed_terracotta" | "cabletiers:ultra_constructor" | "minecraft:recipes/decorations/bamboo_sign" | "immersiveengineering:recipes/misc/crafting/wirecoil_electrum_ins" | "create:recipes/misc/blasting/lead_ingot_compat_thermal" | "exdeorum:core/crook" | "create:recipes/building_blocks/cut_ochrum_brick_stairs" | "minecraft:recipes/building_blocks/blue_ice" | "minecraft:adventure/trade" | "minecraft:recipes/building_blocks/deepslate" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_flat_slashed_locometal" | "minecraft:recipes/decorations/white_carpet" | "extradisks:recipes/misc/disk/shaped/infinite_storage_disk" | "minecraft:recipes/transportation/cherry_chest_boat" | "minecraft:recipes/building_blocks/red_sandstone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_locometal_boiler" | "minecraft:recipes/building_blocks/dark_prismarine_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_flat_slashed_locometal" | "minecraft:recipes/decorations/pink_stained_glass_pane_from_glass_pane" | "create:recipes/building_blocks/cut_scoria_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_iron_wrapped_locometal_boiler" | "create:recipes/misc/smelting/glass_pane_from_tiled_glass_pane" | "create:recipes/building_blocks/cut_tuff_brick_wall_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/jack_o_lantern" | "minecraft:recipes/transportation/birch_chest_boat" | "minecraft:recipes/decorations/glass_pane" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_cyan_from_slab" | "immersiveengineering:recipes/misc/stonecutting/wall_clinker_brick" | "minecraft:recipes/decorations/purple_banner" | "minecraft:recipes/building_blocks/magenta_stained_glass" | "create:recipes/misc/crafting/schematics/schematic_table" | "farmersdelight:recipes/decorations/skillet" | "minecraft:recipes/transportation/oak_boat" | "refinedstorage:recipes/misc/crafting_grid/blue_crafting_grid" | "create:recipes/decorations/brass_scaffolding_from_ingots_brass_stonecutting" | "immersiveengineering:recipes/misc/stonecutting/concrete_tile" | "railways:recipes/misc/crafting/smokestack_streamlined" | "easy_mob_farm:recipes/upgrade/enchancement/speed_enhancement" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_plated_locometal" | "create:recipes/building_blocks/polished_cut_scorchia_stairs" | "refinedstorage:recipes/misc/coloring_recipes/blue_crafter_manager" | "create:recipes/building_blocks/polished_cut_asurine_wall_from_stone_types_asurine_stonecutting" | "minecraft:recipes/building_blocks/bamboo_mosaic_stairs" | "create:recipes/building_blocks/small_granite_brick_wall" | "minecraft:recipes/building_blocks/smooth_stone_slab_from_smooth_stone_stonecutting" | "immersiveengineering:recipes/misc/crafting/coke_from_slab" | "railways:recipes/misc/stonecutting/palettes/cycling/green_locometal_smokebox" | "minecraft:recipes/decorations/deepslate_tile_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "minecraft:recipes/misc/paper" | "create:recipes/building_blocks/polished_cut_tuff_stairs" | "create:backtank" | "minecraft:recipes/redstone/warped_button" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_riveted_locometal" | "exdeorum:recipes/misc/warped_compressed_sieve" | "minecraft:husbandry/kill_axolotl_target" | "minecraft:recipes/decorations/stone_brick_wall_from_stone_bricks_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_flat_slashed_locometal" | "minecraft:recipes/building_blocks/red_nether_brick_stairs" | "create:recipes/misc/crafting/kinetics/brass_door" | "immersiveengineering:recipes/misc/crafting/chute_steel" | "railways:recipes/misc/stonecutting/palettes/cycling/red_flat_riveted_locometal" | "create:recipes/building_blocks/small_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "exdeorum:recipes/tools/compressed_wooden_hammer" | "minecraft:recipes/building_blocks/warped_stairs" | "create:recipes/building_blocks/small_scorchia_brick_wall" | "minecraft:recipes/building_blocks/white_stained_glass" | "farmersdelight:recipes/food/bread_from_smoking" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_lime_from_slab" | "minecraft:recipes/decorations/blue_glazed_terracotta" | "farmersdelight:recipes/cooking/cooked_rice" | "immersiveengineering:recipes/misc/crafting/skyhook" | "minecraft:recipes/building_blocks/mossy_cobblestone_from_moss_block" | "minecraft:recipes/building_blocks/andesite_slab_from_andesite_stonecutting" | "minecraft:recipes/redstone/acacia_fence_gate" | "minecraft:recipes/building_blocks/coal_block" | "immersiveengineering:recipes/misc/crafting/toolupgrade_drill_capacity" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_iron_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_brass_wrapped_locometal" | "exdeorum:recipes/misc/andesite" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_honeycomb" | "railways:recipes/misc/crafting/palettes/wrapping/brass_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/raw_uranium_to_raw_block_uranium" | "minecraft:recipes/building_blocks/spruce_slab" | "minecraft:recipes/decorations/polished_blackstone_wall_from_blackstone_stonecutting" | "create:recipes/building_blocks/cut_asurine_brick_slab_recycling" | "minecraft:recipes/tools/lead" | "minecraft:recipes/decorations/warped_sign" | "farmersdelight:recipes/cooking/fried_rice" | "exdeorum:recipes/misc/crimson_compressed_sieve" | "copycats:recipes/misc/stonecutting/copycat_trapdoor" | "refinedstorage:recipes/misc/coloring_recipes/blue_fluid_grid" | "immersiveengineering:recipes/misc/crafting/toolbox" | "extrastorage:recipes/misc/iron_crafter" | "minecraft:recipes/decorations/white_stained_glass_pane_from_glass_pane" | "create:recipes/misc/crafting/kinetics/windmill_bearing" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_waxed_copper_block_stonecutting" | "immersiveengineering:recipes/misc/crafting/treated_wood_horizontal_to_slab" | "exdeorum:recipes/misc/stone_barrel" | "create:recipes/building_blocks/polished_cut_ochrum_from_stone_types_ochrum_stonecutting" | "create:recipes/building_blocks/cut_asurine_bricks_from_stone_types_asurine_stonecutting" | "sophisticatedbackpacks:recipes/misc/advanced_filter_upgrade" | "refinedstorage:recipes/misc/coloring_recipes/black_pattern_grid" | "minecraft:recipes/redstone/bamboo_door" | "minecraft:recipes/decorations/lodestone" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_flat_slashed_locometal" | "minecraft:recipes/misc/shaper_armor_trim_smithing_template_smithing_trim" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_locometal_pillar" | "create:recipes/building_blocks/cut_calcite_brick_slab_recycling" | "create:recipes/building_blocks/cut_tuff_slab_recycling" | "create:recipes/misc/crafting/materials/sand_paper" | "exdeorum:recipes/misc/dark_oak_barrel" | "immersiveengineering:recipes/misc/crafting/wirecoil_copper" | "create:recipes/building_blocks/layered_limestone_from_stone_types_limestone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_locometal_smokebox" | "create:recipes/building_blocks/polished_cut_calcite_wall_from_stone_types_calcite_stonecutting" | "minecraft:recipes/redstone/oak_button" | "create:recipes/misc/crafting/kinetics/basin" | "create:belt_funnel_kiss" | "immersiveengineering:recipes/misc/crafting/concrete_tile_from_slab" | "extradisks:recipes/misc/blocks/262144k_storage_block" | "minecraft:adventure/honey_block_slide" | "create:recipes/building_blocks/dark_oak_window_pane" | "minecraft:recipes/redstone/dark_oak_pressure_plate" | "mcwfurnitures:recipes/cherry" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_plated_locometal" | "minecraft:recipes/building_blocks/smooth_quartz_stairs_from_smooth_quartz_stonecutting" | "minecraft:recipes/misc/vex_armor_trim_smithing_template" | "mobdropsrecipes_overworld:recipes/misc/prismarine_shard" | "minecraft:recipes/misc/soul_sand_from_compressed_soul_sand" | "create:recipes/building_blocks/cut_calcite_slab" | "immersiveengineering:multiblocks/multiblocks_root" | "create:recipes/building_blocks/small_asurine_brick_slab_from_stone_types_asurine_stonecutting" | "minecraft:recipes/misc/iron_ingot_from_smelting_deepslate_iron_ore" | "minecraft:recipes/decorations/nether_brick_fence" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone_from_blackstone_stonecutting" | "immersiveengineering:main/main_root" | "refinedstorage:recipes/misc/coloring_recipes/brown_crafter_manager" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_pattern_grid" | "refinedstorage:recipes/misc/pattern_grid/lime_pattern_grid" | "minecraft:recipes/misc/magenta_dye_from_allium" | "minecraft:recipes/misc/wayfinder_armor_trim_smithing_template_smithing_trim" | "exdeorum:recipes/tools/stone_watering_can" | "refinedstorage:importing" | "minecraft:recipes/decorations/decorated_pot_simple" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_brass_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_locometal_smokebox" | "minecraft:recipes/building_blocks/cracked_deepslate_tiles" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_shingle_stairs_from_honeycomb" | "sophisticatedbackpacks:recipes/misc/inception_upgrade" | "easy_mob_farm:recipes/mob_farm/bee_hive_farm" | "minecraft:recipes/building_blocks/exposed_cut_copper" | "create:linked_controller" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab" | "minecraft:recipes/decorations/stone_brick_walls_from_stone_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/magenta_detector" | "create:arm_many_targets" | "immersiveengineering:main/craft_heater" | "exdeorum:recipes/misc/sculk_core" | "create:recipes/building_blocks/polished_cut_diorite_wall_from_stone_types_diorite_stonecutting" | "create:recipes/misc/smelting/silver_ingot_compat_iceandfire" | "minecraft:recipes/redstone/daylight_detector" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/diamond_from_blasting_deepslate_diamond_ore" | "create:recipes/misc/crafting/materials/copper_ingot" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_copper_wrapped_locometal_boiler" | "create:recipes/building_blocks/small_calcite_brick_slab" | "minecraft:recipes/building_blocks/dye_purple_bed" | "minecraft:recipes/redstone/jungle_fence_gate" | "create:recipes/misc/crafting/materials/zinc_block_from_compacting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/dye_light_gray_carpet" | "create:recipes/misc/crafting/kinetics/large_cogwheel" | "minecraft:recipes/redstone/warped_door" | "sophisticatedbackpacks:recipes/misc/blasting_upgrade" | "immersiveengineering:recipes/misc/stonecutting/stairs_hempcrete" | "minecraft:recipes/decorations/dark_oak_fence" | "extradisks:recipes/misc/disk/shapeless/1048576k_storage_disk" | "minecraft:recipes/combat/diamond_boots" | "create:recipes/misc/crafting/logistics/andesite_funnel" | "refinedstorage:construction" | "create:recipes/building_blocks/crafting/kinetics/light_blue_seat_from_other_seat" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_gray_from_slab" | "create:recipes/misc/crafting/kinetics/yellow_valve_handle_from_other_valve_handle" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_iron_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/smokestack_caboosestyle" | "extradisks:recipes/misc/part/65536k_fluid_storage_part" | "create:recipes/misc/crafting/kinetics/fluid_valve" | "railways:recipes/misc/crafting/palettes/wrapping/brown_copper_wrapped_locometal" | "create:recipes/building_blocks/polished_cut_asurine_stairs" | "create:recipes/building_blocks/small_dripstone_brick_stairs" | "farmersdelight:recipes/decorations/warped_cabinet" | "refinedstorage:recipes/misc/coloring_recipes/lime_fluid_grid" | "refinedstorage:recipes/misc/fluid_grid/light_gray_fluid_grid" | "create:red_signal" | "immersiveengineering:recipes/misc/crafting/stick_treated" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_locometal_pillar" | "minecraft:recipes/combat/iron_sword" | "create:recipes/building_blocks/polished_cut_limestone_slab_from_stone_types_limestone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_flat_riveted_locometal" | "ironchest:recipes/decorations/upgrades/diamond_to_crystal_chest_upgrade" | "minecraft:recipes/redstone/observer" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_iron_wrapped_locometal_boiler" | "refinedstorage:recipes/misc/coloring_recipes/gray_crafting_grid" | "minecraft:recipes/misc/light_gray_dye_from_white_tulip" | "minecraft:recipes/tools/iron_pickaxe" | "refinedstorage:recipes/misc/coloring_recipes/green_network_receiver" | "minecraft:recipes/building_blocks/polished_granite_stairs" | "minecraft:recipes/building_blocks/dark_oak_slab" | "minecraft:recipes/transportation/mangrove_boat" | "create:recipes/misc/crafting/kinetics/light_blue_valve_handle_from_other_valve_handle" | "create:recipes/building_blocks/cut_limestone_from_stone_types_limestone_stonecutting" | "minecraft:recipes/decorations/torch" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_iron_wrapped_locometal" | "exdeorum:recipes/misc/cherry_compressed_sieve" | "refinedstorage:wireless_items" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_detector" | "minecraft:recipes/building_blocks/stone_brick_slab_from_stone_stonecutting" | "minecraft:recipes/building_blocks/smooth_sandstone_stairs_from_smooth_sandstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_brass_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_honeycomb" | "exdeorum:recipes/misc/warped_crucible" | "minecraft:recipes/building_blocks/dark_oak_planks" | "minecraft:recipes/transportation/detector_rail" | "exdeorum:recipes/misc/dark_oak_compressed_sieve" | "immersiveengineering:recipes/misc/crafting/treated_scaffold" | "minecraft:recipes/combat/shield" | "create:recipes/building_blocks/small_dripstone_brick_slab_recycling" | "extrastorage:recipes/misc/disk/shaped/disk_256k" | "minecraft:recipes/building_blocks/red_sandstone_stairs" | "refinedstorage:recipes/misc/coloring_recipes/green_disk_manipulator" | "immersiveengineering:recipes/misc/smelting/ingot_constantan_from_dust_from_blasting" | "create:recipes/misc/crafting/logistics/stockpile_switch" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_iron_wrapped_locometal_boiler" | "create:recipes/building_blocks/birch_window_pane" | "create:recipes/building_blocks/small_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_locometal_boiler" | "immersiveengineering:recipes/misc/crafting/sheetmetal_silver_from_slab" | "immersiveengineering:main/craft_extract_conveyor" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_flat_riveted_locometal" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_polished_deepslate_stonecutting" | "immersiveengineering:recipes/misc/crafting/ingot_steel_to_nugget_steel" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_riveted_locometal" | "create:recipes/building_blocks/polished_cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/polished_cut_scoria_wall_from_stone_types_scoria_stonecutting" | "extrastorage:recipes/misc/part/storagepart_65536k_fluid" | "create:recipes/building_blocks/polished_cut_andesite_slab_from_stone_types_andesite_stonecutting" | "create:recipes/decorations/copper_ladder_from_ingots_copper_stonecutting" | "minecraft:recipes/misc/dune_armor_trim_smithing_template" | "immersiveengineering:recipes/misc/smelting/ingot_uranium" | "minecraft:recipes/decorations/magenta_carpet" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_iron_wrapped_locometal" | "create:recipes/building_blocks/polished_cut_calcite_wall" | "minecraft:recipes/misc/creeper_banner_pattern" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_helmet_from_blasting" | "create:recipes/misc/crafting/materials/red_sand_paper" | "immersiveengineering:main/craft_treatedwood" | "create:recipes/misc/crafting/kinetics/controls" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_locometal_smokebox" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_flat_riveted_locometal" | "minecraft:recipes/building_blocks/andesite_stairs_from_andesite_stonecutting" | "minecraft:recipes/decorations/iron_bars" | "immersiveengineering:recipes/misc/stonecutting/concrete_brick2" | "create:recipes/building_blocks/cut_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "immersiveengineering:recipes/misc/crafting/alu_post" | "minecraft:recipes/misc/copper_ingot" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_green_to_slab" | "create:recipes/building_blocks/cut_veridium_slab_from_stone_types_veridium_stonecutting" | "create:recipes/misc/blasting/ingot_aluminum_compat_immersiveengineering" | "create:recipes/building_blocks/cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "extradisks:recipes/misc/disk/shaped/65536k_fluid_storage_disk" | "exmachinis:diamond_upgrade" | "minecraft:recipes/building_blocks/dye_purple_wool" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_copper_wrapped_locometal" | "minecraft:recipes/transportation/chest_minecart" | "minecraft:recipes/building_blocks/spruce_planks" | "railways:recipes/misc/crafting/remote_lens" | "minecraft:recipes/building_blocks/netherite_block" | "create:recipes/building_blocks/cut_granite_slab_recycling" | "immersiveengineering:recipes/misc/crafting/nugget_steel_to_ingot_steel" | "refinedstorage:recipes/misc/crafting_grid/pink_crafting_grid" | "minecraft:recipes/building_blocks/polished_diorite_slab" | "immersiveengineering:recipes/misc/smelting/ingot_lead_from_blasting" | "create:train_crash" | "minecraft:recipes/decorations/red_carpet" | "minecraft:recipes/misc/wild_armor_trim_smithing_template" | "immersiveengineering:recipes/misc/smelting/ingot_hop_graphite" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_plated_locometal" | "create:long_travel" | "minecraft:recipes/transportation/dark_oak_chest_boat" | "comforts:hammock_red" | "exdeorum:recipes/misc/ores/silver_tag" | "create:recipes/misc/crafting/kinetics/sequenced_gearshift" | "refinedstorage:recipes/misc/coloring_recipes/red_security_manager" | "minecraft:recipes/building_blocks/stone_brick_stairs_from_stone_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/red_network_transmitter" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_locometal_smokebox" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_standard_from_slab" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_deepslate_tiles_stonecutting" | "minecraft:recipes/building_blocks/mud_brick_slab" | "minecraft:adventure/lightning_rod_with_villager_no_fire" | "immersiveengineering:recipes/misc/crafting/alloybrick_to_slab" | "minecraft:recipes/misc/host_armor_trim_smithing_template" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_locometal_boiler" | "create:recipes/building_blocks/cut_ochrum_from_stone_types_ochrum_stonecutting" | "sophisticatedbackpacks:recipes/misc/advanced_tool_swapper_upgrade" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_slashed_locometal" | "minecraft:recipes/brewing/glistering_melon_slice" | "refinedstorage:recipes/misc/coloring_recipes/cyan_relay" | "immersiveengineering:recipes/misc/crafting/plate_electrum_hammering" | "minecraft:recipes/misc/light_gray_dye_from_azure_bluet" | "immersiveengineering:recipes/misc/crafting/tesla_coil" | "minecraft:recipes/building_blocks/cracked_nether_bricks" | "minecraft:recipes/building_blocks/polished_deepslate_slab_from_cobbled_deepslate_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_plated_locometal" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_waxed_cut_copper_stonecutting" | "minecraft:recipes/misc/wild_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/smooth_quartz" | "farmersdelight:recipes/decorations/cherry_cabinet" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_riveted_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_flat_riveted_locometal" | "create:recipes/building_blocks/polished_cut_limestone_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_brass_wrapped_locometal_boiler" | "extradisks:recipes/misc/raw_withering_processor" | "create:recipes/building_blocks/small_scoria_brick_wall" | "create:recipes/building_blocks/crafting/kinetics/pink_seat" | "minecraft:recipes/decorations/blue_stained_glass_pane" | "create:recipes/building_blocks/mangrove_window_pane" | "immersiveengineering:recipes/misc/crafting/connector_redstone" | "create:recipes/building_blocks/polished_cut_calcite_slab_from_stone_types_calcite_stonecutting" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_wooden_top_from_grate_top" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_waxed_exposed_copper_stonecutting" | "minecraft:adventure/craft_decorated_pot_using_only_sherds" | "extradisks:recipes/misc/part/infinite_fluid_storage_part" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_locometal_pillar" | "minecraft:recipes/decorations/polished_deepslate_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/food/cooked_salmon_from_smoking" | "railways:recipes/combat/dying_existing_cap_green" | "minecraft:recipes/tools/netherite_shovel_smithing" | "minecraft:recipes/brewing/glass_bottle" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_copper_wrapped_locometal" | "immersiveengineering:tools/craft_wolfpack" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_brass_wrapped_locometal" | "create:mechanical_arm" | "minecraft:recipes/decorations/acacia_hanging_sign" | "minecraft:recipes/building_blocks/dye_gray_carpet" | "immersiveengineering:recipes/misc/crafting/plate_steel_hammering" | "create:recipes/misc/crafting/materials/brass_nugget_from_decompacting" | "create:recipes/misc/crafting/kinetics/item_drain" | "create:recipes/building_blocks/small_diorite_brick_stairs" | "exdeorum:recipes/misc/porcelain_bucket" | "create:recipes/building_blocks/rose_quartz_block_from_rose_quartz_stonecutting" | "minecraft:recipes/decorations/red_nether_brick_wall_from_red_nether_bricks_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/light_gray_flat_slashed_locometal" | "minecraft:recipes/misc/lime_dye_from_smelting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_flat_slashed_locometal" | "create:recipes/building_blocks/cut_asurine_wall" | "minecraft:recipes/building_blocks/blackstone_slab_from_blackstone_stonecutting" | "laserio:recipes/misc/logic_chip_raw" | "railways:recipes/misc/stonecutting/palettes/cycling/light_blue_locometal_pillar" | "create:recipes/building_blocks/crafting/copper/waxed_oxidized_copper_shingle_slab_from_honeycomb" | "minecraft:recipes/redstone/cherry_fence_gate" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs" | "create:recipes/misc/crafting/kinetics/mechanical_mixer" | "minecraft:recipes/building_blocks/chiseled_red_sandstone_from_red_sandstone_stonecutting" | "extradisks:recipes/misc/advanced_storage_housing" | "create:recipes/building_blocks/copycat_step_from_ingots_zinc_stonecutting" | "minecraft:recipes/building_blocks/jungle_planks" | "farmersdelight:recipes/decorations/stove" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_brass_wrapped_locometal_boiler" | "minecraft:recipes/building_blocks/chiseled_quartz_block" | "create:recipes/building_blocks/small_tuff_brick_slab" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_white_to_slab" | "minecraft:recipes/redstone/bamboo_trapdoor" | "create:recipes/misc/crafting/kinetics/framed_glass_trapdoor" | "comforts:sleeping_bag_gray" | "railways:recipes/misc/stonecutting/palettes/cycling/locometal_pillar" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_iron_wrapped_locometal_boiler" | "refinedstorage:recipes/misc/pattern_grid/red_pattern_grid" | "farmersdelight:recipes/decorations/oak_cabinet" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_lime" | "farmersdelight:recipes/food/cooked_cod_slice" | "refinedstorage:recipes/misc/coloring_recipes/white_network_transmitter" | "create:recipes/building_blocks/polished_cut_deepslate_wall" | "create:recipes/building_blocks/crafting/kinetics/black_seat" | "create:recipes/building_blocks/cut_diorite_brick_slab" | "create:recipes/decorations/andesite_ladder_from_andesite_alloy_stonecutting" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_boots" | "farmersdelight:main/get_mushroom_colony" | "create:recipes/combat/crafting/appliances/netherite_diving_boots_from_netherite" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_locometal_smokebox" | "create:recipes/building_blocks/small_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_waxed_weathered_copper_stonecutting" | "create:recipes/misc/crafting/logistics/redstone_contact" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_crafting_grid" | "exdeorum:recipes/misc/warped_sieve" | "create:recipes/misc/crafting/kinetics/red_valve_handle_from_other_valve_handle" | "minecraft:recipes/building_blocks/dye_light_blue_wool" | "railways:recipes/misc/crafting/palettes/wrapping/yellow_copper_wrapped_locometal" | "minecraft:recipes/redstone/sticky_piston" | "railways:recipes/misc/crafting/palettes/dyeing_1x/green_locometal_smokebox" | "railways:recipes/misc/stonecutting/palettes/cycling/white_flat_riveted_locometal" | "refinedstorage:crafting_on_demand" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab" | "refinedstorage:recipes/misc/coloring_recipes/gray_crafter" | "sophisticatedbackpacks:recipes/misc/smoking_upgrade_from_smelting_upgrade" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_riveted_locometal" | "cabletiers:elite_importer" | "immersiveengineering:recipes/misc/crafting/sword_steel" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_riveted_locometal" | "refinedstorage:destruction" | "laserio:recipes/misc/overclocker_card" | "minecraft:recipes/brewing/fermented_spider_eye" | "minecraft:recipes/misc/iron_ingot_from_smelting_raw_iron" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_cobbled_deepslate_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_nickel_to_slab" | "refinedstorage:recipes/misc/coloring_recipes/white_pattern_grid" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_locometal_smokebox" | "minecraft:recipes/misc/purple_dye" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_riveted_locometal" | "immersiveengineering:recipes/misc/smelting/gold_ingot_from_dust_from_blasting" | "immersiveengineering:recipes/misc/crafting/concrete" | "create:recipes/building_blocks/cut_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_iron_wrapped_locometal" | "minecraft:recipes/building_blocks/waxed_cut_copper_from_waxed_copper_block_stonecutting" | "refinedstorage:recipes/misc/crafting_grid/black_crafting_grid" | "minecraft:adventure/kill_mob_near_sculk_catalyst" | "create:recipes/building_blocks/polished_cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/building_blocks/dried_kelp_block" | "minecraft:recipes/building_blocks/end_stone_brick_slab_from_end_stone_brick_stonecutting" | "minecraft:recipes/building_blocks/quartz_bricks_from_quartz_block_stonecutting" | "create:recipes/building_blocks/cut_calcite_from_stone_types_calcite_stonecutting" | "create:recipes/building_blocks/cut_scorchia_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_copper_wrapped_locometal" | "exdeorum:recipes/misc/golden_mesh" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_flat_slashed_locometal" | "refinedstorage:wireless_fluids" | "refinedstorage:no_cables_required" | "create:recipes/building_blocks/small_deepslate_brick_slab_recycling" | "extradisks:recipes/misc/part/262144k_storage_part" | "minecraft:recipes/building_blocks/waxed_oxidized_copper_from_honeycomb" | "farmersdelight:recipes/food/beef_patty_from_smoking" | "create:recipes/building_blocks/small_andesite_brick_slab" | "create:recipes/building_blocks/exposed_copper_tile_slab_from_exposed_copper_tiles_stonecutting" | "farmersdelight:recipes/cooking/beef_stew" | "farmersdelight:recipes/food/cabbage" | "immersiveengineering:recipes/misc/crafting/reinforced_crate" | "refinedstorage:recipes/misc/crafting_grid/light_gray_crafting_grid" | "minecraft:recipes/decorations/mangrove_fence" | "minecraft:recipes/building_blocks/dye_white_carpet" | "minecraft:recipes/building_blocks/white_terracotta" | "create:recipes/misc/crafting/kinetics/fluid_tank" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_copper_wrapped_locometal" | "refinedstorage:interface_to_the_world" | "refinedstorage:recipes/misc/fluid_grid/cyan_fluid_grid" | "minecraft:recipes/food/cooked_mutton" | "railways:recipes/misc/crafting/palettes/wrapping/pink_iron_wrapped_locometal" | "minecraft:recipes/misc/white_dye_from_lily_of_the_valley" | "create:recipes/misc/crafting/materials/andesite_alloy_from_zinc" | "minecraft:recipes/building_blocks/deepslate_tile_stairs" | "minecraft:recipes/building_blocks/polished_blackstone_bricks_from_polished_blackstone_stonecutting" | "create:recipes/building_blocks/cut_granite_wall_from_stone_types_granite_stonecutting" | "create:recipes/building_blocks/calcite_from_stone_types_calcite_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_black_from_slab" | "comforts:hammock_black" | "minecraft:recipes/misc/red_sand_from_compressed_red_sand" | "railways:recipes/misc/crafting/palettes/wrapping/magenta_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/dye_light_blue_bed" | "minecraft:recipes/decorations/lime_carpet" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_flat_riveted_locometal" | "railways:recipes/misc/crafting/smokestack_diesel" | "minecraft:adventure/sniper_duel" | "farmersdelight:recipes/decorations/canvas_sign" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_slashed_locometal" | "create:track_signal" | "minecraft:recipes/building_blocks/polished_andesite_stairs" | "create:recipes/decorations/copper_scaffolding_from_ingots_copper_stonecutting" | "minecraft:recipes/transportation/furnace_minecart" | "minecraft:recipes/building_blocks/stone_brick_slab_from_stone_bricks_stonecutting" | "minecraft:nether/root" | "immersiveengineering:main/secret_friedbird" | "minecraft:recipes/misc/spire_armor_trim_smithing_template" | "extrastorage:recipes/misc/disk/shapeless/disk_262144k_fluid" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_flat_slashed_locometal" | "minecraft:recipes/building_blocks/stone_slab_from_stone_stonecutting" | "exmachinis:recipes/misc/comparator_upgrade" | "immersiveengineering:recipes/misc/crafting/alu_wallmount" | "railways:recipes/misc/crafting/palettes/wrapping/gray_brass_wrapped_locometal" | "create:recipes/misc/crafting/kinetics/track_observer_from_other_plates" | "farmersdelight:recipes/misc/canvas_from_canvas_rug" | "exdeorum:recipes/misc/dark_oak_crucible" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_locometal_boiler" | "immersiveengineering:recipes/misc/crafting/powerpack" | "create:recipes/misc/crafting/materials/small_rose_quartz_tilesfrom_conversion" | "create:musical_arm" | "extradisks:recipes/misc/blocks/16384k_storage_block" | "extradisks:recipes/misc/blocks/1024k_storage_block" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_network_transmitter" | "mobdropsrecipes_overworld:recipes/misc/essence_into_rotten_flesh" | "minecraft:recipes/tools/flint_and_steel" | "minecraft:recipes/building_blocks/dye_purple_carpet" | "minecraft:recipes/building_blocks/nether_bricks" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_flat_slashed_locometal" | "create:recipes/building_blocks/andesite_pillar_from_stone_types_andesite_stonecutting" | "minecraft:recipes/decorations/end_stone_brick_wall_from_end_stone_brick_stonecutting" | "create:recipes/building_blocks/scorchia_from_stone_types_scorchia_stonecutting" | "minecraft:recipes/misc/sugar_from_sugar_cane" | "refinedstorage:recipes/misc/coloring_recipes/pink_grid" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_flat_riveted_locometal" | "minecraft:recipes/building_blocks/dye_magenta_bed" | "minecraft:recipes/decorations/respawn_anchor" | "immersiveengineering:recipes/misc/crafting/survey_tools" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_plated_locometal" | "immersiveengineering:recipes/misc/stonecutting/stairs_concrete_leaded" | "create:recipes/building_blocks/cut_calcite_brick_stairs_from_stone_types_calcite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_plated_locometal" | "minecraft:recipes/decorations/white_banner" | "copycats:recipes/crafting/copycat_slab_from_beams" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_locometal_smokebox" | "immersiveengineering:main/craft_router" | "minecraft:recipes/decorations/mossy_cobblestone_wall" | "create:recipes/building_blocks/cut_veridium_slab_recycling" | "minecraft:nether/get_wither_skull" | "immersiveengineering:recipes/misc/crafting/insulating_glass_from_slab" | "refinedstorage:conditional_connecting" | "minecraft:recipes/building_blocks/dye_magenta_wool" | "railways:recipes/misc/crafting/palettes/wrapping/red_iron_wrapped_locometal" | "create:recipes/building_blocks/polished_cut_scorchia_slab" | "minecraft:recipes/decorations/diorite_wall_from_diorite_stonecutting" | "farmersdelight:recipes/misc/straw" | "railways:recipes/misc/crafting/big_buffer" | "create:recipes/misc/crafting/kinetics/magenta_valve_handle_from_other_valve_handle" | "refinedstorage:recipes/misc/coloring_recipes/red_controller" | "create:recipes/building_blocks/small_granite_brick_slab_from_stone_types_granite_stonecutting" | "minecraft:recipes/tools/wooden_pickaxe" | "immersiveengineering:recipes/misc/crafting/speedloader" | "minecraft:recipes/building_blocks/cobbled_deepslate_stairs" | "minecraft:recipes/building_blocks/mossy_stone_brick_stairs" | "create:recipes/misc/crafting/kinetics/cyan_valve_handle_from_other_valve_handle" | "create:recipes/building_blocks/polished_cut_tuff_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_flat_slashed_locometal" | "create:recipes/building_blocks/cut_tuff_brick_slab" | "minecraft:recipes/building_blocks/dark_oak_wood" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_flat_riveted_locometal" | "refinedstorage:recipes/misc/coloring_recipes/orange_disk_manipulator" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_copper_wrapped_locometal" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone_from_polished_blackstone_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_orange_from_slab" | "minecraft:recipes/misc/diamond_from_smelting_diamond_ore" | "exdeorum:recipes/misc/acacia_crucible" | "extradisks:recipes/misc/disk/shapeless/65536k_fluid_storage_disk" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_flat_riveted_locometal" | "create:recipes/building_blocks/cut_andesite_wall" | "immersiveengineering:recipes/misc/crafting/treated_wood_packaged_to_slab" | "farmersdelight:main/root" | "create:recipes/building_blocks/polished_cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "railways:recipes/combat/dying_existing_cap_white" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_blue_from_slab" | "farmersdelight:recipes/food/mixed_salad" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_yellow_to_slab" | "minecraft:recipes/food/baked_potato_from_smoking" | "immersiveengineering:recipes/misc/crafting/blastbrick_to_slab" | "create:recipes/building_blocks/small_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "create:recipes/building_blocks/cut_dripstone_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/cut_andesite_stairs_from_stone_types_andesite_stonecutting" | "minecraft:recipes/building_blocks/smooth_sandstone_stairs" | "create:recipes/building_blocks/cut_scoria_brick_stairs_from_stone_types_scoria_stonecutting" | "create:recipes/misc/smelting/ingot_silver_compat_ic2" | "railways:recipes/misc/stonecutting/palettes/cycling/white_slashed_locometal" | "minecraft:recipes/decorations/black_stained_glass_pane_from_glass_pane" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_copper_wrapped_locometal_boiler" | "create:recipes/misc/crafting/kinetics/linear_chassisfrom_conversion" | "create:recipes/building_blocks/small_scoria_brick_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_8x/black_iron_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_flat_slashed_locometal" | "minecraft:recipes/decorations/red_candle" | "minecraft:recipes/misc/lapis_lazuli" | "minecraft:story/upgrade_tools" | "farmersdelight:recipes/building_blocks/packed_mud_from_straw" | "refinedstorage:recipes/misc/coloring_recipes/blue_network_transmitter" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_waxed_exposed_cut_copper_stonecutting" | "farmersdelight:recipes/decorations/painting_from_canvas" | "create:recipes/building_blocks/cut_deepslate_brick_slab" | "create:recipes/building_blocks/cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "minecraft:recipes/misc/eye_armor_trim_smithing_template" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_slashed_locometal" | "immersiveengineering:recipes/misc/crafting/fluorescent_tube" | "immersiveengineering:recipes/misc/crafting/steel_wallmount" | "create:recipes/misc/crafting/kinetics/crafter_slot_cover" | "farmersdelight:main/master_chef" | "create:diving_suit_lava" | "minecraft:recipes/misc/sentry_armor_trim_smithing_template_smithing_trim" | "vegandelight:tutorial/tofish" | "farmersdelight:main/use_cutting_board" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_copper_wrapped_locometal_boiler" | "create:arm_blaze_burner" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "create:cuckoo_clock" | "create:recipes/misc/smelting/silver_ingot_compat_thermal" | "easy_mob_farm:recipes/upgrade/enchancement/sword_enhancement" | "farmersdelight:recipes/cooking/bone_broth" | "minecraft:husbandry/tactical_fishing" | "create:recipes/building_blocks/cut_granite_stairs_from_stone_types_granite_stonecutting" | "easy_mob_farm:recipes/mob_farm_template/tier2_mob_farm_template" | "create:recipes/misc/crafting/logistics/powered_toggle_latch" | "exmachinis:netherite_upgrade" | "mobdropsrecipes_overworld:recipes/misc/overworld_essence_rare" | "extradisks:recipes/misc/blocks/262144k_fluid_storage_block" | "create:recipes/building_blocks/polished_cut_andesite_wall_from_stone_types_andesite_stonecutting" | "railways:recipes/misc/stonecutting/palettes/cycling/purple_riveted_locometal" | "refinedstorage:recipes/misc/pattern_grid/brown_pattern_grid" | "minecraft:adventure/salvage_sherd" | "mobdropsrecipes_overworld:recipes/misc/phantom_membrane" | "refinedstorage:recipes/misc/coloring_recipes/cyan_crafting_grid" | "immersiveengineering:recipes/misc/stonecutting/slab_concrete" | "railways:recipes/misc/crafting/palettes/dyeing_8x/cyan_flat_slashed_locometal" | "immersiveengineering:main/chute_bonk" | "immersiveengineering:recipes/misc/stonecutting/slab_concrete_tile" | "immersiveengineering:recipes/misc/crafting/hammer" | "refinedstorage:recipes/misc/coloring_recipes/brown_crafting_monitor" | "create:recipes/building_blocks/cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "comforts:hammock_cyan" | "minecraft:story/cure_zombie_villager" | "create:recipes/building_blocks/small_calcite_bricks_from_stone_types_calcite_stonecutting" | "exmachinis:flux_compactor" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_iron_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_brass_wrapped_locometal" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingle_stairs_from_honeycomb" | "create:recipes/building_blocks/small_granite_bricks_from_stone_types_granite_stonecutting" | "farmersdelight:recipes/misc/gold_nugget_from_blasting_knife" | "create:recipes/building_blocks/crafting/copper/waxed_weathered_copper_tile_stairs_from_honeycomb" | "immersiveengineering:recipes/misc/crafting/alu_fence" | "minecraft:recipes/redstone/mangrove_trapdoor" | "immersiveengineering:recipes/misc/crafting/plate_silver_hammering" | "minecraft:recipes/tools/recovery_compass" | "create:recipes/building_blocks/oxidized_copper_shingle_stairs_from_oxidized_copper_shingles_stonecutting" | "sophisticatedbackpacks:recipes/misc/upgrade_base" | "minecraft:recipes/redstone/oak_pressure_plate" | "exdeorum:recipes/misc/spruce_sieve" | "refinedstorage:recipes/misc/coloring_recipes/blue_relay" | "create:recipes/building_blocks/small_dripstone_brick_slab_from_stone_types_dripstone_stonecutting" | "farmersdelight:recipes/decorations/bamboo_cabinet" | "immersiveengineering:main/buy_oremap" | "minecraft:recipes/building_blocks/polished_blackstone_stairs_from_polished_blackstone_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/purple_crafting_grid" | "create:recipes/misc/crafting/kinetics/schedule" | "railways:recipes/misc/crafting/palettes/dyeing_8x/green_plated_locometal" | "minecraft:recipes/redstone/dropper" | "create:recipes/building_blocks/cut_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "create:drain" | "comforts:hammock_light_blue" | "minecraft:end/find_end_city" | "create:recipes/building_blocks/oxidized_copper_tile_slab" | "minecraft:recipes/redstone/mangrove_fence_gate" | "refinedstorage:recipes/misc/coloring_recipes/relay" | "create:recipes/misc/blasting/ingot_uranium_compat_mekanism" | "create:recipes/building_blocks/polished_cut_scoria_slab_recycling" | "create:recipes/building_blocks/cut_deepslate_brick_slab_from_stone_types_deepslate_stonecutting" | "create:recipes/building_blocks/mangrove_window" | "create:recipes/building_blocks/warped_window_pane" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_slashed_locometal" | "create:recipes/building_blocks/cut_veridium_brick_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_brass_wrapped_locometal_boiler" | "create:recipes/building_blocks/polished_cut_veridium_wall" | "immersiveengineering:recipes/misc/crafting/metal_barrel" | "minecraft:recipes/building_blocks/dye_light_blue_carpet" | "minecraft:recipes/building_blocks/polished_andesite" | "immersiveengineering:recipes/misc/crafting/treated_wood_packaged_from_vertical" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_boots_from_blasting" | "minecraft:recipes/decorations/lime_glazed_terracotta" | "refinedstorage:recipes/misc/coloring_recipes/pink_crafter" | "minecraft:recipes/building_blocks/purpur_block" | "refinedstorage:recipes/misc/coloring_recipes/orange_network_transmitter" | "railways:recipes/misc/crafting/palettes/wrapping/green_iron_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_white_from_slab" | "create:recipes/building_blocks/small_andesite_brick_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_slashed_locometal" | "railways:recipes/misc/crafting/palettes/wrapping/magenta_iron_wrapped_locometal" | "vegandelight:tutorial/soymilk" | "exdeorum:recipes/misc/mangrove_compressed_sieve" | "immersiveengineering:recipes/misc/crafting/tinted_glass_lead_wire" | "create:recipes/misc/crafting/kinetics/cogwheel" | "create:recipes/building_blocks/cut_tuff_slab_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab_from_exposed_cut_copper_stonecutting" | "exdeorum:recipes/tools/diamond_watering_can" | "minecraft:recipes/transportation/carrot_on_a_stick" | "railways:recipes/misc/crafting/palettes/wrapping/purple_copper_wrapped_locometal" | "ironchest:recipes/decorations/upgrades/iron_to_gold_chest_upgrade" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_helmet" | "farmersdelight:recipes/misc/pumpkin_seeds_from_slice" | "minecraft:recipes/building_blocks/polished_granite" | "farmersdelight:main/use_skillet" | "create:recipes/building_blocks/small_dripstone_brick_wall" | "immersiveengineering:recipes/misc/crafting/treated_post" | "refinedstorage:portable_storage" | "immersiveengineering:recipes/misc/crafting/wirecoil_redstone" | "minecraft:recipes/redstone/birch_trapdoor" | "railways:recipes/misc/crafting/palettes/wrapping/red_copper_wrapped_locometal" | "create:recipes/building_blocks/cut_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "farmersdelight:main/eat_nourishing_food" | "copycats:recipes/misc/stonecutting/copycat_ladder" | "minecraft:recipes/redstone/spruce_trapdoor" | "minecraft:recipes/building_blocks/muddy_mangrove_roots" | "minecraft:recipes/building_blocks/red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:recipes/misc/quartz" | "create:recipes/building_blocks/crafting/kinetics/magenta_seat_from_other_seat" | "create:recipes/building_blocks/polished_cut_asurine_from_stone_types_asurine_stonecutting" | "peco:recipes/misc/discs" | "refinedstorage:recipes/misc/coloring_recipes/magenta_network_transmitter" | "railways:recipes/misc/crafting/palettes/dyeing_8x/white_plated_locometal" | "minecraft:end/respawn_dragon" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "minecraft:recipes/decorations/soul_campfire" | "sophisticatedbackpacks:recipes/misc/copper_backpack" | "comforts:hammock_green" | "farmersdelight:recipes/decorations/yellow_hanging_canvas_sign" | "create:recipes/building_blocks/cut_deepslate_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_copper_wrapped_locometal" | "minecraft:recipes/building_blocks/warped_slab" | "refinedstorage:recipes/misc/pattern_grid/pink_pattern_grid" | "minecraft:recipes/food/cooked_mutton_from_campfire_cooking" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_cyan" | "create:recipes/misc/smelting/ingot_uranium_compat_immersiveengineering" | "immersiveengineering:recipes/misc/crafting/fluid_sorter" | "create:recipes/building_blocks/polished_cut_dripstone_slab" | "farmersdelight:recipes/decorations/light_gray_hanging_canvas_sign" | "immersiveengineering:recipes/misc/smelting/ingot_hop_graphite_from_blasting" | "farmersdelight:main/harvest_straw" | "exdeorum:recipes/misc/cherry_barrel" | "minecraft:recipes/redstone/spruce_door" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_flat_slashed_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_locometal_pillar" | "minecraft:recipes/building_blocks/crimson_hyphae" | "minecraft:recipes/building_blocks/dye_orange_wool" | "minecraft:recipes/building_blocks/yellow_concrete_powder" | "mcwfurnitures:recipes/mangrove" | "minecraft:recipes/redstone/spruce_fence_gate" | "farmersdelight:recipes/decorations/scaffolding_from_canvas" | "farmersdelight:recipes/cooking/pasta_with_mutton_chop" | "farmersdelight:recipes/decorations/purple_canvas_sign" | "refinedstorage:recipes/misc/coloring_recipes/orange_crafting_monitor" | "minecraft:recipes/building_blocks/purple_stained_glass" | "refinedstorage:recipes/misc/coloring_recipes/purple_pattern_grid" | "immersiveengineering:main/buy_shaderbag" | "minecraft:recipes/building_blocks/chiseled_stone_bricks_stone_from_stonecutting" | "farmersdelight:recipes/decorations/white_canvas_sign" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_slashed_locometal" | "immersiveengineering:recipes/misc/crafting/grit_sand" | "immersiveengineering:recipes/misc/stonecutting/stairs_hempcrete_brick" | "vegandelight:tutorial/tofu" | "create:recipes/misc/crafting/appliances/dough" | "create:recipes/building_blocks/weathered_copper_tile_stairs_from_weathered_copper_tiles_stonecutting" | "create:recipes/building_blocks/crafting/kinetics/light_gray_seat_from_other_seat" | "farmersdelight:recipes/decorations/acacia_cabinet" | "create:recipes/building_blocks/cut_limestone_slab_recycling" | "refinedstorage:recipes/misc/coloring_recipes/yellow_network_receiver" | "laserio:recipes/misc/laser_connector_advanced" | "minecraft:recipes/decorations/blue_carpet" | "refinedstorage:recipes/misc/coloring_recipes/orange_fluid_grid" | "minecraft:recipes/misc/snout_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/dye_white_wool" | "immersiveengineering:recipes/misc/crafting/ersatz_leather" | "exdeorum:recipes/misc/ores/iridium_tag" | "minecraft:recipes/decorations/light_blue_glazed_terracotta" | "farmersdelight:recipes/decorations/pink_canvas_sign" | "extrastorage:recipes/misc/disk/shaped/disk_4096k" | "create:recipes/misc/blasting/gold_ingot_from_crushed" | "exdeorum:recipes/misc/cherry_crucible" | "create:recipes/building_blocks/polished_cut_diorite_from_stone_types_diorite_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/red_flat_riveted_locometal" | "minecraft:recipes/misc/dirt_from_compressed_dirt" | "mcwfurnitures:recipes/warped" | "refinedstorage:recipes/misc/coloring_recipes/red_wireless_transmitter" | "create:recipes/misc/crafting/kinetics/contraption_controls" | "create:recipes/building_blocks/polished_cut_asurine_slab_from_stone_types_asurine_stonecutting" | "create:recipes/building_blocks/small_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "farmersdelight:recipes/decorations/rope_from_safety_net" | "minecraft:recipes/building_blocks/prismarine_stairs" | "create:recipes/misc/crafting/kinetics/flywheel" | "minecraft:recipes/building_blocks/polished_blackstone_from_blackstone_stonecutting" | "immersiveengineering:recipes/misc/crafting/storage_constantan_to_ingot_constantan" | "exdeorum:recipes/misc/unfired_porcelain_bucket" | "create:recipes/misc/crafting/kinetics/hose_pulley" | "immersiveengineering:recipes/misc/crafting/windmill" | "immersiveengineering:tools/craft_drill" | "create:recipes/misc/crafting/curiosities/brown_toolbox" | "immersiveengineering:recipes/misc/stonecutting/stairs_concrete_tile" | "minecraft:recipes/building_blocks/deepslate_tiles_from_polished_deepslate_stonecutting" | "copycats:recipes/crafting/copycat_trapdoor_from_conversion" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_copper_wrapped_locometal" | "comforts:hammock_lime" | "exdeorum:recipes/tools/compressed_golden_hammer" | "minecraft:recipes/decorations/polished_blackstone_wall_from_polished_blackstone_stonecutting" | "farmersdelight:recipes/decorations/yellow_canvas_sign" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_honeycomb" | "minecraft:recipes/building_blocks/deepslate_tiles_from_deepslate_bricks_stonecutting" | "copycats:recipes/crafting/copycat_vertical_slice_from_conversion" | "minecraft:recipes/building_blocks/dripstone_block" | "minecraft:recipes/building_blocks/mangrove_wood" | "immersiveengineering:recipes/misc/smelting/ingot_silver" | "create:recipes/building_blocks/small_ochrum_brick_wall" | "railways:recipes/misc/crafting/palettes/wrapping/light_gray_brass_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/sheetmetal_silver_to_slab" | "minecraft:adventure/avoid_vibration" | "create:recipes/building_blocks/small_tuff_brick_wall_from_stone_types_tuff_stonecutting" | "create:contraption_actors" | "minecraft:recipes/misc/gold_ingot_from_smelting_nether_gold_ore" | "create:recipes/building_blocks/polished_cut_diorite_slab_from_stone_types_diorite_stonecutting" | "railways:recipes/combat/dying_existing_cap_blue" | "create:recipes/building_blocks/crafting/kinetics/white_seat" | "farmersdelight:recipes/decorations/red_canvas_sign" | "railways:recipes/misc/stonecutting/palettes/cycling/gray_locometal_smokebox" | "immersiveengineering:multiblocks/mb_tank" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum_from_dust" | "create:recipes/building_blocks/cut_calcite_brick_slab" | "minecraft:recipes/building_blocks/yellow_stained_glass" | "extradisks:recipes/misc/part/65536k_storage_part" | "refinedstorage:recipes/misc/pattern_grid/purple_pattern_grid" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/spire_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/decorations/acacia_fence" | "create:recipes/building_blocks/polished_cut_deepslate_from_stone_types_deepslate_stonecutting" | "create:recipes/combat/crafting/appliances/netherite_diving_helmet" | "create:recipes/building_blocks/rose_quartz_tiles_from_polished_rose_quartz_stonecutting" | "minecraft:recipes/misc/iron_ingot_from_blasting_deepslate_iron_ore" | "minecraft:recipes/building_blocks/dye_brown_carpet" | "create:recipes/building_blocks/small_limestone_brick_slab_recycling" | "farmersdelight:recipes/decorations/red_hanging_canvas_sign" | "minecraft:recipes/redstone/mangrove_button" | "minecraft:nether/return_to_sender" | "farmersdelight:recipes/cooking/tomato_sauce" | "minecraft:recipes/building_blocks/sandstone" | "refinedstorage:recipes/misc/coloring_recipes/black_crafting_monitor" | "create:recipes/building_blocks/crafting/copper/waxed_copper_shingles_from_honeycomb" | "railways:recipes/combat/dying_existing_cap_orange" | "exdeorum:recipes/misc/ores/lithium_tag" | "easy_mob_farm:recipes/mob_catcher/mystic_binding_crystal" | "farmersdelight:recipes/cooking/ratatouille" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_plated_locometal" | "farmersdelight:recipes/misc/tomato_seeds" | "railways:recipes/misc/crafting/palettes/dyeing_1x/brown_locometal_smokebox" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_brown_from_slab" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_slashed_locometal" | "create:recipes/building_blocks/cut_scoria_brick_slab_from_stone_types_scoria_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/pink_security_manager" | "immersiveengineering:recipes/misc/crafting/ingot_silver_to_nugget_silver" | "minecraft:recipes/building_blocks/polished_basalt_from_basalt_stonecutting" | "create:recipes/building_blocks/small_scorchia_brick_slab" | "immersiveengineering:recipes/misc/crafting/earmuffs" | "create:recipes/building_blocks/polished_cut_diorite_slab_recycling" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_plated_locometal" | "railways:recipes/combat/dying_existing_cap_lime" | "create:recipes/building_blocks/polished_cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_boots" | "minecraft:recipes/building_blocks/white_wool_from_string" | "copycats:recipes/misc/stonecutting/copycat_board" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_flat_riveted_locometal" | "minecraft:recipes/decorations/yellow_banner" | "exdeorum:recipes/misc/cooked_silk_worm_from_smoking" | "minecraft:recipes/decorations/brown_stained_glass_pane_from_glass_pane" | "minecraft:husbandry/obtain_sniffer_egg" | "refinedstorage:recipes/misc/coloring_recipes/orange_crafting_grid" | "minecraft:recipes/building_blocks/deepslate_brick_slab" | "minecraft:recipes/building_blocks/polished_diorite_stairs_from_polished_diorite_stonecutting" | "refinedstorage:pattern_creation" | "minecraft:recipes/decorations/brick_wall_from_bricks_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab_from_exposed_copper_stonecutting" | "immersiveengineering:recipes/misc/smelting/ingot_aluminum_from_blasting" | "create:recipes/building_blocks/cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "laserio:recipes/misc/filter_tag" | "mobdropsrecipes_overworld:recipes/misc/trident" | "minecraft:recipes/redstone/polished_blackstone_pressure_plate" | "farmersdelight:recipes/building_blocks/organic_compost_from_rotten_flesh" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_standard" | "immersiveengineering:recipes/misc/crafting/gunpart_hammer" | "create:recipes/building_blocks/small_deepslate_brick_wall" | "comforts:hammock_blue" | "farmersdelight:recipes/building_blocks/rice_bag" | "minecraft:recipes/food/cooked_cod_from_campfire_cooking" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_flat_riveted_locometal" | "create:recipes/building_blocks/cut_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "minecraft:recipes/decorations/magenta_stained_glass_pane_from_glass_pane" | "refinedstorage:recipes/misc/coloring_recipes/fluid_grid" | "immersiveengineering:recipes/misc/crafting/nugget_nickel_to_ingot_nickel" | "refinedstorage:recipes/misc/pattern_grid/yellow_pattern_grid" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_copper_wrapped_locometal" | "minecraft:recipes/misc/pink_dye_from_red_white_dye" | "comforts:hammock_white" | "immersiveengineering:recipes/misc/smelting/nugget_aluminum_recycle_faraday_chestplate" | "create:recipes/building_blocks/small_veridium_brick_slab_from_stone_types_veridium_stonecutting" | "immersiveengineering:recipes/misc/smelting/nugget_steel_recycle_steel_leggings" | "minecraft:recipes/brewing/blaze_powder" | "minecraft:recipes/redstone/jungle_pressure_plate" | "minecraft:end/root" | "create:recipes/misc/crafting/kinetics/clockwork_bearing" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_slashed_locometal" | "refinedstorage:recipes/misc/coloring_recipes/cyan_crafting_monitor" | "refinedstorage:recipes/misc/coloring_recipes/yellow_crafter" | "sophisticatedbackpacks:recipes/misc/chipped/loom_table_upgrade" | "minecraft:recipes/misc/diamond_from_blasting_diamond_ore" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_polished_blackstone_stonecutting" | "create:recipes/building_blocks/dripstone_pillar_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/decorations/moss_carpet" | "create:recipes/misc/blasting/ingot_nickel_compat_immersiveengineering" | "immersiveengineering:recipes/misc/crafting/current_transformer" | "immersiveengineering:recipes/misc/smelting/iron_ingot_from_dust" | "minecraft:recipes/building_blocks/polished_diorite_slab_from_polished_diorite_stonecutting" | "farmersdelight:recipes/food/stuffed_potato" | "railways:recipes/misc/stonecutting/palettes/cycling/white_flat_slashed_locometal" | "minecraft:recipes/decorations/cyan_stained_glass_pane_from_glass_pane" | "minecraft:recipes/decorations/blackstone_wall_from_blackstone_stonecutting" | "farmersdelight:recipes/food/fruit_salad" | "peco:recipes/misc/ghast_tear" | "farmersdelight:recipes/decorations/light_blue_hanging_canvas_sign" | "immersiveengineering:recipes/misc/crafting/firework" | "minecraft:recipes/redstone/crimson_fence_gate" | "cabletiers:mega_importer" | "exdeorum:recipes/misc/mangrove_barrel" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper" | "create:recipes/building_blocks/cut_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "create:copper_casing" | "extrastorage:recipes/misc/disk/shaped/disk_1024k" | "enchantinginfuser:recipes/decorations/enchanting_infuser" | "minecraft:recipes/building_blocks/amethyst_block" | "create:recipes/misc/crafting/kinetics/vertical_gearbox" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_riveted_locometal" | "immersiveengineering:recipes/misc/crafting/wire_lead" | "minecraft:husbandry/obtain_netherite_hoe" | "minecraft:recipes/building_blocks/gray_concrete_powder" | "minecraft:recipes/decorations/light_gray_banner" | "create:foods" | "refinedstorage:recipes/misc/pattern_grid/gray_pattern_grid" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_locometal_smokebox" | "copycats:recipes/crafting/copycat_slab_from_panels" | "railways:recipes/misc/crafting/palettes/dyeing_8x/purple_flat_riveted_locometal" | "comforts:hammock_light_gray" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_locometal_pillar" | "refinedstorage:recipes/misc/coloring_recipes/light_gray_wireless_transmitter" | "minecraft:recipes/tools/iron_axe" | "railways:recipes/misc/stonecutting/palettes/cycling/brown_flat_riveted_locometal" | "cabletiers:ultra_interface" | "minecraft:recipes/building_blocks/glowstone" | "minecraft:recipes/building_blocks/sea_lantern" | "create:recipes/building_blocks/oak_window" | "refinedstorage:recipes/misc/coloring_recipes/red_crafter_manager" | "railways:recipes/misc/crafting/palettes/dyeing_1x/lime_iron_wrapped_locometal_boiler" | "create:recipes/misc/crafting/curiosities/peculiar_bell" | "railways:recipes/misc/crafting/palettes/dyeing_1x/black_brass_wrapped_locometal" | "immersiveengineering:main/place_windmill" | "create:recipes/building_blocks/polished_cut_diorite_slab" | "minecraft:recipes/decorations/cartography_table" | "create:recipes/misc/blasting/zinc_ingot_from_crushed" | "create:recipes/building_blocks/small_limestone_brick_wall" | "minecraft:recipes/building_blocks/deepslate_tile_slab" | "immersiveengineering:recipes/misc/smelting/ingot_uranium_from_blasting3" | "minecraft:recipes/building_blocks/polished_diorite_from_diorite_stonecutting" | "immersiveengineering:recipes/misc/smelting/ingot_uranium_from_blasting2" | "create:recipes/building_blocks/small_calcite_brick_wall" | "farmersdelight:recipes/food/tomato" | "minecraft:recipes/building_blocks/chiseled_deepslate" | "minecraft:recipes/building_blocks/nether_brick_slab_from_nether_bricks_stonecutting" | "refinedstorage:recipes/misc/fluid_grid/brown_fluid_grid" | "create:recipes/misc/crafting/kinetics/nixie_tube" | "minecraft:recipes/misc/iron_nugget_from_blasting" | "railways:recipes/misc/crafting/small_buffer" | "sophisticatedbackpacks:recipes/misc/restock_upgrade" | "farmersdelight:recipes/food/mutton_wrap" | "immersiveengineering:recipes/misc/smelting/ingot_uranium_from_blasting" | "minecraft:adventure/kill_a_mob" | "refinedstorage:recipes/misc/coloring_recipes/security_manager" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_blue_slashed_locometal" | "immersiveengineering:recipes/misc/crafting/sheetmetal_aluminum_from_slab" | "create:pipe_organ" | "sophisticatedbackpacks:recipes/misc/gold_backpack" | "minecraft:husbandry/plant_any_sniffer_seed" | "create:recipes/building_blocks/crafting/kinetics/brown_seat_from_other_seat" | "minecraft:recipes/building_blocks/deepslate_bricks_from_cobbled_deepslate_stonecutting" | "create:recipes/misc/crafting/materials/rose_quartz_tilesfrom_conversion" | "refinedstorage:recipes/misc/coloring_recipes/gray_crafting_monitor" | "minecraft:adventure/adventuring_time" | "farmersdelight:recipes/food/cooked_cod_slice_from_campfire_cooking" | "exdeorum:recipes/misc/acacia_compressed_sieve" | "minecraft:recipes/building_blocks/dye_cyan_carpet" | "immersiveengineering:recipes/misc/crafting/storage_silver_to_slab" | "create:recipes/building_blocks/polished_cut_asurine_slab" | "immersiveengineering:recipes/misc/crafting/hemp_fabric" | "create:recipes/building_blocks/polished_cut_ochrum_wall_from_stone_types_ochrum_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_copper_wrapped_locometal" | "extradisks:recipes/misc/part/1048576k_fluid_storage_part" | "copycats:recipes/misc/stonecutting/copycat_fence" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_copper_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_locometal_pillar" | "create:recipes/building_blocks/cut_dripstone_brick_slab" | "create:recipes/building_blocks/cut_deepslate_bricks_from_stone_types_deepslate_stonecutting" | "exdeorum:recipes/misc/gold_ore" | "railways:recipes/misc/crafting/palettes/dyeing_1x/red_riveted_locometal" | "immersiveengineering:recipes/misc/crafting/sheetmetal_aluminum" | "minecraft:husbandry/plant_seed" | "immersiveengineering:recipes/misc/crafting/wirecutter" | "minecraft:nether/find_bastion" | "sliceanddice:recipes/misc/sprinkler" | "create:recipes/building_blocks/crafting/kinetics/lime_seat" | "railways:recipes/misc/crafting/palettes/wrapping/white_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/polished_andesite_slab_from_polished_andesite_stonecutting" | "exdeorum:recipes/misc/copper_ore" | "immersiveengineering:main/place_conveyor" | "refinedstorage:recipes/misc/coloring_recipes/black_crafter" | "refinedstorage:recipes/misc/coloring_recipes/green_relay" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_flat_slashed_locometal" | "minecraft:recipes/decorations/flower_pot" | "railways:recipes/misc/crafting/palettes/dyeing_1x/magenta_copper_wrapped_locometal" | "minecraft:recipes/misc/raw_iron" | "create:recipes/building_blocks/cut_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "create:recipes/building_blocks/cut_scoria_brick_slab" | "create:recipes/misc/smelting/silver_ingot_compat_galosphere" | "refinedstorage:recipes/misc/coloring_recipes/crafter" | "sophisticatedbackpacks:recipes/misc/tool_swapper_upgrade" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_deepslate_bricks_stonecutting" | "immersiveengineering:recipes/misc/crafting/treated_wood_horizontal_from_slab" | "create:recipes/building_blocks/layered_asurine_from_stone_types_asurine_stonecutting" | "railways:recipes/combat/dying_existing_cap_black" | "minecraft:recipes/misc/stick_from_bamboo_item" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper" | "minecraft:recipes/redstone/bamboo_fence_gate" | "minecraft:recipes/decorations/sandstone_wall" | "farmersdelight:recipes/food/chicken_sandwich" | "create:recipes/misc/crafting/kinetics/purple_valve_handle_from_other_valve_handle" | "create:recipes/misc/smelting/glass_from_vertical_framed_glass" | "exdeorum:recipes/misc/bamboo_barrel" | "create:fan_processing" | "immersiveengineering:recipes/misc/crafting/stairs_clinker_brick" | "immersiveengineering:recipes/misc/crafting/stairs_steel_scaffolding_wooden_top" | "minecraft:recipes/decorations/andesite_wall" | "minecraft:recipes/misc/end_stone_from_compressed_end_stone" | "minecraft:recipes/building_blocks/andesite_slab" | "minecraft:recipes/misc/light_gray_dye_from_oxeye_daisy" | "cabletiers:ultra_destructor" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_copper_wrapped_locometal_boiler" | "extrastorage:recipes/misc/disk/shaped/disk_16384k_fluid" | "create:water_supply" | "create:recipes/misc/crafting/kinetics/metal_bracket" | "immersiveengineering:recipes/misc/crafting/stairs_treated_wood_vertical" | "minecraft:recipes/misc/light_gray_dye_from_black_white_dye" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_flat_riveted_locometal" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_waxed_copper_block_stonecutting" | "create:recipes/building_blocks/cut_ochrum_slab_recycling" | "minecraft:recipes/building_blocks/cobblestone_stairs_from_cobblestone_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/blue_grid" | "immersiveengineering:recipes/misc/crafting/connector_lv_relay" | "comforts:sleeping_bag_lime" | "create:recipes/building_blocks/small_veridium_brick_wall" | "sophisticatedbackpacks:recipes/misc/auto_smoking_upgrade_from_auto_smelting_upgrade" | "create:recipes/building_blocks/layered_veridium_from_stone_types_veridium_stonecutting" | "refinedstorage:recipes/misc/crafting_grid/crafting_grid" | "immersiveengineering:recipes/misc/crafting/crate" | "refinedstorage:recipes/misc/coloring_recipes/red_pattern_grid" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_copper_wrapped_locometal_boiler" | "minecraft:recipes/misc/wheat" | "refinedstorage:recipes/misc/coloring_recipes/black_disk_manipulator" | "copycats:recipes/misc/stonecutting/copycat_byte" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_riveted_locometal" | "create:recipes/building_blocks/polished_cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "create:recipes/building_blocks/warped_window" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_locometal_smokebox" | "create:recipes/misc/crafting/kinetics/adjustable_chain_gearshift" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_brown_to_slab" | "minecraft:recipes/food/rabbit_stew_from_red_mushroom" | "minecraft:recipes/redstone/birch_pressure_plate" | "railways:recipes/misc/stonecutting/riveted_locometal" | "railways:recipes/transportation/jukeboxcart" | "minecraft:recipes/building_blocks/purpur_stairs_from_purpur_block_stonecutting" | "minecraft:recipes/tools/golden_hoe" | "minecraft:recipes/building_blocks/cut_red_sandstone_from_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/diorite_slab_from_diorite_stonecutting" | "create:recipes/misc/smelting/glass_from_horizontal_framed_glass" | "extradisks:recipes/misc/blocks/infinite_storage_block" | "create:recipes/building_blocks/polished_cut_deepslate_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_1x/cyan_plated_locometal" | "immersiveengineering:recipes/misc/crafting/toolupgrade_chemthrower_multitank" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_copper_wrapped_locometal_boiler" | "minecraft:recipes/decorations/pink_carpet" | "copycats:recipes/misc/stonecutting/copycat_shaft" | "create:portable_storage_interface" | "farmersdelight:recipes/decorations/purple_hanging_canvas_sign" | "immersiveengineering:recipes/misc/crafting/armor_steel_chestplate" | "immersiveengineering:recipes/misc/crafting/coal_coke_to_coke" | "immersiveengineering:recipes/misc/smelting/ingot_lead_from_dust_from_blasting" | "comforts:hammock_yellow" | "immersiveengineering:recipes/misc/crafting/armor_steel_leggings" | "create:conductor" | "immersiveengineering:multiblocks/mb_crusher" | "vegandelight:tutorial/smoked_tofu_slices" | "farmersdelight:recipes/decorations/cutting_board" | "immersiveengineering:recipes/misc/crafting/paper_from_sawdust" | "create:recipes/misc/blasting/ingot_lead_compat_mekanism" | "minecraft:recipes/building_blocks/cut_copper_slab_from_copper_block_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/black_network_receiver" | "minecraft:recipes/food/mushroom_stew" | "immersiveengineering:recipes/misc/crafting/ingot_uranium_to_nugget_uranium" | "immersiveengineering:recipes/misc/crafting/cloche" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab" | "immersiveengineering:recipes/misc/crafting/storage_silver_to_ingot_silver" | "create:recipes/misc/blasting/zinc_ingot_from_ore" | "immersiveengineering:recipes/misc/stonecutting/concrete_three_quarter" | "immersiveengineering:recipes/misc/crafting/item_batcher" | "minecraft:husbandry/balanced_diet" | "create:recipes/building_blocks/cut_dripstone_brick_stairs_from_stone_types_dripstone_stonecutting" | "minecraft:recipes/building_blocks/gray_terracotta" | "cabletiers:elite_exporter" | "refinedstorage:recipes/misc/pattern_grid/cyan_pattern_grid" | "exdeorum:recipes/misc/birch_compressed_sieve" | "farmersdelight:recipes/building_blocks/cabbage_crate" | "minecraft:recipes/food/cooked_cod" | "minecraft:recipes/tools/netherite_pickaxe_smithing" | "minecraft:nether/fast_travel" | "minecraft:recipes/building_blocks/bamboo_stairs" | "refinedstorage:recipes/misc/coloring_recipes/blue_security_manager" | "minecraft:recipes/building_blocks/dye_yellow_bed" | "farmersdelight:recipes/food/bacon_and_eggs" | "refinedstorage:recipes/misc/coloring_recipes/green_crafting_monitor" | "immersiveengineering:recipes/misc/crafting/toolupgrade_drill_waterproof" | "create:recipes/misc/crafting/materials/zinc_nugget_from_decompacting" | "sophisticatedbackpacks:recipes/misc/auto_blasting_upgrade_from_auto_smelting_upgrade" | "minecraft:recipes/building_blocks/bamboo_block" | "create:recipes/building_blocks/copper_shingle_slab_from_copper_shingles_stonecutting" | "create:precision_mechanism" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_brass_wrapped_locometal" | "minecraft:recipes/building_blocks/deepslate_tiles_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/dye_gray_wool" | "refinedstorage:recipes/misc/coloring_recipes/gray_network_receiver" | "immersiveengineering:recipes/misc/crafting/raw_block_aluminum_to_raw_aluminum" | "immersiveengineering:recipes/misc/crafting/sheetmetal_steel_to_slab" | "immersiveengineering:recipes/misc/crafting/sheetmetal_nickel" | "refinedstorage:recipes/misc/pattern_grid/black_pattern_grid" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_flat_riveted_locometal" | "minecraft:recipes/decorations/mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting" | "exdeorum:recipes/misc/birch_barrel" | "immersiveengineering:recipes/misc/crafting/stairs_slag_brick" | "exdeorum:recipes/misc/ores/cobalt_tag" | "minecraft:recipes/redstone/tnt" | "minecraft:recipes/decorations/black_stained_glass_pane" | "create:recipes/building_blocks/cut_tuff_bricks_from_stone_types_tuff_stonecutting" | "create:recipes/building_blocks/crafting/copper/waxed_exposed_copper_tile_slab_from_honeycomb" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_waxed_oxidized_copper_stonecutting" | "immersiveengineering:recipes/misc/crafting/charging_station" | "refinedstorage:root" | "railways:recipes/misc/crafting/palettes/dyeing_8x/brown_plated_locometal" | "create:recipes/building_blocks/small_scoria_bricks_from_stone_types_scoria_stonecutting" | "comforts:sleeping_bag_blue" | "exdeorum:recipes/misc/oak_compressed_sieve" | "minecraft:recipes/building_blocks/dye_gray_bed" | "farmersdelight:recipes/building_blocks/pumpkin_from_slices" | "exdeorum:recipes/tools/iron_hammer" | "create:recipes/building_blocks/small_limestone_brick_stairs" | "immersiveengineering:recipes/misc/crafting/turret_chem" | "refinedstorage:recipes/misc/coloring_recipes/green_detector" | "minecraft:recipes/decorations/enchanting_table" | "immersiveengineering:recipes/misc/crafting/watermill" | "create:recipes/misc/blasting/lead_ingot_compat_oreganized" | "create:recipes/misc/crafting/materials/rose_quartz" | "refinedstorage:recipes/misc/coloring_recipes/lime_security_manager" | "create:train_casing_00" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs_from_weathered_cut_copper_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/orange_network_receiver" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_plated_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_1x/blue_iron_wrapped_locometal_boiler" | "minecraft:recipes/tools/stone_hoe" | "minecraft:recipes/food/dried_kelp" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_blue" | "immersiveengineering:main/craft_workbench" | "immersiveengineering:recipes/misc/crafting/sheetmetal_colored_light_blue" | "minecraft:nether/use_lodestone" | "refinedstorage:recipes/misc/coloring_recipes/white_crafting_monitor" | "immersiveengineering:main/mb_blastfurnace" | "create:recipes/building_blocks/cut_calcite_slab_recycling" | "railways:recipes/misc/crafting/palettes/dyeing_8x/pink_brass_wrapped_locometal" | "cabletiers:mega_interface" | "minecraft:recipes/decorations/jungle_hanging_sign" | "railways:recipes/misc/stonecutting/palettes/cycling/lime_flat_riveted_locometal" | "minecraft:recipes/building_blocks/spruce_stairs" | "create:recipes/misc/blasting/silver_ingot_compat_iceandfire" | "sophisticatedbackpacks:recipes/misc/tank_upgrade" | "minecraft:recipes/building_blocks/mangrove_slab" | "sophisticatedbackpacks:recipes/misc/crafting_upgrade" | "railways:recipes/misc/stonecutting/palettes/cycling/pink_plated_locometal" | "minecraft:recipes/building_blocks/red_sandstone_stairs_from_red_sandstone_stonecutting" | "railways:recipes/misc/crafting/palettes/wrapping/magenta_copper_wrapped_locometal" | "railways:recipes/misc/crafting/palettes/dyeing_8x/blue_flat_slashed_locometal" | "create:recipes/building_blocks/layered_deepslate_from_stone_types_deepslate_stonecutting" | "exdeorum:recipes/tools/golden_hammer" | "minecraft:recipes/decorations/anvil" | "refinedstorage:recipes/misc/coloring_recipes/pink_wireless_transmitter" | "minecraft:recipes/decorations/black_candle" | "immersiveengineering:recipes/misc/crafting/conveyor_redstone" | "railways:recipes/misc/crafting/palettes/dyeing_1x/yellow_riveted_locometal" | "create:recipes/building_blocks/small_crimsite_brick_slab_from_stone_types_crimsite_stonecutting" | "create:recipes/misc/crafting/kinetics/item_vault" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_from_honeycomb" | "immersiveengineering:recipes/misc/crafting/jerrycan" | "immersiveengineering:recipes/misc/crafting/toolupgrade_powerpack_antenna" | "create:recipes/misc/crafting/materials/raw_zinc_block" | "create:recipes/building_blocks/exposed_copper_shingle_stairs" | "create:recipes/building_blocks/crafting/kinetics/gray_seat_from_other_seat" | "minecraft:recipes/decorations/mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting" | "refinedstorage:recipes/misc/coloring_recipes/white_grid" | "railways:recipes/misc/crafting/palettes/dyeing_1x/gray_locometal_smokebox" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_gray_slashed_locometal" | "immersiveengineering:recipes/misc/crafting/stairs_alu_scaffolding_standard" | "refinedstorage:recipes/misc/coloring_recipes/magenta_wireless_transmitter" | "immersiveengineering:recipes/misc/smelting/ingot_silver_from_dust_from_blasting" | "railways:recipes/misc/stonecutting/palettes/cycling/yellow_locometal_smokebox" | "farmersdelight:recipes/building_blocks/onion_crate" | "minecraft:recipes/decorations/loom" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_polished_deepslate_stonecutting" | "create:recipes/building_blocks/exposed_copper_tile_stairs_from_exposed_copper_tiles_stonecutting" | "minecraft:recipes/tools/diamond_axe" | "minecraft:recipes/building_blocks/end_stone_bricks_from_end_stone_stonecutting" | "minecraft:recipes/building_blocks/end_stone_brick_stairs_from_end_stone_stonecutting" | "create:recipes/misc/crafting/appliances/filter_clear" | "copycats:recipes/misc/stonecutting/copycat_half_layer" | "minecraft:recipes/misc/emerald_from_blasting_deepslate_emerald_ore" | "immersiveengineering:main/craft_drop_conveyor" | "minecraft:recipes/decorations/scaffolding" | "farmersdelight:recipes/cooking/vegetable_soup" | "exdeorum:recipes/tools/bone_crook" | "create:recipes/building_blocks/polished_cut_calcite_stairs" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_locometal_boiler" | "immersiveengineering:recipes/misc/crafting/treated_wood_vertical_to_slab" | "laserio:recipes/misc/filter_basic_nbtclear" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper" | "minecraft:recipes/building_blocks/diorite_stairs" | "minecraft:recipes/building_blocks/green_terracotta" | "comforts:sleeping_bag_yellow" | "railways:recipes/misc/crafting/palettes/dyeing_1x/light_blue_brass_wrapped_locometal" | "create:recipes/building_blocks/cut_granite_stairs" | "create:recipes/building_blocks/small_granite_brick_slab" | "easy_mob_farm:recipes/upgrade/filter/no_meat_filter" | "create:recipes/building_blocks/small_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "create:recipes/misc/crafting/kinetics/pink_valve_handle_from_other_valve_handle" | "minecraft:recipes/misc/raw_copper" | "refinedstorage:recipes/misc/pattern_grid/green_pattern_grid" | "create:recipes/building_blocks/copper_shingle_stairs_from_copper_shingles_stonecutting" | "exdeorum:recipes/misc/ores/tin_tag" | "immersiveengineering:multiblocks/mb_metalpress" | "create:recipes/building_blocks/small_crimsite_brick_slab" | "create:recipes/misc/crafting/kinetics/gearshift" | "extradisks:recipes/misc/disk/shaped/16384k_storage_disk" | "immersiveengineering:recipes/misc/crafting/minecart_reinforcedcrate" | "minecraft:recipes/building_blocks/mossy_stone_bricks_from_moss_block" | "railways:recipes/misc/crafting/palettes/dyeing_8x/yellow_locometal_smokebox" | "refinedstorage:recipes/misc/coloring_recipes/magenta_crafting_grid" | "minecraft:recipes/misc/skull_banner_pattern" | "mobdropsrecipes_overworld:recipes/misc/essence_into_prismarine_shard" | "immersiveengineering:recipes/misc/crafting/wirecoil_copper_ins" | "minecraft:story/root" | "minecraft:recipes/building_blocks/dye_black_wool" | "create:recipes/building_blocks/tiled_glass_from_glass_colorless_stonecutting" | "exdeorum:recipes/misc/netherite_mesh" | "exdeorum:recipes/tools/compressed_iron_hammer" | "railways:recipes/misc/crafting/palettes/dyeing_8x/magenta_iron_wrapped_locometal_boiler" | "immersiveengineering:recipes/misc/crafting/treated_wood_vertical_from_slab" | "create:recipes/building_blocks/cut_limestone_brick_slab" | "minecraft:recipes/brewing/brewing_stand" | "minecraft:recipes/root" | "farmersdelight:recipes/food/sweet_berry_cheesecake" | "create:recipes/building_blocks/crafting/kinetics/yellow_seat" | "railways:recipes/transportation/conductor_vent_from_industrial_iron_block_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_8x/light_gray_brass_wrapped_locometal_boiler" | "minecraft:recipes/misc/quartz_from_blasting" | "minecraft:recipes/building_blocks/acacia_planks" | "create:recipes/building_blocks/industrial_iron_block_from_ingots_iron_stonecutting" | "immersiveengineering:recipes/misc/crafting/sheetmetal_aluminum_to_slab" | "create:recipes/misc/crafting/appliances/slime_ball" | "immersiveengineering:recipes/misc/crafting/hempcrete_brick_to_slab" | "minecraft:recipes/redstone/iron_door" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_from_honeycomb" | "farmersdelight:recipes/food/honey_glazed_ham_block" | "refinedstorage:recipes/misc/coloring_recipes/green_crafter_manager" | "refinedstorage:recipes/misc/pattern_grid/light_gray_pattern_grid" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_grate_top_to_slab" | "minecraft:recipes/misc/copper_ingot_from_smelting_raw_copper" | "exdeorum:recipes/misc/crimson_sieve" | "railways:recipes/misc/crafting/palettes/dyeing_8x/orange_locometal_boiler" | "create:recipes/building_blocks/cut_tuff_wall_from_stone_types_tuff_stonecutting" | "minecraft:recipes/building_blocks/snow_block" | "immersiveengineering:recipes/misc/crafting/alu_scaffolding_grate_top_from_slab" | "immersiveengineering:recipes/misc/crafting/conveyor_splitter" | "copycats:recipes/misc/crafting/copycat_cogwheel" | "railways:recipes/misc/crafting/palettes/dyeing_1x/white_slashed_locometal" | "minecraft:recipes/building_blocks/blackstone_stairs_from_blackstone_stonecutting" | "create:recipes/building_blocks/cut_asurine_slab_recycling" | "minecraft:recipes/decorations/polished_blackstone_wall" | "create:recipes/building_blocks/cut_asurine_stairs" | "refinedstorage:recipes/misc/coloring_recipes/yellow_disk_manipulator" | "minecraft:recipes/transportation/dark_oak_boat" | "create:recipes/building_blocks/cut_asurine_brick_wall" | "minecraft:recipes/decorations/honeycomb_block" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs" | "exdeorum:recipes/building_blocks/compressed_crushed_blackstone" | "minecraft:recipes/misc/mojang_banner_pattern" | "create:recipes/building_blocks/crafting/copper/waxed_copper_tile_slab_from_honeycomb" | "minecraft:recipes/combat/golden_leggings" | "minecraft:recipes/redstone/piston" | "minecraft:recipes/misc/lapis_lazuli_from_smelting_lapis_ore" | "more_immersive_wires:recipes/rs_connector" | "railways:recipes/misc/crafting/palettes/dyeing_8x/gray_brass_wrapped_locometal" | "cabletiers:mega_exporter" | "railways:recipes/misc/stonecutting/palettes/cycling/blue_flat_slashed_locometal" | "sophisticatedbackpacks:recipes/misc/advanced_pickup_upgrade" | "vegandelight:tutorial/smoked_tofu" | "minecraft:recipes/food/cooked_beef_from_campfire_cooking" | "railways:recipes/misc/crafting/palettes/dyeing_1x/orange_flat_slashed_locometal" | "sophisticatedbackpacks:recipes/misc/iron_backpack" | "farmersdelight:recipes/food/fried_egg" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_polished_blackstone_stonecutting" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_brass_wrapped_locometal" | "immersiveengineering:recipes/misc/crafting/storage_electrum_to_ingot_electrum" | "immersiveengineering:recipes/misc/crafting/steel_scaffolding_standard_from_slab" | "railways:recipes/misc/crafting/palettes/dyeing_1x/pink_flat_slashed_locometal" | "create:recipes/building_blocks/vertical_framed_glass_pane" | "exmachinis:flux_hammer" | "railways:recipes/misc/crafting/palettes/dyeing_1x/purple_brass_wrapped_locometal_boiler" | "railways:recipes/misc/crafting/palettes/dyeing_8x/lime_flat_riveted_locometal" | "minecraft:recipes/decorations/light_gray_stained_glass_pane" | "create:recipes/building_blocks/polished_cut_scorchia_slab_recycling";
    type RecipeId = "createcompression:block/minecraft/end_stone/decompress/3x" | "farmersdelight:cutting/brown_mushroom_colony" | "exdeorum:compressed_sieve/crushed_blackstone/golden/black_dye" | "railways:sequenced_assembly/track_biomesoplenty_umbran_wide" | "create:milling/charcoal" | "mcwfurnitures:stripped_jungle_desk" | "exdeorum:compressed_sieve/dust/flint/gunpowder" | "immersiveengineering:crusher/ore_redstone" | "exmachinis:compacting/gold_ore" | "immersiveengineering:crafting/hempcrete_from_slab" | "create:milling/compat/environmental/violet" | "pedestals:augments/t1_capacity" | "minecraft:stonecutter" | "refinedstorage:coloring_recipes/pink_security_manager" | "immersiveengineering:crafting/gunpowder_from_dusts" | "minecraft:bone_block" | "createcompression:block/minecraft/end_stone/decompress/2x" | "pedestals:machines/upgrademodification/shearer/sheerer_superspeed" | "pedestals:machines/upgrademodification/import/import_fluid_capacity_tier_one" | "create:cut_granite_wall" | "minecraft:deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "engineeredcompatibility:cloche/botania/brown_petal_rich_soil" | "create:oak_window" | "farmersdelight:cutting/bamboo_trapdoor" | "engineeredcompatibility:cloche/culturaldelights/eggplant" | "mowlib:filters/vanilla/individual_mobs/filter_type_illusioner" | "pedestals:machines/upgrademodification/placer/placer_speed_tier_one" | "create:cut_diorite_from_stone_types_diorite_stonecutting" | "engineeredcompatibility:sawmill/avocado_log" | "sophisticatedbackpacks:void_upgrade" | "create:brass_ladder_from_ingots_brass_stonecutting" | "createcompression:block/minecraft/end_stone/decompress/5x" | "minecraft:cobblestone_wall" | "railways:crafting/palettes/dyeing_8x/light_gray_slashed_locometal" | "craftable_spawner_p:horse_spawn_egg" | "exdeorum:sieve/crushed_deepslate/flint/amethyst_shard" | "mobdropsrecipes_end:essence_into_ender_pearl" | "exdeorum:sieve/crushed_netherrack/iron/gold_nugget" | "engineersdecor:independent/small_tree_cutter_recipe" | "exdeorum:iron_mesh_from_flint_mesh" | "mob_grinding_utils:recipe_solidifier" | "minecraft:raw_copper" | "pedestals:machines/upgrademodification/fegenerator/fegenerator_speed_tier_two" | "railways:crafting/palettes/dyeing_1x/light_blue_iron_wrapped_locometal" | "exdeorum:compressed_sieve/crushed_deepslate/golden/gold_ore_chunk" | "immersiveengineering:crafting/storage_steel_from_slab" | "exdeorum:sieve/crushed_deepslate/diamond/diamond" | "create:splashing/endergetic/petrified_end_corrock_block" | "createcompression:block/minecraft/end_stone/decompress/4x" | "farmersdelight:cooked_chicken_cuts_from_smoking" | "create:crushing/compat/elementaryores/ore_lapis_end" | "immersiveengineering:blueprint/bullet_flare_yellow" | "immersiveengineering:stonecutting/hempcrete_pillar" | "minecraft:map_extending" | "exdeorum:sieve/crushed_end_stone/flint/chorus_flower" | "minecraft:spruce_sign" | "create:cutting/compat/regions_unexplored/joshua_wood" | "minecraft:cut_copper_slab_from_copper_block_stonecutting" | "create:crushing/raw_silver" | "sophisticatedbackpacks:advanced_refill_upgrade" | "minecraft:glow_item_frame" | "immersiveengineering:metalpress/bullet_casing" | "engineeredcompatibility:cloche/farmersdelight/tomato_rich_soil" | "mobdropsrecipes_overworld:essence_into_trident" | "exdeorum:compressed_sieve/moss_block/iron/yellow_autumn_sapling" | "railways:sequenced_assembly/track_bamboo_narrow" | "create:compacting/rock_candys/orange_rock_candy_craft" | "minecraft:copper_block" | "create:cutting/spruce_wood" | "railways:sequenced_assembly/track_tfc_white_cedar_wide" | "sliceanddice:slicer" | "mcwfurnitures:dark_oak_stool_chair" | "immersiveengineering:crusher/red_sandstone" | "farmingforblockheads:chicken_nest" | "createcompression:block/minecraft/cobbled_deepslate/decompress/9x" | "createcompression:block/minecraft/diamond/decompress/1x" | "railways:sequenced_assembly/track_crimson_narrow" | "rebornstorage:disks/large_item_disk" | "minecraft:green_stained_glass" | "create:cutting/crimson_hyphae" | "immersiveengineering:crafting/sheetmetal_colored_light_gray_from_slab" | "engineeredcompatibility:sawmill/aether_redux/crystal_log" | "create:small_veridium_brick_slab_recycling" | "minecraft:sandstone_slab_from_sandstone_stonecutting" | "immersiveengineering:crafting/sheetmetal_gold" | "pedestals:tools/tool_crafting/dualhanded_backwardslinkingtool" | "create_confectionery:ruby_chocolate_emptying" | "createcompression:block/minecraft/cobbled_deepslate/decompress/8x" | "immersiveengineering:crafting/hammercrushing_ardite" | "exdeorum:magic_sieve" | "engineeredcompatibility:arcfurnace/bloodmagic/dust_hellforged" | "createcompression:block/minecraft/diamond/decompress/2x" | "immersiveengineering:crafting/windmill_blade" | "immersiveengineering:metalpress/gear_zinc" | "mekanism:crushing/createcompression/stone/7x_to_7x_cobblestone" | "createcompression:block/minecraft/end_stone/decompress/1x" | "minecraft:cut_sandstone_slab" | "railways:crafting/palettes/dyeing_1x/gray_locometal_pillar" | "refinedstorage:coloring_recipes/fluid_grid" | "create_confectionery:gingerbread_bricks_recipe" | "railways:mechanical_crafting/green_locometal_boiler" | "pedestals:tools/tool_swap/augment_swapping/toolswap_capacity_to_storage" | "createcompression:block/minecraft/diamond/decompress/3x" | "create:cutting/compat/blue_skies/dusk_log" | "immersiveengineering:crafting/concrete_from_slab" | "mob_grinding_utils:beheading/zombie" | "exdeorum:sieve/crushed_deepslate/string/lead_ore_chunk" | "minecraft:mojang_banner_pattern" | "create:cutting/compat/regions_unexplored/cobalt_wood" | "copycats:stonecutting/copycat_iron_trapdoor" | "createcompression:block/minecraft/diamond/decompress/4x" | "engineersdecor:independent/dark_shingle_roof_chimneytrunk_recipe" | "minecraft:golden_hoe" | "create:cutting/stripped_warped_stem" | "minecraft:dye_green_bed" | "immersiveengineering:arcfurnace/raw_ore_uranium" | "exdeorum:sieve/crushed_deepslate/iron/copper_ore_chunk" | "createcompression:block/minecraft/soul_soil/compress/7x" | "mekanism:enriching/createcompression/red_sand/5x_to_5x_gravel" | "create:crushing/cobblestone/1x_to_1x_gravel" | "createcompression:block/minecraft/cobbled_deepslate/decompress/4x" | "farmersdelight:rice_roll_medley_block" | "createcompression:block/minecraft/cobbled_deepslate/decompress/5x" | "createcompression:block/minecraft/grass/compress/1x" | "create:crafting/kinetics/cyan_seat_from_other_seat" | "create:cutting/compat/biomesoplenty/stripped_umbran_log" | "mcwfurnitures:birch_desk" | "mcwfurnitures:stripped_cherry_cupboard_counter" | "railways:crafting/palettes/dyeing_1x/black_iron_wrapped_locometal" | "pedestals:machines/upgrademodification/import/import_item_capacity_tier_two" | "createcompression:block/minecraft/soul_soil/compress/8x" | "more_immersive_wires:rs_connector" | "farmingforblockheads:market" | "createcompression:block/minecraft/cobbled_deepslate/decompress/3x" | "createcompression:block/minecraft/grass/compress/2x" | "vegandelight:campfire_cooking/cooked_smoked_tofish_from_campfire_cooking" | "immersiveengineering:crusher/raw_block_platinum" | "exdeorum:barrel_compost/moss_block" | "exdeorum:hammer/gravel" | "minecraft:purpur_block" | "farmersdelight:cutting/smoked_ham" | "exdeorum:dark_oak_sieve" | "immersiveengineering:crusher/ore_nickel" | "pedestals:machines/cobblegen/generate_clay" | "createcompression:block/minecraft/soul_soil/compress/9x" | "railways:crafting/palettes/wrapping/iron_wrapped_locometal" | "minecraft:polished_blackstone_slab" | "railways:mechanical_crafting/red_copper_wrapped_locometal_boiler" | "mowlib:workcards/area_card" | "exdeorum:sieve/crushed_deepslate/flint/emerald" | "mowlib:filters/vanilla/individual_mobs/filter_type_elderguardian" | "farmersdelight:blue_canvas_sign" | "engineeredcompatibility:sawmill/homespun/ironwood_stairs" | "create:cutting/compat/botania/dreamwood_log" | "refinedstorage:coloring_recipes/brown_pattern_grid" | "refinedstorage:coloring_recipes/yellow_fluid_grid" | "createcompression:block/minecraft/cobbled_deepslate/decompress/7x" | "pedestals:machines/upgrademodification/breeder/breeder_range_tier_one" | "immersiveengineering:sawmill/mangrove_stairs" | "railways:sequenced_assembly/track_tfc_sequoia_wide" | "mcwfurnitures:stripped_spruce_striped_chair" | "minecraft:gray_concrete_powder" | "pedestals:machines/upgrademodification/pump/pump_speed_tier_two" | "immersiveengineering:sawmill/mangrove_log" | "create:crafting/kinetics/mechanical_roller" | "minecraft:redstone_from_blasting_redstone_ore" | "refinedstorage:coloring_recipes/white_detector" | "createcompression:block/minecraft/cobbled_deepslate/decompress/6x" | "exdeorum:compressed_sieve/gravel/string/zinc_ore_chunk" | "railways:crafting/track_coupler" | "exdeorum:compressed_sieve/crushed_deepslate/string/nickel_ore_chunk" | "peco:blaze_rod" | "railways:crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal_boiler" | "create:cutting/compat/twilightforest/stripped_mangrove_wood" | "comforts:hammock_to_green" | "engineeredcompatibility:crusher/hexcasting/amethyst_crystal" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "immersiveengineering:crafting/chute_steel" | "exdeorum:sieve/dirt/iron/carrot" | "createcompression:block/minecraft/end_stone/decompress/7x" | "mobdropsrecipes_nether:essence_into_wither_skeleton_skull" | "exdeorum:sieve/dust/diamond/sky_dust" | "create:cutting/compat/byg/green_enchanted_log" | "createcompression:block/minecraft/grass/compress/5x" | "railways:crafting/palettes/dyeing_1x/light_gray_brass_wrapped_locometal_boiler" | "refinedstorage:coloring_recipes/orange_wireless_transmitter" | "immersiveengineering:smelting/nugget_aluminum_recycle_faraday_chestplate_from_blasting" | "railways:crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal_boiler" | "createcompression:block/minecraft/end_stone/decompress/6x" | "engineersdecor:independent/slag_brick_stairs_recipe_decompose" | "mowlib:filters/vanilla/individual_mobs/baby/filter_type_strider_baby" | "refinedstorage:pattern_grid/gray_pattern_grid" | "immersiveengineering:mineral/auricupride" | "exdeorum:compressed_sieve/soul_sand/flint/glowstone_dust" | "create:item_application/brass_casing_from_log" | "createcompression:block/minecraft/grass/compress/6x" | "railways:crafting/palettes/dyeing_1x/pink_locometal_smokebox" | "create:splashing/light_gray_concrete_powder" | "create:cutting/compat/tconstruct/greenheart_log" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/mulberry" | "pedestals:upgrades/upgrade_fan" | "pedestals:augments/t2_storage" | "refinedstorage:coloring_recipes/brown_network_receiver" | "immersiveengineering:crafting/blastbrick" | "createcompression:block/minecraft/birch_plank/compress/9x" | "exdeorum:compressed_sieve/sand/iron/iron_nugget" | "railways:crafting/palettes/dyeing_1x/pink_riveted_locometal" | "create:cutting/compat/regions_unexplored/blue_bioshroom_stem" | "createcompression:block/minecraft/cobbled_deepslate/decompress/2x" | "create:smelting/ingot_silver_compat_ic2" | "exdeorum:fir_sieve" | "create:crafting/kinetics/chute" | "refinedstorage:coloring_recipes/purple_crafter_manager" | "createcompression:block/minecraft/grass/compress/3x" | "create:brass_scaffolding_from_ingots_brass_stonecutting" | "create:crafting/kinetics/cyan_valve_handle_from_other_valve_handle" | "create:crafting/materials/small_rose_quartz_tilesfrom_conversion" | "createcompression:block/minecraft/end_stone/decompress/9x" | "pipez:copy_upgrade_infinity" | "createcompression:block/minecraft/birch_plank/compress/8x" | "createcompression:block/minecraft/end_stone/decompress/8x" | "railways:crafting/palettes/dyeing_1x/lime_slashed_locometal" | "createcompression:block/minecraft/cobbled_deepslate/decompress/1x" | "farmersdelight:cutting/mangrove_trapdoor" | "create:polished_cut_asurine_stairs" | "createsweetsandtreets:cut_rock_candy_recipe_2_red" | "mcwfurnitures:jungle_drawer" | "create:crafting/kinetics/fluid_tank" | "createcompression:block/minecraft/grass/compress/4x" | "exdeorum:compressed_sieve/gravel/netherite/emerald" | "create:cutting/compat/blue_skies/stripped_maple_log" | "create:smoking/bread" | "mcwfurnitures:birch_striped_chair" | "immersiveengineering:crusher/raw_block_silver" | "exdeorum:sieve/red_sand/netherite/redstone" | "create:cutting/compat/blue_skies/starlit_log" | "minecraft:orange_stained_glass_pane_from_glass_pane" | "exdeorum:sieve/soul_sand/string/glowstone_dust" | "exdeorum:compressed_sieve/crushed_deepslate/diamond/iron_ore_chunk" | "exdeorum:compressed_sieve/gravel/netherite/boron_ore_chunk" | "createcompression:block/minecraft/clay/decompress/7x" | "engineeredcompatibility:cloche/coffee_delight/coffee" | "create:cutting/compat/blue_skies/maple_log" | "createcompression:block/minecraft/grass/compress/9x" | "laserio:card_item_nbtclear" | "minecraft:iron_ingot_from_nuggets" | "minecraft:golden_pickaxe" | "createcompression:block/minecraft/clay/decompress/8x" | "create:cutting/compat/byg/stripped_lament_log" | "pedestals:machines/upgrademodification/attacker/attacker_area_tier_one" | "ironchest:upgrades/diamond_to_crystal_chest_upgrade" | "railways:sequenced_assembly/track_byg_white_mangrove_wide" | "engineeredcompatibility:cloche/botania/white_petal_rich_soil" | "create:filling/compat/regions_unexplored/silt_grass_block" | "create:deploying/waxed_copper_tile_stairs_from_adding_wax" | "railways:crafting/palettes/dyeing_8x/magenta_brass_wrapped_locometal_boiler" | "create:filling/builders_tea" | "railways:sequenced_assembly/track_blackstone_wide" | "create:milling/compat/botania/yellow_petal" | "minecraft:redstone_torch" | "immersiveengineering:crafting/storage_lead_from_slab" | "create:small_tuff_brick_stairs" | "createcompression:block/minecraft/clay/decompress/5x" | "create:crafting/kinetics/deployer" | "minecraft:gray_bed" | "farmersdelight:basket" | "refinedstorage:detector" | "create:crushing/granite/9x_to_9x_red_sand" | "createcompression:block/minecraft/grass/compress/7x" | "forgepeacefulmobdrops:bone_from_bonemeal" | "create:crafting/materials/andesite_alloy" | "exdeorum:compressed_sieve/gravel/iron/diamond" | "minecraft:white_terracotta" | "exdeorum:compressed_sieve/crushed_blackstone/netherite/gunpowder" | "minecraft:armor_stand" | "createcompression:block/minecraft/clay/decompress/6x" | "minecraft:pink_stained_glass_pane" | "minecraft:blue_dye_from_cornflower" | "createcompression:block/minecraft/grass/compress/8x" | "createcompression:block/minecraft/soul_soil/compress/1x" | "immersiveengineering:blueprint/banner_windmill" | "sophisticatedbackpacks:chipped/alchemy_bench_upgrade" | "create_confectionery:hot_chocolate_recipe" | "create_netherless:crimson_nyllium_by_manual_application" | "minecraft:brown_banner" | "farmersdelight:tomato_crate" | "exdeorum:sieve/moss_block/string/origin_sapling" | "minecraft:warped_hyphae" | "createcompression:block/minecraft/clay/decompress/3x" | "exdeorum:compressed_sieve/moss_block/netherite/palm_sapling" | "create:cutting/compat/biomesoplenty/redwood_wood" | "railways:sequenced_assembly/track_twilightforest_sortingwood_wide" | "create:cutting/compat/regions_unexplored/stripped_mauve_log" | "mowlib:filters/vanilla/individual_mobs/baby/filter_type_horseskeleton_baby" | "railways:sequenced_assembly/track_quark_azalea_wide" | "immersiveengineering:cloche/nether_wart" | "mowlib:filters/vanilla/individual_mobs/filter_type_hoglin" | "exdeorum:mangrove_crucible" | "exdeorum:compressed_sieve/sand/golden/prismarine_crystals" | "vegandelight:crafting_shapeless/tofu_sandwich" | "create:crimsite_pillar_from_stone_types_crimsite_stonecutting" | "createcompression:block/minecraft/soul_soil/compress/2x" | "comforts:sleeping_bag_to_yellow" | "createaddition:compat/immersiveengineering/item_application/kiln_brick" | "exdeorum:sieve/moss_block/iron/origin_sapling" | "mcwfurnitures:stripped_oak_lower_triple_drawer" | "mcwfurnitures:stripped_birch_double_drawer_counter" | "createcompression:block/minecraft/soul_soil/compress/4x" | "exdeorum:sieve/moss_block/flint/rainbow_birch_sapling" | "createcompression:block/minecraft/clay/decompress/4x" | "peacefulrecipes:rotten_flesh_5" | "peacefulrecipes:rotten_flesh_4" | "peacefulrecipes:rotten_flesh_3" | "engineeredcompatibility:cloche/botania/cyan_petal_rich_soil" | "peacefulrecipes:rotten_flesh_2" | "exdeorum:sieve/moss_block/string/jacaranda_sapling" | "minecraft:green_bed" | "engineeredcompatibility:sawmill/homespun/olive_slab" | "minecraft:red_sandstone_slab_from_red_sandstone_stonecutting" | "createcompression:block/minecraft/soul_soil/compress/3x" | "extradisks:part/1048576k_storage_part" | "immersiveengineering:crusher/ore_coal" | "farmersdelight:painting_from_canvas" | "createcompression:block/minecraft/soul_soil/compress/5x" | "create:small_deepslate_brick_wall_from_stone_types_deepslate_stonecutting" | "createcompression:block/minecraft/clay/decompress/1x" | "exdeorum:sieve/dirt/iron/mycelium_spores" | "mob_grinding_utils:recipe_jumbotank" | "minecraft:prismarine_brick_slab_from_prismarine_stonecutting" | "railways:crafting/palettes/dyeing_8x/orange_flat_riveted_locometal" | "create:crushing/silver_ore" | "minecraft:waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "create:cutting/stripped_acacia_log" | "rebornstorage:disks/medium_item_storage_disk_from_storage_housing" | "minecraft:gray_banner" | "minecraft:warped_stairs" | "mcwfurnitures:stripped_spruce_glass_table" | "createcompression:block/minecraft/soul_soil/compress/6x" | "exdeorum:compressed_sieve/dirt/flint/andesite_pebble" | "createcompression:block/minecraft/clay/decompress/2x" | "createsweetsandtreets:chiseled_green" | "exdeorum:compressed_sieve/crushed_deepslate/iron/osmium_ore_chunk" | "create:splashing/orange_concrete_powder" | "refinedstorage:coloring_recipes/red_relay" | "exdeorum:compressed_sieve/gravel/iron/magnesium_ore_chunk" | "create:crushing/compat/silentgems/peridot_ore" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/barrelcactus" | "exdeorum:compressed_red_sand" | "exdeorum:compressed_sieve/red_sand/flint/dead_bush" | "mcwfurnitures:mangrove_double_wardrobe" | "minecraft:smooth_sandstone_slab" | "railways:crafting/palettes/dyeing_8x/purple_plated_locometal" | "vegandelight:cooking/applesauce" | "exdeorum:sieve/red_sand/golden/cactus" | "refinedstorage:coloring_recipes/red_crafter" | "immersiveengineering:smelting/ingot_electrum_from_dust" | "minecraft:rail" | "immersiveengineering:crafting/sword_steel" | "createsifter:sifting/dirt_string_mesh_waterlogged" | "railways:stonecutting/palettes/cycling/blue_slashed_locometal" | "create:cutting/compat/ars_nouveau/red_archwood_wood" | "mowlib:filters/vanilla/individual_mobs/foodmobs/filter_type_cow" | "refinedstorage:coloring_recipes/magenta_crafting_grid" | "createcompression:block/minecraft/diamond/decompress/5x" | "farmersdelight:cutting/oak_trapdoor" | "peco:discs/music_disc_stal" | "farmersdelight:cooking/dumplings" | "exdeorum:mangrove_sieve" | "create:milling/compat/biomesoplenty/rose" | "exdeorum:sieve/moss_block/iron/mahogany_sapling" | "engineeredcompatibility:sawmill/twilightforest/mangrove_door" | "refinedstorage:pattern_grid/blue_pattern_grid" | "createcompression:block/minecraft/diamond/decompress/6x" | "immersiveengineering:crafting/toolbox" | "easy_mob_farm:mob_farm/bee_hive_farm/tier3_bee_hive_farm" | "create_confectionery:chocolate_bricks_stairs_recipe_1" | "create_confectionery:chocolate_bricks_stairs_recipe_2" | "craftable_spawner_p:mule_spawn_egg" | "immersiveengineering:crafting/sheetmetal_colored_magenta_from_slab" | "immersiveengineering:metalpress/rod_tungsten" | "minecraft:polished_blackstone_from_blackstone_stonecutting" | "exdeorum:sieve/gravel/golden/gold_ore_chunk" | "exdeorum:sieve/moss_block/string/dead_sapling" | "copycats:crafting/copycat_panel_from_half_panels" | "createcompression:block/minecraft/diamond/decompress/7x" | "engineersdecor:independent/old_industrial_wood_slabslice_recipe" | "engineersdecor:independent/thick_steel_pole_recipe_backcycle" | "farmersdelight:book_from_canvas" | "createaddition:rolling/aluminum_plate" | "minecraft:crimson_planks" | "minecraft:smooth_red_sandstone" | "engineeredcompatibility:sawmill/twilightforest/timewood_stairs" | "mcwfurnitures:crimson_modern_chair" | "mcwfurnitures:stripped_mangrove_counter" | "createcompression:block/minecraft/diamond/decompress/8x" | "create_confectionery:gingerdough_recipe" | "railways:crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal" | "extrastorage:diamond_crafter" | "exdeorum:compressed_sieve/moss_block/golden/mangrove_propagule" | "mcwfurnitures:acacia_counter" | "railways:crafting/palettes/dyeing_8x/gray_locometal_smokebox" | "exdeorum:sieve/red_sand/iron/gold_nugget" | "pedestals:machines/bottler/bottler_bottleofenchanting" | "engineeredcompatibility:cloche/coffee_delight/coffee_rich_soil" | "mcwfurnitures:oak_double_wardrobe" | "railways:crafting/palettes/dyeing_8x/lime_copper_wrapped_locometal_boiler" | "minecraft:iron_nugget_from_blasting" | "createcompression:block/minecraft/diamond/decompress/9x" | "engineeredcompatibility:sawmill/aether_redux/jellyshroom_bookshelf" | "create:cutting/mangrove_wood" | "create:cutting/compat/regions_unexplored/stripped_blue_bioshroom_hyphae" | "railways:sequenced_assembly/track_biomesoplenty_redwood" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/lentil" | "create:milling/azure_bluet" | "mekanism:enriching/createcompression/sand/8x_to_8x_gravel" | "mcwfurnitures:stripped_crimson_coffee_table" | "exdeorum:hellbark_sieve" | "minecraft:green_stained_glass_pane" | "engineersdecor:independent/steel_catwalk_stairs_recipe" | "farmersdelight:red_hanging_canvas_sign" | "minecraft:black_concrete_powder" | "exdeorum:compressed_sieve/crushed_deepslate/diamond/silver_ore_chunk" | "engineeredcompatibility:sawmill/botania/livingwood_log" | "createcompression:block/minecraft/clay/decompress/9x" | "exdeorum:compressed_sieve/crushed_end_stone/netherite/ender_pearl" | "exdeorum:sieve/crushed_netherrack/diamond/gold_nugget" | "peco:discs/music_disc_mall" | "exdeorum:sieve/moss_block/netherite/blue_archwood_sapling" | "exdeorum:compressed_sieve/crushed_netherrack/netherite/magma_cream" | "peacefulrecipes:creeper_head" | "minecraft:quartz_pillar" | "farmersdelight:cutting/leather_leggings" | "exdeorum:compressed_sieve/crushed_deepslate/netherite/boron_ore_chunk" | "railways:crafting/palettes/dyeing_8x/cyan_copper_wrapped_locometal" | "create:deploying/waxed_copper_shingles_from_adding_wax" | "railways:sequenced_assembly/track_natures_spirit_willow_wide" | "minecraft:dye_red_wool" | "exdeorum:compressed_sieve/crushed_deepslate/iron/copper_ore_chunk" | "railways:crafting/palettes/dyeing_8x/brown_flat_slashed_locometal" | "mcwfurnitures:birch_modern_chair" | "railways:crafting/palettes/dyeing_8x/light_blue_copper_wrapped_locometal_boiler" | "exdeorum:sieve/soul_sand/netherite/ghast_tear" | "minecraft:blue_dye" | "minecraft:polished_diorite_slab_from_polished_diorite_stonecutting" | "exdeorum:sieve/gravel/iron/osmium_ore_chunk" | "exdeorum:compressed_sieve/sand/netherite/kelp" | "create:cutting/compat/regions_unexplored/blackwood_wood" | "railways:sequenced_assembly/track_jungle_wide" | "createcompression:block/cc/zinc/decompress/7x" | "createcompression:block/minecraft/stone/decompress/3x" | "mcwfurnitures:stripped_mangrove_wardrobe" | "exdeorum:compressed_sieve/moss_block/netherite/dead_sapling" | "exdeorum:sieve/moss_block/string/spruce_sapling" | "exdeorum:sieve/moss_block/iron/birch_sapling" | "create:cutting/compat/regions_unexplored/magnolia_wood" | "createcompression:block/minecraft/basalt/compress/7x" | "createcompression:block/minecraft/obsidian/compress/5x" | "railways:crafting/palettes/dyeing_8x/orange_brass_wrapped_locometal" | "minecraft:wooden_axe" | "railways:sequenced_assembly/track_oak" | "createcompression:block/cc/zinc/decompress/8x" | "createcompression:block/minecraft/stone/decompress/4x" | "immersiveengineering:crafting/sheetmetal_colored_red_from_slab" | "mowlib:filters/insertable_filters/clear_filterenchantedfuzzy" | "pedestals:machines/upgrademodification/export/export_energy_capacity_tier_one" | "copycats:stonecutting/copycat_slice" | "immersiveengineering:crafting/blastbrick_reinforced" | "createcompression:block/minecraft/basalt/compress/6x" | "laserio:logic_chip" | "create:small_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "createcompression:block/minecraft/obsidian/compress/4x" | "create:smelting/ingot_silver_compat_immersiveengineering" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/cabbage_rich_soil" | "enchantinginfuser:advanced_enchanting_infuser" | "create:oak_window_pane" | "minecraft:stone_stairs_from_stone_stonecutting" | "create:polished_cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "createcompression:block/cc/zinc/decompress/9x" | "pedestals:machines/cobblegen/generate_coral_brain" | "immersiveengineering:blueprint/mold_unpacking" | "createcompression:block/minecraft/stone/decompress/5x" | "exdeorum:compressed_sieve/crushed_deepslate/diamond/deepslate_pebble" | "minecraft:dried_kelp" | "railways:sequenced_assembly/track_blackstone_narrow" | "create:andesite_from_stone_types_andesite_stonecutting" | "exdeorum:barrel_compost/rotten_flesh" | "minecraft:iron_bars" | "pipez:basic_upgrade" | "railways:crafting/palettes/dyeing_1x/magenta_brass_wrapped_locometal" | "createcompression:block/minecraft/obsidian/compress/7x" | "createcompression:block/minecraft/basalt/compress/9x" | "immersiveengineering:crafting/sheetmetal_uranium" | "engineeredcompatibility:sawmill/aether/skyroot_bookshelf" | "mcwfurnitures:birch_covered_desk" | "refinedstorage:coloring_recipes/brown_crafting_monitor" | "createcompression:block/minecraft/stone/decompress/6x" | "exdeorum:compressed_sieve/dirt/diamond/deepslate_pebble" | "createcompression:block/minecraft/obsidian/compress/6x" | "createcompression:block/minecraft/basalt/compress/8x" | "exdeorum:compressed_sieve/moss_block/diamond/origin_sapling" | "railways:crafting/palettes/dyeing_8x/brown_iron_wrapped_locometal_boiler" | "peco:discs/music_disc_far" | "exdeorum:hammer/horn_coral" | "refinedstorage:coloring_recipes/lime_detector" | "mob_grinding_utils:recipe_absorbtion_hopper" | "create:splashing/purple_concrete_powder" | "createcompression:block/cc/zinc/decompress/3x" | "createcompression:block/minecraft/stone/decompress/7x" | "pedestals:augments/augment_collide" | "pedestals:machines/fluidconverter/fluidconverter_experience_cyclic" | "mowlib:filters/insertable_filters/filter_base" | "create:crafting/curiosities/minecart_coupling" | "createcompression:block/minecraft/obsidian/compress/9x" | "create:cut_deepslate_brick_slab" | "create:cut_granite_stairs_from_stone_types_granite_stonecutting" | "createcompression:block/cc/zinc/decompress/4x" | "laserio:overclocker_node" | "mobdropsrecipes_overworld:slime_ball_into_essence" | "createcompression:block/minecraft/stone/decompress/8x" | "create:crushing/compat/byg/emeraldite_ore" | "forgepeacefulmobdrops:dragon_egg" | "forgepeacefulmobdrops:rotten_flesh_from_tropical_fish" | "cabletiers:mega_requester" | "minecraft:mud_brick_wall_from_mud_bricks_stonecutting" | "create:milling/wheat" | "vegandelight:compacting/blaze_cake_base_from_applesauce" | "peacefulrecipes:nautilus_shell" | "create:polished_cut_diorite_slab_from_stone_types_diorite_stonecutting" | "create:compacting/honey" | "minecraft:food_serving" | "create:smelting/cobblestone/8x_to_8x_stone" | "create:milling/compat/botania/light_gray_petal" | "createcompression:block/minecraft/obsidian/compress/8x" | "create:cutting/compat/blue_skies/stripped_starlit_wood" | "railways:stonecutting/palettes/cycling/light_blue_flat_slashed_locometal" | "create:milling/grass" | "exdeorum:compressed_sieve/dirt/netherite/deepslate_pebble" | "exdeorum:compressed_sieve/sand/iron/certus_quartz_crystal" | "engineeredcompatibility:squeezer/cucumber_seeds" | "createcompression:block/cc/zinc/decompress/5x" | "create:splashing/ic2/crushed_raw_uranium" | "createcompression:block/minecraft/stone/decompress/9x" | "additionalredstone:circuit_maker" | "exdeorum:compressed_sieve/sand/string/cactus" | "railways:crafting/palettes/dyeing_1x/cyan_plated_locometal" | "refinedstorage:hollow_cover" | "farmersdelight:cutting/apple_pie" | "exdeorum:sieve/dirt/netherite/flint" | "immersiveengineering:crafting/sheetmetal_colored_white_to_slab" | "mcwfurnitures:stripped_birch_glass_table" | "rebornstorage:parts/super_wireless_crafting_grid" | "railways:stonecutting/palettes/cycling/black_plated_locometal" | "createcompression:block/cc/zinc/decompress/6x" | "craftable_spawner_p:bat_spawn_egg" | "minecraft:deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "immersiveengineering:crafting/ingot_aluminum_to_nugget_aluminum" | "immersiveengineering:thermoelectric/snow" | "engineeredcompatibility:arcfurnace/undergarden/raw_ore_cloggrum" | "exdeorum:sieve/gravel/iron/copper_ore_chunk" | "exdeorum:sieve/crushed_end_stone/netherite/ender_pearl" | "farmersdelight:bacon_and_eggs" | "exdeorum:compressed_sieve/gravel/iron/amethyst_shard" | "railways:mechanical_crafting/lime_locometal_boiler" | "minecraft:torch" | "exdeorum:compressed_sieve/dirt/golden/gold_nugget" | "railways:stonecutting/palettes/cycling/yellow_locometal_pillar" | "engineeredcompatibility:arcfurnace/blue_skies/raw_ore_falsite" | "create:crafting/kinetics/black_seat" | "create:cutting/compat/biomesoplenty/stripped_jacaranda_log" | "create:milling/allium" | "railways:sequenced_assembly/track_quark_ancient_narrow" | "farmersdelight:cutting/acacia_hanging_sign" | "mcwfurnitures:dark_oak_covered_desk" | "immersiveengineering:stonecutting/concrete_three_quarter" | "exdeorum:compressed_sieve/dirt/iron/wheat_seeds" | "createaddition:charging/weathered_copper_shingles" | "exdeorum:sieve/moss_block/golden/maple_sapling" | "engineersdecor:independent/slag_brick_slab_recipe" | "craftable_spawner_p:allay_spawn_egg" | "immersiveengineering:crafting/jerrycan" | "create:crafting/copper/waxed_oxidized_copper_shingles_from_honeycomb" | "immersiveengineering:crafting/toolupgrade_shield_flash" | "create:cutting/compat/twilightforest/canopy_wood" | "extrastorage:disk/shapeless/disk_4096k" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/parsnip" | "railways:crafting/palettes/dyeing_1x/orange_flat_riveted_locometal" | "exdeorum:barrel_compost/leaves" | "createcompression:block/minecraft/basalt/compress/1x" | "create_recipes:saddle" | "exdeorum:compressed_sieve/gravel/diamond/zinc_ore_chunk" | "exdeorum:sieve/dirt/flint/sugar_cane" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/eggplant" | "minecraft:cherry_slab" | "railways:sequenced_assembly/track_blue_skies_starlit" | "create:cutting/stripped_warped_hyphae" | "railways:stonecutting/palettes/cycling/red_locometal_pillar" | "create:milling/clay" | "immersiveengineering:smelting/ingot_steel_from_dust_from_blasting" | "railways:crafting/palettes/dyeing_1x/orange_iron_wrapped_locometal" | "comforts:sleeping_bag_brown" | "mcwfurnitures:stripped_acacia_bookshelf_drawer" | "mcwfurnitures:warped_drawer" | "immersiveengineering:crafting/toolupgrade_powerpack_magnet" | "pedestals:machines/upgrademodification/planter/planter_range_tier_one" | "immersiveengineering:crafting/cloche" | "pedestals:tools/tool_crafting/dualhanded_upgradetool_quark" | "mcwfurnitures:stripped_cherry_large_drawer" | "pedestals:machines/fluidconverter/fluidconverter_experience_mgu" | "minecraft:orange_bed" | "createcompression:block/minecraft/basalt/compress/3x" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/elderberry_rich_soil" | "create_confectionery:gingerbread_brick_stairs_recipe" | "create:milling/compat/atmospheric/hot_monkey_brush" | "exdeorum:sieve/crushed_end_stone/netherite/chorus_flower" | "railways:crafting/palettes/dyeing_8x/pink_riveted_locometal" | "exdeorum:mechanical_hammer" | "create:filling/glowstone" | "immersiveengineering:arcfurnace/ore_nickel" | "railways:sequenced_assembly/track_create_dd_smoked_narrow" | "exdeorum:compressed_sieve/crushed_deepslate/string/copper_ore_chunk" | "engineeredcompatibility:arcfurnace/undergarden/raw_ore_froststeel" | "create:cutting/compat/atmospheric/stripped_morado_wood" | "minecraft:red_stained_glass_pane" | "create:cutting/compat/byg/stripped_green_enchanted_wood" | "exdeorum:sieve/crushed_deepslate/diamond/thorium_ore_chunk" | "create:splashing/gravel" | "exdeorum:barrel_mixing/end_stone" | "railways:sequenced_assembly/track_biomesoplenty_dead_narrow" | "createcompression:block/minecraft/basalt/compress/2x" | "create:crafting/kinetics/andesite_door" | "railways:stonecutting/palettes/cycling/pink_locometal_smokebox" | "peacefulrecipes:bottle_enchanting" | "create:cutting/compat/biomesoplenty/stripped_fir_log" | "exdeorum:compressed_sieve/crushed_blackstone/flint/magma_cream" | "railways:sequenced_assembly/track_tfc_blackwood_wide" | "easy_mob_farm:upgrade/enhancement/luck_enhancement" | "mcwfurnitures:stripped_spruce_chair" | "engineeredcompatibility:sawmill/aether/skyroot_log" | "immersiveengineering:crusher/ingot_silver" | "immersiveengineering:sawmill/stripped_spruce_log" | "createcompression:block/minecraft/basalt/compress/5x" | "mowlib:filters/vanilla/filter_category_misc" | "minecraft:dark_oak_planks" | "minecraft:granite_wall" | "mcwfurnitures:warped_chair" | "create:crushing/raw_lead_block" | "create:cutting/compat/regions_unexplored/willow_wood" | "exdeorum:compressed_sieve/crushed_deepslate/flint/osmium_ore_chunk" | "mobdropsrecipes_overworld:gunpowder" | "mcwfurnitures:jungle_striped_chair" | "railways:stonecutting/palettes/cycling/light_blue_slashed_locometal" | "christmasmusicdiscs:oh_come_all_ye_faithful_recipe" | "createcompression:block/minecraft/basalt/compress/4x" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/strawberry_rich_soil" | "exdeorum:water_crucible/spore_blossom" | "minecraft:mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting" | "mcwfurnitures:stripped_mangrove_end_table" | "minecraft:warped_fence" | "immersiveengineering:mineral/cooled_lava_tube" | "createaddition:compat/tconstruct/hepatizon" | "railways:crafting/track_switch_andesite" | "railways:crafting/palettes/dyeing_1x/black_flat_riveted_locometal" | "mowlib:applicator_reset" | "mcwfurnitures:cherry_bookshelf_cupboard" | "mowlib:filters/vanilla/individual_mobs/filter_type_pillager" | "pedestals:machines/upgrademodification/import/import_remotestorage" | "refinedstorage:pattern_grid/purple_pattern_grid" | "immersiveengineering:crafting/armor_steel_helmet" | "engineersdecor:independent/old_industrial_wood_slab_recipe" | "createcompression:block/minecraft/hay/compress/8x" | "easy_mob_farm:mob_farm/monster_plains_cave/tier2_monster_plains_cave_farm" | "engineeredcompatibility:sawmill/midnight/viridshroom_bookshelf" | "minecraft:loom" | "farmersdelight:cutting/cake" | "create:smelting/copper_ingot_from_crushed" | "create:small_calcite_brick_stairs" | "vegandelight:mixing/dough_from_eggs" | "create:cutting/cherry_wood" | "easy_mob_farm:mob_farm/ocean_farm/tier1_ocean_farm" | "createcompression:block/minecraft/hay/compress/9x" | "farmersdelight:cutting/sweet_berry_cheesecake" | "immersiveengineering:sawmill/mangrove_slab" | "refinedstorage:coloring_recipes/black_crafting_grid" | "railways:crafting/palettes/dyeing_1x/green_locometal_pillar" | "copycats:stonecutting/copycat_trapdoor" | "non_wandering_trader:travellers_table" | "immersiveengineering:sawmill/crimson_log" | "immersiveengineering:metalpress/rod_constantan" | "minecraft:polished_blackstone" | "immersiveengineering:crafting/toolupgrade_drill_damage" | "mcwfurnitures:stripped_birch_glass_kitchen_cabinet" | "refinedstorage:coloring_recipes/blue_relay" | "craftable_spawner:piglin_spawn_egg" | "exdeorum:compressed_sieve/dust/netherite/gunpowder" | "create:filling/honey_pie" | "create:smelting/cobbled_deepslate/7x_to_7x_deepslate" | "engineeredcompatibility:sawmill/twilightforest/canopy_bookshelf" | "engineeredcompatibility:arcfurnace/occultism/raw_ore_iesnium" | "vegandelight:campfire_cooking/cooked_tofu_from_campfire_cooking" | "minecraft:dye_purple_carpet" | "exdeorum:hammer/brain_coral_fan" | "railways:crafting/palettes/dyeing_1x/blue_plated_locometal" | "engineeredcompatibility:sawmill/ecologics/walnut_bookshelf" | "mobdropsrecipes_end:shulker_shell_into_essence" | "railways:crafting/palettes/dyeing_8x/purple_locometal_smokebox" | "exdeorum:compressed_sieve/moss_block/iron/spore_blossom" | "mcwfurnitures:jungle_end_table" | "mcwfurnitures:stripped_oak_chair" | "exdeorum:sieve/moss_block/golden/dead_sapling" | "minecraft:deepslate_brick_slab" | "mowlib:filters/vanilla/filter_category_waterambient" | "railways:crafting/palettes/dyeing_1x/cyan_riveted_locometal" | "mcwfurnitures:stripped_birch_lower_triple_drawer" | "minecraft:polished_blackstone_brick_stairs_from_blackstone_stonecutting" | "ironchest:chests/trapped_diamond_chest" | "refinedstorage:coloring_recipes/red_crafter_manager" | "refinedstorage:coloring_recipes/crafter" | "immersiveengineering:crafting/storage_steel_to_slab" | "refinedstorage:coloring_recipes/crafter_manager" | "immersiveengineering:metalpress/rod_cobalt" | "create:milling/compat/byg/cyan_rose" | "sophisticatedbackpacks:compacting_upgrade" | "create:milling/compat/byg/fairy_slipper" | "farmersdelight:kelp_roll" | "pedestals:machines/bottler/bottler_water_bucket" | "create:cut_crimsite_from_stone_types_crimsite_stonecutting" | "railways:crafting/palettes/dyeing_1x/white_locometal_pillar" | "create:layered_granite_from_stone_types_granite_stonecutting" | "farmersdelight:carrot_from_crate" | "immersiveengineering:mineral/ancient_debris" | "minecraft:acacia_sign" | "laserio:filter_basic_nbtclear" | "minecraft:chest_minecart" | "immersiveengineering:crafting/sheetmetal_gold_from_slab" | "exdeorum:compressed_sieve/moss_block/golden/cherry_sapling" | "mcwfurnitures:stripped_warped_covered_desk" | "exdeorum:sieve/moss_block/netherite/spore_blossom" | "create:crafting/logistics/brass_funnel" | "mcwfurnitures:dark_oak_drawer_counter" | "mcwfurnitures:stripped_oak_stool_chair" | "minecraft:baked_potato_from_campfire_cooking" | "create:compacting/ice" | "exdeorum:compressed_sieve/crushed_deepslate/netherite/tin_ore_chunk" | "railways:crafting/palettes/dyeing_1x/cyan_flat_slashed_locometal" | "immersiveengineering:metalpress/plate_silver" | "minecraft:deepslate_bricks_from_polished_deepslate_stonecutting" | "imersiveengineering:crusher/createcompression/cobblestone/2x_to_2x_gravel" | "immersiveengineering:sawmill/cherry_wood" | "mcwfurnitures:stripped_spruce_double_drawer_counter" | "railways:sequenced_assembly/track_byg_fir_narrow" | "create:crushing/amethyst_block" | "exdeorum:compressed_sieve/moss_block/flint/sweet_berries" | "immersiveengineering:mixer_potion_list" | "createcompression:block/minecraft/hay/compress/1x" | "imersiveengineering:crusher/createcompression/glass/1x_to_1x_sand" | "railways:crafting/palettes/dyeing_1x/light_blue_brass_wrapped_locometal" | "engineeredcompatibility:crusher/aether/ore_zanite" | "refinedstorage:crafting_upgrade" | "mcwfurnitures:warped_drawer_counter" | "exdeorum:sieve/gravel/iron/magnesium_ore_chunk" | "exdeorum:sieve/gravel/netherite/thorium_ore_chunk" | "railways:crafting/conductor_whistle" | "createaddition:liquid_burning/compat/thermal/heavy_oil" | "exdeorum:compressed_sieve/dirt/iron/iron_nugget" | "immersiveengineering:crafting/ingot_steel_to_storage_steel" | "create:crafting/logistics/display_link" | "createcompression:block/minecraft/hay/compress/2x" | "engineeredcompatibility:sawmill/ecologics/walnut_door" | "engineeredcompatibility:crusher/ae2/ender_pearl" | "minecraft:red_stained_glass_pane_from_glass_pane" | "exdeorum:compressed_sieve/crushed_deepslate/netherite/platinum_ore_chunk" | "minecraft:waxed_cut_copper_stairs_from_waxed_copper_block_stonecutting" | "exdeorum:compressed_sieve/red_sand/string/cactus" | "create:splashing/thermal/crushed_raw_nickel" | "createcompression:block/minecraft/hay/compress/3x" | "create:crushing/osmium_ore" | "exdeorum:ores/magnesium_tag" | "create:milling/compat/regions_unexplored/hibiscus" | "minecraft:polished_diorite_stairs_from_polished_diorite_stonecutting" | "farmersdelight:cutting/crimson_stem" | "sophisticatedbackpacks:advanced_restock_upgrade" | "createcompression:block/minecraft/hay/compress/4x" | "create:framed_glass_from_glass_colorless_stonecutting" | "exdeorum:compressed_sieve/crushed_deepslate/flint/iridium_ore_chunk" | "minecraft:warped_sign" | "railways:sequenced_assembly/track_tfc_chestnut_narrow" | "exdeorum:compressed_sieve/moss_block/diamond/flowering_oak_sapling" | "createcompression:block/minecraft/obsidian/compress/1x" | "immersiveengineering:crafting/concrete_pillar" | "refinedstorage:coloring_recipes/orange_crafter_manager" | "createaddition:crafting/rolling_mill" | "createcompression:block/minecraft/hay/compress/5x" | "engineeredcompatibility:sawmill/ars_nouveau/archwood_door" | "minecraft:bamboo_sign" | "refinedstorage:coloring_recipes/pink_relay" | "exdeorum:warped_crucible" | "refinedstorage:wireless_fluid_grid" | "engineeredcompatibility:sawmill/ancient_aether/sakura_bookshelf" | "pedestals:augments/augment_robin" | "mcwfurnitures:stripped_spruce_modern_desk" | "exdeorum:sieve/dust/golden/yellorium_dust" | "create:crafting/kinetics/spout" | "createcompression:block/minecraft/stone/decompress/1x" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/cranberry_rich_soil" | "create:haunting/soul_torch" | "farmersdelight:integration/create/milling/wild_tomatoes" | "createcompression:block/minecraft/hay/compress/6x" | "create:splashing/blue_concrete_powder" | "engineeredcompatibility:sawmill/midnight/bogshroom_slab" | "create:copper_scaffolding_from_ingots_copper_stonecutting" | "mekanism:enriching/createcompression/sand/2x_to_2x_gravel" | "createcompression:block/minecraft/obsidian/compress/3x" | "minecraft:lime_glazed_terracotta" | "engineeredcompatibility:squeezer/flax_seeds" | "create:cut_scoria_brick_slab_recycling" | "craftable_spawner:piglin_brute_spawn_egg" | "exdeorum:sieve/crushed_netherrack/golden/blackstone_pebble" | "exdeorum:water_crucible/grass" | "createcompression:block/minecraft/stone/decompress/2x" | "create:cutting/compat/byg/fir_log" | "createcompression:block/minecraft/hay/compress/7x" | "create:cut_calcite_brick_wall" | "createcompression:block/minecraft/obsidian/compress/2x" | "immersiveengineering:crafting/sheetmetal_colored_orange_from_slab" | "railways:crafting/palettes/dyeing_8x/light_blue_locometal_pillar" | "railways:crafting/palettes/dyeing_1x/white_brass_wrapped_locometal" | "engineersdecor:independent/engineersdecor_manual_recipe" | "create:crushing/compat/silentgems/citrine_ore" | "mowlib:filters/vanilla/individual_mobs/foodmobs/filter_type_bee" | "create:milling/compat/regions_unexplored/blue_lupine" | "create:crafting/kinetics/framed_glass_trapdoor" | "create:cut_asurine_brick_wall_from_stone_types_asurine_stonecutting" | "peacefulrecipes:dragons_egg" | "exdeorum:compressed_sieve/crushed_deepslate/flint/emerald" | "engineeredcompatibility:sawmill/deep_aether/sunroot_slab" | "easy_villagers:breeder" | "refinedstorage:coloring_recipes/pink_crafter" | "mowlib:filters/vanilla/individual_mobs/filter_type_parrot" | "railways:stonecutting/riveted_locometal" | "exdeorum:sieve/soul_sand/golden/quartz" | "mobdropsrecipes_overworld:totem_of_undying" | "create:crushing/compat/druidcraft/amber_ore" | "exdeorum:sieve/moss_block/golden/palm_sapling" | "cabletiers:elite_constructor" | "copycats:crafting/copycat_box" | "create:milling/compat/byg/allium_flower_bush" | "exdeorum:crook/silkworm" | "create_netherless:glowstone_from_haunting" | "farmingforblockheads:green_fertilizer" | "mcwfurnitures:dark_oak_double_wardrobe" | "exdeorum:sieve/moss_block/string/palm_sapling" | "create:cutting/compat/blue_skies/stripped_lunar_wood" | "immersiveengineering:smelting/ingot_constantan_from_dust" | "exdeorum:compressed_sieve/crushed_deepslate/netherite/magnesium_ore_chunk" | "exdeorum:stone_watering_can" | "exdeorum:sieve/sand/string/kelp" | "mcwfurnitures:stripped_acacia_modern_wardrobe" | "create:milling/lilac" | "exdeorum:compressed_sieve/soul_sand/flint/crimson_nylium_spores" | "createaddition:charging/exposed_copper" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/radish" | "minecraft:iron_block" | "exdeorum:sieve/crushed_blackstone/flint/black_dye" | "immersiveengineering:cloche/cactus" | "engineeredcompatibility:sawmill/ecologics/coconut_bookshelf" | "minecraft:dark_oak_door" | "exdeorum:sieve/crushed_deepslate/string/thorium_ore_chunk" | "railways:sequenced_assembly/track_natures_spirit_olive_narrow" | "create:cutting/compat/the_vault/stripped_chromatic_log" | "engineersdecor:independent/dark_shingle_roof_metallized_recipe" | "exdeorum:sieve/dirt/flint/melon_seeds" | "exdeorum:ores/uranium_tag" | "create:cutting/compat/regions_unexplored/stripped_maple_log" | "immersiveengineering:crafting/insulating_glass_from_slab" | "vegandelight:emptying/soymilk_from_emptying_bucket" | "railways:sequenced_assembly/track_ender" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/kohlrabi" | "exdeorum:sieve/moss_block/iron/purple_archwood_sapling" | "exdeorum:compressed_sieve/crushed_blackstone/flint/blackstone_pebble" | "create:exposed_copper_tile_stairs_from_exposed_copper_tiles_stonecutting" | "refinedstorage:64k_storage_block" | "railways:crafting/palettes/dyeing_8x/black_iron_wrapped_locometal_boiler" | "refinedstorage:crafting_grid/purple_crafting_grid" | "create:cutting/compat/twilightforest/transformation_wood" | "farmersdelight:golden_knife" | "exdeorum:sieve/soul_sand/diamond/gunpowder" | "create:milling/compat/byg/amaranth" | "mobdropsrecipes_overworld:string" | "create:cutting/compat/environmental/cherry_log" | "immersiveengineering:fertilizer/slag" | "farmersdelight:cutting/cabbage" | "create:crafting/materials/rose_quartz" | "create:crushing/compat/neapolitan/ice" | "minecraft:copper_ingot_from_blasting_deepslate_copper_ore" | "comforts:hammock_to_gray" | "farmersdelight:integration/immersiveengineering/crusher/wild_carrots" | "engineersdecor:independent/old_industrial_wood_stairs_recipe_decompose" | "exdeorum:compressed_sieve/crushed_deepslate/flint/copper_ore_chunk" | "immersiveengineering:metalpress/gear_platinum" | "minecraft:golden_boots" | "mcwfurnitures:warped_wardrobe" | "waystones:mossy_waystone" | "minecraft:pink_dye_from_red_white_dye" | "create:cutting/compat/regions_unexplored/stripped_joshua_wood" | "immersiveengineering:arcfurnace/dust_gold" | "engineeredcompatibility:arcfurnace/ae2/silicon_sand" | "create:crushing/terracotta/6x_to_6x_red_sand" | "immersiveengineering:smelting/nugget_aluminum_recycle_faraday_boots_from_blasting" | "imersiveengineering:crusher/createcompression/gravel/3x_to_3x_sand" | "engineeredcompatibility:sawmill/twilightforest/minewood_slab" | "farmersdelight:cutting/jungle_door" | "railways:crafting/palettes/dyeing_8x/orange_iron_wrapped_locometal" | "immersiveengineering:metalpress/wire_electrum" | "vegandelight:crafting_shapeless/soybean_from_bag" | "mob_grinding_utils:recipe_xp_block" | "createcompression:block/minecraft/diorite/compress/4x" | "farmersdelight:cutting/oxeye_daisy" | "waystones:waystone" | "minecraft:cherry_planks" | "railways:crafting/palettes/dyeing_1x/yellow_locometal_pillar" | "minecraft:nether_brick_wall_from_nether_bricks_stonecutting" | "minecraft:oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "minecraft:silence_armor_trim_smithing_template" | "minecraft:smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting" | "pedestals:machines/upgrademodification/planter/planter_speed_tier_one" | "create:crushing/nether_gold_ore" | "immersiveengineering:arcfurnace/netherite_scrap" | "refinedstorage:storage_monitor" | "mcwfurnitures:spruce_end_table" | "immersiveengineering:crafting/sheetmetal_constantan_from_slab" | "createcompression:block/minecraft/diorite/compress/3x" | "extrastorage:disk/shaped/disk_16384k" | "immersiveengineering:crafting/rs_engineering" | "farmersdelight:cutting/bamboo_hanging_sign" | "exdeorum:sieve/crushed_deepslate/iron/diamond" | "refinedstorage:coloring_recipes/gray_wireless_transmitter" | "exdeorum:sieve/moss_block/diamond/mahogany_sapling" | "engineeredcompatibility:sawmill/aether_redux/blightwillow_stairs" | "create:filling/honeyed_apple" | "extrastorage:advanced_exporter" | "nocubes_craftable_md:music_disc_relic" | "createcompression:block/minecraft/diorite/compress/2x" | "create:crushing/deepslate_zinc_ore" | "engineeredcompatibility:arcfurnace/undergarden/ore_froststeel" | "mcwfurnitures:birch_lower_bookshelf_drawer" | "createaddition:crafting/modular_accumulator_gold" | "railways:sequenced_assembly/track_twilightforest_canopy_wide" | "exdeorum:barrel_compost/fermented_spider_eye" | "minecraft:light_blue_concrete_powder" | "mcwfurnitures:stripped_birch_bookshelf_drawer" | "immersiveengineering:crafting/storage_uranium_to_slab" | "mob_grinding_utils:recipe_xp_tap" | "minecraft:granite_stairs" | "createcompression:block/minecraft/diorite/compress/1x" | "create:smelting/soul_sand/5x_to_5x_scoria" | "create:small_deepslate_brick_slab" | "create:haunting/infested_chiseled_stone_bricks" | "farmersdelight:cutting/cherry_door" | "create:oxidized_copper_tile_stairs_from_oxidized_copper_tiles_stonecutting" | "exdeorum:compressed_sieve/crushed_netherrack/golden/crimson_nylium_spores" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/oats_rich_soil" | "createcompression:block/minecraft/diorite/compress/8x" | "mob_grinding_utils:recipe_mob_swab" | "exdeorum:dusk_barrel" | "exdeorum:compressed_sieve/moss_block/golden/snowblossom_sapling" | "farmersdelight:integration/create/milling/wild_rice" | "exdeorum:compressed_sieve/crushed_deepslate/iron/lead_ore_chunk" | "createaddition:mixing/netherrack" | "exdeorum:compressed_sieve/gravel/iron/flint" | "pedestals:machines/cobblegen/generate_packedice" | "create:cutting/compat/tconstruct/skyroot_wood" | "exdeorum:sieve/dirt/string/sugar_cane" | "createcompression:block/minecraft/diorite/compress/7x" | "railways:crafting/palettes/dyeing_1x/white_iron_wrapped_locometal_boiler" | "exdeorum:compressed_sieve/crushed_deepslate/golden/diamond" | "exdeorum:sieve/moss_block/netherite/mangrove_propagule" | "mcwfurnitures:stripped_cherry_drawer_counter" | "minecraft:dye_orange_wool" | "create:filling/powderedbrownie1" | "immersiveengineering:crafting/storage_nickel_to_slab" | "mob_grinding_utils:beheading/piglin" | "exdeorum:sieve/moss_block/golden/hellbark_sapling" | "immersiveengineering:smelting/nugget_aluminum_recycle_faraday_leggings_from_blasting" | "exdeorum:compressed_sieve/dirt/golden/iron_nugget" | "engineeredcompatibility:sawmill/blue_skies/crystallized_log" | "immersiveengineering:smelting/nugget_steel_recycle_steel_chestplate_from_blasting" | "createcompression:block/minecraft/diorite/compress/6x" | "extradisks:disk/shapeless/1048576k_storage_disk" | "create:cutting/compat/biomesoplenty/magic_log" | "immersiveengineering:arcfurnace/ore_silver" | "mowlib:filters/vanilla/individual_mobs/baby/filter_type_cow_baby" | "mekanism:crushing/createcompression/cobblestone/6x_to_6x_gravel" | "mobdropsrecipes_nether:nether_essence_epic" | "engineeredcompatibility:cloche/farmersdelight/hemp_rich_soil" | "createcompression:block/minecraft/diorite/compress/5x" | "immersiveengineering:crusher/amethyst" | "exdeorum:compressed_sieve/gravel/netherite/gold_ore_chunk" | "create:cutting/compat/atmospheric/yucca_log" | "refinedstorage:coloring_recipes/orange_crafting_grid" | "minecraft:cyan_banner" | "create:veridium_from_stone_types_veridium_stonecutting" | "create:crafting/materials/copper_nugget" | "railways:crafting/palettes/dyeing_8x/orange_copper_wrapped_locometal" | "farmersdelight:cooking/pumpkin_soup" | "create:crafting/kinetics/gray_seat" | "create:crafting/materials/zinc_ingot_from_decompacting" | "minecraft:dye_yellow_wool" | "railways:sequenced_assembly/track_cherry_narrow" | "exdeorum:sieve/moss_block/string/umbran_sapling" | "minecraft:magenta_carpet" | "create:crafting/kinetics/contraption_controls" | "exdeorum:compressed_sieve/dirt/iron/bamboo" | "exdeorum:compressed_sieve/gravel/iron/osmium_ore_chunk" | "thermal:furnace/createcompression/glass/sand/1x" | "railways:sequenced_assembly/track_byg_jacaranda" | "create:cutting/compat/regions_unexplored/stripped_baobab_log" | "refinedstorage:pattern_grid/light_gray_pattern_grid" | "create:small_diorite_brick_wall" | "mobdropsrecipes_overworld:spider_eye" | "mcwfurnitures:stripped_mangrove_chair" | "exdeorum:birch_barrel" | "farmersdelight:tatami_block_from_full" | "farmersdelight:cooking/vegetable_noodles" | "minecraft:lectern" | "create:cutting/compat/byg/redwood_log" | "create:cut_andesite_brick_wall" | "mowlib:filters/insertable_filters/filteritemstackmachine" | "immersiveengineering:metalpress/gear_constantan" | "mcwfurnitures:stripped_jungle_glass_table" | "mcwfurnitures:crimson_modern_wardrobe" | "nocubes_craftable_md:music_disc_stal" | "exdeorum:sieve/crushed_end_stone/diamond/ender_pearl" | "minecraft:smooth_stone_slab" | "engineeredcompatibility:crusher/blue_skies/ore_pyrope" | "create:milling/beetroot" | "exdeorum:sieve/crushed_deepslate/golden/silver_ore_chunk" | "engineeredcompatibility:sawmill/deep_aether/sunroot_stairs" | "create:crushing/raw_aluminum_block" | "exdeorum:compressed_sieve/moss_block/golden/dark_oak_sapling" | "immersiveengineering:crafting/sheetmetal_silver_from_slab" | "immersiveengineering:metalpress/gear_brass" | "engineeredcompatibility:sawmill/midnight/shadowroot_door" | "railways:crafting/palettes/dyeing_8x/lime_locometal_smokebox" | "minecraft:mossy_cobblestone_from_vine" | "mcwfurnitures:warped_striped_chair" | "mobdropsrecipes_nether:ghast_tear_into_essence" | "immersiveengineering:crafting/metal_barrel" | "exdeorum:sieve/crushed_deepslate/diamond/lapis_lazuli" | "create:cutting/compat/tconstruct/bloodshroom_wood" | "create:small_andesite_brick_wall" | "createcompression:block/minecraft/diorite/compress/9x" | "mcwfurnitures:oak_chair" | "exdeorum:compressed_sieve/dust/diamond/bone_meal" | "engineeredcompatibility:cloche/botania/blue_petal" | "create:crafting/kinetics/adjustable_chain_gearshift" | "farmersdelight:cutting/acacia_door" | "extradisks:disk/shapeless/65536k_storage_disk" | "immersiveengineering:crafting/ingot_lead_to_nugget_lead" | "exdeorum:sieve/moss_block/golden/oak_sapling" | "create:smelting/glass_from_framed_glass" | "farmersdelight:nether_salad" | "createaddition:crafting/portable_energy_interface" | "thermal:furnace/createcompression/glass/sand/5x" | "immersiveengineering:crafting/connector_hv" | "exdeorum:sieve/crushed_netherrack/string/basalt_pebble" | "railways:crafting/palettes/dyeing_8x/blue_plated_locometal" | "railways:sequenced_assembly/track_tfc_kapok" | "mcwfurnitures:crimson_covered_desk" | "create_confectionery:caramel_emptying" | "minecraft:dark_prismarine_slab_from_dark_prismarine_stonecutting" | "create:cutting/compat/twilightforest/stripped_time_log" | "immersiveengineering:crafting/storage_steel_to_ingot_steel" | "comforts:hammock_to_red" | "create:oxidized_copper_shingle_stairs" | "create:pressing/compat/betterendforge/pink_moss_path" | "exdeorum:compressed_sieve/gravel/golden/lapis_lazuli" | "railways:sequenced_assembly/track_create_dd_rose_wide" | "createaddition:crushing/diamond" | "railways:crafting/palettes/dyeing_8x/purple_locometal_boiler" | "farmersdelight:canvas_from_canvas_rug" | "thermal:furnace/createcompression/glass/sand/4x" | "exdeorum:sieve/crushed_netherrack/flint/crimson_nylium_spores" | "exdeorum:birch_sieve" | "mcwfurnitures:stripped_warped_chair" | "immersiveengineering:crafting/storage_nickel_from_slab" | "exdeorum:compressed_sieve/crushed_blackstone/string/gunpowder" | "mcwfurnitures:stripped_acacia_kitchen_cabinet" | "minecraft:pink_concrete_powder" | "thermal:furnace/createcompression/glass/sand/3x" | "farmersdelight:green_canvas_sign" | "exdeorum:compressed_sieve/moss_block/string/azalea" | "railways:crafting/palettes/dyeing_8x/orange_riveted_locometal" | "immersiveengineering:crafting/alu_fence" | "exdeorum:sieve/moss_block/iron/magic_sapling" | "railways:crafting/palettes/dyeing_8x/magenta_copper_wrapped_locometal" | "minecraft:andesite_wall" | "exdeorum:compressed_sieve/moss_block/golden/fir_sapling" | "minecraft:raiser_armor_trim_smithing_template_smithing_trim" | "exdeorum:compressed_sieve/red_sand/flint/redstone" | "exdeorum:sieve/sand/iron/dead_bush" | "exdeorum:sieve/moss_block/netherite/flowering_oak_sapling" | "thermal:furnace/createcompression/glass/sand/2x" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/sweetpotato" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/ginger" | "immersiveengineering:metalpress/gear_steel" | "immersiveengineering:blueprint/component_electronic" | "railways:sequenced_assembly/track_byg_witch_hazel" | "create:cutting/compat/autumnity/maple_wood" | "immersiveengineering:crafting/connector_lv" | "exdeorum:sieve/crushed_netherrack/iron/crimson_nylium_spores" | "thermal:furnace/createcompression/glass/sand/9x" | "railways:mechanical_crafting/green_brass_wrapped_locometal_boiler" | "railways:crafting/palettes/dyeing_1x/cyan_copper_wrapped_locometal" | "create:milling/compat/environmental/red_hibiscus" | "farmersdelight:cooked_bacon_from_campfire_cooking" | "mcwfurnitures:crimson_triple_drawer" | "exdeorum:sieve/crushed_blackstone/iron/black_dye" | "create:weathered_copper_tile_stairs" | "railways:crafting/palettes/dyeing_8x/cyan_flat_riveted_locometal" | "forgepeacefulmobdrops:blaze_rod" | "exdeorum:sieve/dirt/netherite/carrot" | "create:crafting/kinetics/smart_fluid_pipe" | "createendertransmission:item_transmitter" | "exdeorum:sieve/red_sand/diamond/raw_gold" | "mcwfurnitures:stripped_birch_counter" | "pedestals:machines/bottler/bottler_honey_to_bottle_create" | "create:polished_cut_veridium_from_stone_types_veridium_stonecutting" | "exdeorum:sieve/moss_block/diamond/rainbow_birch_sapling" | "thermal:furnace/createcompression/glass/sand/8x" | "engineeredcompatibility:cloche/botania/light_blue_petal" | "create:filling/compat/vampirism/cursed_grass" | "comforts:sleeping_bag_purple" | "minecraft:brown_glazed_terracotta" | "thermal:furnace/createcompression/glass/sand/7x" | "refinedstorage:coloring_recipes/yellow_crafting_grid" | "create:cut_scoria_wall" | "createcompression:block/cc/zinc/decompress/1x" | "minecraft:warped_trapdoor" | "railways:sequenced_assembly/track_mangrove" | "immersiveengineering:arcfurnace/ore_lead" | "create:crafting/kinetics/fluid_pipe_vertical" | "create:crafting/kinetics/lime_valve_handle_from_other_valve_handle" | "create:crafting/kinetics/mechanical_arm" | "create:cutting/compat/byg/fir_wood" | "storagenetwork:inventory" | "create:milling/compat/byg/peach_leather_flower" | "thermal:furnace/createcompression/glass/sand/6x" | "createcompression:block/cc/zinc/decompress/2x" | "create:cut_diorite_bricks_from_stone_types_diorite_stonecutting" | "mcwfurnitures:acacia_end_table" | "engineersdecor:independent/clinker_brick_stained_slab_recipe" | "exdeorum:sieve/moss_block/netherite/fir_sapling" | "copycats:crafting/copycat_vertical_stairs_from_conversion" | "railways:mechanical_crafting/white_locometal_boiler" | "railways:crafting/palettes/dyeing_1x/yellow_iron_wrapped_locometal_boiler" | "exdeorum:sieve/moss_block/flint/big_dripleaf" | "mowlib:filters/vanilla/individual_mobs/rideable/filter_type_horse" | "refinedstorage:coloring_recipes/lime_grid" | "create:cut_diorite_stairs" | "create:crushing/deepslate_lapis_ore" | "immersiveengineering:crafting/breaker_switch" | "exdeorum:compressed_sieve/sand/string/certus_quartz_crystal" | "minecraft:light_gray_dye_from_azure_bluet" | "exdeorum:sieve/soul_sand/iron/ghast_tear" | "easy_mob_farm:upgrade/filter/no_meat_filter" | "farmersdelight:integration/create/milling/rice_panicle" | "mob_grinding_utils:recipe_mould_blank" | "minecraft:magenta_candle" | "create:milling/compat/byg/crocus" | "create:pressing/compat/betterendforge/end_myclium_path" | "engineeredcompatibility:sawmill/caupona/walnut_slab" | "railways:sequenced_assembly/track_byg_palm_narrow" | "create:crushing/compat/silentgems/moldavite_ore" | "exdeorum:sieve/moss_block/diamond/oak_sapling" | "exdeorum:sieve/crushed_deepslate/netherite/tin_ore_chunk" | "easy_mob_farm:mob_farm/animal_plains_farm/tier3_animal_plains_farm" | "create:compacting/rock_candys/blue_rock_candy_craft" | "create:crushing/compat/galosphere/amethyst" | "nocubes_craftable_md:music_disc_mall" | "railways:crafting/palettes/dyeing_1x/light_blue_flat_riveted_locometal" | "create:splashing/stained_glass" | "sophisticatedbackpacks:advanced_tool_swapper_upgrade" | "create:cutting/compat/biomesoplenty/umbran_log" | "immersiveengineering:arcfurnace/dust_brass" | "exdeorum:compressed_sieve/red_sand/diamond/cactus" | "create:crafting/kinetics/large_water_wheel" | "exdeorum:compressed_sieve/moss_block/diamond/umbran_sapling" | "immersiveengineering:crafting/connector_mv" | "create:polished_cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "immersiveengineering:metalpress/gear_silver" | "farmersdelight:cutting_board" | "createaddition:compat/immersiveengineering/item_application/reinforced_blast_brick" | "mcwfurnitures:mangrove_wardrobe" | "create:milling/compat/regions_unexplored/light_gray_snowbelle" | "engineeredcompatibility:sawmill/forbidden_arcanus/aurum_stairs" | "railways:sequenced_assembly/track_byg_embur_wide" | "create:smelting/lead_ingot_compat_oreganized" | "minecraft:note_block" | "railways:crafting/palettes/dyeing_8x/light_blue_iron_wrapped_locometal_boiler" | "immersiveengineering:metalpress/wire_manyullyn" | "mcwfurnitures:stripped_mangrove_modern_chair" | "peacefulrecipes:bone" | "engineeredcompatibility:fermenter/blue_berry" | "create:cutting/compat/regions_unexplored/stripped_blackwood_log" | "vegandelight:smelting/cooked_tofu" | "exdeorum:compressed_sieve/crushed_deepslate/netherite/lapis_lazuli" | "exdeorum:sieve/red_sand/string/gold_nugget" | "exdeorum:hammer/prismarine" | "createcompression:block/minecraft/copper/decompress/6x" | "minecraft:weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "minecraft:end_crystal" | "exdeorum:sieve/soul_sand/netherite/nether_wart" | "engineeredcompatibility:cloche/botania/yellow_petal" | "imersiveengineering:crusher/createcompression/glass/9x_to_9x_sand" | "exdeorum:compressed_sieve/crushed_deepslate/string/diamond" | "minecraft:shulker_box" | "extradisks:disk/shapeless/65536k_fluid_storage_disk" | "exdeorum:compressed_sieve/dust/diamond/gold_nugget" | "minecraft:white_carpet" | "minecraft:mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting" | "createcompression:block/minecraft/copper/decompress/5x" | "create:cutting/compat/regions_unexplored/green_bioshroom_hyphae" | "exdeorum:dead_crucible" | "create:blasting/nickel_ingot_compat_thermal" | "mcwfurnitures:stripped_birch_desk" | "exdeorum:sieve/gravel/golden/deepslate_pebble" | "minecraft:deepslate_from_compressed_deepslate" | "createcompression:block/minecraft/copper/decompress/4x" | "railways:crafting/palettes/dyeing_1x/brown_riveted_locometal" | "create:crushing/granite/6x_to_6x_red_sand" | "minecraft:magenta_stained_glass" | "railways:crafting/palettes/dyeing_8x/gray_locometal_pillar" | "minecraft:iron_trapdoor" | "create:milling/sandstone/1x_to_1x_sand" | "mcwfurnitures:stripped_crimson_wardrobe" | "exdeorum:barrel_compost/potatoes" | "mcwfurnitures:stripped_crimson_double_drawer_counter" | "createcompression:block/minecraft/copper/decompress/3x" | "exdeorum:sieve/red_sand/flint/cactus" | "createaddition:rolling/brass_ingot" | "minecraft:acacia_pressure_plate" | "create:cutting/compat/byg/stripped_maple_wood" | "exdeorum:sieve/sand/iron/certus_quartz_crystal" | "engineeredcompatibility:sawmill/blue_skies/maple_bookshelf" | "mob_grinding_utils:beheading/zombified_piglin_brute" | "refinedstorage:crafting_grid/light_gray_crafting_grid" | "createaddition:charging/copper_shingle_stairs" | "minecraft:deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "easy_mob_farm:mob_farm/nether_fortress_farm/tier3_nether_fortress_farm" | "railways:crafting/palettes/dyeing_8x/gray_locometal_boiler" | "mcwfurnitures:spruce_large_drawer" | "create:filling/compat/farmersdelight/milk_bottle" | "create_confectionery:marshmallow_recipe" | "create:cut_asurine_brick_stairs" | "railways:sequenced_assembly/track_tfc_acacia_wide" | "mowlib:filters/insertable_filters/clear_filteritemstack" | "engineeredcompatibility:fermenter/whitecurrant" | "exdeorum:dark_oak_barrel" | "easy_mob_farm:mob_farm/jungle_farm/tier1_jungle_farm" | "minecraft:polished_andesite_slab_from_polished_andesite_stonecutting" | "refinedstorage:coloring_recipes/cyan_fluid_grid" | "create:crushing/compat/simplefarming/oat" | "exdeorum:sieve/moss_block/golden/azalea" | "exdeorum:ores/tin_tag" | "immersiveengineering:smelting/ingot_aluminum_from_blasting2" | "immersiveengineering:smelting/ingot_aluminum_from_blasting3" | "create:crafting/kinetics/gearshift" | "createcompression:block/minecraft/copper/decompress/9x" | "pedestals:upgrades/upgrade_breeder" | "mcwfurnitures:oak_large_drawer" | "create:crushing/crimsite" | "engineeredcompatibility:fermenter/crescent_fruit" | "copycats:stonecutting/copycat_ghost_block" | "mcwfurnitures:stripped_cherry_double_drawer" | "exdeorum:water_crucible/carrot" | "railways:sequenced_assembly/track_twilightforest_minewood_wide" | "mekanism:crushing/createcompression/stone/4x_to_4x_cobblestone" | "create:cutting/compat/ars_nouveau/green_archwood_log" | "botania:drum_wild" | "createcompression:block/minecraft/copper/decompress/8x" | "engineersdecor:independent/rebar_concrete_halfslab_recipe_decompose" | "exdeorum:hammer/pointed_dripstone" | "mowlib:filters/insertable_filters/clear_filterrestriction" | "mcwfurnitures:cherry_lower_bookshelf_drawer" | "minecraft:lime_banner" | "railways:sequenced_assembly/lime_conductor_cap" | "refinedstorage:coloring_recipes/green_crafter_manager" | "railways:sequenced_assembly/track_byg_redwood_narrow" | "pedestals:tools/tool_swap/linking_swapping/toolswap_linking_to_backwards" | "exdeorum:sieve/crushed_end_stone/golden/ender_pearl" | "refinedstorage:coloring_recipes/yellow_pattern_grid" | "mcwfurnitures:crimson_kitchen_cabinet" | "minecraft:deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "engineeredcompatibility:sawmill/twilightforest/twilight_oak_stairs" | "railways:mechanical_crafting/green_copper_wrapped_locometal_boiler" | "create:polished_cut_andesite_wall" | "minecraft:cut_copper_from_copper_block_stonecutting" | "copycats:crafting/copycat_step_from_conversion" | "create:cutting/compat/biomesoplenty/fir_log" | "create:cutting/compat/biomesoplenty/stripped_hellbark_log" | "immersiveengineering:crafting/plate_silver_hammering" | "createcompression:block/minecraft/copper/decompress/7x" | "farmersdelight:cabbage_crate" | "mcwfurnitures:stripped_dark_oak_modern_desk" | "mobdropsrecipes_overworld:gunpowder_into_essence" | "exdeorum:compressed_sieve/crushed_deepslate/golden/iridium_ore_chunk" | "exdeorum:sieve/soul_sand/iron/quartz" | "exdeorum:compressed_sieve/crushed_deepslate/iron/lithium_ore_chunk" | "immersiveengineering:crafting/storage_constantan_to_slab" | "create:cutting/compat/upgrade_aquatic/stripped_river_wood" | "railways:crafting/palettes/wrapping/cyan_iron_wrapped_locometal" | "railways:sequenced_assembly/track_natures_spirit_maple" | "farmersdelight:half_tatami_mat" | "storagenetwork:operation_upgrade" | "extrastorage:disk/shaped/disk_256k" | "craftable_spawner:wither_skeleton_spawn_egg" | "create_jetpack:jetpack" | "exdeorum:ores/platinum_tag" | "storagenetwork:collector_remote" | "exdeorum:sieve/soul_sand/flint/gunpowder" | "copycats:crafting/copycat_vertical_step_from_conversion" | "immersiveengineering:crafting/turntable" | "exdeorum:sieve/sand/netherite/certus_quartz_crystal" | "minecraft:crimson_sign" | "railways:sequenced_assembly/track_byg_maple" | "create:crafting/copper/waxed_copper_shingles_from_honeycomb" | "mekanism:crushing/createcompression/cobblestone/5x_to_5x_gravel" | "vegandelight:campfire_cooking/cooked_tofu_slices_from_campfire_cooking" | "minecraft:stone_brick_slab" | "mcwfurnitures:stripped_spruce_bookshelf_cupboard" | "create:cutting/compat/byg/palo_verde_wood" | "railways:sequenced_assembly/track_quark_blossom" | "railways:crafting/fuel_tank" | "exdeorum:compressed_sieve/soul_sand/iron/glowstone_dust" | "railways:crafting/palettes/dyeing_1x/blue_locometal_boiler" | "create:small_andesite_brick_stairs" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/cattail_rich_soil" | "create:cutting/compat/regions_unexplored/baobab_wood" | "create:milling/compat/ae2/sky_stone_block" | "minecraft:stone_slab_from_stone_stonecutting" | "immersiveengineering:mixer/herbicide" | "minecraft:gray_glazed_terracotta" | "exdeorum:compressed_sieve/sand/netherite/cactus" | "immersiveengineering:crafting/treated_wood_packaged_to_slab" | "createcompression:block/minecraft/glowstone/compress/9x" | "create:cut_calcite_wall" | "engineersdecor:dependent/slag_brick_block_recipe" | "mob_grinding_utils:beheading/wither_skeleton" | "pedestals:machines/upgrademodification/drain/drain_range_tier_one" | "mowlib:filters/vanilla/individual_mobs/filter_type_ravenger" | "immersiveengineering:crusher/slag" | "create:crimson_window_pane" | "exdeorum:sieve/crushed_deepslate/iron/osmium_ore_chunk" | "railways:crafting/palettes/wrapping/blue_iron_wrapped_locometal" | "exdeorum:compressed_sieve/gravel/flint/lapis_lazuli" | "create:cutting/birch_log" | "easy_mob_farm:mob_farm/swamp_farm/tier1_swamp_farm" | "exdeorum:sieve/dust/flint/yellorium_dust" | "comforts:sleeping_bag_to_light_blue" | "createcompression:block/minecraft/glowstone/compress/8x" | "immersiveengineering:arcfurnace/dust_steel" | "forgepeacefulmobdrops:zombie_head" | "create:cutting/compat/biomesoplenty/stripped_mahogany_log" | "create:cut_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "minecraft:honey_bottle" | "create:milling/compat/botania/gray_petal" | "immersiveengineering:crafting/stairs_concrete_brick" | "createcompression:block/minecraft/glowstone/compress/7x" | "exmachinis:compacting/iron_ore" | "peacefulrecipes:chain_leggins" | "mcwfurnitures:stripped_mangrove_double_kitchen_cabinet" | "railways:crafting/palettes/dyeing_1x/purple_iron_wrapped_locometal_boiler" | "exdeorum:sieve/crushed_blackstone/diamond/magma_cream" | "create:crafting/kinetics/gantry_shaft" | "exdeorum:sieve/crushed_netherrack/string/cobalt_ore_chunk" | "immersiveengineering:crafting/wall_clinker_brick" | "mcwfurnitures:mangrove_bookshelf_cupboard" | "minecraft:lapis_lazuli" | "create:smelting/soul_sand/4x_to_4x_scoria" | "createcompression:block/minecraft/glowstone/compress/6x" | "pipez:gas_pipe" | "pedestals:machines/bottler/mgu_bucketof_fluidxp" | "exdeorum:compressed_sieve/gravel/netherite/thorium_ore_chunk" | "exdeorum:compressed_sieve/crushed_deepslate/flint/lead_ore_chunk" | "mobdropsrecipes_overworld:rotten_flesh_into_essence" | "create:crushing/terracotta/9x_to_9x_red_sand" | "createaddition:pressing/zinc_ingot" | "minecraft:quartz_block" | "create:cut_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "immersiveengineering:crafting/maintenance_kit" | "create:cutting/compat/ars_nouveau/purple_archwood_log" | "createcompression:block/minecraft/glowstone/compress/5x" | "exdeorum:compressed_sieve/dust/netherite/yellorium_dust" | "exdeorum:compressed_sieve/soul_sand/netherite/nether_wart" | "createsweetsandtreets:cut_rock_candy_recipe_1_green" | "pedestals:machines/cobblegen/generate_netherrack" | "engineersdecor:independent/steel_railing_recipe" | "create:milling/compat/byg/green_tulip" | "createcompression:block/minecraft/birch_plank/compress/7x" | "engineeredcompatibility:sawmill/ecologics/flowering_azalea_slab" | "create:deploying/waxed_oxidized_copper_tiles_from_adding_wax" | "createcompression:block/minecraft/glowstone/compress/4x" | "createcompression:block/minecraft/spruce_plank/compress/3x" | "pedestals:machines/upgrademodification/export/export_entitycontainer" | "easy_mob_farm:mob_farm_template/tier3_mob_farm_template" | "pedestals:upgrades/upgrade_unpackager" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/canola" | "create:splashing/crushed_raw_gold" | "exdeorum:compressed_sieve/moss_block/diamond/spruce_sapling" | "minecraft:coast_armor_trim_smithing_template" | "minecraft:dune_armor_trim_smithing_template" | "createcompression:block/minecraft/birch_plank/compress/6x" | "farmersdelight:cutting/orange_tulip" | "create:cut_veridium_stairs" | "createcompression:block/minecraft/spruce_plank/compress/4x" | "createcompression:block/minecraft/glowstone/compress/3x" | "farmersdelight:cutting/mangrove_door" | "vegandelight:filling/soymilk_bucket_from_filling" | "railways:stonecutting/palettes/cycling/red_flat_riveted_locometal" | "pedestals:tools/manifest" | "mobdropsrecipes_overworld:bone_into_essence" | "minecraft:polished_blackstone_stairs_from_blackstone_stonecutting" | "immersiveengineering:crusher/ingot_aluminum" | "createcompression:block/minecraft/birch_plank/compress/5x" | "refinedstorage:coloring_recipes/gray_disk_manipulator" | "exdeorum:compressed_sieve/dust/iron/blaze_powder" | "exdeorum:sieve/dirt/flint/wheat_seeds" | "createcompression:block/minecraft/glowstone/compress/2x" | "createcompression:block/minecraft/spruce_plank/compress/1x" | "createcompression:block/minecraft/birch_plank/compress/4x" | "railways:sequenced_assembly/track_byg_zelkova_narrow" | "create:crafting/kinetics/orange_seat_from_other_seat" | "minecraft:white_candle" | "minecraft:polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "createcompression:block/minecraft/glowstone/compress/1x" | "createcompression:block/minecraft/spruce_plank/compress/2x" | "minecraft:cobbled_deepslate_wall_from_cobbled_deepslate_stonecutting" | "create:small_asurine_brick_stairs" | "laserio:card_fluid" | "comforts:hammock_to_white" | "immersiveengineering:crafting/watermill" | "storagenetwork:storage_kabel" | "immersiveengineering:sawmill/cherry_log" | "exdeorum:compressed_sieve/soul_sand/iron/gunpowder" | "minecraft:golden_carrot" | "mowlib:filters/vanilla/individual_mobs/filter_type_guardian" | "createcompression:block/minecraft/birch_plank/compress/3x" | "railways:dying_existing_cap_purple" | "createsifter:brass_mesh" | "createcompression:block/minecraft/spruce_plank/compress/8x" | "railways:crafting/palettes/dyeing_8x/gray_iron_wrapped_locometal" | "refinedstorage:coloring_recipes/light_gray_security_manager" | "create:cutting/compat/biomesoplenty/stripped_dead_wood" | "mcwfurnitures:stripped_cherry_bookshelf" | "createcompression:block/minecraft/birch_plank/compress/2x" | "farmersdelight:cooking/beetroot_soup" | "createcompression:block/minecraft/spruce_plank/compress/9x" | "create:crafting/kinetics/attribute_filter" | "immersiveengineering:crafting/stairs_treated_wood_vertical" | "immersiveengineering:smelting/ingot_lead3" | "immersiveengineering:smelting/ingot_lead2" | "exdeorum:compressed_sieve/soul_sand/diamond/quartz" | "create:cutting/compat/blue_skies/frostbright_log" | "pedestals:machines/upgrademodification/dropper/dropper_item_capacity_tier_two" | "exdeorum:compressed_sieve/moss_block/diamond/blue_archwood_sapling" | "createcompression:block/minecraft/spruce_plank/compress/5x" | "createcompression:block/minecraft/birch_plank/compress/1x" | "pedestals:machines/upgrademodification/harvester/harvester_speed_tier_two" | "refinedstorage:coloring_recipes/light_gray_detector" | "createcompression:block/minecraft/spruce_plank/compress/6x" | "minecraft:cherry_sign" | "pedestals:machines/upgrademodification/drain/drain_block_capacity_tier_one" | "railways:crafting/palettes/dyeing_8x/blue_flat_riveted_locometal" | "create:crushing/deepslate_gold_ore" | "exdeorum:compressed_sieve/gravel/diamond/boron_ore_chunk" | "refinedstorage:coloring_recipes/purple_detector" | "farmersdelight:onion_crate" | "pedestals:machines/upgrademodification/breeder/breeder_speed_tier_one" | "railways:sequenced_assembly/orange_conductor_cap" | "mcwfurnitures:stripped_acacia_stool_chair" | "engineeredcompatibility:sawmill/midnight/moonshroom_slab" | "copycats:crafting/copycat_block_from_slabs" | "railways:crafting/palettes/wrapping/green_iron_wrapped_locometal" | "engineersdecor:independent/factory_hopper_recipe" | "exdeorum:compressed_sieve/moss_block/golden/sourceberry_bush" | "createcompression:block/minecraft/spruce_plank/compress/7x" | "farmersdelight:cutting/saddle" | "railways:crafting/palettes/dyeing_1x/magenta_locometal_pillar" | "exdeorum:crimson_sieve" | "farmersdelight:cutting/cherry_hanging_sign" | "minecraft:exposed_cut_copper_stairs" | "pedestals:upgrades/upgrade_placer" | "mobdropsrecipes_overworld:phantom_membrane" | "create:crafting/copper/waxed_exposed_copper_shingle_stairs_from_honeycomb" | "create:polished_cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "exdeorum:compressed_sieve/red_sand/netherite/gold_nugget" | "railways:crafting/palettes/dyeing_8x/white_brass_wrapped_locometal" | "minecraft:stripped_mangrove_wood" | "exdeorum:compressed_sieve/sand/flint/dead_bush" | "exdeorum:sieve/dust/string/gunpowder" | "createsifter:sifting/soul_sand_advanced_brass_mesh" | "railways:sequenced_assembly/magenta_conductor_cap" | "exdeorum:compressed_sieve/crushed_deepslate/flint/tin_ore_chunk" | "minecraft:light_weighted_pressure_plate" | "engineeredcompatibility:sawmill/hexcasting/edified_slab" | "refinedstorage:coloring_recipes/network_transmitter" | "minecraft:dye_green_wool" | "create:crafting/appliances/netherite_diving_helmet" | "create:cut_crimsite_stairs_from_stone_types_crimsite_stonecutting" | "exdeorum:compressed_sieve/moss_block/string/jungle_sapling" | "create:cutting/compat/regions_unexplored/brimwood_log" | "immersiveengineering:smelting/ingot_hop_graphite_from_blasting" | "sophisticatedbackpacks:diamond_backpack" | "minecraft:pink_banner" | "create:polished_cut_granite_stairs_from_stone_types_granite_stonecutting" | "mcwfurnitures:spruce_chair" | "minecraft:copper_ingot_from_waxed_copper_block" | "railways:sequenced_assembly/track_quark_blossom_narrow" | "exdeorum:compressed_sieve/crushed_end_stone/golden/ender_eye" | "immersiveengineering:crafting/empty_shell" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/whitemushroom" | "create:cut_deepslate_slab_recycling" | "engineersdecor:independent/old_industrial_wood_door_recipe" | "railways:mechanical_crafting/red_iron_wrapped_locometal_boiler" | "create:cutting/compat/twilightforest/canopy_log" | "mekanism:crushing/createcompression/stone/1x_to_1x_cobblestone" | "exdeorum:fir_crucible" | "mowlib:filters/vanilla/individual_mobs/baby/filter_type_villager_baby" | "comforts:sleeping_bag_to_cyan" | "create:splashing/ice" | "immersiveengineering:crafting/stick_aluminum" | "exdeorum:sieve/moss_block/flint/glow_lichen" | "engineeredcompatibility:sawmill/ars_nouveau/archwood_bookshelf" | "create:splashing/endergetic/petrified_nether_corrock" | "railways:crafting/palettes/dyeing_1x/light_blue_riveted_locometal" | "minecraft:cut_copper_slab_from_cut_copper_stonecutting" | "mowlib:filters/insertable_filters/filteritemstack" | "exdeorum:compressed_sieve/red_sand/golden/dead_bush" | "railways:stonecutting/palettes/cycling/cyan_flat_riveted_locometal" | "exdeorum:compressed_sieve/dust/diamond/blaze_powder" | "railways:sequenced_assembly/track_twilightforest_darkwood_narrow" | "create:crushing/granite/3x_to_3x_red_sand" | "railways:sequenced_assembly/track_biomesoplenty_magic_wide" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/kenaf" | "createcompression:block/minecraft/copper/decompress/2x" | "exdeorum:compressed_sieve/crushed_blackstone/flint/black_dye" | "mowlib:filters/vanilla/individual_mobs/filter_type_armorstand" | "immersiveengineering:thermoelectric/magma" | "exdeorum:compressed_sieve/crushed_netherrack/diamond/gunpowder" | "create:small_calcite_bricks_from_stone_types_calcite_stonecutting" | "copycats:crafting/copycat_stairs_from_conversion" | "create:copper_shingle_stairs" | "immersiveengineering:metalpress/rod_bronze" | "create:milling/compat/regions_unexplored/white_snowbelle" | "exdeorum:barrel_fluid_mixing/blackstone" | "minecraft:copper_ingot_from_smelting_copper_ore" | "create:compacting/rock_candys/blocks/pink_rock_candy_block" | "create_confectionery:caramel_bricks_recipe" | "create:haunting/glow_berries" | "engineeredcompatibility:cloche/farmersdelight/carrot_rich_soil" | "exdeorum:compressed_sieve/moss_block/netherite/spore_blossom" | "create:small_granite_bricks_from_stone_types_granite_stonecutting" | "minecraft:iron_pickaxe" | "createcompression:block/minecraft/copper/decompress/1x" | "refinedstorage:coloring_recipes/light_gray_wireless_transmitter" | "vegandelight:cooking/pasta_with_tofuballs" | "minecraft:spruce_button" | "create:cut_andesite_from_stone_types_andesite_stonecutting" | "exdeorum:cherry_barrel" | "exdeorum:compressed_sieve/crushed_netherrack/string/gunpowder" | "pipez:wrench" | "create:crushing/asurine" | "ironchest:chests/trapped_iron_chest" | "minecraft:deepslate_tiles" | "pedestals:tools/tool_swap/upgrade_swapping/toolswap_tag_to_upgrade" | "immersiveengineering:sawmill/birch_door" | "exdeorum:sieve/crushed_netherrack/golden/magma_cream" | "immersiveengineering:blueprint/banner_wolf" | "immersiveengineering:crafting/nugget_copper_to_copper_ingot" | "exdeorum:compressed_sieve/moss_block/diamond/fir_sapling" | "minecraft:nether_brick_stairs_from_nether_bricks_stonecutting" | "comforts:hammock_orange" | "createsweetsandtreets:chiseled_yellow" | "create:crushing/sandstone/7x_to_7x_sand" | "railways:crafting/palettes/dyeing_8x/cyan_iron_wrapped_locometal_boiler" | "copycats:crafting/copycat_iron_door" | "refinedstorage:fluid_grid/brown_fluid_grid" | "mowlib:filters/vanilla/individual_mobs/baby/filter_type_horse_baby" | "immersiveengineering:cloche/pink_tulip" | "immersiveengineering:crafting/ingot_nickel_to_storage_nickel" | "immersiveengineering:crafting/sheetmetal_colored_brown_to_slab" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/broccoli_rich_soil" | "pedestals:machines/upgrademodification/furnace/smelter_speed_tier_one" | "immersiveengineering:arc_recycling_list" | "railways:sequenced_assembly/track_byg_sythian" | "exdeorum:sieve/crushed_netherrack/flint/blaze_powder" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/juniperberry" | "create:cutting/compat/blue_skies/lunar_log" | "railways:sequenced_assembly/track_tfc_oak_wide" | "exdeorum:barrel_mixing/slime_block" | "exdeorum:compressed_sieve/crushed_netherrack/golden/raw_gold" | "railways:crafting/palettes/dyeing_8x/light_gray_brass_wrapped_locometal" | "minecraft:yellow_dye_from_dandelion" | "createcompression:block/minecraft/dirt/compress/6x" | "engineersdecor:independent/thin_steel_pole_head_recipe" | "minecraft:sentry_armor_trim_smithing_template_smithing_trim" | "immersiveengineering:crusher/ingot_nickel" | "railways:crafting/palettes/dyeing_1x/blue_copper_wrapped_locometal" | "farmersdelight:cutting/spruce_trapdoor" | "create:crafting/kinetics/item_drain" | "create:deepslate_pillar_from_stone_types_deepslate_stonecutting" | "minecraft:eye_armor_trim_smithing_template" | "exdeorum:compressed_sieve/dirt/flint/flint" | "createcompression:block/minecraft/dirt/compress/7x" | "create:cut_tuff_brick_wall" | "mcwfurnitures:stripped_dark_oak_table" | "engineeredcompatibility:cloche/ars_nouveau/magebloom" | "farmersdelight:cutting/warped_door" | "createcompression:block/minecraft/dirt/compress/8x" | "create:crafting/appliances/crafting_blueprint" | "mcwfurnitures:stripped_spruce_end_table" | "pedestals:machines/bottler/bottler_honey_to_bucket_prodbees" | "extrastorage:disk/shaped/disk_4096k" | "engineeredcompatibility:sawmill/deeperdarker/echo_log" | "minecraft:polished_blackstone_brick_slab_from_blackstone_stonecutting" | "railways:crafting/palettes/dyeing_1x/blue_riveted_locometal" | "railways:stonecutting/palettes/cycling/brown_riveted_locometal" | "createcompression:block/minecraft/dirt/compress/9x" | "copycats:stonecutting/copycat_stone_button" | "minecraft:mangrove_button" | "railways:stonecutting/palettes/cycling/orange_flat_slashed_locometal" | "exdeorum:sieve/sand/diamond/prismarine_shard" | "minecraft:yellow_bed" | "minecraft:nether_brick_slab_from_nether_bricks_stonecutting" | "mcwfurnitures:cherry_modern_desk" | "exdeorum:compressed_sieve/crushed_end_stone/iron/chorus_fruit" | "minecraft:waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "create:cutting/compat/regions_unexplored/ashen_wood" | "immersiveengineering:cloche/rose_bush" | "exdeorum:compressed_sieve/sand/golden/flint" | "exdeorum:compressed_sieve/dirt/iron/deepslate_pebble" | "immersiveengineering:crafting/alu_slope" | "create:cutting/compat/blue_skies/crystallized_wood" | "createcompression:block/minecraft/dirt/compress/2x" | "create:layered_crimsite_from_stone_types_crimsite_stonecutting" | "exdeorum:sieve/moss_block/iron/willow_sapling" | "railways:crafting/palettes/dyeing_1x/gray_locometal_boiler" | "farmersdelight:cutting/jungle_trapdoor" | "minecraft:purple_candle" | "exdeorum:compressed_sieve/gravel/iron/tin_ore_chunk" | "exdeorum:sieve/moss_block/string/willow_sapling" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/huckleberry" | "create:cutting/compat/byg/stripped_ether_log" | "exdeorum:sieve/moss_block/flint/magic_sapling" | "mcwfurnitures:dark_oak_wardrobe" | "mcwfurnitures:stripped_mangrove_glass_table" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/nettles" | "mobdropsrecipes_nether:wither_skeleton_skull" | "mowlib:filters/vanilla/individual_mobs/filter_type_glowsquid" | "createcompression:block/minecraft/dirt/compress/3x" | "railways:crafting/palettes/dyeing_1x/white_locometal_boiler" | "exdeorum:sieve/gravel/flint/granite_pebble" | "create:crushing/raw_tin_block" | "engineeredcompatibility:squeezer/tea_seeds" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/barley" | "railways:crafting/palettes/dyeing_8x/blue_iron_wrapped_locometal" | "create:small_tuff_brick_slab" | "mobdropsrecipes_overworld:essence_into_gunpowder" | "railways:crafting/palettes/dyeing_8x/gray_flat_riveted_locometal" | "railways:crafting/palettes/wrapping/gray_copper_wrapped_locometal" | "extrastorage:storage_block/block_256k" | "minecraft:cobblestone_stairs" | "refinedstorage:coloring_recipes/purple_fluid_grid" | "exdeorum:compressed_sieve/crushed_end_stone/netherite/chorus_flower" | "immersiveengineering:crafting/heavy_engineering" | "exdeorum:compressed_sieve/soul_sand/string/gunpowder" | "create:milling/compat/buzzier_bees/pink_clover" | "create:cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "createcompression:block/minecraft/raw_copper/compress/1x" | "createcompression:block/minecraft/dirt/compress/4x" | "immersiveengineering:crafting/hammercrushing_osmium" | "create:cut_scorchia_brick_wall" | "create:milling/granite/8x_to_8x_red_sand" | "refinedstorage:coloring_recipes/red_crafting_monitor" | "exdeorum:compressed_sieve/crushed_netherrack/string/warped_nylium_spores" | "immersiveengineering:crafting/dynamo" | "pedestals:upgrades/upgrade_filler" | "peacefulrecipes:skeleton_skull" | "farmersdelight:cutting/warped_hyphae" | "mowlib:filters/vanilla/individual_mobs/filter_type_witherskeleton" | "create:cutting/compat/atmospheric/stripped_kousa_wood" | "immersiveengineering:crafting/wirecoil_electrum_ins" | "create:polished_cut_scoria_slab_recycling" | "immersiveengineering:metalpress/wire_invar" | "extrastorage:netherite_crafter" | "create:smelting/cobbled_deepslate/9x_to_9x_deepslate" | "create:cut_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "createcompression:block/minecraft/dirt/compress/5x" | "create:mechanical_crafting/crushing_wheel" | "pedestals:machines/cobblegen/generate_stone" | "exdeorum:umbran_sieve" | "create:cutting/compat/biomesoplenty/redwood_log" | "minecraft:sentry_armor_trim_smithing_template" | "create:splashing/magenta_concrete_powder" | "mowlib:filters/vanilla/individual_mobs/filter_type_snow_golem" | "refinedstorage:quartz_enriched_iron" | "railways:sequenced_assembly/track_tfc_birch_narrow" | "engineeredcompatibility:sawmill/deep_aether/cruderoot_bookshelf" | "railways:crafting/palettes/dyeing_1x/yellow_brass_wrapped_locometal" | "create:milling/compat/environmental/red_lotus_flower" | "waystones:warp_dust" | "create:cut_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "createaddition:pressing/steel_ingot" | "engineeredcompatibility:crusher/ae2/skystone" | "extradisks:blocks/1048576k_fluid_storage_block" | "railways:stonecutting/palettes/cycling/magenta_flat_riveted_locometal" | "exdeorum:compressed_sieve/dirt/netherite/potato" | "exdeorum:sieve/moss_block/iron/hellbark_sapling" | "create:deploying/waxed_exposed_copper_shingle_slab_from_adding_wax" | "imersiveengineering:crusher/createcompression/gravel/7x_to_7x_sand" | "create:crafting/kinetics/yellow_valve_handle_from_other_valve_handle" | "minecraft:repeater" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/wintersquash" | "railways:sequenced_assembly/track_tfc_kapok_wide" | "railways:stonecutting/palettes/cycling/blue_flat_riveted_locometal" | "exdeorum:oak_barrel" | "minecraft:iron_leggings" | "create:emptying/compat/alexsmobs/lava_bottle" | "create:rose_quartz_block_from_rose_quartz_stonecutting" | "extradisks:disk/shapeless/16384k_storage_disk" | "railways:crafting/palettes/dyeing_8x/green_flat_riveted_locometal" | "mekanism:crushing/createcompression/gravel/7x_to_7x_sand" | "minecraft:book_cloning" | "exdeorum:compressed_sieve/red_sand/golden/gold_nugget" | "exdeorum:sieve/moss_block/diamond/redwood_sapling" | "create:cutting/compat/twilightforest/transformation_log" | "mobdropsrecipes_overworld:essence_into_ender_pearl" | "immersiveengineering:crafting/ingot_uranium_to_storage_uranium" | "immersiveengineering:sawmill/acacia_log" | "createcompression:block/minecraft/dirt/compress/1x" | "immersiveengineering:crafting/coal_coke_to_coke" | "create:cut_andesite_wall_from_stone_types_andesite_stonecutting" | "railways:crafting/palettes/dyeing_8x/blue_locometal_boiler" | "create:milling/terracotta/9x_to_9x_red_sand" | "mcwfurnitures:jungle_double_wardrobe" | "exdeorum:sieve/dust/golden/blaze_powder" | "exdeorum:jacaranda_crucible" | "minecraft:mushroom_stew" | "farmersdelight:cooked_mutton_chops_from_smoking" | "createcompression:block/minecraft/blackstone/compress/9x" | "mobdropsrecipes_end:essence_into_shulker_shell" | "exdeorum:compressed_granite" | "railways:sequenced_assembly/track_byg_embur" | "engineeredcompatibility:sawmill/aether/skyroot_stairs" | "railways:crafting/palettes/dyeing_8x/orange_iron_wrapped_locometal_boiler" | "create:cutting/compat/regions_unexplored/dead_wood" | "create:copper_tile_stairs_from_copper_tiles_stonecutting" | "exdeorum:compressed_sieve/moss_block/netherite/magic_sapling" | "create:cutting/compat/integrateddynamics/menril_wood_stripped" | "createcompression:block/minecraft/blackstone/compress/8x" | "create:cutting/compat/regions_unexplored/stripped_yellow_bioshroom_stem" | "create_recipes:netherrackfrommixing" | "minecraft:prismarine_brick_slab" | "createcompression:block/minecraft/blackstone/compress/6x" | "createaddition:filling/chocolate_cake" | "create:cutting/compat/byg/fungal_imparius_hyphae" | "exdeorum:sieve/gravel/flint/gold_ore_chunk" | "minecraft:lapis_lazuli_from_blasting_deepslate_lapis_ore" | "immersiveengineering:crafting/sheetmetal_colored_yellow_to_slab" | "create_confectionery:full_white_chocolate_bar_recipe" | "farmersdelight:rope" | "mowlib:filters/vanilla/individual_mobs/filter_type_ghast" | "exdeorum:compressed_sieve/red_sand/iron/cactus" | "immersiveengineering:crusher/ore_uranium" | "createcompression:block/minecraft/blackstone/compress/7x" | "exdeorum:sieve/dust/string/blaze_powder" | "more_immersive_wires:ae_dense_coil" | "minecraft:polished_andesite_from_andesite_stonecutting" | "portabletanks:expert_portable_tank" | "createcompression:block/minecraft/blackstone/compress/5x" | "create:cut_granite_slab_recycling" | "minecraft:mud_brick_slab_from_mud_bricks_stonecutting" | "copycats:stonecutting/copycat_ladder" | "create:deploying/waxed_oxidized_copper_shingle_stairs_from_adding_wax" | "mobdropsrecipes_nether:essence_into_magma_cream" | "createaddition:filling/treated_wood_planks" | "create:cutting/compat/blue_skies/stripped_lunar_log" | "exdeorum:sieve/dust/golden/raw_gold" | "createcompression:block/minecraft/blackstone/compress/4x" | "minecraft:smooth_stone_slab_from_smooth_stone_stonecutting" | "create:cut_calcite_bricks_from_stone_types_calcite_stonecutting" | "exdeorum:sieve/crushed_end_stone/netherite/chorus_fruit" | "refinedstorage:coloring_recipes/magenta_crafter" | "minecraft:clock" | "mowlib:filters/insertable_filters/clear_filtermod" | "create:crafting/appliances/netherite_diving_helmet_from_netherite" | "immersiveengineering:arcfurnace/raw_block_aluminum" | "exdeorum:compressed_sieve/gravel/iron/iron_ore_chunk" | "immersiveengineering:crafting/raw_aluminum_to_raw_block_aluminum" | "comforts:sleeping_bag_light_gray" | "create:cutting/compat/ars_nouveau/stripped_red_archwood_wood" | "createcompression:block/minecraft/blackstone/compress/3x" | "railways:crafting/palettes/dyeing_8x/cyan_locometal_boiler" | "exdeorum:sieve/crushed_end_stone/string/chorus_fruit" | "railways:sequenced_assembly/track_create_dd_spirit" | "pedestals:upgrades/upgrade_pump" | "forgepeacefulmobdrops:ghast_tear" | "create:milling/compat/byg/protea_flower" | "mcwfurnitures:stripped_oak_double_drawer_counter" | "create:filling/compat/neapolitan/milk_bottle" | "minecraft:blue_ice" | "railways:benchcart" | "exdeorum:crucible_heat_source/lantern" | "minecraft:diamond_leggings" | "createcompression:block/minecraft/blackstone/compress/2x" | "exdeorum:compressed_sieve/moss_block/golden/red_archwood_sapling" | "minecraft:purple_stained_glass" | "exdeorum:compressed_sieve/crushed_blackstone/netherite/blackstone_pebble" | "railways:crafting/palettes/wrapping/pink_brass_wrapped_locometal" | "rebornstorage:parts/medium_item_disk_part" | "vegandelight:smoking/cooked_smoked_tofu_from_smoking" | "mcwfurnitures:stripped_oak_covered_desk" | "laserio:filter_nbt_nbtclear" | "exdeorum:sieve/dust/iron/iron_nugget" | "exmachinis:compacting/ato/aluminum_ore" | "railways:stonecutting/palettes/cycling/brown_plated_locometal" | "create:polished_cut_deepslate_slab_from_stone_types_deepslate_stonecutting" | "createcompression:block/minecraft/blackstone/compress/1x" | "peacefulrecipes:wither_skeleton_skull" | "minecraft:polished_andesite_slab_from_andesite_stonecutting" | "minecraft:dye_black_bed" | "refinedstorage:4096k_fluid_storage_disk_from_storage_housing" | "exdeorum:compressed_sieve/dust/netherite/glowstone_dust" | "railways:crafting/palettes/dyeing_1x/blue_locometal_smokebox" | "create:milling/terracotta/3x_to_3x_red_sand" | "exdeorum:compressed_sieve/dirt/iron/flint" | "create:cutting/compat/byg/stripped_baobab_wood" | "create:milling/sunflower" | "minecraft:mossy_stone_bricks_from_moss_block" | "engineeredcompatibility:crusher/sawdust" | "liquidburner:napalm" | "create:cutting/compat/upgrade_aquatic/stripped_river_log" | "exdeorum:compressed_sieve/crushed_blackstone/string/magma_cream" | "farmersdelight:iron_nugget_from_smelting_knife" | "engineeredcompatibility:crusher/aether/ore_ambrosium" | "create:cutting/compat/twilightforest/time_wood" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/greengrape_rich_soil" | "immersiveengineering:crafting/sheetmetal_constantan" | "exdeorum:compressed_sieve/crushed_deepslate/diamond/emerald" | "refinedstorage:crafting_grid/magenta_crafting_grid" | "immersiveengineering:arcfurnace/raw_block_cobalt" | "exdeorum:compressed_sieve/gravel/diamond/emerald" | "railways:crafting/palettes/dyeing_8x/cyan_locometal_smokebox" | "createaddition:rolling/copper_ingot" | "create:crafting/kinetics/mechanical_piston" | "create:splashing/oreganized/crushed_raw_silver" | "engineeredcompatibility:crusher/blue_skies/ore_aquite" | "exdeorum:compressed_sieve/crushed_deepslate/netherite/lithium_ore_chunk" | "farmersdelight:bacon_sandwich" | "railways:sequenced_assembly/track_tfc_pine_narrow" | "minecraft:wooden_shovel" | "railways:sequenced_assembly/track_twilightforest_twilight_oak_narrow" | "immersiveengineering:arcfurnace/ore_platinum" | "immersiveengineering:bottling/mud" | "peacefulrecipes:music_disc_stal" | "createsweetsandtreets:cut_rock_candy_recipe_2_purple" | "minecraft:bamboo_trapdoor" | "create:cutting/compat/biomesoplenty/dead_log" | "create:deploying/waxed_copper_block_from_adding_wax" | "create:item_application/railway_casing" | "farmersdelight:lead_from_straw" | "exdeorum:sieve/gravel/netherite/aluminum_ore_chunk" | "minecraft:waxed_copper_block_from_honeycomb" | "exdeorum:compressed_sieve/crushed_deepslate/iron/uranium_ore_chunk" | "create:copper_bars_from_ingots_copper_stonecutting" | "minecraft:warped_fungus_on_a_stick" | "engineeredcompatibility:cloche/botania/purple_petal_rich_soil" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/spiceleaf" | "create:pressing/aether_dirt_path_from_grass" | "exdeorum:sieve/crushed_deepslate/netherite/platinum_ore_chunk" | "minecraft:gold_ingot_from_smelting_raw_gold" | "engineeredcompatibility:crusher/irons_spellbooks/frozen_bone" | "exdeorum:sieve/sand/string/cactus" | "create:cutting/compat/regions_unexplored/pine_wood" | "farmersdelight:cyan_canvas_sign" | "minecraft:cooked_cod_from_smoking" | "peacefulrecipes:music_disc_mall" | "railways:mechanical_crafting/pink_locometal_boiler" | "cabletiers:ultra_exporter" | "immersiveengineering:crafting/storage_silver_to_slab" | "ironchest:chests/gold_diamond_chest" | "forgepeacefulmobdrops:rabbit_hide" | "railways:stonecutting/palettes/cycling/purple_locometal_smokebox" | "immersiveengineering:mineral/laterite" | "create:crushing/compat/byg/blue_nether_quartz_ore" | "engineeredcompatibility:arcfurnace/blue_skies/raw_block_ventium" | "exdeorum:sieve/crushed_deepslate/flint/silver_ore_chunk" | "minecraft:copper_ingot" | "railways:crafting/handcar" | "create:cut_veridium_brick_stairs" | "immersiveengineering:cloche/cornflower" | "engineeredcompatibility:sawmill/twilightforest/transwood_door" | "minecraft:waxed_weathered_cut_copper_slab" | "create:crushing/cobblestone/8x_to_8x_gravel" | "engineeredcompatibility:sawmill/aether_redux/fieldsproot_slab" | "immersiveengineering:blueprint/bullet_wolfpack" | "railways:crafting/palettes/dyeing_1x/red_copper_wrapped_locometal_boiler" | "create:haunting/glow_ink_sac" | "engineeredcompatibility:sawmill/aether_redux/blightwillow_door" | "copycats:stonecutting/copycat_shaft" | "minecraft:end_stone_brick_wall" | "exdeorum:compressed_sieve/moss_block/string/maple_sapling" | "exdeorum:sieve/moss_block/golden/glow_berries" | "exdeorum:compressed_sieve/moss_block/netherite/sourceberry_bush" | "craftable_spawner:husk_spawn_egg" | "create_confectionery:white_chocolate_candy_2_recipe" | "mcwfurnitures:spruce_bookshelf_cupboard" | "mekanism:enriching/createcompression/sand/9x_to_9x_gravel" | "immersiveengineering:smelting/nugget_steel_recycle_pick" | "exdeorum:sieve/moss_block/golden/orange_autumn_sapling" | "exdeorum:sieve/sand/golden/raw_gold" | "immersiveengineering:cloche/wither_rose" | "peco:slime_ball" | "create:cutting/compat/byg/rainbow_eucalyptus_wood" | "engineersdecor:independent/sign_laser_recipe" | "minecraft:waxed_oxidized_cut_copper_stairs_from_honeycomb" | "exdeorum:compressed_sieve/moss_block/iron/snowblossom_sapling" | "exdeorum:golden_mesh_from_iron_mesh" | "extrastorage:disk/shaped/disk_65536k_fluid" | "exdeorum:barrel_fluid_mixing/obsidian" | "minecraft:oak_sign" | "engineeredcompatibility:sawmill/aether_redux/cloudcap_door" | "create:milling/compat/botania/black_petal" | "railways:crafting/palettes/dyeing_8x/magenta_iron_wrapped_locometal" | "exdeorum:sieve/crushed_deepslate/netherite/thorium_ore_chunk" | "engineeredcompatibility:sawmill/blue_skies/comet_log" | "immersiveengineering:crafting/storage_electrum_to_ingot_electrum" | "exdeorum:sieve/dirt/golden/golden_carrot" | "exdeorum:ores/lead_tag" | "immersiveengineering:stonecutting/slab_concrete_tile" | "immersiveengineering:crafting/alloybrick" | "immersiveengineering:crafting/sheetmetal_colored_magenta" | "railways:sequenced_assembly/track_byg_zelkova" | "create:cutting/compat/botania/livingwood" | "mcwfurnitures:mangrove_double_drawer" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/rutabaga_rich_soil" | "minecraft:shield_decoration" | "create:cutting/compat/tconstruct/stripped_bloodshroom_log" | "create:cut_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "engineeredcompatibility:sawmill/twilightforest/sortingwood_log" | "exdeorum:sieve/crushed_deepslate/netherite/magnesium_ore_chunk" | "create:small_diorite_brick_slab_from_stone_types_diorite_stonecutting" | "rebornstorage:disks/medium_item_disk" | "create:cut_limestone_brick_slab_from_stone_types_limestone_stonecutting" | "farmersdelight:cooking/hot_cocoa" | "create:cutting/compat/biomesoplenty/willow_wood" | "refinedstorage:wrench" | "immersiveengineering:crafting/storage_uranium_to_ingot_uranium" | "create:small_tuff_bricks_from_stone_types_tuff_stonecutting" | "exdeorum:barrel_compost/cookie" | "exdeorum:compressed_sieve/crushed_deepslate/string/iridium_ore_chunk" | "minecraft:birch_planks" | "create:small_calcite_brick_slab" | "create:cutting/compat/regions_unexplored/stripped_baobab_wood" | "refinedstorage:coloring_recipes/purple_pattern_grid" | "minecraft:end_stone_from_compressed_end_stone" | "engineeredcompatibility:sawmill/undergarden/grongle_log" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/eggplant_rich_soil" | "exdeorum:compressed_sieve/crushed_deepslate/golden/boron_ore_chunk" | "create_confectionery:white_chocolate_recipe" | "create:diorite_pillar_from_stone_types_diorite_stonecutting" | "exdeorum:sieve/moss_block/flint/sourceberry_bush" | "exdeorum:sieve/sand/iron/prismarine_crystals" | "exdeorum:compressed_sieve/moss_block/netherite/purple_archwood_sapling" | "create:emptying/compat/neapolitan/milk_bottle" | "comforts:sleeping_bag_magenta" | "create:small_veridium_brick_wall_from_stone_types_veridium_stonecutting" | "minecraft:dye_magenta_carpet" | "extradisks:part/1024k_storage_part" | "create:polished_cut_andesite_from_stone_types_andesite_stonecutting" | "minecraft:weathered_cut_copper_stairs_from_weathered_cut_copper_stonecutting" | "immersiveengineering:crafting/sheetmetal_colored_green" | "farmersdelight:cooking/noodle_soup" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_copper_stonecutting" | "create:cutting/compat/autumnity/stripped_maple_wood" | "exdeorum:sieve/gravel/flint/iron_ore_chunk" | "refinedstorage:64k_storage_part" | "sophisticatedbackpacks:tank_upgrade" | "create_confectionery:gingerbread_block_recipe" | "mcwfurnitures:crimson_table" | "exdeorum:calcite" | "create:crushing/compat/silentgems/iolite_ore" | "minecraft:brown_bed" | "railways:stonecutting/palettes/cycling/gray_plated_locometal" | "exdeorum:bamboo_sieve" | "refinedstorage:coloring_recipes/lime_wireless_transmitter" | "immersiveengineering:crafting/stairs_alu_scaffolding_grate_top" | "mob_grinding_utils:recipe_fan_upgrade_width" | "pedestals:augments/dualhanded_t4_storage" | "railways:sequenced_assembly/track_tfc_hickory" | "create:crushing/ochrum_recycling" | "exdeorum:compressed_sieve/crushed_deepslate/netherite/gold_ore_chunk" | "immersiveengineering:cloche/white_tulip" | "exdeorum:sieve/gravel/string/thorium_ore_chunk" | "mcwfurnitures:oak_modern_wardrobe" | "createcompression:block/minecraft/lapis/compress/9x" | "exdeorum:sieve/dust/iron/glowstone_dust" | "exdeorum:sieve/moss_block/golden/redwood_sapling" | "engineeredcompatibility:sawmill/ancient_aether/sakura_slab" | "extradisks:blocks/16384k_fluid_storage_block" | "minecraft:jack_o_lantern" | "minecraft:tripwire_hook" | "refinedstorage:interface" | "exdeorum:crucible_heat_source/fire" | "exdeorum:barrel_compost/dead_bush" | "create:cut_calcite_stairs_from_stone_types_calcite_stonecutting" | "pedestals:machines/upgrademodification/placer/placer_range_tier_one" | "exdeorum:sieve/crushed_netherrack/flint/basalt_pebble" | "craftable_spawner:endermite_spawn_egg" | "create:cutting/compat/byg/stripped_cypress_wood" | "engineeredcompatibility:crusher/blue_skies/crystal_sandstone" | "create:crafting/appliances/copper_backtank" | "exdeorum:compressed_cobblestone" | "extrastorage:disk/shaped/disk_262144k_fluid" | "refinedstorage:fluid_grid/gray_fluid_grid" | "exdeorum:sieve/crushed_deepslate/flint/iron_ore_chunk" | "exdeorum:compressed_sieve/gravel/diamond/magnesium_ore_chunk" | "immersiveengineering:smelting/nugget_steel_recycle_sword" | "exdeorum:compressed_sieve/moss_block/netherite/dark_oak_sapling" | "immersiveengineering:crafting/ingot_silver_to_storage_silver" | "engineeredcompatibility:sawmill/deep_aether/sunroot_log" | "mcwfurnitures:birch_stool_chair" | "engineeredcompatibility:arcfurnace/blue_skies/raw_block_falsite" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/barley_rich_soil" | "engineeredcompatibility:sawmill/aether/skyroot_slab" | "railways:crafting/palettes/dyeing_1x/blue_iron_wrapped_locometal_boiler" | "create:crafting/appliances/netherite_backtank_from_netherite" | "exdeorum:sieve/crushed_deepslate/iron/magnesium_ore_chunk" | "refinedstorage:coloring_recipes/cyan_security_manager" | "immersiveengineering:mineral/nether_silt" | "minecraft:waxed_weathered_cut_copper_from_honeycomb" | "mowlib:filters/insertable_filters/filterrestriction" | "comforts:sleeping_bag_red" | "refinedstorage:coloring_recipes/cyan_relay" | "mcwfurnitures:stripped_acacia_striped_chair" | "exdeorum:compressed_sieve/soul_sand/iron/ghast_tear" | "create:copper_shingles_from_ingots_copper_stonecutting" | "exdeorum:compressed_sieve/moss_block/netherite/azalea" | "refinedstorage:coloring_recipes/lime_network_transmitter" | "engineeredcompatibility:sawmill/blue_skies/bluebright_bookshelf" | "copycats:stonecutting/copycat_door" | "engineeredcompatibility:cloche/botania/lime_petal_rich_soil" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/peas_rich_soil" | "exdeorum:compressed_sieve/sand/iron/gold_nugget" | "immersiveengineering:crafting/stairs_slag_brick" | "exdeorum:compressed_sieve/red_sand/iron/redstone" | "mcwfurnitures:stripped_oak_bookshelf" | "immersiveengineering:crafting/wire_electrum" | "minecraft:waxed_oxidized_cut_copper_slab" | "immersiveengineering:cloche/peony" | "railways:sequenced_assembly/track_biomesoplenty_hellbark_narrow" | "mekanism:crushing/createcompression/gravel/4x_to_4x_sand" | "engineeredcompatibility:sawmill/blue_skies/bluebright_door" | "railways:sequenced_assembly/track_biomesoplenty_fir_narrow" | "create:crafting/kinetics/piston_extension_pole" | "exdeorum:sieve/red_sand/diamond/dead_bush" | "exdeorum:compressed_sieve/soul_sand/string/glowstone_dust" | "create:cut_crimsite_wall" | "minecraft:lime_dye_from_smelting" | "mob_grinding_utils:recipe_saw_upgrade_sharpness" | "engineeredcompatibility:cloche/botania/orange_petal_rich_soil" | "exdeorum:compressed_sieve/moss_block/flint/cherry_sapling" | "create:cut_limestone_slab" | "exdeorum:sieve/moss_block/netherite/willow_sapling" | "minecraft:weathered_cut_copper_stairs" | "railways:mechanical_crafting/light_gray_brass_wrapped_locometal_boiler" | "vegandelight:cooking/ink_sac" | "extradisks:part/1048576k_fluid_storage_part" | "farmersdelight:cutting/spruce_door" | "immersiveengineering:crafting/concrete_brick_from_slab" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/cauliflower" | "exdeorum:compressed_sieve/sand/diamond/certus_quartz_crystal" | "exdeorum:sieve/gravel/iron/iron_ore_chunk" | "create:cutting/compat/upgrade_aquatic/river_log" | "railways:crafting/palettes/dyeing_1x/lime_flat_riveted_locometal" | "mcwfurnitures:birch_glass_table" | "create:milling/sugar_cane" | "refinedstorage:coloring_recipes/green_network_transmitter" | "mcwfurnitures:stripped_crimson_bookshelf_drawer" | "refinedstorage:coloring_recipes/orange_network_receiver" | "exdeorum:crystallized_sieve" | "engineeredcompatibility:sawmill/twilightforest/canopy_log" | "create:smelting/tin_ingot_compat_thermal" | "mcwfurnitures:spruce_table" | "copycats:stonecutting/copycat_wooden_pressure_plate" | "minecraft:shield" | "minecraft:blackstone_slab" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/peanut_rich_soil" | "exdeorum:sieve/dirt/netherite/deepslate_pebble" | "rebornstorage:parts/super_advanced_processor" | "create:small_dripstone_bricks_from_stone_types_dripstone_stonecutting" | "pedestals:machines/upgrademodification/import/import_item_capacity_tier_one" | "create:cut_crimsite_wall_from_stone_types_crimsite_stonecutting" | "minecraft:quartz_bricks" | "nocubes_craftable_md:music_disc_otherside" | "minecraft:map_cloning" | "immersiveengineering:crafting/wirecoil_redstone" | "railways:sequenced_assembly/track_twilightforest_timewood_narrow" | "exdeorum:sieve/gravel/golden/silver_ore_chunk" | "exdeorum:sieve/dust/flint/glowstone_dust" | "refinedstorage:coloring_recipes/yellow_disk_manipulator" | "create:crafting/kinetics/brown_valve_handle_from_other_valve_handle" | "create:cut_deepslate_brick_slab_recycling" | "createaddition:crafting/spool" | "mcwfurnitures:stripped_oak_large_drawer" | "minecraft:acacia_stairs" | "farmersdelight:cutting/bamboo_door" | "waystones:warp_plate" | "pedestals:machines/upgrademodification/magnet/magnet_area_tier_one" | "exmachinis:compacting/tuff" | "minecraft:raw_gold_block" | "minecraft:birch_door" | "immersiveengineering:blueprint/bullet_flare_red" | "exdeorum:compressed_sieve/moss_block/golden/blue_archwood_sapling" | "exdeorum:compressed_sieve/dirt/string/bamboo" | "immersiveengineering:crafting/alu_scaffolding_standard_from_slab" | "exdeorum:crushed_blackstone_from_compressed_crushed_blackstone" | "railways:sequenced_assembly/track_tfc_ash_narrow" | "mcwfurnitures:stripped_dark_oak_kitchen_cabinet" | "immersiveengineering:cloche/orange_tulip" | "engineersdecor:independent/rebar_concrete_stairs_recipe_decompose" | "railways:stonecutting/palettes/cycling/brown_locometal_pillar" | "mcwfurnitures:crimson_double_wardrobe" | "mowlib:filters/insertable_filters/clear_filteritemmachine" | "immersiveengineering:stonecutting/hempcrete_chiseled" | "minecraft:birch_fence_gate" | "minecraft:gold_ingot_from_blasting_nether_gold_ore" | "railways:sequenced_assembly/track_blue_skies_dusk_wide" | "exdeorum:sieve/crushed_end_stone/golden/ender_eye" | "create:pressing/compat/vampirism/cursed_earth_path" | "forgepeacefulmobdrops:rotten_flesh_from_chicken" | "create:small_scorchia_brick_wall_from_stone_types_scorchia_stonecutting" | "exdeorum:compressed_sieve/soul_sand/flint/warped_nylium_spores" | "exdeorum:lava_crucible/stone" | "exdeorum:sieve/moss_block/golden/flowering_oak_sapling" | "immersiveengineering:sawmill/spruce_wood" | "sophisticatedbackpacks:auto_smoking_upgrade" | "pedestals:machines/upgrademodification/attacker/attacker_speed_tier_two" | "minecraft:mud_brick_wall" | "create:cut_deepslate_from_stone_types_deepslate_stonecutting" | "immersiveengineering:alloysmelter/rose_gold" | "mcwfurnitures:jungle_large_drawer" | "minecraft:prismarine_wall_from_prismarine_stonecutting" | "railways:dying_existing_cap_cyan" | "create:cutting/compat/forbidden_arcanus/aurum_wood" | "create:cutting/compat/botania/glimmering_stripped_livingwood" | "create:cutting/compat/byg/stripped_jacaranda_log" | "minecraft:redstone_block" | "mowlib:filters/vanilla/individual_mobs/filter_type_cod" | "create_recipes:zincnuggetcrushing" | "railways:sequenced_assembly/track_byg_baobab_wide" | "minecraft:honeycomb_block" | "vegandelight:cooking/agave" | "railways:crafting/palettes/dyeing_8x/black_slashed_locometal" | "immersiveengineering:crafting/storage_lead_to_ingot_lead" | "exdeorum:compressed_sieve/crushed_netherrack/string/basalt_pebble" | "exdeorum:sieve/sand/diamond/iron_nugget" | "createaddition:liquid_burning/gasoline" | "create:vertical_framed_glass_from_glass_colorless_stonecutting" | "exdeorum:sieve/moss_block/iron/small_dripleaf" | "minecraft:dye_pink_bed" | "create_confectionery:bar_of_black_chocolate_recipe" | "createcompression:block/cc/limestone/decompress/8x" | "create:crafting/materials/electron_tube" | "createcompression:block/minecraft/oak_plank/compress/8x" | "exdeorum:redwood_compressed_sieve" | "nocubes_craftable_md:music_disc_chirp" | "farmersdelight:wheat_dough_from_water" | "create_recipes:diamondpressing" | "immersiveengineering:crafting/fluid_placer" | "extradisks:blocks/256k_storage_block" | "exdeorum:sieve/red_sand/golden/raw_gold" | "createcompression:block/cc/zinc/compress/4x" | "createsifter:sifting/gravel_brass_mesh" | "createcompression:block/cc/limestone/decompress/7x" | "createcompression:block/minecraft/oak_plank/compress/7x" | "create:cutting/compat/regions_unexplored/silver_birch_wood" | "exdeorum:compressed_sieve/dust/string/glowstone_dust" | "create:cutting/compat/ars_nouveau/blue_archwood_wood" | "mowlib:filters/vanilla/individual_mobs/filter_type_drown" | "mcwfurnitures:stripped_jungle_table" | "exdeorum:barrel_compost/mutton" | "create:cut_granite_stairs" | "minecraft:dye_cyan_carpet" | "createcompression:block/cc/zinc/compress/5x" | "create:cut_scoria_brick_slab" | "create:crushing/andesite/7x_to_7x_cobblestone" | "exdeorum:compressed_sieve/red_sand/flint/raw_gold" | "create:filling/redstone" | "engineersdecor:independent/dense_grit_sand_block_recipe" | "createcompression:block/minecraft/oak_plank/compress/6x" | "railways:crafting/palettes/dyeing_8x/red_copper_wrapped_locometal_boiler" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/scallion_rich_soil" | "minecraft:oxidized_cut_copper_stairs" | "exdeorum:sieve/moss_block/string/rainbow_birch_sapling" | "immersiveengineering:crafting/wirecoil_electrum" | "immersiveengineering:metalpress/electrode" | "pedestals:machines/bottler/bottler_milk_bottle_farmd" | "minecraft:mangrove_trapdoor" | "minecraft:diamond_boots" | "mcwfurnitures:birch_lower_triple_drawer" | "mowlib:filters/vanilla/individual_mobs/filter_type_squid" | "mcwfurnitures:spruce_double_drawer" | "createcompression:block/cc/zinc/compress/2x" | "nocubes_craftable_md:music_disc_far" | "mcwfurnitures:stripped_birch_chair" | "refinedstorage:coloring_recipes/white_security_manager" | "refinedstorage:raw_advanced_processor" | "minecraft:stick" | "createcompression:block/cc/limestone/decompress/9x" | "exdeorum:compressed_sieve/dirt/diamond/potato" | "immersiveengineering:metalpress/wire_nickel" | "create:cut_limestone_slab_recycling" | "createcompression:block/minecraft/oak_plank/compress/5x" | "railways:sequenced_assembly/track_create_dd_rose" | "farmersdelight:cooking/glow_berry_custard" | "create:crafting/kinetics/red_seat" | "create:deploying/waxed_copper_shingle_slab_from_adding_wax" | "immersiveengineering:crafting/constantan_mix" | "immersiveengineering:sawmill/spruce_stairs" | "extradisks:advanced_storage_housing" | "createcompression:block/cc/zinc/compress/3x" | "immersiveengineering:metalpress/gear_lead" | "create:crafting/kinetics/track_observer_from_other_plates" | "create:cutting/compat/regions_unexplored/joshua_log" | "minecraft:dried_kelp_from_campfire_cooking" | "minecraft:cobblestone_from_compressed_cobblestone" | "exdeorum:compressed_sieve/crushed_blackstone/string/ancient_debris" | "create:cut_ochrum_stairs_from_stone_types_ochrum_stonecutting" | "mcwfurnitures:cherry_glass_kitchen_cabinet" | "immersiveengineering:sawmill/stripped_oak_log" | "create:cutting/stripped_mangrove_log" | "vegandelight:smelting/cooked_tofu_slices" | "mcwfurnitures:mangrove_double_kitchen_cabinet" | "engineeredcompatibility:sawmill/midnight/dewshroom_door" | "createcompression:block/minecraft/oak_plank/compress/4x" | "create:pressing/gold_ingot" | "pedestals:machines/upgrademodification/import/import_dust_capacity_tier_one" | "railways:stonecutting/palettes/cycling/cyan_plated_locometal" | "create:crafting/kinetics/light_gray_seat_from_other_seat" | "farmersdelight:cutting/chocolate_pie" | "create:cutting/compat/regions_unexplored/palm_wood" | "createcompression:block/minecraft/oak_plank/compress/3x" | "farmersdelight:horse_feed" | "createcompression:block/cc/zinc/compress/1x" | "createaddition:compat/tconstruct/blaze_blood" | "create:pressing/peat_dirt_path" | "mcwfurnitures:stripped_mangrove_kitchen_cabinet" | "railways:stonecutting/palettes/cycling/blue_plated_locometal" | "createcompression:block/minecraft/basalt/decompress/1x" | "refinedstorage:coloring_recipes/brown_fluid_grid" | "minecraft:brown_stained_glass_pane" | "immersiveengineering:crafting/strip_curtain" | "minecraft:black_terracotta" | "immersiveengineering:crafting/voltmeter" | "createcompression:block/minecraft/oak_plank/compress/2x" | "mcwfurnitures:spruce_counter" | "mcwfurnitures:spruce_glass_kitchen_cabinet" | "create:splashing/endergetic/petrified_overworld_corrock" | "exdeorum:sieve/crushed_deepslate/golden/deepslate_pebble" | "create:crafting/kinetics/pink_valve_handle_from_other_valve_handle" | "engineeredcompatibility:sawmill/ecologics/azalea_slab" | "minecraft:spruce_slab" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/asparagus_rich_soil" | "createcompression:block/minecraft/basalt/decompress/2x" | "refinedstorage:coloring_recipes/pattern_grid" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/amaranth" | "createcompression:block/minecraft/oak_plank/compress/1x" | "create:compacting/andesite_from_flint" | "createcompression:block/minecraft/lapis/compress/2x" | "createcompression:block/minecraft/raw_copper/compress/3x" | "immersiveengineering:crafting/stairs_steel_scaffolding_standard" | "railways:sequenced_assembly/track_hexcasting_edified_wide" | "createcompression:block/minecraft/basalt/decompress/3x" | "exdeorum:green_archwood_compressed_sieve" | "minecraft:pumpkin_pie" | "create:crushing/compat/exnihilosequentia/dust" | "immersiveengineering:crafting/stairs_steel_scaffolding_wooden_top" | "railways:crafting/palettes/dyeing_1x/light_gray_iron_wrapped_locometal_boiler" | "storagenetwork:exchange" | "exdeorum:magic_crucible" | "createcompression:block/minecraft/raw_copper/compress/2x" | "createcompression:block/minecraft/lapis/compress/1x" | "refinedstorage:coloring_recipes/black_network_receiver" | "createcompression:block/minecraft/basalt/decompress/4x" | "pedestals:machines/upgrademodification/shearer/sheerer_area_tier_one" | "exdeorum:sieve/moss_block/netherite/glow_berries" | "waystones:blue_sharestone" | "sophisticatedbackpacks:chipped/tinkering_table_upgrade" | "immersiveengineering:smelting/ingot_electrum_from_dust_from_blasting" | "create:crushing/deepslate_diamond_ore" | "exdeorum:sieve/moss_block/netherite/cherry_sapling" | "minecraft:gold_ingot_from_smelting_nether_gold_ore" | "create:cut_deepslate_stairs_from_stone_types_deepslate_stonecutting" | "createcompression:block/minecraft/lapis/compress/4x" | "exdeorum:barrel_compost/berries" | "exdeorum:sieve/crushed_deepslate/string/emerald" | "createcompression:block/minecraft/raw_copper/compress/5x" | "exdeorum:compressed_sieve/gravel/iron/deepslate_pebble" | "railways:sequenced_assembly/track_tfc_spruce_wide" | "createcompression:block/minecraft/basalt/decompress/5x" | "extradisks:disk/shaped/65536k_fluid_storage_disk" | "railways:sequenced_assembly/track_twilightforest_transwood_wide" | "more_immersive_wires:ae_coil" | "engineeredcompatibility:cloche/ars_nouveau/sourceberries" | "engineersdecor:independent/clinker_brick_wall_recipe" | "extradisks:disk/shapeless/infinite_fluid_storage_disk" | "pedestals:machines/cobblegen/generate_podzol" | "exdeorum:sieve/crushed_end_stone/netherite/ender_eye" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/cactusfruit_rich_soil" | "railways:crafting/palettes/dyeing_1x/purple_flat_slashed_locometal" | "createcompression:block/minecraft/lapis/compress/3x" | "createcompression:block/minecraft/raw_copper/compress/4x" | "refinedstorage:coloring_recipes/pink_detector" | "engineeredcompatibility:arcfurnace/bloodmagic/ore_demonite" | "createcompression:block/minecraft/basalt/decompress/6x" | "create:small_ochrum_bricks_from_stone_types_ochrum_stonecutting" | "mowlib:filters/vanilla/individual_mobs/filter_type_cat" | "extradisks:disk/shaped/infinite_storage_disk" | "engineeredcompatibility:fermenter/fig" | "createcompression:block/cc/refined_radiance_block/compress" | "mcwfurnitures:mangrove_bookshelf" | "createaddition:pressing/aluminum_ingot" | "mcwfurnitures:spruce_kitchen_cabinet" | "createcompression:block/minecraft/lapis/compress/6x" | "createcompression:block/minecraft/basalt/decompress/7x" | "createcompression:block/minecraft/raw_copper/compress/7x" | "railways:sequenced_assembly/track_tfc_pine" | "refinedstorage:1024k_fluid_storage_block" | "exdeorum:barrel_compost/golden_carrot" | "minecraft:lapis_lazuli_from_blasting_lapis_ore" | "engineersdecor:independent/iron_floor_edge_light_recipe" | "engineeredcompatibility:sawmill/undergarden/wigglewood_stairs" | "mcwfurnitures:warped_stool_chair" | "minecraft:rib_armor_trim_smithing_template" | "easy_mob_farm:mob_farm/jungle_farm/tier2_jungle_farm" | "exdeorum:compressed_sieve/sand/diamond/flint" | "railways:mechanical_crafting/purple_brass_wrapped_locometal_boiler" | "minecraft:cooked_chicken_from_campfire_cooking" | "create:emptying/compat/farmersdelight/milk_bottle" | "minecraft:gravel_from_compressed_gravel" | "easy_mob_farm:mob_farm/bee_hive_farm/tier2_bee_hive_farm" | "createcompression:block/minecraft/lapis/compress/5x" | "mcwfurnitures:dark_oak_modern_chair" | "createcompression:block/minecraft/basalt/decompress/8x" | "createcompression:block/minecraft/raw_copper/compress/6x" | "mcwfurnitures:stripped_jungle_coffee_table" | "railways:crafting/palettes/dyeing_8x/blue_copper_wrapped_locometal" | "exdeorum:sieve/crushed_deepslate/golden/platinum_ore_chunk" | "immersiveengineering:crusher/ore_emerald" | "create:cutting/compat/quark/blossom_log" | "exdeorum:sieve/crushed_blackstone/netherite/ancient_debris" | "immersiveengineering:arcfurnace/dust_constantan" | "createcompression:block/minecraft/raw_copper/compress/9x" | "minecraft:quartz_pillar_from_quartz_block_stonecutting" | "extradisks:part/65536k_fluid_storage_part" | "createcompression:block/minecraft/lapis/compress/8x" | "railways:sequenced_assembly/track_tfc_rosewood_wide" | "exdeorum:sieve/sand/golden/prismarine_crystals" | "exdeorum:sieve/gravel/flint/diamond" | "mcwfurnitures:stripped_dark_oak_double_kitchen_cabinet" | "createcompression:block/minecraft/basalt/decompress/9x" | "farmersdelight:cutting/dandelion" | "minecraft:mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting" | "minecraft:observer" | "exdeorum:sieve/crushed_blackstone/netherite/gunpowder" | "create_confectionery:ruby_chocolate_brick_slab_recipe" | "minecraft:cooked_cod_from_campfire_cooking" | "create:cutting/compat/byg/stripped_baobab_log" | "mob_grinding_utils:beheading/spider" | "create:cutting/compat/blue_skies/bluebright_wood" | "createcompression:block/minecraft/oak_plank/compress/9x" | "minecraft:dye_purple_bed" | "createcompression:block/minecraft/lapis/compress/7x" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/raspberry" | "railways:crafting/palettes/dyeing_8x/pink_brass_wrapped_locometal" | "create:cutting/compat/endergetic/poise_stem" | "exdeorum:compressed_sieve/crushed_netherrack/flint/magma_cream" | "create:milling/bone_meal" | "create:mixing/andesite_alloy" | "mcwfurnitures:stripped_oak_modern_desk" | "minecraft:pink_dye_from_peony" | "createcompression:block/minecraft/raw_copper/compress/8x" | "create:cutting/compat/byg/holly_wood" | "storagenetwork:speed_upgrade" | "create:cutting/compat/regions_unexplored/blue_bioshroom_hyphae" | "sophisticatedbackpacks:chipped/botanist_workbench_upgrade" | "create:compacting/chocolate" | "immersiveengineering:crafting/raw_hammercrushing_copper" | "railways:stonecutting/palettes/cycling/black_riveted_locometal" | "createsweetsandtreets:cut_rock_candy_recipe_1_blue" | "engineeredcompatibility:arcfurnace/midnight/raw_ore_tenebrum" | "railways:sequenced_assembly/track_mangrove_narrow" | "create:cutting/compat/regions_unexplored/stripped_kapok_wood" | "exdeorum:compressed_sieve/crushed_deepslate/string/osmium_ore_chunk" | "minecraft:chiseled_deepslate" | "railways:sequenced_assembly/track_byg_white_mangrove_narrow" | "exdeorum:archwood_sieve" | "minecraft:soul_torch" | "create_confectionery:honey_candy_recipe" | "create:crushing/gilded_blackstone" | "mcwfurnitures:acacia_drawer" | "create:milling/compat/byg/iris" | "railways:sequenced_assembly/cyan_conductor_cap" | "farmersdelight:rope_from_safety_net" | "storagenetwork:import_kabel" | "exdeorum:sieve/crushed_deepslate/string/diamond" | "exdeorum:compressed_sieve/dirt/flint/pumpkin_seeds" | "exdeorum:compressed_sieve/crushed_deepslate/iron/iridium_ore_chunk" | "create:crushing/compat/elementaryores/ore_ghast_nether" | "minecraft:andesite_from_compressed_andesite" | "createaddition:compat/jeed/shocking" | "create:cut_tuff_wall" | "immersiveengineering:crafting/drill" | "create:crafting/kinetics/super_glue" | "exdeorum:compressed_sieve/moss_block/netherite/cherry_sapling" | "exdeorum:sieve/crushed_netherrack/golden/gunpowder" | "minecraft:weathered_cut_copper_from_weathered_copper_stonecutting" | "engineeredcompatibility:sawmill/ars_nouveau/green_archwood_log" | "mcwfurnitures:stripped_oak_desk" | "createcompression:block/minecraft/jungle_log/decompress/9x" | "minecraft:gray_dye" | "railways:sequenced_assembly/track_dark_oak_wide" | "immersiveengineering:sawmill/jungle_wood" | "exdeorum:sieve/crushed_netherrack/string/warped_nylium_spores" | "minecraft:slime_ball" | "create:crafting/kinetics/black_seat_from_other_seat" | "mob_grinding_utils:recipe_tank" | "railways:sequenced_assembly/track_tfc_mangrove_wide" | "refinedstorage:coloring_recipes/lime_network_receiver" | "railways:crafting/palettes/dyeing_1x/light_gray_slashed_locometal" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/scallion" | "createcompression:block/minecraft/jungle_log/decompress/8x" | "exdeorum:sieve/gravel/flint/silver_ore_chunk" | "refinedstorage:silk_touch_upgrade" | "create:splashing/atmospheric/arid_sand" | "create:cutting/compat/atmospheric/morado_wood" | "engineeredcompatibility:sawmill/undergarden/wigglewood_log" | "farmersdelight:cutting/dark_oak_wood" | "create:smelting/red_sand/3x_to_3x_glass" | "exdeorum:sieve/crushed_end_stone/iron/chorus_fruit" | "exdeorum:sieve/moss_block/string/maple_sapling" | "immersiveengineering:sawmill/birch_log" | "mcwfurnitures:stripped_dark_oak_glass_kitchen_cabinet" | "exdeorum:sieve/crushed_deepslate/diamond/gold_ore_chunk" | "railways:crafting/palettes/dyeing_1x/black_copper_wrapped_locometal" | "mowlib:filters/vanilla/individual_mobs/filter_type_fox" | "exdeorum:compressed_sieve/crushed_netherrack/string/blackstone_pebble" | "copycats:crafting/copycat_cogwheel" | "mekanism:enriching/createcompression/sand/7x_to_7x_gravel" | "mcwfurnitures:stripped_dark_oak_striped_chair" | "mobdropsrecipes_overworld:prismarine_shard_into_essence" | "createcompression:block/minecraft/jungle_log/decompress/7x" | "create:calcite_from_stone_types_calcite_stonecutting" | "create:cutting/compat/regions_unexplored/larch_wood" | "create:cut_limestone_brick_slab_recycling" | "farmersdelight:cooking/cooked_rice" | "minecraft:end_stone_brick_slab_from_end_stone_brick_stonecutting" | "minecraft:iron_sword" | "mobdropsrecipes_end:dragon_breath" | "mcwfurnitures:jungle_table" | "refinedstorage:coloring_recipes/purple_network_receiver" | "create:milling/saddle" | "railways:crafting/palettes/dyeing_8x/red_flat_slashed_locometal" | "exdeorum:compressed_sieve/crushed_deepslate/iron/nickel_ore_chunk" | "createcompression:block/minecraft/jungle_log/decompress/6x" | "create:splashing/thermal/crushed_raw_tin" | "immersiveengineering:crusher/prismarine_brick" | "create:splashing/oreganized/crushed_raw_lead" | "railways:stonecutting/palettes/cycling/slashed_locometal" | "createcompression:block/minecraft/gravel/compress/9x" | "create:small_ochrum_brick_slab_from_stone_types_ochrum_stonecutting" | "minecraft:chiseled_sandstone_from_sandstone_stonecutting" | "engineeredcompatibility:arcfurnace/aether_redux/ore_veridium" | "mowlib:filters/insertable_filters/filtermod" | "comforts:hammock_red" | "exdeorum:compressed_sieve/crushed_netherrack/golden/basalt_pebble" | "create:cutting/compat/silentgear/netherwood_wood" | "create:milling/compat/environmental/magenta_hibiscus" | "farmersdelight:cutting/leather_helmet" | "pedestals:machines/upgrademodification/filler/filler_area_tier_one" | "immersiveengineering:sawmill/jungle_stairs" | "minecraft:cut_copper_stairs_from_cut_copper_stonecutting" | "createcompression:block/minecraft/gravel/compress/7x" | "createcompression:block/minecraft/jungle_log/decompress/5x" | "railways:mechanical_crafting/black_copper_wrapped_locometal_boiler" | "minecraft:bamboo_pressure_plate" | "createcompression:block/minecraft/gravel/compress/8x" | "immersiveengineering:blueprint/circuit_board" | "mowlib:filters/vanilla/individual_mobs/filter_type_slime" | "exdeorum:hammer/crushed_blackstone" | "railways:sequenced_assembly/track_monorail" | "exdeorum:water_crucible/beetroot" | "create:crafting/appliances/netherite_backtank" | "create:crafting/kinetics/metal_girder" | "refinedstorage:64k_fluid_storage_part" | "create:crafting/kinetics/millstone" | "createcompression:block/minecraft/gravel/compress/6x" | "createcompression:block/minecraft/jungle_log/decompress/4x" | "immersiveengineering:mineral/ancient_seabed" | "railways:crafting/palettes/wrapping/purple_copper_wrapped_locometal" | "minecraft:sticky_piston" | "create_confectionery:black_chocolate_glazed_marshmallow_recipe" | "exdeorum:golden_watering_can" | "immersiveengineering:metalpress/plate_electrum" | "minecraft:exposed_cut_copper_slab_from_exposed_copper_stonecutting" | "create:milling/compat/botania/magenta_petal" | "immersiveengineering:crafting/toolupgrade_shield_shock" | "exdeorum:compressed_sieve/crushed_deepslate/golden/magnesium_ore_chunk" | "exdeorum:compressed_sieve/gravel/flint/iridium_ore_chunk" | "refinedstorage:1k_storage_part" | "exdeorum:sieve/dirt/flint/grass_seeds" | "engineersdecor:independent/clinker_brick_stained_stairs_recipe" | "immersiveengineering:stonecutting/stairs_hempcrete_brick" | "sophisticatedbackpacks:stack_upgrade_starter_tier" | "mcwfurnitures:stripped_crimson_lower_bookshelf_drawer" | "create_recipes:copppernuggetcrushing" | "railways:stonecutting/palettes/cycling/green_riveted_locometal" | "pedestals:machines/upgrademodification/harvester/harvester_area_tier_one" | "create:exposed_copper_tile_slab_from_exposed_copper_tiles_stonecutting" | "railways:crafting/palettes/dyeing_8x/gray_plated_locometal" | "railways:crafting/palettes/dyeing_8x/cyan_plated_locometal" | "createcompression:block/cc/limestone/decompress/2x" | "immersiveengineering:sawmill/crimson_wood" | "exdeorum:compressed_sieve/soul_sand/diamond/nether_wart" | "create:cut_dripstone_wall" | "exdeorum:sieve/moss_block/string/orange_autumn_sapling" | "exdeorum:sieve/soul_sand/golden/bone" | "forgepeacefulmobdrops:leather_from_rotten_flesh" | "createcompression:block/cc/limestone/decompress/1x" | "imersiveengineering:crusher/createcompression/glass/6x_to_6x_sand" | "mcwfurnitures:cherry_covered_desk" | "create:cutting/compat/byg/mahogany_log" | "exdeorum:compressed_sieve/dirt/iron/melon_seeds" | "minecraft:cut_red_sandstone" | "exdeorum:compressed_sieve/crushed_deepslate/string/platinum_ore_chunk" | "railways:crafting/palettes/dyeing_8x/black_flat_slashed_locometal" | "exdeorum:barrel_compost/moss_carpet" | "immersiveengineering:metalpress/plate_uranium" | "immersiveengineering:blueprint/bullet_casull" | "engineeredcompatibility:crusher/forbidden_arcanus/soulless_sandstone" | "createcompression:block/cc/limestone/decompress/4x" | "farmersdelight:canvas_sign" | "exdeorum:sieve/dirt/flint/sweet_berries" | "create:crafting/copper/waxed_exposed_copper_shingles_from_honeycomb" | "create:milling/compat/botania/brown_petal" | "create:cut_limestone_brick_stairs" | "mcwfurnitures:crimson_cupboard_counter" | "engineeredcompatibility:arcfurnace/undergarden/raw_block_cloggrum" | "create:cutting/compat/regions_unexplored/dead_log" | "minecraft:deepslate_brick_stairs_from_polished_deepslate_stonecutting" | "exdeorum:sieve/dust/flint/redstone" | "create:filling/apple_pie" | "engineeredcompatibility:sawmill/midnight/dark_willow_slab" | "create:item_application/copper_casing_from_log" | "railways:crafting/palettes/dyeing_1x/light_gray_plated_locometal" | "exdeorum:compressed_sieve/crushed_deepslate/string/magnesium_ore_chunk" | "create:crushing/raw_quicksilver" | "immersiveengineering:smelting/nugget_steel_recycle_axe" | "immersiveengineering:metalpress/plate_lead" | "createcompression:block/cc/limestone/decompress/3x" | "exdeorum:barrel_compost/rabbit_stew" | "farmersdelight:integration/create/milling/wild_onions" | "exmachinis:compacting/blackstone" | "farmersdelight:oak_cabinet" | "farmersdelight:integration/immersiveengineering/crusher/wild_rice" | "minecraft:cobblestone_wall_from_cobblestone_stonecutting" | "railways:sequenced_assembly/track_quark_azalea" | "exdeorum:compressed_sieve/moss_block/diamond/small_dripleaf" | "createcompression:block/cc/limestone/decompress/6x" | "create:crafting/copper/waxed_copper_tile_slab_from_honeycomb" | "immersiveengineering:smelting/ingot_lead_from_dust_from_blasting" | "engineersdecor:independent/thin_steel_pole_recipe" | "mcwfurnitures:cherry_triple_drawer" | "comforts:hammock_to_magenta" | "minecraft:yellow_dye_from_sunflower" | "create:milling/compat/byg/purple_amaranth" | "immersiveengineering:crafting/copper_ingot_to_nugget_copper" | "rebornstorage:disks/larger_fluid_storage_disk_from_storage_housing" | "create:small_crimsite_bricks_from_stone_types_crimsite_stonecutting" | "exdeorum:sieve/crushed_deepslate/netherite/gold_ore_chunk" | "exdeorum:sieve/crushed_deepslate/netherite/uranium_ore_chunk" | "create:cutting/compat/regions_unexplored/socotra_wood" | "minecraft:oak_slab" | "railways:sequenced_assembly/track_byg_redwood" | "create:milling/compat/atmospheric/scalding_monkey_brush" | "createcompression:block/cc/limestone/decompress/5x" | "railways:stonecutting/palettes/cycling/purple_riveted_locometal" | "create:tiled_glass_from_glass_colorless_stonecutting" | "immersiveengineering:crusher/ingot_tungsten" | "create:milling/sea_pickle" | "create:smelting/silver_ingot_compat_thermal" | "immersiveengineering:crafting/concrete" | "railways:crafting/palettes/dyeing_1x/gray_flat_slashed_locometal" | "createcompression:block/minecraft/cobblestone/compress/6x" | "immersiveengineering:crafting/fluorescent_tube" | "railways:crafting/palettes/dyeing_1x/yellow_copper_wrapped_locometal" | "immersiveengineering:blueprint/bullet_buckshot" | "exdeorum:barrel_compost/mushrooms" | "railways:mechanical_crafting/orange_copper_wrapped_locometal_boiler" | "railways:mechanical_crafting/blue_copper_wrapped_locometal_boiler" | "exdeorum:sieve/moss_block/iron/umbran_sapling" | "farmersdelight:netherite_knife_smithing" | "createcompression:block/minecraft/cobblestone/compress/7x" | "create:crushing/sandstone/3x_to_3x_sand" | "mcwfurnitures:stripped_birch_lower_bookshelf_drawer" | "farmersdelight:rice_panicle" | "create:crafting/kinetics/mechanical_plough" | "mcwfurnitures:stripped_dark_oak_coffee_table" | "create:milling/compat/biomesoplenty/violet" | "railways:crafting/palettes/dyeing_8x/yellow_riveted_locometal" | "create:framed_glass_pane" | "exdeorum:sieve/crushed_deepslate/iron/nickel_ore_chunk" | "railways:sequenced_assembly/track_biomesoplenty_jacaranda_narrow" | "farmersdelight:tatami" | "create:crushing/compat/silentgems/ruby_ore" | "minecraft:oxidized_cut_copper_stairs_from_oxidized_cut_copper_stonecutting" | "mcwfurnitures:stripped_birch_coffee_table" | "pedestals:augments/t3_capacity" | "refinedstorage:coloring_recipes/brown_controller" | "createcompression:block/minecraft/cobblestone/compress/8x" | "exmachinis:compacting/basalt" | "laserio:card_item" | "create:milling/sandstone/5x_to_5x_sand" | "exdeorum:sieve/crushed_end_stone/diamond/ender_eye" | "mowlib:filters/vanilla/individual_mobs/baby/filter_type_wolf_baby" | "railways:stonecutting/palettes/cycling/blue_locometal_smokebox" | "pedestals:machines/upgrademodification/pump/pump_block_capacity_tier_one" | "mob_grinding_utils:recipe_dragon_muffler" | "immersiveengineering:crafting/toolupgrade_revolver_magazine" | "exdeorum:compressed_sieve/moss_block/flint/dark_oak_sapling" | "railways:sequenced_assembly/track_byg_white_mangrove" | "vegandelight:campfire_cooking/cooked_smoked_tofu_slices_from_campfire_cooking" | "farmersdelight:cutting/crimson_door" | "immersiveengineering:alloysmelter/bronze" | "create:crafting/logistics/andesite_tunnel" | "refinedstorage:1k_storage_disk_from_storage_housing" | "immersiveengineering:crafting/stick_steel" | "craftable_spawner_p:villager_spawn_egg" | "createcompression:block/minecraft/amethyst/compress/1x" | "createcompression:block/minecraft/cobblestone/compress/9x" | "create:splashing/crushed_raw_iron" | "mcwfurnitures:stripped_jungle_double_kitchen_cabinet" | "exdeorum:oak_compressed_sieve" | "exdeorum:compressed_sieve/dirt/diamond/grass_seeds" | "craftable_spawner_p:fox_spawn_egg" | "mob_grinding_utils:recipe_ender_inhibitor" | "exdeorum:barrel_compost/weeping_vines" | "createcompression:block/minecraft/cobblestone/compress/2x" | "create:milling/compat/upgrade_aquatic/flowering_rush" | "refinedstorage:fortune_2_upgrade" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/quinoa_rich_soil" | "minecraft:dye_black_carpet" | "engineersdecor:independent/sign_caution_recipe" | "immersiveengineering:sawmill/oak_door" | "compacter:compacter" | "minecraft:polished_blackstone_brick_wall_from_blackstone_stonecutting" | "farmersdelight:cutting/red_mushroom_colony" | "createcompression:block/minecraft/cobblestone/compress/3x" | "nocubes_craftable_md:music_disc_five" | "exdeorum:compressed_sieve/moss_block/netherite/jungle_sapling" | "create:cut_asurine_slab_recycling" | "minecraft:magma_block" | "railways:crafting/palettes/wrapping/black_iron_wrapped_locometal" | "create:cut_limestone_wall_from_stone_types_limestone_stonecutting" | "laserio:card_redstone" | "easy_mob_farm:upgrade/slot/big_slot_upgrade" | "createcompression:block/minecraft/cobblestone/compress/4x" | "exdeorum:barrel_compost/salmon" | "minecraft:deepslate_tile_slab_from_deepslate_tiles_stonecutting" | "railways:sequenced_assembly/track_biomesoplenty_fir" | "create:milling/terracotta/8x_to_8x_red_sand" | "exdeorum:compressed_sieve/moss_block/diamond/acacia_sapling" | "pedestals:machines/cobblegen/generate_blackstone" | "exdeorum:sieve/gravel/iron/gold_ore_chunk" | "pedestals:machines/cobblegen/generate_redmushroom" | "createcompression:block/minecraft/cobblestone/compress/5x" | "exdeorum:sieve/crushed_deepslate/string/magnesium_ore_chunk" | "railways:sequenced_assembly/track_natures_spirit_sugi" | "railways:stonecutting/palettes/cycling/light_gray_flat_slashed_locometal" | "pedestals:machines/upgrademodification/harvester/harvester_speed_tier_one" | "create:cutting/compat/byg/blue_enchanted_wood" | "create:compacting/rock_candys/blocks/orange_rock_candy_block" | "engineeredcompatibility:arcfurnace/blue_skies/ore_falsite" | "exdeorum:sieve/dust/iron/bone_meal" | "engineeredcompatibility:sawmill/blue_skies/maple_slab" | "create:deploying/waxed_exposed_cut_copper_from_adding_wax" | "exdeorum:sieve/dirt/flint/sourceberry_bush" | "railways:stonecutting/palettes/cycling/gray_flat_riveted_locometal" | "immersiveengineering:crafting/sheetmetal_colored_cyan" | "create:sequenced_assembly/track" | "immersiveengineering:stonecutting/concrete_chiseled2" | "exdeorum:sieve/dust/iron/yellorium_dust" | "createcompression:block/minecraft/gravel/compress/5x" | "railways:mechanical_crafting/brown_iron_wrapped_locometal_boiler" | "create:mixing/tea" | "exmachinis:netherite_upgrade" | "railways:sequenced_assembly/track_bamboo_wide" | "create:cut_deepslate_wall" | "create:milling/compat/buzzier_bees/white_clover" | "immersiveengineering:crafting/alu_scaffolding_standard_to_slab" | "exdeorum:frostbright_compressed_sieve" | "create:milling/andesite/9x_to_9x_cobblestone" | "create:cutting/compat/twilightforest/stripped_dark_wood" | "mob_grinding_utils:gm_chicken_feed" | "exdeorum:compressed_sieve/dust/string/yellorium_dust" | "createcompression:block/minecraft/gravel/compress/4x" | "exdeorum:granite" | "mowlib:filters/insertable_filters/clear_filterfood" | "mobdropsrecipes_overworld:essence_into_phantom_membrane" | "mowlib:filters/vanilla/individual_mobs/filter_type_pufferfish" | "immersiveengineering:fermenter/honey" | "minecraft:blaze_powder" | "craftable_spawner_p:squid_spawn_egg" | "minecraft:chain" | "create:cutting/compat/byg/imparius_hyphae" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/brusselsprout" | "railways:stonecutting/palettes/cycling/light_gray_slashed_locometal" | "createcompression:block/minecraft/gravel/compress/3x" | "exdeorum:sieve/crushed_blackstone/string/gold_nugget" | "railways:sequenced_assembly/track_tfc_mangrove" | "minecraft:oak_fence" | "create:polished_cut_calcite_wall_from_stone_types_calcite_stonecutting" | "create:blasting/lead_ingot_compat_thermal" | "peacefulrecipes:slime_block" | "create_recipes:inksacfromwashing" | "rebornstorage:multiblock_storage" | "waystones:brown_sharestone" | "mcwfurnitures:crimson_end_table" | "copycats:crafting/copycat_trapdoor_from_conversion" | "exdeorum:sieve/crushed_end_stone/flint/chorus_fruit" | "createcompression:block/minecraft/gravel/compress/2x" | "immersiveengineering:crafting/fertilizer" | "immersiveengineering:crafting/generator" | "createcompression:block/minecraft/cobblestone/compress/1x" | "liquidburner:diesel" | "create:cutting/compat/endergetic/stripped_poise_stem" | "mcwfurnitures:crimson_drawer_counter" | "create:cutting/compat/regions_unexplored/stripped_cobalt_wood" | "mcwfurnitures:dark_oak_triple_drawer" | "create:cutting/compat/regions_unexplored/brimwood_wood" | "exdeorum:starlit_crucible" | "exmachinis:compacting/stone" | "minecraft:deepslate" | "immersiveengineering:smelting/ingot_silver_from_blasting3" | "immersiveengineering:smelting/ingot_silver_from_blasting2" | "exdeorum:compressed_sieve/dirt/golden/golden_carrot" | "createcompression:block/minecraft/gravel/compress/1x" | "pedestals:machines/upgrademodification/furnace/smelter_speed_tier_two" | "exdeorum:sieve/dirt/netherite/grass_seeds" | "create:milling/compat/environmental/blue_delphinium" | "immersiveengineering:crafting/tesla_coil" | "immersiveengineering:crafting/wooden_barrel" | "exdeorum:cherry_compressed_sieve" | "exdeorum:compressed_sieve/moss_block/diamond/green_archwood_sapling" | "railways:crafting/palettes/dyeing_1x/brown_iron_wrapped_locometal" | "exdeorum:sieve/dust/golden/bone_meal" | "engineeredcompatibility:crusher/deep_aether/ore_skyjade" | "farmersdelight:skillet" | "exdeorum:compressed_sieve/moss_block/string/orange_autumn_sapling" | "minecraft:prismarine_slab_from_prismarine_stonecutting" | "forgepeacefulmobdrops:prismarine_shard" | "immersiveengineering:crafting/armor_faraday_helmet" | "peco:discs/music_disc_cat" | "minecraft:deepslate_tile_wall_from_deepslate_bricks_stonecutting" | "minecraft:green_terracotta" | "minecraft:white_stained_glass" | "immersiveengineering:metalpress/gear_ardite" | "railways:crafting/palettes/dyeing_1x/yellow_locometal_smokebox" | "createaddition:rolling/steel_plate" | "exdeorum:compressed_sieve/gravel/string/stone_pebble" | "refinedstorage:pattern_grid/white_pattern_grid" | "engineeredcompatibility:sawmill/homespun/olive_bookshelf" | "refinedstorage:coloring_recipes/crafting_monitor" | "create:cut_diorite_brick_stairs_from_stone_types_diorite_stonecutting" | "peco:zombie_head" | "minecraft:purpur_stairs" | "peacefulrecipes:trident" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/lettuce" | "immersiveengineering:crafting/conveyor_extract_covered" | "extradisks:disk/shapeless/256k_storage_disk" | "rebornstorage:disks/medium_fluid_disk" | "mcwfurnitures:stripped_crimson_modern_desk" | "create:cut_limestone_stairs_from_stone_types_limestone_stonecutting" | "exdeorum:sieve/sand/netherite/flint" | "exdeorum:compressed_sieve/moss_block/netherite/yellow_autumn_sapling" | "engineeredcompatibility:crusher/blue_skies/turquoise_stone" | "createcompression:block/minecraft/end_stone/compress/8x" | "immersiveengineering:crafting/clinker_brick_quoin" | "create:cutting/compat/atmospheric/stripped_aspen_log" | "minecraft:ward_armor_trim_smithing_template" | "exdeorum:sieve/dirt/flint/bamboo" | "immersiveengineering:smelting/nugget_aluminum_recycle_faraday_helmet_from_blasting" | "create:smelting/soul_sand/6x_to_6x_scoria" | "sophisticatedbackpacks:auto_blasting_upgrade" | "createcompression:block/minecraft/bone_block/compress/8x" | "immersiveengineering:arcfurnace/dust_iron" | "createcompression:block/cc/andesite_alloy/compress/5x" | "exdeorum:porcelain_crucible" | "create:crushing/compat/exnihilosequentia/netherrack" | "mcwfurnitures:stripped_birch_double_wardrobe" | "exdeorum:acacia_sieve" | "exdeorum:sieve/crushed_blackstone/golden/gunpowder" | "createcompression:block/minecraft/crimson_stem/compress/9x" | "copycats:stonecutting/copycat_block" | "minecraft:quartz_from_blasting" | "forgepeacefulmobdrops:pearlescent_froglight" | "createcompression:block/minecraft/end_stone/compress/7x" | "exdeorum:compressed_sieve/crushed_deepslate/netherite/nickel_ore_chunk" | "vegandelight:crafting_shapeless/honey_glazed_tofu_block" | "exdeorum:barrel_compost/rabbit_foot" | "exdeorum:iron_ore" | "createcompression:block/minecraft/bone_block/compress/9x" | "exdeorum:sieve/gravel/iron/iridium_ore_chunk" | "createcompression:block/cc/andesite_alloy/compress/6x" | "mcwfurnitures:mangrove_kitchen_cabinet" | "immersiveengineering:crafting/plate_aluminum_hammering" | "immersiveengineering:mixer/concrete" | "createaddition:filling/honey_cake" | "create:crushing/cobblestone/7x_to_7x_gravel" | "exdeorum:redwood_sieve" | "exdeorum:sieve/crushed_netherrack/netherite/gunpowder" | "rebornstorage:disks/larger_item_storage_disk_from_storage_housing" | "createcompression:block/minecraft/end_stone/compress/6x" | "minecraft:gold_nugget" | "railways:crafting/palettes/dyeing_8x/brown_slashed_locometal" | "create:cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "mobdropsrecipes_overworld:overworld_essence_epic" | "create:small_dripstone_brick_slab" | "immersiveengineering:crafting/alu_scaffolding_grate_top_to_slab" | "pedestals:augments/dualhanded_t1_storage" | "createcompression:block/cc/andesite_alloy/compress/3x" | "exdeorum:compressed_sieve/dirt/flint/mycelium_spores" | "immersiveengineering:crafting/stairs_concrete_leaded" | "create:crafting/kinetics/stressometerfrom_conversion" | "createaddition:compat/immersiveengineering/constantan" | "railways:crafting/palettes/dyeing_8x/lime_slashed_locometal" | "pedestals:machines/upgrademodification/dropper/dropper_xp_capacity_tier_one" | "railways:sequenced_assembly/track_natures_spirit_sugi_wide" | "exdeorum:sieve/sand/flint/charged_certus_quartz_crystal" | "minecraft:waxed_oxidized_cut_copper" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/leek_rich_soil" | "exdeorum:compressed_sieve/moss_block/string/rainbow_birch_sapling" | "createcompression:block/minecraft/end_stone/compress/5x" | "mcwfurnitures:stripped_spruce_desk" | "create:small_calcite_brick_wall_from_stone_types_calcite_stonecutting" | "immersiveengineering:metalpress/plate_nickel" | "exdeorum:sieve/soul_sand/flint/bone" | "create:milling/compat/regions_unexplored/yellow_lupine" | "createcompression:block/cc/andesite_alloy/compress/4x" | "ironchest:chests/trapped_copper_chest" | "refinedstorage:coloring_recipes/blue_disk_manipulator" | "mowlib:taggetter" | "create:cut_scoria_bricks_from_stone_types_scoria_stonecutting" | "createcompression:block/minecraft/crimson_stem/compress/6x" | "exdeorum:compressed_sieve/crushed_deepslate/string/boron_ore_chunk" | "exdeorum:mahogany_crucible" | "minecraft:light_blue_stained_glass_pane_from_glass_pane" | "minecraft:magenta_dye_from_lilac" | "createcompression:block/minecraft/end_stone/compress/4x" | "railways:crafting/palettes/dyeing_1x/gray_copper_wrapped_locometal_boiler" | "railways:crafting/palettes/dyeing_8x/red_locometal_boiler" | "immersiveengineering:crusher/ore_lead" | "mob_grinding_utils:recipe_entity_spawner" | "farmersdelight:canvas_rug" | "exdeorum:ores/aluminum_tag" | "minecraft:blue_stained_glass_pane_from_glass_pane" | "immersiveengineering:metalpress/wire_uranium" | "refinedstorage:coloring_recipes/green_crafter" | "createcompression:block/cc/andesite_alloy/compress/9x" | "railways:crafting/palettes/dyeing_8x/green_slashed_locometal" | "minecraft:red_sandstone_wall_from_red_sandstone_stonecutting" | "createcompression:block/minecraft/crimson_stem/compress/5x" | "create_netherless:blaze_rod_recipe_sequenced" | "railways:sequenced_assembly/track_blue_skies_maple_wide" | "craftable_spawner:stray_spawn_egg" | "minecraft:fletching_table" | "createcompression:block/minecraft/end_stone/compress/3x" | "minecraft:dye_lime_bed" | "exdeorum:sieve/crushed_netherrack/string/quartz" | "railways:crafting/palettes/wrapping/purple_iron_wrapped_locometal" | "exdeorum:sieve/crushed_deepslate/iron/boron_ore_chunk" | "minecraft:spyglass" | "create:smelting/glass_from_horizontal_framed_glass" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/calabash" | "minecraft:pink_stained_glass" | "createcompression:block/minecraft/crimson_stem/compress/8x" | "railways:crafting/palettes/dyeing_8x/red_locometal_pillar" | "exdeorum:compressed_sieve/moss_block/golden/redwood_sapling" | "storagenetwork:single_upgrade" | "exdeorum:compressed_sieve/crushed_netherrack/golden/gold_nugget" | "minecraft:end_stone_brick_wall_from_end_stone_brick_stonecutting" | "createcompression:block/minecraft/end_stone/compress/2x" | "engineeredcompatibility:cloche/botania/pink_petal" | "exdeorum:sieve/crushed_netherrack/string/blackstone_pebble" | "exdeorum:compressed_sieve/red_sand/iron/dead_bush" | "create:cutting/jungle_wood" | "immersiveengineering:sawmill/acacia_door" | "pedestals:machines/upgrademodification/chopper/chopper_range_tier_one" | "exdeorum:sieve/crushed_deepslate/flint/iridium_ore_chunk" | "createcompression:block/cc/andesite_alloy/compress/7x" | "createcompression:block/minecraft/crimson_stem/compress/7x" | "createcompression:block/minecraft/end_stone/compress/1x" | "immersiveengineering:crafting/hammercrushing_silver" | "minecraft:raiser_armor_trim_smithing_template" | "farmersdelight:white_canvas_sign" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/ginger_rich_soil" | "immersiveengineering:crafting/raw_hammercrushing_ardite" | "create:cutting/compat/twilightforest/sorting_wood" | "create:crushing/amethyst_cluster" | "create:smelting/red_sand/9x_to_9x_glass" | "create:polished_cut_dripstone_from_stone_types_dripstone_stonecutting" | "createcompression:block/cc/andesite_alloy/compress/8x" | "create:milling/granite/2x_to_2x_red_sand" | "exdeorum:sieve/crushed_blackstone/iron/gold_nugget" | "minecraft:bread" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/guarana" | "createcompression:block/minecraft/crimson_stem/compress/2x" | "create:crafting/appliances/copper_diving_helmet" | "railways:sequenced_assembly/track_biomesoplenty_willow_wide" | "create:cutting/compat/atmospheric/morado_log" | "immersiveengineering:sawmill/treated_wood_packaged_slab" | "create:blasting/silver_ingot_compat_oreganized" | "createcompression:block/minecraft/amethyst/compress/6x" | "immersiveengineering:cloche/potato" | "exdeorum:compressed_sieve/dirt/golden/melon_seeds" | "mcwfurnitures:stripped_spruce_glass_kitchen_cabinet" | "immersiveengineering:fermenter/melon_slice" | "createcompression:block/minecraft/crimson_stem/compress/1x" | "pedestals:machines/cobblegen/generate_soulsand" | "minecraft:bamboo_slab" | "refinedstorage:raw_basic_processor" | "create:filling/compat/alexsmobs/lava_bottle" | "railways:sequenced_assembly/track_natures_spirit_joshua_wide" | "railways:stonecutting/palettes/cycling/white_flat_slashed_locometal" | "minecraft:black_banner" | "vegandelight:cooking/leather_substitute" | "create:cutting/compat/byg/stripped_zelkova_wood" | "engineeredcompatibility:sawmill/deep_aether/yagroot_slab" | "createcompression:block/minecraft/amethyst/compress/7x" | "create:milling/terracotta/2x_to_2x_red_sand" | "exdeorum:hammer/tube_coral" | "exdeorum:compressed_sieve/gravel/golden/gold_ore_chunk" | "mowlib:filters/vanilla/individual_mobs/filter_type_strider" | "immersiveengineering:thermoelectric/ice" | "createcompression:block/minecraft/crimson_stem/compress/4x" | "create:splashing/red_sand" | "farmersdelight:cutting/jungle_log" | "peacefulrecipes:music_disc_wait" | "create:emptying/builders_tea" | "createcompression:block/minecraft/amethyst/compress/8x" | "exdeorum:maple_crucible" | "create:calcite_pillar_from_stone_types_calcite_stonecutting" | "createcompression:block/minecraft/crimson_stem/compress/3x" | "engineeredcompatibility:sawmill/blue_skies/crystallized_bookshelf" | "create:crushing/deepslate_emerald_ore" | "minecraft:cooked_chicken" | "immersiveengineering:metalpress/gear_aluminum" | "exdeorum:sieve/crushed_deepslate/golden/diamond" | "create:cutting/compat/byg/ebony_log" | "createcompression:block/minecraft/amethyst/compress/9x" | "mcwfurnitures:stripped_jungle_bookshelf_cupboard" | "exdeorum:sieve/gravel/netherite/raw_gold" | "easy_mob_farm:mob_farm/monster_plains_cave/tier0_monster_plains_cave_farm" | "pedestals:machines/upgrademodification/void/void_speed_tier_one" | "railways:crafting/semaphore" | "mcwfurnitures:birch_table" | "createcompression:block/minecraft/amethyst/compress/2x" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/chia_rich_soil" | "railways:crafting/palettes/dyeing_1x/magenta_flat_slashed_locometal" | "createcompression:block/cc/andesite_alloy/compress/1x" | "minecraft:polished_diorite_stairs_from_diorite_stonecutting" | "create:cut_scoria_stairs_from_stone_types_scoria_stonecutting" | "farmersdelight:beetroot_from_crate" | "waystones:return_scroll" | "create:cutting/stripped_cherry_log" | "sophisticatedbackpacks:smelting_upgrade" | "create:crafting/kinetics/propeller" | "mcwfurnitures:stripped_acacia_large_drawer" | "create:cutting/compat/biomesoplenty/stripped_palm_wood" | "immersiveengineering:smelting/copper_ingot_from_dust_from_blasting" | "farmersdelight:cooked_salmon_slice_from_smoking" | "create_confectionery:black_chocolate_candy_3_recipe" | "exdeorum:compressed_sieve/moss_block/flint/sourceberry_bush" | "mcwfurnitures:dark_oak_bookshelf_drawer" | "createcompression:block/minecraft/amethyst/compress/3x" | "createcompression:block/cc/andesite_alloy/compress/2x" | "immersiveengineering:crafting/fluid_pipe" | "mowlib:filters/vanilla/individual_mobs/baby/filter_type_bee_baby" | "farmersdelight:straw" | "minecraft:dark_prismarine" | "easy_mob_farm:mob_catcher/ironbound_containment_cage" | "mcwfurnitures:stripped_crimson_double_kitchen_cabinet" | "railways:crafting/palettes/dyeing_8x/green_copper_wrapped_locometal_boiler" | "exdeorum:sieve/moss_block/flint/dead_sapling" | "createaddition:mechanical_crafting/alternator" | "exdeorum:sieve/dust/netherite/bone_meal" | "immersiveengineering:metalpress/rod_osmium" | "minecraft:waxed_oxidized_cut_copper_slab_from_waxed_oxidized_cut_copper_stonecutting" | "farmersdelight:integration/immersiveengineering/crusher/wild_tomatoes" | "createcompression:block/minecraft/amethyst/compress/4x" | "exdeorum:sieve/gravel/golden/iron_ore_chunk" | "create:cutting/compat/regions_unexplored/stripped_larch_log" | "create:cut_ochrum_slab_recycling" | "refinedstorage:coloring_recipes/blue_fluid_grid" | "engineeredcompatibility:cloche/botania/light_gray_petal_rich_soil" | "createcompression:block/minecraft/amethyst/compress/5x" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/mulberry_rich_soil" | "immersiveengineering:crafting/sheetmetal_colored_white" | "mcwfurnitures:crimson_large_drawer" | "create:milling/compat/byg/compat/byg/white_sage" | "exdeorum:compressed_sieve/dirt/netherite/mycelium_spores" | "railways:crafting/palettes/dyeing_1x/cyan_locometal_boiler" | "createcompression:block/minecraft/dirt/decompress/1x" | "create:compacting/rock_candys/red_rock_candy_craft" | "create:cutting/compat/nethers_exoticism/stripped_ramboutan_wood" | "exdeorum:compressed_sieve/moss_block/golden/maple_sapling" | "minecraft:jungle_slab" | "createcompression:block/minecraft/cobblestone/decompress/4x" | "farmersdelight:cutting/birch_wood" | "create:milling/compat/botania/lime_petal" | "railways:stonecutting/palettes/cycling/black_flat_slashed_locometal" | "rebornstorage:parts/large_item_disk_part" | "create:blasting/ingot_aluminum_compat_immersiveengineering" | "exdeorum:moss_block" | "create:milling/compat/regions_unexplored/felicia_daisy" | "createcompression:block/minecraft/dirt/decompress/2x" | "createaddition:charging/weathered_copper" | "refinedstorage:fluid_grid/blue_fluid_grid" | "exdeorum:compressed_sieve/crushed_deepslate/string/amethyst_shard" | "mcwfurnitures:cabinet_drawer" | "railways:sequenced_assembly/track_byg_pine" | "minecraft:granite" | "railways:crafting/palettes/dyeing_1x/light_gray_riveted_locometal" | "create:compacting/rock_candys/green_rock_candy_craft" | "createcompression:block/minecraft/cobblestone/decompress/3x" | "railways:mechanical_crafting/cyan_iron_wrapped_locometal_boiler" | "exdeorum:sieve/dirt/string/carrot" | "ntgbb:netherite_upgrade_smithing_template" | "minecraft:black_dye_from_wither_rose" | "exdeorum:compressed_crushed_end_stone" | "create:smelting/red_sand/6x_to_6x_glass" | "immersiveengineering:crafting/speedloader" | "railways:sequenced_assembly/track_byg_pine_narrow" | "peacefulrecipes:music_disc_ward" | "pedestals:machines/unbottler/unbottler_bottleofenchanting" | "cabletiers:elite_exporter" | "engineeredcompatibility:arcfurnace/aether_redux/raw_block_veridium" | "exdeorum:sieve/moss_block/iron/snowblossom_sapling" | "createcompression:block/minecraft/cobblestone/decompress/2x" | "exdeorum:compressed_sieve/moss_block/golden/flowering_oak_sapling" | "farmersdelight:cutting/kelp_roll" | "exdeorum:compressed_sieve/crushed_deepslate/diamond/amethyst_shard" | "railways:sequenced_assembly/track_byg_lament_narrow" | "railways:crafting/palettes/dyeing_8x/light_gray_copper_wrapped_locometal" | "railways:crafting/palettes/dyeing_8x/white_locometal_boiler" | "immersiveengineering:crafting/drillhead_steel" | "immersiveengineering:sawmill/treated_wood_horizontal_stairs" | "create:cutting/compat/byg/fungal_imparius_stem" | "exdeorum:barrel_mixing/soul_sand" | "createcompression:block/minecraft/cobblestone/decompress/1x" | "create:crafting/kinetics/brown_seat_from_other_seat" | "exdeorum:sieve/moss_block/golden/blue_archwood_sapling" | "exdeorum:barrel_fluid_mixing/netherrack" | "create:crushing/compat/simplefarming/rye" | "exdeorum:compressed_sieve/moss_block/netherite/glow_berries" | "exdeorum:compressed_sieve/moss_block/flint/orange_autumn_sapling" | "exdeorum:skyroot_barrel" | "create:crafting/kinetics/copper_door" | "create:crafting/copper/waxed_oxidized_copper_tiles_from_honeycomb" | "create:andesite_bars_from_andesite_alloy_stonecutting" | "exdeorum:sieve/gravel/iron/lapis_lazuli" | "railways:crafting/palettes/dyeing_1x/light_blue_brass_wrapped_locometal_boiler" | "mcwfurnitures:spruce_double_drawer_counter" | "exdeorum:sieve/crushed_blackstone/netherite/blackstone_pebble" | "railways:sequenced_assembly/track_mangrove_wide" | "exdeorum:sieve/crushed_deepslate/flint/uranium_ore_chunk" | "refinedstorage:coloring_recipes/light_gray_crafting_monitor" | "minecraft:cobbled_deepslate_wall" | "minecraft:purpur_slab_from_purpur_block_stonecutting" | "exdeorum:sieve/crushed_deepslate/golden/thorium_ore_chunk" | "railways:crafting/palettes/dyeing_8x/brown_copper_wrapped_locometal" | "mcwfurnitures:dark_oak_kitchen_cabinet" | "create:cutting/compat/regions_unexplored/stripped_cypress_wood" | "create:polished_cut_crimsite_wall" | "craftable_spawner:zombified_piglin_spawn_egg" | "exdeorum:compressed_sieve/crushed_deepslate/flint/magnesium_ore_chunk" | "exdeorum:iron_mesh" | "exdeorum:compressed_sieve/crushed_deepslate/diamond/iridium_ore_chunk" | "create:cutting/compat/byg/lament_wood" | "create:mangrove_window_pane" | "exdeorum:willow_compressed_sieve" | "exdeorum:sieve/moss_block/string/glow_berries" | "engineeredcompatibility:sawmill/aether_redux/crystal_door" | "railways:crafting/palettes/dyeing_1x/cyan_locometal_pillar" | "minecraft:purple_carpet" | "create:pressing/compat/infernalexp/warped_nylium_path" | "easy_mob_farm:upgrade/filter/no_flowers_filter" | "immersiveengineering:crafting/revolver" | "mcwfurnitures:dark_oak_end_table" | "minecraft:ender_eye" | "mcwfurnitures:stripped_spruce_coffee_table" | "exdeorum:compressed_sieve/sand/iron/flint" | "create:crushing/obsidian" | "mcwfurnitures:spruce_double_wardrobe" | "railways:sequenced_assembly/track_natures_spirit_aspen_narrow" | "create:cut_scoria_brick_wall_from_stone_types_scoria_stonecutting" | "create:smelting/red_sand/1x_to_1x_glass" | "mobdropsrecipes_overworld:essence_into_bone" | "create:filling/chocolate_donut" | "sophisticatedbackpacks:battery_upgrade" | "exdeorum:sieve/crushed_blackstone/iron/blackstone_pebble" | "create:cutting/compat/byg/stripped_holly_log" | "railways:crafting/palettes/dyeing_1x/white_plated_locometal" | "exdeorum:sieve/crushed_end_stone/golden/chorus_fruit" | "pedestals:upgrades/upgrade_fertilizer" | "extradisks:blocks/262144k_fluid_storage_block" | "exdeorum:compressed_hammer/crushed_netherrack" | "engineeredcompatibility:sawmill/midnight/shadowroot_bookshelf" | "exdeorum:compressed_sieve/crushed_deepslate/string/lead_ore_chunk" | "exdeorum:sieve/crushed_netherrack/netherite/quartz" | "engineeredcompatibility:crusher/blue_skies/lunar_stone" | "immersiveengineering:crafting/conveyor_dropper" | "create:smelting/ingot_uranium_compat_mekanism" | "create:cutting/compat/byg/witch_hazel_wood" | "createcompression:block/minecraft/jungle_log/decompress/3x" | "engineeredcompatibility:crusher/midnight/ore_ebonite" | "railways:sequenced_assembly/track_byg_imparius_wide" | "exdeorum:compressed_sieve/moss_block/flint/rainbow_birch_sapling" | "mcwfurnitures:birch_triple_drawer" | "create:cutting/compat/twilightforest/stripped_transformation_log" | "minecraft:exposed_cut_copper_stairs_from_exposed_cut_copper_stonecutting" | "sophisticatedbackpacks:smoking_upgrade" | "mowlib:filters/insertable_filters/clear_filterenchantedcount" | "exdeorum:sieve/gravel/flint/emerald" | "create:splashing/ic2/crushed_raw_tin" | "create:small_scoria_bricks_from_stone_types_scoria_stonecutting" | "refinedstorage:fluid_grid/lime_fluid_grid" | "mcwfurnitures:stripped_cherry_wardrobe" | "createcompression:block/minecraft/jungle_log/decompress/2x" | "createcompression:block/minecraft/jungle_log/decompress/1x" | "create:pressing/silt_dirt_path" | "extradisks:blocks/1048576k_storage_block" | "engineersdecor:independent/steel_framed_window_recipe" | "refinedstorage:fortune_1_upgrade" | "exmachinis:compacting/ato/iridium_ore" | "minecraft:gold_nugget_from_smelting" | "minecraft:chiseled_quartz_block_from_quartz_block_stonecutting" | "create:milling/compat/atmospheric/yucca_flower" | "waystones:light_gray_sharestone" | "exdeorum:compressed_sieve/gravel/string/thorium_ore_chunk" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/pineapple_rich_soil" | "createcompression:block/minecraft/dirt/decompress/8x" | "exdeorum:compressed_sieve/gravel/iron/aluminum_ore_chunk" | "exdeorum:compressed_sieve/red_sand/netherite/redstone" | "exdeorum:hellbark_barrel" | "craftable_bee_spawn_egg:bee_spawn_egg_recipe" | "railways:crafting/palettes/dyeing_8x/white_locometal_pillar" | "minecraft:cobbled_deepslate_from_compressed_cobbled_deepslate" | "exdeorum:compressed_sieve/gravel/golden/stone_pebble" | "engineeredcompatibility:cloche/farmersdelight/wheat_rich_soil" | "immersiveengineering:smelting/ingot_uranium3" | "createcompression:block/minecraft/cobblestone/decompress/9x" | "immersiveengineering:smelting/ingot_uranium2" | "create_confectionery:chocolate_bricks_slab_recipe_2" | "create_confectionery:chocolate_bricks_slab_recipe_1" | "pedestals:machines/upgrademodification/chopper/chopper_speed_tier_one" | "createcompression:block/minecraft/dirt/decompress/9x" | "railways:crafting/palettes/wrapping/gray_iron_wrapped_locometal" | "pedestals:machines/upgrademodification/planter/planter_superspeed" | "exdeorum:compressed_cobbled_deepslate" | "create:smelting/red_sand/7x_to_7x_glass" | "create:cut_veridium_from_stone_types_veridium_stonecutting" | "exdeorum:compressed_sieve/moss_block/netherite/oak_sapling" | "immersiveengineering:smelting/nugget_steel_recycle_shovel_from_blasting" | "immersiveengineering:blastfurnace/fuel_charcoal_block" | "createcompression:block/minecraft/cobblestone/decompress/8x" | "exdeorum:sieve/dust/string/redstone" | "createcompression:block/minecraft/dirt/decompress/5x" | "minecraft:weathered_cut_copper_slab_from_weathered_cut_copper_stonecutting" | "mcwfurnitures:stripped_birch_modern_desk" | "exdeorum:compressed_sieve/dust/netherite/gold_nugget" | "create:cutting/compat/twilightforest/time_log" | "engineersdecor:dependent/metal_bar_recipe" | "create:small_andesite_brick_slab_from_stone_types_andesite_stonecutting" | "immersiveengineering:arcfurnace/raw_block_platinum" | "rebornstorage:parts/small_item_disk_part" | "create:small_scorchia_brick_slab" | "rebornstorage:disks/larger_item_disk" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/okra_rich_soil" | "railways:sequenced_assembly/track_biomesoplenty_palm" | "create:crushing/emerald_ore" | "immersiveengineering:crafting/steel_scaffolding_wooden_top_from_grate_top" | "exdeorum:compressed_sieve/moss_block/iron/dark_oak_sapling" | "immersiveengineering:crafting/sheetmetal_colored_blue_from_slab" | "create:cutting/compat/environmental/stripped_willow_log" | "createcompression:block/minecraft/dirt/decompress/6x" | "farmersdelight:cooked_mutton_chops" | "createcompression:block/minecraft/dirt/decompress/7x" | "createcompression:block/minecraft/cobblestone/decompress/7x" | "create:smelting/red_sand/4x_to_4x_glass" | "minecraft:shulker_box_coloring" | "railways:stonecutting/palettes/cycling/magenta_locometal_pillar" | "create:cutting/compat/ecologics/stripped_coconut_log" | "railways:sequenced_assembly/track_tfc_ash_wide" | "exdeorum:compressed_sieve/sand/golden/dead_bush" | "engineeredcompatibility:sawmill/twilightforest/timewood_log" | "refinedstorage:256k_fluid_storage_block" | "railways:sequenced_assembly/track_spruce_wide" | "create:milling/compat/atmospheric/gilia" | "mobdropsrecipes_overworld:rotten_flesh" | "exdeorum:compressed_sieve/crushed_deepslate/flint/nickel_ore_chunk" | "minecraft:white_glazed_terracotta" | "create:cutting/compat/goodending/stripped_cypress_wood" | "createcompression:block/minecraft/dirt/decompress/3x" | "railways:crafting/palettes/dyeing_8x/white_flat_slashed_locometal" | "refinedstorage:pattern_grid/magenta_pattern_grid" | "createcompression:block/minecraft/cobblestone/decompress/6x" | "create:cut_asurine_from_stone_types_asurine_stonecutting" | "immersiveengineering:metalpress/gear_uranium" | "railways:sequenced_assembly/track_crimson" | "exdeorum:sieve/moss_block/string/small_dripleaf" | "exdeorum:barrel_mixing/ice" | "comforts:hammock_to_yellow" | "refinedstorage:coloring_recipes/pink_network_transmitter" | "railways:stonecutting/palettes/cycling/black_locometal_smokebox" | "createcompression:block/minecraft/end_stone/compress/9x" | "minecraft:acacia_wood" | "create_netherless:soul_torch_from_ectoplasm" | "engineeredcompatibility:sawmill/forbidden_arcanus/aurum_slab" | "createcompression:block/minecraft/dirt/decompress/4x" | "exdeorum:sieve/moss_block/string/purple_archwood_sapling" | "createcompression:block/minecraft/cobblestone/decompress/5x" | "create:smelting/cobbled_deepslate/5x_to_5x_deepslate" | "railways:crafting/palettes/dyeing_8x/purple_flat_slashed_locometal" | "create:acacia_window_pane" | "create:cut_granite_brick_slab_from_stone_types_granite_stonecutting" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/canola_rich_soil" | "create:cutting/compat/byg/stripped_rainbow_eucalyptus_log" | "engineeredcompatibility:sawmill/midnight/dark_willow_bookshelf" | "imersiveengineering:crusher/createcompression/cobblestone/3x_to_3x_gravel" | "create:cut_diorite_brick_wall" | "createcompression:block/cc/brass/compress/2x" | "create:sequenced_assembly/precision_mechanism" | "railways:crafting/palettes/dyeing_1x/light_gray_flat_riveted_locometal" | "comforts:sleeping_bag_to_lime" | "immersiveengineering:metalpress/plate_copper" | "mcwfurnitures:stripped_acacia_counter" | "railways:sequenced_assembly/track_natures_spirit_wisteria" | "createcompression:block/minecraft/soul_sand/compress/4x" | "mekanism:crushing/createcompression/cobblestone/4x_to_4x_gravel" | "exdeorum:sieve/sand/netherite/sea_pickle" | "farmersdelight:integration/immersiveengineering/cloche/tomato" | "createcompression:block/cc/brass/compress/3x" | "create:cut_scorchia_wall" | "create:polished_cut_deepslate_wall" | "exdeorum:compressed_sieve/soul_sand/netherite/quartz" | "createcompression:block/minecraft/soul_sand/compress/5x" | "exdeorum:compressed_sieve/moss_block/string/spruce_sapling" | "create:milling/calcite" | "mcwfurnitures:cherry_chair" | "exdeorum:compressed_sieve/crushed_deepslate/iron/tin_ore_chunk" | "create:crafting/kinetics/light_gray_seat" | "createcompression:block/cc/brass/compress/4x" | "exdeorum:sieve/dust/netherite/grains_of_infinity" | "exdeorum:spruce_compressed_sieve" | "refinedstorage:coloring_recipes/gray_grid" | "immersiveengineering:crusher/ingot_invar" | "minecraft:waxed_cut_copper_slab" | "createcompression:block/minecraft/soul_sand/compress/2x" | "create:haunting/lapis_recycling" | "engineersdecor:independent/steel_floor_grating_recipe" | "exdeorum:compressed_sieve/crushed_end_stone/flint/ender_pearl" | "mcwfurnitures:spruce_drawer" | "createcompression:block/cc/brass/compress/5x" | "railways:stonecutting/palettes/cycling/cyan_riveted_locometal" | "mcwfurnitures:stripped_warped_glass_kitchen_cabinet" | "railways:sequenced_assembly/track_twilightforest_darkwood" | "createcompression:block/minecraft/soul_sand/compress/3x" | "mowlib:filters/vanilla/individual_mobs/filter_type_dragon" | "immersiveengineering:crafting/hammercrushing_cobalt" | "createcompression:block/cc/brass/compress/6x" | "mowlib:filters/vanilla/individual_mobs/rideable/filter_type_donkey" | "mcwfurnitures:stripped_crimson_covered_desk" | "createcompression:block/minecraft/soul_sand/compress/9x" | "comforts:sleeping_bag_to_blue" | "craftable_spawner_p:chicken_spawn_egg" | "create:cutting/compat/ars_nouveau/stripped_red_archwood_log" | "minecraft:nether_brick_stairs" | "pedestals:machines/cobblegen/generate_calcite" | "create:cutting/compat/windswept/stripped_chestnut_wood" | "create:deploying/waxed_oxidized_copper_tile_slab_from_adding_wax" | "exdeorum:jungle_compressed_sieve" | "createcompression:block/minecraft/soul_sand/compress/8x" | "minecraft:recovery_compass" | "pedestals:tools/tool_crafting/dualhanded_linkingtool_quark" | "imersiveengineering:crusher/createcompression/glass/2x_to_2x_sand" | "exmachinis:compacting/ato/osmium_ore" | "mob_grinding_utils:recipe_tank_sink_reset" | "exdeorum:sieve/sand/diamond/certus_quartz_crystal" | "createcompression:block/cc/brass/compress/7x" | "immersiveengineering:crafting/sheetmetal_iron_from_slab" | "exdeorum:sieve/dust/iron/certus_quartz_dust" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/juniperberry_rich_soil" | "create:crafting/kinetics/black_valve_handle_from_other_valve_handle" | "pedestals:upgrades/upgrade_fluidconverter" | "copycats:crafting/copycat_slice_from_conversion" | "mobdropsrecipes_end:ender_pearl_into_essence" | "railways:crafting/palettes/dyeing_8x/white_copper_wrapped_locometal" | "engineersdecor:independent/dark_shingle_roof_recipe" | "mcwfurnitures:stripped_dark_oak_double_drawer_counter" | "create:pressing/compat/environmental/podzol_path" | "exdeorum:sieve/dirt/golden/gold_nugget" | "createcompression:block/cc/brass/compress/8x" | "exdeorum:sieve/gravel/diamond/magnesium_ore_chunk" | "vegandelight:filling/soymilk_bottle_from_filling" | "exdeorum:compressed_sieve/crushed_deepslate/flint/calcite_pebble" | "exdeorum:compressed_sieve/gravel/flint/copper_ore_chunk" | "createcompression:block/minecraft/soul_sand/compress/6x" | "railways:stonecutting/palettes/cycling/black_locometal_pillar" | "immersiveengineering:crusher/raw_ore_lead" | "refinedstorage:coloring_recipes/brown_security_manager" | "railways:crafting/small_buffer" | "exdeorum:sieve/moss_block/netherite/hellbark_sapling" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/soybean" | "exdeorum:compressed_sieve/crushed_deepslate/netherite/uranium_ore_chunk" | "createcompression:block/cc/brass/compress/9x" | "exdeorum:compressed_sieve/gravel/golden/thorium_ore_chunk" | "immersiveengineering:cloche/crimson_fungus" | "pedestals:tools/tool_swap/linking_swapping/toolswap_backwards_to_linking" | "exdeorum:sieve/gravel/flint/amethyst_shard" | "immersiveengineering:crusher/blue_dye" | "createcompression:block/minecraft/soul_sand/compress/7x" | "minecraft:white_dye" | "mowlib:filters/vanilla/individual_mobs/filter_type_ocelot" | "railways:sequenced_assembly/track_byg_aspen" | "refinedstorage:crafting_grid/yellow_crafting_grid" | "engineersdecor:independent/metal_sliding_door_recipe" | "create:crafting/kinetics/linear_chassisfrom_conversion" | "engineeredcompatibility:sawmill/midnight/decayed_log" | "exdeorum:sieve/sand/iron/gold_nugget" | "railways:crafting/palettes/dyeing_1x/orange_plated_locometal" | "createcompression:block/minecraft/gold/decompress/5x" | "exdeorum:compressed_sieve/sand/netherite/prismarine_shard" | "exdeorum:compressed_sieve/crushed_netherrack/flint/gold_nugget" | "minecraft:wild_armor_trim_smithing_template_smithing_trim" | "create:polished_cut_granite_slab" | "create:polished_cut_veridium_stairs" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/papyrus" | "create:cutting/compat/byg/skyris_log" | "engineersdecor:independent/panzerglass_block_recipe" | "create:cutting/compat/nethers_exoticism/stripped_jabuticaba_log" | "create:milling/compat/environmental/pink_delphinium" | "immersiveengineering:arcfurnace/raw_ore_silver" | "minecraft:tinted_glass" | "createcompression:block/minecraft/gold/decompress/6x" | "engineersdecor:independent/straight_pipe_valve_redstone_analog_recipe" | "exdeorum:sieve/moss_block/netherite/spruce_sapling" | "exdeorum:sieve/crushed_deepslate/flint/lead_ore_chunk" | "exdeorum:compressed_hammer/crushed_blackstone" | "mcwfurnitures:stripped_crimson_bookshelf" | "create:crafting/kinetics/yellow_seat_from_other_seat" | "railways:crafting/palettes/dyeing_1x/purple_locometal_pillar" | "create:cut_ochrum_from_stone_types_ochrum_stonecutting" | "minecraft:cut_copper_stairs_from_copper_block_stonecutting" | "refinedstorage:portable_grid" | "farmersdelight:potato_from_crate" | "createcompression:block/minecraft/gold/decompress/3x" | "create:granite_from_stone_types_granite_stonecutting" | "engineeredcompatibility:sawmill/midnight/bogshroom_stem" | "exdeorum:barrel_compost/tropical_fish" | "exdeorum:barrel_compost/wood_chippings" | "minecraft:dried_kelp_block" | "exdeorum:barrel_compost/chicken" | "minecraft:quartz" | "create:cutting/compat/byg/stripped_ether_wood" | "exdeorum:crucible_heat_source/torch" | "railways:stonecutting/palettes/cycling/red_plated_locometal" | "mcwfurnitures:stripped_warped_drawer_counter" | "create:cutting/compat/ars_nouveau/stripped_green_archwood_wood" | "create:deploying/waxed_weathered_copper_shingle_slab_from_adding_wax" | "immersiveengineering:smelting/ingot_steel_from_dust" | "railways:crafting/palettes/dyeing_1x/green_plated_locometal" | "exdeorum:sieve/crushed_blackstone/string/black_dye" | "createcompression:block/minecraft/gold/decompress/4x" | "extrastorage:iron_crafter" | "create:polished_cut_dripstone_slab_from_stone_types_dripstone_stonecutting" | "create:industrial_iron_block_from_ingots_iron_stonecutting" | "exdeorum:compressed_sieve/moss_block/iron/magic_sapling" | "exdeorum:compressed_sieve/moss_block/golden/willow_sapling" | "createsweetsandtreets:chiseled_orange" | "exdeorum:compressed_sieve/moss_block/flint/purple_archwood_sapling" | "exdeorum:compressed_hammer/dust" | "createcompression:block/minecraft/gold/decompress/9x" | "exdeorum:barrel_compost/apple" | "createcompression:block/minecraft/blackstone/decompress/1x" | "christmasmusicdiscs:have_a_holly_jolly_christmas_recipe" | "railways:crafting/palettes/dyeing_1x/brown_copper_wrapped_locometal" | "forgepeacefulmobdrops:rotten_flesh_from_mutton" | "exdeorum:sieve/gravel/diamond/lead_ore_chunk" | "immersiveengineering:squeezer/hemp_seeds" | "exdeorum:sieve/dirt/flint/mycelium_spores" | "minecraft:blue_carpet" | "create_netherless:soulsand_by_deploying" | "pipez:filter_destination_tool" | "railways:sequenced_assembly/blue_conductor_cap" | "extradisks:blocks/65536k_storage_block" | "create:cut_dripstone_brick_slab" | "engineeredcompatibility:sawmill/blue_skies/dusk_slab" | "railways:crafting/palettes/dyeing_8x/brown_brass_wrapped_locometal" | "pedestals:machines/cobblegen/generate_endstone" | "farmersdelight:barbecue_stick" | "immersiveengineering:crafting/shield" | "createcompression:block/minecraft/blackstone/decompress/2x" | "create:small_limestone_brick_stairs_from_stone_types_limestone_stonecutting" | "pedestals:augments/t3_range" | "exdeorum:compressed_sieve/crushed_deepslate/diamond/diamond" | "refinedstorage:fluid_grid/fluid_grid" | "engineersdecor:independent/sign_firehazard_recipe" | "railways:sequenced_assembly/track_byg_pine_wide" | "pedestals:machines/upgrademodification/pump/pump_range_tier_one" | "createcompression:block/minecraft/gold/decompress/7x" | "mcwfurnitures:stripped_spruce_double_drawer" | "pedestals:augments/dualhanded_t3_range" | "create:deploying/waxed_weathered_cut_copper_from_adding_wax" | "minecraft:cooked_chicken_from_smoking" | "exdeorum:compressed_sieve/crushed_blackstone/string/basalt_pebble" | "minecraft:cut_red_sandstone_from_red_sandstone_stonecutting" | "minecraft:waxed_weathered_cut_copper_slab_from_waxed_weathered_copper_stonecutting" | "create:cutting/compat/architects_palette/twisted_log" | "createcompression:block/minecraft/gold/decompress/8x" | "minecraft:mangrove_chest_boat" | "minecraft:dirt_from_compressed_dirt" | "minecraft:iron_hoe" | "immersiveengineering:smelting/ingot_silver3" | "mowlib:filters/vanilla/filter_category_underwatercreature_baby" | "immersiveengineering:smelting/ingot_silver2" | "create:crushing/golden_horse_armor" | "exdeorum:sieve/crushed_netherrack/golden/crimson_nylium_spores" | "exdeorum:compressed_sieve/moss_block/netherite/big_dripleaf" | "immersiveengineering:crafting/raw_block_aluminum_to_raw_aluminum" | "exdeorum:compressed_sieve/sand/golden/kelp" | "minecraft:jungle_trapdoor" | "peacefulrecipes:blaze_rod" | "exdeorum:umbran_crucible" | "refinedstorage:coloring_recipes/blue_network_transmitter" | "exdeorum:crucible_heat_source/soul_wall_torch" | "mcwfurnitures:dark_oak_coffee_table" | "railways:crafting/palettes/dyeing_1x/brown_locometal_boiler" | "sophisticatedbackpacks:filter_upgrade" | "railways:crafting/palettes/dyeing_8x/green_copper_wrapped_locometal" | "rebornstorage:disks/small_item_disk" | "extrastorage:disk/shaped/disk_1048576k_fluid" | "immersiveengineering:mineral/amethyst_crevasse" | "mobdropsrecipes_overworld:essence_into_totem_of_undying" | "engineeredcompatibility:cloche/botania/magenta_petal_rich_soil" | "create:deploying/waxed_exposed_copper_tile_slab_from_adding_wax" | "create:polished_cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "create:cutting/compat/regions_unexplored/blackwood_log" | "exdeorum:sieve/moss_block/diamond/glow_berries" | "exdeorum:compressed_sieve/crushed_netherrack/flint/gunpowder" | "railways:crafting/palettes/dyeing_1x/green_brass_wrapped_locometal" | "create:deploying/waxed_weathered_cut_copper_slab_from_adding_wax" | "exdeorum:sieve/moss_block/netherite/yellow_autumn_sapling" | "immersiveengineering:metalpress/wire_cobalt" | "minecraft:orange_carpet" | "immersiveengineering:blueprint/component_electronic_adv" | "create:campfire_cooking/bread" | "mowlib:filters/vanilla/individual_mobs/baby/filter_type_horsezombie_baby" | "create:cutting/compat/quark/azalea_wood" | "create_netherless:pigstep_from_haunting" | "mcwfurnitures:stripped_acacia_lower_triple_drawer" | "create:cutting/compat/tconstruct/skyroot_log" | "immersiveengineering:arcfurnace/raw_block_osmium" | "minecraft:mangrove_slab" | "engineeredcompatibility:sawmill/twilightforest/sortingwood_door" | "railways:crafting/palettes/dyeing_1x/brown_flat_riveted_locometal" | "pedestals:machines/upgrademodification/hiveharvester/hiveharvester_speed_tier_one" | "farmersdelight:cutting/leather_boots" | "exdeorum:compressed_netherrack" | "create:crushing/compat/thermal/niter_ore" | "createcompression:block/minecraft/gold/decompress/1x" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/jute" | "create:cut_diorite_slab_recycling" | "railways:sequenced_assembly/track_natures_spirit_palo_verde" | "refinedstorage:coloring_recipes/black_detector" | "immersiveengineering:crusher/ingot_platinum" | "create:cutting/compat/blue_skies/stripped_frostbright_log" | "exdeorum:compressed_sieve/red_sand/golden/cactus" | "create:filling/chocolate_pie" | "createcompression:block/minecraft/gold/decompress/2x" | "immersiveengineering:crafting/conveyor_vertical_covered" | "railways:crafting/palettes/dyeing_8x/purple_flat_riveted_locometal" | "minecraft:netherite_sword_smithing" | "createaddition:compat/immersiveengineering/crushing/coal_coke" | "create:cutting/compat/ecologics/flowering_azalea_wood" | "immersiveengineering:crusher/raw_ore_aluminum" | "create:blasting/iron_ingot_from_crushed" | "exdeorum:diorite" | "mcwfurnitures:cherry_double_wardrobe" | "railways:crafting/palettes/dyeing_1x/brown_brass_wrapped_locometal_boiler" | "immersiveengineering:crafting/torch" | "exdeorum:compressed_sieve/crushed_end_stone/flint/chorus_fruit" | "immersiveengineering:metalpress/rod_invar" | "minecraft:magenta_concrete_powder" | "minecraft:red_dye_from_poppy" | "exdeorum:sieve/sand/diamond/gold_nugget" | "minecraft:light_blue_candle" | "create_netherless:crimson_nylium_from_deploying" | "exdeorum:compressed_sieve/dirt/netherite/grass_seeds" | "pedestals:augments/dualhanded_t2_speed" | "minecraft:iron_ingot_from_blasting_deepslate_iron_ore" | "pedestals:machines/upgrademodification/recycler/recycler_speed_tier_two" | "minecraft:deepslate_tile_wall_from_deepslate_tiles_stonecutting" | "railways:sequenced_assembly/track_byg_embur_narrow" | "pedestals:machines/unbottler/unbottler_arsn_greaterxpgem" | "create:crushing/sandstone/8x_to_8x_sand" | "immersiveengineering:stonecutting/slab_concrete" | "immersiveengineering:blueprint/component_iron" | "create:polished_cut_scoria_slab_from_stone_types_scoria_stonecutting" | "farmersdelight:light_blue_hanging_canvas_sign" | "sophisticatedbackpacks:magnet_upgrade" | "railways:crafting/palettes/dyeing_1x/yellow_flat_riveted_locometal" | "pedestals:machines/cobblegen/generate_sand" | "immersiveengineering:crafting/slag_brick" | "mcwfurnitures:spruce_wardrobe" | "exdeorum:compressed_sieve/crushed_netherrack/iron/cobalt_ore_chunk" | "minecraft:yellow_banner" | "extradisks:part/65536k_storage_part" | "immersiveengineering:sawmill/dark_oak_log" | "exdeorum:sieve/dirt/string/stone_pebble" | "pipez:clear_upgrade" | "railways:crafting/palettes/dyeing_8x/yellow_brass_wrapped_locometal_boiler" | "nocubes_craftable_md:music_disc_cat" | "create:cutting/compat/byg/stripped_lament_wood" | "minecraft:purpur_stairs_from_purpur_block_stonecutting" | "peacefulrecipes:music_disc_strad" | "exdeorum:barrel_compost/saplings" | "createcompression:block/minecraft/bone_block/compress/1x" | "create:milling/compat/environmental/dianthus" | "create:milling/compat/regions_unexplored/daisy" | "create:crafting/kinetics/mysterious_cuckoo_clock" | "createsweetsandtreets:cut_rock_candy_recipe_2_blue" | "minecraft:dye_gray_bed" | "minecraft:firework_star_fade" | "create:cutting/compat/windswept/chestnut_wood" | "railways:sequenced_assembly/track_tfc_oak" | "farmersdelight:cooked_salmon_slice_from_campfire_cooking" | "refinedstorage:coloring_recipes/black_grid" | "refinedstorage:coloring_recipes/brown_crafter_manager" | "exdeorum:compressed_sieve/moss_block/flint/red_archwood_sapling" | "create:crafting/logistics/pulse_repeater" | "exdeorum:compressed_sieve/red_sand/diamond/raw_gold" | "create:small_scoria_brick_slab_recycling" | "minecraft:dye_light_gray_bed" | "mcwfurnitures:jungle_double_kitchen_cabinet" | "create:milling/compat/byg/lazarus_bellflower" | "minecraft:smooth_basalt" | "refinedstorage:coloring_recipes/controller" | "exdeorum:wooden_watering_can" | "exdeorum:barrel_fluid_mixing/slime_block" | "createcompression:block/minecraft/bone_block/compress/2x" | "create:small_granite_brick_wall_from_stone_types_granite_stonecutting" | "mcwfurnitures:stripped_dark_oak_desk" | "create:small_granite_brick_slab" | "immersiveengineering:crafting/treated_wood_vertical_to_slab" | "extradisks:disk/shaped/262144k_storage_disk" | "exdeorum:sieve/moss_block/flint/jungle_sapling" | "minecraft:blue_candle" | "exdeorum:sieve/moss_block/diamond/orange_autumn_sapling" | "exdeorum:compressed_gravel" | "exdeorum:sieve/crushed_netherrack/golden/raw_gold" | "create:milling/compat/regions_unexplored/red_snowbelle" | "create_confectionery:ruby_chocolate_brick_stairs_recipe_2" | "createcompression:block/minecraft/bone_block/compress/3x" | "minecraft:flower_banner_pattern" | "mcwfurnitures:spruce_stool_chair" | "liquidburner:benzene" | "railways:crafting/palettes/dyeing_8x/white_slashed_locometal" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/cauliflower_rich_soil" | "minecraft:polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting" | "rebornstorage:parts/small_fluid_disk_part" | "createcompression:block/minecraft/soul_sand/decompress/3x" | "exdeorum:compressed_sieve/crushed_blackstone/golden/gold_nugget" | "create:cutting/compat/byg/stripped_pine_wood" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/sweetpotato_rich_soil" | "createcompression:block/minecraft/bone_block/compress/4x" | "easy_mob_farm:mob_farm/ocean_farm/tier2_ocean_farm" | "create:small_diorite_brick_slab" | "createcompression:block/minecraft/soul_sand/decompress/4x" | "immersiveengineering:crafting/sawdust" | "railways:sequenced_assembly/track_byg_imparius_narrow" | "createcompression:block/minecraft/soul_sand/compress/1x" | "create:cut_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "create:smelting/zinc_ingot_from_raw_ore" | "createcompression:block/minecraft/bone_block/compress/5x" | "ironchest:chests/vanilla_copper_chest" | "minecraft:purple_banner" | "immersiveengineering:thermoelectric/packed_ice" | "create:jungle_window_pane" | "farmersdelight:straw_bale" | "create:deepslate_from_stone_types_deepslate_stonecutting" | "railways:crafting/palettes/dyeing_1x/purple_iron_wrapped_locometal" | "immersiveengineering:metalpress/gear_tungsten" | "engineeredcompatibility:sawmill/ancient_aether/sakura_stairs" | "immersiveengineering:stonecutting/stairs_clinker_brick" | "minecraft:wooden_hoe" | "createcompression:block/minecraft/soul_sand/decompress/1x" | "refinedstorage:coloring_recipes/light_gray_network_transmitter" | "create:cutting/compat/byg/ebony_wood" | "mob_catcher:netherite_mob_catcher" | "create:small_limestone_bricks_from_stone_types_limestone_stonecutting" | "createcompression:block/minecraft/bone_block/compress/6x" | "engineeredcompatibility:cloche/botania/purple_petal" | "railways:mechanical_crafting/yellow_iron_wrapped_locometal_boiler" | "railways:sequenced_assembly/track_natures_spirit_olive_wide" | "exdeorum:compressed_sieve/sand/flint/iron_nugget" | "immersiveengineering:crafting/hempcrete_pillar" | "createcompression:block/cc/brass/compress/1x" | "createcompression:block/minecraft/soul_sand/decompress/2x" | "createcompression:block/minecraft/bone_block/compress/7x" | "exdeorum:sieve/moss_block/netherite/green_archwood_sapling" | "mcwfurnitures:stripped_spruce_double_wardrobe" | "exdeorum:sieve/gravel/golden/nickel_ore_chunk" | "exdeorum:compressed_sieve/sand/string/dead_bush" | "railways:crafting/palettes/dyeing_8x/light_blue_iron_wrapped_locometal" | "railways:crafting/palettes/dyeing_8x/red_flat_riveted_locometal" | "minecraft:blackstone_stairs_from_blackstone_stonecutting" | "extradisks:part/infinite_storage_part" | "immersiveengineering:smelting/ingot_uranium" | "exdeorum:compressed_sieve/gravel/netherite/osmium_ore_chunk" | "mcwfurnitures:jungle_coffee_table" | "railways:sequenced_assembly/track_byg_jacaranda_wide" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/truffle" | "minecraft:white_banner" | "exdeorum:sieve/crushed_deepslate/netherite/silver_ore_chunk" | "nocubes_craftable_md:music_disc_blocks" | "refinedstorage:coloring_recipes/magenta_network_transmitter" | "exdeorum:compressed_sieve/crushed_end_stone/netherite/chorus_fruit" | "railways:sequenced_assembly/track_tfc_chestnut" | "exdeorum:sieve/moss_block/netherite/magic_sapling" | "create:cutting/compat/blue_skies/maple_wood" | "create:sequenced_assembly/sturdy_sheet" | "refinedstorage:coloring_recipes/magenta_relay" | "farmersdelight:fried_egg_from_campfire_cooking" | "create:milling/compat/environmental/bluebell" | "minecraft:diorite_stairs_from_diorite_stonecutting" | "comforts:rope_and_nail_shapeless" | "pedestals:machines/upgrademodification/crafter/crafter_range_tier_one" | "create:cutting/compat/regions_unexplored/silver_birch_log" | "create:small_limestone_brick_stairs" | "railways:crafting/palettes/wrapping/orange_copper_wrapped_locometal" | "create_confectionery:candy_cane_recipe_2" | "minecraft:green_glazed_terracotta" | "comforts:sleeping_bag_to_white" | "exdeorum:compressed_sieve/moss_block/iron/fir_sapling" | "create:crafting/kinetics/copper_valve_handle" | "create:deploying/waxed_oxidized_cut_copper_stairs_from_adding_wax" | "immersiveengineering:metalpress/plate_platinum" | "create:small_scorchia_brick_stairs_from_stone_types_scorchia_stonecutting" | "engineersdecor:independent/dark_shingle_roof_skylight_recipe" | "exdeorum:sieve/red_sand/flint/gold_nugget" | "create:milling/compat/byg/california_poppy" | "exdeorum:compressed_sieve/crushed_deepslate/golden/raw_gold" | "immersiveengineering:smelting/ingot_uranium_from_dust" | "create:crushing/compat/aether/zanite_ore" | "immersiveengineering:smelting/copper_ingot_from_dust" | "minecraft:e_item_frame" | "exdeorum:sieve/crushed_netherrack/flint/magma_cream" | "exdeorum:barrel_mixing/clay" | "railways:sequenced_assembly/track_biomesoplenty_palm_wide" | "immersiveengineering:crafting/stick_treated" | "farmersdelight:stove" | "exdeorum:compressed_sieve/soul_sand/iron/nether_wart" | "create:cutting/compat/windswept/stripped_holly_wood" | "engineeredcompatibility:squeezer/ancient_fruit" | "farmersdelight:carrot_crate" | "minecraft:tipped_arrow" | "immersiveengineering:smelting/ingot_hop_graphite" | "more_immersive_wires:ae_connector" | "mobdropsrecipes_overworld:trident" | "minecraft:light_blue_carpet" | "immersiveengineering:cloche/poppy" | "create:cutting/compat/regions_unexplored/redwood_log" | "railways:sequenced_assembly/track_natures_spirit_sugi_narrow" | "railways:mechanical_crafting/lime_iron_wrapped_locometal_boiler" | "vegandelight:smelting/cooked_smoked_tofish" | "mcwfurnitures:stripped_jungle_wardrobe" | "pedestals:machines/upgrademodification/quarry/quarry_area_tier_one" | "minecraft:gold_ingot_from_smelting_deepslate_gold_ore" | "immersiveengineering:crafting/pickaxe_steel" | "mcwfurnitures:stripped_crimson_chair" | "mcwfurnitures:birch_double_drawer" | "lava_source:guide" | "exdeorum:sieve/crushed_deepslate/iron/deepslate_pebble" | "refinedstorage:coloring_recipes/white_crafter_manager" | "create:layered_andesite_from_stone_types_andesite_stonecutting" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/candleberry" | "immersiveengineering:crafting/hempcrete_brick_to_slab" | "create:cut_ochrum_brick_wall_from_stone_types_ochrum_stonecutting" | "create:polished_cut_ochrum_slab_from_stone_types_ochrum_stonecutting" | "create:polished_cut_calcite_from_stone_types_calcite_stonecutting" | "railways:stonecutting/palettes/cycling/red_slashed_locometal" | "mcwfurnitures:stripped_birch_double_drawer" | "immersiveengineering:crafting/blueprint_components" | "railways:crafting/palettes/dyeing_1x/gray_plated_locometal" | "railways:crafting/palettes/dyeing_8x/pink_plated_locometal" | "refinedstorage:coloring_recipes/pink_crafter_manager" | "peacefulrecipes:gunpowder" | "railways:crafting/palettes/dyeing_1x/purple_copper_wrapped_locometal" | "railways:crafting/palettes/dyeing_1x/pink_flat_slashed_locometal" | "create:cutting/compat/environmental/willow_log" | "liquidburner:gasoline" | "immersiveengineering:crafting/sheetmetal_colored_purple_to_slab" | "immersiveengineering:crusher/raw_ore_silver" | "create:cutting/compat/byg/holly_log" | "minecraft:warped_button" | "exdeorum:compressed_sieve/moss_block/diamond/big_dripleaf" | "exdeorum:compressed_sieve/moss_block/golden/spore_blossom" | "create:cut_crimsite_stairs" | "engineersdecor:independent/dark_shingle_roof_chimney_recipe" | "create:small_deepslate_brick_stairs_from_stone_types_deepslate_stonecutting" | "exdeorum:sieve/crushed_deepslate/netherite/deepslate_pebble" | "create:crafting/kinetics/sequenced_gearshift" | "farmersdelight:cutting/dark_oak_door" | "minecraft:armor_dye" | "create:smelting/cobblestone/6x_to_6x_stone" | "pedestals:machines/fluidconverter/fluidconverter_experience_soph" | "exdeorum:compressed_sieve/dust/netherite/bone_meal" | "farmersdelight:cutting/mangrove_hanging_sign" | "create_confectionery:candy_cane_recipe" | "mcwfurnitures:birch_large_drawer" | "exdeorum:compressed_sieve/dust/golden/gold_nugget" | "create:cut_scorchia_stairs" | "createcompression:block/minecraft/deepslate/decompress/9x" | "minecraft:detector_rail" | "engineeredcompatibility:sawmill/blue_skies/dusk_stairs" | "refinedstorage:4096k_fluid_storage_part" | "exdeorum:compressed_sieve/crushed_deepslate/diamond/gold_ore_chunk" | "exdeorum:barrel_compost/pumpkin" | "exdeorum:hammer/fire_coral_fan" | "exdeorum:sieve/dirt/flint/andesite_pebble" | "mcwfurnitures:mangrove_stool_chair" | "exdeorum:sieve/crushed_netherrack/flint/blackstone_pebble" | "mcwfurnitures:warped_large_drawer" | "exdeorum:sieve/dirt/diamond/carrot" | "pedestals:machines/upgrademodification/planter/planter_speed_tier_two" | "immersiveengineering:bottling/copper_aging2" | "exdeorum:sieve/crushed_netherrack/flint/cobalt_ore_chunk" | "immersiveengineering:bottling/copper_aging3" | "mcwfurnitures:jungle_double_drawer" | "engineersdecor:independent/steel_catwalk_ta_recipe" | "immersiveengineering:smelting/nugget_steel_recycle_steel_helmet" | "mcwfurnitures:crimson_bookshelf" | "create:splashing/mekanism/crushed_raw_uranium" | "refinedstorage:coloring_recipes/red_controller" | "create:crafting/logistics/stockpile_switch" | "storagenetwork:request" | "exdeorum:sieve/dust/flint/certus_quartz_dust" | "immersiveengineering:crafting/toolupgrade_drill_fortune" | "refinedstorage:fluid_interface" | "exdeorum:compressed_sieve/crushed_netherrack/string/cobalt_ore_chunk" | "exdeorum:barrel_compost/kelp" | "create_confectionery:black_chocolate_bricks_slab_recipe_2" | "create_confectionery:black_chocolate_bricks_slab_recipe_1" | "immersiveengineering:crafting/sheetmetal_colored_light_blue_from_slab" | "railways:crafting/palettes/dyeing_8x/orange_locometal_boiler" | "immersiveengineering:crafting/toolupgrade_shield_magnet" | "create:cutting/compat/regions_unexplored/green_bioshroom_stem" | "craftable_spawner_p:mooshroom_spawn_egg" | "farmersdelight:magenta_hanging_canvas_sign" | "createcompression:block/minecraft/deepslate/decompress/6x" | "immersiveengineering:stonecutting/concrete_chiseled" | "vegandelight:smelting/cooked_smoked_tofu" | "create:polished_cut_limestone_slab_from_stone_types_limestone_stonecutting" | "minecraft:black_glazed_terracotta" | "create:pressing/compat/byg/lush_grass_path" | "minecraft:carrot_on_a_stick" | "exdeorum:sieve/gravel/netherite/deepslate_pebble" | "extradisks:disk/shaped/262144k_fluid_storage_disk" | "create:cutting/compat/byg/pine_wood" | "createcompression:block/minecraft/deepslate/decompress/5x" | "mcwfurnitures:crimson_wardrobe" | "exdeorum:compressed_sieve/dirt/golden/potato" | "immersiveengineering:arcfurnace/ore_ardite" | "immersiveengineering:generator_fuel/creosote" | "exdeorum:andesite" | "railways:crafting/palettes/dyeing_1x/brown_iron_wrapped_locometal_boiler" | "refinedstorage:pattern_grid/orange_pattern_grid" | "railways:sequenced_assembly/track_byg_lament_wide" | "createcompression:block/minecraft/deepslate/decompress/4x" | "create:cut_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "immersiveengineering:crafting/cokebrick_to_slab" | "engineeredcompatibility:crusher/elementalcraft/springaline_crystal" | "create:cutting/compat/quark/ancient_wood" | "createcompression:block/minecraft/deepslate/decompress/8x" | "createaddition:rolling/steel_ingot" | "refinedstorage:coloring_recipes/red_disk_manipulator" | "createcompression:block/minecraft/glowstone/decompress/8x" | "vegandelight:mixing/applesauce_from_mixing" | "create:crushing/compat/elementaryores/ore_diamond_end" | "exdeorum:sieve/dust/netherite/blaze_powder" | "immersiveengineering:blueprint/banner_bevels" | "exdeorum:sieve/moss_block/diamond/umbran_sapling" | "forgepeacefulmobdrops:chicken" | "create:splashing/gray_concrete_powder" | "createcompression:block/minecraft/deepslate/decompress/7x" | "engineeredcompatibility:sawmill/twilightforest/minewood_log" | "mcwfurnitures:acacia_glass_table" | "create:cutting/compat/botania/dreamwood" | "createcompression:block/minecraft/glowstone/decompress/9x" | "railways:crafting/palettes/dyeing_8x/light_gray_locometal_smokebox" | "immersiveengineering:crusher/white_dye" | "craftable_spawner:slime_spawn_egg" | "extrastorage:part/storagepart_16384k" | "exdeorum:compressed_sieve/moss_block/diamond/azalea" | "exdeorum:sieve/sand/netherite/prismarine_crystals" | "refinedstorage:coloring_recipes/cyan_grid" | "immersiveengineering:crusher/ingot_uranium" | "create:milling/cobblestone/3x_to_3x_gravel" | "immersiveengineering:crafting/connector_probe" | "createcompression:block/minecraft/glowstone/decompress/6x" | "immersiveengineering:crafting/hammercrushing_uranium" | "exdeorum:compressed_sieve/crushed_netherrack/iron/blaze_powder" | "exdeorum:compressed_sieve/gravel/golden/iron_ore_chunk" | "refinedstorage:1024k_fluid_storage_part" | "immersiveengineering:blueprint/bullet_explosive" | "mowlib:filters/vanilla/individual_mobs/baby/filter_type_polarbear_baby" | "createcompression:block/minecraft/tuff/decompress/4x" | "minecraft:polished_granite_stairs_from_polished_granite_stonecutting" | "engineersdecor:independent/clinker_brick_vertical_slab_structured_recipe" | "exdeorum:sieve/gravel/golden/copper_ore_chunk" | "engineeredcompatibility:crusher/blue_skies/ore_diopside" | "exdeorum:sieve/moss_block/string/big_dripleaf" | "createcompression:block/minecraft/deepslate/decompress/1x" | "pedestals:machines/upgrademodification/export/export_speed_tier_two" | "createcompression:block/minecraft/bone_block/decompress/1x" | "create:small_diorite_brick_slab_recycling" | "createcompression:block/minecraft/bone_block/decompress/2x" | "create:milling/compat/byg/cyan_tulip" | "minecraft:arrow" | "createcompression:block/minecraft/glowstone/decompress/7x" | "exdeorum:sieve/moss_block/golden/jungle_sapling" | "exdeorum:compressed_dust" | "cabletiers:ultra_disk_manipulator" | "exdeorum:sieve/moss_block/netherite/palm_sapling" | "createcompression:block/minecraft/tuff/decompress/5x" | "mcwfurnitures:stripped_cherry_chair" | "farmersdelight:purple_canvas_sign" | "pedestals:machines/upgrademodification/pump/pump_block_capacity_tier_two" | "mowlib:filters/vanilla/individual_mobs/filter_type_polarbear" | "exdeorum:sieve/crushed_blackstone/string/basalt_pebble" | "createcompression:block/minecraft/glowstone/decompress/4x" | "create:cut_granite_brick_wall_from_stone_types_granite_stonecutting" | "createcompression:block/minecraft/amethyst/decompress/2x" | "create:smelting/ingot_aluminium_compat_ic2" | "farmersdelight:brown_hanging_canvas_sign" | "pedestals:augments/t1_speed" | "immersiveengineering:crafting/sheetmetal_colored_blue" | "copycats:crafting/copycat_large_cogwheel" | "createcompression:block/minecraft/tuff/decompress/6x" | "createcompression:block/minecraft/deepslate/decompress/3x" | "createcompression:block/minecraft/glowstone/decompress/5x" | "createcompression:block/minecraft/amethyst/decompress/1x" | "exdeorum:sieve/dirt/string/grass_seeds" | "create:cutting/compat/ars_nouveau/stripped_blue_archwood_wood" | "railways:crafting/palettes/dyeing_1x/white_flat_riveted_locometal" | "engineeredcompatibility:sawmill/blue_skies/crystallized_slab" | "engineeredcompatibility:sawmill/hexcasting/edified_stairs" | "createcompression:block/minecraft/tuff/decompress/7x" | "exdeorum:compressed_sieve/crushed_blackstone/flint/basalt_pebble" | "railways:crafting/smokestack_woodburner" | "createcompression:block/minecraft/deepslate/decompress/2x" | "refinedstorage:coloring_recipes/yellow_wireless_transmitter" | "createcompression:block/minecraft/bone_block/decompress/5x" | "createcompression:block/minecraft/glowstone/decompress/2x" | "createcompression:block/minecraft/amethyst/decompress/4x" | "immersiveengineering:crafting/treated_wood_packaged_from_vertical" | "immersiveengineering:crafting/ingot_constantan_to_nugget_constantan" | "createcompression:block/minecraft/tuff/decompress/8x" | "create:cutting/compat/biomesoplenty/hellbark_log" | "create:milling/andesite/6x_to_6x_cobblestone" | "createcompression:block/minecraft/bone_block/decompress/6x" | "createcompression:block/minecraft/amethyst/decompress/3x" | "vegandelight:cooking/silken_tofu" | "minecraft:respawn_anchor" | "createcompression:block/minecraft/glowstone/decompress/3x" | "create:cutting/compat/byg/skyris_wood" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/peas" | "exdeorum:sieve/crushed_netherrack/netherite/blackstone_pebble" | "immersiveengineering:blueprint/mold_bullet_casing" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/huckleberry_rich_soil" | "createcompression:block/minecraft/tuff/decompress/9x" | "pipez:copy_upgrade_ultimate" | "createaddition:charging/cut_copper_slab" | "createaddition:crafting/electrum_amulet" | "createcompression:block/minecraft/bone_block/decompress/3x" | "create:milling/compat/byg/pink_allium_flower_bush" | "exdeorum:sieve/dust/flint/bone_meal" | "createcompression:block/minecraft/amethyst/decompress/6x" | "engineeredcompatibility:sawmill/ecologics/azalea_log" | "comforts:hammock_to_blue" | "mob_grinding_utils:beheading/blaze" | "create:milling/compat/byg/richea" | "create:milling/compat/regions_unexplored/light_blue_snowbelle" | "create:cutting/compat/byg/stripped_skyris_wood" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/peanut" | "exdeorum:compressed_sieve/gravel/golden/emerald" | "exdeorum:sieve/dust/netherite/certus_quartz_dust" | "minecraft:snow_block" | "exdeorum:sieve/gravel/netherite/lead_ore_chunk" | "exdeorum:sieve/dirt/iron/potato" | "extradisks:disk/shaped/1048576k_fluid_storage_disk" | "createcompression:block/minecraft/bone_block/decompress/4x" | "minecraft:sandstone_stairs" | "mob_grinding_utils:beheading/piglin_brute" | "createcompression:block/minecraft/glowstone/decompress/1x" | "exdeorum:compressed_sieve/crushed_deepslate/diamond/lapis_lazuli" | "createcompression:block/minecraft/amethyst/decompress/5x" | "create:crushing/compat/aether/ambrosium_ore" | "create:haunting/infested_cracked_stone_bricks" | "create:copper_tile_stairs" | "railways:crafting/palettes/dyeing_8x/magenta_flat_slashed_locometal" | "minecraft:coarse_dirt" | "refinedstorage:crafting_grid/green_crafting_grid" | "create:crafting/kinetics/white_seat" | "exdeorum:compressed_sieve/crushed_end_stone/netherite/ender_eye" | "refinedstorage:relay" | "minecraft:fermented_spider_eye" | "railways:crafting/palettes/dyeing_1x/blue_iron_wrapped_locometal" | "minecraft:light_gray_glazed_terracotta" | "createcompression:block/minecraft/bone_block/decompress/9x" | "create:blasting/ingot_osmium_compat_mekanism" | "createcompression:block/minecraft/amethyst/decompress/8x" | "engineeredcompatibility:sawmill/undergarden/grongle_slab" | "create:cutting/compat/biomesoplenty/mahogany_log" | "exdeorum:sieve/moss_block/string/redwood_sapling" | "exdeorum:sieve/moss_block/golden/cherry_sapling" | "exdeorum:umbran_barrel" | "create:cutting/compat/ecologics/flowering_azalea_log" | "exdeorum:compressed_hammer/sand" | "minecraft:cobbled_deepslate_slab" | "pedestals:machines/upgrademodification/materialgenerator/cobblegen_speed_tier_two" | "create:crafting/appliances/dough" | "immersiveengineering:arcfurnace/raw_block_copper" | "create:cutting/compat/biomesoplenty/stripped_redwood_wood" | "minecraft:iron_door" | "minecraft:purple_stained_glass_pane" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/broccoli" | "createcompression:block/minecraft/amethyst/decompress/7x" | "immersiveengineering:cloche/brown_mushroom" | "railways:stonecutting/palettes/cycling/magenta_plated_locometal" | "mcwfurnitures:stripped_spruce_stool_chair" | "immersiveengineering:arcfurnace/raw_block_tungsten" | "mobdropsrecipes_overworld:spider_eye_into_essence" | "minecraft:chiseled_quartz_block" | "create:crafting/materials/rose_quartz_tilesfrom_conversion" | "exdeorum:spruce_sieve" | "exdeorum:comet_sieve" | "engineersdecor:independent/treated_wood_pole_support_recipe" | "createcompression:block/minecraft/bone_block/decompress/7x" | "exdeorum:compressed_sieve/gravel/golden/iridium_ore_chunk" | "create:cutting/compat/the_vault/stripped_overgrown_wooden_log" | "create:cut_crimsite_brick_stairs_from_stone_types_crimsite_stonecutting" | "railways:stonecutting/palettes/cycling/brown_locometal_smokebox" | "comforts:hammock_to_lime" | "railways:crafting/palettes/dyeing_8x/white_plated_locometal" | "exdeorum:sieve/red_sand/string/cactus" | "imersiveengineering:crusher/createcompression/cobblestone/4x_to_4x_gravel" | "exdeorum:compressed_diorite" | "create:compacting/rock_candys/blocks/yellow_rock_candy_block" | "vegandelight:crafting_shaped/soymilk_bucket_from_bottles" | "immersiveengineering:sawmill/treated_wood_horizontal_slab" | "minecraft:smooth_quartz_stairs" | "create:crushing/raw_uranium" | "createcompression:block/minecraft/bone_block/decompress/8x" | "create:blasting/ingot_uranium_compat_mekanism" | "createcompression:block/minecraft/amethyst/decompress/9x" | "create:milling/compat/regions_unexplored/purple_lupine" | "createaddition:mixing/biomass_from_honeycomb" | "ironchest:upgrades/gold_to_diamond_chest_upgrade" | "create:cutting/compat/regions_unexplored/pink_bioshroom_hyphae" | "create:smelting/ingot_lead_compat_mekanism" | "railways:crafting/palettes/dyeing_1x/brown_locometal_smokebox" | "railways:sequenced_assembly/track_tfc_birch" | "minecraft:orange_candle" | "immersiveengineering:crafting/sheetmetal_lead" | "refinedstorage:controller" | "exdeorum:sieve/crushed_blackstone/golden/magma_cream" | "exdeorum:sieve/crushed_netherrack/diamond/blackstone_pebble" | "exdeorum:compressed_sieve/moss_block/netherite/blue_archwood_sapling" | "engineeredcompatibility:sawmill/hexcasting/edified_bookshelf" | "mcwfurnitures:stripped_warped_large_drawer" | "railways:crafting/palettes/dyeing_8x/red_riveted_locometal" | "railways:sequenced_assembly/track_ender_wide" | "minecraft:stone_brick_wall" | "exdeorum:compressed_sieve/dust/golden/gunpowder" | "easy_mob_farm:upgrade/enhancement/experience_enhancement" | "createcompression:block/minecraft/tuff/decompress/1x" | "exdeorum:compressed_sieve/crushed_deepslate/netherite/osmium_ore_chunk" | "minecraft:light_blue_dye_from_blue_white_dye" | "railways:sequenced_assembly/track_create_dd_rose_narrow" | "minecraft:cyan_dye" | "create:cutting/compat/ars_nouveau/stripped_blue_archwood_log" | "exdeorum:compressed_sieve/gravel/diamond/thorium_ore_chunk" | "railways:crafting/palettes/dyeing_8x/lime_iron_wrapped_locometal_boiler" | "create:crafting/kinetics/gray_seat_from_other_seat" | "create:cutting/compat/biomesoplenty/palm_wood" | "minecraft:gold_block" | "minecraft:spruce_boat" | "exdeorum:barrel_compost/seeds" | "engineeredcompatibility:sawmill/deeperdarker/echo_door" | "createcompression:block/minecraft/tuff/decompress/2x" | "minecraft:cherry_wood" | "immersiveengineering:crafting/sheetmetal_colored_lime" | "immersiveengineering:crafting/sheetmetal_colored_yellow" | "create:cutting/compat/byg/nightshade_log" | "pedestals:machines/cobblegen/generate_dripstone" | "engineeredcompatibility:sawmill/homespun/ironwood_slab" | "mcwfurnitures:stripped_dark_oak_bookshelf" | "refinedstorage:crafting_grid/white_crafting_grid" | "create_confectionery:black_chocolate_recipe_6" | "create_confectionery:black_chocolate_recipe_5" | "railways:crafting/palettes/dyeing_8x/light_gray_locometal_pillar" | "createcompression:block/minecraft/tuff/decompress/3x" | "create_confectionery:black_chocolate_recipe_2" | "engineeredcompatibility:cloche/quark/glow_shroom" | "minecraft:copper_ingot_from_blasting_raw_copper" | "create_confectionery:black_chocolate_recipe_4" | "create_confectionery:black_chocolate_recipe_3" | "farmersdelight:salmon_roll" | "engineeredcompatibility:sawmill/midnight/nightshroom_door" | "exdeorum:compressed_sieve/crushed_blackstone/iron/basalt_pebble" | "create:cutting/compat/regions_unexplored/stripped_blue_bioshroom_stem" | "pedestals:machines/cobblegen/generate_moss" | "refinedstorage:pattern_grid/red_pattern_grid" | "createcompression:block/minecraft/crimson_plank/decompress/8x" | "mcwfurnitures:mangrove_drawer_counter" | "immersiveengineering:crusher/raw_ore_cobalt" | "create:cut_tuff_brick_slab_recycling" | "exdeorum:compressed_sieve/moss_block/golden/big_dripleaf" | "createcompression:block/minecraft/pumpkin/decompress/9x" | "railways:crafting/palettes/dyeing_8x/magenta_iron_wrapped_locometal_boiler" | "create:ornate_iron_window_pane" | "createcompression:block/minecraft/glass/compress/8x" | "createendertransmission:fluid_transmitter" | "mcwfurnitures:jungle_bookshelf_drawer" | "minecraft:raw_iron" | "createcompression:block/minecraft/crimson_plank/decompress/9x" | "minecraft:iron_nugget" | "mowlib:filters/insertable_filters/filterfood" | "exdeorum:sieve/crushed_blackstone/diamond/blackstone_pebble" | "immersiveengineering:cloche/dandelion" | "exdeorum:sieve/moss_block/flint/maple_sapling" | "mcwfurnitures:stripped_warped_double_drawer_counter" | "pedestals:machines/fluidconverter/fluidconverter_concrete_to_block" | "farmersdelight:cutting/gravel" | "minecraft:waxed_oxidized_cut_copper_from_honeycomb" | "railways:crafting/palettes/dyeing_1x/black_brass_wrapped_locometal" | "imersiveengineering:crusher/createcompression/cobblestone/1x_to_1x_gravel" | "engineeredcompatibility:sawmill/undergarden/smogstem_stairs" | "createcompression:block/minecraft/glass/compress/7x" | "peacefulrecipes:iron_horse_armor" | "engineeredcompatibility:sawmill/blue_skies/comet_door" | "minecraft:bamboo_fence_gate" | "farmersdelight:cooking/baked_cod_stew" | "immersiveengineering:crafting/wirecoil_structure_rope" | "exdeorum:sieve/crushed_netherrack/string/magma_cream" | "createsweetsandtreets:cut_rock_candy_recipe_1_red" | "exdeorum:water_crucible/sea_pickle" | "refinedstorage:coloring_recipes/blue_controller" | "railways:stonecutting/palettes/cycling/green_flat_riveted_locometal" | "exdeorum:compressed_sieve/crushed_netherrack/iron/gold_nugget" | "immersiveengineering:crafting/sheetmetal_colored_purple_from_slab" | "mowlib:filters/insertable_filters/clear_filteritem" | "sophisticatedbackpacks:advanced_magnet_upgrade_from_basic" | "farmersdelight:cherry_cabinet" | "exdeorum:compressed_sieve/dirt/flint/melon_seeds" | "comforts:hammock_purple" | "create:cut_veridium_wall" | "create:crafting/kinetics/magenta_seat_from_other_seat" | "create:cutting/compat/integrateddynamics/menril_log" | "createcompression:block/minecraft/glass/compress/6x" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/oats" | "mowlib:filters/vanilla/individual_mobs/baby/filter_type_drown_baby" | "refinedstorage:coloring_recipes/security_manager" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/tomato" | "engineeredcompatibility:sawmill/forbidden_arcanus/edelwood_door" | "easy_mob_farm:upgrade/enhancement/loot_enhancement" | "exdeorum:dead_sieve" | "minecraft:dye_light_gray_wool" | "minecraft:writable_book" | "create:cut_dripstone_brick_wall_from_stone_types_dripstone_stonecutting" | "railways:stonecutting/palettes/cycling/flat_slashed_locometal" | "create_netherless:warped_nylium_from_deploying" | "createcompression:block/minecraft/glass/compress/5x" | "exdeorum:compressed_sieve/dirt/flint/pink_petals" | "rsrequestify:crafting_emitter" | "exdeorum:compressed_sieve/dirt/netherite/golden_apple" | "mowlib:filters/vanilla/individual_mobs/filter_type_villager" | "exdeorum:compressed_sieve/crushed_netherrack/flint/cobalt_ore_chunk" | "immersiveengineering:crusher/ingot_rose_gold" | "createcompression:block/minecraft/pumpkin/decompress/5x" | "createcompression:block/minecraft/crimson_plank/decompress/4x" | "createcompression:block/minecraft/glass/compress/4x" | "minecraft:diamond_pickaxe" | "railways:sequenced_assembly/track_create_andesite_wide" | "create:splashing/ic2/crushed_raw_aluminum" | "create:crushing/deepslate_redstone_ore" | "exdeorum:compressed_sieve/red_sand/iron/gold_nugget" | "engineeredcompatibility:sawmill/blue_skies/frostbright_slab" | "create:milling/compat/botania/pink_petal" | "create:small_deepslate_brick_slab_recycling" | "createcompression:block/cc/veridium/compress/9x" | "engineersdecor:independent/thin_steel_pole_recipe_backcycle" | "createcompression:block/minecraft/pumpkin/decompress/6x" | "createcompression:block/minecraft/crimson_plank/decompress/5x" | "createcompression:block/minecraft/glass/compress/3x" | "immersiveengineering:crafting/ingot_electrum_to_nugget_electrum" | "exdeorum:compressed_sieve/red_sand/netherite/raw_gold" | "refinedstorage:coloring_recipes/magenta_crafter_manager" | "mcwfurnitures:stripped_mangrove_triple_drawer" | "railways:sequenced_assembly/track_tfc_douglas_fir" | "immersiveengineering:crafting/raw_block_lead_to_raw_lead" | "pedestals:machines/upgrademodification/attacker/attacker_damage_tier_three" | "immersiveengineering:crafting/electric_lantern" | "immersiveengineering:smelting/nugget_steel_recycle_sword_from_blasting" | "craftable_spawner:enderman_spawn_egg" | "createcompression:block/minecraft/pumpkin/decompress/7x" | "createcompression:block/minecraft/glass/compress/2x" | "laserio:card_cloner" | "createcompression:block/minecraft/crimson_plank/decompress/6x" | "engineersdecor:independent/small_fluid_funnel_recipe" | "farmersdelight:cutting/warped_trapdoor" | "extradisks:blocks/16384k_storage_block" | "railways:crafting/palettes/dyeing_1x/yellow_brass_wrapped_locometal_boiler" | "railways:crafting/palettes/wrapping/light_blue_iron_wrapped_locometal" | "farmersdelight:cutting/oak_wood" | "exdeorum:sieve/red_sand/string/redstone" | "createcompression:block/cc/veridium/compress/7x" | "mcwfurnitures:stripped_mangrove_modern_wardrobe" | "railways:crafting/palettes/dyeing_8x/yellow_copper_wrapped_locometal_boiler" | "createcompression:block/minecraft/glass/compress/1x" | "refinedstorage:coloring_recipes/green_security_manager" | "createcompression:block/minecraft/crimson_plank/decompress/7x" | "exdeorum:sieve/moss_block/string/acacia_sapling" | "create:warped_window_pane" | "exdeorum:sieve/crushed_deepslate/flint/deepslate_pebble" | "create:crafting/schematics/schematic_table" | "createcompression:block/minecraft/pumpkin/decompress/8x" | "create:crafting/copper/waxed_weathered_copper_tile_stairs_from_honeycomb" | "createcompression:block/cc/veridium/compress/8x" | "immersiveengineering:crafting/fluid_pump" | "farmersdelight:cutting/spruce_log" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/blackberry_rich_soil" | "immersiveengineering:smelting/nugget_steel_recycle_shovel" | "railways:stonecutting/palettes/cycling/yellow_plated_locometal" | "vegandelight:smoking/cooked_smoked_tofu_slices_from_smoking" | "createcompression:block/minecraft/stone/compress/5x" | "minecraft:wooden_pickaxe" | "railways:mechanical_crafting/cyan_locometal_boiler" | "createcompression:block/minecraft/pumpkin/decompress/1x" | "create:small_asurine_brick_slab" | "createcompression:block/minecraft/jungle_plank/decompress/5x" | "mobdropsrecipes_overworld:string_into_essence" | "minecraft:granite_from_compressed_granite" | "railways:sequenced_assembly/track_twilightforest_sortingwood" | "exdeorum:sieve/crushed_deepslate/diamond/tin_ore_chunk" | "mowlib:filters/vanilla/individual_mobs/filter_type_sniffer" | "vegandelight:smoking/smoked_tofish_from_smoking" | "create:cut_granite_brick_stairs" | "createcompression:block/minecraft/stone/compress/4x" | "railways:mechanical_crafting/black_iron_wrapped_locometal_boiler" | "createcompression:block/minecraft/pumpkin/decompress/2x" | "extradisks:disk/shapeless/1024k_storage_disk" | "createcompression:block/minecraft/jungle_plank/decompress/6x" | "minecraft:diamond_from_blasting_diamond_ore" | "mcwfurnitures:acacia_double_drawer" | "railways:sequenced_assembly/track_blue_skies_maple" | "createaddition:compat/immersiveengineering/item_application/leaded_concrete" | "railways:stonecutting/palettes/cycling/magenta_slashed_locometal" | "engineeredcompatibility:arcfurnace/blue_skies/raw_ore_horizonite" | "create:crushing/tin_ore" | "createcompression:block/minecraft/stone/compress/3x" | "createcompression:block/minecraft/pumpkin/decompress/3x" | "craftable_spawner_p:donkey_spawn_egg" | "createcompression:block/minecraft/jungle_plank/decompress/3x" | "exdeorum:compressed_sieve/crushed_deepslate/iron/magnesium_ore_chunk" | "minecraft:end_stone_brick_stairs" | "engineersdecor:independent/small_waste_incinerator_recipe" | "create:small_andesite_brick_wall_from_stone_types_andesite_stonecutting" | "create:cut_asurine_brick_stairs_from_stone_types_asurine_stonecutting" | "minecraft:stripped_crimson_hyphae" | "peacefulrecipes:poisonous_potato" | "railways:crafting/palettes/dyeing_1x/orange_slashed_locometal" | "mcwfurnitures:birch_bookshelf_drawer" | "minecraft:smooth_sandstone_stairs_from_smooth_sandstone_stonecutting" | "createcompression:block/minecraft/stone/compress/2x" | "createcompression:block/minecraft/pumpkin/decompress/4x" | "pedestals:augments/t2_range" | "immersiveengineering:sawmill/dark_oak_slab" | "peacefulrecipes:gold_horse_armor" | "sliceanddice:filling/hot_cocoa_from_fluid" | "exdeorum:umbran_compressed_sieve" | "createcompression:block/minecraft/jungle_plank/decompress/4x" | "immersiveengineering:smelting/nugget_steel_recycle_steel_helmet_from_blasting" | "create:cutting/compat/byg/stripped_bulbis_stem" | "railways:crafting/palettes/wrapping/light_blue_brass_wrapped_locometal" | "minecraft:mangrove_fence" | "minecraft:polished_deepslate_from_cobbled_deepslate_stonecutting" | "createsweetsandtreets:cut_rock_candy_recipe_1_pink" | "exdeorum:compressed_sieve/crushed_deepslate/iron/silver_ore_chunk" | "refinedstorage:coloring_recipes/gray_crafting_monitor" | "exdeorum:cobbled_deepslate" | "createcompression:block/minecraft/jungle_plank/decompress/9x" | "create_netherless:nether_quartz_from_haunting" | "createcompression:block/minecraft/stone/compress/1x" | "minecraft:light_gray_bed" | "exdeorum:compressed_sieve/gravel/diamond/lapis_lazuli" | "engineersdecor:dependent/old_industrial_planks_recipe" | "immersiveengineering:crusher/ingot_osmium" | "pedestals:machines/upgrademodification/void/void_speed_tier_two" | "immersiveengineering:blueprint/graphite_electrode" | "mowlib:filters/insertable_filters/filterenchantedexact" | "create:cutting/compat/regions_unexplored/larch_log" | "immersiveengineering:cloche/torchflower" | "exdeorum:compressed_sieve/moss_block/golden/green_archwood_sapling" | "exdeorum:comet_compressed_sieve" | "create:cutting/compat/goodending/stripped_muddy_oak_wood" | "railways:stonecutting/palettes/cycling/lime_slashed_locometal" | "exdeorum:compressed_sieve/dirt/golden/flint" | "refinedstorage:coloring_recipes/orange_crafter" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/jicama" | "exdeorum:sieve/crushed_deepslate/netherite/lead_ore_chunk" | "refinedstorage:pattern_grid/black_pattern_grid" | "minecraft:spruce_chest_boat" | "pedestals:upgrades/upgrade_export" | "exdeorum:sieve/dirt/golden/potato" | "create:milling/compat/regions_unexplored/green_snowbelle" | "immersiveengineering:crafting/gunpart_drum" | "createcompression:block/minecraft/jungle_plank/decompress/7x" | "exdeorum:compressed_sieve/moss_block/string/spore_blossom" | "immersiveengineering:crafting/paper_from_sawdust" | "farmersdelight:sweet_berry_cheesecake_from_slices" | "railways:crafting/palettes/dyeing_1x/magenta_brass_wrapped_locometal_boiler" | "createcompression:block/minecraft/jungle_plank/decompress/8x" | "immersiveengineering:arcfurnace/dust_lead" | "immersiveengineering:crafting/alu_wallmount" | "engineeredcompatibility:cloche/ars_nouveau/magebloom_rich_soil" | "minecraft:snow" | "exdeorum:dark_oak_crucible" | "immersiveengineering:sawmill/stripped_crimson_log" | "createcompression:block/minecraft/glass/compress/9x" | "create:cut_crimsite_brick_slab_recycling" | "refinedstorage:coloring_recipes/red_wireless_transmitter" | "exdeorum:sieve/crushed_blackstone/golden/ancient_debris" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/corn_rich_soil" | "engineeredcompatibility:sawmill/midnight/moonshroom_bookshelf" | "exdeorum:compressed_sieve/moss_block/iron/flowering_oak_sapling" | "pedestals:machines/unbottler/unbottler_water_bottle" | "immersiveengineering:crafting/stairs_clinker_brick" | "mcwfurnitures:stripped_spruce_triple_drawer" | "engineeredcompatibility:sawmill/twilightforest/canopy_door" | "minecraft:blackstone_wall_from_blackstone_stonecutting" | "refinedstorage:coloring_recipes/light_gray_crafter_manager" | "railways:crafting/palettes/dyeing_8x/green_brass_wrapped_locometal_boiler" | "exdeorum:sieve/soul_sand/iron/glowstone_dust" | "forgepeacefulmobdrops:cod" | "create:milling/compat/regions_unexplored/cactus_flower" | "createcompression:block/minecraft/sand/compress/2x" | "immersiveengineering:smelting/nugget_steel_recycle_steel_boots_from_blasting" | "createcompression:block/minecraft/red_sand/compress/4x" | "immersiveengineering:crafting/stick_iron" | "farmersdelight:integration/create/milling/wild_carrots" | "exdeorum:starlit_compressed_sieve" | "minecraft:emerald_from_smelting_emerald_ore" | "railways:sequenced_assembly/track_byg_skyris_wide" | "exdeorum:sieve/moss_block/string/blue_archwood_sapling" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/turnip" | "mcwfurnitures:acacia_table" | "mowlib:filters/vanilla/individual_mobs/filter_type_wither" | "create:crafting/appliances/copper_diving_boots" | "exdeorum:compressed_sieve/gravel/netherite/gold_nugget" | "waystones:lime_sharestone" | "exdeorum:sieve/gravel/netherite/boron_ore_chunk" | "mcwfurnitures:stripped_oak_glass_kitchen_cabinet" | "peacefulrecipes:diamond_horse_armor" | "createcompression:block/minecraft/red_sand/compress/3x" | "createcompression:block/minecraft/sand/compress/3x" | "exdeorum:sieve/moss_block/iron/redwood_sapling" | "railways:crafting/palettes/dyeing_8x/green_flat_slashed_locometal" | "farmersdelight:mixed_salad" | "create:crushing/wool" | "exdeorum:sieve/gravel/diamond/iron_ore_chunk" | "create:crimson_window" | "mekanism:crushing/createcompression/stone/8x_to_8x_cobblestone" | "immersiveengineering:blastfurnace/steel_block" | "createaddition:pressing/uranium_ingot" | "createcompression:block/minecraft/sand/compress/5x" | "farmersdelight:cutting/cooked_cod" | "mobdropsrecipes_nether:ghast_tear" | "railways:sequenced_assembly/track_stripped_bamboo" | "minecraft:white_concrete_powder" | "engineeredcompatibility:cloche/farmersdelight/sweet_berries_rich_soil" | "minecraft:yellow_terracotta" | "exdeorum:sieve/moss_block/flint/cherry_sapling" | "immersiveengineering:crafting/alloybrick_from_slab" | "create:cutting/mangrove_log" | "createcompression:block/minecraft/red_sand/compress/6x" | "createcompression:block/minecraft/sand/compress/4x" | "sophisticatedbackpacks:blasting_upgrade" | "minecraft:cherry_boat" | "create_netherless:magma_from_spouting" | "minecraft:chiseled_nether_bricks_from_nether_bricks_stonecutting" | "create:small_andesite_brick_stairs_from_stone_types_andesite_stonecutting" | "refinedstorage:256k_fluid_storage_part" | "create_confectionery:black_chocolate_candy_recipe" | "create:deploying/waxed_weathered_copper_shingles_from_adding_wax" | "createcompression:block/minecraft/sand/compress/6x" | "engineeredcompatibility:arcfurnace/blue_skies/ore_ventium" | "exdeorum:compressed_sieve/dirt/golden/grass_seeds" | "create:milling/compat/regions_unexplored/yellow_snowbelle" | "engineeredcompatibility:sawmill/ecologics/coconut_stairs" | "mcwfurnitures:stripped_jungle_modern_chair" | "sliceanddice:sprinkler" | "immersiveengineering:metalpress/gear_invar" | "createcompression:block/minecraft/red_sand/compress/5x" | "create:crushing/compat/silentgems/sapphire_ore" | "exdeorum:sieve/dust/diamond/bone_meal" | "create:cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "engineeredcompatibility:sawmill/midnight/dewshroom_stem" | "railways:crafting/palettes/dyeing_8x/magenta_locometal_pillar" | "easy_villagers:trader" | "minecraft:barrel" | "create:crushing/compat/elementaryores/ore_emerald_end" | "create:tuff_pillar_from_stone_types_tuff_stonecutting" | "createcompression:block/minecraft/jungle_plank/decompress/1x" | "createcompression:block/minecraft/stone/compress/9x" | "create_confectionery:gingerbread_recipe" | "immersiveengineering:crusher/raw_block_tungsten" | "createcompression:block/minecraft/oak_log/compress/9x" | "exdeorum:compressed_sieve/moss_block/iron/rainbow_birch_sapling" | "exdeorum:compressed_sieve/moss_block/netherite/redwood_sapling" | "createcompression:block/minecraft/jungle_plank/decompress/2x" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/sisal_rich_soil" | "railways:crafting/palettes/dyeing_1x/orange_locometal_smokebox" | "createcompression:block/minecraft/stone/compress/8x" | "minecraft:dye_gray_carpet" | "create:milling/sandstone/2x_to_2x_sand" | "minecraft:shaper_armor_trim_smithing_template" | "mcwfurnitures:jungle_cupboard_counter" | "create:crushing/andesite/4x_to_4x_cobblestone" | "createcompression:block/minecraft/oak_log/compress/8x" | "minecraft:cauldron" | "create:cutting/compat/byg/stripped_blue_enchanted_wood" | "exdeorum:compressed_golden_hammer" | "pedestals:machines/upgrademodification/shearer/sheerer_range_tier_one" | "exdeorum:sieve/moss_block/flint/palm_sapling" | "immersiveengineering:crusher/black_dye" | "createcompression:block/minecraft/red_sand/compress/2x" | "immersiveengineering:smelting/nugget_steel_recycle_steel_chestplate" | "createcompression:block/minecraft/stone/compress/7x" | "railways:crafting/palettes/dyeing_1x/blue_slashed_locometal" | "mcwfurnitures:oak_kitchen_cabinet" | "minecraft:waxed_weathered_cut_copper_slab_from_honeycomb" | "create:cutting/compat/regions_unexplored/stripped_brimwood_log" | "engineeredcompatibility:sawmill/ancient_aether/highsproot_slab" | "pedestals:upgrades/upgrade_crafter" | "exdeorum:compressed_sieve/crushed_netherrack/diamond/quartz" | "exdeorum:sieve/dust/iron/gunpowder" | "createcompression:block/minecraft/oak_log/compress/7x" | "forgepeacefulmobdrops:verdant_froglight" | "createcompression:block/minecraft/oak_log/compress/6x" | "railways:crafting/palettes/dyeing_8x/purple_locometal_pillar" | "create:cutting/compat/byg/cypress_log" | "exdeorum:sieve/gravel/golden/aluminum_ore_chunk" | "minecraft:gold_ingot_from_smelting_gold_ore" | "create:smelting/soul_sand/9x_to_9x_scoria" | "createcompression:block/minecraft/red_sand/compress/1x" | "createcompression:block/minecraft/stone/compress/6x" | "railways:sequenced_assembly/track_natures_spirit_redwood_narrow" | "createcompression:block/minecraft/sand/compress/1x" | "railways:stonecutting/palettes/cycling/yellow_riveted_locometal" | "mcwfurnitures:oak_double_kitchen_cabinet" | "exdeorum:compressed_sieve/moss_block/flint/maple_sapling" | "exdeorum:compressed_sieve/moss_block/flint/flowering_oak_sapling" | "exdeorum:hammer/bubble_coral" | "pedestals:augments/dualhanded_t1_speed" | "minecraft:chest" | "railways:crafting/palettes/dyeing_8x/red_iron_wrapped_locometal" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/kohlrabi_rich_soil" | "minecraft:gray_stained_glass" | "immersiveengineering:crafting/sheetmetal_colored_gray_from_slab" | "engineersdecor:stonecutting/clinker_brick_slab_stonecutting" | "mobdropsrecipes_nether:nether_star_into_essence" | "createsifter:sifting/gravel_andesite_mesh" | "createaddition:charging/exposed_cut_copper_stairs" | "railways:crafting/palettes/dyeing_8x/pink_iron_wrapped_locometal_boiler" | "create:cutting/compat/byg/bulbis_stem" | "exdeorum:sieve/crushed_blackstone/golden/basalt_pebble" | "createcompression:block/cc/veridium/compress/5x" | "minecraft:red_bed" | "extradisks:blocks/1024k_storage_block" | "create:cutting/compat/twilightforest/stripped_mining_wood" | "exdeorum:compressed_sieve/gravel/iron/coal" | "minecraft:deepslate_bricks_from_cobbled_deepslate_stonecutting" | "exdeorum:compressed_sieve/dirt/flint/stone_pebble" | "railways:crafting/palettes/dyeing_8x/light_blue_locometal_smokebox" | "engineeredcompatibility:cloche/botania/black_petal" | "immersiveengineering:smelting/ingot_aluminum_from_blasting" | "create:compacting/granite_from_flint" | "createcompression:block/cc/veridium/compress/6x" | "exdeorum:sieve/crushed_netherrack/netherite/gold_nugget" | "farmersdelight:cooked_cod_slice_from_campfire_cooking" | "railways:crafting/palettes/dyeing_1x/purple_flat_riveted_locometal" | "create:copper_ladder_from_ingots_copper_stonecutting" | "exdeorum:sieve/moss_block/string/oak_sapling" | "create:cutting/stripped_birch_log" | "immersiveengineering:mineral/mephitic_quarzite" | "exdeorum:sieve/soul_sand/string/ghast_tear" | "engineeredcompatibility:sawmill/twilightforest/darkwood_slab" | "minecraft:iron_boots" | "minecraft:golden_chestplate" | "exdeorum:sieve/moss_block/netherite/jacaranda_sapling" | "refinedstorage:64k_fluid_storage_disk_from_storage_housing" | "createcompression:block/cc/veridium/compress/3x" | "railways:dying_existing_cap_black" | "pedestals:upgrades/upgrade_harvester" | "comforts:sleeping_bag_to_green" | "waystones:green_sharestone" | "minecraft:netherite_ingot" | "farmersdelight:warped_cabinet" | "exdeorum:hellbark_crucible" | "exdeorum:compressed_sieve/moss_block/netherite/birch_sapling" | "refinedstorage:fluid_grid/pink_fluid_grid" | "railways:mechanical_crafting/cyan_copper_wrapped_locometal_boiler" | "createcompression:block/cc/veridium/compress/4x" | "railways:crafting/palettes/dyeing_8x/purple_iron_wrapped_locometal" | "minecraft:light_blue_terracotta" | "create:cutting/compat/botania/glimmering_livingwood_log" | "minecraft:spruce_stairs" | "exdeorum:compressed_sieve/dirt/iron/potato" | "createcompression:block/minecraft/sand/compress/7x" | "create:deploying/waxed_cut_copper_from_adding_wax" | "create_confectionery:bar_of_caramel_recipe" | "createcompression:block/minecraft/red_sand/compress/8x" | "engineersdecor:dependent/straight_pipe_valve_redstone_recipe" | "immersiveengineering:squeezer/beetroot_seeds" | "exdeorum:compressed_sieve/gravel/flint/emerald" | "exdeorum:compressed_sieve/crushed_deepslate/diamond/osmium_ore_chunk" | "exdeorum:ores/thorium_tag" | "pedestals:machines/upgrademodification/furnace_blast/blaster_speed_tier_two" | "createcompression:block/cc/veridium/compress/1x" | "minecraft:light_gray_dye_from_white_tulip" | "mcwfurnitures:stripped_crimson_drawer" | "create:cutting/compat/blue_skies/bluebright_log" | "immersiveengineering:crafting/wirecoil_copper" | "imersiveengineering:crusher/createcompression/gravel/2x_to_2x_sand" | "createcompression:block/minecraft/sand/compress/8x" | "create:cutting/compat/quark/azalea_log" | "create:polished_cut_scoria_wall" | "create:cut_dripstone_wall_from_stone_types_dripstone_stonecutting" | "createcompression:block/minecraft/red_sand/compress/7x" | "immersiveengineering:crafting/conveyor_extract" | "create:cutting/compat/twilightforest/twilight_oak_log" | "createcompression:block/cc/veridium/compress/2x" | "mobdropsrecipes_overworld:overworld_essence_rare" | "extradisks:withering_processor" | "sophisticatedbackpacks:deposit_upgrade" | "mcwfurnitures:mangrove_covered_desk" | "mcwfurnitures:stripped_acacia_end_table" | "createcompression:block/minecraft/sand/compress/9x" | "railways:crafting/palettes/dyeing_1x/pink_brass_wrapped_locometal" | "ironchest:chests/diamond_crystal_chest" | "mcwfurnitures:stripped_warped_modern_desk" | "create:copycat_panel_from_ingots_zinc_stonecutting" | "minecraft:cooked_rabbit_from_campfire_cooking" | "immersiveengineering:arcfurnace/dust_aluminum" | "railways:crafting/palettes/dyeing_8x/blue_copper_wrapped_locometal_boiler" | "imersiveengineering:crusher/createcompression/glass/8x_to_8x_sand" | "exdeorum:sieve/dust/flint/grains_of_infinity" | "exdeorum:compressed_sieve/crushed_netherrack/string/quartz" | "exdeorum:compressed_sieve/gravel/golden/silver_ore_chunk" | "createcompression:block/minecraft/red_sand/compress/9x" | "immersiveengineering:metalpress/rod_rose_gold" | "exdeorum:compressed_sieve/soul_sand/golden/ghast_tear" | "exdeorum:compressed_hammer/crushed_deepslate" | "railways:sequenced_assembly/track_twilightforest_sortingwood_narrow" | "create_confectionery:white_chocolate_candy_recipe" | "create:crushing/raw_nickel_block" | "immersiveengineering:metalpress/plate_zinc" | "createendertransmission:chunk_loader" | "easy_mob_farm:mob_farm/animal_plains_farm/tier2_animal_plains_farm" | "exdeorum:compressed_sieve/dirt/string/carrot" | "create:small_limestone_brick_wall_from_stone_types_limestone_stonecutting" | "createcompression:block/minecraft/soul_sand/decompress/7x" | "minecraft:light_gray_carpet" | "exdeorum:comet_barrel" | "minecraft:magenta_stained_glass_pane_from_glass_pane" | "minecraft:smooth_sandstone" | "engineeredcompatibility:cloche/botania/cyan_petal" | "mcwfurnitures:stripped_mangrove_large_drawer" | "createcompression:block/minecraft/soul_sand/decompress/8x" | "create:splashing/endergetic/petrified_end_corrock_crown" | "extrastorage:storage_block/block_16384k_fluid" | "createcompression:block/minecraft/granite/compress/9x" | "railways:stonecutting/palettes/cycling/white_locometal_pillar" | "exdeorum:cooked_silk_worm_from_smoking" | "railways:crafting/palettes/dyeing_1x/magenta_iron_wrapped_locometal_boiler" | "pedestals:machines/upgrademodification/import/import_fluid_capacity_tier_two" | "minecraft:polished_blackstone_bricks" | "create_confectionery:black_chocolate_glazed_berries_recipe" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/rutabaga" | "minecraft:mossy_cobblestone_from_moss_block" | "mcwfurnitures:mangrove_bookshelf_drawer" | "exdeorum:sieve/dust/netherite/iron_nugget" | "createcompression:block/minecraft/soul_sand/decompress/9x" | "create:small_granite_brick_stairs" | "createcompression:block/minecraft/granite/compress/8x" | "exdeorum:compressed_sieve/moss_block/flint/big_dripleaf" | "mobdropsrecipes_overworld:essence_into_prismarine_shard" | "minecraft:lantern" | "refinedstorage:speed_upgrade" | "minecraft:waxed_cut_copper_slab_from_waxed_copper_block_stonecutting" | "createcompression:block/minecraft/soul_sand/decompress/5x" | "mowlib:filters/vanilla/individual_mobs/baby/filter_type_sniffer_baby" | "createcompression:block/minecraft/warped_plank/decompress/1x" | "minecraft:deepslate_brick_wall" | "createcompression:block/minecraft/granite/compress/7x" | "create:small_ochrum_brick_stairs_from_stone_types_ochrum_stonecutting" | "create:milling/granite/7x_to_7x_red_sand" | "mob_grinding_utils:recipe_fan" | "createcompression:block/minecraft/soul_sand/decompress/6x" | "more_immersive_wires:cc_relay" | "create:cutting/compat/silentgear/stripped_netherwood_log" | "createcompression:block/minecraft/warped_plank/decompress/2x" | "refinedstorage:coloring_recipes/blue_detector" | "immersiveengineering:crafting/hempcrete_to_slab" | "railways:sequenced_assembly/track_tfc_rosewood_narrow" | "exdeorum:sieve/crushed_netherrack/flint/warped_nylium_spores" | "refinedstorage:coloring_recipes/lime_controller" | "create:blasting/zinc_ingot_from_ore" | "createcompression:block/minecraft/granite/compress/6x" | "exdeorum:compressed_sieve/gravel/netherite/lapis_lazuli" | "farmersdelight:flint_knife" | "exdeorum:oak_sieve" | "minecraft:cherry_chest_boat" | "railways:crafting/palettes/dyeing_1x/cyan_iron_wrapped_locometal" | "exdeorum:sieve/red_sand/netherite/raw_gold" | "engineeredcompatibility:cloche/farmersdelight/potato_rich_soil" | "pedestals:machines/upgrademodification/fan/fan_range_tier_one" | "immersiveengineering:crafting/sheetmetal_steel_to_slab" | "mcwfurnitures:stripped_spruce_drawer" | "createcompression:block/minecraft/warped_plank/decompress/3x" | "createaddition:rolling/electrum_plate" | "exdeorum:compressed_sieve/moss_block/flint/hellbark_sapling" | "mcwfurnitures:stripped_mangrove_bookshelf_drawer" | "create:cutting/compat/biomesoplenty/stripped_mahogany_wood" | "exdeorum:sieve/soul_sand/flint/nether_wart" | "createcompression:block/minecraft/granite/compress/5x" | "refinedstorage:coloring_recipes/yellow_network_transmitter" | "exdeorum:sieve/crushed_deepslate/iron/amethyst_shard" | "create:milling/tall_grass" | "railways:crafting/palettes/dyeing_1x/purple_riveted_locometal" | "exdeorum:sieve/crushed_blackstone/netherite/magma_cream" | "create:polished_cut_scorchia_slab_recycling" | "mobdropsrecipes_overworld:trident_into_essence" | "minecraft:magenta_dye_from_purple_and_pink" | "createcompression:block/minecraft/warped_plank/decompress/4x" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/cucumber" | "createcompression:block/minecraft/granite/compress/4x" | "exdeorum:sieve/crushed_deepslate/iron/thorium_ore_chunk" | "exdeorum:compressed_sieve/soul_sand/golden/quartz" | "minecraft:redstone_lamp" | "engineersdecor:independent/dark_shingle_roof_slab_recipe_decompose" | "mcwfurnitures:warped_lower_bookshelf_drawer" | "createcompression:block/minecraft/warped_plank/decompress/5x" | "easy_mob_farm:mob_farm/nether_fortress_farm/tier1_nether_fortress_farm" | "minecraft:iron_ingot_from_blasting_iron_ore" | "createcompression:block/minecraft/granite/compress/3x" | "mcwfurnitures:stripped_birch_large_drawer" | "createcompression:block/minecraft/warped_plank/decompress/6x" | "create:polished_cut_veridium_slab_recycling" | "exdeorum:compressed_sieve/crushed_deepslate/flint/amethyst_shard" | "immersiveengineering:crafting/alloybrick_to_slab" | "create:milling/compat/byg/purple_rose" | "createcompression:block/minecraft/oak_log/compress/5x" | "immersiveengineering:smelting/nugget_steel_recycle_steel_leggings" | "engineeredcompatibility:sawmill/midnight/dewshroom_stairs" | "createcompression:block/cc/asurine/decompress/6x" | "exdeorum:sieve/dirt/string/beetroot_seeds" | "exdeorum:sieve/dirt/iron/pumpkin_seeds" | "refinedstorage:exporter" | "refinedstorage:security_manager" | "mcwfurnitures:stripped_acacia_double_wardrobe" | "exdeorum:birch_crucible" | "farmersdelight:magenta_canvas_sign" | "railways:stonecutting/palettes/cycling/white_riveted_locometal" | "immersiveengineering:arcfurnace/raw_block_lead" | "create:scoria_pillar_from_stone_types_scoria_stonecutting" | "exdeorum:compressed_sieve/gravel/flint/amethyst_shard" | "create:polished_cut_dripstone_stairs" | "createcompression:block/minecraft/oak_log/compress/4x" | "railways:crafting/palettes/dyeing_1x/gray_brass_wrapped_locometal_boiler" | "create:compacting/apple_syrup" | "createcompression:block/cc/asurine/decompress/5x" | "create:filling/chocolate_cookie" | "easy_mob_farm:mob_farm/desert_farm/tier2_desert_farm" | "exdeorum:sieve/red_sand/golden/gold_nugget" | "exdeorum:compressed_sieve/moss_block/string/snowblossom_sapling" | "minecraft:painting" | "mcwfurnitures:stripped_mangrove_cupboard_counter" | "farmersdelight:cutting/wild_potatoes" | "refinedstorage:improved_processor" | "createcompression:block/minecraft/oak_log/compress/3x" | "pedestals:machines/upgrademodification/pump/pump_speed_tier_one" | "vegandelight:cutting/feather" | "createcompression:block/cc/asurine/decompress/4x" | "minecraft:dark_oak_wood" | "createaddition:rolling/aluminum_ingot" | "createaddition:crafting/small_connector_copper" | "create:small_ochrum_brick_slab_recycling" | "farmersdelight:cutting/birch_hanging_sign" | "railways:crafting/palettes/dyeing_8x/black_copper_wrapped_locometal" | "immersiveengineering:sawmill/warped_door" | "immersiveengineering:sawmill/stripped_dark_oak_log" | "exdeorum:water_crucible/vine" | "farmersdelight:integration/create/milling/wild_potatoes" | "exdeorum:compressed_sieve/gravel/diamond/flint" | "createcompression:block/minecraft/oak_log/compress/2x" | "railways:sequenced_assembly/track_cherry_wide" | "pedestals:machines/upgrademodification/fluidconverter/fluidconverter_speed_tier_one" | "create:deploying/waxed_weathered_copper_shingle_stairs_from_adding_wax" | "railways:sequenced_assembly/track_twilightforest_mangrove_narrow" | "createcompression:block/cc/asurine/decompress/3x" | "create:crafting/materials/andesite_alloy_block" | "exdeorum:water_crucible/moss" | "create:cutting/compat/architects_palette/stripped_twisted_log" | "immersiveengineering:mineral/cassiterite" | "create:crafting/kinetics/pink_seat_from_other_seat" | "create:cutting/compat/hexcasting/edified_log" | "exdeorum:sieve/crushed_deepslate/iron/iridium_ore_chunk" | "create:crafting/kinetics/placard" | "minecraft:birch_button" | "createcompression:block/minecraft/oak_log/compress/1x" | "railways:sequenced_assembly/track_natures_spirit_maple_narrow" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/tomato_rich_soil" | "farmersdelight:grilled_salmon" | "refinedstorage:coloring_recipes/green_relay" | "exdeorum:compressed_sieve/gravel/golden/nickel_ore_chunk" | "create:crushing/diamond_horse_armor" | "immersiveengineering:crafting/sorter" | "minecraft:weathered_cut_copper_stairs_from_weathered_copper_stonecutting" | "create:milling/granite/4x_to_4x_red_sand" | "immersiveengineering:crafting/chute_copper" | "exdeorum:sieve/moss_block/golden/fir_sapling" | "minecraft:cyan_bed" | "exdeorum:sieve/moss_block/netherite/dead_sapling" | "createcompression:block/cc/asurine/decompress/9x" | "exdeorum:compressed_sieve/moss_block/string/fir_sapling" | "railways:sequenced_assembly/track_create_dd_smoked_wide" | "immersiveengineering:crafting/current_transformer" | "exdeorum:compressed_sieve/crushed_blackstone/golden/blackstone_pebble" | "mcwfurnitures:stripped_mangrove_double_wardrobe" | "create:crafting/kinetics/white_valve_handle_from_other_valve_handle" | "refinedstorage:block_of_quartz_enriched_iron" | "railways:sequenced_assembly/track_tfc_blackwood" | "railways:stonecutting/palettes/cycling/green_locometal_smokebox" | "create:crushing/compat/silentgems/kyanite_ore" | "createcompression:block/cc/asurine/decompress/8x" | "create:smelting/sand/6x_to_6x_glass" | "exdeorum:compressed_sieve/moss_block/string/red_archwood_sapling" | "railways:crafting/palettes/dyeing_8x/purple_brass_wrapped_locometal" | "pedestals:augments/t4_range" | "refinedstorage:coloring_recipes/light_gray_relay" | "create:small_limestone_brick_slab_recycling" | "railways:crafting/palettes/dyeing_1x/brown_slashed_locometal" | "railways:crafting/palettes/dyeing_1x/light_gray_copper_wrapped_locometal" | "immersiveengineering:metalpress/wire_silver" | "comforts:hammock_pink" | "minecraft:brick" | "exdeorum:compressed_sieve/soul_sand/netherite/glowstone_dust" | "exmachinis:comparator_upgrade" | "createcompression:block/cc/asurine/decompress/7x" | "railways:crafting/palettes/dyeing_8x/blue_riveted_locometal" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/wolfberry_rich_soil" | "exdeorum:sieve/sand/netherite/gold_nugget" | "railways:crafting/palettes/dyeing_1x/green_slashed_locometal" | "exdeorum:compressed_sieve/gravel/flint/diorite_pebble" | "railways:crafting/palettes/dyeing_1x/blue_locometal_pillar" | "immersiveengineering:crusher/raw_block_uranium" | "immersiveengineering:crafting/sheetmetal_colored_magenta_to_slab" | "exdeorum:compressed_sieve/gravel/string/flint" | "railways:stonecutting/palettes/cycling/cyan_locometal_pillar" | "immersiveengineering:crafting/sheetmetal_aluminum_from_slab" | "create:cutting/compat/atmospheric/stripped_aspen_wood" | "create:cutting/compat/byg/stripped_cypress_log" | "engineeredcompatibility:sawmill/ancient_aether/highsproot_bookshelf" | "immersiveengineering:cloche/hemp" | "mcwfurnitures:stripped_warped_bookshelf_cupboard" | "immersiveengineering:crafting/hammercrushing_aluminum" | "create:deploying/waxed_weathered_copper_tile_slab_from_adding_wax" | "railways:stonecutting/palettes/cycling/light_blue_locometal_smokebox" | "sophisticatedbackpacks:iron_backpack" | "mekanism:enriching/createcompression/red_sand/4x_to_4x_gravel" | "mowlib:applicator" | "create:crafting/kinetics/smart_chute" | "engineeredcompatibility:sawmill/midnight/dark_willow_stairs" | "minecraft:brown_dye" | "mcwfurnitures:stripped_dark_oak_double_wardrobe" | "minecraft:brick_slab" | "railways:crafting/palettes/dyeing_8x/orange_plated_locometal" | "railways:conductor_vent_from_industrial_iron_block_stonecutting" | "create:deploying/waxed_exposed_copper_shingle_stairs_from_adding_wax" | "minecraft:red_sandstone_slab" | "immersiveengineering:arcfurnace/ore_copper" | "exdeorum:red_archwood_compressed_sieve" | "pedestals:machines/upgrademodification/shearer/sheerer_speed_tier_one" | "extradisks:advanced_machine_casing" | "minecraft:yellow_glazed_terracotta" | "create:polished_cut_diorite_stairs_from_stone_types_diorite_stonecutting" | "sophisticatedbackpacks:auto_smoking_upgrade_from_auto_smelting_upgrade" | "exdeorum:compressed_sieve/dirt/flint/granite_pebble" | "immersiveengineering:metalpress/wire_iron" | "farmersdelight:cutting/cherry_wood" | "exdeorum:sieve/dust/iron/blaze_powder" | "minecraft:dark_oak_stairs" | "immersiveengineering:arcfurnace/raw_ore_nickel" | "farmersdelight:honey_glazed_ham_block" | "mekanism:enriching/createcompression/sand/1x_to_1x_gravel" | "minecraft:smooth_red_sandstone_stairs_from_smooth_red_sandstone_stonecutting" | "exdeorum:compressed_sieve/gravel/string/diamond" | "pedestals:machines/upgrademodification/fertilizer/fertilizer_area_tier_one" | "refinedstorage:coloring_recipes/green_detector" | "exdeorum:sieve/gravel/diamond/deepslate_pebble" | "create:crushing/cobblestone/5x_to_5x_gravel" | "exdeorum:sieve/sand/golden/random_armor_trim" | "easy_mob_farm:upgrade/enhancement/sword_enhancement" | "railways:sequenced_assembly/track_byg_skyris_narrow" | "mcwfurnitures:warped_bookshelf_cupboard" | "create:crushing/leather_horse_armor" | "create:crushing/compat/silentgems/ammolite_ore" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/soybean_rich_soil" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/sisal" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/rice" | "exdeorum:compressed_sieve/moss_block/flint/acacia_sapling" | "immersiveengineering:crafting/plate_electrum_hammering" | "farmersdelight:integration/immersiveengineering/squeezer/tomato_seeds" | "create:cut_deepslate_brick_stairs" | "minecraft:red_nether_brick_wall" | "create:small_crimsite_brick_stairs" | "pedestals:tools/tool_crafting/dualhanded_linkingtool" | "exdeorum:sieve/dust/iron/grains_of_infinity" | "mcwfurnitures:cherry_double_drawer_counter" | "railways:sequenced_assembly/track_biomesoplenty_fir_wide" | "exdeorum:compressed_sieve/moss_block/string/hellbark_sapling" | "mekanism:crushing/createcompression/cobblestone/1x_to_1x_gravel" | "create:cutting/compat/biomesoplenty/mahogany_wood" | "mcwfurnitures:stripped_oak_table" | "create:smelting/cobbled_deepslate/1x_to_1x_deepslate" | "minecraft:light_gray_candle" | "create:smelting/sand/2x_to_2x_glass" | "exdeorum:compressed_sieve/dust/golden/yellorium_dust" | "minecraft:cobbled_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "create:crafting/kinetics/belt_connector" | "exdeorum:compressed_sieve/dirt/diamond/carrot" | "engineeredcompatibility:sawmill/ancient_aether/highsproot_log" | "pedestals:machines/fluidconverter/fluidconverter_honey_to_block_cyclic" | "minecraft:dye_lime_carpet" | "immersiveengineering:sawmill/warped_log" | "farmersdelight:cooking/tomato_sauce" | "farmersdelight:fruit_salad" | "immersiveengineering:crafting/minecart_reinforcedcrate" | "immersiveengineering:crusher/wool" | "create:cutting/compat/blue_skies/stripped_dusk_log" | "minecraft:deepslate_tile_stairs_from_cobbled_deepslate_stonecutting" | "create_confectionery:black_chocolate_bricks_stairs_recipe_2" | "create_confectionery:black_chocolate_bricks_stairs_recipe_1" | "botania:bellows" | "create:cutting/compat/environmental/cherry_wood" | "minecraft:sea_lantern" | "create:weathered_copper_tile_slab" | "engineeredcompatibility:sawmill/midnight/nightshroom_bookshelf" | "farmersdelight:cutting/oak_hanging_sign" | "exdeorum:sieve/soul_sand/flint/ghast_tear" | "exdeorum:compressed_sieve/moss_block/golden/jacaranda_sapling" | "railways:sequenced_assembly/track_tfc_sequoia" | "create:cutting/compat/regions_unexplored/stripped_brimwood_wood" | "createsweetsandtreets:cut_rock_candy_recipe_2_orange" | "createcompression:block/minecraft/granite/compress/2x" | "create:milling/sandstone" | "minecraft:diamond_hoe" | "farmersdelight:tomato_seeds" | "mcwfurnitures:stripped_mangrove_double_drawer" | "createcompression:block/minecraft/warped_plank/decompress/7x" | "farmersdelight:cutting/allium" | "immersiveengineering:cloche/red_mushroom" | "railways:stonecutting/palettes/cycling/pink_slashed_locometal" | "exdeorum:compressed_hammer/gravel" | "create:cutting/compat/tconstruct/stripped_bloodshroom_wood" | "create_confectionery:ruby_chocolate_glazed_marshmallow_recipe" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/spinach_rich_soil" | "create:cutting/compat/silentgear/netherwood_log" | "createcompression:block/minecraft/granite/compress/1x" | "create:cutting/compat/biomesoplenty/palm_log" | "railways:crafting/palettes/dyeing_1x/orange_brass_wrapped_locometal" | "engineersdecor:independent/rebar_concrete_tile_stairs_recipe" | "createcompression:block/minecraft/warped_plank/decompress/8x" | "minecraft:end_stone_brick_stairs_from_end_stone_brick_stonecutting" | "minecraft:dye_pink_carpet" | "mowlib:filters/insertable_filters/filterenchantedcount" | "create:polished_cut_ochrum_stairs" | "refinedstorage:coloring_recipes/cyan_disk_manipulator" | "create:smelting/ingot_aluminum_compat_immersiveengineering" | "exdeorum:sieve/dirt/golden/stone_pebble" | "minecraft:waxed_cut_copper_stairs_from_honeycomb" | "exdeorum:compressed_sieve/crushed_blackstone/netherite/gold_nugget" | "refinedstorage:coloring_recipes/green_pattern_grid" | "create:cut_diorite_brick_slab_recycling" | "engineeredcompatibility:sawmill/aether_redux/glacia_slab" | "createcompression:block/minecraft/warped_plank/decompress/9x" | "immersiveengineering:crafting/concrete_leaded_to_slab" | "create:cutting/compat/byg/stripped_witch_hazel_wood" | "mcwfurnitures:stripped_warped_triple_drawer" | "immersiveengineering:metalpress/rod_lead" | "immersiveengineering:crafting/wirecoil_copper_ins" | "minecraft:furnace" | "create:cutting/compat/upgrade_aquatic/driftwood" | "refinedstorage:coloring_recipes/magenta_fluid_grid" | "create:crushing/compat/elementaryores/ore_copper_nether" | "mcwfurnitures:stripped_oak_lower_bookshelf_drawer" | "mob_grinding_utils:recipe_cursed_feed" | "mowlib:workcards/pedestal_card" | "mcwfurnitures:birch_cupboard_counter" | "minecraft:crimson_pressure_plate" | "exdeorum:sieve/crushed_deepslate/diamond/silver_ore_chunk" | "exdeorum:sieve/dirt/golden/mycelium_spores" | "pedestals:machines/upgrademodification/fan/fan_speed_tier_one" | "immersiveengineering:sawmill/warped_stairs" | "liquidburner:kerosene" | "engineeredcompatibility:cloche/botania/light_blue_petal_rich_soil" | "mowlib:filters/vanilla/individual_mobs/filter_type_witch" | "create:veridium_pillar_from_stone_types_veridium_stonecutting" | "createaddition:compat/tconstruct/slimesteel" | "create:cutting/compat/byg/stripped_green_enchanted_log" | "create:milling/compat/environmental/purple_delphinium" | "create:cutting/compat/botania/stripped_livingwood_log" | "immersiveengineering:smelting/ingot_lead_from_blasting" | "mcwfurnitures:stripped_spruce_table" | "immersiveengineering:crafting/steel_wallmount" | "vegandelight:smelting/tofu_patty" | "minecraft:waxed_cut_copper_stairs_from_waxed_cut_copper_stonecutting" | "watersources:water_source_tier_1" | "minecraft:bamboo_fence" | "exdeorum:bamboo_compressed_sieve" | "create:cutting/compat/twilightforest/dark_wood" | "minecraft:birch_boat" | "craftable_spawner_p:parrot_spawn_egg" | "pedestals:machines/upgrademodification/placer/placer_area_tier_one" | "create_confectionery:bar_of_ruby_chocolate_recipe" | "exdeorum:sieve/crushed_netherrack/golden/basalt_pebble" | "watersources:water_source_tier_2" | "watersources:water_source_tier_3" | "watersources:water_source_tier_4" | "watersources:water_source_tier_5" | "railways:crafting/palettes/dyeing_1x/light_blue_copper_wrapped_locometal_boiler" | "immersiveengineering:metalpress/plate_ardite" | "refinedstorage:importer" | "create:milling/compat/supplementaries/flax" | "immersiveengineering:crafting/ingot_aluminum_to_storage_aluminum" | "railways:stonecutting/palettes/cycling/gray_riveted_locometal" | "minecraft:netherite_helmet_smithing" | "cabletiers:mega_destructor" | "mcwfurnitures:dark_oak_desk" | "create:layered_calcite_from_stone_types_calcite_stonecutting" | "create:milling/compat/upgrade_aquatic/pink_searocket" | "create:cutting/compat/byg/stripped_cika_wood" | "exdeorum:compressed_sieve/moss_block/string/big_dripleaf" | "railways:sequenced_assembly/track_tieless_narrow" | "create:crushing/compat/exnihilosequentia/crushed_diorite" | "exdeorum:barrel_compost/mushroom_stew" | "create:smelting/cobblestone/2x_to_2x_stone" | "immersiveengineering:blueprint/mold_packing_4" | "create:cutting/compat/blue_skies/lunar_wood" | "create:mixing/compat/ae2/fluix_crystal" | "extradisks:part/infinite_fluid_storage_part" | "mowlib:filters/insertable_filters/filtertag" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/blueberry" | "minecraft:gray_candle" | "createcompression:block/cc/crimsite/compress/2x" | "exdeorum:compressed_sieve/sand/netherite/prismarine_crystals" | "minecraft:stripped_dark_oak_wood" | "exdeorum:compressed_sieve/moss_block/diamond/maple_sapling" | "mcwfurnitures:stripped_cherry_double_kitchen_cabinet" | "exdeorum:sieve/moss_block/flint/umbran_sapling" | "mcwfurnitures:stripped_cherry_modern_desk" | "exdeorum:sieve/sand/iron/kelp" | "createsifter:zinc_mesh" | "create:crafting/materials/brass_nugget_from_decompacting" | "storagenetwork:collector" | "minecraft:birch_fence" | "createcompression:block/cc/crimsite/compress/4x" | "mcwfurnitures:crimson_bookshelf_cupboard" | "create:crafting/kinetics/brass_door" | "farmersdelight:cooking_pot" | "exdeorum:compressed_sieve/red_sand/string/gold_nugget" | "create:crafting/materials/zinc_ingot_from_compacting" | "createcompression:block/cc/crimsite/compress/3x" | "create:crushing/andesite/3x_to_3x_cobblestone" | "createcompression:block/cc/crimsite/compress/5x" | "pedestals:machines/upgrademodification/dropper/dropper_xp_capacity_tier_two" | "create:milling/compat/byg/cyan_amaranth" | "create:crafting/kinetics/green_valve_handle_from_other_valve_handle" | "create:mixing/compat/regions_unexplored/silt_mud" | "create:cutting/compat/ars_nouveau/blue_archwood_log" | "railways:crafting/palettes/dyeing_8x/lime_flat_slashed_locometal" | "minecraft:cut_sandstone_slab_from_cut_sandstone_stonecutting" | "immersiveengineering:crafting/storage_electrum_to_slab" | "minecraft:sugar_from_honey_bottle" | "pedestals:machines/bottler/bottler_candle_cyclic" | "pedestals:upgrades/upgrade_import" | "exdeorum:compressed_sieve/moss_block/flint/willow_sapling" | "minecraft:leather_chestplate" | "create_confectionery:white_chocolate_recipe_6" | "create_confectionery:white_chocolate_recipe_5" | "create_confectionery:white_chocolate_recipe_4" | "create:milling/compat/ae2/certus_quartz" | "create_confectionery:white_chocolate_recipe_3" | "engineeredcompatibility:squeezer/ironberries" | "immersiveengineering:crafting/toolupgrade_powerpack_tesla" | "immersiveengineering:crafting/radiator" | "createcompression:block/cc/crimsite/compress/6x" | "create_confectionery:white_chocolate_recipe_2" | "immersiveengineering:sawmill/stripped_birch_log" | "immersiveengineering:crafting/hammer" | "minecraft:birch_wood" | "railways:sequenced_assembly/track_byg_palm" | "immersiveengineering:blueprint/mold_packing_9" | "exdeorum:unfired_porcelain_bucket" | "create:milling/terracotta/6x_to_6x_red_sand" | "engineeredcompatibility:cloche/undergarden/blisterberry" | "exdeorum:sieve/dirt/flint/potato" | "railways:crafting/palettes/dyeing_8x/brown_locometal_pillar" | "mcwfurnitures:acacia_bookshelf_cupboard" | "minecraft:polished_granite_from_granite_stonecutting" | "create:crushing/glowstone" | "exdeorum:sieve/gravel/string/magnesium_ore_chunk" | "exdeorum:compressed_sieve/sand/flint/gold_nugget" | "create:crushing/granite/2x_to_2x_red_sand" | "mcwfurnitures:stripped_jungle_bookshelf" | "forgepeacefulmobdrops:phantom_membrane" | "railways:stonecutting/palettes/cycling/gray_locometal_pillar" | "waystones:black_sharestone" | "createcompression:block/minecraft/dark_oak_log/decompress/2x" | "mcwfurnitures:stripped_jungle_counter" | "create:mechanical_crafting/extendo_grip" | "create:crushing/compat/simplefarming/barley" | "railways:mechanical_crafting/black_brass_wrapped_locometal_boiler" | "minecraft:bamboo_chest_raft" | "pedestals:upgrades/upgrade_smoker" | "minecraft:honey_block" | "immersiveengineering:metalpress/plate_steel" | "railways:crafting/palettes/wrapping/orange_iron_wrapped_locometal" | "create:cutting/compat/byg/stripped_holly_wood" | "minecraft:bamboo_planks" | "immersiveengineering:crusher/raw_ore_tin" | "create:cutting/compat/byg/jacaranda_wood" | "createcompression:block/minecraft/dark_oak_log/decompress/1x" | "mobdropsrecipes_overworld:essence_into_slime_ball" | "railways:sequenced_assembly/track_natures_spirit_aspen" | "create:milling/cobblestone/5x_to_5x_gravel" | "createsifter:string_mesh" | "immersiveengineering:crusher/raw_ore_nickel" | "railways:sequenced_assembly/track_tfc_sequoia_narrow" | "exdeorum:hammer/fire_coral" | "create:cutting/compat/byg/ether_log" | "engineeredcompatibility:cloche/nethersdelight/nether_wart_rich_soul_soil" | "exdeorum:compressed_sieve/red_sand/netherite/cactus" | "immersiveengineering:crafting/sheetmetal_colored_red_to_slab" | "exdeorum:compressed_sieve/crushed_deepslate/golden/lead_ore_chunk" | "immersiveengineering:metalpress/wire_brass" | "createaddition:compat/tconstruct/rose_gold" | "minecraft:coal_from_blasting_coal_ore" | "refinedstorage:coloring_recipes/blue_grid" | "mcwfurnitures:oak_cupboard_counter" | "exdeorum:sieve/crushed_deepslate/flint/lithium_ore_chunk" | "immersiveengineering:crafting/sheetmetal_colored_purple" | "exdeorum:sieve/gravel/diamond/flint" | "immersiveengineering:crafting/sheetmetal_colored_black_from_slab" | "engineeredcompatibility:arcfurnace/blue_skies/raw_block_horizonite" | "createcompression:block/cc/crimsite/compress/1x" | "refinedstorage:destruction_core" | "exdeorum:compressed_sieve/moss_block/golden/mahogany_sapling" | "create:milling/compat/byg/alpine_bellflower" | "exdeorum:compressed_sieve/moss_block/string/small_dripleaf" | "farmersdelight:cutting/red_tulip" | "railways:stonecutting/palettes/cycling/pink_flat_slashed_locometal" | "create:cutting/compat/byg/cika_log" | "engineeredcompatibility:crusher/undergarden/ore_regalium" | "mowlib:filters/insertable_filters/filtertagmachine" | "exdeorum:compressed_sieve/gravel/iron/boron_ore_chunk" | "exdeorum:sieve/red_sand/flint/raw_gold" | "farmersdelight:cutting/spruce_wood" | "create:crafting/logistics/powered_latch" | "railways:crafting/palettes/wrapping/red_copper_wrapped_locometal" | "refinedstorage:coloring_recipes/blue_crafter_manager" | "mcwfurnitures:mangrove_striped_chair" | "create:ochrum_pillar_from_stone_types_ochrum_stonecutting" | "farmersdelight:cutting/crimson_hyphae" | "minecraft:warped_hanging_sign" | "exdeorum:compressed_sieve/crushed_deepslate/golden/amethyst_shard" | "minecraft:cracked_deepslate_bricks" | "exdeorum:sieve/moss_block/flint/redwood_sapling" | "railways:crafting/palettes/dyeing_1x/white_riveted_locometal" | "create:smelting/iron_ingot_from_crushed" | "exdeorum:sieve/crushed_deepslate/diamond/nickel_ore_chunk" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/agave_rich_soil" | "railways:crafting/palettes/dyeing_8x/red_locometal_smokebox" | "immersiveengineering:smelting/iron_ingot_from_dust_from_blasting" | "exdeorum:sieve/gravel/diamond/gold_ore_chunk" | "railways:mechanical_crafting/light_blue_brass_wrapped_locometal_boiler" | "immersiveengineering:speedloader_load" | "create:crafting/materials/andesite_alloy_from_block" | "forgepeacefulmobdrops:sponge" | "minecraft:jungle_fence_gate" | "immersiveengineering:blueprint/bullet_dragonsbreath" | "create:cut_asurine_wall" | "create:polished_cut_asurine_wall_from_stone_types_asurine_stonecutting" | "immersiveengineering:crafting/sheetmetal_aluminum_to_slab" | "create:milling/compat/byg/snowdrops" | "exdeorum:compressed_sieve/moss_block/diamond/purple_archwood_sapling" | "pedestals:machines/upgrademodification/milker/milker_range_tier_one" | "exdeorum:redwood_crucible" | "extrastorage:disk/shapeless/disk_16384k_fluid" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/cactusfruit" | "railways:crafting/palettes/dyeing_8x/red_brass_wrapped_locometal" | "create:crafting/materials/raw_zinc_block" | "create:cutting/andesite_alloy" | "cobblefordays:tier_2" | "create:pressing/copper_ingot" | "cobblefordays:tier_3" | "farmersdelight:light_blue_canvas_sign" | "immersiveengineering:sawmill/bamboo_slab" | "create:cut_diorite_slab_from_stone_types_diorite_stonecutting" | "cobblefordays:tier_1" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/arrowroot" | "railways:sequenced_assembly/track_tfc_acacia" | "cobblefordays:tier_4" | "cobblefordays:tier_5" | "mobdropsrecipes_overworld:prismarine_crystals" | "railways:crafting/palettes/dyeing_8x/white_copper_wrapped_locometal_boiler" | "create:smelting/sand/8x_to_8x_glass" | "exdeorum:sieve/crushed_deepslate/string/copper_ore_chunk" | "mcwfurnitures:stripped_mangrove_lower_triple_drawer" | "storagenetwork:crafting_remote" | "exdeorum:compressed_sieve/moss_block/diamond/red_archwood_sapling" | "exdeorum:sieve/crushed_end_stone/netherite/echo_shard" | "minecraft:warped_planks" | "minecraft:red_nether_brick_wall_from_red_nether_bricks_stonecutting" | "immersiveengineering:crafting/sheetmetal_colored_light_gray" | "exdeorum:sieve/moss_block/diamond/dead_sapling" | "create:crafting/kinetics/sticker" | "immersiveengineering:sawmill/jungle_log" | "createcompression:block/cc/crimsite/compress/7x" | "minecraft:red_candle" | "createcompression:block/minecraft/netherrack/decompress/9x" | "minecraft:brown_carpet" | "railways:crafting/palettes/dyeing_8x/pink_flat_riveted_locometal" | "engineeredcompatibility:sawmill/undergarden/grongle_stairs" | "mcwfurnitures:dark_oak_bookshelf_cupboard" | "imersiveengineering:crusher/createcompression/cobblestone/6x_to_6x_gravel" | "minecraft:crimson_fence" | "exdeorum:compressed_sieve/dirt/golden/pumpkin_seeds" | "immersiveengineering:crusher/raw_block_nickel" | "createcompression:block/cc/crimsite/compress/8x" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/cloudberry" | "immersiveengineering:crafting/concrete_to_slab" | "createcompression:block/minecraft/netherrack/decompress/8x" | "railways:crafting/palettes/dyeing_8x/red_copper_wrapped_locometal" | "minecraft:light_gray_stained_glass" | "sophisticatedbackpacks:backpack_dye" | "mekanism:crushing/createcompression/stone/2x_to_2x_cobblestone" | "create:cutting/compat/environmental/stripped_wisteria_log" | "craftable_spawner:blaze_spawn_egg" | "minecraft:decorated_pot_simple" | "createcompression:block/cc/crimsite/compress/9x" | "exdeorum:compressed_sieve/sand/flint/charged_certus_quartz_crystal" | "engineeredcompatibility:sawmill/midnight/viridshroom_door" | "exdeorum:sieve/gravel/flint/stone_pebble" | "createcompression:block/minecraft/netherrack/decompress/7x" | "immersiveengineering:crafting/steel_scaffolding_standard" | "minecraft:diorite" | "refinedstorage:coloring_recipes/purple_wireless_transmitter" | "extrastorage:storage_block/block_1024k" | "exdeorum:compressed_sieve/gravel/string/osmium_ore_chunk" | "exdeorum:sieve/moss_block/flint/mahogany_sapling" | "minecraft:snout_armor_trim_smithing_template_smithing_trim" | "farmersdelight:cutting/bricks" | "minecraft:jungle_planks" | "exdeorum:sieve/sand/golden/sea_pickle" | "refinedstorage:crafter" | "createcompression:block/minecraft/netherrack/decompress/6x" | "create:cutting/compat/regions_unexplored/cobalt_log" | "engineeredcompatibility:sawmill/deep_aether/conberry_door" | "exdeorum:golden_oak_compressed_sieve" | "create:milling/compat/regions_unexplored/blue_snowbelle" | "engineeredcompatibility:arcfurnace/blue_skies/ore_horizonite" | "exdeorum:sieve/moss_block/netherite/redwood_sapling" | "exdeorum:compressed_sieve/crushed_deepslate/netherite/diamond" | "mob_grinding_utils:recipe_xpsolidifier_upgrade" | "engineeredcompatibility:sawmill/deep_aether/cruderoot_door" | "immersiveengineering:metalpress/rod_aluminum" | "create:crushing/blaze_rod" | "createaddition:charging/copper_shingle_slab" | "createcompression:block/minecraft/red_sand/decompress/9x" | "railways:crafting/palettes/dyeing_1x/purple_brass_wrapped_locometal" | "minecraft:warped_slab" | "minecraft:mangrove_stairs" | "minecraft:prismarine" | "minecraft:bamboo_raft" | "exdeorum:compressed_sieve/dirt/golden/bamboo" | "immersiveengineering:metalpress/wire_aluminum" | "exdeorum:sieve/dust/netherite/sky_dust" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/alfalfa" | "exdeorum:water_crucible/melon" | "railways:sequenced_assembly/track_ender_narrow" | "createcompression:block/minecraft/red_sand/decompress/8x" | "mcwfurnitures:stripped_jungle_chair" | "mowlib:filters/vanilla/individual_mobs/rideable/filter_type_mule" | "create:crafting/kinetics/nozzle" | "minecraft:polished_diorite_slab_from_diorite_stonecutting" | "railways:stonecutting/palettes/cycling/yellow_locometal_smokebox" | "createaddition:compat/tconstruct/pig_iron" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/cloudberry_rich_soil" | "mekanism:crushing/createcompression/gravel/8x_to_8x_sand" | "minecraft:cake" | "mcwfurnitures:stripped_birch_table" | "create:polished_cut_asurine_slab" | "exdeorum:compressed_sieve/dust/golden/raw_gold" | "minecraft:granite_slab" | "createcompression:block/minecraft/red_sand/decompress/7x" | "engineeredcompatibility:cloche/culturaldelights/eggplant_rich_soil" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/wolfberry" | "minecraft:lime_concrete_powder" | "refinedstorage:coloring_recipes/purple_network_transmitter" | "minecraft:sandstone_wall_from_sandstone_stonecutting" | "mowlib:filters/vanilla/individual_mobs/filter_type_vindicator" | "minecraft:polished_blackstone_bricks_from_polished_blackstone_stonecutting" | "immersiveengineering:generator_fuel/biodiesel" | "createcompression:block/minecraft/red_sand/decompress/6x" | "railways:mechanical_crafting/light_gray_iron_wrapped_locometal_boiler" | "minecraft:cherry_pressure_plate" | "create:cutting/compat/byg/palm_log" | "railways:crafting/palettes/dyeing_1x/green_locometal_smokebox" | "minecraft:redstone_from_blasting_deepslate_redstone_ore" | "create:milling/compat/byg/incan_lily" | "exdeorum:sieve/crushed_end_stone/netherite/sculk_shrieker" | "minecraft:netherite_scrap_from_blasting" | "exdeorum:compressed_sieve/crushed_deepslate/diamond/lithium_ore_chunk" | "createcompression:block/cc/asurine/decompress/2x" | "mcwfurnitures:stripped_mangrove_covered_desk" | "refinedstorage:coloring_recipes/orange_security_manager" | "create_confectionery:ruby_chocolate_candy_3_recipe" | "smartcrafter:smart_crafter" | "exdeorum:sieve/gravel/string/diamond" | "craftable_spawner:spider_spawn_egg" | "exdeorum:sieve/gravel/diamond/emerald" | "createcompression:block/cc/asurine/decompress/1x" | "farmersdelight:cutting/cooked_salmon" | "refinedstorage:coloring_recipes/magenta_disk_manipulator" | "pedestals:machines/fluidconverter/fluidconverter_honey_to_block_create" | "immersiveengineering:cloche/glow_berries" | "exdeorum:compressed_sieve/moss_block/diamond/willow_sapling" | "create:cut_scoria_brick_stairs" | "ironchest:chests/vanilla_dirt_chest" | "createcompression:block/cc/nether_star_block/decompress" | "immersiveengineering:crafting/sheetmetal_colored_green_to_slab" | "railways:crafting/palettes/dyeing_1x/black_slashed_locometal" | "refinedstorage:coloring_recipes/lime_crafting_monitor" | "pedestals:machines/upgrademodification/magnet/magnet_speed_tier_two" | "exdeorum:ores/boron_tag" | "immersiveengineering:crusher/bone_meal" | "exdeorum:sieve/gravel/golden/coal" | "mcwfurnitures:stripped_mangrove_bookshelf" | "exdeorum:diamond_watering_can" | "create:polished_cut_scoria_from_stone_types_scoria_stonecutting" | "craftable_slimeball:slimeball_recipe" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/greengrape" | "minecraft:cracked_polished_blackstone_bricks" | "railways:crafting/palettes/dyeing_8x/lime_plated_locometal" | "minecraft:snout_armor_trim_smithing_template" | "railways:sequenced_assembly/track_byg_aspen_narrow" | "comforts:hammock_gray" | "comforts:hammock_to_light_blue" | "minecraft:pink_candle" | "railways:sequenced_assembly/track_byg_bulbis_narrow" | "craftable_elytra_remastered:elytra_side_recipe_2" | "exdeorum:water_crucible/potato" | "refinedstorage:crafting_grid/black_crafting_grid" | "createcompression:block/cc/experience/decompress/3x" | "craftable_spawner_p:sheep_spawn_egg" | "minecraft:ward_armor_trim_smithing_template_smithing_trim" | "create_confectionery:chocolate_glazed_marshmallow_recipe" | "immersiveengineering:crafting/raw_block_uranium_to_raw_uranium" | "mob_grinding_utils:recipe_tank_sink" | "create:crafting/kinetics/encased_chain_drive" | "immersiveengineering:blueprint/electron_tube" | "exdeorum:compressed_sieve/crushed_blackstone/diamond/gold_nugget" | "farmersdelight:mangrove_cabinet" | "engineeredcompatibility:crusher/blue_skies/ore_charoite" | "immersiveengineering:crafting/treated_wallmount" | "refinedstorage:64k_fluid_storage_disk" | "minecraft:eye_armor_trim_smithing_template_smithing_trim" | "pedestals:machines/unbottler/unbottler_honey_bottle" | "railways:stonecutting/palettes/cycling/magenta_locometal_smokebox" | "pedestals:machines/upgrademodification/materialgenerator/cobblegen_speed_tier_one" | "exdeorum:sieve/gravel/string/iron_ore_chunk" | "createcompression:block/cc/experience/decompress/4x" | "createcompression:block/minecraft/tuff/compress/9x" | "refinedstorage:coloring_recipes/gray_crafter_manager" | "minecraft:waxed_exposed_cut_copper_slab_from_waxed_exposed_cut_copper_stonecutting" | "create_confectionery:gingerbread_brick_slab_recipe" | "immersiveengineering:metalpress/plate_iron" | "pedestals:upgrades/upgrade_cobblegen" | "immersiveengineering:stonecutting/concrete_brick2" | "immersiveengineering:crafting/sheetmetal_steel" | "exdeorum:compressed_sieve/gravel/flint/silver_ore_chunk" | "minecraft:netherite_hoe_smithing" | "engineersdecor:independent/panzerglass_slab_recipe" | "mcwfurnitures:acacia_triple_drawer" | "mcwfurnitures:cherry_striped_chair" | "railways:crafting/palettes/wrapping/pink_iron_wrapped_locometal" | "exdeorum:sieve/crushed_netherrack/flint/gunpowder" | "engineeredcompatibility:arcfurnace/undergarden/ore_cloggrum" | "createcompression:block/cc/experience/decompress/5x" | "create:milling/white_tulip" | "createcompression:block/minecraft/tuff/compress/8x" | "easy_mob_farm:mob_farm/swamp_farm/tier0_swamp_farm" | "mcwfurnitures:stripped_acacia_double_drawer_counter" | "immersiveengineering:crafting/toolupgrade_powerpack_antenna" | "minecraft:prismarine_stairs_from_prismarine_stonecutting" | "create:crushing/compat/silentgems/alexandrite_ore" | "minecraft:quartz_stairs_from_quartz_block_stonecutting" | "minecraft:wayfinder_armor_trim_smithing_template_smithing_trim" | "minecraft:birch_pressure_plate" | "create:milling/dripstone/1x_to_9x_clay_ball" | "createcompression:block/cc/experience/decompress/6x" | "createcompression:block/minecraft/tuff/compress/7x" | "exdeorum:compressed_sieve/moss_block/string/mangrove_propagule" | "exdeorum:sieve/moss_block/golden/birch_sapling" | "create:cut_scorchia_wall_from_stone_types_scorchia_stonecutting" | "create:crafting/materials/zinc_nugget_from_decompacting" | "refinedstorage:crafting_grid/lime_crafting_grid" | "create:crafting/copper/waxed_weathered_copper_shingle_stairs_from_honeycomb" | "minecraft:emerald_from_blasting_deepslate_emerald_ore" | "minecraft:black_bed" | "mcwfurnitures:stripped_dark_oak_modern_wardrobe" | "create:crafting/kinetics/hose_pulley" | "create:crushing/lead_ore" | "pedestals:tools/tool_swap/augment_swapping/toolswap_storage_to_range" | "farmersdelight:cooked_bacon" | "exdeorum:acacia_crucible" | "railways:crafting/palettes/dyeing_8x/green_locometal_smokebox" | "railways:crafting/palettes/dyeing_1x/blue_flat_slashed_locometal" | "createcompression:block/cc/experience/decompress/7x" | "create:cut_andesite_slab_from_stone_types_andesite_stonecutting" | "exdeorum:sieve/crushed_deepslate/golden/osmium_ore_chunk" | "createaddition:compat/tconstruct/manyullyn" | "exdeorum:compressed_sieve/gravel/flint/coal" | "refinedstorage:coloring_recipes/cyan_pattern_grid" | "exdeorum:sieve/crushed_deepslate/string/lithium_ore_chunk" | "minecraft:purple_concrete_powder" | "mcwfurnitures:mangrove_cupboard_counter" | "mcwfurnitures:stripped_cherry_modern_wardrobe" | "createcompression:block/cc/experience/decompress/8x" | "exdeorum:sieve/gravel/string/osmium_ore_chunk" | "create:milling/granite/5x_to_5x_red_sand" | "minecraft:red_carpet" | "exdeorum:compressed_sieve/crushed_netherrack/string/gold_nugget" | "immersiveengineering:crafting/hempcrete_brick" | "create:cutting/compat/regions_unexplored/eucalyptus_log" | "immersiveengineering:crafting/light_engineering" | "mcwfurnitures:stripped_cherry_desk" | "createcompression:block/cc/experience/decompress/9x" | "refinedstorage:coloring_recipes/black_fluid_grid" | "exdeorum:sieve/sand/golden/dead_bush" | "create:cut_crimsite_slab_from_stone_types_crimsite_stonecutting" | "immersiveengineering:metalpress/wire_bronze" | "farmersdelight:cooking/dog_food" | "exdeorum:compressed_sieve/crushed_netherrack/iron/quartz" | "mcwfurnitures:stripped_mangrove_modern_desk" | "create:small_scoria_brick_stairs" | "immersiveengineering:crafting/redstone_breaker" | "create:cutting/compat/byg/pine_log" | "engineeredcompatibility:fermenter/vinegar_ingredients" | "refinedstorage:coloring_recipes/brown_grid" | "minecraft:dye_orange_bed" | "create:smelting/silver_ingot_compat_oreganized" | "exdeorum:compressed_sieve/crushed_deepslate/netherite/iron_ore_chunk" | "waystones:red_sharestone" | "sophisticatedbackpacks:iron_backpack_from_copper" | "minecraft:waxed_weathered_cut_copper_from_waxed_weathered_copper_stonecutting" | "exdeorum:barrel_compost/spores_and_seeds" | "create:crafting/kinetics/white_sail" | "createcompression:block/minecraft/tuff/compress/1x" | "exdeorum:compressed_sieve/moss_block/flint/small_dripleaf" | "engineersdecor:independent/old_industrial_wood_stairs_recipe" | "exdeorum:crystallized_compressed_sieve" | "refinedstorage:pattern_grid/yellow_pattern_grid" | "minecraft:smooth_red_sandstone_stairs" | "minecraft:stone_pickaxe" | "createcompression:block/minecraft/tuff/compress/2x" | "refinedstorage:coloring_recipes/lime_crafter" | "create:splashing/quark/rusty_iron_plate" | "minecraft:cyan_stained_glass_pane" | "create:crafting/copper/waxed_oxidized_copper_tile_slab_from_honeycomb" | "minecraft:daylight_detector" | "vegandelight:campfire_cooking/cooked_tofish_from_campfire_cooking" | "farmersdelight:cutting/salmon" | "create:cutting/jungle_log" | "immersiveengineering:metalpress/rod_uranium" | "pedestals:machines/upgrademodification/fan/fan_area_tier_one" | "mcwfurnitures:oak_drawer" | "create:crafting/kinetics/mechanical_pump" | "minecraft:hopper" | "create:cut_tuff_slab_recycling" | "create:milling/compat/botania/white_petal" | "minecraft:raw_gold" | "railways:sequenced_assembly/yellow_conductor_cap" | "minecraft:green_banner" | "exdeorum:compressed_sieve/dust/string/blaze_powder" | "farmersdelight:paper_from_tree_bark" | "refinedstorage:coloring_recipes/purple_controller" | "refinedstorage:coloring_recipes/orange_controller" | "farmersdelight:cutting/lily_of_the_valley" | "create:cut_dripstone_stairs" | "createaddition:liquid_burning/biodiesel" | "createaddition:mixing/electrum" | "peco:saddle" | "minecraft:cooked_cod" | "create:cutting/compat/botania/glimmering_stripped_dreamwood" | "create_netherless:warped_nyllium_by_manual_application" | "create:blasting/ingot_silver_compat_ic2" | "minecraft:cartography_table" | "exdeorum:compressed_deepslate" | "railways:crafting/palettes/dyeing_1x/red_slashed_locometal" | "minecraft:polished_diorite" | "exdeorum:compressed_sieve/dust/iron/grains_of_infinity" | "mcwfurnitures:stripped_crimson_drawer_counter" | "create:polished_cut_ochrum_slab" | "create:milling/sandstone/6x_to_6x_sand" | "mcwfurnitures:warped_modern_desk" | "mcwfurnitures:stripped_dark_oak_triple_drawer" | "easy_mob_farm:upgrade/enhancement/sheep_enhancement" | "immersiveengineering:alloysmelter/manyullyn" | "mob_grinding_utils:beheading/husk" | "exdeorum:willow_sieve" | "peco:cobweb" | "railways:crafting/palettes/dyeing_8x/light_gray_flat_slashed_locometal" | "exdeorum:sieve/moss_block/netherite/red_archwood_sapling" | "create:small_tuff_brick_slab_from_stone_types_tuff_stonecutting" | "exdeorum:stone_barrel" | "exdeorum:sieve/gravel/netherite/gold_nugget" | "exdeorum:compressed_sieve/moss_block/flint/mangrove_propagule" | "immersiveengineering:crafting/raw_hammercrushing_platinum" | "createcompression:block/minecraft/acacia_plank/compress/2x" | "exdeorum:sieve/moss_block/diamond/red_archwood_sapling" | "createcompression:block/minecraft/tuff/compress/6x" | "create:milling/compat/biomesoplenty/pink_hibiscus" | "refinedstorage:security_card" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/guarana_rich_soil" | "createcompression:block/minecraft/tuff/compress/5x" | "createcompression:block/minecraft/acacia_plank/compress/1x" | "mcwfurnitures:jungle_chair" | "createcompression:block/cc/experience/decompress/1x" | "minecraft:deepslate_tiles_from_polished_deepslate_stonecutting" | "mcwfurnitures:stripped_warped_striped_chair" | "railways:crafting/palettes/dyeing_8x/lime_brass_wrapped_locometal" | "create:cut_calcite_brick_slab_recycling" | "exdeorum:mechanical_sieve" | "create:layered_tuff_from_stone_types_tuff_stonecutting" | "minecraft:netherite_pickaxe_smithing" | "createcompression:block/minecraft/tuff/compress/4x" | "exdeorum:sieve/crushed_deepslate/string/lapis_lazuli" | "createcompression:block/minecraft/acacia_plank/compress/4x" | "create:milling/compat/byg/yellow_tulip" | "createcompression:block/cc/experience/decompress/2x" | "create:cut_veridium_brick_stairs_from_stone_types_veridium_stonecutting" | "create:milling/compat/regions_unexplored/tassel" | "exdeorum:compressed_sieve/dust/golden/blaze_powder" | "mekanism:crushing/createcompression/cobblestone/8x_to_8x_gravel" | "exdeorum:sieve/red_sand/iron/redstone" | "farmersdelight:honey_cookie" | "minecraft:golden_helmet" | "refinedstorage:1k_storage_block" | "minecraft:light_blue_dye_from_blue_orchid" | "exdeorum:sieve/gravel/diamond/nickel_ore_chunk" | "minecraft:mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting" | "mcwfurnitures:stripped_cherry_bookshelf_cupboard" | "peco:discs/disc_ring" | "createcompression:block/minecraft/tuff/compress/3x" | "railways:sequenced_assembly/track_hexcasting_edified" | "createcompression:block/minecraft/acacia_plank/compress/3x" | "exdeorum:compressed_sieve/crushed_deepslate/flint/basalt_pebble" | "railways:sequenced_assembly/track_byg_ether_wide" | "create:scoria_from_stone_types_scoria_stonecutting" | "farmersdelight:cutting/birch_log" | "more_immersive_wires:cc_modem" | "create:crushing/compat/silentgems/rose_quartz_ore" | "peacefulrecipes:tide_armor_trim_smithing_template" | "immersiveengineering:sawmill/treated_wood_vertical_stairs" | "exdeorum:sieve/sand/flint/random_pottery_sherd" | "create:small_scorchia_brick_stairs" | "engineeredcompatibility:sawmill/aether_redux/cloudcap_log" | "createsifter:andesite_mesh" | "create:cutting/compat/twilightforest/stripped_sorting_wood" | "createaddition:rolling/iron_plate" | "exdeorum:compressed_sieve/moss_block/iron/hellbark_sapling" | "create:cutting/compat/biomesoplenty/fir_wood" | "create:milling/compat/regions_unexplored/hyssop" | "railways:crafting/palettes/dyeing_8x/orange_copper_wrapped_locometal_boiler" | "farmersdelight:cutting/warped_stem" | "engineersdecor:independent/dark_shingle_roof_recipe_from_block" | "minecraft:cooked_porkchop_from_campfire_cooking" | "create_confectionery:ruby_chocolate_brick_slab_recipe_2" | "exdeorum:compressed_sieve/gravel/string/boron_ore_chunk" | "create:cutting/compat/byg/aspen_log" | "create:spruce_window_pane" | "exdeorum:sieve/red_sand/iron/cactus" | "create:item_application/andesite_casing_from_wood" | "create_mechanical_chicken:compacting/compacting_seed_oil" | "mowlib:filters/vanilla/filter_category_axolotls" | "nocubes_craftable_md:music_disc_strad" | "mobdropsrecipes_overworld:essence_into_spider_eye" | "exdeorum:compressed_sieve/moss_block/netherite/mahogany_sapling" | "create:cutting/compat/autumnity/maple_log" | "create:cutting/compat/regions_unexplored/brimwood_log_magma" | "exdeorum:compressed_sieve/soul_sand/iron/bone" | "railways:crafting/palettes/dyeing_8x/blue_iron_wrapped_locometal_boiler" | "create:cut_veridium_brick_wall" | "create:filling/applesyrup_roll" | "immersiveengineering:sawmill/jungle_door" | "mcwfurnitures:stripped_dark_oak_drawer_counter" | "mowlib:filters/vanilla/individual_mobs/foodmobs/filter_type_chicken" | "exdeorum:compressed_sieve/soul_sand/diamond/gunpowder" | "engineersdecor:independent/rebar_concrete_tile_slab_recipe_decompose" | "farmersdelight:jungle_cabinet" | "immersiveengineering:crafting/hammercrushing_tungsten" | "exdeorum:sieve/gravel/netherite/silver_ore_chunk" | "mowlib:filters/vanilla/individual_mobs/baby/filter_type_fox_baby" | "farmersdelight:iron_nugget_from_blasting_knife" | "railways:crafting/palettes/dyeing_1x/orange_flat_slashed_locometal" | "minecraft:wooden_sword" | "immersiveengineering:crafting/stairs_alu_scaffolding_standard" | "railways:sequenced_assembly/track_byg_cika_wide" | "mob_grinding_utils:beheading/dragon" | "exdeorum:sieve/gravel/iron/tin_ore_chunk" | "create:smelting/glass_pane_from_framed_glass_pane" | "refinedstorage:regulator_upgrade" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/amaranth_rich_soil" | "pedestals:machines/cobblegen/generate_brownmushroom" | "create:cutting/compat/regions_unexplored/stripped_redwood_log" | "create:cutting/compat/blue_skies/stripped_frostbright_wood" | "farmersdelight:blue_hanging_canvas_sign" | "engineeredcompatibility:sawmill/deep_aether/roseroot_stairs" | "create:cutting/compat/regions_unexplored/stripped_palm_wood" | "create:small_veridium_brick_slab_from_stone_types_veridium_stonecutting" | "railways:crafting/palettes/dyeing_1x/white_copper_wrapped_locometal" | "mowlib:filters/vanilla/individual_mobs/rideable/filter_type_llama_trader" | "railways:crafting/palettes/dyeing_1x/red_brass_wrapped_locometal_boiler" | "railways:sequenced_assembly/track_natures_spirit_palo_verde_narrow" | "immersiveengineering:metalpress/plate_cobalt" | "create:cut_limestone_brick_wall" | "exmachinis:item_buffer" | "minecraft:lightning_rod" | "minecraft:brown_stained_glass_pane_from_glass_pane" | "create:milling/compat/regions_unexplored/salmon_poppy_bush" | "minecraft:orange_concrete_powder" | "minecraft:shears" | "exdeorum:sieve/moss_block/string/mangrove_propagule" | "railways:crafting/palettes/dyeing_1x/cyan_locometal_smokebox" | "railways:crafting/palettes/dyeing_1x/green_iron_wrapped_locometal" | "minecraft:yellow_stained_glass_pane_from_glass_pane" | "exdeorum:barrel_compost/vine" | "immersiveengineering:crusher/raw_block_tin" | "more_immersive_wires:id_connector" | "immersiveengineering:crafting/slag_brick_to_slab" | "exdeorum:jungle_crucible" | "minecraft:stone_brick_slab_from_stone_bricks_stonecutting" | "create:crafting/appliances/filter_clear" | "immersiveengineering:smelting/nugget_steel_recycle_axe_from_blasting" | "create:milling/compat/biomesoplenty/pink_daffodil" | "create:milling/terracotta" | "create:cut_scorchia_stairs_from_stone_types_scorchia_stonecutting" | "farmersdelight:sweet_berry_cookie" | "create:crafting/kinetics/cuckoo_clock" | "mcwfurnitures:stripped_warped_glass_table" | "exdeorum:sieve/dirt/diamond/bamboo" | "extradisks:disk/shaped/16384k_fluid_storage_disk" | "exdeorum:compressed_sieve/crushed_deepslate/iron/gold_ore_chunk" | "immersiveengineering:stonecutting/concrete_brick" | "create:copper_tile_slab_from_copper_tiles_stonecutting" | "create:polished_cut_andesite_slab" | "createcompression:block/minecraft/netherrack/decompress/5x" | "peco:discs/music_disc_13" | "exdeorum:frostbright_barrel" | "farmersdelight:beetroot_crate" | "exdeorum:compressed_sieve/sand/diamond/prismarine_crystals" | "rebornstorage:multiblock_heat" | "immersiveengineering:crafting/hammercrushing_iron" | "peco:discs/music_disc_11" | "engineersdecor:independent/iron_hatch_recipe" | "immersiveengineering:sawmill/spruce_slab" | "engineeredcompatibility:arcfurnace/midnight/raw_ore_nagrilite" | "createcompression:block/minecraft/netherrack/decompress/4x" | "create:splashing/ic2/crushed_raw_silver" | "createcompression:block/minecraft/redstone/compress/1x" | "create_confectionery:full_black_chocolate_bar_recipe" | "extradisks:disk/shapeless/infinite_storage_disk" | "minecraft:gray_carpet" | "peacefulrecipes:totem_of_undying" | "minecraft:crimson_hanging_sign" | "create:polished_cut_deepslate_wall_from_stone_types_deepslate_stonecutting" | "createcompression:block/minecraft/netherrack/decompress/3x" | "engineeredcompatibility:sawmill/deep_aether/cruderoot_log" | "mcwfurnitures:cherry_drawer_counter" | "mowlib:filters/insertable_filters/clear_filtertag" | "createcompression:block/minecraft/redstone/compress/2x" | "create_netherless:blaze_burner_recipe_from_craft" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/coffeebean_rich_soil" | "minecraft:brewing_stand" | "railways:crafting/palettes/dyeing_8x/light_blue_flat_slashed_locometal" | "create:mechanical_crafting/potato_cannon" | "immersiveengineering:crusher/ore_silver" | "sophisticatedbackpacks:chipped/loom_table_upgrade" | "exdeorum:sieve/moss_block/flint/birch_sapling" | "farmersdelight:yellow_canvas_sign" | "engineeredcompatibility:cloche/pams_harvestcraft_2_crops/tomatillo" | "createcompression:block/minecraft/netherrack/decompress/2x" | "refinedstorage:16k_storage_disk" | "createcompression:block/minecraft/redstone/compress/3x" | "create:crafting/kinetics/gearboxfrom_conversion" | "immersiveengineering:crafting/conveyor_vertical" | "create:cutting/compat/windswept/chestnut_log" | "create:cutting/compat/biomesoplenty/umbran_wood" | "minecraft:diamond_block" | "easy_mob_farm:upgrade/enhancement/speed_enhancement" | "create:crushing/compat/byg/pervaded_netherrack" | "minecraft:deepslate_tile_stairs_from_deepslate_bricks_stonecutting" | "peacefulrecipes:music_disc_chirp" | "minecraft:diorite_slab" | "farmersdelight:lime_canvas_sign" | "minecraft:yellow_stained_glass" | "createcompression:block/minecraft/netherrack/decompress/1x" | "exdeorum:sieve/moss_block/diamond/cherry_sapling" | "createcompression:block/minecraft/redstone/compress/4x" | "exdeorum:compressed_sieve/moss_block/golden/spruce_sapling" | "exdeorum:compressed_sieve/dirt/diamond/flint" | "create:milling/compat/byg/bistort" | "immersiveengineering:crusher/raw_ore_zinc" | "railways:dying_existing_cap_lime" | "railways:crafting/palettes/dyeing_1x/green_locometal_boiler" | "create:milling/compat/byg/foxglove" | "minecraft:cooked_mutton" | "create:cut_andesite_wall" | "create:cut_asurine_bricks_from_stone_types_asurine_stonecutting" | "farmersdelight:wheat_dough_from_eggs" | "minecraft:bookshelf" | "engineeredcompatibility:sawmill/blue_skies/starlit_door" | "railways:sequenced_assembly/track_biomesoplenty_dead" | "railways:crafting/palettes/dyeing_1x/yellow_locometal_boiler" | "create:cutting/stripped_crimson_hyphae" | "exdeorum:sieve/crushed_deepslate/golden/lapis_lazuli" | "exdeorum:crucible_heat_source/wall_torch" | "farmersdelight:cutting/birch_sign" | "engineersdecor:independent/rebar_concrete_tile_recipe" | "railways:crafting/palettes/dyeing_1x/pink_slashed_locometal" | "createcompression:block/minecraft/redstone/compress/5x" | "exdeorum:sieve/gravel/flint/magnesium_ore_chunk" | "railways:mechanical_crafting/orange_brass_wrapped_locometal_boiler" | "createsweetsandtreets:mixing/donutcook" | "exdeorum:compressed_sieve/gravel/iron/stone_pebble" | "refinedstorage:coloring_recipes/cyan_wireless_transmitter" | "immersiveengineering:smelting/ingot_uranium_from_dust_from_blasting" | "exdeorum:sieve/sand/iron/charged_certus_quartz_crystal" | "engineersdecor:independent/factory_placer_recipe" | "immersiveengineering:crusher/raw_ore_tungsten" | "create:layered_scoria_from_stone_types_scoria_stonecutting" | "mcwfurnitures:stripped_jungle_covered_desk" | "createcompression:block/minecraft/redstone/compress/6x" | "mcwfurnitures:stripped_oak_kitchen_cabinet" | "createcompression:block/minecraft/dark_oak_log/decompress/6x" | "mcwfurnitures:stripped_spruce_lower_bookshelf_drawer" | "railways:dying_existing_cap_blue" | "exdeorum:compressed_sieve/gravel/string/lapis_lazuli" | "immersiveengineering:fermenter/sugar_cane" | "immersiveengineering:crafting/item_batcher" | "immersiveengineering:arcfurnace/dust_tin" | "exdeorum:sieve/moss_block/string/hellbark_sapling" | "createcompression:block/minecraft/redstone/compress/7x" | "minecraft:glass_bottle" | "minecraft:iron_ingot_from_smelting_raw_iron" | "createcompression:block/minecraft/dark_oak_log/decompress/5x" | "create:milling/compat/byg/lolipop_flower" | "exdeorum:sieve/gravel/string/zinc_ore_chunk" | "comforts:sleeping_bag_to_purple" | "createcompression:block/minecraft/crimson_plank/decompress/1x" | "create:crafting/materials/copper_ingot" | "easy_mob_farm:mob_farm/desert_farm/tier0_desert_farm" | "minecraft:stripped_warped_hyphae" | "create_recipes:coalfromcharcoal" | "create:cut_calcite_brick_stairs" | "create:smelting/glass_pane_from_tiled_glass_pane" | "refinedstorage:wireless_grid" | "railways:sequenced_ass