import { ServerEvents } from 'crafttweaker';

ServerEvents.recipes(event => {
    // Add uranium block as a heat source
    exdeorum.setCrucibleHeatValue('immersiveengineering:storage_uranium', 20);
    event.recipes.create.mixing('create_better_motors:reggarfonite_gem', ['minecraft:diamond', 'minecraft:iron_ingot']).heated().id('swagnilla_ice:flat_world_reggarfonite_gem');
    event.recipes.create.filling("immersiveengineering:treated_wood_horizontal", [Fluid.of('immersiveengineering:creosote', 125), '#minecraft:planks']).id('swagnilla_ice:flat_world_treated_wood');
    // Craft one oak sapling into one menril one.
    event.shapeless('integrateddynamics:menril_sapling', ['minecraft:oak_sapling']).id('swagnilla_ice:flat_world_menril_sapling');
    event.shapeless('3x minecraft:honeycomb', [
        '4x minecraft:sugar',
        'minecraft:shears',
        '2x #minecraft:flowers',
        'minecraft:stick'
    ]).id('swagnilla_ice:flat_world_honeycomb');
});

// Add cocoa bean trade for level 2 farmers
MoreJSEvents.villagerTrades((event) => {
    const trade = event.addTrade('minecraft:farmer', 2, [ // Profession, level, input items
        { item: 'minecraft:emerald', count: 8 } // Emerald as input
    ], { // Output item
        item: 'minecraft:cocoa_beans', count: 1
    });

    // Optional: Set experience for the trade (default is 0)
    trade.villagerExperience(10);
});
